require(GlobalDependencys:GetDependency("StandardBase"):GetPackageName())

--GAME VARS
fDefaultAspectRatio = 1.777777791

--ControlVars
bFixEnabled = true
bFOVFixGame = true
bHUDConstraint = true
bMarkerFix = true
bHealthBarFix = true
bCutsceneAspectFix = true
bShadowsFix = true
bWallClipFix = true

fDefaultClampMinValue = 40
fDefaultClampMaxValue = 90

RadiansToDegrees = 57.2958
DegreesToRadians = 0.0174533
FOVScaleGame = 1.0

FOVClampMin = fDefaultClampMinValue * DegreesToRadians
FOVClampMax = fDefaultClampMaxValue * DegreesToRadians

--PROCESS VARS
Process_FriendlyName = Module:GetFriendlyName()
Process_WindowName = "LEGO Star Wars - The Skywalker Saga"
Process_ClassName = "TTalesWindow"
Process_EXEName = "paddington.win64-gdk.master.exe;LEGOSTARWARSSKYWALKERSAGA_DX11.exe"

--INJECTION BEHAVIOUR
InjectDelay = 2000
WriteInterval = 500
SearchInterval = 500
SuspendThread = false

--Name                         Manual/Auto/Hybrid  		Steam/Origin/Any                IncludeFile:Configure;Enable;Periodic;Disable;
SupportedVersions = { 		
{"Automatically Detect",       "Hybrid",  		  	"Any",	                         "Configure_SignatureScan;Enable_Inject;Periodic;Disable_Inject;"},
}

function Init_Controls()

    HUDScalingOptions = {"Use DisplayDetection","Constrain HUD to 16:9","Constrain HUD to 16:10","Constrain HUD to 21:9"}
    DefaultControls.AddHeader("Header_HUDScalingOptions","HUD Scaling Options",245,240,210,17)
    DefaultControls.AddComboBox("HUDScalingCombo","HUDScalingCombo_Changed",HUDScalingOptions,255,267,190,300)

	local FOVSlider_X, FOVSlider_Y = 15, 70

	DefaultControls.AddHeader("Header_FOV_1","In-Game FOV - Fine adjustment",FOVSlider_X,FOVSlider_Y,210,17)
	DefaultControls.AddFixedFOVSlider("FOVSliderGame","FOVSliderGame_Changed",FOVSlider_X+40,FOVSlider_Y+30,125,35,0,85,0,1)
	FOVSliderGame:SetTickFrequency(5)
	FOVSliderGame:SetLabel1Text("0%")
	FOVSliderGame:SetLabel2Text("85%")
	
	local FOVSliderMax_X, FOVSliderMax_Y = 15, 170

	DefaultControls.AddHeader("Header_FOV_2","FOV Clamping (Maximum)",FOVSliderMax_X,FOVSliderMax_Y,210,17)
	DefaultControls.AddFixedFOVSlider("FOVSliderClampMax","FOVSliderClampMax_Changed",FOVSliderMax_X+40,FOVSliderMax_Y+30,125,35,fDefaultClampMinValue,fDefaultClampMaxValue,75.0,1)
	FOVSliderClampMax:SetTickFrequency(4)
	FOVSliderClampMax:SetLabel1Text(fDefaultClampMinValue)
	FOVSliderClampMax:SetLabel2Text(fDefaultClampMaxValue)
	
	local FOVSliderMin_X, FOVSliderMin_Y = 15, 270

	DefaultControls.AddHeader("Header_FOV_3","FOV Clamping (Minimum)",FOVSliderMin_X,FOVSliderMin_Y,210,17)
	DefaultControls.AddFixedFOVSlider("FOVSliderClampMin","FOVSliderClampMin_Changed",FOVSliderMin_X+40,FOVSliderMin_Y+30,125,35,fDefaultClampMinValue,fDefaultClampMaxValue,45.0,1)
	FOVSliderClampMin:SetTickFrequency(4)
	FOVSliderClampMin:SetLabel1Text(fDefaultClampMinValue)
	FOVSliderClampMin:SetLabel2Text(fDefaultClampMaxValue)

	DefaultControls.AddHeader("Header_FixesEnableDisable","Individual Fixes",245,70,210,17)
	DefaultControls.AddFixToggle("CKFOVFixGame_Enable","FOV Fix","CKFOVFixGame_Changed",255,101,180,14)	
	DefaultControls.AddFixToggle("CKHUDConstraint_Enable","Constrain HUD","CKHUDConstraint_Changed",255,120,180,14)	
	DefaultControls.AddFixToggle("CKMarkerFix_Enable","Marker Fix","CKMarkerFix_Changed",255,139,180,14)
	DefaultControls.AddFixToggle("CKHealthBarFix_Enable","Health Bar Fix","CKHealthBarFix_Changed",255,158,180,14)	
	DefaultControls.AddFixToggle("CKCutsceneAspectFix_Enable","Cutscene Aspect Fix","CKCutsceneAspectFix_Changed",255,177,180,14)	
	DefaultControls.AddFixToggle("CKShadowsFix_Enable","Shadows Fix","CKShadowsFix_Changed",255,196,180,14)	
	DefaultControls.AddFixToggle("CKWallClipFix_Enable","WallClip Fix","CKWallClipFix_Changed",255,215,180,14)	
	
end

function Configure_SignatureScan() 

	local tAddress = HackTool:AddAddress("FOV1")
	if HackTool:SignatureScan("7A ?? 75 ?? F3 0F 10 ?? ?? ?? ?? ?? F3 0F 10 ?? ?? ?? 48 ?? ?? ?? ?? ?? ?? 0F",tAddress,PAGE_EXECUTE_READ,0xC,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	

	--Try Gamepass Version
	FOVTransitionCount = HackTool:SignatureScanMulti("E8 ?? ?? ?? ?? 48 ?? ?? 84 ?? 48 0F ?? ?? ?? 8B ?? ?? 8B ?? E8 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 41","FOV2_",PAGE_EXECUTE_READ,0x1F,Process_EXEName)
	if FOVTransitionCount == 0 then
		--Try Steam Version
		FOVTransitionCount = HackTool:SignatureScanMulti("E8 ?? ?? ?? ?? 49 ?? ?? 84 ?? 48 0F ?? ?? ?? 8B ?? ?? 8B ?? E8 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 89","FOV2_",PAGE_EXECUTE_READ,0x1F,Process_EXEName)
	end
	
	
	if FOVTransitionCount ~= 3 then	
		return ErrorOccurred("Could not find FOVTransition1 injection point, " .. Process_FriendlyName .. " may have updated to a version that is no longer supported.\r\n\r\n" .. 
							 "Try selecting a different version and re-enable the fix."	)
	else
		for i = 1,FOVTransitionCount,1 do
			local FOV2 = HackTool:GetAddress( string.format("FOV2_%d",i) )
			if FOV2 ~= nil then if i == 3 then print( string.format("%s (desired)",FOV2:GetInfo(TYPE_ADDRESS)) ) else  print( FOV2:GetInfo(TYPE_ADDRESS) ) end end
		end		
	end	

	FOVTransitionCount = HackTool:SignatureScanMulti("48 ?? ?? 74 ?? E8 ?? ?? ?? ?? ?? 8B ?? ?? ?? 8B ?? ?? 8B ?? E8 ?? ?? ?? ?? 41 8B ?? ?? ?? ?? ?? 89","FOV3_",PAGE_EXECUTE_READ,0x20,Process_EXEName)
	if FOVTransitionCount ~= 3 then	
		return ErrorOccurred("Could not find FOVTransition2 injection point, " .. Process_FriendlyName .. " may have updated to a version that is no longer supported.\r\n\r\n" .. 
							 "Try selecting a different version and re-enable the fix."	)
	else
		for i = 1,FOVTransitionCount,1 do
			local FOV3 = HackTool:GetAddress( string.format("FOV3_%d",i) )
			if FOV3 ~= nil then if i == 3 then print( string.format("%s (desired)",FOV3:GetInfo(TYPE_ADDRESS)) ) else  print( FOV3:GetInfo(TYPE_ADDRESS) ) end end
		end		
	end	
	
	local tAddress = HackTool:AddAddress("FOV4")
	if HackTool:SignatureScan("CC F3 0F 10 ?? ?? ?? ?? ?? F3 0F ?? ?? F3 41 0F ?? ?? ?? ?? ?? ?? F3 0F ?? ?? ?? ?? ?? ?? F3 0F ?? ?? F3",tAddress,PAGE_EXECUTE_READ,0x22,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	

	local tAddress = HackTool:AddAddress("FOV5")
	if HackTool:SignatureScan("89 ?? E9 ?? ?? ?? ?? CC 48 89 ?? ?? ?? ?? 48 83 ?? ?? ?? 8B ?? ?? 8B ?? E8 ?? ?? ?? ?? 8B",tAddress,PAGE_EXECUTE_READ,0x23,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	


	local tAddress = HackTool:AddAddress("HUDConstraint")
	if HackTool:SignatureScan("48 ?? ?? C1 ?? ?? F3 0F ?? ?? ?? ?? ?? ?? A8 ?? 74 ?? F3 0F ?? ?? ?? ?? ?? ?? F3",tAddress,PAGE_EXECUTE_READ,0x6,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	

	local tAddress = HackTool:AddAddress("MarkerFix")
	if HackTool:SignatureScan("F3 0F ?? ?? ?? ?? F3 0F ?? ?? ?? ?? 44 0F ?? ?? ?? ?? 0F ?? ?? ?? ?? 76",tAddress,PAGE_EXECUTE_READ,0xC,Process_EXEName) == 0 then	
		if HackTool:SignatureScan("0F 11 ?? ?? ?? 0F 11 ?? ?? ?? 44 0F ?? ?? ?? ?? 0F 29 ?? ?? ?? 76",tAddress,PAGE_EXECUTE_READ,0xA,Process_EXEName) == 0 then --Steam
			return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
		else
			print( tAddress:GetInfo(TYPE_ADDRESS) )	
		end		
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	

	local tAddress = HackTool:AddAddress("HealthBarFix")
	if HackTool:SignatureScan("48 ?? ?? EB ?? 49 ?? ?? F3 0F ?? ?? ?? F3 0F 59 ?? ?? ?? ?? ?? 44 0F ?? ?? ?? ?? F3",tAddress,PAGE_EXECUTE_READ,0xD,Process_EXEName) == 0 then	
		if HackTool:SignatureScan("48 ?? ?? 0F 10 ?? ?? 0F C6 ?? ?? F3 0F 59 ?? ?? ?? ?? ?? 0F 28 ?? ?? ?? F3 0F ?? ?? 49",tAddress,PAGE_EXECUTE_READ,0xB,Process_EXEName) == 0 then	--Steam	
			return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
		else
			print( tAddress:GetInfo(TYPE_ADDRESS) )		
		end	
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	

	local tAddress = HackTool:AddAddress("CutsceneFix")
	if HackTool:SignatureScan("EB ?? F3 44 0F ?? ?? ?? ?? ?? ?? 48 ?? ?? ?? 41 ?? ?? ?? F3 0F ?? ?? ?? ?? ?? ?? 41",tAddress,PAGE_EXECUTE_READ,0xF,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	

	local tAddress = HackTool:AddAddress("ShadowsFix")
	if HackTool:SignatureScan("48 89 ?? ?? 0F 1F ?? ?? ?? F3 0F 10 ?? ?? ?? ?? ?? 49 ?? ?? ?? ?? ?? ?? F3",tAddress,PAGE_EXECUTE_READ,0x11,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	
	
	local tAddress = HackTool:AddAddress("CutsceneFix2")
	if HackTool:SignatureScan("74 ?? F3 0F ?? ?? 48 ?? ?? E8 ?? ?? ?? ?? F3 0F 10 ?? ?? ?? ?? ?? F3 0F 10 ?? ?? ?? ?? ?? F3 0F ?? ?? F3 0F ?? ?? E8",tAddress,PAGE_EXECUTE_READ,0x1E,Process_EXEName) == 0 then	
		return ErrorOccurred(string.format(SigScanError,tAddress:GetName()))
	else
		print( tAddress:GetInfo(TYPE_ADDRESS) )		
	end	
	
	--Try Gamepass Version
	WallClipFixCount = HackTool:SignatureScanMulti("48 0F ?? ?? ?? 8B ?? ?? 8B ?? E8 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 41 ?? ?? ?? ?? ?? ?? 8B","WallClipFix_",PAGE_EXECUTE_READ,0x15,Process_EXEName)
	if WallClipFixCount == 0 then
		--Try Steam Version
		WallClipFixCount = HackTool:SignatureScanMulti("48 0F ?? ?? ?? 8B ?? ?? 8B ?? E8 ?? ?? ?? ?? 8B ?? ?? ?? ?? ?? 89 ?? ?? ?? ?? ?? 8B","WallClipFix_",PAGE_EXECUTE_READ,0x15,Process_EXEName)
	end
	
	
	if WallClipFixCount ~= 2 then	
		return ErrorOccurred("Could not find WallClipFix injection point, " .. Process_FriendlyName .. " may have updated to a version that is no longer supported.\r\n\r\n" .. 
							 "Try selecting a different version and re-enable the fix."	)
	else
		for i = 1,WallClipFixCount,1 do
			local WallClipFix = HackTool:GetAddress( string.format("WallClipFix_%d",i) )
			if WallClipFix ~= nil then if i == 1 then print( string.format("%s (desired)",WallClipFix:GetInfo(TYPE_ADDRESS)) ) else  print( WallClipFix:GetInfo(TYPE_ADDRESS) ) end end
		end		
	end		

	return true

end

function rshift(x, by)
  return math.floor(x / 2 ^ by)
end

function Enable_Inject() 

	local NearTo = 0
	local tAddress = HackTool:GetAddress("HUDConstraint")

	if HackTool:GetArchitecture() == 0 then --Workaround for GamePass
		NearTo = HackTool:GetBaseAddress() + tAddress:GetAddress()
	end
	
	local Variables = HackTool:AllocateMemory("Variables",0)
	Variables:PushFloat("FOVGame_In1")
	Variables:PushFloat("FOVGame_In2")
	Variables:PushFloat("FOVGame_In3")
	Variables:PushFloat("FOVGame_In4")
	Variables:PushFloat("FOVGame_In5")
	Variables:PushFloat("FOVGame_Out1")
	Variables:PushFloat("FOVGame_Out2")
	Variables:PushFloat("FOVGame_Out3")
	Variables:PushFloat("FOVGame_Out4")
	Variables:PushFloat("FOVGame_Out5")
	Variables:PushFloat("FOVGame_Max")	
	Variables:PushFloat("FOVGame_Min")	
	Variables:PushFloat("FOVGame_Scale")	
	Variables:PushFloat("HUDScaleWidth")
	Variables:PushFloat("ShadowValue")
	Variables:PushFloat("FSAspect")
	Variables:PushFloat("CS2Aspect")
	Variables:Allocate(NearTo)

	ResolutionChanged()
	
	local asm = [[	
	
		(codecave:jmp)FOV1,FOV1_cc:
			movss [(allocation)Variables->FOVGame_In1], $$2					$ctx=3
			mulss $$2, [(allocation)Variables->FOVGame_Scale]				$ctx=3
			minss $$2, [(allocation)Variables->FOVGame_Max]					$ctx=3
			maxss $$2, [(allocation)Variables->FOVGame_Min]					$ctx=3
			movss [(allocation)Variables->FOVGame_Out1], $$2					$ctx=3
			%originalcode%
			jmp %returnaddress%		
			%end%		

		(codecave:jmp)FOV2_3,FOV2_cc:
			%originalcode%
			movss xmm0, [$$1]												$ctx=1
			movss [(allocation)Variables->FOVGame_In2], xmm0
			mulss xmm0, [(allocation)Variables->FOVGame_Scale]
			minss xmm0, [(allocation)Variables->FOVGame_Max]
			maxss xmm0, [(allocation)Variables->FOVGame_Min]
			movss [(allocation)Variables->FOVGame_Out2],xmm0
			movss [$$1], xmm0												$ctx=1
			jmp %returnaddress%		
			%end%	
			
		(codecave:jmp)FOV3_3,FOV3_cc:
			%originalcode%
			movss xmm6, [$$1]												$ctx=1
			movss [(allocation)Variables->FOVGame_In3], xmm6
			mulss xmm6, [(allocation)Variables->FOVGame_Scale]
			minss xmm6, [(allocation)Variables->FOVGame_Max]
			maxss xmm6, [(allocation)Variables->FOVGame_Min]
			movss [(allocation)Variables->FOVGame_Out3], xmm6
			movss [$$1], xmm6												$ctx=1		
			jmp %returnaddress%		
			%end%	
			
		(codecave:jmp)FOV4,FOV4_cc:
			movss [(allocation)Variables->FOVGame_In4], $$2					$ctx=1
			mulss $$2, [(allocation)Variables->FOVGame_Scale]				$ctx=1
			minss $$2, [(allocation)Variables->FOVGame_Max]					$ctx=1
			maxss $$2, [(allocation)Variables->FOVGame_Min]					$ctx=1
			movss [(allocation)Variables->FOVGame_Out4], $$2					$ctx=1
			%originalcode%
			jmp %returnaddress%		
			%end%	
			
		(codecave:jmp)FOV5,FOV5_cc:
			%originalcode%
			movss xmm6, [$$1]												$ctx=1
			movss [(allocation)Variables->FOVGame_In5], xmm6
			mulss xmm6, [(allocation)Variables->FOVGame_Scale]
			minss xmm6, [(allocation)Variables->FOVGame_Max]
			maxss xmm6, [(allocation)Variables->FOVGame_Min]
			movss [(allocation)Variables->FOVGame_Out5],xmm6
			movss [$$1], xmm6												$ctx=1
			jmp %returnaddress%		
			%end%	
	
		(codecave:jmp)HUDConstraint,HUDConstraint_cc:
			mulss $$2, [(allocation)Variables->HUDScaleWidth]
			%originalcode%
			jmp %returnaddress%		
			%end%

		(codecave:jmp)MarkerFix,MarkerFix_cc:
			$$0 [$$1], $$2
			xorps $$2, $$2													$ctx=1
			movss $$2, [$$1]												$ctx=1
			divss $$2, [(allocation)Variables->HUDScaleWidth]				$ctx=1
			movss [$$1], $$2												$ctx=1			
			jmp %returnaddress%		
			%end%

		(codecave:jmp)HealthBarFix,HealthBarFix_cc:
			divss $$1, [(allocation)Variables->HUDScaleWidth]				$ctx=1
			%originalcode%
			jmp %returnaddress%		
			%end%
			
		(codecave:jmp)CutsceneFix,CutsceneFix_cc:
			movss $$1, [(allocation)Variables->FSAspect]					$ctx=2			
			movss [$$2], $$1												$ctx=2
			%originalcode%
			jmp %returnaddress%		
			%end%

		(codecave:jmp)CutsceneFix2,CutsceneFix2_cc:
			movss $$1, [(allocation)Variables->CS2Aspect]					$ctx=2
			%originalcode%
			jmp %returnaddress%		
			%end%			

		(codecave:jmp)ShadowsFix,ShadowsFix_cc:
			%originalcode%
			movss $$2, [(allocation)Variables->ShadowValue]	
			jmp %returnaddress%		
			%end%			

		(codecave:jmp)WallClipFix_1,WallClipFix_cc:
			mov $$2, (float)0.025
			%originalcode%
			jmp %returnaddress%		
			%end%	
			
	]] 

	if HackTool:CompileAssembly(asm,"FOVFix",NearTo) == nil then
		return ErrorOccurred("Assembly compilation failed...")
	else		
		Toggle_CodeCave("HUDConstraint_cc",bHUDConstraint)
		Toggle_CodeCave("MarkerFix_cc",bMarkerFix)
		Toggle_CodeCave("HealthBarFix_cc",bHealthBarFix)
		Toggle_CodeCave("CutsceneFix_cc",bCutsceneAspectFix)
		Toggle_CodeCave("CutsceneFix2_cc",bCutsceneAspectFix)
		Toggle_CodeCave("ShadowsFix_cc",bShadowsFix)
		Toggle_CodeCave("WallClipFix_cc",bWallClipFix)
		
		ToggleFOVCodeCave(bFOVFixGame)
	end	
		
end

function ToggleFOVCodeCave(Enabled)

	if Enabled == true then
		WriteFOVScaling()
		WriteFOVClampMin()
		WriteFOVClampMax()
	end

	Toggle_CodeCave("FOV1_cc",Enabled)
	Toggle_CodeCave("FOV2_cc",Enabled)
	Toggle_CodeCave("FOV3_cc",Enabled)
	Toggle_CodeCave("FOV4_cc",Enabled)
	Toggle_CodeCave("FOV5_cc",Enabled)
end


function Periodic()

	local Variables = HackTool:GetAllocation("Variables")
	if Variables then 
	
		PluginViewport:AppendStatusMessage( "\r\n" )
		
		if bFOVFixGame then 
			if bFOVFixGame and Variables["FOVGame_In1"] and Variables["FOVGame_Out1"] then
			
				local FOV1_In  = Variables["FOVGame_In1"]:ReadFloat()  * RadiansToDegrees
				local FOV1_Out = Variables["FOVGame_Out1"]:ReadFloat() * RadiansToDegrees
				local FOV2_In  = Variables["FOVGame_In2"]:ReadFloat()  * RadiansToDegrees
				local FOV2_Out = Variables["FOVGame_Out2"]:ReadFloat() * RadiansToDegrees
				local FOV3_In  = Variables["FOVGame_In3"]:ReadFloat()  * RadiansToDegrees
				local FOV3_Out = Variables["FOVGame_Out3"]:ReadFloat() * RadiansToDegrees
				local FOV4_In  = Variables["FOVGame_In4"]:ReadFloat()  * RadiansToDegrees
				local FOV4_Out = Variables["FOVGame_Out4"]:ReadFloat() * RadiansToDegrees
				local FOV5_In  = Variables["FOVGame_In5"]:ReadFloat()  * RadiansToDegrees
				local FOV5_Out = Variables["FOVGame_Out5"]:ReadFloat() * RadiansToDegrees		
			
				PluginViewport:AppendStatusMessage( string.format("     (Game FOV) In 1=%.2f 2=%.2f 3=%.2f 4=%.2f 5=%.2f, Out 1=%.2f 2=%.2f 3=%.2f 4=%.2f 5=%.2f", FOV1_In,FOV2_In,FOV3_In,FOV4_In,FOV5_In,FOV1_Out,FOV2_Out,FOV3_Out,FOV4_Out,FOV5_Out) )
			end
		end	

	end		
	
end

function Disable_Inject()
	
	CleanUp()
	
end

function ResolutionChanged() 

	SyncDisplayDetection()
	
	local tHeight = DisplayInfo:GetHeight()
	local tWidth = DisplayInfo:GetWidth()
	
	local AspectDevisional = tHeight / tWidth
	
	local Variables = HackTool:GetAllocation("Variables")
	if Variables then
		if Variables["FSAspect"] then
			Variables["FSAspect"]:WriteFloat(AspectDevisional)
		end

		if Variables["CS2Aspect"] then		
			local OriginalAspect = 0.56250
			Variables["CS2Aspect"]:WriteFloat(OriginalAspect)
		end
		
		if Variables["ShadowValue"] then		
			local tShadowValue = 0.250
			Variables["ShadowValue"]:WriteFloat(tShadowValue)
		end		
	end
	
	WriteFOVClampMin()
	WriteFOVClampMax()
	CalculateHUDScaling()

end

function CKFOVFixGame_Changed(Sender)

	bFOVFixGame = Toggle_CheckFix(Sender)
	ToggleFOVCodeCave(bFOVFixGame)
	ForceUpdate()
	
end

function CKHUDConstraint_Changed(Sender)

	bHUDConstraint = Toggle_CheckFix(Sender)
	Toggle_CodeCave("HUDConstraint_cc",bHUDConstraint) 
	ForceUpdate()
	
end

function CKMarkerFix_Changed(Sender)

	bMarkerFix = Toggle_CheckFix(Sender)
	Toggle_CodeCave("MarkerFix_cc",bMarkerFix) 
	ForceUpdate()
	
end

function CKHealthBarFix_Changed(Sender)

	bHealthBarFix = Toggle_CheckFix(Sender)
	Toggle_CodeCave("HealthBarFix_cc",bHealthBarFix) 
	ForceUpdate()
	
end

function CKCutsceneAspectFix_Changed(Sender)

	bCutsceneAspectFix = Toggle_CheckFix(Sender)
	Toggle_CodeCave("CutsceneFix_cc",bCutsceneAspectFix)
	Toggle_CodeCave("CutsceneFix2_cc",bCutsceneAspectFix)	
	ForceUpdate()
	
end

function CKShadowsFix_Changed(Sender)

	bShadowsFix = Toggle_CheckFix(Sender)
	Toggle_CodeCave("ShadowsFix_cc",bShadowsFix) 
	ForceUpdate()
	
end

function CKWallClipFix_Changed(Sender)

	bWallClipFix = Toggle_CheckFix(Sender)
	Toggle_CodeCave("WallClipFix_cc",bWallClipFix) 
	ForceUpdate()
	
end

function HK_IncreaseFOV()	
	FOVSliderGame:OffsetPosition(1)
end

function HK_DecreaseFOV()	
	FOVSliderGame:OffsetPosition(-1)
end

function FOVSliderGame_Changed(Sender)

	local AdditionalFOV = Sender:GetPosition()
	lblFOVSliderGame.Caption:SetCaption( string.format("Value: +%.0f%%",AdditionalFOV) )
	
	FOVScaleGame = 1.0 + (AdditionalFOV/100)
	
	WriteFOVScaling()	
	ForceUpdate()

end

function FOVSliderClampMax_Changed(Sender)

	local ClampValue = Sender:GetPosition()
	lblFOVSliderClampMax.Caption:SetCaption( string.format("Value: %.0f",ClampValue) )
	
	FOVClampMax = ClampValue * DegreesToRadians
	
	WriteFOVClampMax()	
	ForceUpdate()

end

function FOVSliderClampMin_Changed(Sender)

	local ClampValue = Sender:GetPosition()
	lblFOVSliderClampMin.Caption:SetCaption( string.format("Value: %.0f",ClampValue) )
	
	FOVClampMin = ClampValue * DegreesToRadians
	
	WriteFOVClampMin()	
	ForceUpdate()

end

function WriteFOVScaling() 

	local Variables = HackTool:GetAllocation("Variables")
	if Variables and Variables["FOVGame_Scale"] then
		Variables["FOVGame_Scale"]:WriteFloat(FOVScaleGame)
	end
	
end

function WriteFOVClampMax() 

	local Variables = HackTool:GetAllocation("Variables")
	if Variables and Variables["FOVGame_Max"] then
		Variables["FOVGame_Max"]:WriteFloat(FOVClampMax)
	end

end

function WriteFOVClampMin() 

	local Variables = HackTool:GetAllocation("Variables")
	if Variables and Variables["FOVGame_Min"] then
		Variables["FOVGame_Min"]:WriteFloat(FOVClampMin)
	end
	
end

function CalculateHUDScaling() 	

	local Variables = HackTool:GetAllocation("Variables")
	if Variables and Variables["HUDScaleWidth"] then
	
		local cbIndex = HUDScalingCombo:GetSelectedIndex()
		
		local tHeight = DisplayInfo:GetHeight()
		local tWidth = DisplayInfo:GetWidth()
		
		local tHUDWidth = 0
		
		if cbIndex == 0 then --Use DisplayDetection
			tHUDWidth = DisplayInfo:GetfOffsetWidth(0,0)	
		elseif cbIndex == 1 then  -- Use 16:9	
			tHUDWidth = math.floor(tHeight * 1.7777778) 	
		elseif cbIndex == 2 then --use 16:10	
			tHUDWidth = math.floor(tHeight * 1.6000001)  		
		elseif cbIndex == 3 then  -- Use 21:9	
			tHUDWidth = math.floor(tHeight * 2.3333334) 
		end		

		Variables["HUDScaleWidth"]:WriteFloat(tHUDWidth / tWidth)			
	
	end


end

function HUDScalingCombo_Changed(Sender)

	CalculateHUDScaling()
	ForceUpdate()
	
end

function Init()	
	Init_BaseControls()
	Init_Controls()
end

function DeInit()
	DisableFix()
end
