#include "LightScenarios\Inc\TrackDebugLightingLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float AnimLength_floatVal < string UIName = "AnimLength_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.4130435 ;
float AnimOffset_floatVal < string UIName = "AnimOffset_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float ExposureEV0_floatVal < string UIName = "ExposureEV0_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.001375 ;
float Float2_floatVal < string UIName = "Float2_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
bool InstanceAnimOffsetFullColor < string UIName = "InstanceAnimOffsetFullColor"; string UIWidget = "Checkbox"; > = 0;
int InstanceAnimOffsetVariationIndex < string UIName = "InstanceAnimOffsetVariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float InternalReflectionMax_floatVal < string UIName = "InternalReflectionMax_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.3260869 ;
float InternalReflectionMin_floatVal < string UIName = "InternalReflectionMin_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.7934783 ;
float InternalReflectionStrength_floatVal < string UIName = "InternalReflectionStrength_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.3 ;
int LegoColorSeasonIndex < string UIName = "LegoColorSeasonIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 LightPosOffsetVector4 < string UIName = "LightPosOffsetVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.25, 1.978261, 0.08695669, -0.8478261 );
float LightSizeMax_floatVal < string UIName = "LightSizeMax_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.8804348 ;
float LightSizeMin_floatVal < string UIName = "LightSizeMin_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.8260869 ;
float LightSwitchOnEnd_floatVal < string UIName = "LightSwitchOnEnd_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LightSwitchOnStart_floatVal < string UIName = "LightSwitchOnStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float NormalMapSpecPower < string UIName = "NormalMapSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalMapTiling < string UIName = "NormalMapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float RefractionMax_floatVal < string UIName = "RefractionMax_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.326087 ;
float RefractionMin_floatVal < string UIName = "RefractionMin_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = -0.5652174 ;
float4 Roughness_AO_SpecScale_ModulateTiling < string UIName = "Roughness_AO_SpecScale_ModulateTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
bool Step0Bool < string UIName = "Step0Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step0HardStepBool < string UIName = "Step0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool Step2Bool < string UIName = "Step2Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step2HardStepBool < string UIName = "Step2HardStepBool"; string UIWidget = "Checkbox"; > = 1;
bool StepBool < string UIName = "StepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepHardStepBool < string UIName = "StepHardStepBool"; string UIWidget = "Checkbox"; > = 0;
float StudEmissive_floatVal < string UIName = "StudEmissive_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.98 ;
float4 ThicknessTiling < string UIName = "ThicknessTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float TimeScaleTimeScale < string UIName = "TimeScaleTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.05 ;
int UV3UVSet < string UIName = "UV3UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
int UV4UVSet < string UIName = "UV4UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_AnimatedLight < string UIName = "VariantConstant_AnimatedLight"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Light < string UIName = "VariantConstant_Light"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Refraction < string UIName = "VariantConstant_Refraction"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_UV34Offset < string UIName = "VariantConstant_UV34Offset"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define LightPosOffsetVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 LightPosOffsetVector4 : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define RefractionMin_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].x)
	#else
	float RefractionMin_floatVal : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define RefractionMax_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].y)
	#else
	float RefractionMax_floatVal : packoffset(c1.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSizeMin_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].z)
	#else
	float LightSizeMin_floatVal : packoffset(c1.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSizeMax_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].w)
	#else
	float LightSizeMax_floatVal : packoffset(c1.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define InternalReflectionMin_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].x)
	#else
	float InternalReflectionMin_floatVal : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define InternalReflectionMax_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].y)
	#else
	float InternalReflectionMax_floatVal : packoffset(c2.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define InternalReflectionStrength_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].z)
	#else
	float InternalReflectionStrength_floatVal : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AnimLength_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].w)
	#else
	float AnimLength_floatVal : packoffset(c2.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TimeScaleTimeScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].x)
	#else
	float TimeScaleTimeScale : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AnimOffset_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].y)
	#else
	float AnimOffset_floatVal : packoffset(c3.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define StudEmissive_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].z)
	#else
	float StudEmissive_floatVal : packoffset(c3.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ExposureEV0_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].w)
	#else
	float ExposureEV0_floatVal : packoffset(c3.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float2_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float Float2_floatVal : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].y)
	#else
	float LightSwitchOnStart_floatVal : packoffset(c4.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnEnd_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].z)
	#else
	float LightSwitchOnEnd_floatVal : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LegoColorSeasonIndex ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)))
	#else
	int LegoColorSeasonIndex : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Light ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)))
	#else
	int VariantConstant_Light : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_AnimatedLight ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)))
	#else
	int VariantConstant_AnimatedLight : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Refraction ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)))
	#else
	int VariantConstant_Refraction : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UV34Offset ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)))
	#else
	int VariantConstant_UV34Offset : packoffset(c6.x);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UVUVSet = 0;
static const float2 ThicknessTiling = float2(1, 1);
static const float2 Roughness_AO_SpecScale_ModulateTiling = float2(1, 1);
static const bool StepBool = false;
static const bool StepHardStepBool = false;
static const bool Step0Bool = false;
static const bool Step0HardStepBool = false;
static const int UV4UVSet = 3;
static const bool InstanceAnimOffsetFullColor = false;
static const int InstanceAnimOffsetVariationIndex = 0;
static const bool Step2Bool = false;
static const bool Step2HardStepBool = true;
static const float NormalMapSpecPower = 100;
static const float2 NormalMapTiling = float2(1, 1);
static const int UV3UVSet = 2;

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStates0Sampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Colour_Metalness_Swatch0Texture, 16);
#else
#define Colour_Metalness_Swatch0Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapTexture, 17);
#else
#define NormalMapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Roughness_AO_SpecScale_ModulateTexture, 18);
#else
#define Roughness_AO_SpecScale_ModulateTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(ThicknessTexture, 19);
#else
#define ThicknessTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_INPUT_IS_USED_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Transmissiveness 1
#define MATERIAL_HAS_INPUT_TransmissiveFuzziness 1
#define MATERIAL_HAS_INPUT_TransmissiveControl 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_INPUT_IS_USED_Lightmap 1
#define MATERIAL_HAS_INPUT_LightmapAdditive 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_INPUT_IS_USED_SpecularScale 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_MinimumWind 1
#define MATERIAL_HAS_INPUT_AnimationPivot 1
#define MATERIAL_INPUT_IS_USED_AnimationPivot 1
#define MATERIAL_HAS_INPUT_AnimationSpeed 1
#define MATERIAL_HAS_INPUT_TranslateSpeed 1
#define MATERIAL_HAS_INPUT_RotateSpeed 1
#define MATERIAL_HAS_INPUT_Translate 1
#define MATERIAL_HAS_INPUT_Rotate 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
#define MATERIAL_HAS_INPUT_SnowSpecTexture 1
#define MATERIAL_HAS_INPUT_SnowAmount 1
#define MATERIAL_HAS_INPUT_FrostAmount 1
#define MATERIAL_HAS_INPUT_TwinkleAmount 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BlinnPhongAlpha.hlsl"
#include "Lego.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:ViewVectorNode, Name:ViewVector
	float4 ViewVector = float4(GetViewVector(), 0);
	// Type:NegateNode, Name:Negate
	float4 Negate = -1.0f * ViewVector;
	
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:FloatNode, Name:RefractionMin
	float4 RefractionMin = RefractionMin_floatVal;
	
	// Type:FloatNode, Name:RefractionMax
	float4 RefractionMax = RefractionMax_floatVal;
	
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord0(In).xyxy;
	float4 UVTangent = GetWorldTangent0(In);
	float4 UVUCoord = GetTexCoord0(In).xxxx;
	float4 UVVCoord = GetTexCoord0(In).yyyy;
	
	// Type:SamplerStatesNode, Name:SamplerStates0
	SamplerState SamplerStates0 = SamplerStates0Sampler;
	float4 SamplerStates0Preview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:Thickness
	float4 Thickness = ThicknessTexture.Sample(SamplerStates0Sampler, UV.xy * ThicknessTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 ThicknessMip = GetDebugMipColour(ThicknessTexture, SamplerStates0Sampler, UV.xy * ThicknessTiling);
	#else
	float4 ThicknessMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 ThicknessAlpha = Thickness.aaaa;
	float4 ThicknessRed = Thickness.rrrr;
	float4 ThicknessGreen = Thickness.gggg;
	float4 ThicknessBlue = Thickness.bbbb;
	Texture2D ThicknessRef = ThicknessTexture;
	
	// Type:LerpNode, Name:Lerp2
	float4 Lerp2 = lerp(RefractionMin, RefractionMax, ThicknessRed.x);
	
	// Type:LerpNode, Name:Lerp1
	float4 Lerp1 = lerp(Negate, WorldNormal, Lerp2.x);
	
	// Type:NormalizeNode, Name:Normalize1
	float4 Normalize1 = float4(normalize(Lerp1.xyz), Lerp1.w);
	
	// Type:GlobalSpecularCubeNode, Name:GlobalSpecularCube
	float4 GlobalSpecularCube = GetGlobalSpecularCubeLookup(g_samplerLinearWrap, Normalize1.xyz);
	float4 GlobalSpecularCubeAlpha = GlobalSpecularCube.aaaa;
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:LegoColorNode, Name:LegoColor
	float4 LegoColorColourUV = UnpackLegoColor(VertexColor, LegoColorSeasonIndex);
	// Type:GatherTexture4, Name:Colour_Metalness_Swatch0
	float4 Colour_Metalness_Swatch0Color0 = Colour_Metalness_Swatch0Texture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(0,0));
	float4 Colour_Metalness_Swatch0Color1 = Colour_Metalness_Swatch0Texture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(1,0));
	float4 Colour_Metalness_Swatch0Color2 = Colour_Metalness_Swatch0Texture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(0,1));
	float4 Colour_Metalness_Swatch0Color3 = Colour_Metalness_Swatch0Texture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(1,1));
	
	// Type:TextureNode, Name:Roughness_AO_SpecScale_Modulate
	float4 Roughness_AO_SpecScale_Modulate = Roughness_AO_SpecScale_ModulateTexture.Sample(SamplerStates0Sampler, UV.xy * Roughness_AO_SpecScale_ModulateTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Roughness_AO_SpecScale_ModulateMip = GetDebugMipColour(Roughness_AO_SpecScale_ModulateTexture, SamplerStates0Sampler, UV.xy * Roughness_AO_SpecScale_ModulateTiling);
	#else
	float4 Roughness_AO_SpecScale_ModulateMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Roughness_AO_SpecScale_ModulateAlpha = Roughness_AO_SpecScale_Modulate.aaaa;
	float4 Roughness_AO_SpecScale_ModulateRed = Roughness_AO_SpecScale_Modulate.rrrr;
	float4 Roughness_AO_SpecScale_ModulateGreen = Roughness_AO_SpecScale_Modulate.gggg;
	float4 Roughness_AO_SpecScale_ModulateBlue = Roughness_AO_SpecScale_Modulate.bbbb;
	Texture2D Roughness_AO_SpecScale_ModulateRef = Roughness_AO_SpecScale_ModulateTexture;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Colour_Metalness_Swatch0Color0 * Roughness_AO_SpecScale_ModulateAlpha;
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = GlobalSpecularCube * Multiply;
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(Multiply2, Multiply, ThicknessRed.x);
	
	// Type:FloatNode, Name:LightSizeMin
	float4 LightSizeMin = LightSizeMin_floatVal;
	
	// Type:FloatNode, Name:LightSizeMax
	float4 LightSizeMax = LightSizeMax_floatVal;
	
	// Type:NormalizeNode, Name:Normalize0
	float4 Normalize0 = float4(normalize(Lerp1.xyz), Lerp1.w);
	
	// Type:ModelPosNode, Name:ModelPos
	float4 ModelPos = float4(GetMeshPos(In).xyz, 1);
	// Type:NormalizeNode, Name:Normalize
	float4 Normalize = float4(normalize(ModelPos.xyz), ModelPos.w);
	
	// Type:DotNode, Name:Dot
	float4 Dot = dot(Normalize0, Normalize);
	
	// Type:StepNode, Name:Step
	float4 Step = linearstep( LightSizeMin, LightSizeMax, Dot );
	
	// Type:FloatNode, Name:InternalReflectionMin
	float4 InternalReflectionMin = InternalReflectionMin_floatVal;
	
	// Type:FloatNode, Name:InternalReflectionMax
	float4 InternalReflectionMax = InternalReflectionMax_floatVal;
	
	// Type:NegateNode, Name:Negate0
	float4 Negate0 = -1.0f * WorldNormal;
	
	// Type:DotNode, Name:Dot0
	float4 Dot0 = dot(Normalize0, Negate0);
	
	// Type:StepNode, Name:Step0
	float4 Step0 = linearstep( InternalReflectionMin, InternalReflectionMax, Dot0 );
	
	// Type:FloatNode, Name:InternalReflectionStrength
	float4 InternalReflectionStrength = InternalReflectionStrength_floatVal;
	
	// Type:MultiplyNode, Name:Multiply4
	float4 Multiply4 = Step0 * InternalReflectionStrength;
	
	// Type:MaxNode, Name:Max
	float4 Max = max(Step, Multiply4);
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(1, 1, 1, 1);
	
	// Type:VariantOnOffNode, Name:RefractionOnOff
	#if defined(VARIANTPROPERTY_REFRACTION) && VARIANTPROPERTY_REFRACTION == 1
	float4 RefractionOnOff = Max;
	#elif defined(VARIANTPROPERTY_REFRACTION) && VARIANTPROPERTY_REFRACTION == 0
	float4 RefractionOnOff = Float1;
	#elif !defined(VARIANTPROPERTY_REFRACTION) || VARIANTPROPERTY_REFRACTION == 2
	float4 RefractionOnOff;
	[branch]
	if(VariantConstant_Refraction != 0)
	{
		RefractionOnOff = Max;
	}
	else
	{
		RefractionOnOff = Float1;
	}
	#endif
	
	// Type:FloatNode, Name:AnimLength
	float4 AnimLength = AnimLength_floatVal;
	
	// Type:NetworkTimeNode, Name:TimeScale
	float4 TimeScale = TimeScaleTimeScale * GetNetworkSyncrhonizedTime();
	
	// Type:UVNode, Name:UV4
	float4 UV4 = GetTexCoord3(In).xyxy;
	float4 UV4Tangent = GetWorldTangent3(In);
	float4 UV4UCoord = GetTexCoord3(In).xxxx;
	float4 UV4VCoord = GetTexCoord3(In).yyyy;
	
	// Type:FloatNode, Name:AnimOffset
	float4 AnimOffset = AnimOffset_floatVal;
	
	// Type:VariantOnOffNode, Name:UV34OffsetOnOff
	#if defined(VARIANTPROPERTY_UV34OFFSET) && VARIANTPROPERTY_UV34OFFSET == 1
	float4 UV34OffsetOnOff = UV4VCoord;
	#elif defined(VARIANTPROPERTY_UV34OFFSET) && VARIANTPROPERTY_UV34OFFSET == 0
	float4 UV34OffsetOnOff = AnimOffset;
	#elif !defined(VARIANTPROPERTY_UV34OFFSET) || VARIANTPROPERTY_UV34OFFSET == 2
	float4 UV34OffsetOnOff;
	[branch]
	if(VariantConstant_UV34Offset != 0)
	{
		UV34OffsetOnOff = UV4VCoord;
	}
	else
	{
		UV34OffsetOnOff = AnimOffset;
	}
	#endif
	
	// Type:VariationNode, Name:InstanceAnimOffset
	float4 InstanceAnimOffset = GetInstanceVariation(In)[0];
	
	// Type:AddNode, Name:Add1
	float4 Add1 = UV34OffsetOnOff + InstanceAnimOffset;
	
	// Type:AddNode, Name:Add0
	float4 Add0 = TimeScale + Add1;
	
	// Type:FracNode, Name:Frac
	float4 Frac = frac(Add0);
	
	// Type:StepNode, Name:Step2
	float4 Step2 = step( Frac, AnimLength);
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(1, 1, 1, 1);
	
	// Type:VariantOnOffNode, Name:VariantOnOff_AnimatedLight
	#if defined(VARIANTPROPERTY_ANIMATEDLIGHT) && VARIANTPROPERTY_ANIMATEDLIGHT == 1
	float4 VariantOnOff_AnimatedLight = Step2;
	#elif defined(VARIANTPROPERTY_ANIMATEDLIGHT) && VARIANTPROPERTY_ANIMATEDLIGHT == 0
	float4 VariantOnOff_AnimatedLight = Float;
	#elif !defined(VARIANTPROPERTY_ANIMATEDLIGHT) || VARIANTPROPERTY_ANIMATEDLIGHT == 2
	float4 VariantOnOff_AnimatedLight;
	[branch]
	if(VariantConstant_AnimatedLight != 0)
	{
		VariantOnOff_AnimatedLight = Step2;
	}
	else
	{
		VariantOnOff_AnimatedLight = Float;
	}
	#endif
	
	// Type:MultiplyNode, Name:Multiply5
	float4 Multiply5 = RefractionOnOff * VariantOnOff_AnimatedLight;
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(Lerp0, Colour_Metalness_Swatch0Color2, Multiply5.x);
	
	// Type:VariantOnOffNode, Name:VariantOnOff_Light00
	#if defined(VARIANTPROPERTY_LIGHT) && VARIANTPROPERTY_LIGHT == 1
	float4 VariantOnOff_Light00 = Lerp;
	#elif defined(VARIANTPROPERTY_LIGHT) && VARIANTPROPERTY_LIGHT == 0
	float4 VariantOnOff_Light00 = Lerp0;
	#elif !defined(VARIANTPROPERTY_LIGHT) || VARIANTPROPERTY_LIGHT == 2
	float4 VariantOnOff_Light00;
	[branch]
	if(VariantConstant_Light != 0)
	{
		VariantOnOff_Light00 = Lerp;
	}
	else
	{
		VariantOnOff_Light00 = Lerp0;
	}
	#endif
	
	// Type:NormalMapNode, Name:NormalMap
	float4 textureLookup_NormalMap = NormalMapTexture.Sample(SamplerStates0Sampler, UV.xy * NormalMapTiling);
	#ifdef _MAX_
	textureLookup_NormalMap.xyz = pow(textureLookup_NormalMap.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMap = (2.0f * textureLookup_NormalMap.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMap, NormalMapSpecPower);
	float4 NormalMapAlpha = textureLookup_NormalMap.aaaa;
	float4 NormalMapRed = textureLookup_NormalMap.rrrr;
	float4 NormalMapGreen = textureLookup_NormalMap.gggg;
	float4 NormalMapBlue = textureLookup_NormalMap.bbbb;
	tangentSpaceNormal_NormalMap.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMap.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMap.x*tangentSpaceNormal_NormalMap.x - tangentSpaceNormal_NormalMap.y*tangentSpaceNormal_NormalMap.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMap.xy *= g_GlobalNormalScale;
	#endif
	float4 NormalMap = float4(normalize(mul(tangentSpaceNormal_NormalMap, float3x3(UVTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UVTangent.xyz) * UVTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMap = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:FloatNode, Name:RoughnessOverride
	float4 RoughnessOverride = float4(0.08, 0.08, 0.08, 0.08);
	
	// Type:FloatNode, Name:RoughnessOverrideScale
	float4 RoughnessOverrideScale = float4(0.6, 0.6, 0.6, 0.6);
	
	// Type:LerpNode, Name:LerpRoughnessOverride
	float4 LerpRoughnessOverride = lerp(Roughness_AO_SpecScale_ModulateRed, RoughnessOverride, RoughnessOverrideScale.x);
	
	// Type:SwizzleNode, Name:AlphaSwizzle
	float4 AlphaSwizzle = Colour_Metalness_Swatch0Color0.wwww;
	
	// Type:FloatNode, Name:StudEmissive
	float4 StudEmissive = StudEmissive_floatVal;
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = Colour_Metalness_Swatch0Color2 * RefractionOnOff;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd
	float4 MultiplyAdd = Multiply * StudEmissive + Multiply3;
	
	// Type:MultiplyNode, Name:Multiply50
	float4 Multiply50 = MultiplyAdd * VariantOnOff_AnimatedLight;
	
	// Type:ExposureValuesGroupNode, Name:ExposureEV0
	float4 ExposureEV0 = ExposureEV0_floatVal;
	
	// Type:MultiplyNode, Name:EmissiveMultiply0
	float4 EmissiveMultiply0 = Multiply50 * ExposureEV0;
	
	// Type:FloatNode, Name:Float0
	float4 Float0 = float4(0, 0, 0, 0);
	
	// Type:VariantOnOffNode, Name:VariantOnOff_Light01
	#if defined(VARIANTPROPERTY_LIGHT) && VARIANTPROPERTY_LIGHT == 1
	float4 VariantOnOff_Light01 = EmissiveMultiply0;
	#elif defined(VARIANTPROPERTY_LIGHT) && VARIANTPROPERTY_LIGHT == 0
	float4 VariantOnOff_Light01 = Float0;
	#elif !defined(VARIANTPROPERTY_LIGHT) || VARIANTPROPERTY_LIGHT == 2
	float4 VariantOnOff_Light01;
	[branch]
	if(VariantConstant_Light != 0)
	{
		VariantOnOff_Light01 = EmissiveMultiply0;
	}
	else
	{
		VariantOnOff_Light01 = Float0;
	}
	#endif
	
	// Type:UVNode, Name:UV3
	float4 UV3 = GetTexCoord2(In).xyxy;
	float4 UV3Tangent = GetWorldTangent2(In);
	float4 UV3UCoord = GetTexCoord2(In).xxxx;
	float4 UV3VCoord = GetTexCoord2(In).yyyy;
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(UV3UCoord.x, UV4UCoord.y, UV3VCoord.z, 0);
	
	// Type:Vector4Node, Name:LightPosOffset
	float4 LightPosOffset = LightPosOffsetVector4;
	
	// Type:VariantOnOffNode, Name:UV34OffsetOnOff1
	#if defined(VARIANTPROPERTY_UV34OFFSET) && VARIANTPROPERTY_UV34OFFSET == 1
	float4 UV34OffsetOnOff1 = VectorMake;
	#elif defined(VARIANTPROPERTY_UV34OFFSET) && VARIANTPROPERTY_UV34OFFSET == 0
	float4 UV34OffsetOnOff1 = LightPosOffset;
	#elif !defined(VARIANTPROPERTY_UV34OFFSET) || VARIANTPROPERTY_UV34OFFSET == 2
	float4 UV34OffsetOnOff1;
	[branch]
	if(VariantConstant_UV34Offset != 0)
	{
		UV34OffsetOnOff1 = VectorMake;
	}
	else
	{
		UV34OffsetOnOff1 = LightPosOffset;
	}
	#endif
	
	// Type:FloatNode, Name:Float2
	float4 Float2 = Float2_floatVal;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = UV34OffsetOnOff1 * Float2;
	
	// Type:FloatNode, Name:LightSwitchOnStart
	float4 LightSwitchOnStart = LightSwitchOnStart_floatVal;
	
	// Type:FloatNode, Name:LightSwitchOnEnd
	float4 LightSwitchOnEnd = LightSwitchOnEnd_floatVal;
	
	output.BaseColor = VariantOnOff_Light00;
	output.Normal = NormalMap;
	output.Roughness = LerpRoughnessOverride;
	output.Metalness = AlphaSwizzle;
	output.Emissive = VariantOnOff_Light01;
	output.Lightmap = Multiply0;
	output.AmbientOcclusion = Roughness_AO_SpecScale_ModulateGreen;
	output.LightSwitchOnStart = LightSwitchOnStart;
	output.LightSwitchOnEnd = LightSwitchOnEnd;
	output.SpecularScale = Roughness_AO_SpecScale_ModulateBlue;
	output.AnimationPivot = UV34OffsetOnOff1;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\AnimatedLampOffset.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\TrackDebugLightingLightScenario.hlsl"