#include "LightScenarios\Inc\ShadowDepthLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 AlphaTiling < string UIName = "AlphaTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 AO_Thickness_ModelTiling < string UIName = "AO_Thickness_ModelTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float DirectOcclusion_floatVal < string UIName = "DirectOcclusion_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 EmissiveTiling < string UIName = "EmissiveTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float ExposureEV_floatVal < string UIName = "ExposureEV_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.001375 ;
int LegoColorSeasonIndex < string UIName = "LegoColorSeasonIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LightmapEV_floatVal < string UIName = "LightmapEV_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.001375 ;
float4 LightmapTiling < string UIName = "LightmapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float LightSwitchOnEnd_floatVal < string UIName = "LightSwitchOnEnd_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LightSwitchOnStart_floatVal < string UIName = "LightSwitchOnStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float NormalMapSpecPower < string UIName = "NormalMapSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalMapTiling < string UIName = "NormalMapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float ParallaxAODepth_floatVal < string UIName = "ParallaxAODepth_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.075 ;
float4 ParallaxAOMaskTextureTiling < string UIName = "ParallaxAOMaskTextureTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float ParallaxAOStrength_floatVal < string UIName = "ParallaxAOStrength_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1.5 ;
float4 ParallaxAOTextureTiling < string UIName = "ParallaxAOTextureTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 Roughness_AO_Thickness_ModulateTiling < string UIName = "Roughness_AO_Thickness_ModulateTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float RoughnessMin_floatVal < string UIName = "RoughnessMin_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.125 ;
int TangentToWorldSpaceUVSet < string UIName = "TangentToWorldSpaceUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 TransmissiveControlVector4 < string UIName = "TransmissiveControlVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0, 1, 0.5, 0 );
float TransmissiveDistanceFadeEndFade < string UIName = "TransmissiveDistanceFadeEndFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float TransmissiveDistanceFadeStartFade < string UIName = "TransmissiveDistanceFadeStartFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 75 ;
float4 TransmissiveFuzzinessVector4 < string UIName = "TransmissiveFuzzinessVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0, 1, -0.2, 0.2 );
float TransmissiveIntensity_floatVal < string UIName = "TransmissiveIntensity_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
int UV1UVSet < string UIName = "UV1UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_AlphaBlend < string UIName = "VariantConstant_AlphaBlend"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_AlphaTest < string UIName = "VariantConstant_AlphaTest"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_DisableTrims < string UIName = "VariantConstant_DisableTrims"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Emissive < string UIName = "VariantConstant_Emissive"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Lightmap < string UIName = "VariantConstant_Lightmap"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_LMVariationColour < string UIName = "VariantConstant_LMVariationColour"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_ParallaxAO < string UIName = "VariantConstant_ParallaxAO"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Transmissive < string UIName = "VariantConstant_Transmissive"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_UpperFloor < string UIName = "VariantConstant_UpperFloor"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_VariationColour < string UIName = "VariantConstant_VariationColour"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
bool Variation1FullColor < string UIName = "Variation1FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation1VariationIndex < string UIName = "Variation1VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
bool Variation2FullColor < string UIName = "Variation2FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation2VariationIndex < string UIName = "Variation2VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
bool Variation3FullColor < string UIName = "Variation3FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation3VariationIndex < string UIName = "Variation3VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
bool VariationFullColor < string UIName = "VariationFullColor"; string UIWidget = "Checkbox"; > = 0;
int VariationVariationIndex < string UIName = "VariationVariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define TransmissiveFuzzinessVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 TransmissiveFuzzinessVector4 : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TransmissiveControlVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 TransmissiveControlVector4 : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define RoughnessMin_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].x)
	#else
	float RoughnessMin_floatVal : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ExposureEV_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].y)
	#else
	float ExposureEV_floatVal : packoffset(c2.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TransmissiveIntensity_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].z)
	#else
	float TransmissiveIntensity_floatVal : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TransmissiveDistanceFadeStartFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].w)
	#else
	float TransmissiveDistanceFadeStartFade : packoffset(c2.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TransmissiveDistanceFadeEndFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].x)
	#else
	float TransmissiveDistanceFadeEndFade : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightmapEV_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].y)
	#else
	float LightmapEV_floatVal : packoffset(c3.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ParallaxAODepth_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].z)
	#else
	float ParallaxAODepth_floatVal : packoffset(c3.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ParallaxAOStrength_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].w)
	#else
	float ParallaxAOStrength_floatVal : packoffset(c3.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DirectOcclusion_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float DirectOcclusion_floatVal : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].y)
	#else
	float LightSwitchOnStart_floatVal : packoffset(c4.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnEnd_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].z)
	#else
	float LightSwitchOnEnd_floatVal : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LegoColorSeasonIndex ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)))
	#else
	int LegoColorSeasonIndex : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_AlphaTest ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)))
	#else
	int VariantConstant_AlphaTest : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_AlphaBlend ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)))
	#else
	int VariantConstant_AlphaBlend : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Emissive ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)))
	#else
	int VariantConstant_Emissive : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Lightmap ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)))
	#else
	int VariantConstant_Lightmap : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Transmissive ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].y)))
	#else
	int VariantConstant_Transmissive : packoffset(c6.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_VariationColour ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].z)))
	#else
	int VariantConstant_VariationColour : packoffset(c6.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_LMVariationColour ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].w)))
	#else
	int VariantConstant_LMVariationColour : packoffset(c6.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UpperFloor ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].x)))
	#else
	int VariantConstant_UpperFloor : packoffset(c7.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_DisableTrims ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].y)))
	#else
	int VariantConstant_DisableTrims : packoffset(c7.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_ParallaxAO ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].z)))
	#else
	int VariantConstant_ParallaxAO : packoffset(c7.z);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const bool VariationFullColor = false;
static const int VariationVariationIndex = 0;
static const int UVUVSet = 0;
static const float2 Roughness_AO_Thickness_ModulateTiling = float2(1, 1);
static const int TangentToWorldSpaceUVSet = 0;
static const float NormalMapSpecPower = 100;
static const float2 NormalMapTiling = float2(1, 1);
static const float2 EmissiveTiling = float2(1, 1);
static const int UV1UVSet = 1;
static const float2 AO_Thickness_ModelTiling = float2(1, 1);
static const bool Variation1FullColor = false;
static const int Variation1VariationIndex = 1;
static const bool Variation2FullColor = false;
static const int Variation2VariationIndex = 2;
static const bool Variation3FullColor = false;
static const int Variation3VariationIndex = 3;
static const float2 LightmapTiling = float2(1, 1);
static const float2 ParallaxAOMaskTextureTiling = float2(1, 1);
static const float2 ParallaxAOTextureTiling = float2(1, 1);
static const float2 AlphaTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStates0Sampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(AlphaTexture, 16);
#else
#define AlphaTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(AO_Thickness_ModelTexture, 17);
#else
#define AO_Thickness_ModelTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Colour_Metalness_SwatchTexture, 18);
#else
#define Colour_Metalness_SwatchTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(EmissiveTexture, 19);
#else
#define EmissiveTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(LightmapTexture, 20);
#else
#define LightmapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapTexture, 21);
#else
#define NormalMapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(ParallaxAOMaskTextureTexture, 22);
#else
#define ParallaxAOMaskTextureTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(6)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(ParallaxAOTextureTexture, 23);
#else
#define ParallaxAOTextureTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(7)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Roughness_AO_Thickness_ModulateTexture, 24);
#else
#define Roughness_AO_Thickness_ModulateTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(8)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_INPUT_IS_USED_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Transmissiveness 1
#define MATERIAL_INPUT_IS_USED_Transmissiveness 1
#define MATERIAL_HAS_INPUT_TransmissiveFuzziness 1
#define MATERIAL_INPUT_IS_USED_TransmissiveFuzziness 1
#define MATERIAL_HAS_INPUT_TransmissiveControl 1
#define MATERIAL_INPUT_IS_USED_TransmissiveControl 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_INPUT_IS_USED_Lightmap 1
#define MATERIAL_HAS_INPUT_LightmapAdditive 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_INPUT_IS_USED_AlphaTest 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_INPUT_IS_USED_AlphaBlend 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_INPUT_IS_USED_SpecularScale 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_MinimumWind 1
#define MATERIAL_HAS_INPUT_AnimationPivot 1
#define MATERIAL_HAS_INPUT_AnimationSpeed 1
#define MATERIAL_HAS_INPUT_TranslateSpeed 1
#define MATERIAL_HAS_INPUT_RotateSpeed 1
#define MATERIAL_HAS_INPUT_Translate 1
#define MATERIAL_HAS_INPUT_Rotate 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
#define MATERIAL_HAS_INPUT_SnowSpecTexture 1
#define MATERIAL_HAS_INPUT_SnowAmount 1
#define MATERIAL_HAS_INPUT_FrostAmount 1
#define MATERIAL_HAS_INPUT_TwinkleAmount 1
// Alpha
#if VARIANTPROPERTY_ALPHABLEND
#define IS_ALPHA_BLENDED 1
#else
#define IS_ALPHA_BLENDED 0
#endif
#if VARIANTPROPERTY_ALPHATEST
#define IS_ALPHA_TESTED 1
#else
#define IS_ALPHA_TESTED 0
#endif
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BlinnPhongAlpha.hlsl"
#include "Lego.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:VariationNode, Name:Variation
	float4 Variation = GetInstanceVariation(In)[0];
	
	// Type:FloatNode, Name:ONE
	float4 ONE = float4(1, 1, 1, 1);
	
	// Type:MaxSwitch, Name:MaxSwitch
	    float4 MaxSwitch = Variation;
	#ifdef _MAX_
	    MaxSwitch = ONE;
	#endif
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(MaxSwitch.x, MaxSwitch.x, MaxSwitch.x, MaxSwitch.x);
	
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:VariantOnOffNode, Name:VariationColourOnOff
	#if defined(VARIANTPROPERTY_VARIATIONCOLOUR) && VARIANTPROPERTY_VARIATIONCOLOUR == 1
	float4 VariationColourOnOff = VectorMake;
	#elif defined(VARIANTPROPERTY_VARIATIONCOLOUR) && VARIANTPROPERTY_VARIATIONCOLOUR == 0
	float4 VariationColourOnOff = VertexColor;
	#elif !defined(VARIANTPROPERTY_VARIATIONCOLOUR) || VARIANTPROPERTY_VARIATIONCOLOUR == 2
	float4 VariationColourOnOff;
	[branch]
	if(VariantConstant_VariationColour != 0)
	{
		VariationColourOnOff = VectorMake;
	}
	else
	{
		VariationColourOnOff = VertexColor;
	}
	#endif
	
	// Type:LegoColorNode, Name:LegoColor
	float4 LegoColorColourUV = UnpackLegoColor(VariationColourOnOff, LegoColorSeasonIndex);
	// Type:GatherTexture4, Name:Colour_Metalness_Swatch
	float4 Colour_Metalness_SwatchColor0 = Colour_Metalness_SwatchTexture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(0,0));
	float4 Colour_Metalness_SwatchColor1 = Colour_Metalness_SwatchTexture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(1,0));
	float4 Colour_Metalness_SwatchColor2 = Colour_Metalness_SwatchTexture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(0,1));
	float4 Colour_Metalness_SwatchColor3 = Colour_Metalness_SwatchTexture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(1,1));
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(1, 1, 1, 1);
	
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord0(In).xyxy;
	float4 UVTangent = GetWorldTangent0(In);
	float4 UVUCoord = GetTexCoord0(In).xxxx;
	float4 UVVCoord = GetTexCoord0(In).yyyy;
	
	// Type:SamplerStatesNode, Name:SamplerStates0
	SamplerState SamplerStates0 = SamplerStates0Sampler;
	float4 SamplerStates0Preview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:Roughness_AO_Thickness_Modulate
	float4 Roughness_AO_Thickness_Modulate = Roughness_AO_Thickness_ModulateTexture.Sample(SamplerStates0Sampler, UV.xy * Roughness_AO_Thickness_ModulateTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Roughness_AO_Thickness_ModulateMip = GetDebugMipColour(Roughness_AO_Thickness_ModulateTexture, SamplerStates0Sampler, UV.xy * Roughness_AO_Thickness_ModulateTiling);
	#else
	float4 Roughness_AO_Thickness_ModulateMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Roughness_AO_Thickness_ModulateAlpha = Roughness_AO_Thickness_Modulate.aaaa;
	float4 Roughness_AO_Thickness_ModulateRed = Roughness_AO_Thickness_Modulate.rrrr;
	float4 Roughness_AO_Thickness_ModulateGreen = Roughness_AO_Thickness_Modulate.gggg;
	float4 Roughness_AO_Thickness_ModulateBlue = Roughness_AO_Thickness_Modulate.bbbb;
	Texture2D Roughness_AO_Thickness_ModulateRef = Roughness_AO_Thickness_ModulateTexture;
	
	// Type:VariantOnOffNode, Name:DisableTrimsOnOff3
	#if defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 1
	float4 DisableTrimsOnOff3 = Float;
	#elif defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 0
	float4 DisableTrimsOnOff3 = Roughness_AO_Thickness_ModulateAlpha;
	#elif !defined(VARIANTPROPERTY_DISABLETRIMS) || VARIANTPROPERTY_DISABLETRIMS == 2
	float4 DisableTrimsOnOff3;
	[branch]
	if(VariantConstant_DisableTrims != 0)
	{
		DisableTrimsOnOff3 = Float;
	}
	else
	{
		DisableTrimsOnOff3 = Roughness_AO_Thickness_ModulateAlpha;
	}
	#endif
	
	// Type:MultiplyNode, Name:Modulate
	float4 Modulate = Colour_Metalness_SwatchColor0 * DisableTrimsOnOff3;
	
	// Type:Vector4Node, Name:Vector4
	float4 Vector4 = float4(0, 0, 1, 1) ;
	
	// Type:TangentToWorldSpaceNode, Name:TangentToWorldSpace
	float4 TangentToWorldSpace = float4(normalize(mul(Vector4, float3x3(UVTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UVTangent.xyz) * UVTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	
	// Type:NormalMapNode, Name:NormalMap
	float4 textureLookup_NormalMap = NormalMapTexture.Sample(SamplerStates0Sampler, UV.xy * NormalMapTiling);
	#ifdef _MAX_
	textureLookup_NormalMap.xyz = pow(textureLookup_NormalMap.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMap = (2.0f * textureLookup_NormalMap.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMap, NormalMapSpecPower);
	float4 NormalMapAlpha = textureLookup_NormalMap.aaaa;
	float4 NormalMapRed = textureLookup_NormalMap.rrrr;
	float4 NormalMapGreen = textureLookup_NormalMap.gggg;
	float4 NormalMapBlue = textureLookup_NormalMap.bbbb;
	tangentSpaceNormal_NormalMap.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMap.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMap.x*tangentSpaceNormal_NormalMap.x - tangentSpaceNormal_NormalMap.y*tangentSpaceNormal_NormalMap.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMap.xy *= g_GlobalNormalScale;
	#endif
	float4 NormalMap = float4(normalize(mul(tangentSpaceNormal_NormalMap, float3x3(UVTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UVTangent.xyz) * UVTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMap = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:VariantOnOffNode, Name:DisableTrimsOnOff0
	#if defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 1
	float4 DisableTrimsOnOff0 = TangentToWorldSpace;
	#elif defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 0
	float4 DisableTrimsOnOff0 = NormalMap;
	#elif !defined(VARIANTPROPERTY_DISABLETRIMS) || VARIANTPROPERTY_DISABLETRIMS == 2
	float4 DisableTrimsOnOff0;
	[branch]
	if(VariantConstant_DisableTrims != 0)
	{
		DisableTrimsOnOff0 = TangentToWorldSpace;
	}
	else
	{
		DisableTrimsOnOff0 = NormalMap;
	}
	#endif
	
	// Type:FloatNode, Name:RoughnessMin
	float4 RoughnessMin = RoughnessMin_floatVal;
	
	// Type:MaxNode, Name:Max
	float4 Max = max(Roughness_AO_Thickness_ModulateRed, RoughnessMin);
	
	// Type:VariantOnOffNode, Name:DisableTrimsOnOff10
	#if defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 1
	float4 DisableTrimsOnOff10 = RoughnessMin;
	#elif defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 0
	float4 DisableTrimsOnOff10 = Max;
	#elif !defined(VARIANTPROPERTY_DISABLETRIMS) || VARIANTPROPERTY_DISABLETRIMS == 2
	float4 DisableTrimsOnOff10;
	[branch]
	if(VariantConstant_DisableTrims != 0)
	{
		DisableTrimsOnOff10 = RoughnessMin;
	}
	else
	{
		DisableTrimsOnOff10 = Max;
	}
	#endif
	
	// Type:FloatNode, Name:RoughnessOverride
	float4 RoughnessOverride = float4(0.08, 0.08, 0.08, 0.08);
	
	// Type:FloatNode, Name:RoughnessOverrideScale
	float4 RoughnessOverrideScale = float4(0.6, 0.6, 0.6, 0.6);
	
	// Type:LerpNode, Name:LerpRoughnessOverride
	float4 LerpRoughnessOverride = lerp(DisableTrimsOnOff10, RoughnessOverride, RoughnessOverrideScale.x);
	
	// Type:SwizzleNode, Name:AlphaSwizzle
	float4 AlphaSwizzle = Colour_Metalness_SwatchColor0.wwww;
	
	// Type:ExposureValuesGroupNode, Name:ExposureEV
	float4 ExposureEV = ExposureEV_floatVal;
	
	// Type:TextureNode, Name:Emissive
	float4 Emissive = EmissiveTexture.Sample(SamplerStates0Sampler, UV.xy * EmissiveTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 EmissiveMip = GetDebugMipColour(EmissiveTexture, SamplerStates0Sampler, UV.xy * EmissiveTiling);
	#else
	float4 EmissiveMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 EmissiveAlpha = Emissive.aaaa;
	float4 EmissiveRed = Emissive.rrrr;
	float4 EmissiveGreen = Emissive.gggg;
	float4 EmissiveBlue = Emissive.bbbb;
	Texture2D EmissiveRef = EmissiveTexture;
	
	// Type:MultiplyNode, Name:EmissiveMultiply
	float4 EmissiveMultiply = ExposureEV * Emissive;
	
	// Type:MultiplyNode, Name:MultiplyEmmisiveColor
	float4 MultiplyEmmisiveColor = Colour_Metalness_SwatchColor0 * EmissiveMultiply;
	
	// Type:FloatNode, Name:Zero
	float4 Zero = float4(0, 0, 0, 0);
	
	// Type:VariantOnOffNode, Name:EmissiveVariantOnOff
	#if defined(VARIANTPROPERTY_EMISSIVE) && VARIANTPROPERTY_EMISSIVE == 1
	float4 EmissiveVariantOnOff = MultiplyEmmisiveColor;
	#elif defined(VARIANTPROPERTY_EMISSIVE) && VARIANTPROPERTY_EMISSIVE == 0
	float4 EmissiveVariantOnOff = Zero;
	#elif !defined(VARIANTPROPERTY_EMISSIVE) || VARIANTPROPERTY_EMISSIVE == 2
	float4 EmissiveVariantOnOff;
	[branch]
	if(VariantConstant_Emissive != 0)
	{
		EmissiveVariantOnOff = MultiplyEmmisiveColor;
	}
	else
	{
		EmissiveVariantOnOff = Zero;
	}
	#endif
	
	// Type:UVNode, Name:UV1
	float4 UV1 = GetTexCoord1(In).xyxy;
	float4 UV1Tangent = GetWorldTangent1(In);
	float4 UV1UCoord = GetTexCoord1(In).xxxx;
	float4 UV1VCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:AO_Thickness_Model
	float4 AO_Thickness_Model = AO_Thickness_ModelTexture.Sample(SamplerStates0Sampler, UV1.xy * AO_Thickness_ModelTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AO_Thickness_ModelMip = GetDebugMipColour(AO_Thickness_ModelTexture, SamplerStates0Sampler, UV1.xy * AO_Thickness_ModelTiling);
	#else
	float4 AO_Thickness_ModelMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AO_Thickness_ModelAlpha = AO_Thickness_Model.aaaa;
	float4 AO_Thickness_ModelRed = AO_Thickness_Model.rrrr;
	float4 AO_Thickness_ModelGreen = AO_Thickness_Model.gggg;
	float4 AO_Thickness_ModelBlue = AO_Thickness_Model.bbbb;
	Texture2D AO_Thickness_ModelRef = AO_Thickness_ModelTexture;
	
	// Type:OneMinusNode, Name:OneMinus
	float4 OneMinus = 1 - Roughness_AO_Thickness_ModulateBlue;
	
	// Type:VariantOnOffNode, Name:DisableTrimsOnOff2
	#if defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 1
	float4 DisableTrimsOnOff2 = Float;
	#elif defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 0
	float4 DisableTrimsOnOff2 = OneMinus;
	#elif !defined(VARIANTPROPERTY_DISABLETRIMS) || VARIANTPROPERTY_DISABLETRIMS == 2
	float4 DisableTrimsOnOff2;
	[branch]
	if(VariantConstant_DisableTrims != 0)
	{
		DisableTrimsOnOff2 = Float;
	}
	else
	{
		DisableTrimsOnOff2 = OneMinus;
	}
	#endif
	
	// Type:MultiplyNode, Name:MultiplyTransmissiveness2
	float4 MultiplyTransmissiveness2 = AO_Thickness_ModelGreen * DisableTrimsOnOff2;
	
	// Type:FloatNode, Name:TransmissiveIntensity
	float4 TransmissiveIntensity = TransmissiveIntensity_floatVal;
	
	// Type:MultiplyNode, Name:TransmissiveColourIntensity
	float4 TransmissiveColourIntensity = TransmissiveIntensity * Colour_Metalness_SwatchColor1;
	
	// Type:MultiplyNode, Name:MultiplyTransmissiveness
	float4 MultiplyTransmissiveness = MultiplyTransmissiveness2 * TransmissiveColourIntensity;
	
	// Type:DistanceFaderNode, Name:TransmissiveDistanceFade
	float4 TransmissiveDistanceFade = 1 - saturate( ( distance(GetWorldPos(In), g_EyePos.xyz) - TransmissiveDistanceFadeStartFade) / (TransmissiveDistanceFadeEndFade - TransmissiveDistanceFadeStartFade) );
	
	// Type:MultiplyNode, Name:MultiplyTransmissiveness0
	float4 MultiplyTransmissiveness0 = MultiplyTransmissiveness * TransmissiveDistanceFade;
	
	// Type:VariantOnOffNode, Name:TransmissiveVariantOnOff
	#if defined(VARIANTPROPERTY_TRANSMISSIVE) && VARIANTPROPERTY_TRANSMISSIVE == 1
	float4 TransmissiveVariantOnOff = MultiplyTransmissiveness0;
	#elif defined(VARIANTPROPERTY_TRANSMISSIVE) && VARIANTPROPERTY_TRANSMISSIVE == 0
	float4 TransmissiveVariantOnOff = Zero;
	#elif !defined(VARIANTPROPERTY_TRANSMISSIVE) || VARIANTPROPERTY_TRANSMISSIVE == 2
	float4 TransmissiveVariantOnOff;
	[branch]
	if(VariantConstant_Transmissive != 0)
	{
		TransmissiveVariantOnOff = MultiplyTransmissiveness0;
	}
	else
	{
		TransmissiveVariantOnOff = Zero;
	}
	#endif
	
	// Type:Vector4Node, Name:TransmissiveFuzziness
	float4 TransmissiveFuzziness = TransmissiveFuzzinessVector4;
	
	// Type:Vector4Node, Name:TransmissiveControl
	float4 TransmissiveControl = TransmissiveControlVector4;
	
	// Type:ExposureValuesGroupNode, Name:LightmapEV
	float4 LightmapEV = LightmapEV_floatVal;
	
	// Type:VariationNode, Name:Variation1
	float4 Variation1 = GetInstanceVariation(In)[1];
	
	// Type:VariationNode, Name:Variation2
	float4 Variation2 = GetInstanceVariation(In)[2];
	
	// Type:VariationNode, Name:Variation3
	float4 Variation3 = GetInstanceVariation(In)[3];
	
	// Type:VectorMake, Name:VariationColor
	float4 VariationColor = float4(Variation1.x, Variation2.y, Variation3.z, 0);
	
	// Type:FloatNode, Name:Gamma22
	float4 Gamma22 = float4(2.2, 2.2, 2.2, 2.2);
	
	// Type:PowNode, Name:PowGamma
	float4 PowGamma = pow( VariationColor, Gamma22 );
	
	// Type:ColorNode, Name:White
	float4 White =  float4(1, 1, 1, 1) ;
	float4 WhiteRed = 1;
	float4 WhiteGreen = 1;
	float4 WhiteBlue = 1;
	float4 WhiteAlpha = 1;
	
	// Type:VariantOnOffNode, Name:LMVariationColourOnOff
	#if defined(VARIANTPROPERTY_LMVARIATIONCOLOUR) && VARIANTPROPERTY_LMVARIATIONCOLOUR == 1
	float4 LMVariationColourOnOff = PowGamma;
	#elif defined(VARIANTPROPERTY_LMVARIATIONCOLOUR) && VARIANTPROPERTY_LMVARIATIONCOLOUR == 0
	float4 LMVariationColourOnOff = White;
	#elif !defined(VARIANTPROPERTY_LMVARIATIONCOLOUR) || VARIANTPROPERTY_LMVARIATIONCOLOUR == 2
	float4 LMVariationColourOnOff;
	[branch]
	if(VariantConstant_LMVariationColour != 0)
	{
		LMVariationColourOnOff = PowGamma;
	}
	else
	{
		LMVariationColourOnOff = White;
	}
	#endif
	
	// Type:TextureNode, Name:Lightmap
	float4 Lightmap = LightmapTexture.Sample(SamplerStates0Sampler, UV1.xy * LightmapTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 LightmapMip = GetDebugMipColour(LightmapTexture, SamplerStates0Sampler, UV1.xy * LightmapTiling);
	#else
	float4 LightmapMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 LightmapAlpha = Lightmap.aaaa;
	float4 LightmapRed = Lightmap.rrrr;
	float4 LightmapGreen = Lightmap.gggg;
	float4 LightmapBlue = Lightmap.bbbb;
	Texture2D LightmapRef = LightmapTexture;
	
	// Type:MultiplyNode, Name:LightmapMultiply1
	float4 LightmapMultiply1 = LMVariationColourOnOff * Lightmap;
	
	// Type:MultiplyNode, Name:LightmapMultiply0
	float4 LightmapMultiply0 = LightmapEV * LightmapMultiply1;
	
	// Type:VariantOnOffNode, Name:LightmapOnOff
	#if defined(VARIANTPROPERTY_LIGHTMAP) && VARIANTPROPERTY_LIGHTMAP == 1
	float4 LightmapOnOff = LightmapMultiply0;
	#elif defined(VARIANTPROPERTY_LIGHTMAP) && VARIANTPROPERTY_LIGHTMAP == 0
	float4 LightmapOnOff = Zero;
	#elif !defined(VARIANTPROPERTY_LIGHTMAP) || VARIANTPROPERTY_LIGHTMAP == 2
	float4 LightmapOnOff;
	[branch]
	if(VariantConstant_Lightmap != 0)
	{
		LightmapOnOff = LightmapMultiply0;
	}
	else
	{
		LightmapOnOff = Zero;
	}
	#endif
	
	// Type:VariantOnOffNode, Name:DisableTrimsOnOff1
	#if defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 1
	float4 DisableTrimsOnOff1 = Float;
	#elif defined(VARIANTPROPERTY_DISABLETRIMS) && VARIANTPROPERTY_DISABLETRIMS == 0
	float4 DisableTrimsOnOff1 = Roughness_AO_Thickness_ModulateGreen;
	#elif !defined(VARIANTPROPERTY_DISABLETRIMS) || VARIANTPROPERTY_DISABLETRIMS == 2
	float4 DisableTrimsOnOff1;
	[branch]
	if(VariantConstant_DisableTrims != 0)
	{
		DisableTrimsOnOff1 = Float;
	}
	else
	{
		DisableTrimsOnOff1 = Roughness_AO_Thickness_ModulateGreen;
	}
	#endif
	
	// Type:MultiplyNode, Name:MultiplyAO
	float4 MultiplyAO = DisableTrimsOnOff1 * AO_Thickness_ModelRed;
	
	// Type:TextureNode, Name:ParallaxAOMaskTexture
	float4 ParallaxAOMaskTexture = ParallaxAOMaskTextureTexture.Sample(SamplerStates0Sampler, UV.xy * ParallaxAOMaskTextureTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 ParallaxAOMaskTextureMip = GetDebugMipColour(ParallaxAOMaskTextureTexture, SamplerStates0Sampler, UV.xy * ParallaxAOMaskTextureTiling);
	#else
	float4 ParallaxAOMaskTextureMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 ParallaxAOMaskTextureAlpha = ParallaxAOMaskTexture.aaaa;
	float4 ParallaxAOMaskTextureRed = ParallaxAOMaskTexture.rrrr;
	float4 ParallaxAOMaskTextureGreen = ParallaxAOMaskTexture.gggg;
	float4 ParallaxAOMaskTextureBlue = ParallaxAOMaskTexture.bbbb;
	Texture2D ParallaxAOMaskTextureRef = ParallaxAOMaskTextureTexture;
	
	// Type:OneMinusNode, Name:OneMinus0
	float4 OneMinus0 = 1 - ParallaxAOMaskTexture;
	
	// Type:FloatNode, Name:ParallaxAODepth
	float4 ParallaxAODepth = ParallaxAODepth_floatVal;
	
	// Type:FloatNode, Name:ParallaxHeight
	float4 ParallaxHeight = float4(-1, -1, -1, -1);
	
	// Type:FloatNode, Name:ParallaxBaseHeight
	float4 ParallaxBaseHeight = float4(0, 0, 0, 0);
	
	// Type:ParallaxMappingNode, Name:ParallaxMapping
	float4 ParallaxMapping = 0;
	ParallaxMapping.xy = ParallaxMap(UV.xy, ParallaxHeight.x, ParallaxBaseHeight.x, ParallaxAODepth.x, 0.01.x, GetViewVector(), GetWorldNormal(In).xyz, GetWorldTangent0(In).xyzw);
	
	// Type:TextureNode, Name:ParallaxAOTexture
	float4 ParallaxAOTexture = ParallaxAOTextureTexture.Sample(SamplerStates0Sampler, ParallaxMapping.xy * ParallaxAOTextureTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 ParallaxAOTextureMip = GetDebugMipColour(ParallaxAOTextureTexture, SamplerStates0Sampler, ParallaxMapping.xy * ParallaxAOTextureTiling);
	#else
	float4 ParallaxAOTextureMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 ParallaxAOTextureAlpha = ParallaxAOTexture.aaaa;
	float4 ParallaxAOTextureRed = ParallaxAOTexture.rrrr;
	float4 ParallaxAOTextureGreen = ParallaxAOTexture.gggg;
	float4 ParallaxAOTextureBlue = ParallaxAOTexture.bbbb;
	Texture2D ParallaxAOTextureRef = ParallaxAOTextureTexture;
	
	// Type:FloatNode, Name:ParallaxAOStrength
	float4 ParallaxAOStrength = ParallaxAOStrength_floatVal;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = ParallaxAOTexture * ParallaxAOStrength;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = OneMinus0 * Multiply0;
	
	// Type:OneMinusNode, Name:OneMinus00
	float4 OneMinus00 = 1 - Multiply;
	
	// Type:FloatNode, Name:One0
	float4 One0 = float4(1, 1, 1, 1);
	
	// Type:VariantOnOffNode, Name:ParallaxOnOff
	#if defined(VARIANTPROPERTY_PARALLAXAO) && VARIANTPROPERTY_PARALLAXAO == 1
	float4 ParallaxOnOff = OneMinus00;
	#elif defined(VARIANTPROPERTY_PARALLAXAO) && VARIANTPROPERTY_PARALLAXAO == 0
	float4 ParallaxOnOff = One0;
	#elif !defined(VARIANTPROPERTY_PARALLAXAO) || VARIANTPROPERTY_PARALLAXAO == 2
	float4 ParallaxOnOff;
	[branch]
	if(VariantConstant_ParallaxAO != 0)
	{
		ParallaxOnOff = OneMinus00;
	}
	else
	{
		ParallaxOnOff = One0;
	}
	#endif
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = MultiplyAO * ParallaxOnOff;
	
	// Type:FloatNode, Name:DirectOcclusion
	float4 DirectOcclusion = DirectOcclusion_floatVal;
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(DisableTrimsOnOff1, Float, DirectOcclusion.x);
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = Lerp * ParallaxOnOff;
	
	// Type:TextureNode, Name:Alpha
	float4 Alpha = AlphaTexture.Sample(SamplerStates0Sampler, UV.xy * AlphaTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AlphaMip = GetDebugMipColour(AlphaTexture, SamplerStates0Sampler, UV.xy * AlphaTiling);
	#else
	float4 AlphaMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AlphaAlpha = Alpha.aaaa;
	float4 AlphaRed = Alpha.rrrr;
	float4 AlphaGreen = Alpha.gggg;
	float4 AlphaBlue = Alpha.bbbb;
	Texture2D AlphaRef = AlphaTexture;
	
	// Type:FloatNode, Name:One
	float4 One = float4(1, 1, 1, 1);
	
	// Type:VariantOnOffNode, Name:AlphaTestVariantOnOff
	#if defined(VARIANTPROPERTY_ALPHATEST) && VARIANTPROPERTY_ALPHATEST == 1
	float4 AlphaTestVariantOnOff = AlphaRed;
	#elif defined(VARIANTPROPERTY_ALPHATEST) && VARIANTPROPERTY_ALPHATEST == 0
	float4 AlphaTestVariantOnOff = One;
	#elif !defined(VARIANTPROPERTY_ALPHATEST) || VARIANTPROPERTY_ALPHATEST == 2
	float4 AlphaTestVariantOnOff;
	[branch]
	if(VariantConstant_AlphaTest != 0)
	{
		AlphaTestVariantOnOff = AlphaRed;
	}
	else
	{
		AlphaTestVariantOnOff = One;
	}
	#endif
	
	// Type:VariantOnOffNode, Name:AlphaBlendVariantOnOff
	#if defined(VARIANTPROPERTY_ALPHABLEND) && VARIANTPROPERTY_ALPHABLEND == 1
	float4 AlphaBlendVariantOnOff = AlphaRed;
	#elif defined(VARIANTPROPERTY_ALPHABLEND) && VARIANTPROPERTY_ALPHABLEND == 0
	float4 AlphaBlendVariantOnOff = One;
	#elif !defined(VARIANTPROPERTY_ALPHABLEND) || VARIANTPROPERTY_ALPHABLEND == 2
	float4 AlphaBlendVariantOnOff;
	[branch]
	if(VariantConstant_AlphaBlend != 0)
	{
		AlphaBlendVariantOnOff = AlphaRed;
	}
	else
	{
		AlphaBlendVariantOnOff = One;
	}
	#endif
	
	// Type:FloatNode, Name:LightSwitchOnStart
	float4 LightSwitchOnStart = LightSwitchOnStart_floatVal;
	
	// Type:FloatNode, Name:LightSwitchOnEnd
	float4 LightSwitchOnEnd = LightSwitchOnEnd_floatVal;
	
	output.BaseColor = Modulate;
	output.Normal = DisableTrimsOnOff0;
	output.Roughness = LerpRoughnessOverride;
	output.Metalness = AlphaSwizzle;
	output.Emissive = EmissiveVariantOnOff;
	output.Transmissiveness = TransmissiveVariantOnOff;
	output.TransmissiveFuzziness = TransmissiveFuzziness;
	output.TransmissiveControl = TransmissiveControl;
	output.Lightmap = LightmapOnOff;
	output.AmbientOcclusion = Multiply1;
	output.DirectOcclusion = Multiply2;
	#if IN_MATERIAL_EDITOR
	if (!forVertex) clip(AlphaTestVariantOnOff.x - ALPHATEST_MIN);
	#else
	#if ENABLE_ALPHA_TEST && IS_ALPHA_TESTED
	if (!forVertex && g_EnableAlphaTest) clip(AlphaTestVariantOnOff.x - ALPHATEST_MIN);
	#endif
	#endif
	output.AlphaTest = AlphaTestVariantOnOff;
	output.AlphaBlend = AlphaBlendVariantOnOff;
	output.LightSwitchOnStart = LightSwitchOnStart;
	output.LightSwitchOnEnd = LightSwitchOnEnd;
	output.SpecularScale = ParallaxOnOff;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\ShadowDepthLightScenario.hlsl"