#include "LightScenarios\Inc\TrackDayOptimisedLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 DayReflectiveSurfaceColourPickerColorParam < string UIName = "DayReflectiveSurfaceColourPickerColorParam"; string UIWidget = "Color"; > = float4( 0.223228, 0.1274377, 0.03820437, 1 );
float EmissiveEV_floatVal < string UIName = "EmissiveEV_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.088 ;
float FadeDistance_floatVal < string UIName = "FadeDistance_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 80 ;
bool FadeSmoothstepBool < string UIName = "FadeSmoothstepBool"; string UIWidget = "Checkbox"; > = 1;
bool FadeSmoothstepHardStepBool < string UIName = "FadeSmoothstepHardStepBool"; string UIWidget = "Checkbox"; > = 0;
float FadeStart_floatVal < string UIName = "FadeStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 190 ;
float4 FrameDiffuseTiling < string UIName = "FrameDiffuseTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 FrameRoughnessTiling < string UIName = "FrameRoughnessTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 InteriorDiffuseTiling < string UIName = "InteriorDiffuseTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 InteriorEmissiveTiling < string UIName = "InteriorEmissiveTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float LightSwitchOnEnd_floatVal < string UIName = "LightSwitchOnEnd_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.02 ;
float LightSwitchOnStart_floatVal < string UIName = "LightSwitchOnStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.01 ;
float4 Room_CountXYVector4 < string UIName = "Room_CountXYVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 Room_DepthXYZWVector4 < string UIName = "Room_DepthXYZWVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0.5, 0.5 );
float4 Room_WidthXYZWVector4 < string UIName = "Room_WidthXYZWVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 1, 1 );
float RoughnessOverride_floatVal < string UIName = "RoughnessOverride_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 Surface_TransColorColorParam < string UIName = "Surface_TransColorColorParam"; string UIWidget = "Color"; > = float4( 1, 1, 1, 1 );
float4 SurfaceDiffuseTiling < string UIName = "SurfaceDiffuseTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 SurfaceTransmissiveTiling < string UIName = "SurfaceTransmissiveTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
int UV0UVSet < string UIName = "UV0UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int UV1UVSet < string UIName = "UV1UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int UV2UVSet < string UIName = "UV2UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
int UV3UVSet < string UIName = "UV3UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
int VariantConstant_DayReflectiveSurfaceColour < string UIName = "VariantConstant_DayReflectiveSurfaceColour"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Emissive < string UIName = "VariantConstant_Emissive"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_FrameTex < string UIName = "VariantConstant_FrameTex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_InteriorAtlas < string UIName = "VariantConstant_InteriorAtlas"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_RoughnessTex < string UIName = "VariantConstant_RoughnessTex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Specular < string UIName = "VariantConstant_Specular"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_SurfaceDiff < string UIName = "VariantConstant_SurfaceDiff"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_UpperFloor < string UIName = "VariantConstant_UpperFloor"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_VariationTinting < string UIName = "VariantConstant_VariationTinting"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
bool Variation000FullColor < string UIName = "Variation000FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation000VariationIndex < string UIName = "Variation000VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
bool Variation01FullColor < string UIName = "Variation01FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation01VariationIndex < string UIName = "Variation01VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
bool Variation0FullColor < string UIName = "Variation0FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation0VariationIndex < string UIName = "Variation0VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
bool Variation10FullColor < string UIName = "Variation10FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation10VariationIndex < string UIName = "Variation10VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
float Window_Darkening_floatVal < string UIName = "Window_Darkening_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.75 ;
float4 Window_ReflectionTiling < string UIName = "Window_ReflectionTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float Window_RoughnessFloat_floatVal < string UIName = "Window_RoughnessFloat_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.02 ;
float WindowNormalSpecPower < string UIName = "WindowNormalSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 WindowNormalTiling < string UIName = "WindowNormalTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define DayReflectiveSurfaceColourPickerColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 DayReflectiveSurfaceColourPickerColorParam : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Room_CountXYVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 Room_CountXYVector4 : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Room_DepthXYZWVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2]))
	#else
	float4 Room_DepthXYZWVector4 : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Room_WidthXYZWVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3]))
	#else
	float4 Room_WidthXYZWVector4 : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Surface_TransColorColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4]))
	#else
	float4 Surface_TransColorColorParam : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define SurfaceDiffuseTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].xy))
	#else
	float2 SurfaceDiffuseTiling : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define FrameDiffuseTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].zw))
	#else
	float2 FrameDiffuseTiling : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define WindowNormalTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].xy))
	#else
	float2 WindowNormalTiling : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define FrameRoughnessTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].zw))
	#else
	float2 FrameRoughnessTiling : packoffset(c6.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Window_ReflectionTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].xy))
	#else
	float2 Window_ReflectionTiling : packoffset(c7.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define SurfaceTransmissiveTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].zw))
	#else
	float2 SurfaceTransmissiveTiling : packoffset(c7.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define FadeDistance_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].x)
	#else
	float FadeDistance_floatVal : packoffset(c8.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define FadeStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].y)
	#else
	float FadeStart_floatVal : packoffset(c8.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Window_Darkening_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].z)
	#else
	float Window_Darkening_floatVal : packoffset(c8.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define RoughnessOverride_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].w)
	#else
	float RoughnessOverride_floatVal : packoffset(c8.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Window_RoughnessFloat_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].x)
	#else
	float Window_RoughnessFloat_floatVal : packoffset(c9.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define EmissiveEV_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].y)
	#else
	float EmissiveEV_floatVal : packoffset(c9.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].z)
	#else
	float LightSwitchOnStart_floatVal : packoffset(c9.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnEnd_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].w)
	#else
	float LightSwitchOnEnd_floatVal : packoffset(c9.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Emissive ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].x)))
	#else
	int VariantConstant_Emissive : packoffset(c10.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_SurfaceDiff ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].y)))
	#else
	int VariantConstant_SurfaceDiff : packoffset(c10.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_FrameTex ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].z)))
	#else
	int VariantConstant_FrameTex : packoffset(c10.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_RoughnessTex ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].w)))
	#else
	int VariantConstant_RoughnessTex : packoffset(c10.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_InteriorAtlas ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].x)))
	#else
	int VariantConstant_InteriorAtlas : packoffset(c11.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UpperFloor ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].y)))
	#else
	int VariantConstant_UpperFloor : packoffset(c11.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Specular ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].z)))
	#else
	int VariantConstant_Specular : packoffset(c11.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_VariationTinting ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].w)))
	#else
	int VariantConstant_VariationTinting : packoffset(c11.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_DayReflectiveSurfaceColour ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 12].x)))
	#else
	int VariantConstant_DayReflectiveSurfaceColour : packoffset(c12.x);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UV0UVSet = 0;
static const int UV3UVSet = 3;
static const float2 InteriorDiffuseTiling = float2(1, 1);
static const bool FadeSmoothstepBool = true;
static const bool FadeSmoothstepHardStepBool = false;
static const int UV1UVSet = 1;
static const int UV2UVSet = 2;
static const float WindowNormalSpecPower = 100;
static const bool Variation0FullColor = false;
static const int Variation0VariationIndex = 0;
static const float2 InteriorEmissiveTiling = float2(1, 1);
static const bool Variation01FullColor = false;
static const int Variation01VariationIndex = 1;
static const bool Variation000FullColor = false;
static const int Variation000VariationIndex = 2;
static const bool Variation10FullColor = false;
static const int Variation10VariationIndex = 3;

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStatesSampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(FrameDiffuseTexture, 16);
#else
#define FrameDiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(FrameRoughnessTexture, 17);
#else
#define FrameRoughnessTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(InteriorDiffuseTexture, 18);
#else
#define InteriorDiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(InteriorEmissiveTexture, 19);
#else
#define InteriorEmissiveTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(SurfaceDiffuseTexture, 20);
#else
#define SurfaceDiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(SurfaceTransmissiveTexture, 21);
#else
#define SurfaceTransmissiveTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Window_ReflectionTexture, 22);
#else
#define Window_ReflectionTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(6)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(WindowNormalTexture, 23);
#else
#define WindowNormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(7)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_TerrainTransmissivness 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_LightmapAdditive 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_INPUT_IS_USED_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_SnowSpecTexture 1
#define MATERIAL_HAS_INPUT_SnowAmount 1
#define MATERIAL_HAS_INPUT_FrostAmount 1
#define MATERIAL_HAS_INPUT_TwinkleAmount 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"
#include "InteriorMapping.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:ColorNode, Name:Fresnel_Diffuse
	float4 Fresnel_Diffuse =  float4(0.02121901, 0.02121901, 0.02121901, 1) ;
	float4 Fresnel_DiffuseRed = 0.02121901;
	float4 Fresnel_DiffuseGreen = 0.02121901;
	float4 Fresnel_DiffuseBlue = 0.02121901;
	float4 Fresnel_DiffuseAlpha = 1;
	
	// Type:ColorNode, Name:DayReflectiveSurfaceColourPicker
	float4 DayReflectiveSurfaceColourPicker = DayReflectiveSurfaceColourPickerColorParam;
	float4 DayReflectiveSurfaceColourPickerRed = DayReflectiveSurfaceColourPickerColorParam.rrrr;
	float4 DayReflectiveSurfaceColourPickerGreen = DayReflectiveSurfaceColourPickerColorParam.gggg;
	float4 DayReflectiveSurfaceColourPickerBlue = DayReflectiveSurfaceColourPickerColorParam.bbbb;
	float4 DayReflectiveSurfaceColourPickerAlpha = DayReflectiveSurfaceColourPickerColorParam.aaaa;
	
	// Type:UVNode, Name:UV0
	float4 UV0 = GetTexCoord0(In).xyxy;
	float4 UV0Tangent = GetWorldTangent0(In);
	float4 UV0UCoord = GetTexCoord0(In).xxxx;
	float4 UV0VCoord = GetTexCoord0(In).yyyy;
	
	// Type:Vector4Node, Name:Room_CountXY
	float4 Room_CountXY = Room_CountXYVector4;
	
	// Type:Vector4Node, Name:Vector4
	float4 Vector4 = float4(1, 1, 0, 0) ;
	
	// Type:VariantOnOffNode, Name:InteriorAtlasOnOff0
	#if defined(VARIANTPROPERTY_INTERIORATLAS) && VARIANTPROPERTY_INTERIORATLAS == 1
	float4 InteriorAtlasOnOff0 = Room_CountXY;
	#elif defined(VARIANTPROPERTY_INTERIORATLAS) && VARIANTPROPERTY_INTERIORATLAS == 0
	float4 InteriorAtlasOnOff0 = Vector4;
	#elif !defined(VARIANTPROPERTY_INTERIORATLAS) || VARIANTPROPERTY_INTERIORATLAS == 2
	float4 InteriorAtlasOnOff0;
	[branch]
	if(VariantConstant_InteriorAtlas != 0)
	{
		InteriorAtlasOnOff0 = Room_CountXY;
	}
	else
	{
		InteriorAtlasOnOff0 = Vector4;
	}
	#endif
	
	// Type:Vector4Node, Name:Room_DepthXYZW
	float4 Room_DepthXYZW = Room_DepthXYZWVector4;
	
	// Type:Vector4Node, Name:Flat_Depth
	float4 Flat_Depth = float4(0.999, 0.999, 0.999, 0.999) ;
	
	// Type:ViewDistanceNode, Name:ViewDistance
	float4 ViewDistance = distance(GetWorldPos(In).xyz, g_EyePos.xyz).xxxx;
	// Type:IntNode, Name:One
	float4 One = float4(1, 1, 1, 1) ;
	
	// Type:FloatNode, Name:FadeDistance
	float4 FadeDistance = FadeDistance_floatVal;
	
	// Type:DivideNode, Name:Divide
	float4 Divide = One / FadeDistance;
	
	// Type:FloatNode, Name:FadeStart
	float4 FadeStart = FadeStart_floatVal;
	
	// Type:DivideNode, Name:Divide0
	float4 Divide0 = FadeStart / FadeDistance;
	
	// Type:IntNode, Name:Int0
	float4 Int0 = float4(-1, -1, -1, -1) ;
	
	// Type:MultiplyNode, Name:Multiply00
	float4 Multiply00 = Divide0 * Int0;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd2
	float4 MultiplyAdd2 = ViewDistance * Divide + Multiply00;
	
	// Type:SaturateNode, Name:Saturate0
	float4 Saturate0 = saturate( MultiplyAdd2 ); 
	
	// Type:LerpNode, Name:Lerp3
	float4 Lerp3 = lerp(Room_DepthXYZW, Flat_Depth, Saturate0.x);
	
	// Type:UVNode, Name:UV3
	float4 UV3 = GetTexCoord3(In).xyxy;
	float4 UV3Tangent = GetWorldTangent3(In);
	float4 UV3UCoord = GetTexCoord3(In).xxxx;
	float4 UV3VCoord = GetTexCoord3(In).yyyy;
	
	// Type:IntNode, Name:Int
	float4 Int = float4(1, 1, 1, 1) ;
	
	// Type:VariantOnOffNode, Name:InteriorAtlasOnOff
	#if defined(VARIANTPROPERTY_INTERIORATLAS) && VARIANTPROPERTY_INTERIORATLAS == 1
	float4 InteriorAtlasOnOff = UV3UCoord;
	#elif defined(VARIANTPROPERTY_INTERIORATLAS) && VARIANTPROPERTY_INTERIORATLAS == 0
	float4 InteriorAtlasOnOff = Int;
	#elif !defined(VARIANTPROPERTY_INTERIORATLAS) || VARIANTPROPERTY_INTERIORATLAS == 2
	float4 InteriorAtlasOnOff;
	[branch]
	if(VariantConstant_InteriorAtlas != 0)
	{
		InteriorAtlasOnOff = UV3UCoord;
	}
	else
	{
		InteriorAtlasOnOff = Int;
	}
	#endif
	
	// Type:Vector4Node, Name:Room_WidthXYZW
	float4 Room_WidthXYZW = Room_WidthXYZWVector4;
	
	// Type:InteriorMappingNode, Name:InteriorMappingUV
	float4 InteriorMappingUV = InteriorMap(UV0, GetTangentViewDir(In), InteriorAtlasOnOff0, Lerp3, Room_WidthXYZW, InteriorAtlasOnOff);
	
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStatesSampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:InteriorDiffuse
	float4 InteriorDiffuse = InteriorDiffuseTexture.Sample(SamplerStatesSampler, InteriorMappingUV.xy * InteriorDiffuseTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 InteriorDiffuseMip = GetDebugMipColour(InteriorDiffuseTexture, SamplerStatesSampler, InteriorMappingUV.xy * InteriorDiffuseTiling);
	#else
	float4 InteriorDiffuseMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 InteriorDiffuseAlpha = InteriorDiffuse.aaaa;
	float4 InteriorDiffuseRed = InteriorDiffuse.rrrr;
	float4 InteriorDiffuseGreen = InteriorDiffuse.gggg;
	float4 InteriorDiffuseBlue = InteriorDiffuse.bbbb;
	Texture2D InteriorDiffuseRef = InteriorDiffuseTexture;
	
	// Type:FloatNode, Name:FadeStart0
	float4 FadeStart0 = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:FloatNode, Name:FadeEnd
	float4 FadeEnd = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:LightSwitchOnTimeNode, Name:FadeStartTime
	float4 FadeStartTime = g_LightSwitchOnTime;
	
	// Type:StepNode, Name:FadeSmoothstep
	float4 FadeSmoothstep = smoothstep( FadeStart0, FadeEnd, FadeStartTime );
	
	// Type:LerpNode, Name:Lerp10
	float4 Lerp10 = lerp(DayReflectiveSurfaceColourPicker, InteriorDiffuse, FadeSmoothstep.x);
	
	// Type:VariantOnOffNode, Name:DayReflectiveSurfaceColour_OnOff10
	#if defined(VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR) && VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR == 1
	float4 DayReflectiveSurfaceColour_OnOff10 = Lerp10;
	#elif defined(VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR) && VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR == 0
	float4 DayReflectiveSurfaceColour_OnOff10 = InteriorDiffuse;
	#elif !defined(VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR) || VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR == 2
	float4 DayReflectiveSurfaceColour_OnOff10;
	[branch]
	if(VariantConstant_DayReflectiveSurfaceColour != 0)
	{
		DayReflectiveSurfaceColour_OnOff10 = Lerp10;
	}
	else
	{
		DayReflectiveSurfaceColour_OnOff10 = InteriorDiffuse;
	}
	#endif
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = Fresnel_Diffuse * InteriorDiffuse;
	
	// Type:FloatNode, Name:Window_Darkening
	float4 Window_Darkening = Window_Darkening_floatVal;
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(InteriorDiffuse, Multiply1, Window_Darkening.x);
	
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:LerpNode, Name:Lerp1
	float4 Lerp1 = lerp(DayReflectiveSurfaceColour_OnOff10, Lerp0, VertexColorAlpha.x);
	
	// Type:UVNode, Name:UV1
	float4 UV1 = GetTexCoord1(In).xyxy;
	float4 UV1Tangent = GetWorldTangent1(In);
	float4 UV1UCoord = GetTexCoord1(In).xxxx;
	float4 UV1VCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:SurfaceDiffuse
	float4 SurfaceDiffuse = SurfaceDiffuseTexture.Sample(SamplerStatesSampler, UV1.xy * SurfaceDiffuseTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 SurfaceDiffuseMip = GetDebugMipColour(SurfaceDiffuseTexture, SamplerStatesSampler, UV1.xy * SurfaceDiffuseTiling);
	#else
	float4 SurfaceDiffuseMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 SurfaceDiffuseAlpha = SurfaceDiffuse.aaaa;
	float4 SurfaceDiffuseRed = SurfaceDiffuse.rrrr;
	float4 SurfaceDiffuseGreen = SurfaceDiffuse.gggg;
	float4 SurfaceDiffuseBlue = SurfaceDiffuse.bbbb;
	Texture2D SurfaceDiffuseRef = SurfaceDiffuseTexture;
	
	// Type:LerpNode, Name:AddWindowDetails
	float4 AddWindowDetails = lerp(Lerp1, SurfaceDiffuse, SurfaceDiffuseAlpha.x);
	
	// Type:VariantOnOffNode, Name:SurfaceDiffOnOff
	#if defined(VARIANTPROPERTY_SURFACEDIFF) && VARIANTPROPERTY_SURFACEDIFF == 1
	float4 SurfaceDiffOnOff = AddWindowDetails;
	#elif defined(VARIANTPROPERTY_SURFACEDIFF) && VARIANTPROPERTY_SURFACEDIFF == 0
	float4 SurfaceDiffOnOff = Lerp1;
	#elif !defined(VARIANTPROPERTY_SURFACEDIFF) || VARIANTPROPERTY_SURFACEDIFF == 2
	float4 SurfaceDiffOnOff;
	[branch]
	if(VariantConstant_SurfaceDiff != 0)
	{
		SurfaceDiffOnOff = AddWindowDetails;
	}
	else
	{
		SurfaceDiffOnOff = Lerp1;
	}
	#endif
	
	// Type:ViewVectorNode, Name:ViewVector
	float4 ViewVector = float4(GetViewVector(), 0);
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:DotNode, Name:Dot
	float4 Dot = dot(ViewVector, WorldNormal);
	
	// Type:FloatNode, Name:Fresnel_Scale
	float4 Fresnel_Scale = float4(1.8, 1.8, 1.8, 1.8);
	
	// Type:FloatNode, Name:Fresnel_Offset
	float4 Fresnel_Offset = float4(-0.5, -0.5, -0.5, -0.5);
	
	// Type:MultiplyAddNode, Name:MultiplyAdd
	float4 MultiplyAdd = Dot * Fresnel_Scale + Fresnel_Offset;
	
	// Type:SaturateNode, Name:Saturate
	float4 Saturate = saturate( MultiplyAdd ); 
	
	// Type:LerpNode, Name:AddFresnel
	float4 AddFresnel = lerp(Fresnel_Diffuse, SurfaceDiffOnOff, Saturate.x);
	
	// Type:UVNode, Name:UV2
	float4 UV2 = GetTexCoord2(In).xyxy;
	float4 UV2Tangent = GetWorldTangent2(In);
	float4 UV2UCoord = GetTexCoord2(In).xxxx;
	float4 UV2VCoord = GetTexCoord2(In).yyyy;
	
	// Type:TextureNode, Name:FrameDiffuse
	float4 FrameDiffuse = FrameDiffuseTexture.Sample(g_samplerLinearWrap, UV2.xy * FrameDiffuseTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 FrameDiffuseMip = GetDebugMipColour(FrameDiffuseTexture, g_samplerLinearWrap, UV2.xy * FrameDiffuseTiling);
	#else
	float4 FrameDiffuseMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 FrameDiffuseAlpha = FrameDiffuse.aaaa;
	float4 FrameDiffuseRed = FrameDiffuse.rrrr;
	float4 FrameDiffuseGreen = FrameDiffuse.gggg;
	float4 FrameDiffuseBlue = FrameDiffuse.bbbb;
	Texture2D FrameDiffuseRef = FrameDiffuseTexture;
	
	// Type:LerpNode, Name:AddFrameDiff
	float4 AddFrameDiff = lerp(AddFresnel, FrameDiffuse, FrameDiffuseAlpha.x);
	
	// Type:VariantOnOffNode, Name:FrameTex_OnOff
	#if defined(VARIANTPROPERTY_FRAMETEX) && VARIANTPROPERTY_FRAMETEX == 1
	float4 FrameTex_OnOff = AddFrameDiff;
	#elif defined(VARIANTPROPERTY_FRAMETEX) && VARIANTPROPERTY_FRAMETEX == 0
	float4 FrameTex_OnOff = AddFresnel;
	#elif !defined(VARIANTPROPERTY_FRAMETEX) || VARIANTPROPERTY_FRAMETEX == 2
	float4 FrameTex_OnOff;
	[branch]
	if(VariantConstant_FrameTex != 0)
	{
		FrameTex_OnOff = AddFrameDiff;
	}
	else
	{
		FrameTex_OnOff = AddFresnel;
	}
	#endif
	
	// Type:NormalMapNode, Name:WindowNormal
	float4 textureLookup_WindowNormal = WindowNormalTexture.Sample(g_samplerLinearWrap, UV2.xy * WindowNormalTiling);
	#ifdef _MAX_
	textureLookup_WindowNormal.xyz = pow(textureLookup_WindowNormal.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_WindowNormal = (2.0f * textureLookup_WindowNormal.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 WindowNormalGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_WindowNormal, WindowNormalSpecPower);
	float4 WindowNormalAlpha = textureLookup_WindowNormal.aaaa;
	float4 WindowNormalRed = textureLookup_WindowNormal.rrrr;
	float4 WindowNormalGreen = textureLookup_WindowNormal.gggg;
	float4 WindowNormalBlue = textureLookup_WindowNormal.bbbb;
	tangentSpaceNormal_WindowNormal.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_WindowNormal.z = sqrt(saturate(1 - tangentSpaceNormal_WindowNormal.x*tangentSpaceNormal_WindowNormal.x - tangentSpaceNormal_WindowNormal.y*tangentSpaceNormal_WindowNormal.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_WindowNormal.xy *= g_GlobalNormalScale;
	#endif
	float4 WindowNormal = float4(normalize(mul(tangentSpaceNormal_WindowNormal, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 WindowNormal = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:Vector4Node, Name:Glass_F0
	float4 Glass_F0 = float4(0.04, 0.04, 0.04, 1) ;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Glass_F0 * VertexColorAlpha;
	
	// Type:FloatNode, Name:RoughnessOverride
	float4 RoughnessOverride = RoughnessOverride_floatVal;
	
	// Type:TextureNode, Name:FrameRoughness
	float4 FrameRoughness = FrameRoughnessTexture.Sample(g_samplerLinearWrap, UV2.xy * FrameRoughnessTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 FrameRoughnessMip = GetDebugMipColour(FrameRoughnessTexture, g_samplerLinearWrap, UV2.xy * FrameRoughnessTiling);
	#else
	float4 FrameRoughnessMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 FrameRoughnessAlpha = FrameRoughness.aaaa;
	float4 FrameRoughnessRed = FrameRoughness.rrrr;
	float4 FrameRoughnessGreen = FrameRoughness.gggg;
	float4 FrameRoughnessBlue = FrameRoughness.bbbb;
	Texture2D FrameRoughnessRef = FrameRoughnessTexture;
	
	// Type:OneMinusNode, Name:OneMinus
	float4 OneMinus = 1 - VertexColorAlpha;
	
	// Type:TextureNode, Name:Window_Reflection
	float4 Window_Reflection = Window_ReflectionTexture.Sample(SamplerStatesSampler, UV0.xy * Window_ReflectionTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Window_ReflectionMip = GetDebugMipColour(Window_ReflectionTexture, SamplerStatesSampler, UV0.xy * Window_ReflectionTiling);
	#else
	float4 Window_ReflectionMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Window_ReflectionAlpha = Window_Reflection.aaaa;
	float4 Window_ReflectionRed = Window_Reflection.rrrr;
	float4 Window_ReflectionGreen = Window_Reflection.gggg;
	float4 Window_ReflectionBlue = Window_Reflection.bbbb;
	Texture2D Window_ReflectionRef = Window_ReflectionTexture;
	
	// Type:FloatNode, Name:Window_RoughnessFloat
	float4 Window_RoughnessFloat = Window_RoughnessFloat_floatVal;
	
	// Type:VariantOnOffNode, Name:RoughnessTexOnOff
	#if defined(VARIANTPROPERTY_ROUGHNESSTEX) && VARIANTPROPERTY_ROUGHNESSTEX == 1
	float4 RoughnessTexOnOff = Window_ReflectionRed;
	#elif defined(VARIANTPROPERTY_ROUGHNESSTEX) && VARIANTPROPERTY_ROUGHNESSTEX == 0
	float4 RoughnessTexOnOff = Window_RoughnessFloat;
	#elif !defined(VARIANTPROPERTY_ROUGHNESSTEX) || VARIANTPROPERTY_ROUGHNESSTEX == 2
	float4 RoughnessTexOnOff;
	[branch]
	if(VariantConstant_RoughnessTex != 0)
	{
		RoughnessTexOnOff = Window_ReflectionRed;
	}
	else
	{
		RoughnessTexOnOff = Window_RoughnessFloat;
	}
	#endif
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(OneMinus, RoughnessTexOnOff, VertexColorAlpha.x);
	
	// Type:VariantOnOffNode, Name:FrameTex_OnOff0
	#if defined(VARIANTPROPERTY_FRAMETEX) && VARIANTPROPERTY_FRAMETEX == 1
	float4 FrameTex_OnOff0 = FrameRoughnessRed;
	#elif defined(VARIANTPROPERTY_FRAMETEX) && VARIANTPROPERTY_FRAMETEX == 0
	float4 FrameTex_OnOff0 = Lerp;
	#elif !defined(VARIANTPROPERTY_FRAMETEX) || VARIANTPROPERTY_FRAMETEX == 2
	float4 FrameTex_OnOff0;
	[branch]
	if(VariantConstant_FrameTex != 0)
	{
		FrameTex_OnOff0 = FrameRoughnessRed;
	}
	else
	{
		FrameTex_OnOff0 = Lerp;
	}
	#endif
	
	// Type:VariantOnOffNode, Name:DayReflectiveSurfaceColour_OnOff1
	#if defined(VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR) && VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR == 1
	float4 DayReflectiveSurfaceColour_OnOff1 = RoughnessOverride;
	#elif defined(VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR) && VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR == 0
	float4 DayReflectiveSurfaceColour_OnOff1 = FrameTex_OnOff0;
	#elif !defined(VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR) || VARIANTPROPERTY_DAYREFLECTIVESURFACECOLOUR == 2
	float4 DayReflectiveSurfaceColour_OnOff1;
	[branch]
	if(VariantConstant_DayReflectiveSurfaceColour != 0)
	{
		DayReflectiveSurfaceColour_OnOff1 = RoughnessOverride;
	}
	else
	{
		DayReflectiveSurfaceColour_OnOff1 = FrameTex_OnOff0;
	}
	#endif
	
	// Type:VariationNode, Name:Variation0
	float4 Variation0 = GetInstanceVariation(In)[0];
	
	// Type:IntNode, Name:Int1
	float4 Int1 = float4(1000, 1000, 1000, 1000) ;
	
	// Type:MaxSwitch, Name:MaxSwitch
	    float4 MaxSwitch = Variation0;
	#ifdef _MAX_
	    MaxSwitch = Int1;
	#endif
	
	// Type:ExposureValuesGroupNode, Name:EmissiveEV
	float4 EmissiveEV = EmissiveEV_floatVal;
	
	// Type:TextureNode, Name:InteriorEmissive
	float4 InteriorEmissive = InteriorEmissiveTexture.Sample(SamplerStatesSampler, InteriorMappingUV.xy * InteriorEmissiveTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 InteriorEmissiveMip = GetDebugMipColour(InteriorEmissiveTexture, SamplerStatesSampler, InteriorMappingUV.xy * InteriorEmissiveTiling);
	#else
	float4 InteriorEmissiveMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 InteriorEmissiveAlpha = InteriorEmissive.aaaa;
	float4 InteriorEmissiveRed = InteriorEmissive.rrrr;
	float4 InteriorEmissiveGreen = InteriorEmissive.gggg;
	float4 InteriorEmissiveBlue = InteriorEmissive.bbbb;
	Texture2D InteriorEmissiveRef = InteriorEmissiveTexture;
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = InteriorEmissive * VertexColor;
	
	// Type:VariationNode, Name:Variation01
	float4 Variation01 = GetInstanceVariation(In)[1];
	
	// Type:VariationNode, Name:Variation000
	float4 Variation000 = GetInstanceVariation(In)[2];
	
	// Type:VariationNode, Name:Variation10
	float4 Variation10 = GetInstanceVariation(In)[3];
	
	// Type:VectorMake, Name:VectorMake00
	float4 VectorMake00 = float4(Variation01.x, Variation000.y, Variation10.z, 0);
	
	// Type:FloatNode, Name:Float010
	float4 Float010 = float4(2.2, 2.2, 2.2, 2.2);
	
	// Type:PowNode, Name:Pow0
	float4 Pow0 = pow( VectorMake00, Float010 );
	
	// Type:ColorNode, Name:Color1
	float4 Color1 =  float4(1, 1, 1, 1) ;
	float4 Color1Red = 1;
	float4 Color1Green = 1;
	float4 Color1Blue = 1;
	float4 Color1Alpha = 1;
	
	// Type:VariantOnOffNode, Name:VariationTintingOnOff
	#if defined(VARIANTPROPERTY_VARIATIONTINTING) && VARIANTPROPERTY_VARIATIONTINTING == 1
	float4 VariationTintingOnOff = Pow0;
	#elif defined(VARIANTPROPERTY_VARIATIONTINTING) && VARIANTPROPERTY_VARIATIONTINTING == 0
	float4 VariationTintingOnOff = Color1;
	#elif !defined(VARIANTPROPERTY_VARIATIONTINTING) || VARIANTPROPERTY_VARIATIONTINTING == 2
	float4 VariationTintingOnOff;
	[branch]
	if(VariantConstant_VariationTinting != 0)
	{
		VariationTintingOnOff = Pow0;
	}
	else
	{
		VariationTintingOnOff = Color1;
	}
	#endif
	
	// Type:MultiplyNode, Name:Multiply20
	float4 Multiply20 = Multiply2 * VariationTintingOnOff;
	
	// Type:ColorNode, Name:Black_Color
	float4 Black_Color =  float4(0, 0, 0, 1) ;
	float4 Black_ColorRed = 0;
	float4 Black_ColorGreen = 0;
	float4 Black_ColorBlue = 0;
	float4 Black_ColorAlpha = 1;
	
	// Type:ColorNode, Name:Surface_TransColor
	float4 Surface_TransColor = Surface_TransColorColorParam;
	float4 Surface_TransColorRed = Surface_TransColorColorParam.rrrr;
	float4 Surface_TransColorGreen = Surface_TransColorColorParam.gggg;
	float4 Surface_TransColorBlue = Surface_TransColorColorParam.bbbb;
	float4 Surface_TransColorAlpha = Surface_TransColorColorParam.aaaa;
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = VertexColor * Surface_TransColor;
	
	// Type:TextureNode, Name:SurfaceTransmissive
	float4 SurfaceTransmissive = SurfaceTransmissiveTexture.Sample(g_samplerLinearWrap, UV1.xy * SurfaceTransmissiveTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 SurfaceTransmissiveMip = GetDebugMipColour(SurfaceTransmissiveTexture, g_samplerLinearWrap, UV1.xy * SurfaceTransmissiveTiling);
	#else
	float4 SurfaceTransmissiveMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 SurfaceTransmissiveAlpha = SurfaceTransmissive.aaaa;
	float4 SurfaceTransmissiveRed = SurfaceTransmissive.rrrr;
	float4 SurfaceTransmissiveGreen = SurfaceTransmissive.gggg;
	float4 SurfaceTransmissiveBlue = SurfaceTransmissive.bbbb;
	Texture2D SurfaceTransmissiveRef = SurfaceTransmissiveTexture;
	
	// Type:LerpNode, Name:Lerp2
	float4 Lerp2 = lerp(Black_Color, Multiply3, SurfaceTransmissiveRed.x);
	
	// Type:LerpNode, Name:AddWindowDetails0
	float4 AddWindowDetails0 = lerp(Multiply20, Lerp2, SurfaceDiffuseAlpha.x);
	
	// Type:VariantOnOffNode, Name:SurfaceDiffOnOff0
	#if defined(VARIANTPROPERTY_SURFACEDIFF) && VARIANTPROPERTY_SURFACEDIFF == 1
	float4 SurfaceDiffOnOff0 = AddWindowDetails0;
	#elif defined(VARIANTPROPERTY_SURFACEDIFF) && VARIANTPROPERTY_SURFACEDIFF == 0
	float4 SurfaceDiffOnOff0 = Multiply20;
	#elif !defined(VARIANTPROPERTY_SURFACEDIFF) || VARIANTPROPERTY_SURFACEDIFF == 2
	float4 SurfaceDiffOnOff0;
	[branch]
	if(VariantConstant_SurfaceDiff != 0)
	{
		SurfaceDiffOnOff0 = AddWindowDetails0;
	}
	else
	{
		SurfaceDiffOnOff0 = Multiply20;
	}
	#endif
	
	// Type:LerpNode, Name:AddFrameEmis
	float4 AddFrameEmis = lerp(SurfaceDiffOnOff0, Black_Color, FrameDiffuseAlpha.x);
	
	// Type:VariantOnOffNode, Name:FrameTex_OnOff000
	#if defined(VARIANTPROPERTY_FRAMETEX) && VARIANTPROPERTY_FRAMETEX == 1
	float4 FrameTex_OnOff000 = AddFrameEmis;
	#elif defined(VARIANTPROPERTY_FRAMETEX) && VARIANTPROPERTY_FRAMETEX == 0
	float4 FrameTex_OnOff000 = SurfaceDiffOnOff0;
	#elif !defined(VARIANTPROPERTY_FRAMETEX) || VARIANTPROPERTY_FRAMETEX == 2
	float4 FrameTex_OnOff000;
	[branch]
	if(VariantConstant_FrameTex != 0)
	{
		FrameTex_OnOff000 = AddFrameEmis;
	}
	else
	{
		FrameTex_OnOff000 = SurfaceDiffOnOff0;
	}
	#endif
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = EmissiveEV * FrameTex_OnOff000;
	
	// Type:MultiplyNode, Name:Multiply4
	float4 Multiply4 = MaxSwitch * Multiply0;
	
	// Type:Vector4Node, Name:Zero
	float4 Zero = float4(0, 0, 0, 1) ;
	
	// Type:VariantOnOffNode, Name:EmissiveOnOff
	#if defined(VARIANTPROPERTY_EMISSIVE) && VARIANTPROPERTY_EMISSIVE == 1
	float4 EmissiveOnOff = Multiply4;
	#elif defined(VARIANTPROPERTY_EMISSIVE) && VARIANTPROPERTY_EMISSIVE == 0
	float4 EmissiveOnOff = Zero;
	#elif !defined(VARIANTPROPERTY_EMISSIVE) || VARIANTPROPERTY_EMISSIVE == 2
	float4 EmissiveOnOff;
	[branch]
	if(VariantConstant_Emissive != 0)
	{
		EmissiveOnOff = Multiply4;
	}
	else
	{
		EmissiveOnOff = Zero;
	}
	#endif
	
	// Type:FloatNode, Name:LightSwitchOnStart
	float4 LightSwitchOnStart = LightSwitchOnStart_floatVal;
	
	// Type:FloatNode, Name:LightSwitchOnEnd
	float4 LightSwitchOnEnd = LightSwitchOnEnd_floatVal;
	
	// Type:FloatNode, Name:SpecularOn
	float4 SpecularOn = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:SpecularOff
	float4 SpecularOff = float4(0, 0, 0, 0);
	
	// Type:VariantOnOffNode, Name:SpecularVariantOnOff
	#if defined(VARIANTPROPERTY_SPECULAR) && VARIANTPROPERTY_SPECULAR == 1
	float4 SpecularVariantOnOff = SpecularOn;
	#elif defined(VARIANTPROPERTY_SPECULAR) && VARIANTPROPERTY_SPECULAR == 0
	float4 SpecularVariantOnOff = SpecularOff;
	#elif !defined(VARIANTPROPERTY_SPECULAR) || VARIANTPROPERTY_SPECULAR == 2
	float4 SpecularVariantOnOff;
	[branch]
	if(VariantConstant_Specular != 0)
	{
		SpecularVariantOnOff = SpecularOn;
	}
	else
	{
		SpecularVariantOnOff = SpecularOff;
	}
	#endif
	
	output.BaseColor = FrameTex_OnOff;
	output.Normal = WindowNormal;
	output.F0 = Multiply;
	output.Roughness = DayReflectiveSurfaceColour_OnOff1;
	output.Emissive = EmissiveOnOff;
	output.LightSwitchOnStart = LightSwitchOnStart;
	output.LightSwitchOnEnd = LightSwitchOnEnd;
	output.SpecularScale = SpecularVariantOnOff;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\InteriorMappingVertex.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\TrackDayOptimisedLightScenario.hlsl"