#include "LightScenarios\Inc\CubemapLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 AO_LightingTiling < string UIName = "AO_LightingTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float DefaultGloss_floatVal < string UIName = "DefaultGloss_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 DiffuseTiling < string UIName = "DiffuseTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 Direct_Lighting0Tiling < string UIName = "Direct_Lighting0Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
bool DisableNormal_Bool < string UIName = "DisableNormal_Bool"; string UIWidget = "Checkbox"; > = 0;
bool DisableSpecular_Bool < string UIName = "DisableSpecular_Bool"; string UIWidget = "Checkbox"; > = 0;
float4 F0AMax_F0Value < string UIName = "F0AMax_F0Value"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.04, 0.04, 0.04, 1 );
float4 F0AMin_F0Value < string UIName = "F0AMin_F0Value"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.04, 0.04, 0.04, 1 );
float GlossAMax_floatVal < string UIName = "GlossAMax_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float GlossAMin_floatVal < string UIName = "GlossAMin_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 GlossTiling < string UIName = "GlossTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 Indirect_LightingTiling < string UIName = "Indirect_LightingTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 NormalMapTiling < string UIName = "NormalMapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
int TangentToWorldSpaceUVSet < string UIName = "TangentToWorldSpaceUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int UV0UVSet < string UIName = "UV0UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
int UV1UVSet < string UIName = "UV1UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define F0AMin_F0Value ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 F0AMin_F0Value : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F0AMax_F0Value ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 F0AMax_F0Value : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DiffuseTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].xy))
	#else
	float2 DiffuseTiling : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define NormalMapTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].zw))
	#else
	float2 NormalMapTiling : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GlossTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].xy))
	#else
	float2 GlossTiling : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DefaultGloss_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float DefaultGloss_floatVal : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GlossAMin_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].y)
	#else
	float GlossAMin_floatVal : packoffset(c4.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GlossAMax_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].z)
	#else
	float GlossAMax_floatVal : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DisableNormal_Bool ((bool)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x) != 0.0f)
	#else
	bool DisableNormal_Bool : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DisableSpecular_Bool ((bool)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y) != 0.0f)
	#else
	bool DisableSpecular_Bool : packoffset(c5.y);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UVUVSet = 0;
static const int UV1UVSet = 1;
static const int TangentToWorldSpaceUVSet = 0;
static const int UV0UVSet = 2;
static const float2 Indirect_LightingTiling = float2(1, 1);
static const float2 AO_LightingTiling = float2(1, 1);
static const float2 Direct_Lighting0Tiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStates_Sampler, 12);
DECLARE_SAMPLERSTATE(SamplerStates0Sampler, 13);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(AO_LightingTexture, 16);
#else
#define AO_LightingTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(DiffuseTexture, 17);
#else
#define DiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Direct_Lighting0Texture, 18);
#else
#define Direct_Lighting0Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(GlossTexture, 19);
#else
#define GlossTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Indirect_LightingTexture, 20);
#else
#define Indirect_LightingTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapTexture, 21);
#else
#define NormalMapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_TerrainTransmissivness 1
#define MATERIAL_HAS_INPUT_Glossiness 1
#define MATERIAL_INPUT_IS_USED_Glossiness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_INPUT_IS_USED_Lightmap 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_ReflectionScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_TerrainPerturb 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhongRTReflection.hlsl"
#include "NormalMapping.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord0(In).xyxy;
	float4 UVTangent = GetWorldTangent0(In);
	float4 UVUCoord = GetTexCoord0(In).xxxx;
	float4 UVVCoord = GetTexCoord0(In).yyyy;
	
	// Type:SamplerStatesNode, Name:SamplerStates0
	SamplerState SamplerStates0 = SamplerStates0Sampler;
	float4 SamplerStates0Preview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:Diffuse
	float4 Diffuse = DiffuseTexture.Sample(SamplerStates0Sampler, UV.xy * DiffuseTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 DiffuseMip = GetDebugMipColour(DiffuseTexture, SamplerStates0Sampler, UV.xy * DiffuseTiling);
	#else
	float4 DiffuseMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 DiffuseAlpha = Diffuse.aaaa;
	float4 DiffuseRed = Diffuse.rrrr;
	float4 DiffuseGreen = Diffuse.gggg;
	float4 DiffuseBlue = Diffuse.bbbb;
	Texture2D DiffuseRef = DiffuseTexture;
	
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:UVNode, Name:UV1
	float4 UV1 = GetTexCoord1(In).xyxy;
	float4 UV1Tangent = GetWorldTangent1(In);
	float4 UV1UCoord = GetTexCoord1(In).xxxx;
	float4 UV1VCoord = GetTexCoord1(In).yyyy;
	
	// Type:NormalMapOnlyNode, Name:NormalMap
	float4 NormalMap = NormalMapTexture.Sample(g_samplerLinearWrap, UV1.xy * NormalMapTiling);
	#ifdef _MAX_
	NormalMap.xyz = pow(NormalMap.xyz, 1 / 2.2);
	#endif
	float4 NormalMapGlossiness = NormalMap.wwww;
	float4 NormalMapRed = NormalMap.rrrr;
	float4 NormalMapGreen = NormalMap.gggg;
	float4 NormalMapBlue = NormalMap.bbbb;
	float4 NormalMapAlpha = NormalMap.aaaa;
	NormalMap = DecodeNormalMap(NormalMap);
	
	// Type:TangentToWorldSpaceNode, Name:TangentToWorldSpace
	float4 TangentToWorldSpace = float4(normalize(mul(NormalMap, float3x3(UV1Tangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UV1Tangent.xyz) * UV1Tangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	
	// Type:OnOffNode, Name:DisableNormal
	float4 DisableNormal;
	float4 DisableNormalOutput2;
	[branch]
	if(DisableNormal_Bool == true)
	{
		DisableNormal = WorldNormal;
		DisableNormalOutput2 = float4(1, 1, 1, 1);
	}
	else
	{
		DisableNormal = TangentToWorldSpace;
		DisableNormalOutput2 = float4(1, 1, 1, 1);
	}
	
	// Type:LerpNode, Name:Lerp1
	float4 Lerp1 = lerp(DisableNormal, WorldNormal, DiffuseAlpha.x);
	
	// Type:F0ValuesNode, Name:F0AMin
	float4 F0AMin = F0AMin_F0Value;
	
	// Type:F0ValuesNode, Name:F0AMax
	float4 F0AMax = F0AMax_F0Value;
	
	// Type:AddNode, Name:AddF0
	float4 AddF0 = F0AMin + F0AMax;
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(2, 2, 2, 2);
	
	// Type:DivideNode, Name:Divide1
	float4 Divide1 = AddF0 / Float1;
	
	// Type:FloatNode, Name:DefaultGloss
	float4 DefaultGloss = DefaultGloss_floatVal;
	
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStates_Sampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:Gloss
	float4 Gloss = GlossTexture.Sample(SamplerStates_Sampler, UV1.xy * GlossTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 GlossMip = GetDebugMipColour(GlossTexture, SamplerStates_Sampler, UV1.xy * GlossTiling);
	#else
	float4 GlossMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 GlossAlpha = Gloss.aaaa;
	float4 GlossRed = Gloss.rrrr;
	float4 GlossGreen = Gloss.gggg;
	float4 GlossBlue = Gloss.bbbb;
	Texture2D GlossRef = GlossTexture;
	
	// Type:LerpNode, Name:Lerp2
	float4 Lerp2 = lerp(DefaultGloss, GlossRed, DiffuseAlpha.x);
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(F0AMin, F0AMax, Lerp2.x);
	
	// Type:FloatNode, Name:GlossAMin
	float4 GlossAMin = GlossAMin_floatVal;
	
	// Type:FloatNode, Name:GlossAMax
	float4 GlossAMax = GlossAMax_floatVal;
	
	// Type:AddNode, Name:AddGloss
	float4 AddGloss = GlossAMin + GlossAMax;
	
	// Type:DivideNode, Name:Divide0
	float4 Divide0 = AddGloss / Float1;
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(GlossAMin, GlossAMax, Lerp2.x);
	
	// Type:SwizzleNode, Name:Swizzle
	float4 Swizzle = Lerp0.xxxx;
	
	// Type:OnOffNode, Name:DisableSpecular
	float4 DisableSpecular;
	float4 DisableSpecularOutput2;
	[branch]
	if(DisableSpecular_Bool == true)
	{
		DisableSpecular = Divide1;
		DisableSpecularOutput2 = Divide0;
	}
	else
	{
		DisableSpecular = Lerp;
		DisableSpecularOutput2 = Swizzle;
	}
	
	// Type:UVNode, Name:UV0
	float4 UV0 = GetTexCoord2(In).xyxy;
	float4 UV0Tangent = GetWorldTangent2(In);
	float4 UV0UCoord = GetTexCoord2(In).xxxx;
	float4 UV0VCoord = GetTexCoord2(In).yyyy;
	
	// Type:TextureNode, Name:Indirect_Lighting
	float4 Indirect_Lighting = Indirect_LightingTexture.Sample(g_samplerLinearWrap, UV0.xy * Indirect_LightingTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Indirect_LightingMip = GetDebugMipColour(Indirect_LightingTexture, g_samplerLinearWrap, UV0.xy * Indirect_LightingTiling);
	#else
	float4 Indirect_LightingMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Indirect_LightingAlpha = Indirect_Lighting.aaaa;
	float4 Indirect_LightingRed = Indirect_Lighting.rrrr;
	float4 Indirect_LightingGreen = Indirect_Lighting.gggg;
	float4 Indirect_LightingBlue = Indirect_Lighting.bbbb;
	Texture2D Indirect_LightingRef = Indirect_LightingTexture;
	
	// Type:TextureNode, Name:AO_Lighting
	float4 AO_Lighting = AO_LightingTexture.Sample(g_samplerLinearWrap, UV0.xy * AO_LightingTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AO_LightingMip = GetDebugMipColour(AO_LightingTexture, g_samplerLinearWrap, UV0.xy * AO_LightingTiling);
	#else
	float4 AO_LightingMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AO_LightingAlpha = AO_Lighting.aaaa;
	float4 AO_LightingRed = AO_Lighting.rrrr;
	float4 AO_LightingGreen = AO_Lighting.gggg;
	float4 AO_LightingBlue = AO_Lighting.bbbb;
	Texture2D AO_LightingRef = AO_LightingTexture;
	
	// Type:TextureNode, Name:Direct_Lighting0
	float4 Direct_Lighting0 = Direct_Lighting0Texture.Sample(g_samplerLinearWrap, UV0.xy * Direct_Lighting0Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Direct_Lighting0Mip = GetDebugMipColour(Direct_Lighting0Texture, g_samplerLinearWrap, UV0.xy * Direct_Lighting0Tiling);
	#else
	float4 Direct_Lighting0Mip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Direct_Lighting0Alpha = Direct_Lighting0.aaaa;
	float4 Direct_Lighting0Red = Direct_Lighting0.rrrr;
	float4 Direct_Lighting0Green = Direct_Lighting0.gggg;
	float4 Direct_Lighting0Blue = Direct_Lighting0.bbbb;
	Texture2D Direct_Lighting0Ref = Direct_Lighting0Texture;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Direct_Lighting0 * AO_Lighting;
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(-0.1, -0.1, -0.1, -0.1);
	
	output.DiffuseColor = Diffuse;
	output.Normal = Lerp1;
	output.F0 = DisableSpecular;
	output.Glossiness = DisableSpecularOutput2;
	output.Lightmap = Indirect_Lighting;
	output.AmbientOcclusion = AO_Lighting;
	output.DirectOcclusion = Multiply;
	output.LightSwitchOnStart = Float;
	output.LightSwitchOnEnd = Float;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\CubemapLightScenario.hlsl"