#include "LightScenarios\Inc\ShadowDepthLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 DiffuseATiling < string UIName = "DiffuseATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 F0ValuesVector4 < string UIName = "F0ValuesVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0, 0, 0, 1 );
float4 LightmapATiling < string UIName = "LightmapATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float LightmapEV_floatVal < string UIName = "LightmapEV_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3.419565 ;
float LightSwitchOnEnd_floatVal < string UIName = "LightSwitchOnEnd_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LightSwitchOnStart_floatVal < string UIName = "LightSwitchOnStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 NormalMapATiling < string UIName = "NormalMapATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 NormalMapBTiling < string UIName = "NormalMapBTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float NormalStrength_floatVal < string UIName = "NormalStrength_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.4673913 ;
float Roughness_floatVal < string UIName = "Roughness_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
bool StepBool < string UIName = "StepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepHardStepBool < string UIName = "StepHardStepBool"; string UIWidget = "Checkbox"; > = 0;
int TangentToWorldSpaceUVSet < string UIName = "TangentToWorldSpaceUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int TrackParameterTrackParam < string UIName = "TrackParameterTrackParam"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
float4 TransmissiveFuzzinessVector4 < string UIName = "TransmissiveFuzzinessVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( -0.1, -0.2, -0.2, 0 );
float4 TransmissivenessColorParam < string UIName = "TransmissivenessColorParam"; string UIWidget = "Color"; > = float4( 0, 0, 0, 1 );
int UV0UVSet < string UIName = "UV0UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 UVPannerXYTimeScale < string UIName = "UVPannerXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0, 1, 0, 0 );
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 UVWobbleVector4 < string UIName = "UVWobbleVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.03, 0.01, 0, 0 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define UVWobbleVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 UVWobbleVector4 : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F0ValuesVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 F0ValuesVector4 : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TransmissivenessColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2]))
	#else
	float4 TransmissivenessColorParam : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TransmissiveFuzzinessVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3]))
	#else
	float4 TransmissiveFuzzinessVector4 : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DiffuseATiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].xy))
	#else
	float2 DiffuseATiling : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightmapATiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].zw))
	#else
	float2 LightmapATiling : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define NormalStrength_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)
	#else
	float NormalStrength_floatVal : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Roughness_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)
	#else
	float Roughness_floatVal : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightmapEV_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)
	#else
	float LightmapEV_floatVal : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)
	#else
	float LightSwitchOnStart_floatVal : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnEnd_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)
	#else
	float LightSwitchOnEnd_floatVal : packoffset(c6.x);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int TrackParameterTrackParam = 3;
static const int UV0UVSet = 0;
static const int UVUVSet = 1;
static const float2 UVPannerXYTimeScale = float2(0, 1);
static const float2 NormalMapATiling = float2(1, 1);
static const float2 NormalMapBTiling = float2(1, 1);
static const int TangentToWorldSpaceUVSet = 0;
static const bool StepBool = false;
static const bool StepHardStepBool = false;

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStatesSampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(DiffuseATexture, 16);
#else
#define DiffuseATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(LightmapATexture, 17);
#else
#define LightmapATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapATexture, 18);
#else
#define NormalMapATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapBTexture, 19);
#else
#define NormalMapBTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Transmissiveness 1
#define MATERIAL_INPUT_IS_USED_Transmissiveness 1
#define MATERIAL_HAS_INPUT_TransmissiveFuzziness 1
#define MATERIAL_INPUT_IS_USED_TransmissiveFuzziness 1
#define MATERIAL_HAS_INPUT_TransmissiveControl 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_INPUT_IS_USED_Lightmap 1
#define MATERIAL_HAS_INPUT_LightmapAdditive 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_INPUT_IS_USED_AlphaTest 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_INPUT_IS_USED_GIScale 1
#define MATERIAL_HAS_INPUT_MinimumWind 1
#define MATERIAL_HAS_INPUT_AnimationPivot 1
#define MATERIAL_HAS_INPUT_AnimationSpeed 1
#define MATERIAL_HAS_INPUT_TranslateSpeed 1
#define MATERIAL_HAS_INPUT_RotateSpeed 1
#define MATERIAL_HAS_INPUT_Translate 1
#define MATERIAL_HAS_INPUT_Rotate 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
#define MATERIAL_HAS_INPUT_SnowSpecTexture 1
#define MATERIAL_HAS_INPUT_SnowAmount 1
#define MATERIAL_HAS_INPUT_FrostAmount 1
#define MATERIAL_HAS_INPUT_TwinkleAmount 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 1
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BlinnPhongAlpha.hlsl"
#include "TrackConstantBuffer.hlsl"
#include "Panner.hlsl"
#include "NormalMapping.hlsl"
#include "CarConstantBuffer.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:TrackParameterNode, Name:TrackParameter
	// DX12 binding strategies currently don't support track params in these light scenarios
	
	#if defined(IS_WHEEL_BLUR_SCENARIO) || defined(CAR_LIGHTING_SCENARIO)
	float4 TrackParameter = float4(1.0, 1.0, 0.0, 1.0);
	#else
	float4 TrackParameter = g_TrackParams[min(NUM_TRACKPARAMS_SLOTS - 1, TrackParameterTrackParam)];
	#endif
	
	// Type:UVNode, Name:UV0
	float4 UV0 = GetTexCoord0(In).xyxy;
	float4 UV0Tangent = GetWorldTangent0(In);
	float4 UV0UCoord = GetTexCoord0(In).xxxx;
	float4 UV0VCoord = GetTexCoord0(In).yyyy;
	
	// Type:OneMinusNode, Name:OneMinus
	float4 OneMinus = 1 - UV0VCoord;
	
	// Type:Vector4Node, Name:UVWobble
	float4 UVWobble = UVWobbleVector4;
	
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord1(In).xyxy;
	float4 UVTangent = GetWorldTangent1(In);
	float4 UVUCoord = GetTexCoord1(In).xxxx;
	float4 UVVCoord = GetTexCoord1(In).yyyy;
	
	// Type:UVPannerNode, Name:UVPanner
	float4 UVPanner = PanTextureCoordinates(UV.xy, g_Time * UVPannerXYTimeScale.xy).xyxy;
	
	// Type:NormalMapOnlyNode, Name:NormalMapA
	float4 NormalMapA = NormalMapATexture.Sample(g_samplerLinearWrap, UVPanner.xy * NormalMapATiling);
	#ifdef _MAX_
	NormalMapA.xyz = pow(NormalMapA.xyz, 1 / 2.2);
	#endif
	float4 NormalMapAGlossiness = NormalMapA.wwww;
	float4 NormalMapARed = NormalMapA.rrrr;
	float4 NormalMapAGreen = NormalMapA.gggg;
	float4 NormalMapABlue = NormalMapA.bbbb;
	float4 NormalMapAAlpha = NormalMapA.aaaa;
	NormalMapA = DecodeNormalMap(NormalMapA);
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = UVWobble * NormalMapA;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = OneMinus * Multiply;
	
	// Type:AddNode, Name:Add
	float4 Add = UV0 + Multiply0;
	
	// Type:SwizzleNode, Name:Swizzle
	float4 Swizzle = Add.xxxx;
	
	// Type:FracNode, Name:Frac
	float4 Frac = frac(Swizzle);
	
	// Type:SwizzleNode, Name:Swizzle0
	float4 Swizzle0 = Add.yyyy;
	
	// Type:SaturateNode, Name:Saturate
	float4 Saturate = saturate( Swizzle0 ); 
	
	// Type:FracNode, Name:Frac0
	float4 Frac0 = frac(Saturate);
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(Frac.x, Frac0.x, 0, 0);
	
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStatesSampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:DiffuseA
	float4 DiffuseA = DiffuseATexture.Sample(SamplerStatesSampler, VectorMake.xy * DiffuseATiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 DiffuseAMip = GetDebugMipColour(DiffuseATexture, SamplerStatesSampler, VectorMake.xy * DiffuseATiling);
	#else
	float4 DiffuseAMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 DiffuseAAlpha = DiffuseA.aaaa;
	float4 DiffuseARed = DiffuseA.rrrr;
	float4 DiffuseAGreen = DiffuseA.gggg;
	float4 DiffuseABlue = DiffuseA.bbbb;
	Texture2D DiffuseARef = DiffuseATexture;
	
	// Type:WetifyNode, Name:Wetify
	float4 WetifyDiffuse = DiffuseA;
	float WetifyGloss = float(0);
	float WetifyRoughness = float(0);
	#ifdef _MAX_
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyGloss, float4(lerp(1.0, g_WetDiffuse, g_WetLevel), lerp(1.0, g_WetGloss, g_WetLevel), lerp(1.0, g_WetDiffuse, g_WetLevel), 0), float3(0,1,0), 1);
	#else
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyRoughness, TrackParameter, GetWorldNormal(In).xyz, float(1));
	#endif
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FloatNode, Name:NormalStrength
	float4 NormalStrength = NormalStrength_floatVal;
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(Float, NormalMapA, NormalStrength.x);
	
	// Type:NormalMapOnlyNode, Name:NormalMapB
	float4 NormalMapB = NormalMapBTexture.Sample(g_samplerLinearWrap, Add.xy * NormalMapBTiling);
	#ifdef _MAX_
	NormalMapB.xyz = pow(NormalMapB.xyz, 1 / 2.2);
	#endif
	float4 NormalMapBGlossiness = NormalMapB.wwww;
	float4 NormalMapBRed = NormalMapB.rrrr;
	float4 NormalMapBGreen = NormalMapB.gggg;
	float4 NormalMapBBlue = NormalMapB.bbbb;
	float4 NormalMapBAlpha = NormalMapB.aaaa;
	NormalMapB = DecodeNormalMap(NormalMapB);
	
	// Type:AddNode, Name:Add0
	float4 Add0 = Lerp0 + NormalMapB;
	
	// Type:TangentToWorldSpaceNode, Name:TangentToWorldSpace
	float4 TangentToWorldSpace = float4(normalize(mul(Add0, float3x3(UV0Tangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UV0Tangent.xyz) * UV0Tangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	
	// Type:F0ValuesNode, Name:F0Values
	float4 F0Values = F0ValuesVector4;
	
	// Type:FloatNode, Name:Roughness
	float4 Roughness = Roughness_floatVal;
	
	// Type:ColorNode, Name:Transmissiveness
	float4 Transmissiveness = TransmissivenessColorParam;
	float4 TransmissivenessRed = TransmissivenessColorParam.rrrr;
	float4 TransmissivenessGreen = TransmissivenessColorParam.gggg;
	float4 TransmissivenessBlue = TransmissivenessColorParam.bbbb;
	float4 TransmissivenessAlpha = TransmissivenessColorParam.aaaa;
	
	// Type:Vector4Node, Name:TransmissiveFuzziness
	float4 TransmissiveFuzziness = TransmissiveFuzzinessVector4;
	
	// Type:CarDigitalGaugeIntensityNode, Name:CarDigitalGaugeIntensity
	#if defined(IN_MATERIAL_EDITOR)
	    float4 CarDigitalGaugeIntensity = 1;
	#else
	    float4 CarDigitalGaugeIntensity = g_DigitalGaugeIntensity;
	#endif
	
	// Type:FloatNode, Name:Float2
	float4 Float2 = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:MultiplyAddNode, Name:MultiplyAdd
	float4 MultiplyAdd = TangentToWorldSpace * Float2 + Float2;
	
	// Type:SwizzleNode, Name:Swizzle1
	float4 Swizzle1 = MultiplyAdd.yyyz;
	
	// Type:TextureNode, Name:LightmapA
	float4 LightmapA = LightmapATexture.Sample(SamplerStatesSampler, VectorMake.xy * LightmapATiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 LightmapAMip = GetDebugMipColour(LightmapATexture, SamplerStatesSampler, VectorMake.xy * LightmapATiling);
	#else
	float4 LightmapAMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 LightmapAAlpha = LightmapA.aaaa;
	float4 LightmapARed = LightmapA.rrrr;
	float4 LightmapAGreen = LightmapA.gggg;
	float4 LightmapABlue = LightmapA.bbbb;
	Texture2D LightmapARef = LightmapATexture;
	
	// Type:FloatNode, Name:LightmapEV
	float4 LightmapEV = LightmapEV_floatVal;
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = LightmapA * LightmapEV;
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = Swizzle1 * Multiply1;
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = CarDigitalGaugeIntensity * Multiply2;
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:StepNode, Name:Step
	float4 Step = linearstep( Float1, float4(1, 1, 1, 1), DiffuseAAlpha );
	
	// Type:FloatNode, Name:LightSwitchOnStart
	float4 LightSwitchOnStart = LightSwitchOnStart_floatVal;
	
	// Type:FloatNode, Name:LightSwitchOnEnd
	float4 LightSwitchOnEnd = LightSwitchOnEnd_floatVal;
	
	// Type:FloatNode, Name:Float4
	float4 Float4 = float4(0, 0, 0, 0);
	
	output.BaseColor = WetifyDiffuse;
	output.Normal = TangentToWorldSpace;
	output.F0 = F0Values;
	output.Roughness = Roughness;
	output.Transmissiveness = Transmissiveness;
	output.TransmissiveFuzziness = TransmissiveFuzziness;
	output.Lightmap = Multiply3;
	#if IN_MATERIAL_EDITOR
	if (!forVertex) clip(Step.x - ALPHATEST_MIN);
	#else
	#if ENABLE_ALPHA_TEST && IS_ALPHA_TESTED
	if (!forVertex && g_EnableAlphaTest) clip(Step.x - ALPHATEST_MIN);
	#endif
	#endif
	output.AlphaTest = Step;
	output.LightSwitchOnStart = LightSwitchOnStart;
	output.LightSwitchOnEnd = LightSwitchOnEnd;
	output.GIScale = Float4;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\CheckPointFlagSkeletalDeformVL.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\ShadowDepthLightScenario.hlsl"