#include "LightScenarios\Inc\TrackNightLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float F_ColVarDiv_floatVal < string UIName = "F_ColVarDiv_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 10 ;
float F_DiffuseAmp_floatVal < string UIName = "F_DiffuseAmp_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1.5 ;
float F_EmissiveAmp_floatVal < string UIName = "F_EmissiveAmp_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 5 ;
float F_Grad_Add_floatVal < string UIName = "F_Grad_Add_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float F_Grad_Mult_floatVal < string UIName = "F_Grad_Mult_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 Grad_Col_AColorParam < string UIName = "Grad_Col_AColorParam"; string UIWidget = "Color"; > = float4( 1, 0.2122308, 0, 1 );
float4 Grad_Col_BColorParam < string UIName = "Grad_Col_BColorParam"; string UIWidget = "Color"; > = float4( 1, 1, 0, 1 );
float4 Tex_Col_Base_GTiling < string UIName = "Tex_Col_Base_GTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 Tex_Mask_RTiling < string UIName = "Tex_Mask_RTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 Tex_Var_Beams_BTiling < string UIName = "Tex_Var_Beams_BTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 Tex_Var_Clouds_GTiling < string UIName = "Tex_Var_Clouds_GTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 0.5, 0, 0 );
float4 UVPanner_BeamXYTimeScale < string UIName = "UVPanner_BeamXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( -0.4347821, 0, 0, 0 );
float4 UVPanner_CloudXYTimeScale < string UIName = "UVPanner_CloudXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.22, 3.33, 0, 0 );
float4 UVPanner_ColXYTimeScale < string UIName = "UVPanner_ColXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1.2, 0, 0, 0 );
float4 UVPanner_MaskXYTimeScale < string UIName = "UVPanner_MaskXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0, 0, 0, 0 );
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define Grad_Col_AColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 Grad_Col_AColorParam : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Grad_Col_BColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 Grad_Col_BColorParam : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UVPanner_ColXYTimeScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].xy))
	#else
	float2 UVPanner_ColXYTimeScale : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UVPanner_CloudXYTimeScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].zw))
	#else
	float2 UVPanner_CloudXYTimeScale : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UVPanner_MaskXYTimeScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].xy))
	#else
	float2 UVPanner_MaskXYTimeScale : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_EmissiveAmp_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float F_EmissiveAmp_floatVal : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_DiffuseAmp_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].y)
	#else
	float F_DiffuseAmp_floatVal : packoffset(c4.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_Grad_Mult_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].z)
	#else
	float F_Grad_Mult_floatVal : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_Grad_Add_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].w)
	#else
	float F_Grad_Add_floatVal : packoffset(c4.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_ColVarDiv_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)
	#else
	float F_ColVarDiv_floatVal : packoffset(c5.x);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UVUVSet = 0;
static const float2 Tex_Col_Base_GTiling = float2(1, 1);
static const float2 UVPanner_BeamXYTimeScale = float2(-0.4347821, 0);
static const float2 Tex_Var_Beams_BTiling = float2(1, 1);
static const float2 Tex_Var_Clouds_GTiling = float2(1, 0.5);
static const float2 Tex_Mask_RTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStatesSampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Tex_Col_Base_GTexture, 16);
#else
#define Tex_Col_Base_GTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Tex_Mask_RTexture, 17);
#else
#define Tex_Mask_RTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Tex_Var_Beams_BTexture, 18);
#else
#define Tex_Var_Beams_BTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Tex_Var_Clouds_GTexture, 19);
#else
#define Tex_Var_Clouds_GTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Additive 1
#define MATERIAL_INPUT_IS_USED_Additive 1
#define MATERIAL_HAS_INPUT_ApplyFog 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_INPUT_IS_USED_AlphaBlend 1
// Alpha
#define IS_ALPHA_BLENDED 1
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\EmissiveOnly.hlsl"
#include "Panner.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:FloatNode, Name:F_EmissiveAmp
	float4 F_EmissiveAmp = F_EmissiveAmp_floatVal;
	
	// Type:FloatNode, Name:F_DiffuseAmp
	float4 F_DiffuseAmp = F_DiffuseAmp_floatVal;
	
	// Type:ColorNode, Name:Grad_Col_A
	float4 Grad_Col_A = Grad_Col_AColorParam;
	float4 Grad_Col_ARed = Grad_Col_AColorParam.rrrr;
	float4 Grad_Col_AGreen = Grad_Col_AColorParam.gggg;
	float4 Grad_Col_ABlue = Grad_Col_AColorParam.bbbb;
	float4 Grad_Col_AAlpha = Grad_Col_AColorParam.aaaa;
	
	// Type:ColorNode, Name:Grad_Col_B
	float4 Grad_Col_B = Grad_Col_BColorParam;
	float4 Grad_Col_BRed = Grad_Col_BColorParam.rrrr;
	float4 Grad_Col_BGreen = Grad_Col_BColorParam.gggg;
	float4 Grad_Col_BBlue = Grad_Col_BColorParam.bbbb;
	float4 Grad_Col_BAlpha = Grad_Col_BColorParam.aaaa;
	
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord0(In).xyxy;
	float4 UVTangent = GetWorldTangent0(In);
	float4 UVUCoord = GetTexCoord0(In).xxxx;
	float4 UVVCoord = GetTexCoord0(In).yyyy;
	
	// Type:FloatNode, Name:F_Grad_Mult
	float4 F_Grad_Mult = F_Grad_Mult_floatVal;
	
	// Type:FloatNode, Name:F_Grad_Add
	float4 F_Grad_Add = F_Grad_Add_floatVal;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd
	float4 MultiplyAdd = UVVCoord * F_Grad_Mult + F_Grad_Add;
	
	// Type:SaturateNode, Name:Saturate0
	float4 Saturate0 = saturate( MultiplyAdd ); 
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(Grad_Col_A, Grad_Col_B, Saturate0.x);
	
	// Type:UVPannerNode, Name:UVPanner_Col
	float4 UVPanner_Col = PanTextureCoordinates(GetTexCoord0(In), g_Time * UVPanner_ColXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:Tex_Col_Base_G
	float4 Tex_Col_Base_G = Tex_Col_Base_GTexture.Sample(g_samplerLinearWrap, UVPanner_Col.xy * Tex_Col_Base_GTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Tex_Col_Base_GMip = GetDebugMipColour(Tex_Col_Base_GTexture, g_samplerLinearWrap, UVPanner_Col.xy * Tex_Col_Base_GTiling);
	#else
	float4 Tex_Col_Base_GMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Tex_Col_Base_GAlpha = Tex_Col_Base_G.aaaa;
	float4 Tex_Col_Base_GRed = Tex_Col_Base_G.rrrr;
	float4 Tex_Col_Base_GGreen = Tex_Col_Base_G.gggg;
	float4 Tex_Col_Base_GBlue = Tex_Col_Base_G.bbbb;
	Texture2D Tex_Col_Base_GRef = Tex_Col_Base_GTexture;
	
	// Type:FloatNode, Name:F_ColVarDiv
	float4 F_ColVarDiv = F_ColVarDiv_floatVal;
	
	// Type:DivideNode, Name:Divide
	float4 Divide = Tex_Col_Base_GGreen / F_ColVarDiv;
	
	// Type:AddNode, Name:Add0
	float4 Add0 = Lerp + Divide;
	
	// Type:UVPannerNode, Name:UVPanner_Beam
	float4 UVPanner_Beam = PanTextureCoordinates(GetTexCoord0(In), g_Time * UVPanner_BeamXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:Tex_Var_Beams_B
	float4 Tex_Var_Beams_B = Tex_Var_Beams_BTexture.Sample(g_samplerLinearWrap, UVPanner_Beam.xy * Tex_Var_Beams_BTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Tex_Var_Beams_BMip = GetDebugMipColour(Tex_Var_Beams_BTexture, g_samplerLinearWrap, UVPanner_Beam.xy * Tex_Var_Beams_BTiling);
	#else
	float4 Tex_Var_Beams_BMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Tex_Var_Beams_BAlpha = Tex_Var_Beams_B.aaaa;
	float4 Tex_Var_Beams_BRed = Tex_Var_Beams_B.rrrr;
	float4 Tex_Var_Beams_BGreen = Tex_Var_Beams_B.gggg;
	float4 Tex_Var_Beams_BBlue = Tex_Var_Beams_B.bbbb;
	Texture2D Tex_Var_Beams_BRef = Tex_Var_Beams_BTexture;
	
	// Type:UVPannerNode, Name:UVPanner_Cloud
	float4 UVPanner_Cloud = PanTextureCoordinates(GetTexCoord0(In), g_Time * UVPanner_CloudXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:Tex_Var_Clouds_G
	float4 Tex_Var_Clouds_G = Tex_Var_Clouds_GTexture.Sample(g_samplerLinearWrap, UVPanner_Cloud.xy * Tex_Var_Clouds_GTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Tex_Var_Clouds_GMip = GetDebugMipColour(Tex_Var_Clouds_GTexture, g_samplerLinearWrap, UVPanner_Cloud.xy * Tex_Var_Clouds_GTiling);
	#else
	float4 Tex_Var_Clouds_GMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Tex_Var_Clouds_GAlpha = Tex_Var_Clouds_G.aaaa;
	float4 Tex_Var_Clouds_GRed = Tex_Var_Clouds_G.rrrr;
	float4 Tex_Var_Clouds_GGreen = Tex_Var_Clouds_G.gggg;
	float4 Tex_Var_Clouds_GBlue = Tex_Var_Clouds_G.bbbb;
	Texture2D Tex_Var_Clouds_GRef = Tex_Var_Clouds_GTexture;
	
	// Type:AddNode, Name:Add
	float4 Add = Tex_Var_Beams_BBlue + Tex_Var_Clouds_GGreen;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = Add0 * Add;
	
	// Type:MultiplyNode, Name:Mult_Diff
	float4 Mult_Diff = F_DiffuseAmp * Multiply0;
	
	// Type:UVPannerNode, Name:UVPanner_Mask
	float4 UVPanner_Mask = PanTextureCoordinates(GetTexCoord0(In), g_Time * UVPanner_MaskXYTimeScale.xy).xyxy;
	
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStatesSampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:Tex_Mask_R
	float4 Tex_Mask_R = Tex_Mask_RTexture.Sample(SamplerStatesSampler, UVPanner_Mask.xy * Tex_Mask_RTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Tex_Mask_RMip = GetDebugMipColour(Tex_Mask_RTexture, SamplerStatesSampler, UVPanner_Mask.xy * Tex_Mask_RTiling);
	#else
	float4 Tex_Mask_RMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Tex_Mask_RAlpha = Tex_Mask_R.aaaa;
	float4 Tex_Mask_RRed = Tex_Mask_R.rrrr;
	float4 Tex_Mask_RGreen = Tex_Mask_R.gggg;
	float4 Tex_Mask_RBlue = Tex_Mask_R.bbbb;
	Texture2D Tex_Mask_RRef = Tex_Mask_RTexture;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Tex_Var_Clouds_GGreen * Tex_Mask_RRed;
	
	// Type:MultiplyNode, Name:Multiply00
	float4 Multiply00 = Mult_Diff * Multiply;
	
	// Type:MultiplyNode, Name:Mult_Emiss
	float4 Mult_Emiss = F_EmissiveAmp * Multiply00;
	
	output.Emissive = Mult_Emiss;
	output.Additive = Mult_Emiss;
	output.AlphaBlend = Mult_Emiss;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\TrackNightLightScenario.hlsl"