#include "LightScenarios\Inc\CubemapLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float Brightness_floatVal < string UIName = "Brightness_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.1 ;
float4 DiffuseTiling < string UIName = "DiffuseTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 2, 2, 0, 0 );
float4 GlossMapTiling < string UIName = "GlossMapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 6, 12, 0, 0 );
float4 MaskTiling < string UIName = "MaskTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 2, 2, 0, 0 );
float NormalMapSpecPower < string UIName = "NormalMapSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalMapTiling < string UIName = "NormalMapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 2, 2, 0, 0 );
float4 ScreenTiling < string UIName = "ScreenTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 TextureTiling < string UIName = "TextureTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define DiffuseTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].xy))
	#else
	float2 DiffuseTiling : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define NormalMapTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].zw))
	#else
	float2 NormalMapTiling : packoffset(c0.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GlossMapTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].xy))
	#else
	float2 GlossMapTiling : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MaskTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].zw))
	#else
	float2 MaskTiling : packoffset(c1.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TextureTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].xy))
	#else
	float2 TextureTiling : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Brightness_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].x)
	#else
	float Brightness_floatVal : packoffset(c3.x);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const float NormalMapSpecPower = 100;
static const int UVUVSet = 1;
static const float2 ScreenTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(DiffuseTexture, 16);
#else
#define DiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(GlossMapTexture, 17);
#else
#define GlossMapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MaskTexture, 18);
#else
#define MaskTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapTexture, 19);
#else
#define NormalMapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(ScreenTexture, 20);
#else
#define ScreenTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TextureTexture, 21);
#else
#define TextureTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_Glossiness 1
#define MATERIAL_INPUT_IS_USED_Glossiness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"
#include "CarConstantBuffer.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:TextureNode, Name:Diffuse
	float4 Diffuse = DiffuseTexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * DiffuseTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 DiffuseMip = GetDebugMipColour(DiffuseTexture, g_samplerLinearWrap, GetTexCoord0(In) * DiffuseTiling);
	#else
	float4 DiffuseMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 DiffuseAlpha = Diffuse.aaaa;
	float4 DiffuseRed = Diffuse.rrrr;
	float4 DiffuseGreen = Diffuse.gggg;
	float4 DiffuseBlue = Diffuse.bbbb;
	Texture2D DiffuseRef = DiffuseTexture;
	
	// Type:NormalMapNode, Name:NormalMap
	float4 textureLookup_NormalMap = NormalMapTexture.Sample(g_samplerLinearWrap, GetTexCoord0(In).xy * NormalMapTiling);
	#ifdef _MAX_
	textureLookup_NormalMap.xyz = pow(textureLookup_NormalMap.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMap = (2.0f * textureLookup_NormalMap.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMap, NormalMapSpecPower);
	float4 NormalMapAlpha = textureLookup_NormalMap.aaaa;
	float4 NormalMapRed = textureLookup_NormalMap.rrrr;
	float4 NormalMapGreen = textureLookup_NormalMap.gggg;
	float4 NormalMapBlue = textureLookup_NormalMap.bbbb;
	tangentSpaceNormal_NormalMap.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMap.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMap.x*tangentSpaceNormal_NormalMap.x - tangentSpaceNormal_NormalMap.y*tangentSpaceNormal_NormalMap.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMap.xy *= g_GlobalNormalScale;
	#endif
	float4 NormalMap = float4(normalize(mul(tangentSpaceNormal_NormalMap, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMap = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:FloatNode, Name:F0
	float4 F0 = float4(0.04, 0.04, 0.04, 0.04);
	
	// Type:TextureNode, Name:GlossMap
	float4 GlossMap = GlossMapTexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * GlossMapTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 GlossMapMip = GetDebugMipColour(GlossMapTexture, g_samplerLinearWrap, GetTexCoord0(In) * GlossMapTiling);
	#else
	float4 GlossMapMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 GlossMapAlpha = GlossMap.aaaa;
	float4 GlossMapRed = GlossMap.rrrr;
	float4 GlossMapGreen = GlossMap.gggg;
	float4 GlossMapBlue = GlossMap.bbbb;
	Texture2D GlossMapRef = GlossMapTexture;
	
	// Type:TextureNode, Name:Mask
	float4 Mask = MaskTexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * MaskTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MaskMip = GetDebugMipColour(MaskTexture, g_samplerLinearWrap, GetTexCoord0(In) * MaskTiling);
	#else
	float4 MaskMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MaskAlpha = Mask.aaaa;
	float4 MaskRed = Mask.rrrr;
	float4 MaskGreen = Mask.gggg;
	float4 MaskBlue = Mask.bbbb;
	Texture2D MaskRef = MaskTexture;
	
	// Type:TextureNode, Name:Texture
	float4 Texture = TextureTexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * TextureTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TextureMip = GetDebugMipColour(TextureTexture, g_samplerLinearWrap, GetTexCoord0(In) * TextureTiling);
	#else
	float4 TextureMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TextureAlpha = Texture.aaaa;
	float4 TextureRed = Texture.rrrr;
	float4 TextureGreen = Texture.gggg;
	float4 TextureBlue = Texture.bbbb;
	Texture2D TextureRef = TextureTexture;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = Mask * Texture;
	
	// Type:SwizzleNode, Name:Swizzle
	float4 Swizzle = Multiply0.xxxw;
	
	// Type:FloatNode, Name:Brightness
	float4 Brightness = Brightness_floatVal;
	
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord1(In).xyxy;
	float4 UVTangent = GetWorldTangent1(In);
	float4 UVUCoord = GetTexCoord1(In).xxxx;
	float4 UVVCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:Screen
	float4 Screen = ScreenTexture.Sample(g_samplerLinearWrap, UV.xy * ScreenTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 ScreenMip = GetDebugMipColour(ScreenTexture, g_samplerLinearWrap, UV.xy * ScreenTiling);
	#else
	float4 ScreenMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 ScreenAlpha = Screen.aaaa;
	float4 ScreenRed = Screen.rrrr;
	float4 ScreenGreen = Screen.gggg;
	float4 ScreenBlue = Screen.bbbb;
	Texture2D ScreenRef = ScreenTexture;
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(2.4, 2.4, 2.4, 2.4);
	
	// Type:PowNode, Name:Pow
	float4 Pow = pow( Screen, Float );
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Brightness * Pow;
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = Swizzle * Multiply;
	
	// Type:CarDigitalGaugeIntensityNode, Name:CarDigitalGaugeIntensity
	#if defined(IN_MATERIAL_EDITOR)
	    float4 CarDigitalGaugeIntensity = 1;
	#else
	    float4 CarDigitalGaugeIntensity = g_DigitalGaugeIntensity;
	#endif
	
	// Type:MultiplyNode, Name:Multiply30
	float4 Multiply30 = Multiply3 * CarDigitalGaugeIntensity;
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(-1, -1, -1, -1);
	
	output.DiffuseColor = Diffuse;
	output.Normal = NormalMap;
	output.F0 = F0;
	output.Glossiness = GlossMap;
	output.Emissive = Multiply30;
	output.LightSwitchOnStart = Float1;
	output.LightSwitchOnEnd = Float1;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\CubemapLightScenario.hlsl"