#include "LightScenarios\Inc\DebugLightingLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
int CarLODLOD_surfaceFX_opus < string UIName = "CarLODLOD_surfaceFX_opus"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
int CarLODoptimisation1LOD_surfaceFX_opus < string UIName = "CarLODoptimisation1LOD_surfaceFX_opus"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
int CarLODOptimisationLOD_surfaceFX_opus < string UIName = "CarLODOptimisationLOD_surfaceFX_opus"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
int CH2UV1UVSet_surfaceFX_opus < string UIName = "CH2UV1UVSet_surfaceFX_opus"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int CH2UV1UVSet_surfaceFX_winter < string UIName = "CH2UV1UVSet_surfaceFX_winter"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int CH4UV3UVSet_surfaceFX_opus < string UIName = "CH4UV3UVSet_surfaceFX_opus"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
int CH4UV3UVSet_surfaceFX_winter < string UIName = "CH4UV3UVSet_surfaceFX_winter"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
float4 ColorDryDustColorParam_surfaceFX_opus < string UIName = "ColorDryDustColorParam_surfaceFX_opus"; string UIWidget = "Color"; > = float4( 0.3762622, 0.2663556, 0.1912017, 1 );
float4 ColorDryMudColorParam_surfaceFX_opus < string UIName = "ColorDryMudColorParam_surfaceFX_opus"; string UIWidget = "Color"; > = float4( 0.2961383, 0.2122308, 0.1441285, 1 );
float4 ColorGrimeColorParam_surfaceFX_winter < string UIName = "ColorGrimeColorParam_surfaceFX_winter"; string UIWidget = "Color"; > = float4( 0.03310477, 0.03189603, 0.02842604, 1 );
float4 ColorOFFColorParam < string UIName = "ColorOFFColorParam"; string UIWidget = "Color"; > = float4( 0.2122308, 0.2122308, 0.2122308, 1 );
float4 ColorWetDustColorParam_surfaceFX_opus < string UIName = "ColorWetDustColorParam_surfaceFX_opus"; string UIWidget = "Color"; > = float4( 0.1470273, 0.1070231, 0.07818743, 1 );
float4 ColorWetMudColorParam_surfaceFX_opus < string UIName = "ColorWetMudColorParam_surfaceFX_opus"; string UIWidget = "Color"; > = float4( 0.1559265, 0.1022417, 0.06480327, 1 );
float DynamicBranchRefValue_surfaceFX_opus < string UIName = "DynamicBranchRefValue_surfaceFX_opus"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float DynamicOptimisationForNonMuddyPixelsRefValue_surfaceFX_opus < string UIName = "DynamicOptimisationForNonMuddyPixelsRefValue_surfaceFX_opus"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.05 ;
float4 HighNoiseTextureTiling_surfaceFX_winter < string UIName = "HighNoiseTextureTiling_surfaceFX_winter"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 HighNoiseTireBlurApproxColorParam_surfaceFX_winter < string UIName = "HighNoiseTireBlurApproxColorParam_surfaceFX_winter"; string UIWidget = "Color"; > = float4( 0.6444797, 0.1559265, 0, 1 );
float4 LowNoiseTextureTiling_surfaceFX_winter < string UIName = "LowNoiseTextureTiling_surfaceFX_winter"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0, 0 );
float4 MudTileDirectionalLeftTiling_surfaceFX_opus < string UIName = "MudTileDirectionalLeftTiling_surfaceFX_opus"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 5, 5, 0, 0 );
float4 MudTileNonDirectionalTiling_surfaceFX_opus < string UIName = "MudTileNonDirectionalTiling_surfaceFX_opus"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float NormalMapWithIntensityHeightScale_surfaceFX_opus < string UIName = "NormalMapWithIntensityHeightScale_surfaceFX_opus"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.25 ;
float NormalMapWithIntensityHeightScale_surfaceFX_winter < string UIName = "NormalMapWithIntensityHeightScale_surfaceFX_winter"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.3 ;
float NormalMapWithIntensitySpecPower_surfaceFX_opus < string UIName = "NormalMapWithIntensitySpecPower_surfaceFX_opus"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float NormalMapWithIntensitySpecPower_surfaceFX_winter < string UIName = "NormalMapWithIntensitySpecPower_surfaceFX_winter"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalMapWithIntensityTiling_surfaceFX_opus < string UIName = "NormalMapWithIntensityTiling_surfaceFX_opus"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 NormalMapWithIntensityTiling_surfaceFX_winter < string UIName = "NormalMapWithIntensityTiling_surfaceFX_winter"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0, 0 );
bool SmoothStep_bottomFade0Bool_surfaceFX_opus < string UIName = "SmoothStep_bottomFade0Bool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_bottomFade0HardStepBool_surfaceFX_opus < string UIName = "SmoothStep_bottomFade0HardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool SmoothStep_frontFadeBool_surfaceFX_opus < string UIName = "SmoothStep_frontFadeBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_frontFadeBool_surfaceFX_winter < string UIName = "SmoothStep_frontFadeBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_frontFadeHardStepBool_surfaceFX_opus < string UIName = "SmoothStep_frontFadeHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool SmoothStep_frontFadeHardStepBool_surfaceFX_winter < string UIName = "SmoothStep_frontFadeHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool SmoothStep_heightFadeBool_surfaceFX_opus < string UIName = "SmoothStep_heightFadeBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_heightFadeHardStepBool_surfaceFX_opus < string UIName = "SmoothStep_heightFadeHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool SmoothStep_kickupDustBool_surfaceFX_opus < string UIName = "SmoothStep_kickupDustBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_kickupDustHardStepBool_surfaceFX_opus < string UIName = "SmoothStep_kickupDustHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool SmoothStep_testBool_surfaceFX_winter < string UIName = "SmoothStep_testBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_testHardStepBool_surfaceFX_winter < string UIName = "SmoothStep_testHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
float4 SnowDiffuseTextureTiling_surfaceFX_winter < string UIName = "SnowDiffuseTextureTiling_surfaceFX_winter"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0, 0 );
bool step_bottomFade0Bool_surfaceFX_winter < string UIName = "step_bottomFade0Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool step_bottomFade0HardStepBool_surfaceFX_winter < string UIName = "step_bottomFade0HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool Step_test0Bool_surfaceFX_winter < string UIName = "Step_test0Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool Step_test0HardStepBool_surfaceFX_winter < string UIName = "Step_test0HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool Step0Bool_surfaceFX_opus < string UIName = "Step0Bool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool Step0HardStepBool_surfaceFX_opus < string UIName = "Step0HardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepAccumSplashBool_surfaceFX_opus < string UIName = "StepAccumSplashBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepAccumSplashHardStepBool_surfaceFX_opus < string UIName = "StepAccumSplashHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepAccumStreakBool_surfaceFX_opus < string UIName = "StepAccumStreakBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepAccumStreakHardStepBool_surfaceFX_opus < string UIName = "StepAccumStreakHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepAngleTranslucencyFadeBool_surfaceFX_winter < string UIName = "StepAngleTranslucencyFadeBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepAngleTranslucencyFadeHardStepBool_surfaceFX_winter < string UIName = "StepAngleTranslucencyFadeHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepBool_surfaceFX_opus < string UIName = "StepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 1;
bool StepF0Mask0Bool_surfaceFX_winter < string UIName = "StepF0Mask0Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepF0Mask0HardStepBool_surfaceFX_winter < string UIName = "StepF0Mask0HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepFineSnowMaskBool_surfaceFX_winter < string UIName = "StepFineSnowMaskBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepFineSnowMaskHardStepBool_surfaceFX_winter < string UIName = "StepFineSnowMaskHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepFineSnowMaskHeightBool_surfaceFX_winter < string UIName = "StepFineSnowMaskHeightBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepFineSnowMaskHeightHardStepBool_surfaceFX_winter < string UIName = "StepFineSnowMaskHeightHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepFineSnowMaskKickup0Bool_surfaceFX_winter < string UIName = "StepFineSnowMaskKickup0Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepFineSnowMaskKickup0HardStepBool_surfaceFX_winter < string UIName = "StepFineSnowMaskKickup0HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepFlattenBool_surfaceFX_opus < string UIName = "StepFlattenBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepFlattenHardStepBool_surfaceFX_opus < string UIName = "StepFlattenHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepFrostMask0Bool_surfaceFX_winter < string UIName = "StepFrostMask0Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepFrostMask0HardStepBool_surfaceFX_winter < string UIName = "StepFrostMask0HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepFrostMask10Bool_surfaceFX_winter < string UIName = "StepFrostMask10Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepFrostMask10HardStepBool_surfaceFX_winter < string UIName = "StepFrostMask10HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepFrostMaskBool_surfaceFX_winter < string UIName = "StepFrostMaskBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepFrostMaskHardStepBool_surfaceFX_winter < string UIName = "StepFrostMaskHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepGrimeNormalMask0Bool_surfaceFX_winter < string UIName = "StepGrimeNormalMask0Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepGrimeNormalMask0HardStepBool_surfaceFX_winter < string UIName = "StepGrimeNormalMask0HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepHardStepBool_surfaceFX_opus < string UIName = "StepHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepHighNoiseMask00Bool_surfaceFX_winter < string UIName = "StepHighNoiseMask00Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepHighNoiseMask00HardStepBool_surfaceFX_winter < string UIName = "StepHighNoiseMask00HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepHighNoiseMask0Bool_surfaceFX_winter < string UIName = "StepHighNoiseMask0Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepHighNoiseMask0HardStepBool_surfaceFX_winter < string UIName = "StepHighNoiseMask0HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepHighNoiseMask1Bool_surfaceFX_winter < string UIName = "StepHighNoiseMask1Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepHighNoiseMask1HardStepBool_surfaceFX_winter < string UIName = "StepHighNoiseMask1HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepHighNoiseMaskBool_surfaceFX_winter < string UIName = "StepHighNoiseMaskBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepHighNoiseMaskHardStepBool_surfaceFX_winter < string UIName = "StepHighNoiseMaskHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepLowLODsBool_surfaceFX_opus < string UIName = "StepLowLODsBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepLowLODsHardStepBool_surfaceFX_opus < string UIName = "StepLowLODsHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepLumRangeBool_surfaceFX_opus < string UIName = "StepLumRangeBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepLumRangeHardStepBool_surfaceFX_opus < string UIName = "StepLumRangeHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepMudDampnessBuildupMaskBool_surfaceFX_opus < string UIName = "StepMudDampnessBuildupMaskBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepMudDampnessBuildupMaskHardStepBool_surfaceFX_opus < string UIName = "StepMudDampnessBuildupMaskHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepNoiseTextureBool_surfaceFX_opus < string UIName = "StepNoiseTextureBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepNoiseTextureBool_surfaceFX_winter < string UIName = "StepNoiseTextureBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepNoiseTextureHardStepBool_surfaceFX_opus < string UIName = "StepNoiseTextureHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepNoiseTextureHardStepBool_surfaceFX_winter < string UIName = "StepNoiseTextureHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepNonSnowWetnessTriggerBool_surfaceFX_winter < string UIName = "StepNonSnowWetnessTriggerBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepNonSnowWetnessTriggerHardStepBool_surfaceFX_winter < string UIName = "StepNonSnowWetnessTriggerHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepNormalMaskBool_surfaceFX_opus < string UIName = "StepNormalMaskBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepNormalMaskBool_surfaceFX_winter < string UIName = "StepNormalMaskBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepNormalMaskHardStepBool_surfaceFX_opus < string UIName = "StepNormalMaskHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepNormalMaskHardStepBool_surfaceFX_winter < string UIName = "StepNormalMaskHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepRemapGlobalNaturalWetRangeBool_surfaceFX_opus < string UIName = "StepRemapGlobalNaturalWetRangeBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepRemapGlobalNaturalWetRangeHardStepBool_surfaceFX_opus < string UIName = "StepRemapGlobalNaturalWetRangeHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepSideTexDirectionBool_surfaceFX_opus < string UIName = "StepSideTexDirectionBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepSideTexDirectionHardStepBool_surfaceFX_opus < string UIName = "StepSideTexDirectionHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepSideTexMaskBool_surfaceFX_opus < string UIName = "StepSideTexMaskBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepSideTexMaskHardStepBool_surfaceFX_opus < string UIName = "StepSideTexMaskHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepSnowMask0Bool_surfaceFX_winter < string UIName = "StepSnowMask0Bool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepSnowMask0HardStepBool_surfaceFX_winter < string UIName = "StepSnowMask0HardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepSnowMaskBool_surfaceFX_winter < string UIName = "StepSnowMaskBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepSnowMaskFrontBool_surfaceFX_winter < string UIName = "StepSnowMaskFrontBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepSnowMaskFrontHardStepBool_surfaceFX_winter < string UIName = "StepSnowMaskFrontHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepSnowMaskHardStepBool_surfaceFX_winter < string UIName = "StepSnowMaskHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepSnowMaskKickupBool_surfaceFX_winter < string UIName = "StepSnowMaskKickupBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepSnowMaskKickupHardStepBool_surfaceFX_winter < string UIName = "StepSnowMaskKickupHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepSpecSpotsBool_surfaceFX_opus < string UIName = "StepSpecSpotsBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 1;
bool StepSpecSpotsHardStepBool_surfaceFX_opus < string UIName = "StepSpecSpotsHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepStreakMaskBool_surfaceFX_winter < string UIName = "StepStreakMaskBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepStreakMaskHardStepBool_surfaceFX_winter < string UIName = "StepStreakMaskHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepStreakSkyDirFadeBool_surfaceFX_winter < string UIName = "StepStreakSkyDirFadeBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepStreakSkyDirFadeHardStepBool_surfaceFX_winter < string UIName = "StepStreakSkyDirFadeHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepWadingLevelBool_surfaceFX_opus < string UIName = "StepWadingLevelBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepWadingLevelBool_surfaceFX_winter < string UIName = "StepWadingLevelBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepWadingLevelHardStepBool_surfaceFX_opus < string UIName = "StepWadingLevelHardStepBool_surfaceFX_opus"; string UIWidget = "Checkbox"; > = 0;
bool StepWadingLevelHardStepBool_surfaceFX_winter < string UIName = "StepWadingLevelHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepWheelFrostMaskBool_surfaceFX_winter < string UIName = "StepWheelFrostMaskBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepWheelFrostMaskHardStepBool_surfaceFX_winter < string UIName = "StepWheelFrostMaskHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepWheelSideFadeAngleBool_surfaceFX_winter < string UIName = "StepWheelSideFadeAngleBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepWheelSideFadeAngleHardStepBool_surfaceFX_winter < string UIName = "StepWheelSideFadeAngleHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
bool StepWheelSnowMaskBool_surfaceFX_winter < string UIName = "StepWheelSnowMaskBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 1;
bool StepWheelSnowMaskHardStepBool_surfaceFX_winter < string UIName = "StepWheelSnowMaskHardStepBool_surfaceFX_winter"; string UIWidget = "Checkbox"; > = 0;
float4 TexLowFrequencyNoiseTiling_surfaceFX_opus < string UIName = "TexLowFrequencyNoiseTiling_surfaceFX_opus"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0, 0 );
float4 TextureWetnessEdgeTiling_surfaceFX_opus < string UIName = "TextureWetnessEdgeTiling_surfaceFX_opus"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.3, 0.32, 0, 0 );
float4 TextureWetnessEdgeTiling_surfaceFX_winter < string UIName = "TextureWetnessEdgeTiling_surfaceFX_winter"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.3, 0.32, 0, 0 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const float4 ColorDryDustColorParam_surfaceFX_opus = float4(0.3762622, 0.2663556, 0.1912017, 1);
static const float4 ColorWetDustColorParam_surfaceFX_opus = float4(0.1470273, 0.1070231, 0.07818743, 1);
static const bool StepWadingLevelBool_surfaceFX_opus = false;
static const bool StepWadingLevelHardStepBool_surfaceFX_opus = false;
static const int CH2UV1UVSet_surfaceFX_opus = 1;
static const float2 TextureWetnessEdgeTiling_surfaceFX_opus = float2(0.3, 0.32);
static const float2 TexLowFrequencyNoiseTiling_surfaceFX_opus = float2(0.5, 0.5);
static const bool StepNoiseTextureBool_surfaceFX_opus = false;
static const bool StepNoiseTextureHardStepBool_surfaceFX_opus = false;
static const bool StepSpecSpotsBool_surfaceFX_opus = true;
static const bool StepSpecSpotsHardStepBool_surfaceFX_opus = false;
static const float2 MudTileNonDirectionalTiling_surfaceFX_opus = float2(1, 1);
static const bool StepBool_surfaceFX_opus = true;
static const bool StepHardStepBool_surfaceFX_opus = false;
static const bool StepAccumSplashBool_surfaceFX_opus = false;
static const bool StepAccumSplashHardStepBool_surfaceFX_opus = false;
static const int CH4UV3UVSet_surfaceFX_opus = 3;
static const float2 MudTileDirectionalLeftTiling_surfaceFX_opus = float2(5, 5);
static const bool StepSideTexDirectionBool_surfaceFX_opus = false;
static const bool StepSideTexDirectionHardStepBool_surfaceFX_opus = false;
static const bool StepAccumStreakBool_surfaceFX_opus = false;
static const bool StepAccumStreakHardStepBool_surfaceFX_opus = false;
static const bool StepSideTexMaskBool_surfaceFX_opus = false;
static const bool StepSideTexMaskHardStepBool_surfaceFX_opus = false;
static const float DynamicOptimisationForNonMuddyPixelsRefValue_surfaceFX_opus = 0.05;
static const bool StepLowLODsBool_surfaceFX_opus = false;
static const bool StepLowLODsHardStepBool_surfaceFX_opus = false;
static const int CarLODOptimisationLOD_surfaceFX_opus = 3;
static const bool StepRemapGlobalNaturalWetRangeBool_surfaceFX_opus = false;
static const bool StepRemapGlobalNaturalWetRangeHardStepBool_surfaceFX_opus = false;
static const int CarLODoptimisation1LOD_surfaceFX_opus = 3;
static const bool StepFlattenBool_surfaceFX_opus = false;
static const bool StepFlattenHardStepBool_surfaceFX_opus = false;
static const bool StepMudDampnessBuildupMaskBool_surfaceFX_opus = false;
static const bool StepMudDampnessBuildupMaskHardStepBool_surfaceFX_opus = false;
static const float DynamicBranchRefValue_surfaceFX_opus = 0;
static const float4 ColorDryMudColorParam_surfaceFX_opus = float4(0.2961383, 0.2122308, 0.1441285, 1);
static const float4 ColorWetMudColorParam_surfaceFX_opus = float4(0.1559265, 0.1022417, 0.06480327, 1);
static const bool SmoothStep_kickupDustBool_surfaceFX_opus = true;
static const bool SmoothStep_kickupDustHardStepBool_surfaceFX_opus = false;
static const bool SmoothStep_bottomFade0Bool_surfaceFX_opus = true;
static const bool SmoothStep_bottomFade0HardStepBool_surfaceFX_opus = false;
static const bool SmoothStep_frontFadeBool_surfaceFX_opus = true;
static const bool SmoothStep_frontFadeHardStepBool_surfaceFX_opus = false;
static const bool SmoothStep_heightFadeBool_surfaceFX_opus = true;
static const bool SmoothStep_heightFadeHardStepBool_surfaceFX_opus = false;
static const int CarLODLOD_surfaceFX_opus = 2;
static const bool StepLumRangeBool_surfaceFX_opus = false;
static const bool StepLumRangeHardStepBool_surfaceFX_opus = false;
static const float NormalMapWithIntensityHeightScale_surfaceFX_opus = 0.25;
static const float NormalMapWithIntensitySpecPower_surfaceFX_opus = 100;
static const float2 NormalMapWithIntensityTiling_surfaceFX_opus = float2(1, 1);
static const bool StepNormalMaskBool_surfaceFX_opus = false;
static const bool StepNormalMaskHardStepBool_surfaceFX_opus = false;
static const bool Step0Bool_surfaceFX_opus = false;
static const bool Step0HardStepBool_surfaceFX_opus = false;
static const int CH2UV1UVSet_surfaceFX_winter = 1;
static const float2 SnowDiffuseTextureTiling_surfaceFX_winter = float2(0.5, 0.5);
static const bool StepAngleTranslucencyFadeBool_surfaceFX_winter = true;
static const bool StepAngleTranslucencyFadeHardStepBool_surfaceFX_winter = false;
static const float2 HighNoiseTextureTiling_surfaceFX_winter = float2(1, 1);
static const float4 HighNoiseTireBlurApproxColorParam_surfaceFX_winter = float4(0.6444797, 0.1559265, 0, 1);
static const bool StepNonSnowWetnessTriggerBool_surfaceFX_winter = false;
static const bool StepNonSnowWetnessTriggerHardStepBool_surfaceFX_winter = false;
static const float2 TextureWetnessEdgeTiling_surfaceFX_winter = float2(0.3, 0.32);
static const bool StepWheelSideFadeAngleBool_surfaceFX_winter = true;
static const bool StepWheelSideFadeAngleHardStepBool_surfaceFX_winter = false;
static const bool StepWheelFrostMaskBool_surfaceFX_winter = true;
static const bool StepWheelFrostMaskHardStepBool_surfaceFX_winter = false;
static const bool StepWheelSnowMaskBool_surfaceFX_winter = true;
static const bool StepWheelSnowMaskHardStepBool_surfaceFX_winter = false;
static const bool StepHighNoiseMask1Bool_surfaceFX_winter = true;
static const bool StepHighNoiseMask1HardStepBool_surfaceFX_winter = false;
static const float2 LowNoiseTextureTiling_surfaceFX_winter = float2(0.5, 0.5);
static const bool StepSnowMask0Bool_surfaceFX_winter = true;
static const bool StepSnowMask0HardStepBool_surfaceFX_winter = false;
static const bool StepFrostMask0Bool_surfaceFX_winter = true;
static const bool StepFrostMask0HardStepBool_surfaceFX_winter = false;
static const bool StepSnowMaskBool_surfaceFX_winter = true;
static const bool StepSnowMaskHardStepBool_surfaceFX_winter = false;
static const bool StepHighNoiseMask0Bool_surfaceFX_winter = true;
static const bool StepHighNoiseMask0HardStepBool_surfaceFX_winter = false;
static const bool StepFrostMaskBool_surfaceFX_winter = true;
static const bool StepFrostMaskHardStepBool_surfaceFX_winter = false;
static const bool SmoothStep_frontFadeBool_surfaceFX_winter = true;
static const bool SmoothStep_frontFadeHardStepBool_surfaceFX_winter = false;
static const bool StepSnowMaskFrontBool_surfaceFX_winter = true;
static const bool StepSnowMaskFrontHardStepBool_surfaceFX_winter = false;
static const bool StepHighNoiseMask00Bool_surfaceFX_winter = true;
static const bool StepHighNoiseMask00HardStepBool_surfaceFX_winter = false;
static const bool StepFrostMask10Bool_surfaceFX_winter = true;
static const bool StepFrostMask10HardStepBool_surfaceFX_winter = false;
static const int CH4UV3UVSet_surfaceFX_winter = 3;
static const bool StepSnowMaskKickupBool_surfaceFX_winter = true;
static const bool StepSnowMaskKickupHardStepBool_surfaceFX_winter = false;
static const bool StepHighNoiseMaskBool_surfaceFX_winter = true;
static const bool StepHighNoiseMaskHardStepBool_surfaceFX_winter = false;
static const bool StepFineSnowMaskHeightBool_surfaceFX_winter = true;
static const bool StepFineSnowMaskHeightHardStepBool_surfaceFX_winter = false;
static const bool StepFineSnowMaskKickup0Bool_surfaceFX_winter = true;
static const bool StepFineSnowMaskKickup0HardStepBool_surfaceFX_winter = false;
static const bool StepFineSnowMaskBool_surfaceFX_winter = true;
static const bool StepFineSnowMaskHardStepBool_surfaceFX_winter = false;
static const bool StepWadingLevelBool_surfaceFX_winter = false;
static const bool StepWadingLevelHardStepBool_surfaceFX_winter = false;
static const bool StepNoiseTextureBool_surfaceFX_winter = false;
static const bool StepNoiseTextureHardStepBool_surfaceFX_winter = false;
static const float4 ColorGrimeColorParam_surfaceFX_winter = float4(0.03310477, 0.03189603, 0.02842604, 1);
static const bool StepStreakMaskBool_surfaceFX_winter = false;
static const bool StepStreakMaskHardStepBool_surfaceFX_winter = false;
static const bool StepStreakSkyDirFadeBool_surfaceFX_winter = false;
static const bool StepStreakSkyDirFadeHardStepBool_surfaceFX_winter = false;
static const bool step_bottomFade0Bool_surfaceFX_winter = false;
static const bool step_bottomFade0HardStepBool_surfaceFX_winter = false;
static const bool SmoothStep_testBool_surfaceFX_winter = true;
static const bool SmoothStep_testHardStepBool_surfaceFX_winter = false;
static const float NormalMapWithIntensityHeightScale_surfaceFX_winter = 0.3;
static const float NormalMapWithIntensitySpecPower_surfaceFX_winter = 100;
static const float2 NormalMapWithIntensityTiling_surfaceFX_winter = float2(0.5, 0.5);
static const bool Step_test0Bool_surfaceFX_winter = false;
static const bool Step_test0HardStepBool_surfaceFX_winter = false;
static const bool StepNormalMaskBool_surfaceFX_winter = false;
static const bool StepNormalMaskHardStepBool_surfaceFX_winter = false;
static const bool StepF0Mask0Bool_surfaceFX_winter = false;
static const bool StepF0Mask0HardStepBool_surfaceFX_winter = false;
static const bool StepGrimeNormalMask0Bool_surfaceFX_winter = false;
static const bool StepGrimeNormalMask0HardStepBool_surfaceFX_winter = false;
static const float4 ColorOFFColorParam = float4(0.2122308, 0.2122308, 0.2122308, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStatesSampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(HighNoiseTextureTexture_surfaceFX_winter, 16);
#else
#define HighNoiseTextureTexture_surfaceFX_winter InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(LowNoiseTextureTexture_surfaceFX_winter, 17);
#else
#define LowNoiseTextureTexture_surfaceFX_winter InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MudTileDirectionalLeftTexture_surfaceFX_opus, 18);
#else
#define MudTileDirectionalLeftTexture_surfaceFX_opus InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MudTileNonDirectionalTexture_surfaceFX_opus, 19);
#else
#define MudTileNonDirectionalTexture_surfaceFX_opus InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapWithIntensityTexture_surfaceFX_opus, 20);
#else
#define NormalMapWithIntensityTexture_surfaceFX_opus InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapWithIntensityTexture_surfaceFX_winter, 21);
#else
#define NormalMapWithIntensityTexture_surfaceFX_winter InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(SnowDiffuseTextureTexture_surfaceFX_winter, 22);
#else
#define SnowDiffuseTextureTexture_surfaceFX_winter InstancedDrawBundleTextures2D[GetIDBTextureIndex(6)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TexLowFrequencyNoiseTexture_surfaceFX_opus, 23);
#else
#define TexLowFrequencyNoiseTexture_surfaceFX_opus InstancedDrawBundleTextures2D[GetIDBTextureIndex(7)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TextureWetnessEdgeTexture_surfaceFX_opus, 24);
#else
#define TextureWetnessEdgeTexture_surfaceFX_opus InstancedDrawBundleTextures2D[GetIDBTextureIndex(8)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TextureWetnessEdgeTexture_surfaceFX_winter, 25);
#else
#define TextureWetnessEdgeTexture_surfaceFX_winter InstancedDrawBundleTextures2D[GetIDBTextureIndex(9)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_Glossiness 1
#define MATERIAL_INPUT_IS_USED_Glossiness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_INPUT_IS_USED_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"
#include "CarConstantBuffer.hlsl"

struct surfaceFX_opusShaderFunctionInput
{
	SamplerState SamplerStates;
	float4 DiffuseColour;
	float4 MetalColour;
	float4 Metalness;
};

struct surfaceFX_opusShaderFunctionOutput
{
	float4 DiffuseColor;
	float4 Normal;
	float4 F0;
	float4 Glossiness;
	float4 CarAOOverride;
	float4 DiffuseColorNoBlend;
	float4 DustMask;
	float4 CombinedCoverage;
	float4 WetnessAmount;
	float4 MudDiffMask;
	float4 NormalMask;
	float4 F0Mask;
	float4 GlossMask;
};

surfaceFX_opusShaderFunctionOutput surfaceFX_opusShaderFunction(PS_IN In, surfaceFX_opusShaderFunctionInput dataIn)
{
	// Type:FunctionInputNode, Name:DiffuseColour_surfaceFX_opus
	float4 DiffuseColour_surfaceFX_opus = dataIn.DiffuseColour;
	float4 DiffuseColour_surfaceFX_opusPreview = float4(0,0,0,0);
	
	// Type:ColorNode, Name:ColorDryDust_surfaceFX_opus
	float4 ColorDryDust_surfaceFX_opus = ColorDryDustColorParam_surfaceFX_opus;
	float4 ColorDryDust_surfaceFX_opusRed = ColorDryDustColorParam_surfaceFX_opus.rrrr;
	float4 ColorDryDust_surfaceFX_opusGreen = ColorDryDustColorParam_surfaceFX_opus.gggg;
	float4 ColorDryDust_surfaceFX_opusBlue = ColorDryDustColorParam_surfaceFX_opus.bbbb;
	float4 ColorDryDust_surfaceFX_opusAlpha = ColorDryDustColorParam_surfaceFX_opus.aaaa;
	
	// Type:ColorNode, Name:ColorWetDust_surfaceFX_opus
	float4 ColorWetDust_surfaceFX_opus = ColorWetDustColorParam_surfaceFX_opus;
	float4 ColorWetDust_surfaceFX_opusRed = ColorWetDustColorParam_surfaceFX_opus.rrrr;
	float4 ColorWetDust_surfaceFX_opusGreen = ColorWetDustColorParam_surfaceFX_opus.gggg;
	float4 ColorWetDust_surfaceFX_opusBlue = ColorWetDustColorParam_surfaceFX_opus.bbbb;
	float4 ColorWetDust_surfaceFX_opusAlpha = ColorWetDustColorParam_surfaceFX_opus.aaaa;
	
	// Type:CarWetAmountNode, Name:GlobalCarWetness_surfaceFX_opus
	float4 GlobalCarWetness_surfaceFX_opus = GetWetMudAmount().xxxx;
	
	// Type:FloatNode, Name:floatNoiseTexStepRange0_surfaceFX_opus
	float4 floatNoiseTexStepRange0_surfaceFX_opus = float4(-0.1, -0.1, -0.1, -0.1);
	
	// Type:Vector4Node, Name:WheelVertColor_surfaceFX_opus
	float4 WheelVertColor_surfaceFX_opus = float4(0, 0, 0, 1) ;
	
	// Type:FloatNode, Name:startOfWheelWading_surfaceFX_opus
	float4 startOfWheelWading_surfaceFX_opus = float4(-0.38, -0.38, -0.38, -0.38);
	
	// Type:CarTireWadingLevelNode, Name:CarTireWadingLevel_surfaceFX_opus
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IN_MATERIAL_EDITOR)
	float4 CarTireWadingLevel_surfaceFX_opus = GetTireWadingLevel();
	#else
	float4 CarTireWadingLevel_surfaceFX_opus = float4(0,0,0,0);
	#endif
	
	// Type:AddNode, Name:Add5_surfaceFX_opus
	float4 Add5_surfaceFX_opus = startOfWheelWading_surfaceFX_opus + CarTireWadingLevel_surfaceFX_opus;
	
	// Type:VertexColor, Name:VertexColor_surfaceFX_opus
	float4 VertexColor_surfaceFX_opus = GetColor(In);float4 VertexColor_surfaceFX_opusAlpha = VertexColor_surfaceFX_opus.aaaa;
	float4 VertexColor_surfaceFX_opusRed = VertexColor_surfaceFX_opus.rrrr;
	float4 VertexColor_surfaceFX_opusGreen = VertexColor_surfaceFX_opus.gggg;
	float4 VertexColor_surfaceFX_opusBlue = VertexColor_surfaceFX_opus.bbbb;
	
	// Type:CarWadingWetnessLevelNode, Name:CarWadingWetnessLevel_surfaceFX_opus
	float4 CarWadingWetnessLevel_surfaceFX_opus = GetRubberAmount().xxxx;
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel_surfaceFX_opus
	float4 CarPartIsWheel_surfaceFX_opus;
	float4 CarPartIsWheel_surfaceFX_opusOut1;
	float4 CarPartIsWheel_surfaceFX_opusOut2;
	float4 CarPartIsWheel_surfaceFX_opusOut3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel_surfaceFX_opus = VertexColor_surfaceFX_opus;
	CarPartIsWheel_surfaceFX_opusOut1 = CarWadingWetnessLevel_surfaceFX_opus;
	CarPartIsWheel_surfaceFX_opusOut2 = float4(1, 1, 1, 1);
	CarPartIsWheel_surfaceFX_opusOut3 = float4(1, 1, 1, 1);
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel_surfaceFX_opus = WheelVertColor_surfaceFX_opus;
		CarPartIsWheel_surfaceFX_opusOut1 = Add5_surfaceFX_opus;
		CarPartIsWheel_surfaceFX_opusOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_surfaceFX_opusOut3 = float4(1, 1, 1, 1);
	}
	else
	{
		CarPartIsWheel_surfaceFX_opus = VertexColor_surfaceFX_opus;
		CarPartIsWheel_surfaceFX_opusOut1 = CarWadingWetnessLevel_surfaceFX_opus;
		CarPartIsWheel_surfaceFX_opusOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_surfaceFX_opusOut3 = float4(1, 1, 1, 1);
	}
	#endif
	
	// Type:FloatNode, Name:WadingSplashTransitionRangeInMeters_surfaceFX_opus
	float4 WadingSplashTransitionRangeInMeters_surfaceFX_opus = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:AddNode, Name:Add2_surfaceFX_opus
	float4 Add2_surfaceFX_opus = WadingSplashTransitionRangeInMeters_surfaceFX_opus + CarPartIsWheel_surfaceFX_opusOut1;
	
	// Type:FloatNode, Name:floatKickupContributionScaler_surfaceFX_opus
	float4 floatKickupContributionScaler_surfaceFX_opus = float4(-0.25, -0.25, -0.25, -0.25);
	
	// Type:SwizzleNode, Name:SwizzleG0_surfaceFX_opus
	float4 SwizzleG0_surfaceFX_opus = CarPartIsWheel_surfaceFX_opus.yyyw;
	
	// Type:FloatNode, Name:FloatAdjustmentOnly_surfaceFX_opus
	float4 FloatAdjustmentOnly_surfaceFX_opus = float4(1.9, 1.9, 1.9, 1.9);
	
	// Type:PowNode, Name:PowDeGammaG_plusAdjustment_surfaceFX_opus
	float4 PowDeGammaG_plusAdjustment_surfaceFX_opus = pow( SwizzleG0_surfaceFX_opus, FloatAdjustmentOnly_surfaceFX_opus );
	
	// Type:MultiplyNode, Name:mulModulatedKickupVC_surfaceFX_opus
	float4 mulModulatedKickupVC_surfaceFX_opus = floatKickupContributionScaler_surfaceFX_opus * PowDeGammaG_plusAdjustment_surfaceFX_opus;
	
	// Type:SwizzleNode, Name:SwizzleR0_surfaceFX_opus
	float4 SwizzleR0_surfaceFX_opus = CarPartIsWheel_surfaceFX_opus.xxxw;
	
	// Type:FloatNode, Name:HeightToVertColorRatio_surfaceFX_opus
	float4 HeightToVertColorRatio_surfaceFX_opus = float4(2, 2, 2, 2);
	
	// Type:MultiplyNode, Name:MulToMeters_surfaceFX_opus
	float4 MulToMeters_surfaceFX_opus = SwizzleR0_surfaceFX_opus * HeightToVertColorRatio_surfaceFX_opus;
	
	// Type:AddNode, Name:Add4_surfaceFX_opus
	float4 Add4_surfaceFX_opus = mulModulatedKickupVC_surfaceFX_opus + MulToMeters_surfaceFX_opus;
	
	// Type:SaturateNode, Name:Saturate0_surfaceFX_opus
	float4 Saturate0_surfaceFX_opus = saturate( Add4_surfaceFX_opus ); 
	
	// Type:StepNode, Name:StepWadingLevel_surfaceFX_opus
	float4 StepWadingLevel_surfaceFX_opus = linearstep( CarPartIsWheel_surfaceFX_opusOut1, Add2_surfaceFX_opus, Saturate0_surfaceFX_opus );
	
	// Type:AddNode, Name:Add200_surfaceFX_opus
	float4 Add200_surfaceFX_opus = floatNoiseTexStepRange0_surfaceFX_opus + StepWadingLevel_surfaceFX_opus;
	
	// Type:FloatNode, Name:MaskWheelBlurred_surfaceFX_opus
	float4 MaskWheelBlurred_surfaceFX_opus = float4(0.8706, 0.8706, 0.8706, 0.8706);
	
	// Type:UVNode, Name:CH2UV1_surfaceFX_opus
	float4 CH2UV1_surfaceFX_opus = GetTexCoord1(In).xyxy;
	float4 CH2UV1_surfaceFX_opusTangent = GetWorldTangent1(In);
	float4 CH2UV1_surfaceFX_opusUCoord = GetTexCoord1(In).xxxx;
	float4 CH2UV1_surfaceFX_opusVCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:TextureWetnessEdge_surfaceFX_opus
	float4 TextureWetnessEdge_surfaceFX_opus = TextureWetnessEdgeTexture_surfaceFX_opus.Sample(g_samplerLinearWrap, CH2UV1_surfaceFX_opus.xy * TextureWetnessEdgeTiling_surfaceFX_opus);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TextureWetnessEdge_surfaceFX_opusMip = GetDebugMipColour(TextureWetnessEdgeTexture_surfaceFX_opus, g_samplerLinearWrap, CH2UV1_surfaceFX_opus.xy * TextureWetnessEdgeTiling_surfaceFX_opus);
	#else
	float4 TextureWetnessEdge_surfaceFX_opusMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TextureWetnessEdge_surfaceFX_opusAlpha = TextureWetnessEdge_surfaceFX_opus.aaaa;
	float4 TextureWetnessEdge_surfaceFX_opusRed = TextureWetnessEdge_surfaceFX_opus.rrrr;
	float4 TextureWetnessEdge_surfaceFX_opusGreen = TextureWetnessEdge_surfaceFX_opus.gggg;
	float4 TextureWetnessEdge_surfaceFX_opusBlue = TextureWetnessEdge_surfaceFX_opus.bbbb;
	Texture2D TextureWetnessEdge_surfaceFX_opusRef = TextureWetnessEdgeTexture_surfaceFX_opus;
	
	// Type:FloatNode, Name:MaskWheelBlurred0_surfaceFX_opus
	float4 MaskWheelBlurred0_surfaceFX_opus = float4(0.2863, 0.2863, 0.2863, 0.2863);
	
	// Type:CarTireVelocityNode, Name:CarTireVelocity_surfaceFX_opus
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IN_MATERIAL_EDITOR)
	float4 CarTireVelocity_surfaceFX_opus = GetTireVelocityAmount();
	#else
	float4 CarTireVelocity_surfaceFX_opus = float4(0,0,0,0);
	#endif
	
	// Type:LerpNode, Name:Lerp00_surfaceFX_opus
	float4 Lerp00_surfaceFX_opus = lerp(TextureWetnessEdge_surfaceFX_opusRed, MaskWheelBlurred0_surfaceFX_opus, CarTireVelocity_surfaceFX_opus.x);
	
	// Type:TextureNode, Name:TexLowFrequencyNoise_surfaceFX_opus
	float4 TexLowFrequencyNoise_surfaceFX_opus = TexLowFrequencyNoiseTexture_surfaceFX_opus.Sample(g_samplerLinearWrap, CH2UV1_surfaceFX_opus.xy * TexLowFrequencyNoiseTiling_surfaceFX_opus);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TexLowFrequencyNoise_surfaceFX_opusMip = GetDebugMipColour(TexLowFrequencyNoiseTexture_surfaceFX_opus, g_samplerLinearWrap, CH2UV1_surfaceFX_opus.xy * TexLowFrequencyNoiseTiling_surfaceFX_opus);
	#else
	float4 TexLowFrequencyNoise_surfaceFX_opusMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TexLowFrequencyNoise_surfaceFX_opusAlpha = TexLowFrequencyNoise_surfaceFX_opus.aaaa;
	float4 TexLowFrequencyNoise_surfaceFX_opusRed = TexLowFrequencyNoise_surfaceFX_opus.rrrr;
	float4 TexLowFrequencyNoise_surfaceFX_opusGreen = TexLowFrequencyNoise_surfaceFX_opus.gggg;
	float4 TexLowFrequencyNoise_surfaceFX_opusBlue = TexLowFrequencyNoise_surfaceFX_opus.bbbb;
	Texture2D TexLowFrequencyNoise_surfaceFX_opusRef = TexLowFrequencyNoiseTexture_surfaceFX_opus;
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel_noise_surfaceFX_opus
	float4 CarPartIsWheel_noise_surfaceFX_opus;
	float4 CarPartIsWheel_noise_surfaceFX_opusOut1;
	float4 CarPartIsWheel_noise_surfaceFX_opusOut2;
	float4 CarPartIsWheel_noise_surfaceFX_opusOut3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel_noise_surfaceFX_opus = TexLowFrequencyNoise_surfaceFX_opusRed;
	CarPartIsWheel_noise_surfaceFX_opusOut1 = TextureWetnessEdge_surfaceFX_opusRed;
	CarPartIsWheel_noise_surfaceFX_opusOut2 = float4(1, 1, 1, 1);
	CarPartIsWheel_noise_surfaceFX_opusOut3 = float4(1, 1, 1, 1);
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel_noise_surfaceFX_opus = MaskWheelBlurred_surfaceFX_opus;
		CarPartIsWheel_noise_surfaceFX_opusOut1 = Lerp00_surfaceFX_opus;
		CarPartIsWheel_noise_surfaceFX_opusOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_noise_surfaceFX_opusOut3 = float4(1, 1, 1, 1);
	}
	else
	{
		CarPartIsWheel_noise_surfaceFX_opus = TexLowFrequencyNoise_surfaceFX_opusRed;
		CarPartIsWheel_noise_surfaceFX_opusOut1 = TextureWetnessEdge_surfaceFX_opusRed;
		CarPartIsWheel_noise_surfaceFX_opusOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_noise_surfaceFX_opusOut3 = float4(1, 1, 1, 1);
	}
	#endif
	
	// Type:StepNode, Name:StepNoiseTexture_surfaceFX_opus
	float4 StepNoiseTexture_surfaceFX_opus = linearstep( Add200_surfaceFX_opus, StepWadingLevel_surfaceFX_opus, CarPartIsWheel_noise_surfaceFX_opusOut1 );
	
	// Type:MaxNode, Name:MaxWetMask_surfaceFX_opus
	float4 MaxWetMask_surfaceFX_opus = max(GlobalCarWetness_surfaceFX_opus, StepNoiseTexture_surfaceFX_opus);
	
	// Type:OneMinusNode, Name:OneMinus5_surfaceFX_opus
	float4 OneMinus5_surfaceFX_opus = 1 - MulToMeters_surfaceFX_opus;
	
	// Type:FloatNode, Name:TractorTyreOverride_surfaceFX_opus
	float4 TractorTyreOverride_surfaceFX_opus = float4(1, 1, 1, 1);
	
	// Type:MultiplyNode, Name:MulHeightMask_surfaceFX_opus
	float4 MulHeightMask_surfaceFX_opus = OneMinus5_surfaceFX_opus * TractorTyreOverride_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:mulKickupAmount_surfaceFX_opus
	float4 mulKickupAmount_surfaceFX_opus = TractorTyreOverride_surfaceFX_opus * PowDeGammaG_plusAdjustment_surfaceFX_opus;
	
	// Type:AddNode, Name:AddUpAllMudMaskGradientForOptimisation_surfaceFX_opus
	float4 AddUpAllMudMaskGradientForOptimisation_surfaceFX_opus = MulHeightMask_surfaceFX_opus + mulKickupAmount_surfaceFX_opus;
	
	// Type:FloatNode, Name:Float9_surfaceFX_opus
	float4 Float9_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:MinStep0_surfaceFX_opus
	float4 MinStep0_surfaceFX_opus = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:FloatNode, Name:maxStep0_surfaceFX_opus
	float4 maxStep0_surfaceFX_opus = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:FloatNode, Name:mudNoiseMultiplier_surfaceFX_opus
	float4 mudNoiseMultiplier_surfaceFX_opus = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:OneMinusNode, Name:OneMinus0_surfaceFX_opus
	float4 OneMinus0_surfaceFX_opus = 1 - mudNoiseMultiplier_surfaceFX_opus;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd_surfaceFX_opus
	float4 MultiplyAdd_surfaceFX_opus = CarPartIsWheel_noise_surfaceFX_opus * mudNoiseMultiplier_surfaceFX_opus + OneMinus0_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:xLowNoise_surfaceFX_opus
	float4 xLowNoise_surfaceFX_opus = MultiplyAdd_surfaceFX_opus * MulHeightMask_surfaceFX_opus;
	
	// Type:StepNode, Name:StepSpecSpots_surfaceFX_opus
	float4 StepSpecSpots_surfaceFX_opus = smoothstep( MinStep0_surfaceFX_opus, maxStep0_surfaceFX_opus, xLowNoise_surfaceFX_opus );
	
	// Type:SamplerStatesFunctionInputNode, Name:SamplerStates_surfaceFX_opus
	SamplerState SamplerStates_surfaceFX_opus = dataIn.SamplerStates;
	float4 SamplerStates_surfaceFX_opusPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:MudTileNonDirectional_surfaceFX_opus
	float4 MudTileNonDirectional_surfaceFX_opus = MudTileNonDirectionalTexture_surfaceFX_opus.Sample(SamplerStatesSampler, CH2UV1_surfaceFX_opus.xy * MudTileNonDirectionalTiling_surfaceFX_opus);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MudTileNonDirectional_surfaceFX_opusMip = GetDebugMipColour(MudTileNonDirectionalTexture_surfaceFX_opus, SamplerStatesSampler, CH2UV1_surfaceFX_opus.xy * MudTileNonDirectionalTiling_surfaceFX_opus);
	#else
	float4 MudTileNonDirectional_surfaceFX_opusMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MudTileNonDirectional_surfaceFX_opusAlpha = MudTileNonDirectional_surfaceFX_opus.aaaa;
	float4 MudTileNonDirectional_surfaceFX_opusRed = MudTileNonDirectional_surfaceFX_opus.rrrr;
	float4 MudTileNonDirectional_surfaceFX_opusGreen = MudTileNonDirectional_surfaceFX_opus.gggg;
	float4 MudTileNonDirectional_surfaceFX_opusBlue = MudTileNonDirectional_surfaceFX_opus.bbbb;
	Texture2D MudTileNonDirectional_surfaceFX_opusRef = MudTileNonDirectionalTexture_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:MulSpotNonDirectional_surfaceFX_opus
	float4 MulSpotNonDirectional_surfaceFX_opus = StepSpecSpots_surfaceFX_opus * MudTileNonDirectional_surfaceFX_opusGreen;
	
	// Type:FloatNode, Name:minStep_surfaceFX_opus
	float4 minStep_surfaceFX_opus = float4(0.36, 0.36, 0.36, 0.36);
	
	// Type:FloatNode, Name:maxStep_surfaceFX_opus
	float4 maxStep_surfaceFX_opus = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:Step_surfaceFX_opus
	float4 Step_surfaceFX_opus = smoothstep( minStep_surfaceFX_opus, maxStep_surfaceFX_opus, xLowNoise_surfaceFX_opus );
	
	// Type:MultiplyNode, Name:MulSolid_surfaceFX_opus
	float4 MulSolid_surfaceFX_opus = Step_surfaceFX_opus * MudTileNonDirectional_surfaceFX_opusRed;
	
	// Type:OneMinusNode, Name:OneMinusStreakAmount0_surfaceFX_opus
	float4 OneMinusStreakAmount0_surfaceFX_opus = 1 - mulKickupAmount_surfaceFX_opus;
	
	// Type:FloatNode, Name:StepRangeAccumSplash_surfaceFX_opus
	float4 StepRangeAccumSplash_surfaceFX_opus = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:AddNode, Name:Add10_surfaceFX_opus
	float4 Add10_surfaceFX_opus = OneMinusStreakAmount0_surfaceFX_opus + StepRangeAccumSplash_surfaceFX_opus;
	
	// Type:StepNode, Name:StepAccumSplash_surfaceFX_opus
	float4 StepAccumSplash_surfaceFX_opus = linearstep( OneMinusStreakAmount0_surfaceFX_opus, Add10_surfaceFX_opus, MudTileNonDirectional_surfaceFX_opusBlue );
	
	// Type:OneMinusNode, Name:OneMinusStreakAmount_surfaceFX_opus
	float4 OneMinusStreakAmount_surfaceFX_opus = 1 - mulKickupAmount_surfaceFX_opus;
	
	// Type:FloatNode, Name:StepRangeAccumStreaks_surfaceFX_opus
	float4 StepRangeAccumStreaks_surfaceFX_opus = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:AddNode, Name:Add1_surfaceFX_opus
	float4 Add1_surfaceFX_opus = OneMinusStreakAmount_surfaceFX_opus + StepRangeAccumStreaks_surfaceFX_opus;
	
	// Type:UVNode, Name:CH4UV3_surfaceFX_opus
	float4 CH4UV3_surfaceFX_opus = GetTexCoord3(In).xyxy;
	float4 CH4UV3_surfaceFX_opusTangent = GetWorldTangent3(In);
	float4 CH4UV3_surfaceFX_opusUCoord = GetTexCoord3(In).xxxx;
	float4 CH4UV3_surfaceFX_opusVCoord = GetTexCoord3(In).yyyy;
	
	// Type:TextureNode, Name:MudTileDirectionalLeft_surfaceFX_opus
	float4 MudTileDirectionalLeft_surfaceFX_opus = MudTileDirectionalLeftTexture_surfaceFX_opus.Sample(SamplerStatesSampler, CH4UV3_surfaceFX_opus.xy * MudTileDirectionalLeftTiling_surfaceFX_opus);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MudTileDirectionalLeft_surfaceFX_opusMip = GetDebugMipColour(MudTileDirectionalLeftTexture_surfaceFX_opus, SamplerStatesSampler, CH4UV3_surfaceFX_opus.xy * MudTileDirectionalLeftTiling_surfaceFX_opus);
	#else
	float4 MudTileDirectionalLeft_surfaceFX_opusMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MudTileDirectionalLeft_surfaceFX_opusAlpha = MudTileDirectionalLeft_surfaceFX_opus.aaaa;
	float4 MudTileDirectionalLeft_surfaceFX_opusRed = MudTileDirectionalLeft_surfaceFX_opus.rrrr;
	float4 MudTileDirectionalLeft_surfaceFX_opusGreen = MudTileDirectionalLeft_surfaceFX_opus.gggg;
	float4 MudTileDirectionalLeft_surfaceFX_opusBlue = MudTileDirectionalLeft_surfaceFX_opus.bbbb;
	Texture2D MudTileDirectionalLeft_surfaceFX_opusRef = MudTileDirectionalLeftTexture_surfaceFX_opus;
	
	// Type:FloatNode, Name:Float0_surfaceFX_opus
	float4 Float0_surfaceFX_opus = float4(-0.1, -0.1, -0.1, -0.1);
	
	// Type:FloatNode, Name:Float1_surfaceFX_opus
	float4 Float1_surfaceFX_opus = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:CarSpaceNormal, Name:CarSpaceNormal_surfaceFX_opus
	float4 CarSpaceNormal_surfaceFX_opus = normalize(mul(float4(GetWorldNormal(In).xyz, 0), g_CarInvWorldTransform));
	
	// Type:Vector4Node, Name:SideVector_surfaceFX_opus
	float4 SideVector_surfaceFX_opus = float4(1, 0, 0, 1) ;
	
	// Type:DotNode, Name:DotSideNormal_surfaceFX_opus
	float4 DotSideNormal_surfaceFX_opus = dot(CarSpaceNormal_surfaceFX_opus, SideVector_surfaceFX_opus);
	
	// Type:StepNode, Name:StepSideTexDirection_surfaceFX_opus
	float4 StepSideTexDirection_surfaceFX_opus = linearstep( Float0_surfaceFX_opus, Float1_surfaceFX_opus, DotSideNormal_surfaceFX_opus );
	
	// Type:LerpNode, Name:LerpSideStreaks_surfaceFX_opus
	float4 LerpSideStreaks_surfaceFX_opus = lerp(MudTileDirectionalLeft_surfaceFX_opusRed, MudTileDirectionalLeft_surfaceFX_opusBlue, StepSideTexDirection_surfaceFX_opus.x);
	
	// Type:StepNode, Name:StepAccumStreak_surfaceFX_opus
	float4 StepAccumStreak_surfaceFX_opus = linearstep( OneMinusStreakAmount_surfaceFX_opus, Add1_surfaceFX_opus, LerpSideStreaks_surfaceFX_opus );
	
	// Type:FloatNode, Name:stepStart_surfaceFX_opus
	float4 stepStart_surfaceFX_opus = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:FloatNode, Name:stepEnd_surfaceFX_opus
	float4 stepEnd_surfaceFX_opus = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:AbsNode, Name:Abs0_surfaceFX_opus
	float4 Abs0_surfaceFX_opus = abs( DotSideNormal_surfaceFX_opus ); 
	
	// Type:StepNode, Name:StepSideTexMask_surfaceFX_opus
	float4 StepSideTexMask_surfaceFX_opus = linearstep( stepStart_surfaceFX_opus, stepEnd_surfaceFX_opus, Abs0_surfaceFX_opus );
	
	// Type:LerpNode, Name:Lerp_surfaceFX_opus
	float4 Lerp_surfaceFX_opus = lerp(StepAccumSplash_surfaceFX_opus, StepAccumStreak_surfaceFX_opus, StepSideTexMask_surfaceFX_opus.x);
	
	// Type:MultiplyNode, Name:MulSolidTex_highFrequencyFix_surfaceFX_opus
	float4 MulSolidTex_highFrequencyFix_surfaceFX_opus = MudTileNonDirectional_surfaceFX_opusRed * Lerp_surfaceFX_opus;
	
	// Type:MaxNode, Name:MaxStreaksAndSolids_surfaceFX_opus
	float4 MaxStreaksAndSolids_surfaceFX_opus = max(MulSolid_surfaceFX_opus, MulSolidTex_highFrequencyFix_surfaceFX_opus);
	
	// Type:MaxNode, Name:MaxSpotsNonDirectional_surfaceFX_opus
	float4 MaxSpotsNonDirectional_surfaceFX_opus = max(MulSpotNonDirectional_surfaceFX_opus, MaxStreaksAndSolids_surfaceFX_opus);
	
	// Type:LerpNode, Name:LerpSideSpots_surfaceFX_opus
	float4 LerpSideSpots_surfaceFX_opus = lerp(MudTileDirectionalLeft_surfaceFX_opusGreen, MudTileDirectionalLeft_surfaceFX_opusAlpha, StepSideTexDirection_surfaceFX_opus.x);
	
	// Type:MultiplyNode, Name:MulSideMask0_surfaceFX_opus
	float4 MulSideMask0_surfaceFX_opus = LerpSideSpots_surfaceFX_opus * StepSideTexMask_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:MulSpotDirectional_surfaceFX_opus
	float4 MulSpotDirectional_surfaceFX_opus = StepSpecSpots_surfaceFX_opus * MulSideMask0_surfaceFX_opus;
	
	// Type:MaxNode, Name:MaxSpotsDirectional_surfaceFX_opus
	float4 MaxSpotsDirectional_surfaceFX_opus = max(MaxSpotsNonDirectional_surfaceFX_opus, MulSpotDirectional_surfaceFX_opus);
	
	// Type:DynamicBranchNode, Name:DynamicOptimisationForNonMuddyPixels_surfaceFX_opus
	float4 DynamicOptimisationForNonMuddyPixels_surfaceFX_opus;
	[branch]
	if(AddUpAllMudMaskGradientForOptimisation_surfaceFX_opus.x < DynamicOptimisationForNonMuddyPixelsRefValue_surfaceFX_opus.x)
	{
		DynamicOptimisationForNonMuddyPixels_surfaceFX_opus = Float9_surfaceFX_opus;
	}
	else
	{
		DynamicOptimisationForNonMuddyPixels_surfaceFX_opus = MaxSpotsDirectional_surfaceFX_opus;
	}
	
	// Type:StepNode, Name:StepLowLODs_surfaceFX_opus
	float4 StepLowLODs_surfaceFX_opus = linearstep( minStep_surfaceFX_opus, maxStep_surfaceFX_opus, xLowNoise_surfaceFX_opus );
	
	// Type:CarLODNode, Name:CarLODOptimisation_surfaceFX_opus
	float4 CarLODOptimisation_surfaceFX_opus;
	[branch]
	if (GetLODLessThanOrEqual(3) )
	{
		CarLODOptimisation_surfaceFX_opus = DynamicOptimisationForNonMuddyPixels_surfaceFX_opus;
	}
	else
	{
		CarLODOptimisation_surfaceFX_opus = StepLowLODs_surfaceFX_opus;
	}
	
	// Type:FloatNode, Name:NoMud_surfaceFX_opus
	float4 NoMud_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:CarReceivesOilNode, Name:CarReceivesOil_surfaceFX_opus
	float4 CarReceivesOil_surfaceFX_opus;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesOil_surfaceFX_opus = NoMud_surfaceFX_opus;
	#else
	[branch]
	if (ReceivesOil())
	{
		CarReceivesOil_surfaceFX_opus = CarLODOptimisation_surfaceFX_opus;
	}
	else
	{
		CarReceivesOil_surfaceFX_opus = NoMud_surfaceFX_opus;
	}
	#endif
	
	// Type:FloatNode, Name:Float15_surfaceFX_opus
	float4 Float15_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:FloatNaturalWetBuildupMax_surfaceFX_opus
	float4 FloatNaturalWetBuildupMax_surfaceFX_opus = float4(0.75, 0.75, 0.75, 0.75);
	
	// Type:FloatNode, Name:Float14_surfaceFX_opus
	float4 Float14_surfaceFX_opus = float4(-0.2, -0.2, -0.2, -0.2);
	
	// Type:FloatNode, Name:Float16_surfaceFX_opus
	float4 Float16_surfaceFX_opus = float4(-1, -1, -1, -1);
	
	// Type:FloatNode, Name:Float17_surfaceFX_opus
	float4 Float17_surfaceFX_opus = float4(1, 1, 1, 1);
	
	// Type:CarMudDampAmountNode, Name:CarMudDampAmount_surfaceFX_opus
	float4 CarMudDampAmount_surfaceFX_opus = GetCarMudDampAmount().xxxx;
	
	// Type:StepNode, Name:StepRemapGlobalNaturalWetRange_surfaceFX_opus
	float4 StepRemapGlobalNaturalWetRange_surfaceFX_opus = linearstep( Float16_surfaceFX_opus, Float17_surfaceFX_opus, CarMudDampAmount_surfaceFX_opus );
	
	// Type:OneMinusNode, Name:OneMinus3_surfaceFX_opus
	float4 OneMinus3_surfaceFX_opus = 1 - StepRemapGlobalNaturalWetRange_surfaceFX_opus;
	
	// Type:AddNode, Name:Add30_surfaceFX_opus
	float4 Add30_surfaceFX_opus = Float14_surfaceFX_opus + OneMinus3_surfaceFX_opus;
	
	// Type:SaturateNode, Name:Saturate_surfaceFX_opus
	float4 Saturate_surfaceFX_opus = saturate( Add30_surfaceFX_opus ); 
	
	// Type:FloatNode, Name:initialStepMax_surfaceFX_opus
	float4 initialStepMax_surfaceFX_opus = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:AddNode, Name:Add3_surfaceFX_opus
	float4 Add3_surfaceFX_opus = OneMinus3_surfaceFX_opus + initialStepMax_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:mulLowFrequencyNoise_surfaceFX_opus
	float4 mulLowFrequencyNoise_surfaceFX_opus = CarPartIsWheel_noise_surfaceFX_opusOut1 * CarPartIsWheel_noise_surfaceFX_opus;
	
	// Type:FloatNode, Name:Float13_surfaceFX_opus
	float4 Float13_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:float14_surfaceFX_opus
	float4 float14_surfaceFX_opus = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:CarLODNode, Name:CarLODoptimisation1_surfaceFX_opus
	float4 CarLODoptimisation1_surfaceFX_opus;
	[branch]
	if (GetLODLessThanOrEqual(3) )
	{
		CarLODoptimisation1_surfaceFX_opus = MaxStreaksAndSolids_surfaceFX_opus;
	}
	else
	{
		CarLODoptimisation1_surfaceFX_opus = StepLowLODs_surfaceFX_opus;
	}
	
	// Type:StepNode, Name:StepFlatten_surfaceFX_opus
	float4 StepFlatten_surfaceFX_opus = linearstep( Float13_surfaceFX_opus, float14_surfaceFX_opus, CarLODoptimisation1_surfaceFX_opus );
	
	// Type:MultiplyNode, Name:Multiply2_surfaceFX_opus
	float4 Multiply2_surfaceFX_opus = mulLowFrequencyNoise_surfaceFX_opus * StepFlatten_surfaceFX_opus;
	
	// Type:StepNode, Name:StepMudDampnessBuildupMask_surfaceFX_opus
	float4 StepMudDampnessBuildupMask_surfaceFX_opus = linearstep( Saturate_surfaceFX_opus, Add3_surfaceFX_opus, Multiply2_surfaceFX_opus );
	
	// Type:MultiplyNode, Name:Multiply0_surfaceFX_opus
	float4 Multiply0_surfaceFX_opus = FloatNaturalWetBuildupMax_surfaceFX_opus * StepMudDampnessBuildupMask_surfaceFX_opus;
	
	// Type:DynamicBranchNode, Name:DynamicBranch_surfaceFX_opus
	float4 DynamicBranch_surfaceFX_opus;
	[branch]
	if(CarReceivesOil_surfaceFX_opus.x == DynamicBranchRefValue_surfaceFX_opus.x)
	{
		DynamicBranch_surfaceFX_opus = Float15_surfaceFX_opus;
	}
	else
	{
		DynamicBranch_surfaceFX_opus = Multiply0_surfaceFX_opus;
	}
	
	// Type:MaxNode, Name:MaxDampnessBuildupMask_surfaceFX_opus
	float4 MaxDampnessBuildupMask_surfaceFX_opus = max(MaxWetMask_surfaceFX_opus, DynamicBranch_surfaceFX_opus);
	
	// Type:LerpNode, Name:LerpColourDryWet_surfaceFX_opus
	float4 LerpColourDryWet_surfaceFX_opus = lerp(ColorDryDust_surfaceFX_opus, ColorWetDust_surfaceFX_opus, MaxDampnessBuildupMask_surfaceFX_opus.x);
	
	// Type:ColorNode, Name:ColorDryMud_surfaceFX_opus
	float4 ColorDryMud_surfaceFX_opus = ColorDryMudColorParam_surfaceFX_opus;
	float4 ColorDryMud_surfaceFX_opusRed = ColorDryMudColorParam_surfaceFX_opus.rrrr;
	float4 ColorDryMud_surfaceFX_opusGreen = ColorDryMudColorParam_surfaceFX_opus.gggg;
	float4 ColorDryMud_surfaceFX_opusBlue = ColorDryMudColorParam_surfaceFX_opus.bbbb;
	float4 ColorDryMud_surfaceFX_opusAlpha = ColorDryMudColorParam_surfaceFX_opus.aaaa;
	
	// Type:ColorNode, Name:ColorWetMud_surfaceFX_opus
	float4 ColorWetMud_surfaceFX_opus = ColorWetMudColorParam_surfaceFX_opus;
	float4 ColorWetMud_surfaceFX_opusRed = ColorWetMudColorParam_surfaceFX_opus.rrrr;
	float4 ColorWetMud_surfaceFX_opusGreen = ColorWetMudColorParam_surfaceFX_opus.gggg;
	float4 ColorWetMud_surfaceFX_opusBlue = ColorWetMudColorParam_surfaceFX_opus.bbbb;
	float4 ColorWetMud_surfaceFX_opusAlpha = ColorWetMudColorParam_surfaceFX_opus.aaaa;
	
	// Type:LerpNode, Name:LerpColourDryWet0_surfaceFX_opus
	float4 LerpColourDryWet0_surfaceFX_opus = lerp(ColorDryMud_surfaceFX_opus, ColorWetMud_surfaceFX_opus, MaxDampnessBuildupMask_surfaceFX_opus.x);
	
	// Type:FloatNode, Name:FloatNoINF_surfaceFX_opus
	float4 FloatNoINF_surfaceFX_opus = float4(0.001, 0.001, 0.001, 0.001);
	
	// Type:CarDirtAmountNode, Name:CarDirtAmount_surfaceFX_opus
	float4 CarDirtAmount_surfaceFX_opus = GetDirtAmount().xxxx;
	
	// Type:MultiplyNode, Name:xLowNoise0_surfaceFX_opus
	float4 xLowNoise0_surfaceFX_opus = CarDirtAmount_surfaceFX_opus * CarPartIsWheel_noise_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:xHighFrequencyDustTexture_surfaceFX_opus
	float4 xHighFrequencyDustTexture_surfaceFX_opus = xLowNoise0_surfaceFX_opus * MudTileNonDirectional_surfaceFX_opusAlpha;
	
	// Type:FloatNode, Name:Float6_surfaceFX_opus
	float4 Float6_surfaceFX_opus = float4(0.7, 0.7, 0.7, 0.7);
	
	// Type:FloatNode, Name:Float5_surfaceFX_opus
	float4 Float5_surfaceFX_opus = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:ViewVectorNode, Name:ViewVector_surfaceFX_opus
	float4 ViewVector_surfaceFX_opus = float4(GetViewVector(), 0);
	// Type:WorldNormalNode, Name:WorldNormal_surfaceFX_opus
	float4 WorldNormal_surfaceFX_opus = float4(GetWorldNormal(In).xyz, 0);
	// Type:DotNode, Name:Dot0_surfaceFX_opus
	float4 Dot0_surfaceFX_opus = dot(ViewVector_surfaceFX_opus, WorldNormal_surfaceFX_opus);
	
	// Type:OneMinusNode, Name:OneMinus1_surfaceFX_opus
	float4 OneMinus1_surfaceFX_opus = 1 - Dot0_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:Multiply4_surfaceFX_opus
	float4 Multiply4_surfaceFX_opus = Float5_surfaceFX_opus * OneMinus1_surfaceFX_opus;
	
	// Type:AddNode, Name:AddViewVectorVariation_surfaceFX_opus
	float4 AddViewVectorVariation_surfaceFX_opus = Float6_surfaceFX_opus + Multiply4_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:xViewFade_surfaceFX_opus
	float4 xViewFade_surfaceFX_opus = xHighFrequencyDustTexture_surfaceFX_opus * AddViewVectorVariation_surfaceFX_opus;
	
	// Type:FloatNode, Name:maxDustThicknessPercentage1_wheel_surfaceFX_opus
	float4 maxDustThicknessPercentage1_wheel_surfaceFX_opus = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:MultiplyNode, Name:xDustCombinedWheel_surfaceFX_opus
	float4 xDustCombinedWheel_surfaceFX_opus = xViewFade_surfaceFX_opus * maxDustThicknessPercentage1_wheel_surfaceFX_opus;
	
	// Type:FloatNode, Name:maxDustThicknessPercentageBottom_surfaceFX_opus
	float4 maxDustThicknessPercentageBottom_surfaceFX_opus = float4(0.7, 0.7, 0.7, 0.7);
	
	// Type:FloatNode, Name:maxDustThicknessPercentage1_surfaceFX_opus
	float4 maxDustThicknessPercentage1_surfaceFX_opus = float4(0.31, 0.31, 0.31, 0.31);
	
	// Type:FloatNode, Name:maxDustKickupThickness_surfaceFX_opus
	float4 maxDustKickupThickness_surfaceFX_opus = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FloatNode, Name:Float10_surfaceFX_opus
	float4 Float10_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:Float23_surfaceFX_opus
	float4 Float23_surfaceFX_opus = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:StepNode, Name:SmoothStep_kickupDust_surfaceFX_opus
	float4 SmoothStep_kickupDust_surfaceFX_opus = smoothstep( Float10_surfaceFX_opus, Float23_surfaceFX_opus, VertexColor_surfaceFX_opusGreen );
	
	// Type:LerpNode, Name:LerpKickupDust_surfaceFX_opus
	float4 LerpKickupDust_surfaceFX_opus = lerp(maxDustThicknessPercentage1_surfaceFX_opus, maxDustKickupThickness_surfaceFX_opus, SmoothStep_kickupDust_surfaceFX_opus.x);
	
	// Type:FloatNode, Name:FloatLowerVertColour0_surfaceFX_opus
	float4 FloatLowerVertColour0_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:FloatHigherVertColour0_surfaceFX_opus
	float4 FloatHigherVertColour0_surfaceFX_opus = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:StepNode, Name:SmoothStep_bottomFade0_surfaceFX_opus
	float4 SmoothStep_bottomFade0_surfaceFX_opus = smoothstep( FloatLowerVertColour0_surfaceFX_opus, FloatHigherVertColour0_surfaceFX_opus, VertexColor_surfaceFX_opusRed );
	
	// Type:LerpNode, Name:LerpBottomFadeMultiplier0_surfaceFX_opus
	float4 LerpBottomFadeMultiplier0_surfaceFX_opus = lerp(maxDustThicknessPercentageBottom_surfaceFX_opus, LerpKickupDust_surfaceFX_opus, SmoothStep_bottomFade0_surfaceFX_opus.x);
	
	// Type:FloatNode, Name:maxDustThicknessPercentageFront0_surfaceFX_opus
	float4 maxDustThicknessPercentageFront0_surfaceFX_opus = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FloatNode, Name:Float8_surfaceFX_opus
	float4 Float8_surfaceFX_opus = float4(0.28, 0.28, 0.28, 0.28);
	
	// Type:FloatNode, Name:Float20_surfaceFX_opus
	float4 Float20_surfaceFX_opus = float4(1, 1, 1, 1);
	
	// Type:Vector4Node, Name:FrontVector_surfaceFX_opus
	float4 FrontVector_surfaceFX_opus = float4(0, 0, 1, 1) ;
	
	// Type:DotNode, Name:DotFrontNormal_surfaceFX_opus
	float4 DotFrontNormal_surfaceFX_opus = dot(CarSpaceNormal_surfaceFX_opus, FrontVector_surfaceFX_opus);
	
	// Type:StepNode, Name:SmoothStep_frontFade_surfaceFX_opus
	float4 SmoothStep_frontFade_surfaceFX_opus = smoothstep( Float8_surfaceFX_opus, Float20_surfaceFX_opus, DotFrontNormal_surfaceFX_opus );
	
	// Type:LerpNode, Name:LerpFrontVectorScaler_surfaceFX_opus
	float4 LerpFrontVectorScaler_surfaceFX_opus = lerp(LerpBottomFadeMultiplier0_surfaceFX_opus, maxDustThicknessPercentageFront0_surfaceFX_opus, SmoothStep_frontFade_surfaceFX_opus.x);
	
	// Type:FloatNode, Name:maxSmearMaskMultipler_surfaceFX_opus
	float4 maxSmearMaskMultipler_surfaceFX_opus = float4(0.22, 0.22, 0.22, 0.22);
	
	// Type:MultiplyNode, Name:Multiply6_surfaceFX_opus
	float4 Multiply6_surfaceFX_opus = TextureWetnessEdge_surfaceFX_opusGreen * maxSmearMaskMultipler_surfaceFX_opus;
	
	// Type:OneMinusNode, Name:OneMinus_surfaceFX_opus
	float4 OneMinus_surfaceFX_opus = 1 - Multiply6_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:mulDustSmearMask_surfaceFX_opus
	float4 mulDustSmearMask_surfaceFX_opus = LerpFrontVectorScaler_surfaceFX_opus * OneMinus_surfaceFX_opus;
	
	// Type:FloatNode, Name:dustLowerPart_surfaceFX_opus
	float4 dustLowerPart_surfaceFX_opus = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:dustHigherPart_surfaceFX_opus
	float4 dustHigherPart_surfaceFX_opus = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:FloatNode, Name:FloatLowerVertColour_surfaceFX_opus
	float4 FloatLowerVertColour_surfaceFX_opus = float4(0.14, 0.14, 0.14, 0.14);
	
	// Type:FloatNode, Name:FloatHigherVertColour_surfaceFX_opus
	float4 FloatHigherVertColour_surfaceFX_opus = float4(0.35, 0.35, 0.35, 0.35);
	
	// Type:StepNode, Name:SmoothStep_heightFade_surfaceFX_opus
	float4 SmoothStep_heightFade_surfaceFX_opus = smoothstep( FloatLowerVertColour_surfaceFX_opus, FloatHigherVertColour_surfaceFX_opus, VertexColor_surfaceFX_opusRed );
	
	// Type:LerpNode, Name:LerpHeightFadeMultiplier_surfaceFX_opus
	float4 LerpHeightFadeMultiplier_surfaceFX_opus = lerp(dustLowerPart_surfaceFX_opus, dustHigherPart_surfaceFX_opus, SmoothStep_heightFade_surfaceFX_opus.x);
	
	// Type:MultiplyNode, Name:mulFadeRules_surfaceFX_opus
	float4 mulFadeRules_surfaceFX_opus = mulDustSmearMask_surfaceFX_opus * LerpHeightFadeMultiplier_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:xDustCombinedNonWheel_surfaceFX_opus
	float4 xDustCombinedNonWheel_surfaceFX_opus = xViewFade_surfaceFX_opus * mulFadeRules_surfaceFX_opus;
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel_dust_surfaceFX_opus
	float4 CarPartIsWheel_dust_surfaceFX_opus;
	float4 CarPartIsWheel_dust_surfaceFX_opusOut1;
	float4 CarPartIsWheel_dust_surfaceFX_opusOut2;
	float4 CarPartIsWheel_dust_surfaceFX_opusOut3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel_dust_surfaceFX_opus = xDustCombinedNonWheel_surfaceFX_opus;
	CarPartIsWheel_dust_surfaceFX_opusOut1 = float4(1, 1, 1, 1);
	CarPartIsWheel_dust_surfaceFX_opusOut2 = float4(1, 1, 1, 1);
	CarPartIsWheel_dust_surfaceFX_opusOut3 = float4(1, 1, 1, 1);
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel_dust_surfaceFX_opus = xDustCombinedWheel_surfaceFX_opus;
		CarPartIsWheel_dust_surfaceFX_opusOut1 = float4(1, 1, 1, 1);
		CarPartIsWheel_dust_surfaceFX_opusOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_dust_surfaceFX_opusOut3 = float4(1, 1, 1, 1);
	}
	else
	{
		CarPartIsWheel_dust_surfaceFX_opus = xDustCombinedNonWheel_surfaceFX_opus;
		CarPartIsWheel_dust_surfaceFX_opusOut1 = float4(1, 1, 1, 1);
		CarPartIsWheel_dust_surfaceFX_opusOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_dust_surfaceFX_opusOut3 = float4(1, 1, 1, 1);
	}
	#endif
	
	// Type:FloatNode, Name:LOD_approximate_surfaceFX_opus
	float4 LOD_approximate_surfaceFX_opus = float4(0.25, 0.25, 0.25, 0.25);
	
	// Type:MultiplyNode, Name:Multiply7_surfaceFX_opus
	float4 Multiply7_surfaceFX_opus = LOD_approximate_surfaceFX_opus * LerpHeightFadeMultiplier_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:lowerLODAverage_surfaceFX_opus
	float4 lowerLODAverage_surfaceFX_opus = xLowNoise0_surfaceFX_opus * Multiply7_surfaceFX_opus;
	
	// Type:CarLODNode, Name:CarLOD_surfaceFX_opus
	float4 CarLOD_surfaceFX_opus;
	[branch]
	if (GetLODLessThanOrEqual(2) )
	{
		CarLOD_surfaceFX_opus = CarPartIsWheel_dust_surfaceFX_opus;
	}
	else
	{
		CarLOD_surfaceFX_opus = lowerLODAverage_surfaceFX_opus;
	}
	
	// Type:FloatNode, Name:NoDust_surfaceFX_opus
	float4 NoDust_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:CarReceivesDirtNode, Name:CarReceivesDirt_surfaceFX_opus
	float4 CarReceivesDirt_surfaceFX_opus;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDirt_surfaceFX_opus = NoDust_surfaceFX_opus;
	#else
	[branch]
	if (ReceivesDirt())
	{
		CarReceivesDirt_surfaceFX_opus = CarLOD_surfaceFX_opus;
	}
	else
	{
		CarReceivesDirt_surfaceFX_opus = NoDust_surfaceFX_opus;
	}
	#endif
	
	// Type:AddNode, Name:AddMask_surfaceFX_opus
	float4 AddMask_surfaceFX_opus = CarReceivesDirt_surfaceFX_opus + CarReceivesOil_surfaceFX_opus;
	
	// Type:AddNode, Name:Add_surfaceFX_opus
	float4 Add_surfaceFX_opus = FloatNoINF_surfaceFX_opus + AddMask_surfaceFX_opus;
	
	// Type:DivideNode, Name:Divide_percentage_surfaceFX_opus
	float4 Divide_percentage_surfaceFX_opus = CarReceivesOil_surfaceFX_opus / Add_surfaceFX_opus;
	
	// Type:LerpNode, Name:LerpDiffColor_surfaceFX_opus
	float4 LerpDiffColor_surfaceFX_opus = lerp(LerpColourDryWet_surfaceFX_opus, LerpColourDryWet0_surfaceFX_opus, Divide_percentage_surfaceFX_opus.x);
	
	// Type:LerpNode, Name:SurfaceFX_DiffMud_surfaceFX_opus
	float4 SurfaceFX_DiffMud_surfaceFX_opus = lerp(DiffuseColour_surfaceFX_opus, LerpDiffColor_surfaceFX_opus, CarReceivesOil_surfaceFX_opus.x);
	
	// Type:FloatNode, Name:LumRangeMin_surfaceFX_opus
	float4 LumRangeMin_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:LumRangeMax_surfaceFX_opus
	float4 LumRangeMax_surfaceFX_opus = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:Vector4Node, Name:VectorDryDustLumCoefficient_surfaceFX_opus
	float4 VectorDryDustLumCoefficient_surfaceFX_opus = float4(0.3864, 0.3302, 0.2833, 0) ;
	
	// Type:FloatNode, Name:SSSMetalContribution_scaler_surfaceFX_opus
	float4 SSSMetalContribution_scaler_surfaceFX_opus = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FunctionInputNode, Name:MetalColour_surfaceFX_opus
	float4 MetalColour_surfaceFX_opus = dataIn.MetalColour;
	float4 MetalColour_surfaceFX_opusPreview = float4(0,0,0,0);
	
	// Type:MultiplyNode, Name:Multiply8_surfaceFX_opus
	float4 Multiply8_surfaceFX_opus = SSSMetalContribution_scaler_surfaceFX_opus * MetalColour_surfaceFX_opus;
	
	// Type:FunctionInputNode, Name:Metalness_surfaceFX_opus
	float4 Metalness_surfaceFX_opus = dataIn.Metalness;
	float4 Metalness_surfaceFX_opusPreview = float4(0,0,0,0);
	
	// Type:LerpNode, Name:LerpSSScontributors_surfaceFX_opus
	float4 LerpSSScontributors_surfaceFX_opus = lerp(SurfaceFX_DiffMud_surfaceFX_opus, Multiply8_surfaceFX_opus, Metalness_surfaceFX_opus.x);
	
	// Type:DotNode, Name:Dot_surfaceFX_opus
	float4 Dot_surfaceFX_opus = dot(VectorDryDustLumCoefficient_surfaceFX_opus, LerpSSScontributors_surfaceFX_opus);
	
	// Type:StepNode, Name:StepLumRange_surfaceFX_opus
	float4 StepLumRange_surfaceFX_opus = linearstep( LumRangeMin_surfaceFX_opus, LumRangeMax_surfaceFX_opus, Dot_surfaceFX_opus );
	
	// Type:FloatNode, Name:SSSWeighting_surfaceFX_opus
	float4 SSSWeighting_surfaceFX_opus = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:MultiplyAddNode, Name:MulAddSSSFactor_surfaceFX_opus
	float4 MulAddSSSFactor_surfaceFX_opus = StepLumRange_surfaceFX_opus * SSSWeighting_surfaceFX_opus + SSSWeighting_surfaceFX_opus;
	
	// Type:OneMinusNode, Name:OneMinus412_surfaceFX_opus
	float4 OneMinus412_surfaceFX_opus = 1 - CarReceivesDirt_surfaceFX_opus;
	
	// Type:FloatNode, Name:DustDiffMaskPower_surfaceFX_opus
	float4 DustDiffMaskPower_surfaceFX_opus = float4(5, 5, 5, 5);
	
	// Type:PowNode, Name:PowDiffRate_surfaceFX_opus
	float4 PowDiffRate_surfaceFX_opus = pow( OneMinus412_surfaceFX_opus, DustDiffMaskPower_surfaceFX_opus );
	
	// Type:OneMinusNode, Name:DustDiffMask_surfaceFX_opus
	float4 DustDiffMask_surfaceFX_opus = 1 - PowDiffRate_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:MulSSS_surfaceFX_opus
	float4 MulSSS_surfaceFX_opus = MulAddSSSFactor_surfaceFX_opus * DustDiffMask_surfaceFX_opus;
	
	// Type:LerpNode, Name:SurfaceFX_DiffDust_surfaceFX_opus
	float4 SurfaceFX_DiffDust_surfaceFX_opus = lerp(SurfaceFX_DiffMud_surfaceFX_opus, LerpDiffColor_surfaceFX_opus, MulSSS_surfaceFX_opus.x);
	
	// Type:NormalMapWithIntensityNode, Name:NormalMapWithIntensity_surfaceFX_opus
	float4 textureLookup_NormalMapWithIntensity_surfaceFX_opus = NormalMapWithIntensityTexture_surfaceFX_opus.Sample(SamplerStatesSampler, CH2UV1_surfaceFX_opus.xy * NormalMapWithIntensityTiling_surfaceFX_opus);
	#ifdef _MAX_
	textureLookup_NormalMapWithIntensity_surfaceFX_opus.xyz = pow(textureLookup_NormalMapWithIntensity_surfaceFX_opus.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus = (2.0f * textureLookup_NormalMapWithIntensity_surfaceFX_opus.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapWithIntensity_surfaceFX_opusGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus, NormalMapWithIntensitySpecPower_surfaceFX_opus);
	float4 NormalMapWithIntensity_surfaceFX_opusAlpha = textureLookup_NormalMapWithIntensity_surfaceFX_opus.aaaa;
	float4 NormalMapWithIntensity_surfaceFX_opusRed = textureLookup_NormalMapWithIntensity_surfaceFX_opus.rrrr;
	float4 NormalMapWithIntensity_surfaceFX_opusGreen = textureLookup_NormalMapWithIntensity_surfaceFX_opus.gggg;
	float4 NormalMapWithIntensity_surfaceFX_opusBlue = textureLookup_NormalMapWithIntensity_surfaceFX_opus.bbbb;
	tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus.x*tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus.x - tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus.y*tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus.xy *= g_GlobalNormalScale * NormalMapWithIntensityHeightScale_surfaceFX_opus.x;
	#else
	tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus.xy *= NormalMapWithIntensityHeightScale_surfaceFX_opus.x;
	#endif
	float4 NormalMapWithIntensity_surfaceFX_opus = float4(normalize(mul(tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_opus, float3x3(CH2UV1_surfaceFX_opusTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, CH2UV1_surfaceFX_opusTangent.xyz) * CH2UV1_surfaceFX_opusTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMapWithIntensity_surfaceFX_opus = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:F0ValuesNode, Name:F0Values_temp_surfaceFX_opus
	float4 F0Values_temp_surfaceFX_opus = float4(0.01790891, 0.01790891, 0.01790891, 1) ;
	
	// Type:FloatNode, Name:GlossMatte_surfaceFX_opus
	float4 GlossMatte_surfaceFX_opus = float4(0.05, 0.05, 0.05, 0.05);
	
	// Type:AOMapValueNode, Name:AOMapValue0_surfaceFX_opus
	float4 AOMapValue0_surfaceFX_opus = g_AOMapValue.xxxx;
	// Type:BlinnPhongPixelShadernode, Name:Root_surfaceFX_opus
	
	// Type:CarOilAmountNode, Name:CarOilAmount_surfaceFX_opus
	float4 CarOilAmount_surfaceFX_opus = GetOilAmount().xxxx;
	
	// Type:MaxNode, Name:Max_finalThickness_surfaceFX_opus
	float4 Max_finalThickness_surfaceFX_opus = max(CarReceivesDirt_surfaceFX_opus, CarReceivesOil_surfaceFX_opus);
	
	// Type:FloatNode, Name:MaxWaterAmount_surfaceFX_opus
	float4 MaxWaterAmount_surfaceFX_opus = float4(0.6, 0.6, 0.6, 0.6);
	
	// Type:MultiplyNode, Name:MulScaleWaterAmountFromWetMask_surfaceFX_opus
	float4 MulScaleWaterAmountFromWetMask_surfaceFX_opus = MaxWetMask_surfaceFX_opus * MaxWaterAmount_surfaceFX_opus;
	
	// Type:FloatNode, Name:Float11_surfaceFX_opus
	float4 Float11_surfaceFX_opus = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FloatNode, Name:Float12_surfaceFX_opus
	float4 Float12_surfaceFX_opus = float4(1, 1, 1, 1);
	
	// Type:StepNode, Name:StepNormalMask_surfaceFX_opus
	float4 StepNormalMask_surfaceFX_opus = linearstep( Float11_surfaceFX_opus, Float12_surfaceFX_opus, CarReceivesOil_surfaceFX_opus );
	
	// Type:FloatNode, Name:FloatDeGammaPlusAdjustment_surfaceFX_opus
	float4 FloatDeGammaPlusAdjustment_surfaceFX_opus = float4(0.9, 0.9, 0.9, 0.9);
	
	// Type:OneMinusNode, Name:OneMinus410_surfaceFX_opus
	float4 OneMinus410_surfaceFX_opus = 1 - CarReceivesOil_surfaceFX_opus;
	
	// Type:FloatNode, Name:Float701_surfaceFX_opus
	float4 Float701_surfaceFX_opus = float4(13, 13, 13, 13);
	
	// Type:PowNode, Name:PowGlossRate_surfaceFX_opus
	float4 PowGlossRate_surfaceFX_opus = pow( OneMinus410_surfaceFX_opus, Float701_surfaceFX_opus );
	
	// Type:OneMinusNode, Name:OneMinus40_surfaceFX_opus
	float4 OneMinus40_surfaceFX_opus = 1 - PowGlossRate_surfaceFX_opus;
	
	// Type:OneMinusNode, Name:OneMinus41_surfaceFX_opus
	float4 OneMinus41_surfaceFX_opus = 1 - CarReceivesDirt_surfaceFX_opus;
	
	// Type:FloatNode, Name:F0MaskPower_surfaceFX_opus
	float4 F0MaskPower_surfaceFX_opus = float4(10, 10, 10, 10);
	
	// Type:PowNode, Name:PowF0Rate_surfaceFX_opus
	float4 PowF0Rate_surfaceFX_opus = pow( OneMinus41_surfaceFX_opus, F0MaskPower_surfaceFX_opus );
	
	// Type:OneMinusNode, Name:OneMinus400_surfaceFX_opus
	float4 OneMinus400_surfaceFX_opus = 1 - PowF0Rate_surfaceFX_opus;
	
	// Type:FloatNode, Name:Float4_surfaceFX_opus
	float4 Float4_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:Float7_surfaceFX_opus
	float4 Float7_surfaceFX_opus = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:Step0_surfaceFX_opus
	float4 Step0_surfaceFX_opus = linearstep( Float4_surfaceFX_opus, Float7_surfaceFX_opus, CarReceivesOil_surfaceFX_opus );
	
	// Type:MaxNode, Name:MaxF0MaskFromDustAndMud_surfaceFX_opus
	float4 MaxF0MaskFromDustAndMud_surfaceFX_opus = max(OneMinus400_surfaceFX_opus, Step0_surfaceFX_opus);
	
	// Type:CarMudTint, Name:CarMudTint_surfaceFX_opus
	float4 CarMudTint_surfaceFX_opus = GetMudTint();
	
	// Type:MultiplyNode, Name:Multiply_surfaceFX_opus
	float4 Multiply_surfaceFX_opus = CarMudTint_surfaceFX_opus * LerpDiffColor_surfaceFX_opus;
	
	// Type:FloatNode, Name:MaxPorosityDarkeningScaler_surfaceFX_opus
	float4 MaxPorosityDarkeningScaler_surfaceFX_opus = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:Vector4Node, Name:FrontVector0_surfaceFX_opus
	float4 FrontVector0_surfaceFX_opus = float4(0, 0.1736, 0.9848, 1) ;
	
	// Type:CarRainAmountNode, Name:debugCarRainAmount_surfaceFX_opus
	float4 debugCarRainAmount_surfaceFX_opus = GetRainAmount().xxxx;
	
	// Type:ObjectNormalNode, Name:ObjectNormal_surfaceFX_opus
	float4 ObjectNormal_surfaceFX_opus = normalize(mul(float4(GetWorldNormal(In).xyz, 0), g_InvWorldMatrix));
	// Type:FloatNode, Name:maxDustRoughness_surfaceFX_opus
	float4 maxDustRoughness_surfaceFX_opus = float4(0.93, 0.93, 0.93, 0.93);
	
	// Type:OneMinusNode, Name:OneMinus4100_surfaceFX_opus
	float4 OneMinus4100_surfaceFX_opus = 1 - CarReceivesDirt_surfaceFX_opus;
	
	// Type:PowNode, Name:PowGlossRate0_surfaceFX_opus
	float4 PowGlossRate0_surfaceFX_opus = pow( OneMinus4100_surfaceFX_opus, Float701_surfaceFX_opus );
	
	// Type:OneMinusNode, Name:OneMinus401_surfaceFX_opus
	float4 OneMinus401_surfaceFX_opus = 1 - PowGlossRate0_surfaceFX_opus;
	
	// Type:MultiplyNode, Name:Multiply1_surfaceFX_opus
	float4 Multiply1_surfaceFX_opus = maxDustRoughness_surfaceFX_opus * OneMinus401_surfaceFX_opus;
	
	// Type:MaxNode, Name:MaxGlossMaskFromDustAndMud_surfaceFX_opus
	float4 MaxGlossMaskFromDustAndMud_surfaceFX_opus = max(Multiply1_surfaceFX_opus, OneMinus40_surfaceFX_opus);
	
	// Type:FloatNode, Name:L1_surfaceFX_opus
	float4 L1_surfaceFX_opus = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:L2_surfaceFX_opus
	float4 L2_surfaceFX_opus = float4(1, 1, 1, 1);
	
	// Type:LerpNode, Name:Lerp0_surfaceFX_opus
	float4 Lerp0_surfaceFX_opus = lerp(L1_surfaceFX_opus, L2_surfaceFX_opus, CarTireWadingLevel_surfaceFX_opus.x);
	
	// Type:FunctionOutputNode, Name:DiffuseColorNoBlend_surfaceFX_opus
	float4 DiffuseColorNoBlend_surfaceFX_opus = LerpDiffColor_surfaceFX_opus;
	
	// Type:FunctionOutputNode, Name:DustMask_surfaceFX_opus
	float4 DustMask_surfaceFX_opus = DustDiffMask_surfaceFX_opus;
	
	// Type:FunctionOutputNode, Name:CombinedCoverage_surfaceFX_opus
	float4 CombinedCoverage_surfaceFX_opus = Max_finalThickness_surfaceFX_opus;
	
	// Type:FunctionOutputNode, Name:WetnessAmount_surfaceFX_opus
	float4 WetnessAmount_surfaceFX_opus = MulScaleWaterAmountFromWetMask_surfaceFX_opus;
	
	// Type:FunctionOutputNode, Name:MudDiffMask_surfaceFX_opus
	float4 MudDiffMask_surfaceFX_opus = CarReceivesOil_surfaceFX_opus;
	
	// Type:FunctionOutputNode, Name:NormalMask_surfaceFX_opus
	float4 NormalMask_surfaceFX_opus = StepNormalMask_surfaceFX_opus;
	
	// Type:FunctionOutputNode, Name:F0Mask_surfaceFX_opus
	float4 F0Mask_surfaceFX_opus = MaxF0MaskFromDustAndMud_surfaceFX_opus;
	
	// Type:FunctionOutputNode, Name:GlossMask_surfaceFX_opus
	float4 GlossMask_surfaceFX_opus = MaxGlossMaskFromDustAndMud_surfaceFX_opus;
	
	// Type:OneMinusNode, Name:OneMinusNonSSS_surfaceFX_opus
	float4 OneMinusNonSSS_surfaceFX_opus = 1 - SSSWeighting_surfaceFX_opus;
	
	surfaceFX_opusShaderFunctionOutput dataOut;
	dataOut.DiffuseColor = SurfaceFX_DiffDust_surfaceFX_opus;
	dataOut.Normal = NormalMapWithIntensity_surfaceFX_opus;
	dataOut.F0 = F0Values_temp_surfaceFX_opus;
	dataOut.Glossiness = GlossMatte_surfaceFX_opus;
	dataOut.CarAOOverride = AOMapValue0_surfaceFX_opus;
	dataOut.DiffuseColorNoBlend = DiffuseColorNoBlend_surfaceFX_opus;
	dataOut.DustMask = DustMask_surfaceFX_opus;
	dataOut.CombinedCoverage = CombinedCoverage_surfaceFX_opus;
	dataOut.WetnessAmount = WetnessAmount_surfaceFX_opus;
	dataOut.MudDiffMask = MudDiffMask_surfaceFX_opus;
	dataOut.NormalMask = NormalMask_surfaceFX_opus;
	dataOut.F0Mask = F0Mask_surfaceFX_opus;
	dataOut.GlossMask = GlossMask_surfaceFX_opus;
	return dataOut;
}

struct surfaceFX_winterShaderFunctionInput
{
	SamplerState SamplerStates;
	float4 DiffuseColour;
	float4 MetalColour;
	float4 Metalness;
};

struct surfaceFX_winterShaderFunctionOutput
{
	float4 DiffuseColor;
	float4 Normal;
	float4 F0;
	float4 Glossiness;
	float4 CarAOOverride;
	float4 DiffuseColorNoBlend;
	float4 WetnessAmount;
	float4 FrostDiffMask;
	float4 SnowDiffMask;
	float4 CombinedCoverage;
	float4 NormalMask;
	float4 F0Mask;
	float4 GlossMask;
};

surfaceFX_winterShaderFunctionOutput surfaceFX_winterShaderFunction(PS_IN In, surfaceFX_winterShaderFunctionInput dataIn)
{
	// Type:FunctionInputNode, Name:DiffuseColour_surfaceFX_winter
	float4 DiffuseColour_surfaceFX_winter = dataIn.DiffuseColour;
	float4 DiffuseColour_surfaceFX_winterPreview = float4(0,0,0,0);
	
	// Type:UVNode, Name:CH2UV1_surfaceFX_winter
	float4 CH2UV1_surfaceFX_winter = GetTexCoord1(In).xyxy;
	float4 CH2UV1_surfaceFX_winterTangent = GetWorldTangent1(In);
	float4 CH2UV1_surfaceFX_winterUCoord = GetTexCoord1(In).xxxx;
	float4 CH2UV1_surfaceFX_winterVCoord = GetTexCoord1(In).yyyy;
	
	// Type:SamplerStatesFunctionInputNode, Name:SamplerStates_surfaceFX_winter
	SamplerState SamplerStates_surfaceFX_winter = dataIn.SamplerStates;
	float4 SamplerStates_surfaceFX_winterPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:SnowDiffuseTexture_surfaceFX_winter
	float4 SnowDiffuseTexture_surfaceFX_winter = SnowDiffuseTextureTexture_surfaceFX_winter.Sample(SamplerStatesSampler, CH2UV1_surfaceFX_winter.xy * SnowDiffuseTextureTiling_surfaceFX_winter);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 SnowDiffuseTexture_surfaceFX_winterMip = GetDebugMipColour(SnowDiffuseTextureTexture_surfaceFX_winter, SamplerStatesSampler, CH2UV1_surfaceFX_winter.xy * SnowDiffuseTextureTiling_surfaceFX_winter);
	#else
	float4 SnowDiffuseTexture_surfaceFX_winterMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 SnowDiffuseTexture_surfaceFX_winterAlpha = SnowDiffuseTexture_surfaceFX_winter.aaaa;
	float4 SnowDiffuseTexture_surfaceFX_winterRed = SnowDiffuseTexture_surfaceFX_winter.rrrr;
	float4 SnowDiffuseTexture_surfaceFX_winterGreen = SnowDiffuseTexture_surfaceFX_winter.gggg;
	float4 SnowDiffuseTexture_surfaceFX_winterBlue = SnowDiffuseTexture_surfaceFX_winter.bbbb;
	Texture2D SnowDiffuseTexture_surfaceFX_winterRef = SnowDiffuseTextureTexture_surfaceFX_winter;
	
	// Type:FloatNode, Name:floatLowAngleTranslucency_surfaceFX_winter
	float4 floatLowAngleTranslucency_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:minAngleTranslucencyFade_surfaceFX_winter
	float4 minAngleTranslucencyFade_surfaceFX_winter = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:FloatNode, Name:maxAngleTranslucencyFade_surfaceFX_winter
	float4 maxAngleTranslucencyFade_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:ViewVectorNode, Name:ViewVector_surfaceFX_winter
	float4 ViewVector_surfaceFX_winter = float4(GetViewVector(), 0);
	// Type:WorldNormalNode, Name:WorldNormal_surfaceFX_winter
	float4 WorldNormal_surfaceFX_winter = float4(GetWorldNormal(In).xyz, 0);
	// Type:DotNode, Name:NdotV_surfaceFX_winter
	float4 NdotV_surfaceFX_winter = dot(ViewVector_surfaceFX_winter, WorldNormal_surfaceFX_winter);
	
	// Type:StepNode, Name:StepAngleTranslucencyFade_surfaceFX_winter
	float4 StepAngleTranslucencyFade_surfaceFX_winter = smoothstep( minAngleTranslucencyFade_surfaceFX_winter, maxAngleTranslucencyFade_surfaceFX_winter, NdotV_surfaceFX_winter );
	
	// Type:LerpNode, Name:LerpAngleTranslucencyFade_surfaceFX_winter
	float4 LerpAngleTranslucencyFade_surfaceFX_winter = lerp(floatLowAngleTranslucency_surfaceFX_winter, SnowDiffuseTexture_surfaceFX_winterBlue, StepAngleTranslucencyFade_surfaceFX_winter.x);
	
	// Type:FloatNode, Name:floatDrivingSnowTranslucencyPower_surfaceFX_winter
	float4 floatDrivingSnowTranslucencyPower_surfaceFX_winter = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:PowNode, Name:Pow0_surfaceFX_winter
	float4 Pow0_surfaceFX_winter = pow( SnowDiffuseTexture_surfaceFX_winterBlue, floatDrivingSnowTranslucencyPower_surfaceFX_winter );
	
	// Type:FloatNode, Name:Float10_surfaceFX_winter
	float4 Float10_surfaceFX_winter = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:TextureNode, Name:HighNoiseTexture_surfaceFX_winter
	float4 HighNoiseTexture_surfaceFX_winter = HighNoiseTextureTexture_surfaceFX_winter.Sample(SamplerStatesSampler, CH2UV1_surfaceFX_winter.xy * HighNoiseTextureTiling_surfaceFX_winter);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 HighNoiseTexture_surfaceFX_winterMip = GetDebugMipColour(HighNoiseTextureTexture_surfaceFX_winter, SamplerStatesSampler, CH2UV1_surfaceFX_winter.xy * HighNoiseTextureTiling_surfaceFX_winter);
	#else
	float4 HighNoiseTexture_surfaceFX_winterMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 HighNoiseTexture_surfaceFX_winterAlpha = HighNoiseTexture_surfaceFX_winter.aaaa;
	float4 HighNoiseTexture_surfaceFX_winterRed = HighNoiseTexture_surfaceFX_winter.rrrr;
	float4 HighNoiseTexture_surfaceFX_winterGreen = HighNoiseTexture_surfaceFX_winter.gggg;
	float4 HighNoiseTexture_surfaceFX_winterBlue = HighNoiseTexture_surfaceFX_winter.bbbb;
	Texture2D HighNoiseTexture_surfaceFX_winterRef = HighNoiseTextureTexture_surfaceFX_winter;
	
	// Type:ColorNode, Name:HighNoiseTireBlurApprox_surfaceFX_winter
	float4 HighNoiseTireBlurApprox_surfaceFX_winter = HighNoiseTireBlurApproxColorParam_surfaceFX_winter;
	float4 HighNoiseTireBlurApprox_surfaceFX_winterRed = HighNoiseTireBlurApproxColorParam_surfaceFX_winter.rrrr;
	float4 HighNoiseTireBlurApprox_surfaceFX_winterGreen = HighNoiseTireBlurApproxColorParam_surfaceFX_winter.gggg;
	float4 HighNoiseTireBlurApprox_surfaceFX_winterBlue = HighNoiseTireBlurApproxColorParam_surfaceFX_winter.bbbb;
	float4 HighNoiseTireBlurApprox_surfaceFX_winterAlpha = HighNoiseTireBlurApproxColorParam_surfaceFX_winter.aaaa;
	
	// Type:CarTireVelocityNode, Name:CarTireVelocity_surfaceFX_winter
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IN_MATERIAL_EDITOR)
	float4 CarTireVelocity_surfaceFX_winter = GetTireVelocityAmount();
	#else
	float4 CarTireVelocity_surfaceFX_winter = float4(0,0,0,0);
	#endif
	
	// Type:LerpNode, Name:LerpTireVelocity_surfaceFX_winter
	float4 LerpTireVelocity_surfaceFX_winter = lerp(HighNoiseTexture_surfaceFX_winter, HighNoiseTireBlurApprox_surfaceFX_winter, CarTireVelocity_surfaceFX_winter.x);
	
	// Type:FloatNode, Name:startOfWheelWading_surfaceFX_winter
	float4 startOfWheelWading_surfaceFX_winter = float4(-0.38, -0.38, -0.38, -0.38);
	
	// Type:FloatNode, Name:WinterIsUsuallyWet_surfaceFX_winter
	float4 WinterIsUsuallyWet_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:CarTireWadingLevelNode, Name:CarTireWadingLevel_surfaceFX_winter
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IN_MATERIAL_EDITOR)
	float4 CarTireWadingLevel_surfaceFX_winter = GetTireWadingLevel();
	#else
	float4 CarTireWadingLevel_surfaceFX_winter = float4(0,0,0,0);
	#endif
	
	// Type:FloatNode, Name:Float13_surfaceFX_winter
	float4 Float13_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:Float130_surfaceFX_winter
	float4 Float130_surfaceFX_winter = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:FloatNode, Name:TractorTyreOverride_surfaceFX_winter
	float4 TractorTyreOverride_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:StepNode, Name:StepNonSnowWetnessTrigger_surfaceFX_winter
	float4 StepNonSnowWetnessTrigger_surfaceFX_winter = linearstep( Float13_surfaceFX_winter, Float130_surfaceFX_winter, TractorTyreOverride_surfaceFX_winter );
	
	// Type:LerpNode, Name:LerpWheelWetnessControl_surfaceFX_winter
	float4 LerpWheelWetnessControl_surfaceFX_winter = lerp(WinterIsUsuallyWet_surfaceFX_winter, CarTireWadingLevel_surfaceFX_winter, StepNonSnowWetnessTrigger_surfaceFX_winter.x);
	
	// Type:AddNode, Name:Add5_surfaceFX_winter
	float4 Add5_surfaceFX_winter = startOfWheelWading_surfaceFX_winter + LerpWheelWetnessControl_surfaceFX_winter;
	
	// Type:TextureNode, Name:TextureWetnessEdge_surfaceFX_winter
	float4 TextureWetnessEdge_surfaceFX_winter = TextureWetnessEdgeTexture_surfaceFX_winter.Sample(g_samplerLinearWrap, CH2UV1_surfaceFX_winter.xy * TextureWetnessEdgeTiling_surfaceFX_winter);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TextureWetnessEdge_surfaceFX_winterMip = GetDebugMipColour(TextureWetnessEdgeTexture_surfaceFX_winter, g_samplerLinearWrap, CH2UV1_surfaceFX_winter.xy * TextureWetnessEdgeTiling_surfaceFX_winter);
	#else
	float4 TextureWetnessEdge_surfaceFX_winterMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TextureWetnessEdge_surfaceFX_winterAlpha = TextureWetnessEdge_surfaceFX_winter.aaaa;
	float4 TextureWetnessEdge_surfaceFX_winterRed = TextureWetnessEdge_surfaceFX_winter.rrrr;
	float4 TextureWetnessEdge_surfaceFX_winterGreen = TextureWetnessEdge_surfaceFX_winter.gggg;
	float4 TextureWetnessEdge_surfaceFX_winterBlue = TextureWetnessEdge_surfaceFX_winter.bbbb;
	Texture2D TextureWetnessEdge_surfaceFX_winterRef = TextureWetnessEdgeTexture_surfaceFX_winter;
	
	// Type:FloatNode, Name:MaskWheelBlurred0_surfaceFX_winter
	float4 MaskWheelBlurred0_surfaceFX_winter = float4(0.2863, 0.2863, 0.2863, 0.2863);
	
	// Type:LerpNode, Name:Lerp00_surfaceFX_winter
	float4 Lerp00_surfaceFX_winter = lerp(TextureWetnessEdge_surfaceFX_winterRed, MaskWheelBlurred0_surfaceFX_winter, CarTireVelocity_surfaceFX_winter.x);
	
	// Type:FloatNode, Name:Float3_surfaceFX_winter
	float4 Float3_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:FloatAWheel_surfaceFX_winter
	float4 FloatAWheel_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:CarWadingWetnessLevelNode, Name:CarWadingWetnessLevel_surfaceFX_winter
	float4 CarWadingWetnessLevel_surfaceFX_winter = GetRubberAmount().xxxx;
	
	// Type:FloatNode, Name:floatKickupContributionScaler_surfaceFX_winter
	float4 floatKickupContributionScaler_surfaceFX_winter = float4(-0.25, -0.25, -0.25, -0.25);
	
	// Type:VertexColor, Name:VertexColor_surfaceFX_winter
	float4 VertexColor_surfaceFX_winter = GetColor(In);float4 VertexColor_surfaceFX_winterAlpha = VertexColor_surfaceFX_winter.aaaa;
	float4 VertexColor_surfaceFX_winterRed = VertexColor_surfaceFX_winter.rrrr;
	float4 VertexColor_surfaceFX_winterGreen = VertexColor_surfaceFX_winter.gggg;
	float4 VertexColor_surfaceFX_winterBlue = VertexColor_surfaceFX_winter.bbbb;
	
	// Type:FloatNode, Name:FloatPowKickupMaskRateAdjustment_surfaceFX_winter
	float4 FloatPowKickupMaskRateAdjustment_surfaceFX_winter = float4(1.7, 1.7, 1.7, 1.7);
	
	// Type:PowNode, Name:PowKickupMaskRateAdjustment_surfaceFX_winter
	float4 PowKickupMaskRateAdjustment_surfaceFX_winter = pow( VertexColor_surfaceFX_winterGreen, FloatPowKickupMaskRateAdjustment_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:mulModulatedKickupVC_surfaceFX_winter
	float4 mulModulatedKickupVC_surfaceFX_winter = floatKickupContributionScaler_surfaceFX_winter * PowKickupMaskRateAdjustment_surfaceFX_winter;
	
	// Type:FloatNode, Name:HeightToVertColorRatio_surfaceFX_winter
	float4 HeightToVertColorRatio_surfaceFX_winter = float4(2, 2, 2, 2);
	
	// Type:MultiplyNode, Name:MulToMeters_surfaceFX_winter
	float4 MulToMeters_surfaceFX_winter = VertexColor_surfaceFX_winterRed * HeightToVertColorRatio_surfaceFX_winter;
	
	// Type:AddNode, Name:Add4_surfaceFX_winter
	float4 Add4_surfaceFX_winter = mulModulatedKickupVC_surfaceFX_winter + MulToMeters_surfaceFX_winter;
	
	// Type:SaturateNode, Name:Saturate0_surfaceFX_winter
	float4 Saturate0_surfaceFX_winter = saturate( Add4_surfaceFX_winter ); 
	
	// Type:FloatNode, Name:FloatNotAWheel_surfaceFX_winter
	float4 FloatNotAWheel_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel_noise_surfaceFX_winter
	float4 CarPartIsWheel_noise_surfaceFX_winter;
	float4 CarPartIsWheel_noise_surfaceFX_winterOut1;
	float4 CarPartIsWheel_noise_surfaceFX_winterOut2;
	float4 CarPartIsWheel_noise_surfaceFX_winterOut3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel_noise_surfaceFX_winter = CarWadingWetnessLevel_surfaceFX_winter;
	CarPartIsWheel_noise_surfaceFX_winterOut1 = TextureWetnessEdge_surfaceFX_winterRed;
	CarPartIsWheel_noise_surfaceFX_winterOut2 = Saturate0_surfaceFX_winter;
	CarPartIsWheel_noise_surfaceFX_winterOut3 = FloatNotAWheel_surfaceFX_winter;
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel_noise_surfaceFX_winter = Add5_surfaceFX_winter;
		CarPartIsWheel_noise_surfaceFX_winterOut1 = Lerp00_surfaceFX_winter;
		CarPartIsWheel_noise_surfaceFX_winterOut2 = Float3_surfaceFX_winter;
		CarPartIsWheel_noise_surfaceFX_winterOut3 = FloatAWheel_surfaceFX_winter;
	}
	else
	{
		CarPartIsWheel_noise_surfaceFX_winter = CarWadingWetnessLevel_surfaceFX_winter;
		CarPartIsWheel_noise_surfaceFX_winterOut1 = TextureWetnessEdge_surfaceFX_winterRed;
		CarPartIsWheel_noise_surfaceFX_winterOut2 = Saturate0_surfaceFX_winter;
		CarPartIsWheel_noise_surfaceFX_winterOut3 = FloatNotAWheel_surfaceFX_winter;
	}
	#endif
	
	// Type:LerpNode, Name:LerpEnableTireBlur_surfaceFX_winter
	float4 LerpEnableTireBlur_surfaceFX_winter = lerp(HighNoiseTexture_surfaceFX_winter, LerpTireVelocity_surfaceFX_winter, CarPartIsWheel_noise_surfaceFX_winterOut3.x);
	
	// Type:SwizzleNode, Name:SwizzleG_surfaceFX_winter
	float4 SwizzleG_surfaceFX_winter = LerpEnableTireBlur_surfaceFX_winter.yyyw;
	
	// Type:FloatNode, Name:SunriseGlobalScaler_surfaceFX_winter
	float4 SunriseGlobalScaler_surfaceFX_winter = float4(0.7, 0.7, 0.7, 0.7);
	
	// Type:CarDirtAmountNode, Name:CarDirtAmount_surfaceFX_winter
	float4 CarDirtAmount_surfaceFX_winter = GetDirtAmount().xxxx;
	
	// Type:MultiplyNode, Name:WARNING_SunriseMaxTopSnowNFrost_surfaceFX_winter
	float4 WARNING_SunriseMaxTopSnowNFrost_surfaceFX_winter = SunriseGlobalScaler_surfaceFX_winter * CarDirtAmount_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:wheelStationaryFrostMask_surfaceFX_winter
	float4 wheelStationaryFrostMask_surfaceFX_winter = SwizzleG_surfaceFX_winter * WARNING_SunriseMaxTopSnowNFrost_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:mulWheelStationaryFrostMaskScaler_surfaceFX_winter
	float4 mulWheelStationaryFrostMaskScaler_surfaceFX_winter = Float10_surfaceFX_winter * wheelStationaryFrostMask_surfaceFX_winter;
	
	// Type:FloatNode, Name:MinStepWheelFrostMask_surfaceFX_winter
	float4 MinStepWheelFrostMask_surfaceFX_winter = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:FloatNode, Name:MaxStepWheelFrostMask_surfaceFX_winter
	float4 MaxStepWheelFrostMask_surfaceFX_winter = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:FloatNode, Name:Float5_surfaceFX_winter
	float4 Float5_surfaceFX_winter = float4(0.086, 0.086, 0.086, 0.086);
	
	// Type:FloatNode, Name:Float50_surfaceFX_winter
	float4 Float50_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:LerpNode, Name:LerpLinearRemap_surfaceFX_winter
	float4 LerpLinearRemap_surfaceFX_winter = lerp(Float5_surfaceFX_winter, Float50_surfaceFX_winter, TractorTyreOverride_surfaceFX_winter.x);
	
	// Type:FloatNode, Name:Float4_surfaceFX_winter
	float4 Float4_surfaceFX_winter = float4(6.28318, 6.28318, 6.28318, 6.28318);
	
	// Type:MultiplyNode, Name:Multiply0_surfaceFX_winter
	float4 Multiply0_surfaceFX_winter = LerpLinearRemap_surfaceFX_winter * Float4_surfaceFX_winter;
	
	// Type:SinCos, Name:SinCos_surfaceFX_winter
	float4 SinCos_surfaceFX_winterSinOut = float4( 1, 1, 1, 1); 
	float4 SinCos_surfaceFX_winterCosOut = float4( 1, 1, 1, 1); 
	sincos(Multiply0_surfaceFX_winter, SinCos_surfaceFX_winterSinOut, SinCos_surfaceFX_winterCosOut); 
	
	// Type:FloatNode, Name:Float00_surfaceFX_winter
	float4 Float00_surfaceFX_winter = float4(0.125, 0.125, 0.125, 0.125);
	
	// Type:MultiplyNode, Name:Multiply00_surfaceFX_winter
	float4 Multiply00_surfaceFX_winter = SinCos_surfaceFX_winterSinOut * Float00_surfaceFX_winter;
	
	// Type:AddNode, Name:InputHardInHardOut_surfaceFX_winter
	float4 InputHardInHardOut_surfaceFX_winter = Multiply00_surfaceFX_winter + LerpLinearRemap_surfaceFX_winter;
	
	// Type:FloatNode, Name:maxTreadDrivingSnow_surfaceFX_winter
	float4 maxTreadDrivingSnow_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:minSideDrivingSnow_surfaceFX_winter
	float4 minSideDrivingSnow_surfaceFX_winter = float4(0.27, 0.27, 0.27, 0.27);
	
	// Type:FloatNode, Name:minStepWheelSideFadeAngle_surfaceFX_winter
	float4 minStepWheelSideFadeAngle_surfaceFX_winter = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:FloatNode, Name:maxStepWheelSideFadeAngle_surfaceFX_winter
	float4 maxStepWheelSideFadeAngle_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:AbsNode, Name:Abs00_surfaceFX_winter
	float4 Abs00_surfaceFX_winter = abs( VertexColor_surfaceFX_winterAlpha ); 
	
	// Type:StepNode, Name:StepWheelSideFadeAngle_surfaceFX_winter
	float4 StepWheelSideFadeAngle_surfaceFX_winter = smoothstep( minStepWheelSideFadeAngle_surfaceFX_winter, maxStepWheelSideFadeAngle_surfaceFX_winter, Abs00_surfaceFX_winter );
	
	// Type:LerpNode, Name:LerpTireSideFade_surfaceFX_winter
	float4 LerpTireSideFade_surfaceFX_winter = lerp(maxTreadDrivingSnow_surfaceFX_winter, minSideDrivingSnow_surfaceFX_winter, StepWheelSideFadeAngle_surfaceFX_winter.x);
	
	// Type:MultiplyNode, Name:mulWheelSideFade_surfaceFX_winter
	float4 mulWheelSideFade_surfaceFX_winter = InputHardInHardOut_surfaceFX_winter * LerpTireSideFade_surfaceFX_winter;
	
	// Type:StepNode, Name:StepWheelFrostMask_surfaceFX_winter
	float4 StepWheelFrostMask_surfaceFX_winter = smoothstep( MinStepWheelFrostMask_surfaceFX_winter, MaxStepWheelFrostMask_surfaceFX_winter, mulWheelSideFade_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:mulWheelFrostFade10_surfaceFX_winter
	float4 mulWheelFrostFade10_surfaceFX_winter = SwizzleG_surfaceFX_winter * StepWheelFrostMask_surfaceFX_winter;
	
	// Type:FloatNode, Name:StationaryWheelSnow_surfaceFX_winter
	float4 StationaryWheelSnow_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:MinStepWheelSnowMask_surfaceFX_winter
	float4 MinStepWheelSnowMask_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:MaxStepWheelSnowMask_surfaceFX_winter
	float4 MaxStepWheelSnowMask_surfaceFX_winter = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:StepWheelSnowMask_surfaceFX_winter
	float4 StepWheelSnowMask_surfaceFX_winter = smoothstep( MinStepWheelSnowMask_surfaceFX_winter, MaxStepWheelSnowMask_surfaceFX_winter, mulWheelSideFade_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinus010_surfaceFX_winter
	float4 OneMinus010_surfaceFX_winter = 1 - StepWheelSnowMask_surfaceFX_winter;
	
	// Type:FloatNode, Name:WheelSnowHighNoiseMaskStepRange1_surfaceFX_winter
	float4 WheelSnowHighNoiseMaskStepRange1_surfaceFX_winter = float4(0.7, 0.7, 0.7, 0.7);
	
	// Type:AddNode, Name:Add01_surfaceFX_winter
	float4 Add01_surfaceFX_winter = WheelSnowHighNoiseMaskStepRange1_surfaceFX_winter + OneMinus010_surfaceFX_winter;
	
	// Type:SwizzleNode, Name:SwizzleR_surfaceFX_winter
	float4 SwizzleR_surfaceFX_winter = LerpEnableTireBlur_surfaceFX_winter.xxxw;
	
	// Type:StepNode, Name:StepHighNoiseMask1_surfaceFX_winter
	float4 StepHighNoiseMask1_surfaceFX_winter = smoothstep( OneMinus010_surfaceFX_winter, Add01_surfaceFX_winter, SwizzleR_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:xHighNoiseMask1_surfaceFX_winter
	float4 xHighNoiseMask1_surfaceFX_winter = StepHighNoiseMask1_surfaceFX_winter * StepWheelSnowMask_surfaceFX_winter;
	
	// Type:FloatNode, Name:StepMin_surfaceFX_winter
	float4 StepMin_surfaceFX_winter = float4(1.25, 1.25, 1.25, 1.25);
	
	// Type:FloatNode, Name:StepMax_surfaceFX_winter
	float4 StepMax_surfaceFX_winter = float4(2, 2, 2, 2);
	
	// Type:FloatNode, Name:fluctuationNoiseSnow0_surfaceFX_winter
	float4 fluctuationNoiseSnow0_surfaceFX_winter = float4(0.25, 0.25, 0.25, 0.25);
	
	// Type:TextureNode, Name:LowNoiseTexture_surfaceFX_winter
	float4 LowNoiseTexture_surfaceFX_winter = LowNoiseTextureTexture_surfaceFX_winter.Sample(g_samplerLinearWrap, CH2UV1_surfaceFX_winter.xy * LowNoiseTextureTiling_surfaceFX_winter);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 LowNoiseTexture_surfaceFX_winterMip = GetDebugMipColour(LowNoiseTextureTexture_surfaceFX_winter, g_samplerLinearWrap, CH2UV1_surfaceFX_winter.xy * LowNoiseTextureTiling_surfaceFX_winter);
	#else
	float4 LowNoiseTexture_surfaceFX_winterMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 LowNoiseTexture_surfaceFX_winterAlpha = LowNoiseTexture_surfaceFX_winter.aaaa;
	float4 LowNoiseTexture_surfaceFX_winterRed = LowNoiseTexture_surfaceFX_winter.rrrr;
	float4 LowNoiseTexture_surfaceFX_winterGreen = LowNoiseTexture_surfaceFX_winter.gggg;
	float4 LowNoiseTexture_surfaceFX_winterBlue = LowNoiseTexture_surfaceFX_winter.bbbb;
	Texture2D LowNoiseTexture_surfaceFX_winterRef = LowNoiseTextureTexture_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:Multiply1_surfaceFX_winter
	float4 Multiply1_surfaceFX_winter = fluctuationNoiseSnow0_surfaceFX_winter * LowNoiseTexture_surfaceFX_winterRed;
	
	// Type:OneMinusNode, Name:OneMinus3_surfaceFX_winter
	float4 OneMinus3_surfaceFX_winter = 1 - Multiply1_surfaceFX_winter;
	
	// Type:FloatNode, Name:addedBonusStationarySnowForDrivingSnowScaler_surfaceFX_winter
	float4 addedBonusStationarySnowForDrivingSnowScaler_surfaceFX_winter = float4(0.35, 0.35, 0.35, 0.35);
	
	// Type:CarOilAmountNode, Name:CarOilAmount0_surfaceFX_winter
	float4 CarOilAmount0_surfaceFX_winter = GetOilAmount().xxxx;
	
	// Type:MultiplyNode, Name:mulMoreStationarySnow_surfaceFX_winter
	float4 mulMoreStationarySnow_surfaceFX_winter = addedBonusStationarySnowForDrivingSnowScaler_surfaceFX_winter * CarOilAmount0_surfaceFX_winter;
	
	// Type:MaxNode, Name:MaxBonusForDrivingSnow_surfaceFX_winter
	float4 MaxBonusForDrivingSnow_surfaceFX_winter = max(WARNING_SunriseMaxTopSnowNFrost_surfaceFX_winter, mulMoreStationarySnow_surfaceFX_winter);
	
	// Type:CarSpaceNormal, Name:CarSpaceNormal_surfaceFX_winter
	float4 CarSpaceNormal_surfaceFX_winter = normalize(mul(float4(GetWorldNormal(In).xyz, 0), g_CarInvWorldTransform));
	
	// Type:Vector4Node, Name:SkyDirection_surfaceFX_winter
	float4 SkyDirection_surfaceFX_winter = float4(0, 1, 0, 1) ;
	
	// Type:DotNode, Name:AmountTowardsSky_surfaceFX_winter
	float4 AmountTowardsSky_surfaceFX_winter = dot(CarSpaceNormal_surfaceFX_winter, SkyDirection_surfaceFX_winter);
	
	// Type:AddNode, Name:Add1_surfaceFX_winter
	float4 Add1_surfaceFX_winter = MaxBonusForDrivingSnow_surfaceFX_winter + AmountTowardsSky_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:xLowNoiseSnow_surfaceFX_winter
	float4 xLowNoiseSnow_surfaceFX_winter = OneMinus3_surfaceFX_winter * Add1_surfaceFX_winter;
	
	// Type:StepNode, Name:StepSnowMask0_surfaceFX_winter
	float4 StepSnowMask0_surfaceFX_winter = smoothstep( StepMin_surfaceFX_winter, StepMax_surfaceFX_winter, xLowNoiseSnow_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinusInverseSnowMask_surfaceFX_winter
	float4 OneMinusInverseSnowMask_surfaceFX_winter = 1 - StepSnowMask0_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:MulFrostMaskTex_surfaceFX_winter
	float4 MulFrostMaskTex_surfaceFX_winter = OneMinusInverseSnowMask_surfaceFX_winter * SwizzleG_surfaceFX_winter;
	
	// Type:FloatNode, Name:StepMinDelta_surfaceFX_winter
	float4 StepMinDelta_surfaceFX_winter = float4(-0.35, -0.35, -0.35, -0.35);
	
	// Type:FloatNode, Name:StepMinFX_surfaceFX_winter
	float4 StepMinFX_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:MultiplyAddNode, Name:MultiplyAddForOver90Degs_surfaceFX_winter
	float4 MultiplyAddForOver90Degs_surfaceFX_winter = StepMinDelta_surfaceFX_winter * MaxBonusForDrivingSnow_surfaceFX_winter + StepMinFX_surfaceFX_winter;
	
	// Type:FloatNode, Name:StepMax0_surfaceFX_winter
	float4 StepMax0_surfaceFX_winter = float4(1.5, 1.5, 1.5, 1.5);
	
	// Type:FloatNode, Name:fluctuationNoise0_surfaceFX_winter
	float4 fluctuationNoise0_surfaceFX_winter = float4(0.18, 0.18, 0.18, 0.18);
	
	// Type:MultiplyNode, Name:Multiply10_surfaceFX_winter
	float4 Multiply10_surfaceFX_winter = fluctuationNoise0_surfaceFX_winter * LowNoiseTexture_surfaceFX_winterRed;
	
	// Type:OneMinusNode, Name:OneMinus30_surfaceFX_winter
	float4 OneMinus30_surfaceFX_winter = 1 - Multiply10_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:xLowNoiseFrost_surfaceFX_winter
	float4 xLowNoiseFrost_surfaceFX_winter = OneMinus30_surfaceFX_winter * Add1_surfaceFX_winter;
	
	// Type:StepNode, Name:StepFrostMask0_surfaceFX_winter
	float4 StepFrostMask0_surfaceFX_winter = smoothstep( MultiplyAddForOver90Degs_surfaceFX_winter, StepMax0_surfaceFX_winter, xLowNoiseFrost_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:mulFrostFade_surfaceFX_winter
	float4 mulFrostFade_surfaceFX_winter = MulFrostMaskTex_surfaceFX_winter * StepFrostMask0_surfaceFX_winter;
	
	// Type:FloatNode, Name:NoStationaryFrostOrSnow_surfaceFX_winter
	float4 NoStationaryFrostOrSnow_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:CarReceivesDirtNode, Name:CarReceivesDirt0_surfaceFX_winter
	float4 CarReceivesDirt0_surfaceFX_winter;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDirt0_surfaceFX_winter = NoStationaryFrostOrSnow_surfaceFX_winter;
	#else
	[branch]
	if (ReceivesDirt())
	{
		CarReceivesDirt0_surfaceFX_winter = mulFrostFade_surfaceFX_winter;
	}
	else
	{
		CarReceivesDirt0_surfaceFX_winter = NoStationaryFrostOrSnow_surfaceFX_winter;
	}
	#endif
	
	// Type:FloatNode, Name:floatHeightFrostDecay_surfaceFX_winter
	float4 floatHeightFrostDecay_surfaceFX_winter = float4(0.6, 0.6, 0.6, 0.6);
	
	// Type:FloatNode, Name:MinStepHeightSnowMask_surfaceFX_winter
	float4 MinStepHeightSnowMask_surfaceFX_winter = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:FloatNode, Name:MaxStepHeightSnowMask_surfaceFX_winter
	float4 MaxStepHeightSnowMask_surfaceFX_winter = float4(1.25, 1.25, 1.25, 1.25);
	
	// Type:FloatNode, Name:fluctuationNoiseHeightSnow_surfaceFX_winter
	float4 fluctuationNoiseHeightSnow_surfaceFX_winter = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:MultiplyNode, Name:Multiply12_surfaceFX_winter
	float4 Multiply12_surfaceFX_winter = LowNoiseTexture_surfaceFX_winterRed * fluctuationNoiseHeightSnow_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus31_surfaceFX_winter
	float4 OneMinus31_surfaceFX_winter = 1 - Multiply12_surfaceFX_winter;
	
	// Type:FloatNode, Name:maxSmearMaskMultipler_surfaceFX_winter
	float4 maxSmearMaskMultipler_surfaceFX_winter = float4(0.07, 0.07, 0.07, 0.07);
	
	// Type:MultiplyNode, Name:Multiply6_surfaceFX_winter
	float4 Multiply6_surfaceFX_winter = TextureWetnessEdge_surfaceFX_winterGreen * maxSmearMaskMultipler_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus6_surfaceFX_winter
	float4 OneMinus6_surfaceFX_winter = 1 - Multiply6_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus5_surfaceFX_winter
	float4 OneMinus5_surfaceFX_winter = 1 - MulToMeters_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:mulSmearMask_surfaceFX_winter
	float4 mulSmearMask_surfaceFX_winter = OneMinus6_surfaceFX_winter * OneMinus5_surfaceFX_winter;
	
	// Type:FloatNode, Name:FloatPowHeightSnowChangeRate_surfaceFX_winter
	float4 FloatPowHeightSnowChangeRate_surfaceFX_winter = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:PowNode, Name:PowHeightSnowChangeRate_surfaceFX_winter
	float4 PowHeightSnowChangeRate_surfaceFX_winter = pow( CarOilAmount0_surfaceFX_winter, FloatPowHeightSnowChangeRate_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:MulHeightMask_surfaceFX_winter
	float4 MulHeightMask_surfaceFX_winter = mulSmearMask_surfaceFX_winter * PowHeightSnowChangeRate_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:xLowNoiseSnow0_surfaceFX_winter
	float4 xLowNoiseSnow0_surfaceFX_winter = OneMinus31_surfaceFX_winter * MulHeightMask_surfaceFX_winter;
	
	// Type:StepNode, Name:StepSnowMask_surfaceFX_winter
	float4 StepSnowMask_surfaceFX_winter = smoothstep( MinStepHeightSnowMask_surfaceFX_winter, MaxStepHeightSnowMask_surfaceFX_winter, xLowNoiseSnow0_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinus0_surfaceFX_winter
	float4 OneMinus0_surfaceFX_winter = 1 - StepSnowMask_surfaceFX_winter;
	
	// Type:FloatNode, Name:HighNoiseMaskStepRange0_surfaceFX_winter
	float4 HighNoiseMaskStepRange0_surfaceFX_winter = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:AddNode, Name:Add00_surfaceFX_winter
	float4 Add00_surfaceFX_winter = HighNoiseMaskStepRange0_surfaceFX_winter + OneMinus0_surfaceFX_winter;
	
	// Type:StepNode, Name:StepHighNoiseMask0_surfaceFX_winter
	float4 StepHighNoiseMask0_surfaceFX_winter = smoothstep( OneMinus0_surfaceFX_winter, Add00_surfaceFX_winter, SwizzleR_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:xHighNoiseMask0_surfaceFX_winter
	float4 xHighNoiseMask0_surfaceFX_winter = StepHighNoiseMask0_surfaceFX_winter * StepSnowMask_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus20_surfaceFX_winter
	float4 OneMinus20_surfaceFX_winter = 1 - xHighNoiseMask0_surfaceFX_winter;
	
	// Type:FloatNode, Name:modulationRate0_surfaceFX_winter
	float4 modulationRate0_surfaceFX_winter = float4(10, 10, 10, 10);
	
	// Type:PowNode, Name:PowSharpen0_surfaceFX_winter
	float4 PowSharpen0_surfaceFX_winter = pow( OneMinus20_surfaceFX_winter, modulationRate0_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinus030_surfaceFX_winter
	float4 OneMinus030_surfaceFX_winter = 1 - PowSharpen0_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus01_surfaceFX_winter
	float4 OneMinus01_surfaceFX_winter = 1 - OneMinus030_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:Multiply111_surfaceFX_winter
	float4 Multiply111_surfaceFX_winter = OneMinus01_surfaceFX_winter * SwizzleG_surfaceFX_winter;
	
	// Type:FloatNode, Name:StepMinDeltaFrostMask_surfaceFX_winter
	float4 StepMinDeltaFrostMask_surfaceFX_winter = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:FloatNode, Name:StepMinFXFrostMask_surfaceFX_winter
	float4 StepMinFXFrostMask_surfaceFX_winter = float4(0.28, 0.28, 0.28, 0.28);
	
	// Type:MultiplyAddNode, Name:MulAddFrostMask_surfaceFX_winter
	float4 MulAddFrostMask_surfaceFX_winter = StepMinDeltaFrostMask_surfaceFX_winter * CarOilAmount0_surfaceFX_winter + StepMinFXFrostMask_surfaceFX_winter;
	
	// Type:FloatNode, Name:MaxStepDeltaFrostMask_surfaceFX_winter
	float4 MaxStepDeltaFrostMask_surfaceFX_winter = float4(0.79, 0.79, 0.79, 0.79);
	
	// Type:StepNode, Name:StepFrostMask_surfaceFX_winter
	float4 StepFrostMask_surfaceFX_winter = smoothstep( MulAddFrostMask_surfaceFX_winter, MaxStepDeltaFrostMask_surfaceFX_winter, xLowNoiseSnow0_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:mulFrostFade1_surfaceFX_winter
	float4 mulFrostFade1_surfaceFX_winter = Multiply111_surfaceFX_winter * StepFrostMask_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:mulHeightFrostDecay_surfaceFX_winter
	float4 mulHeightFrostDecay_surfaceFX_winter = floatHeightFrostDecay_surfaceFX_winter * mulFrostFade1_surfaceFX_winter;
	
	// Type:FloatNode, Name:StepMin110_surfaceFX_winter
	float4 StepMin110_surfaceFX_winter = float4(-0.15, -0.15, -0.15, -0.15);
	
	// Type:FloatNode, Name:StepMax210_surfaceFX_winter
	float4 StepMax210_surfaceFX_winter = float4(1.5, 1.5, 1.5, 1.5);
	
	// Type:FloatNode, Name:fluctuationNoiseSnow1_surfaceFX_winter
	float4 fluctuationNoiseSnow1_surfaceFX_winter = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:MultiplyNode, Name:Multiply120_surfaceFX_winter
	float4 Multiply120_surfaceFX_winter = LowNoiseTexture_surfaceFX_winterRed * fluctuationNoiseSnow1_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus310_surfaceFX_winter
	float4 OneMinus310_surfaceFX_winter = 1 - Multiply120_surfaceFX_winter;
	
	// Type:FloatNode, Name:Float8_surfaceFX_winter
	float4 Float8_surfaceFX_winter = float4(0.28, 0.28, 0.28, 0.28);
	
	// Type:FloatNode, Name:Float20_surfaceFX_winter
	float4 Float20_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:Vector4Node, Name:FrontDirection_surfaceFX_winter
	float4 FrontDirection_surfaceFX_winter = float4(0, 0, 1, 1) ;
	
	// Type:DotNode, Name:DotFrontNormal_surfaceFX_winter
	float4 DotFrontNormal_surfaceFX_winter = dot(CarSpaceNormal_surfaceFX_winter, FrontDirection_surfaceFX_winter);
	
	// Type:StepNode, Name:SmoothStep_frontFade_surfaceFX_winter
	float4 SmoothStep_frontFade_surfaceFX_winter = smoothstep( Float8_surfaceFX_winter, Float20_surfaceFX_winter, DotFrontNormal_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:mulFrontMaskAmount_surfaceFX_winter
	float4 mulFrontMaskAmount_surfaceFX_winter = SmoothStep_frontFade_surfaceFX_winter * CarOilAmount0_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:xLowNoiseSnow00_surfaceFX_winter
	float4 xLowNoiseSnow00_surfaceFX_winter = OneMinus310_surfaceFX_winter * mulFrontMaskAmount_surfaceFX_winter;
	
	// Type:StepNode, Name:StepSnowMaskFront_surfaceFX_winter
	float4 StepSnowMaskFront_surfaceFX_winter = smoothstep( StepMin110_surfaceFX_winter, StepMax210_surfaceFX_winter, xLowNoiseSnow00_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinus00_surfaceFX_winter
	float4 OneMinus00_surfaceFX_winter = 1 - StepSnowMaskFront_surfaceFX_winter;
	
	// Type:FloatNode, Name:HighNoiseMaskStepRange00_surfaceFX_winter
	float4 HighNoiseMaskStepRange00_surfaceFX_winter = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:AddNode, Name:Add000_surfaceFX_winter
	float4 Add000_surfaceFX_winter = HighNoiseMaskStepRange00_surfaceFX_winter + OneMinus00_surfaceFX_winter;
	
	// Type:StepNode, Name:StepHighNoiseMask00_surfaceFX_winter
	float4 StepHighNoiseMask00_surfaceFX_winter = smoothstep( OneMinus00_surfaceFX_winter, Add000_surfaceFX_winter, SwizzleR_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:xHighNoiseMask00_surfaceFX_winter
	float4 xHighNoiseMask00_surfaceFX_winter = StepHighNoiseMask00_surfaceFX_winter * StepSnowMaskFront_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus0110_surfaceFX_winter
	float4 OneMinus0110_surfaceFX_winter = 1 - xHighNoiseMask00_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:Multiply11110_surfaceFX_winter
	float4 Multiply11110_surfaceFX_winter = OneMinus0110_surfaceFX_winter * SwizzleG_surfaceFX_winter;
	
	// Type:FloatNode, Name:StepMin0110_surfaceFX_winter
	float4 StepMin0110_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:StepMax0110_surfaceFX_winter
	float4 StepMax0110_surfaceFX_winter = float4(0.35, 0.35, 0.35, 0.35);
	
	// Type:StepNode, Name:StepFrostMask10_surfaceFX_winter
	float4 StepFrostMask10_surfaceFX_winter = smoothstep( StepMin0110_surfaceFX_winter, StepMax0110_surfaceFX_winter, xLowNoiseSnow00_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:mulFrostFadeFront_surfaceFX_winter
	float4 mulFrostFadeFront_surfaceFX_winter = Multiply11110_surfaceFX_winter * StepFrostMask10_surfaceFX_winter;
	
	// Type:MaxNode, Name:MaxFrostMask_surfaceFX_winter
	float4 MaxFrostMask_surfaceFX_winter = max(mulHeightFrostDecay_surfaceFX_winter, mulFrostFadeFront_surfaceFX_winter);
	
	// Type:UVNode, Name:CH4UV3_surfaceFX_winter
	float4 CH4UV3_surfaceFX_winter = GetTexCoord3(In).xyxy;
	float4 CH4UV3_surfaceFX_winterTangent = GetWorldTangent3(In);
	float4 CH4UV3_surfaceFX_winterUCoord = GetTexCoord3(In).xxxx;
	float4 CH4UV3_surfaceFX_winterVCoord = GetTexCoord3(In).yyyy;
	
	// Type:FloatNode, Name:NoDrivingFrostOrSnow_surfaceFX_winter
	float4 NoDrivingFrostOrSnow_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:MultiplyNode, Name:mulDummyUVforCompatibility_surfaceFX_winter
	float4 mulDummyUVforCompatibility_surfaceFX_winter = CH4UV3_surfaceFX_winterUCoord * NoDrivingFrostOrSnow_surfaceFX_winter;
	
	// Type:CarReceivesOilNode, Name:CarReceivesOil0_surfaceFX_winter
	float4 CarReceivesOil0_surfaceFX_winter;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesOil0_surfaceFX_winter = mulDummyUVforCompatibility_surfaceFX_winter;
	#else
	[branch]
	if (ReceivesOil())
	{
		CarReceivesOil0_surfaceFX_winter = MaxFrostMask_surfaceFX_winter;
	}
	else
	{
		CarReceivesOil0_surfaceFX_winter = mulDummyUVforCompatibility_surfaceFX_winter;
	}
	#endif
	
	// Type:CarReceivesDirtNode, Name:CarReceivesDirt00_surfaceFX_winter
	float4 CarReceivesDirt00_surfaceFX_winter;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDirt00_surfaceFX_winter = NoStationaryFrostOrSnow_surfaceFX_winter;
	#else
	[branch]
	if (ReceivesDirt())
	{
		CarReceivesDirt00_surfaceFX_winter = StepSnowMask0_surfaceFX_winter;
	}
	else
	{
		CarReceivesDirt00_surfaceFX_winter = NoStationaryFrostOrSnow_surfaceFX_winter;
	}
	#endif
	
	// Type:FloatNode, Name:StepMin11_sideKickupHighNoise_surfaceFX_winter
	float4 StepMin11_sideKickupHighNoise_surfaceFX_winter = float4(-0.3, -0.3, -0.3, -0.3);
	
	// Type:FloatNode, Name:StepMax21_sideKickupHighNoise_surfaceFX_winter
	float4 StepMax21_sideKickupHighNoise_surfaceFX_winter = float4(1.55, 1.55, 1.55, 1.55);
	
	// Type:MultiplyNode, Name:mulSmearMask0_surfaceFX_winter
	float4 mulSmearMask0_surfaceFX_winter = OneMinus6_surfaceFX_winter * PowKickupMaskRateAdjustment_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:mulKickupAmount0_surfaceFX_winter
	float4 mulKickupAmount0_surfaceFX_winter = mulSmearMask0_surfaceFX_winter * CarOilAmount0_surfaceFX_winter;
	
	// Type:StepNode, Name:StepSnowMaskKickup_surfaceFX_winter
	float4 StepSnowMaskKickup_surfaceFX_winter = smoothstep( StepMin11_sideKickupHighNoise_surfaceFX_winter, StepMax21_sideKickupHighNoise_surfaceFX_winter, mulKickupAmount0_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinus_surfaceFX_winter
	float4 OneMinus_surfaceFX_winter = 1 - StepSnowMaskKickup_surfaceFX_winter;
	
	// Type:FloatNode, Name:HighNoiseMaskStepRange_sideKickup_surfaceFX_winter
	float4 HighNoiseMaskStepRange_sideKickup_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:AddNode, Name:Add0_surfaceFX_winter
	float4 Add0_surfaceFX_winter = HighNoiseMaskStepRange_sideKickup_surfaceFX_winter + OneMinus_surfaceFX_winter;
	
	// Type:StepNode, Name:StepHighNoiseMask_surfaceFX_winter
	float4 StepHighNoiseMask_surfaceFX_winter = smoothstep( OneMinus_surfaceFX_winter, Add0_surfaceFX_winter, SwizzleR_surfaceFX_winter );
	
	// Type:MultiplyNode, Name:xHighNoiseMask_surfaceFX_winter
	float4 xHighNoiseMask_surfaceFX_winter = StepHighNoiseMask_surfaceFX_winter * StepSnowMaskKickup_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus2_surfaceFX_winter
	float4 OneMinus2_surfaceFX_winter = 1 - xHighNoiseMask_surfaceFX_winter;
	
	// Type:FloatNode, Name:modulationRate_surfaceFX_winter
	float4 modulationRate_surfaceFX_winter = float4(10, 10, 10, 10);
	
	// Type:PowNode, Name:PowSharpen_surfaceFX_winter
	float4 PowSharpen_surfaceFX_winter = pow( OneMinus2_surfaceFX_winter, modulationRate_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinus03_surfaceFX_winter
	float4 OneMinus03_surfaceFX_winter = 1 - PowSharpen_surfaceFX_winter;
	
	// Type:FloatNode, Name:StepMin11_height_surfaceFX_winter
	float4 StepMin11_height_surfaceFX_winter = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:FloatNode, Name:StepMax21_height_surfaceFX_winter
	float4 StepMax21_height_surfaceFX_winter = float4(0.9, 0.9, 0.9, 0.9);
	
	// Type:StepNode, Name:StepFineSnowMaskHeight_surfaceFX_winter
	float4 StepFineSnowMaskHeight_surfaceFX_winter = smoothstep( StepMin11_height_surfaceFX_winter, StepMax21_height_surfaceFX_winter, xLowNoiseSnow0_surfaceFX_winter );
	
	// Type:FloatNode, Name:StepMin11_sideKickup0_surfaceFX_winter
	float4 StepMin11_sideKickup0_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:StepMax21_sideKickup0_surfaceFX_winter
	float4 StepMax21_sideKickup0_surfaceFX_winter = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:StepFineSnowMaskKickup0_surfaceFX_winter
	float4 StepFineSnowMaskKickup0_surfaceFX_winter = smoothstep( StepMin11_sideKickup0_surfaceFX_winter, StepMax21_sideKickup0_surfaceFX_winter, mulKickupAmount0_surfaceFX_winter );
	
	// Type:MaxNode, Name:Max_surfaceFX_winter
	float4 Max_surfaceFX_winter = max(StepFineSnowMaskHeight_surfaceFX_winter, StepFineSnowMaskKickup0_surfaceFX_winter);
	
	// Type:OneMinusNode, Name:OneMinus4_surfaceFX_winter
	float4 OneMinus4_surfaceFX_winter = 1 - Max_surfaceFX_winter;
	
	// Type:FloatNode, Name:FineSnowMaskStepRange_sideKickup0_surfaceFX_winter
	float4 FineSnowMaskStepRange_sideKickup0_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:AddNode, Name:Add02_surfaceFX_winter
	float4 Add02_surfaceFX_winter = FineSnowMaskStepRange_sideKickup0_surfaceFX_winter + OneMinus4_surfaceFX_winter;
	
	// Type:StepNode, Name:StepFineSnowMask_surfaceFX_winter
	float4 StepFineSnowMask_surfaceFX_winter = smoothstep( OneMinus4_surfaceFX_winter, Add02_surfaceFX_winter, HighNoiseTexture_surfaceFX_winterBlue );
	
	// Type:MultiplyNode, Name:xHighNoiseMask2_surfaceFX_winter
	float4 xHighNoiseMask2_surfaceFX_winter = StepFineSnowMask_surfaceFX_winter * Max_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus21_surfaceFX_winter
	float4 OneMinus21_surfaceFX_winter = 1 - xHighNoiseMask2_surfaceFX_winter;
	
	// Type:FloatNode, Name:modulationRate1_surfaceFX_winter
	float4 modulationRate1_surfaceFX_winter = float4(10, 10, 10, 10);
	
	// Type:PowNode, Name:PowSharpen1_surfaceFX_winter
	float4 PowSharpen1_surfaceFX_winter = pow( OneMinus21_surfaceFX_winter, modulationRate1_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinus031_surfaceFX_winter
	float4 OneMinus031_surfaceFX_winter = 1 - PowSharpen1_surfaceFX_winter;
	
	// Type:FloatNode, Name:FloatTunedLevel_surfaceFX_winter
	float4 FloatTunedLevel_surfaceFX_winter = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:MultiplyNode, Name:mulFineSnowMaxLevel_surfaceFX_winter
	float4 mulFineSnowMaxLevel_surfaceFX_winter = OneMinus031_surfaceFX_winter * FloatTunedLevel_surfaceFX_winter;
	
	// Type:MaxNode, Name:MaxSnowHighAndFine_surfaceFX_winter
	float4 MaxSnowHighAndFine_surfaceFX_winter = max(OneMinus03_surfaceFX_winter, mulFineSnowMaxLevel_surfaceFX_winter);
	
	// Type:MaxNode, Name:MaxSnowMaskFront_surfaceFX_winter
	float4 MaxSnowMaskFront_surfaceFX_winter = max(MaxSnowHighAndFine_surfaceFX_winter, xHighNoiseMask00_surfaceFX_winter);
	
	// Type:MaxNode, Name:MaxSnowMask0_surfaceFX_winter
	float4 MaxSnowMask0_surfaceFX_winter = max(OneMinus030_surfaceFX_winter, MaxSnowMaskFront_surfaceFX_winter);
	
	// Type:CarReceivesOilNode, Name:CarReceivesOil00_surfaceFX_winter
	float4 CarReceivesOil00_surfaceFX_winter;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesOil00_surfaceFX_winter = mulDummyUVforCompatibility_surfaceFX_winter;
	#else
	[branch]
	if (ReceivesOil())
	{
		CarReceivesOil00_surfaceFX_winter = MaxSnowMask0_surfaceFX_winter;
	}
	else
	{
		CarReceivesOil00_surfaceFX_winter = mulDummyUVforCompatibility_surfaceFX_winter;
	}
	#endif
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel01_surfaceFX_winter
	float4 CarPartIsWheel01_surfaceFX_winter;
	float4 CarPartIsWheel01_surfaceFX_winterOut1;
	float4 CarPartIsWheel01_surfaceFX_winterOut2;
	float4 CarPartIsWheel01_surfaceFX_winterOut3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel01_surfaceFX_winter = CarReceivesDirt0_surfaceFX_winter;
	CarPartIsWheel01_surfaceFX_winterOut1 = CarReceivesOil0_surfaceFX_winter;
	CarPartIsWheel01_surfaceFX_winterOut2 = CarReceivesDirt00_surfaceFX_winter;
	CarPartIsWheel01_surfaceFX_winterOut3 = CarReceivesOil00_surfaceFX_winter;
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel01_surfaceFX_winter = mulWheelStationaryFrostMaskScaler_surfaceFX_winter;
		CarPartIsWheel01_surfaceFX_winterOut1 = mulWheelFrostFade10_surfaceFX_winter;
		CarPartIsWheel01_surfaceFX_winterOut2 = StationaryWheelSnow_surfaceFX_winter;
		CarPartIsWheel01_surfaceFX_winterOut3 = xHighNoiseMask1_surfaceFX_winter;
	}
	else
	{
		CarPartIsWheel01_surfaceFX_winter = CarReceivesDirt0_surfaceFX_winter;
		CarPartIsWheel01_surfaceFX_winterOut1 = CarReceivesOil0_surfaceFX_winter;
		CarPartIsWheel01_surfaceFX_winterOut2 = CarReceivesDirt00_surfaceFX_winter;
		CarPartIsWheel01_surfaceFX_winterOut3 = CarReceivesOil00_surfaceFX_winter;
	}
	#endif
	
	// Type:LerpNode, Name:LerpDrivingSnowSpecificTranslucency_surfaceFX_winter
	float4 LerpDrivingSnowSpecificTranslucency_surfaceFX_winter = lerp(LerpAngleTranslucencyFade_surfaceFX_winter, Pow0_surfaceFX_winter, CarPartIsWheel01_surfaceFX_winterOut3.x);
	
	// Type:AddNode, Name:AddFrostMasksDrivingAndStationary_surfaceFX_winter
	float4 AddFrostMasksDrivingAndStationary_surfaceFX_winter = CarPartIsWheel01_surfaceFX_winter + CarPartIsWheel01_surfaceFX_winterOut1;
	
	// Type:FloatNode, Name:Float2_surfaceFX_winter
	float4 Float2_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:FloatWadingWaterDiffScaler_surfaceFX_winter
	float4 FloatWadingWaterDiffScaler_surfaceFX_winter = float4(0.12, 0.12, 0.12, 0.12);
	
	// Type:FloatNode, Name:FloatWadingWaterDiffScalerWheel_surfaceFX_winter
	float4 FloatWadingWaterDiffScalerWheel_surfaceFX_winter = float4(0.06, 0.06, 0.06, 0.06);
	
	// Type:LerpNode, Name:Lerp0_surfaceFX_winter
	float4 Lerp0_surfaceFX_winter = lerp(FloatWadingWaterDiffScaler_surfaceFX_winter, FloatWadingWaterDiffScalerWheel_surfaceFX_winter, CarPartIsWheel_noise_surfaceFX_winterOut3.x);
	
	// Type:FloatNode, Name:floatNoiseTexStepRange0_surfaceFX_winter
	float4 floatNoiseTexStepRange0_surfaceFX_winter = float4(-0.1, -0.1, -0.1, -0.1);
	
	// Type:FloatNode, Name:WadingSplashTransitionRangeInMeters_surfaceFX_winter
	float4 WadingSplashTransitionRangeInMeters_surfaceFX_winter = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:AddNode, Name:Add2_surfaceFX_winter
	float4 Add2_surfaceFX_winter = WadingSplashTransitionRangeInMeters_surfaceFX_winter + CarPartIsWheel_noise_surfaceFX_winter;
	
	// Type:StepNode, Name:StepWadingLevel_surfaceFX_winter
	float4 StepWadingLevel_surfaceFX_winter = linearstep( CarPartIsWheel_noise_surfaceFX_winter, Add2_surfaceFX_winter, CarPartIsWheel_noise_surfaceFX_winterOut2 );
	
	// Type:AddNode, Name:Add200_surfaceFX_winter
	float4 Add200_surfaceFX_winter = floatNoiseTexStepRange0_surfaceFX_winter + StepWadingLevel_surfaceFX_winter;
	
	// Type:StepNode, Name:StepNoiseTexture_surfaceFX_winter
	float4 StepNoiseTexture_surfaceFX_winter = linearstep( Add200_surfaceFX_winter, StepWadingLevel_surfaceFX_winter, CarPartIsWheel_noise_surfaceFX_winterOut1 );
	
	// Type:LerpNode, Name:LerpWadingWaterDiffScaler_surfaceFX_winter
	float4 LerpWadingWaterDiffScaler_surfaceFX_winter = lerp(Float2_surfaceFX_winter, Lerp0_surfaceFX_winter, StepNoiseTexture_surfaceFX_winter.x);
	
	// Type:MultiplyNode, Name:mulWadingWaterDiffMaskFade00_surfaceFX_winter
	float4 mulWadingWaterDiffMaskFade00_surfaceFX_winter = AddFrostMasksDrivingAndStationary_surfaceFX_winter * LerpWadingWaterDiffScaler_surfaceFX_winter;
	
	// Type:AddNode, Name:AddSnowMasksDrivingAndStationary_surfaceFX_winter
	float4 AddSnowMasksDrivingAndStationary_surfaceFX_winter = CarPartIsWheel01_surfaceFX_winterOut2 + CarPartIsWheel01_surfaceFX_winterOut3;
	
	// Type:MultiplyNode, Name:mulWadingWaterDiffMaskFade0_surfaceFX_winter
	float4 mulWadingWaterDiffMaskFade0_surfaceFX_winter = LerpWadingWaterDiffScaler_surfaceFX_winter * AddSnowMasksDrivingAndStationary_surfaceFX_winter;
	
	// Type:AddNode, Name:Add_SnowFrostThickness_surfaceFX_winter
	float4 Add_SnowFrostThickness_surfaceFX_winter = mulWadingWaterDiffMaskFade00_surfaceFX_winter + mulWadingWaterDiffMaskFade0_surfaceFX_winter;
	
	// Type:SaturateNode, Name:Saturate_surfaceFX_winter
	float4 Saturate_surfaceFX_winter = saturate( Add_SnowFrostThickness_surfaceFX_winter ); 
	
	// Type:MultiplyNode, Name:mulTranslucencyMaskSnowPlusFrost_surfaceFX_winter
	float4 mulTranslucencyMaskSnowPlusFrost_surfaceFX_winter = LerpDrivingSnowSpecificTranslucency_surfaceFX_winter * Saturate_surfaceFX_winter;
	
	// Type:LerpNode, Name:LerpSnowFrostDiffuse_surfaceFX_winter
	float4 LerpSnowFrostDiffuse_surfaceFX_winter = lerp(DiffuseColour_surfaceFX_winter, SnowDiffuseTexture_surfaceFX_winter, mulTranslucencyMaskSnowPlusFrost_surfaceFX_winter.x);
	
	// Type:ColorNode, Name:ColorGrime_surfaceFX_winter
	float4 ColorGrime_surfaceFX_winter = ColorGrimeColorParam_surfaceFX_winter;
	float4 ColorGrime_surfaceFX_winterRed = ColorGrimeColorParam_surfaceFX_winter.rrrr;
	float4 ColorGrime_surfaceFX_winterGreen = ColorGrimeColorParam_surfaceFX_winter.gggg;
	float4 ColorGrime_surfaceFX_winterBlue = ColorGrimeColorParam_surfaceFX_winter.bbbb;
	float4 ColorGrime_surfaceFX_winterAlpha = ColorGrimeColorParam_surfaceFX_winter.aaaa;
	
	// Type:FloatNode, Name:Float1_surfaceFX_winter
	float4 Float1_surfaceFX_winter = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:MultiplyNode, Name:mulWetDarken_surfaceFX_winter
	float4 mulWetDarken_surfaceFX_winter = ColorGrime_surfaceFX_winter * Float1_surfaceFX_winter;
	
	// Type:CarWetAmountNode, Name:GlobalCarWetness_surfaceFX_winter
	float4 GlobalCarWetness_surfaceFX_winter = GetWetMudAmount().xxxx;
	
	// Type:MaxNode, Name:MaxWetMask_surfaceFX_winter
	float4 MaxWetMask_surfaceFX_winter = max(GlobalCarWetness_surfaceFX_winter, StepNoiseTexture_surfaceFX_winter);
	
	// Type:LerpNode, Name:LerpWetGrime_surfaceFX_winter
	float4 LerpWetGrime_surfaceFX_winter = lerp(ColorGrime_surfaceFX_winter, mulWetDarken_surfaceFX_winter, MaxWetMask_surfaceFX_winter.x);
	
	// Type:Vector4Node, Name:Vector4_surfaceFX_winter
	float4 Vector4_surfaceFX_winter = float4(0.2126, 0.7152, 0.0722, 1) ;
	
	// Type:FunctionInputNode, Name:MetalColour_surfaceFX_winter
	float4 MetalColour_surfaceFX_winter = dataIn.MetalColour;
	float4 MetalColour_surfaceFX_winterPreview = float4(0,0,0,0);
	
	// Type:DotNode, Name:DotMetalColourRelLuminance_surfaceFX_winter
	float4 DotMetalColourRelLuminance_surfaceFX_winter = dot(Vector4_surfaceFX_winter, MetalColour_surfaceFX_winter);
	
	// Type:FloatNode, Name:metalContributionScaler_surfaceFX_winter
	float4 metalContributionScaler_surfaceFX_winter = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:MultiplyNode, Name:mulMixedWithMetalLight0_surfaceFX_winter
	float4 mulMixedWithMetalLight0_surfaceFX_winter = DotMetalColourRelLuminance_surfaceFX_winter * metalContributionScaler_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:mulMixedWithMetalLight_surfaceFX_winter
	float4 mulMixedWithMetalLight_surfaceFX_winter = mulMixedWithMetalLight0_surfaceFX_winter * LerpWetGrime_surfaceFX_winter;
	
	// Type:AddNode, Name:Add_surfaceFX_winter
	float4 Add_surfaceFX_winter = mulMixedWithMetalLight_surfaceFX_winter + LerpWetGrime_surfaceFX_winter;
	
	// Type:FunctionInputNode, Name:Metalness_surfaceFX_winter
	float4 Metalness_surfaceFX_winter = dataIn.Metalness;
	float4 Metalness_surfaceFX_winterPreview = float4(0,0,0,0);
	
	// Type:LerpNode, Name:LerpDiffWithMixedMetal_surfaceFX_winter
	float4 LerpDiffWithMixedMetal_surfaceFX_winter = lerp(LerpWetGrime_surfaceFX_winter, Add_surfaceFX_winter, Metalness_surfaceFX_winter.x);
	
	// Type:FloatNode, Name:stepmin_thickness_surfaceFX_winter
	float4 stepmin_thickness_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:stepmax_thickness_surfaceFX_winter
	float4 stepmax_thickness_surfaceFX_winter = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:CarGrimeAmountNode, Name:CarGrimeAmount_surfaceFX_winter
	float4 CarGrimeAmount_surfaceFX_winter = GetCarGrimeAmount().xxxx;
	
	// Type:FloatNode, Name:Float0_surfaceFX_winter
	float4 Float0_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:CarReceivesDirtNode, Name:CarReceivesDirt01_surfaceFX_winter
	float4 CarReceivesDirt01_surfaceFX_winter;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDirt01_surfaceFX_winter = Float0_surfaceFX_winter;
	#else
	[branch]
	if (ReceivesDirt())
	{
		CarReceivesDirt01_surfaceFX_winter = CarGrimeAmount_surfaceFX_winter;
	}
	else
	{
		CarReceivesDirt01_surfaceFX_winter = Float0_surfaceFX_winter;
	}
	#endif
	
	// Type:FloatNode, Name:Float_surfaceFX_winter
	float4 Float_surfaceFX_winter = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:PowNode, Name:PowControlRate_surfaceFX_winter
	float4 PowControlRate_surfaceFX_winter = pow( CarReceivesDirt01_surfaceFX_winter, Float_surfaceFX_winter );
	
	// Type:FloatNode, Name:fluctuationNoise00_surfaceFX_winter
	float4 fluctuationNoise00_surfaceFX_winter = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:MultiplyNode, Name:Multiply100_surfaceFX_winter
	float4 Multiply100_surfaceFX_winter = fluctuationNoise00_surfaceFX_winter * LowNoiseTexture_surfaceFX_winterRed;
	
	// Type:OneMinusNode, Name:OneMinus300_surfaceFX_winter
	float4 OneMinus300_surfaceFX_winter = 1 - Multiply100_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:xLowNoise0_surfaceFX_winter
	float4 xLowNoise0_surfaceFX_winter = PowControlRate_surfaceFX_winter * OneMinus300_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:xHighFrequencyDustTexture_surfaceFX_winter
	float4 xHighFrequencyDustTexture_surfaceFX_winter = xLowNoise0_surfaceFX_winter * SnowDiffuseTexture_surfaceFX_winterBlue;
	
	// Type:FloatNode, Name:FloatOne_surfaceFX_winter
	float4 FloatOne_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:stepStreakMin_surfaceFX_winter
	float4 stepStreakMin_surfaceFX_winter = float4(-5, -5, -5, -5);
	
	// Type:FloatNode, Name:stepStreakMax_surfaceFX_winter
	float4 stepStreakMax_surfaceFX_winter = float4(1, 1, 1, 1);
	
	// Type:StepNode, Name:StepStreakMask_surfaceFX_winter
	float4 StepStreakMask_surfaceFX_winter = linearstep( stepStreakMin_surfaceFX_winter, stepStreakMax_surfaceFX_winter, HighNoiseTexture_surfaceFX_winterAlpha );
	
	// Type:FloatNode, Name:Float9_surfaceFX_winter
	float4 Float9_surfaceFX_winter = float4(0.766, 0.766, 0.766, 0.766);
	
	// Type:FloatNode, Name:Float7_surfaceFX_winter
	float4 Float7_surfaceFX_winter = float4(0.6428, 0.6428, 0.6428, 0.6428);
	
	// Type:StepNode, Name:StepStreakSkyDirFade_surfaceFX_winter
	float4 StepStreakSkyDirFade_surfaceFX_winter = linearstep( Float9_surfaceFX_winter, Float7_surfaceFX_winter, AmountTowardsSky_surfaceFX_winter );
	
	// Type:LerpNode, Name:Lerp1_surfaceFX_winter
	float4 Lerp1_surfaceFX_winter = lerp(FloatOne_surfaceFX_winter, StepStreakMask_surfaceFX_winter, StepStreakSkyDirFade_surfaceFX_winter.x);
	
	// Type:MultiplyNode, Name:mulStreakPattern_surfaceFX_winter
	float4 mulStreakPattern_surfaceFX_winter = xHighFrequencyDustTexture_surfaceFX_winter * Lerp1_surfaceFX_winter;
	
	// Type:FloatNode, Name:Float6_surfaceFX_winter
	float4 Float6_surfaceFX_winter = float4(0.85, 0.85, 0.85, 0.85);
	
	// Type:FloatNode, Name:Float51_surfaceFX_winter
	float4 Float51_surfaceFX_winter = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:OneMinusNode, Name:OneMinus10_surfaceFX_winter
	float4 OneMinus10_surfaceFX_winter = 1 - NdotV_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:Multiply4_surfaceFX_winter
	float4 Multiply4_surfaceFX_winter = Float51_surfaceFX_winter * OneMinus10_surfaceFX_winter;
	
	// Type:AddNode, Name:AddViewVectorVariation_surfaceFX_winter
	float4 AddViewVectorVariation_surfaceFX_winter = Float6_surfaceFX_winter + Multiply4_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:xViewFade_surfaceFX_winter
	float4 xViewFade_surfaceFX_winter = mulStreakPattern_surfaceFX_winter * AddViewVectorVariation_surfaceFX_winter;
	
	// Type:FloatNode, Name:maxDustThicknessPercentageBottom_surfaceFX_winter
	float4 maxDustThicknessPercentageBottom_surfaceFX_winter = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:FloatNode, Name:maxDustThicknessPercentage1_surfaceFX_winter
	float4 maxDustThicknessPercentage1_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:maxDustKickupThickness_surfaceFX_winter
	float4 maxDustKickupThickness_surfaceFX_winter = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:LerpNode, Name:LerpKickupDust_surfaceFX_winter
	float4 LerpKickupDust_surfaceFX_winter = lerp(maxDustThicknessPercentage1_surfaceFX_winter, maxDustKickupThickness_surfaceFX_winter, VertexColor_surfaceFX_winterGreen.x);
	
	// Type:FloatNode, Name:FloatLowerVertHeightInMeters_surfaceFX_winter
	float4 FloatLowerVertHeightInMeters_surfaceFX_winter = float4(-0.2, -0.2, -0.2, -0.2);
	
	// Type:FloatNode, Name:FloatHigherVertHeightInMeters_surfaceFX_winter
	float4 FloatHigherVertHeightInMeters_surfaceFX_winter = float4(0.95, 0.95, 0.95, 0.95);
	
	// Type:StepNode, Name:step_bottomFade0_surfaceFX_winter
	float4 step_bottomFade0_surfaceFX_winter = linearstep( FloatLowerVertHeightInMeters_surfaceFX_winter, FloatHigherVertHeightInMeters_surfaceFX_winter, MulToMeters_surfaceFX_winter );
	
	// Type:LerpNode, Name:LerpBottomFadeMultiplier0_surfaceFX_winter
	float4 LerpBottomFadeMultiplier0_surfaceFX_winter = lerp(maxDustThicknessPercentageBottom_surfaceFX_winter, LerpKickupDust_surfaceFX_winter, step_bottomFade0_surfaceFX_winter.x);
	
	// Type:FloatNode, Name:maxSmearMaskMultipler0_surfaceFX_winter
	float4 maxSmearMaskMultipler0_surfaceFX_winter = float4(0.08, 0.08, 0.08, 0.08);
	
	// Type:MultiplyNode, Name:Multiply60_surfaceFX_winter
	float4 Multiply60_surfaceFX_winter = TextureWetnessEdge_surfaceFX_winterGreen * maxSmearMaskMultipler0_surfaceFX_winter;
	
	// Type:OneMinusNode, Name:OneMinus7_surfaceFX_winter
	float4 OneMinus7_surfaceFX_winter = 1 - Multiply60_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:mulDustSmearMask_surfaceFX_winter
	float4 mulDustSmearMask_surfaceFX_winter = LerpBottomFadeMultiplier0_surfaceFX_winter * OneMinus7_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:xDustCombinedNonWheel_surfaceFX_winter
	float4 xDustCombinedNonWheel_surfaceFX_winter = xViewFade_surfaceFX_winter * mulDustSmearMask_surfaceFX_winter;
	
	// Type:StepNode, Name:SmoothStep_test_surfaceFX_winter
	float4 SmoothStep_test_surfaceFX_winter = smoothstep( stepmin_thickness_surfaceFX_winter, stepmax_thickness_surfaceFX_winter, xDustCombinedNonWheel_surfaceFX_winter );
	
	// Type:LerpNode, Name:LerpGrimeDiffuse_surfaceFX_winter
	float4 LerpGrimeDiffuse_surfaceFX_winter = lerp(LerpSnowFrostDiffuse_surfaceFX_winter, LerpDiffWithMixedMetal_surfaceFX_winter, SmoothStep_test_surfaceFX_winter.x);
	
	// Type:NormalMapWithIntensityNode, Name:NormalMapWithIntensity_surfaceFX_winter
	float4 textureLookup_NormalMapWithIntensity_surfaceFX_winter = NormalMapWithIntensityTexture_surfaceFX_winter.Sample(SamplerStatesSampler, CH2UV1_surfaceFX_winter.xy * NormalMapWithIntensityTiling_surfaceFX_winter);
	#ifdef _MAX_
	textureLookup_NormalMapWithIntensity_surfaceFX_winter.xyz = pow(textureLookup_NormalMapWithIntensity_surfaceFX_winter.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter = (2.0f * textureLookup_NormalMapWithIntensity_surfaceFX_winter.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapWithIntensity_surfaceFX_winterGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter, NormalMapWithIntensitySpecPower_surfaceFX_winter);
	float4 NormalMapWithIntensity_surfaceFX_winterAlpha = textureLookup_NormalMapWithIntensity_surfaceFX_winter.aaaa;
	float4 NormalMapWithIntensity_surfaceFX_winterRed = textureLookup_NormalMapWithIntensity_surfaceFX_winter.rrrr;
	float4 NormalMapWithIntensity_surfaceFX_winterGreen = textureLookup_NormalMapWithIntensity_surfaceFX_winter.gggg;
	float4 NormalMapWithIntensity_surfaceFX_winterBlue = textureLookup_NormalMapWithIntensity_surfaceFX_winter.bbbb;
	tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter.x*tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter.x - tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter.y*tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter.xy *= g_GlobalNormalScale * NormalMapWithIntensityHeightScale_surfaceFX_winter.x;
	#else
	tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter.xy *= NormalMapWithIntensityHeightScale_surfaceFX_winter.x;
	#endif
	float4 NormalMapWithIntensity_surfaceFX_winter = float4(normalize(mul(tangentSpaceNormal_NormalMapWithIntensity_surfaceFX_winter, float3x3(CH2UV1_surfaceFX_winterTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, CH2UV1_surfaceFX_winterTangent.xyz) * CH2UV1_surfaceFX_winterTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMapWithIntensity_surfaceFX_winter = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:F0ValuesNode, Name:F0Values_snowFrost_surfaceFX_winter
	float4 F0Values_snowFrost_surfaceFX_winter = float4(0.04, 0.04, 0.04, 1) ;
	
	// Type:F0ValuesNode, Name:F0Values_grime_surfaceFX_winter
	float4 F0Values_grime_surfaceFX_winter = float4(0.01790891, 0.01790891, 0.01790891, 1) ;
	
	// Type:FloatNode, Name:stepmin_target_surfaceFX_winter
	float4 stepmin_target_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:stepmax_target_surfaceFX_winter
	float4 stepmax_target_surfaceFX_winter = float4(0.6, 0.6, 0.6, 0.6);
	
	// Type:StepNode, Name:Step_test0_surfaceFX_winter
	float4 Step_test0_surfaceFX_winter = linearstep( stepmin_target_surfaceFX_winter, stepmax_target_surfaceFX_winter, xDustCombinedNonWheel_surfaceFX_winter );
	
	// Type:FloatNode, Name:FloatNoINF0_surfaceFX_winter
	float4 FloatNoINF0_surfaceFX_winter = float4(0.001, 0.001, 0.001, 0.001);
	
	// Type:AddNode, Name:Add3_surfaceFX_winter
	float4 Add3_surfaceFX_winter = FloatNoINF0_surfaceFX_winter + Saturate_surfaceFX_winter;
	
	// Type:DivideNode, Name:DivideBetweenGrimeMaskAndSnowFrostMask_surfaceFX_winter
	float4 DivideBetweenGrimeMaskAndSnowFrostMask_surfaceFX_winter = Step_test0_surfaceFX_winter / Add3_surfaceFX_winter;
	
	// Type:SaturateNode, Name:Saturate1_surfaceFX_winter
	float4 Saturate1_surfaceFX_winter = saturate( DivideBetweenGrimeMaskAndSnowFrostMask_surfaceFX_winter ); 
	
	// Type:LerpNode, Name:LerpGrimeF0_surfaceFX_winter
	float4 LerpGrimeF0_surfaceFX_winter = lerp(F0Values_snowFrost_surfaceFX_winter, F0Values_grime_surfaceFX_winter, Saturate1_surfaceFX_winter.x);
	
	// Type:FloatNode, Name:GlossMatte_surfaceFX_winter
	float4 GlossMatte_surfaceFX_winter = float4(0.05, 0.05, 0.05, 0.05);
	
	// Type:LerpNode, Name:LerpGrimeGloss_surfaceFX_winter
	float4 LerpGrimeGloss_surfaceFX_winter = lerp(SnowDiffuseTexture_surfaceFX_winterAlpha, GlossMatte_surfaceFX_winter, Saturate1_surfaceFX_winter.x);
	
	// Type:AOMapValueNode, Name:AOMapValue0_surfaceFX_winter
	float4 AOMapValue0_surfaceFX_winter = g_AOMapValue.xxxx;
	// Type:OneMinusNode, Name:OneMinus8_surfaceFX_winter
	float4 OneMinus8_surfaceFX_winter = 1 - AOMapValue0_surfaceFX_winter;
	
	// Type:FloatNode, Name:floatSnowAOPower_surfaceFX_winter
	float4 floatSnowAOPower_surfaceFX_winter = float4(2, 2, 2, 2);
	
	// Type:PowNode, Name:Pow00_surfaceFX_winter
	float4 Pow00_surfaceFX_winter = pow( OneMinus8_surfaceFX_winter, floatSnowAOPower_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinus02_surfaceFX_winter
	float4 OneMinus02_surfaceFX_winter = 1 - Pow00_surfaceFX_winter;
	
	// Type:LerpNode, Name:SurfaceFX_AOSnow_surfaceFX_winter
	float4 SurfaceFX_AOSnow_surfaceFX_winter = lerp(AOMapValue0_surfaceFX_winter, OneMinus02_surfaceFX_winter, mulTranslucencyMaskSnowPlusFrost_surfaceFX_winter.x);
	
	// Type:BlinnPhongPixelShadernode, Name:Root_surfaceFX_winter
	
	// Type:FloatNode, Name:MaxWaterAmount_surfaceFX_winter
	float4 MaxWaterAmount_surfaceFX_winter = float4(0.6, 0.6, 0.6, 0.6);
	
	// Type:MultiplyNode, Name:MulScaleWaterAmountFromWetMask_surfaceFX_winter
	float4 MulScaleWaterAmountFromWetMask_surfaceFX_winter = StepNoiseTexture_surfaceFX_winter * MaxWaterAmount_surfaceFX_winter;
	
	// Type:FloatNode, Name:Float11_surfaceFX_winter
	float4 Float11_surfaceFX_winter = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:FloatNode, Name:Float12_surfaceFX_winter
	float4 Float12_surfaceFX_winter = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:StepNode, Name:StepNormalMask_surfaceFX_winter
	float4 StepNormalMask_surfaceFX_winter = linearstep( Float11_surfaceFX_winter, Float12_surfaceFX_winter, Saturate_surfaceFX_winter );
	
	// Type:ObjectNormalNode, Name:ObjectNormal_surfaceFX_winter
	float4 ObjectNormal_surfaceFX_winter = normalize(mul(float4(GetWorldNormal(In).xyz, 0), g_InvWorldMatrix));
	// Type:OneMinusNode, Name:OneMinus4101_surfaceFX_winter
	float4 OneMinus4101_surfaceFX_winter = 1 - Saturate_surfaceFX_winter;
	
	// Type:FloatNode, Name:Float7010_surfaceFX_winter
	float4 Float7010_surfaceFX_winter = float4(10, 10, 10, 10);
	
	// Type:PowNode, Name:PowGlossRate1_surfaceFX_winter
	float4 PowGlossRate1_surfaceFX_winter = pow( OneMinus4101_surfaceFX_winter, Float7010_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinusFrostSnowGloss_surfaceFX_winter
	float4 OneMinusFrostSnowGloss_surfaceFX_winter = 1 - PowGlossRate1_surfaceFX_winter;
	
	// Type:FloatNode, Name:Float40_surfaceFX_winter
	float4 Float40_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:Float70_surfaceFX_winter
	float4 Float70_surfaceFX_winter = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:StepF0Mask0_surfaceFX_winter
	float4 StepF0Mask0_surfaceFX_winter = linearstep( Float40_surfaceFX_winter, Float70_surfaceFX_winter, Saturate_surfaceFX_winter );
	
	// Type:Vector4Node, Name:FrontVector0_surfaceFX_winter
	float4 FrontVector0_surfaceFX_winter = float4(0, 0.1736, 0.9848, 1) ;
	
	// Type:OneMinusNode, Name:OneMinus1_surfaceFX_winter
	float4 OneMinus1_surfaceFX_winter = 1 - TextureWetnessEdge_surfaceFX_winterRed;
	
	// Type:AddNode, Name:AddUpAllMaskGradientForOptimisation_surfaceFX_winter
	float4 AddUpAllMaskGradientForOptimisation_surfaceFX_winter = MulHeightMask_surfaceFX_winter + mulKickupAmount0_surfaceFX_winter;
	
	// Type:FloatNode, Name:Note_vertColorBisDotSideVec_surfaceFX_winter
	float4 Note_vertColorBisDotSideVec_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:CarTireSnowDepthNode, Name:CarTireSnowDepth_surfaceFX_winter
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IN_MATERIAL_EDITOR)
	float4 CarTireSnowDepth_surfaceFX_winter = GetTireSnowDepth();
	#else
	float4 CarTireSnowDepth_surfaceFX_winter = float4(0,0,0,0);
	#endif
	
	// Type:MultiplyNode, Name:mulDiffGrimeSnow_surfaceFX_winter
	float4 mulDiffGrimeSnow_surfaceFX_winter = LerpWetGrime_surfaceFX_winter * SnowDiffuseTexture_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:mulThicknessGrimeSnow_surfaceFX_winter
	float4 mulThicknessGrimeSnow_surfaceFX_winter = SmoothStep_test_surfaceFX_winter * Saturate_surfaceFX_winter;
	
	// Type:LerpNode, Name:Lerp_surfaceFX_winter
	float4 Lerp_surfaceFX_winter = lerp(SnowDiffuseTexture_surfaceFX_winter, mulDiffGrimeSnow_surfaceFX_winter, mulThicknessGrimeSnow_surfaceFX_winter.x);
	
	// Type:LerpNode, Name:LerpDiffColorSnowOrGrime_surfaceFX_winter
	float4 LerpDiffColorSnowOrGrime_surfaceFX_winter = lerp(Lerp_surfaceFX_winter, LerpWetGrime_surfaceFX_winter, Saturate1_surfaceFX_winter.x);
	
	// Type:FunctionOutputNode, Name:DiffuseColorNoBlend_surfaceFX_winter
	float4 DiffuseColorNoBlend_surfaceFX_winter = LerpDiffColorSnowOrGrime_surfaceFX_winter;
	
	// Type:FunctionOutputNode, Name:WetnessAmount_surfaceFX_winter
	float4 WetnessAmount_surfaceFX_winter = MulScaleWaterAmountFromWetMask_surfaceFX_winter;
	
	// Type:FunctionOutputNode, Name:FrostDiffMask_surfaceFX_winter
	float4 FrostDiffMask_surfaceFX_winter = mulWadingWaterDiffMaskFade00_surfaceFX_winter;
	
	// Type:FunctionOutputNode, Name:SnowDiffMask_surfaceFX_winter
	float4 SnowDiffMask_surfaceFX_winter = mulWadingWaterDiffMaskFade0_surfaceFX_winter;
	
	// Type:AddNode, Name:AddAllThickness_surfaceFX_winter
	float4 AddAllThickness_surfaceFX_winter = SmoothStep_test_surfaceFX_winter + mulTranslucencyMaskSnowPlusFrost_surfaceFX_winter;
	
	// Type:SaturateNode, Name:Saturate3_surfaceFX_winter
	float4 Saturate3_surfaceFX_winter = saturate( AddAllThickness_surfaceFX_winter ); 
	
	// Type:FunctionOutputNode, Name:CombinedCoverage_surfaceFX_winter
	float4 CombinedCoverage_surfaceFX_winter = Saturate3_surfaceFX_winter;
	
	// Type:FloatNode, Name:StepGrimeNormalMin_surfaceFX_winter
	float4 StepGrimeNormalMin_surfaceFX_winter = float4(0.28, 0.28, 0.28, 0.28);
	
	// Type:FloatNode, Name:StepGrimeNormalMax_surfaceFX_winter
	float4 StepGrimeNormalMax_surfaceFX_winter = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:StepNode, Name:StepGrimeNormalMask0_surfaceFX_winter
	float4 StepGrimeNormalMask0_surfaceFX_winter = linearstep( StepGrimeNormalMin_surfaceFX_winter, StepGrimeNormalMax_surfaceFX_winter, xDustCombinedNonWheel_surfaceFX_winter );
	
	// Type:MaxNode, Name:MaxNormMaskFromSnowAndGrime0_surfaceFX_winter
	float4 MaxNormMaskFromSnowAndGrime0_surfaceFX_winter = max(StepGrimeNormalMask0_surfaceFX_winter, StepNormalMask_surfaceFX_winter);
	
	// Type:FunctionOutputNode, Name:NormalMask_surfaceFX_winter
	float4 NormalMask_surfaceFX_winter = MaxNormMaskFromSnowAndGrime0_surfaceFX_winter;
	
	// Type:FloatNode, Name:maxGrimeF0Scaler_surfaceFX_winter
	float4 maxGrimeF0Scaler_surfaceFX_winter = float4(0.95, 0.95, 0.95, 0.95);
	
	// Type:MultiplyNode, Name:Multiply110_surfaceFX_winter
	float4 Multiply110_surfaceFX_winter = maxGrimeF0Scaler_surfaceFX_winter * SmoothStep_test_surfaceFX_winter;
	
	// Type:MaxNode, Name:MaxF0MaskFromSnowAndGrime_surfaceFX_winter
	float4 MaxF0MaskFromSnowAndGrime_surfaceFX_winter = max(Multiply110_surfaceFX_winter, StepF0Mask0_surfaceFX_winter);
	
	// Type:FunctionOutputNode, Name:F0Mask_surfaceFX_winter
	float4 F0Mask_surfaceFX_winter = MaxF0MaskFromSnowAndGrime_surfaceFX_winter;
	
	// Type:FloatNode, Name:maxGrimeRoughness_surfaceFX_winter
	float4 maxGrimeRoughness_surfaceFX_winter = float4(0.7, 0.7, 0.7, 0.7);
	
	// Type:OneMinusNode, Name:OneMinus41010_surfaceFX_winter
	float4 OneMinus41010_surfaceFX_winter = 1 - xDustCombinedNonWheel_surfaceFX_winter;
	
	// Type:FloatNode, Name:Float70100_surfaceFX_winter
	float4 Float70100_surfaceFX_winter = float4(10, 10, 10, 10);
	
	// Type:PowNode, Name:PowGlossRate10_surfaceFX_winter
	float4 PowGlossRate10_surfaceFX_winter = pow( OneMinus41010_surfaceFX_winter, Float70100_surfaceFX_winter );
	
	// Type:OneMinusNode, Name:OneMinusFrostSnowGloss0_surfaceFX_winter
	float4 OneMinusFrostSnowGloss0_surfaceFX_winter = 1 - PowGlossRate10_surfaceFX_winter;
	
	// Type:MultiplyNode, Name:Multiply11_surfaceFX_winter
	float4 Multiply11_surfaceFX_winter = maxGrimeRoughness_surfaceFX_winter * OneMinusFrostSnowGloss0_surfaceFX_winter;
	
	// Type:MaxNode, Name:MaxGlossMaskFromSnowAndGrime0_surfaceFX_winter
	float4 MaxGlossMaskFromSnowAndGrime0_surfaceFX_winter = max(Multiply11_surfaceFX_winter, OneMinusFrostSnowGloss_surfaceFX_winter);
	
	// Type:FunctionOutputNode, Name:GlossMask_surfaceFX_winter
	float4 GlossMask_surfaceFX_winter = MaxGlossMaskFromSnowAndGrime0_surfaceFX_winter;
	
	// Type:FloatNode, Name:ParallaxAmountClean_surfaceFX_winter
	float4 ParallaxAmountClean_surfaceFX_winter = float4(0.04, 0.04, 0.04, 0.04);
	
	// Type:FloatNode, Name:BaseHeight_surfaceFX_winter
	float4 BaseHeight_surfaceFX_winter = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FloatNode, Name:Offset_surfaceFX_winter
	float4 Offset_surfaceFX_winter = float4(0, 0, 0, 0);
	
	// Type:ParallaxMappingNode, Name:ParallaxMapping_surfaceFX_winter
	float4 ParallaxMapping_surfaceFX_winter = 0;
	ParallaxMapping_surfaceFX_winter.xy = ParallaxMap(CH2UV1_surfaceFX_winter.xy, SwizzleR_surfaceFX_winter.x, BaseHeight_surfaceFX_winter.x, ParallaxAmountClean_surfaceFX_winter.x, Offset_surfaceFX_winter.x, GetViewVector(), GetWorldNormal(In).xyz, CH2UV1_surfaceFX_winterTangent.xyzw);
	
	// Type:FloatNode, Name:ParallaxMappingIntOverride_surfaceFX_winter
	float4 ParallaxMappingIntOverride_surfaceFX_winter = float4(0.7, 0.7, 0.7, 0.7);
	
	surfaceFX_winterShaderFunctionOutput dataOut;
	dataOut.DiffuseColor = LerpGrimeDiffuse_surfaceFX_winter;
	dataOut.Normal = NormalMapWithIntensity_surfaceFX_winter;
	dataOut.F0 = LerpGrimeF0_surfaceFX_winter;
	dataOut.Glossiness = LerpGrimeGloss_surfaceFX_winter;
	dataOut.CarAOOverride = SurfaceFX_AOSnow_surfaceFX_winter;
	dataOut.DiffuseColorNoBlend = DiffuseColorNoBlend_surfaceFX_winter;
	dataOut.WetnessAmount = WetnessAmount_surfaceFX_winter;
	dataOut.FrostDiffMask = FrostDiffMask_surfaceFX_winter;
	dataOut.SnowDiffMask = SnowDiffMask_surfaceFX_winter;
	dataOut.CombinedCoverage = CombinedCoverage_surfaceFX_winter;
	dataOut.NormalMask = NormalMask_surfaceFX_winter;
	dataOut.F0Mask = F0Mask_surfaceFX_winter;
	dataOut.GlossMask = GlossMask_surfaceFX_winter;
	return dataOut;
}

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStatesSampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:FunctionInputNode, Name:DiffuseColour
	float4 DiffuseColour = float4(0,0,0,0);
	float4 DiffuseColourPreview = float4(0,0,0,0);
	
	// Type:FunctionInputNode, Name:MetalColour
	float4 MetalColour = float4(0,0,0,0);
	float4 MetalColourPreview = float4(0,0,0,0);
	
	// Type:FunctionInputNode, Name:Metalness
	float4 Metalness = float4(0,0,0,0);
	float4 MetalnessPreview = float4(0,0,0,0);
	
	// Type:FunctionNode, Name:surfaceFX_opus
	float4 surfaceFX_opus;
	float4 surfaceFX_opusDiffuseColor;
	float4 surfaceFX_opusNormal;
	float4 surfaceFX_opusF0;
	float4 surfaceFX_opusGlossiness;
	float4 surfaceFX_opusCarAOOverride;
	float4 surfaceFX_opusDiffuseColorNoBlend;
	float4 surfaceFX_opusDustMask;
	float4 surfaceFX_opusCombinedCoverage;
	float4 surfaceFX_opusWetnessAmount;
	float4 surfaceFX_opusMudDiffMask;
	float4 surfaceFX_opusNormalMask;
	float4 surfaceFX_opusF0Mask;
	float4 surfaceFX_opusGlossMask;
	{
		surfaceFX_opusShaderFunctionInput inputData;
		inputData.SamplerStates = SamplerStates;
		inputData.DiffuseColour = DiffuseColour;
		inputData.MetalColour = MetalColour;
		inputData.Metalness = Metalness;
		surfaceFX_opusShaderFunctionOutput funcData = surfaceFX_opusShaderFunction(In, inputData);
		surfaceFX_opus = funcData.DiffuseColor;
		surfaceFX_opusDiffuseColor = funcData.DiffuseColor;
		surfaceFX_opusNormal = funcData.Normal;
		surfaceFX_opusF0 = funcData.F0;
		surfaceFX_opusGlossiness = funcData.Glossiness;
		surfaceFX_opusCarAOOverride = funcData.CarAOOverride;
		surfaceFX_opusDiffuseColorNoBlend = funcData.DiffuseColorNoBlend;
		surfaceFX_opusDustMask = funcData.DustMask;
		surfaceFX_opusCombinedCoverage = funcData.CombinedCoverage;
		surfaceFX_opusWetnessAmount = funcData.WetnessAmount;
		surfaceFX_opusMudDiffMask = funcData.MudDiffMask;
		surfaceFX_opusNormalMask = funcData.NormalMask;
		surfaceFX_opusF0Mask = funcData.F0Mask;
		surfaceFX_opusGlossMask = funcData.GlossMask;
	}
	
	// Type:FunctionNode, Name:surfaceFX_winter
	float4 surfaceFX_winter;
	float4 surfaceFX_winterDiffuseColor;
	float4 surfaceFX_winterNormal;
	float4 surfaceFX_winterF0;
	float4 surfaceFX_winterGlossiness;
	float4 surfaceFX_winterCarAOOverride;
	float4 surfaceFX_winterDiffuseColorNoBlend;
	float4 surfaceFX_winterWetnessAmount;
	float4 surfaceFX_winterFrostDiffMask;
	float4 surfaceFX_winterSnowDiffMask;
	float4 surfaceFX_winterCombinedCoverage;
	float4 surfaceFX_winterNormalMask;
	float4 surfaceFX_winterF0Mask;
	float4 surfaceFX_winterGlossMask;
	{
		surfaceFX_winterShaderFunctionInput inputData;
		inputData.SamplerStates = SamplerStates;
		inputData.DiffuseColour = DiffuseColour;
		inputData.MetalColour = MetalColour;
		inputData.Metalness = Metalness;
		surfaceFX_winterShaderFunctionOutput funcData = surfaceFX_winterShaderFunction(In, inputData);
		surfaceFX_winter = funcData.DiffuseColor;
		surfaceFX_winterDiffuseColor = funcData.DiffuseColor;
		surfaceFX_winterNormal = funcData.Normal;
		surfaceFX_winterF0 = funcData.F0;
		surfaceFX_winterGlossiness = funcData.Glossiness;
		surfaceFX_winterCarAOOverride = funcData.CarAOOverride;
		surfaceFX_winterDiffuseColorNoBlend = funcData.DiffuseColorNoBlend;
		surfaceFX_winterWetnessAmount = funcData.WetnessAmount;
		surfaceFX_winterFrostDiffMask = funcData.FrostDiffMask;
		surfaceFX_winterSnowDiffMask = funcData.SnowDiffMask;
		surfaceFX_winterCombinedCoverage = funcData.CombinedCoverage;
		surfaceFX_winterNormalMask = funcData.NormalMask;
		surfaceFX_winterF0Mask = funcData.F0Mask;
		surfaceFX_winterGlossMask = funcData.GlossMask;
	}
	
	// Type:ColorNode, Name:ColorOFF
	float4 ColorOFF = ColorOFFColorParam;
	float4 ColorOFFRed = ColorOFFColorParam.rrrr;
	float4 ColorOFFGreen = ColorOFFColorParam.gggg;
	float4 ColorOFFBlue = ColorOFFColorParam.bbbb;
	float4 ColorOFFAlpha = ColorOFFColorParam.aaaa;
	
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:FloatNode, Name:FloatZero
	float4 FloatZero = float4(0, 0, 0, 0);
	
	// Type:AOMapValueNode, Name:CarAO
	float4 CarAO = g_AOMapValue.xxxx;
	// Type:FloatNode, Name:alwaysON
	float4 alwaysON = float4(1, 1, 1, 1);
	
	// Type:SurfaceFXMountainBranchNode, Name:SurfaceFXMountainBranch
	float4 SurfaceFXMountainBranchDiffuseColor = DiffuseColour;
	float4 SurfaceFXMountainBranchDiffuseColorNoBlend = ColorOFF;
	float4 SurfaceFXMountainBranchNormal = WorldNormal;
	float4 SurfaceFXMountainBranchWaterAmount = FloatZero;
	float4 SurfaceFXMountainBranchF0 = FloatZero;
	float4 SurfaceFXMountainBranchGlossiness = FloatZero;
	float4 SurfaceFXMountainBranchDustDiffMask = FloatZero;
	float4 SurfaceFXMountainBranchMudDiffMask = FloatZero;
	float4 SurfaceFXMountainBranchCombinedCoverage = FloatZero;
	float4 SurfaceFXMountainBranchNormalMask = FloatZero;
	float4 SurfaceFXMountainBranchF0Mask = FloatZero;
	float4 SurfaceFXMountainBranchGlossMask = FloatZero;
	float4 SurfaceFXMountainBranchCarAOOverride = CarAO;
	[branch]
	if(alwaysON.x > 0.0f)
	{
		[branch]
		if(GetUseMountainShaders())
		{
			float4 surfaceFX_winter;
			float4 surfaceFX_winterDiffuseColor;
			float4 surfaceFX_winterNormal;
			float4 surfaceFX_winterF0;
			float4 surfaceFX_winterGlossiness;
			float4 surfaceFX_winterCarAOOverride;
			float4 surfaceFX_winterDiffuseColorNoBlend;
			float4 surfaceFX_winterWetnessAmount;
			float4 surfaceFX_winterFrostDiffMask;
			float4 surfaceFX_winterSnowDiffMask;
			float4 surfaceFX_winterCombinedCoverage;
			float4 surfaceFX_winterNormalMask;
			float4 surfaceFX_winterF0Mask;
			float4 surfaceFX_winterGlossMask;
			{
				surfaceFX_winterShaderFunctionInput inputData;
				inputData.SamplerStates = SamplerStates;
				inputData.DiffuseColour = DiffuseColour;
				inputData.MetalColour = MetalColour;
				inputData.Metalness = Metalness;
				surfaceFX_winterShaderFunctionOutput funcData = surfaceFX_winterShaderFunction(In, inputData);
				surfaceFX_winter = funcData.DiffuseColor;
				surfaceFX_winterDiffuseColor = funcData.DiffuseColor;
				surfaceFX_winterNormal = funcData.Normal;
				surfaceFX_winterF0 = funcData.F0;
				surfaceFX_winterGlossiness = funcData.Glossiness;
				surfaceFX_winterCarAOOverride = funcData.CarAOOverride;
				surfaceFX_winterDiffuseColorNoBlend = funcData.DiffuseColorNoBlend;
				surfaceFX_winterWetnessAmount = funcData.WetnessAmount;
				surfaceFX_winterFrostDiffMask = funcData.FrostDiffMask;
				surfaceFX_winterSnowDiffMask = funcData.SnowDiffMask;
				surfaceFX_winterCombinedCoverage = funcData.CombinedCoverage;
				surfaceFX_winterNormalMask = funcData.NormalMask;
				surfaceFX_winterF0Mask = funcData.F0Mask;
				surfaceFX_winterGlossMask = funcData.GlossMask;
			}
			  SurfaceFXMountainBranchDiffuseColor = surfaceFX_winterDiffuseColor;
			  SurfaceFXMountainBranchDiffuseColorNoBlend = surfaceFX_winterDiffuseColorNoBlend;
			  SurfaceFXMountainBranchNormal = surfaceFX_winterNormal;
			  SurfaceFXMountainBranchWaterAmount = surfaceFX_winterWetnessAmount;
			  SurfaceFXMountainBranchF0 = surfaceFX_winterF0;
			  SurfaceFXMountainBranchGlossiness = surfaceFX_winterGlossiness;
			  SurfaceFXMountainBranchDustDiffMask = surfaceFX_winterFrostDiffMask;
			  SurfaceFXMountainBranchMudDiffMask = surfaceFX_winterSnowDiffMask;
			  SurfaceFXMountainBranchCombinedCoverage = surfaceFX_winterCombinedCoverage;
			  SurfaceFXMountainBranchNormalMask = surfaceFX_winterNormalMask;
			  SurfaceFXMountainBranchF0Mask = surfaceFX_winterF0Mask;
			  SurfaceFXMountainBranchGlossMask = surfaceFX_winterGlossMask;
			  SurfaceFXMountainBranchCarAOOverride = surfaceFX_winterCarAOOverride;
		}
		else
		{
			float4 surfaceFX_opus;
			float4 surfaceFX_opusDiffuseColor;
			float4 surfaceFX_opusNormal;
			float4 surfaceFX_opusF0;
			float4 surfaceFX_opusGlossiness;
			float4 surfaceFX_opusCarAOOverride;
			float4 surfaceFX_opusDiffuseColorNoBlend;
			float4 surfaceFX_opusDustMask;
			float4 surfaceFX_opusCombinedCoverage;
			float4 surfaceFX_opusWetnessAmount;
			float4 surfaceFX_opusMudDiffMask;
			float4 surfaceFX_opusNormalMask;
			float4 surfaceFX_opusF0Mask;
			float4 surfaceFX_opusGlossMask;
			{
				surfaceFX_opusShaderFunctionInput inputData;
				inputData.SamplerStates = SamplerStates;
				inputData.DiffuseColour = DiffuseColour;
				inputData.MetalColour = MetalColour;
				inputData.Metalness = Metalness;
				surfaceFX_opusShaderFunctionOutput funcData = surfaceFX_opusShaderFunction(In, inputData);
				surfaceFX_opus = funcData.DiffuseColor;
				surfaceFX_opusDiffuseColor = funcData.DiffuseColor;
				surfaceFX_opusNormal = funcData.Normal;
				surfaceFX_opusF0 = funcData.F0;
				surfaceFX_opusGlossiness = funcData.Glossiness;
				surfaceFX_opusCarAOOverride = funcData.CarAOOverride;
				surfaceFX_opusDiffuseColorNoBlend = funcData.DiffuseColorNoBlend;
				surfaceFX_opusDustMask = funcData.DustMask;
				surfaceFX_opusCombinedCoverage = funcData.CombinedCoverage;
				surfaceFX_opusWetnessAmount = funcData.WetnessAmount;
				surfaceFX_opusMudDiffMask = funcData.MudDiffMask;
				surfaceFX_opusNormalMask = funcData.NormalMask;
				surfaceFX_opusF0Mask = funcData.F0Mask;
				surfaceFX_opusGlossMask = funcData.GlossMask;
			}
			  SurfaceFXMountainBranchDiffuseColor = surfaceFX_opusDiffuseColor;
			  SurfaceFXMountainBranchDiffuseColorNoBlend = surfaceFX_opusDiffuseColorNoBlend;
			  SurfaceFXMountainBranchNormal = surfaceFX_opusNormal;
			  SurfaceFXMountainBranchWaterAmount = surfaceFX_opusWetnessAmount;
			  SurfaceFXMountainBranchF0 = surfaceFX_opusF0;
			  SurfaceFXMountainBranchGlossiness = surfaceFX_opusGlossiness;
			  SurfaceFXMountainBranchDustDiffMask = surfaceFX_opusDustMask;
			  SurfaceFXMountainBranchMudDiffMask = surfaceFX_opusMudDiffMask;
			  SurfaceFXMountainBranchCombinedCoverage = surfaceFX_opusCombinedCoverage;
			  SurfaceFXMountainBranchNormalMask = surfaceFX_opusNormalMask;
			  SurfaceFXMountainBranchF0Mask = surfaceFX_opusF0Mask;
			  SurfaceFXMountainBranchGlossMask = surfaceFX_opusGlossMask;
			  SurfaceFXMountainBranchCarAOOverride = surfaceFX_opusCarAOOverride;
		}
	}
	
	output.DiffuseColor = SurfaceFXMountainBranchDiffuseColor;
	output.Normal = SurfaceFXMountainBranchNormal;
	output.F0 = SurfaceFXMountainBranchF0;
	output.Glossiness = SurfaceFXMountainBranchGlossiness;
	output.CarAOOverride = SurfaceFXMountainBranchCarAOOverride;
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#include "LightScenarios\DebugLightingLightScenario.hlsl"