#include "LightScenarios\Inc\CarDebugLightingLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
int CH2UV1UVSet < string UIName = "CH2UV1UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int CH4UV3UVSet < string UIName = "CH4UV3UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
float4 ColorGrimeColorParam < string UIName = "ColorGrimeColorParam"; string UIWidget = "Color"; > = float4( 0.03310477, 0.03189603, 0.02842604, 1 );
float4 HighNoiseTextureTiling < string UIName = "HighNoiseTextureTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 HighNoiseTireBlurApproxColorParam < string UIName = "HighNoiseTireBlurApproxColorParam"; string UIWidget = "Color"; > = float4( 0.6444797, 0.1559265, 0, 1 );
float4 LowNoiseTextureTiling < string UIName = "LowNoiseTextureTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0, 0 );
float NormalMapWithIntensityHeightScale < string UIName = "NormalMapWithIntensityHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.3 ;
float NormalMapWithIntensitySpecPower < string UIName = "NormalMapWithIntensitySpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalMapWithIntensityTiling < string UIName = "NormalMapWithIntensityTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0, 0 );
bool SmoothStep_frontFadeBool < string UIName = "SmoothStep_frontFadeBool"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_frontFadeHardStepBool < string UIName = "SmoothStep_frontFadeHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool SmoothStep_testBool < string UIName = "SmoothStep_testBool"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_testHardStepBool < string UIName = "SmoothStep_testHardStepBool"; string UIWidget = "Checkbox"; > = 0;
float4 SnowDiffuseTextureTiling < string UIName = "SnowDiffuseTextureTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0, 0 );
bool step_bottomFade0Bool < string UIName = "step_bottomFade0Bool"; string UIWidget = "Checkbox"; > = 0;
bool step_bottomFade0HardStepBool < string UIName = "step_bottomFade0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool Step_test0Bool < string UIName = "Step_test0Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step_test0HardStepBool < string UIName = "Step_test0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepAngleTranslucencyFadeBool < string UIName = "StepAngleTranslucencyFadeBool"; string UIWidget = "Checkbox"; > = 1;
bool StepAngleTranslucencyFadeHardStepBool < string UIName = "StepAngleTranslucencyFadeHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepFineSnowMaskBool < string UIName = "StepFineSnowMaskBool"; string UIWidget = "Checkbox"; > = 1;
bool StepFineSnowMaskHardStepBool < string UIName = "StepFineSnowMaskHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepFineSnowMaskHeightBool < string UIName = "StepFineSnowMaskHeightBool"; string UIWidget = "Checkbox"; > = 1;
bool StepFineSnowMaskHeightHardStepBool < string UIName = "StepFineSnowMaskHeightHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepFineSnowMaskKickup0Bool < string UIName = "StepFineSnowMaskKickup0Bool"; string UIWidget = "Checkbox"; > = 1;
bool StepFineSnowMaskKickup0HardStepBool < string UIName = "StepFineSnowMaskKickup0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepFrostMask0Bool < string UIName = "StepFrostMask0Bool"; string UIWidget = "Checkbox"; > = 1;
bool StepFrostMask0HardStepBool < string UIName = "StepFrostMask0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepFrostMask10Bool < string UIName = "StepFrostMask10Bool"; string UIWidget = "Checkbox"; > = 1;
bool StepFrostMask10HardStepBool < string UIName = "StepFrostMask10HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepFrostMaskBool < string UIName = "StepFrostMaskBool"; string UIWidget = "Checkbox"; > = 1;
bool StepFrostMaskHardStepBool < string UIName = "StepFrostMaskHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepHighNoiseMask00Bool < string UIName = "StepHighNoiseMask00Bool"; string UIWidget = "Checkbox"; > = 1;
bool StepHighNoiseMask00HardStepBool < string UIName = "StepHighNoiseMask00HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepHighNoiseMask0Bool < string UIName = "StepHighNoiseMask0Bool"; string UIWidget = "Checkbox"; > = 1;
bool StepHighNoiseMask0HardStepBool < string UIName = "StepHighNoiseMask0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepHighNoiseMask1Bool < string UIName = "StepHighNoiseMask1Bool"; string UIWidget = "Checkbox"; > = 1;
bool StepHighNoiseMask1HardStepBool < string UIName = "StepHighNoiseMask1HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepHighNoiseMaskBool < string UIName = "StepHighNoiseMaskBool"; string UIWidget = "Checkbox"; > = 1;
bool StepHighNoiseMaskHardStepBool < string UIName = "StepHighNoiseMaskHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepNoiseTextureBool < string UIName = "StepNoiseTextureBool"; string UIWidget = "Checkbox"; > = 0;
bool StepNoiseTextureHardStepBool < string UIName = "StepNoiseTextureHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepNonSnowWetnessTriggerBool < string UIName = "StepNonSnowWetnessTriggerBool"; string UIWidget = "Checkbox"; > = 0;
bool StepNonSnowWetnessTriggerHardStepBool < string UIName = "StepNonSnowWetnessTriggerHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepSnowMask0Bool < string UIName = "StepSnowMask0Bool"; string UIWidget = "Checkbox"; > = 1;
bool StepSnowMask0HardStepBool < string UIName = "StepSnowMask0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepSnowMaskBool < string UIName = "StepSnowMaskBool"; string UIWidget = "Checkbox"; > = 1;
bool StepSnowMaskFrontBool < string UIName = "StepSnowMaskFrontBool"; string UIWidget = "Checkbox"; > = 1;
bool StepSnowMaskFrontHardStepBool < string UIName = "StepSnowMaskFrontHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepSnowMaskHardStepBool < string UIName = "StepSnowMaskHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepSnowMaskKickupBool < string UIName = "StepSnowMaskKickupBool"; string UIWidget = "Checkbox"; > = 1;
bool StepSnowMaskKickupHardStepBool < string UIName = "StepSnowMaskKickupHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepStreakMaskBool < string UIName = "StepStreakMaskBool"; string UIWidget = "Checkbox"; > = 0;
bool StepStreakMaskHardStepBool < string UIName = "StepStreakMaskHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepStreakSkyDirFadeBool < string UIName = "StepStreakSkyDirFadeBool"; string UIWidget = "Checkbox"; > = 0;
bool StepStreakSkyDirFadeHardStepBool < string UIName = "StepStreakSkyDirFadeHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepWadingLevelBool < string UIName = "StepWadingLevelBool"; string UIWidget = "Checkbox"; > = 0;
bool StepWadingLevelHardStepBool < string UIName = "StepWadingLevelHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepWheelFrostMaskBool < string UIName = "StepWheelFrostMaskBool"; string UIWidget = "Checkbox"; > = 1;
bool StepWheelFrostMaskHardStepBool < string UIName = "StepWheelFrostMaskHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepWheelSideFadeAngleBool < string UIName = "StepWheelSideFadeAngleBool"; string UIWidget = "Checkbox"; > = 1;
bool StepWheelSideFadeAngleHardStepBool < string UIName = "StepWheelSideFadeAngleHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepWheelSnowMaskBool < string UIName = "StepWheelSnowMaskBool"; string UIWidget = "Checkbox"; > = 1;
bool StepWheelSnowMaskHardStepBool < string UIName = "StepWheelSnowMaskHardStepBool"; string UIWidget = "Checkbox"; > = 0;
float4 TextureWetnessEdgeTiling < string UIName = "TextureWetnessEdgeTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.3, 0.32, 0, 0 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int CH2UV1UVSet = 1;
static const float2 SnowDiffuseTextureTiling = float2(0.5, 0.5);
static const bool StepAngleTranslucencyFadeBool = true;
static const bool StepAngleTranslucencyFadeHardStepBool = false;
static const float2 HighNoiseTextureTiling = float2(1, 1);
static const float4 HighNoiseTireBlurApproxColorParam = float4(0.6444797, 0.1559265, 0, 1);
static const bool StepNonSnowWetnessTriggerBool = false;
static const bool StepNonSnowWetnessTriggerHardStepBool = false;
static const float2 TextureWetnessEdgeTiling = float2(0.3, 0.32);
static const bool StepWheelSideFadeAngleBool = true;
static const bool StepWheelSideFadeAngleHardStepBool = false;
static const bool StepWheelFrostMaskBool = true;
static const bool StepWheelFrostMaskHardStepBool = false;
static const bool StepWheelSnowMaskBool = true;
static const bool StepWheelSnowMaskHardStepBool = false;
static const bool StepHighNoiseMask1Bool = true;
static const bool StepHighNoiseMask1HardStepBool = false;
static const float2 LowNoiseTextureTiling = float2(0.5, 0.5);
static const bool StepSnowMask0Bool = true;
static const bool StepSnowMask0HardStepBool = false;
static const bool StepFrostMask0Bool = true;
static const bool StepFrostMask0HardStepBool = false;
static const bool StepSnowMaskBool = true;
static const bool StepSnowMaskHardStepBool = false;
static const bool StepHighNoiseMask0Bool = true;
static const bool StepHighNoiseMask0HardStepBool = false;
static const bool StepFrostMaskBool = true;
static const bool StepFrostMaskHardStepBool = false;
static const bool SmoothStep_frontFadeBool = true;
static const bool SmoothStep_frontFadeHardStepBool = false;
static const bool StepSnowMaskFrontBool = true;
static const bool StepSnowMaskFrontHardStepBool = false;
static const bool StepHighNoiseMask00Bool = true;
static const bool StepHighNoiseMask00HardStepBool = false;
static const bool StepFrostMask10Bool = true;
static const bool StepFrostMask10HardStepBool = false;
static const int CH4UV3UVSet = 3;
static const bool StepSnowMaskKickupBool = true;
static const bool StepSnowMaskKickupHardStepBool = false;
static const bool StepHighNoiseMaskBool = true;
static const bool StepHighNoiseMaskHardStepBool = false;
static const bool StepFineSnowMaskHeightBool = true;
static const bool StepFineSnowMaskHeightHardStepBool = false;
static const bool StepFineSnowMaskKickup0Bool = true;
static const bool StepFineSnowMaskKickup0HardStepBool = false;
static const bool StepFineSnowMaskBool = true;
static const bool StepFineSnowMaskHardStepBool = false;
static const bool StepWadingLevelBool = false;
static const bool StepWadingLevelHardStepBool = false;
static const bool StepNoiseTextureBool = false;
static const bool StepNoiseTextureHardStepBool = false;
static const float4 ColorGrimeColorParam = float4(0.03310477, 0.03189603, 0.02842604, 1);
static const bool StepStreakMaskBool = false;
static const bool StepStreakMaskHardStepBool = false;
static const bool StepStreakSkyDirFadeBool = false;
static const bool StepStreakSkyDirFadeHardStepBool = false;
static const bool step_bottomFade0Bool = false;
static const bool step_bottomFade0HardStepBool = false;
static const bool SmoothStep_testBool = true;
static const bool SmoothStep_testHardStepBool = false;
static const float NormalMapWithIntensityHeightScale = 0.3;
static const float NormalMapWithIntensitySpecPower = 100;
static const float2 NormalMapWithIntensityTiling = float2(0.5, 0.5);
static const bool Step_test0Bool = false;
static const bool Step_test0HardStepBool = false;

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(HighNoiseTextureTexture, 16);
#else
#define HighNoiseTextureTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(LowNoiseTextureTexture, 17);
#else
#define LowNoiseTextureTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapWithIntensityTexture, 18);
#else
#define NormalMapWithIntensityTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(SnowDiffuseTextureTexture, 19);
#else
#define SnowDiffuseTextureTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TextureWetnessEdgeTexture, 20);
#else
#define TextureWetnessEdgeTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_Glossiness 1
#define MATERIAL_INPUT_IS_USED_Glossiness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_INPUT_IS_USED_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"
#include "CarConstantBuffer.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:FunctionInputNode, Name:DiffuseColour
	float4 DiffuseColour = float4(0,0,0,0);
	float4 DiffuseColourPreview = float4(0,0,0,0);
	
	// Type:UVNode, Name:CH2UV1
	float4 CH2UV1 = GetTexCoord1(In).xyxy;
	float4 CH2UV1Tangent = GetWorldTangent1(In);
	float4 CH2UV1UCoord = GetTexCoord1(In).xxxx;
	float4 CH2UV1VCoord = GetTexCoord1(In).yyyy;
	
	// Type:SamplerStatesFunctionInputNode, Name:SamplerStates
	SamplerState SamplerStates = FunctionInputDummySamplerState;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:SnowDiffuseTexture
	float4 SnowDiffuseTexture = SnowDiffuseTextureTexture.Sample(g_samplerLinearWrap, CH2UV1.xy * SnowDiffuseTextureTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 SnowDiffuseTextureMip = GetDebugMipColour(SnowDiffuseTextureTexture, g_samplerLinearWrap, CH2UV1.xy * SnowDiffuseTextureTiling);
	#else
	float4 SnowDiffuseTextureMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 SnowDiffuseTextureAlpha = SnowDiffuseTexture.aaaa;
	float4 SnowDiffuseTextureRed = SnowDiffuseTexture.rrrr;
	float4 SnowDiffuseTextureGreen = SnowDiffuseTexture.gggg;
	float4 SnowDiffuseTextureBlue = SnowDiffuseTexture.bbbb;
	Texture2D SnowDiffuseTextureRef = SnowDiffuseTextureTexture;
	
	// Type:FloatNode, Name:floatLowAngleTranslucency
	float4 floatLowAngleTranslucency = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:minAngleTranslucencyFade
	float4 minAngleTranslucencyFade = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:FloatNode, Name:maxAngleTranslucencyFade
	float4 maxAngleTranslucencyFade = float4(1, 1, 1, 1);
	
	// Type:ViewVectorNode, Name:ViewVector
	float4 ViewVector = float4(GetViewVector(), 0);
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:DotNode, Name:NdotV
	float4 NdotV = dot(ViewVector, WorldNormal);
	
	// Type:StepNode, Name:StepAngleTranslucencyFade
	float4 StepAngleTranslucencyFade = smoothstep( minAngleTranslucencyFade, maxAngleTranslucencyFade, NdotV );
	
	// Type:LerpNode, Name:LerpAngleTranslucencyFade
	float4 LerpAngleTranslucencyFade = lerp(floatLowAngleTranslucency, SnowDiffuseTextureBlue, StepAngleTranslucencyFade.x);
	
	// Type:FloatNode, Name:floatDrivingSnowTranslucencyPower
	float4 floatDrivingSnowTranslucencyPower = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:PowNode, Name:Pow0
	float4 Pow0 = pow( SnowDiffuseTextureBlue, floatDrivingSnowTranslucencyPower );
	
	// Type:FloatNode, Name:Float10
	float4 Float10 = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:TextureNode, Name:HighNoiseTexture
	float4 HighNoiseTexture = HighNoiseTextureTexture.Sample(g_samplerLinearWrap, CH2UV1.xy * HighNoiseTextureTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 HighNoiseTextureMip = GetDebugMipColour(HighNoiseTextureTexture, g_samplerLinearWrap, CH2UV1.xy * HighNoiseTextureTiling);
	#else
	float4 HighNoiseTextureMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 HighNoiseTextureAlpha = HighNoiseTexture.aaaa;
	float4 HighNoiseTextureRed = HighNoiseTexture.rrrr;
	float4 HighNoiseTextureGreen = HighNoiseTexture.gggg;
	float4 HighNoiseTextureBlue = HighNoiseTexture.bbbb;
	Texture2D HighNoiseTextureRef = HighNoiseTextureTexture;
	
	// Type:ColorNode, Name:HighNoiseTireBlurApprox
	float4 HighNoiseTireBlurApprox = HighNoiseTireBlurApproxColorParam;
	float4 HighNoiseTireBlurApproxRed = HighNoiseTireBlurApproxColorParam.rrrr;
	float4 HighNoiseTireBlurApproxGreen = HighNoiseTireBlurApproxColorParam.gggg;
	float4 HighNoiseTireBlurApproxBlue = HighNoiseTireBlurApproxColorParam.bbbb;
	float4 HighNoiseTireBlurApproxAlpha = HighNoiseTireBlurApproxColorParam.aaaa;
	
	// Type:CarTireVelocityNode, Name:CarTireVelocity
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IN_MATERIAL_EDITOR)
	float4 CarTireVelocity = GetTireVelocityAmount();
	#else
	float4 CarTireVelocity = float4(0,0,0,0);
	#endif
	
	// Type:LerpNode, Name:LerpTireVelocity
	float4 LerpTireVelocity = lerp(HighNoiseTexture, HighNoiseTireBlurApprox, CarTireVelocity.x);
	
	// Type:FloatNode, Name:startOfWheelWading
	float4 startOfWheelWading = float4(-0.38, -0.38, -0.38, -0.38);
	
	// Type:FloatNode, Name:WinterIsUsuallyWet
	float4 WinterIsUsuallyWet = float4(1, 1, 1, 1);
	
	// Type:CarTireWadingLevelNode, Name:CarTireWadingLevel
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IN_MATERIAL_EDITOR)
	float4 CarTireWadingLevel = GetTireWadingLevel();
	#else
	float4 CarTireWadingLevel = float4(0,0,0,0);
	#endif
	
	// Type:FloatNode, Name:Float13
	float4 Float13 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:Float130
	float4 Float130 = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:FloatNode, Name:TractorTyreOverride
	float4 TractorTyreOverride = float4(1, 1, 1, 1);
	
	// Type:StepNode, Name:StepNonSnowWetnessTrigger
	float4 StepNonSnowWetnessTrigger = linearstep( Float13, Float130, TractorTyreOverride );
	
	// Type:LerpNode, Name:LerpWheelWetnessControl
	float4 LerpWheelWetnessControl = lerp(WinterIsUsuallyWet, CarTireWadingLevel, StepNonSnowWetnessTrigger.x);
	
	// Type:AddNode, Name:Add5
	float4 Add5 = startOfWheelWading + LerpWheelWetnessControl;
	
	// Type:TextureNode, Name:TextureWetnessEdge
	float4 TextureWetnessEdge = TextureWetnessEdgeTexture.Sample(g_samplerLinearWrap, CH2UV1.xy * TextureWetnessEdgeTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TextureWetnessEdgeMip = GetDebugMipColour(TextureWetnessEdgeTexture, g_samplerLinearWrap, CH2UV1.xy * TextureWetnessEdgeTiling);
	#else
	float4 TextureWetnessEdgeMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TextureWetnessEdgeAlpha = TextureWetnessEdge.aaaa;
	float4 TextureWetnessEdgeRed = TextureWetnessEdge.rrrr;
	float4 TextureWetnessEdgeGreen = TextureWetnessEdge.gggg;
	float4 TextureWetnessEdgeBlue = TextureWetnessEdge.bbbb;
	Texture2D TextureWetnessEdgeRef = TextureWetnessEdgeTexture;
	
	// Type:FloatNode, Name:MaskWheelBlurred0
	float4 MaskWheelBlurred0 = float4(0.2863, 0.2863, 0.2863, 0.2863);
	
	// Type:LerpNode, Name:Lerp00
	float4 Lerp00 = lerp(TextureWetnessEdgeRed, MaskWheelBlurred0, CarTireVelocity.x);
	
	// Type:FloatNode, Name:Float3
	float4 Float3 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:FloatAWheel
	float4 FloatAWheel = float4(1, 1, 1, 1);
	
	// Type:CarWadingWetnessLevelNode, Name:CarWadingWetnessLevel
	float4 CarWadingWetnessLevel = GetRubberAmount().xxxx;
	
	// Type:FloatNode, Name:floatKickupContributionScaler
	float4 floatKickupContributionScaler = float4(-0.25, -0.25, -0.25, -0.25);
	
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:FloatNode, Name:FloatPowKickupMaskRateAdjustment
	float4 FloatPowKickupMaskRateAdjustment = float4(1.7, 1.7, 1.7, 1.7);
	
	// Type:PowNode, Name:PowKickupMaskRateAdjustment
	float4 PowKickupMaskRateAdjustment = pow( VertexColorGreen, FloatPowKickupMaskRateAdjustment );
	
	// Type:MultiplyNode, Name:mulModulatedKickupVC
	float4 mulModulatedKickupVC = floatKickupContributionScaler * PowKickupMaskRateAdjustment;
	
	// Type:FloatNode, Name:HeightToVertColorRatio
	float4 HeightToVertColorRatio = float4(2, 2, 2, 2);
	
	// Type:MultiplyNode, Name:MulToMeters
	float4 MulToMeters = VertexColorRed * HeightToVertColorRatio;
	
	// Type:AddNode, Name:Add4
	float4 Add4 = mulModulatedKickupVC + MulToMeters;
	
	// Type:SaturateNode, Name:Saturate0
	float4 Saturate0 = saturate( Add4 ); 
	
	// Type:FloatNode, Name:FloatNotAWheel
	float4 FloatNotAWheel = float4(0, 0, 0, 0);
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel_noise
	float4 CarPartIsWheel_noise;
	float4 CarPartIsWheel_noiseOut1;
	float4 CarPartIsWheel_noiseOut2;
	float4 CarPartIsWheel_noiseOut3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel_noise = CarWadingWetnessLevel;
	CarPartIsWheel_noiseOut1 = TextureWetnessEdgeRed;
	CarPartIsWheel_noiseOut2 = Saturate0;
	CarPartIsWheel_noiseOut3 = FloatNotAWheel;
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel_noise = Add5;
		CarPartIsWheel_noiseOut1 = Lerp00;
		CarPartIsWheel_noiseOut2 = Float3;
		CarPartIsWheel_noiseOut3 = FloatAWheel;
	}
	else
	{
		CarPartIsWheel_noise = CarWadingWetnessLevel;
		CarPartIsWheel_noiseOut1 = TextureWetnessEdgeRed;
		CarPartIsWheel_noiseOut2 = Saturate0;
		CarPartIsWheel_noiseOut3 = FloatNotAWheel;
	}
	#endif
	
	// Type:LerpNode, Name:LerpEnableTireBlur
	float4 LerpEnableTireBlur = lerp(HighNoiseTexture, LerpTireVelocity, CarPartIsWheel_noiseOut3.x);
	
	// Type:SwizzleNode, Name:SwizzleG
	float4 SwizzleG = LerpEnableTireBlur.yyyw;
	
	// Type:FloatNode, Name:SunriseGlobalScaler
	float4 SunriseGlobalScaler = float4(0.7, 0.7, 0.7, 0.7);
	
	// Type:CarDirtAmountNode, Name:CarDirtAmount
	float4 CarDirtAmount = GetDirtAmount().xxxx;
	
	// Type:MultiplyNode, Name:WARNING_SunriseMaxTopSnowNFrost
	float4 WARNING_SunriseMaxTopSnowNFrost = SunriseGlobalScaler * CarDirtAmount;
	
	// Type:MultiplyNode, Name:wheelStationaryFrostMask
	float4 wheelStationaryFrostMask = SwizzleG * WARNING_SunriseMaxTopSnowNFrost;
	
	// Type:MultiplyNode, Name:mulWheelStationaryFrostMaskScaler
	float4 mulWheelStationaryFrostMaskScaler = Float10 * wheelStationaryFrostMask;
	
	// Type:FloatNode, Name:MinStepWheelFrostMask
	float4 MinStepWheelFrostMask = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:FloatNode, Name:MaxStepWheelFrostMask
	float4 MaxStepWheelFrostMask = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:FloatNode, Name:Float5
	float4 Float5 = float4(0.086, 0.086, 0.086, 0.086);
	
	// Type:FloatNode, Name:Float50
	float4 Float50 = float4(1, 1, 1, 1);
	
	// Type:LerpNode, Name:LerpLinearRemap
	float4 LerpLinearRemap = lerp(Float5, Float50, TractorTyreOverride.x);
	
	// Type:FloatNode, Name:Float4
	float4 Float4 = float4(6.28318, 6.28318, 6.28318, 6.28318);
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = LerpLinearRemap * Float4;
	
	// Type:SinCos, Name:SinCos
	float4 SinCosSinOut = float4( 1, 1, 1, 1); 
	float4 SinCosCosOut = float4( 1, 1, 1, 1); 
	sincos(Multiply0, SinCosSinOut, SinCosCosOut); 
	
	// Type:FloatNode, Name:Float00
	float4 Float00 = float4(0.125, 0.125, 0.125, 0.125);
	
	// Type:MultiplyNode, Name:Multiply00
	float4 Multiply00 = SinCosSinOut * Float00;
	
	// Type:AddNode, Name:InputHardInHardOut
	float4 InputHardInHardOut = Multiply00 + LerpLinearRemap;
	
	// Type:FloatNode, Name:maxTreadDrivingSnow
	float4 maxTreadDrivingSnow = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:minSideDrivingSnow
	float4 minSideDrivingSnow = float4(0.27, 0.27, 0.27, 0.27);
	
	// Type:FloatNode, Name:minStepWheelSideFadeAngle
	float4 minStepWheelSideFadeAngle = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:FloatNode, Name:maxStepWheelSideFadeAngle
	float4 maxStepWheelSideFadeAngle = float4(1, 1, 1, 1);
	
	// Type:AbsNode, Name:Abs00
	float4 Abs00 = abs( VertexColorAlpha ); 
	
	// Type:StepNode, Name:StepWheelSideFadeAngle
	float4 StepWheelSideFadeAngle = smoothstep( minStepWheelSideFadeAngle, maxStepWheelSideFadeAngle, Abs00 );
	
	// Type:LerpNode, Name:LerpTireSideFade
	float4 LerpTireSideFade = lerp(maxTreadDrivingSnow, minSideDrivingSnow, StepWheelSideFadeAngle.x);
	
	// Type:MultiplyNode, Name:mulWheelSideFade
	float4 mulWheelSideFade = InputHardInHardOut * LerpTireSideFade;
	
	// Type:StepNode, Name:StepWheelFrostMask
	float4 StepWheelFrostMask = smoothstep( MinStepWheelFrostMask, MaxStepWheelFrostMask, mulWheelSideFade );
	
	// Type:MultiplyNode, Name:mulWheelFrostFade10
	float4 mulWheelFrostFade10 = SwizzleG * StepWheelFrostMask;
	
	// Type:FloatNode, Name:StationaryWheelSnow
	float4 StationaryWheelSnow = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:MinStepWheelSnowMask
	float4 MinStepWheelSnowMask = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:MaxStepWheelSnowMask
	float4 MaxStepWheelSnowMask = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:StepWheelSnowMask
	float4 StepWheelSnowMask = smoothstep( MinStepWheelSnowMask, MaxStepWheelSnowMask, mulWheelSideFade );
	
	// Type:OneMinusNode, Name:OneMinus010
	float4 OneMinus010 = 1 - StepWheelSnowMask;
	
	// Type:FloatNode, Name:WheelSnowHighNoiseMaskStepRange1
	float4 WheelSnowHighNoiseMaskStepRange1 = float4(0.7, 0.7, 0.7, 0.7);
	
	// Type:AddNode, Name:Add01
	float4 Add01 = WheelSnowHighNoiseMaskStepRange1 + OneMinus010;
	
	// Type:SwizzleNode, Name:SwizzleR
	float4 SwizzleR = LerpEnableTireBlur.xxxw;
	
	// Type:StepNode, Name:StepHighNoiseMask1
	float4 StepHighNoiseMask1 = smoothstep( OneMinus010, Add01, SwizzleR );
	
	// Type:MultiplyNode, Name:xHighNoiseMask1
	float4 xHighNoiseMask1 = StepHighNoiseMask1 * StepWheelSnowMask;
	
	// Type:FloatNode, Name:StepMin
	float4 StepMin = float4(1.25, 1.25, 1.25, 1.25);
	
	// Type:FloatNode, Name:StepMax
	float4 StepMax = float4(2, 2, 2, 2);
	
	// Type:FloatNode, Name:fluctuationNoiseSnow0
	float4 fluctuationNoiseSnow0 = float4(0.25, 0.25, 0.25, 0.25);
	
	// Type:TextureNode, Name:LowNoiseTexture
	float4 LowNoiseTexture = LowNoiseTextureTexture.Sample(g_samplerLinearWrap, CH2UV1.xy * LowNoiseTextureTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 LowNoiseTextureMip = GetDebugMipColour(LowNoiseTextureTexture, g_samplerLinearWrap, CH2UV1.xy * LowNoiseTextureTiling);
	#else
	float4 LowNoiseTextureMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 LowNoiseTextureAlpha = LowNoiseTexture.aaaa;
	float4 LowNoiseTextureRed = LowNoiseTexture.rrrr;
	float4 LowNoiseTextureGreen = LowNoiseTexture.gggg;
	float4 LowNoiseTextureBlue = LowNoiseTexture.bbbb;
	Texture2D LowNoiseTextureRef = LowNoiseTextureTexture;
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = fluctuationNoiseSnow0 * LowNoiseTextureRed;
	
	// Type:OneMinusNode, Name:OneMinus3
	float4 OneMinus3 = 1 - Multiply1;
	
	// Type:FloatNode, Name:addedBonusStationarySnowForDrivingSnowScaler
	float4 addedBonusStationarySnowForDrivingSnowScaler = float4(0.35, 0.35, 0.35, 0.35);
	
	// Type:CarOilAmountNode, Name:CarOilAmount0
	float4 CarOilAmount0 = GetOilAmount().xxxx;
	
	// Type:MultiplyNode, Name:mulMoreStationarySnow
	float4 mulMoreStationarySnow = addedBonusStationarySnowForDrivingSnowScaler * CarOilAmount0;
	
	// Type:MaxNode, Name:MaxBonusForDrivingSnow
	float4 MaxBonusForDrivingSnow = max(WARNING_SunriseMaxTopSnowNFrost, mulMoreStationarySnow);
	
	// Type:CarSpaceNormal, Name:CarSpaceNormal
	float4 CarSpaceNormal = normalize(mul(float4(GetWorldNormal(In).xyz, 0), g_CarInvWorldTransform));
	
	// Type:Vector4Node, Name:SkyDirection
	float4 SkyDirection = float4(0, 1, 0, 1) ;
	
	// Type:DotNode, Name:AmountTowardsSky
	float4 AmountTowardsSky = dot(CarSpaceNormal, SkyDirection);
	
	// Type:AddNode, Name:Add1
	float4 Add1 = MaxBonusForDrivingSnow + AmountTowardsSky;
	
	// Type:MultiplyNode, Name:xLowNoiseSnow
	float4 xLowNoiseSnow = OneMinus3 * Add1;
	
	// Type:StepNode, Name:StepSnowMask0
	float4 StepSnowMask0 = smoothstep( StepMin, StepMax, xLowNoiseSnow );
	
	// Type:OneMinusNode, Name:OneMinusInverseSnowMask
	float4 OneMinusInverseSnowMask = 1 - StepSnowMask0;
	
	// Type:MultiplyNode, Name:MulFrostMaskTex
	float4 MulFrostMaskTex = OneMinusInverseSnowMask * SwizzleG;
	
	// Type:FloatNode, Name:StepMinDelta
	float4 StepMinDelta = float4(-0.35, -0.35, -0.35, -0.35);
	
	// Type:FloatNode, Name:StepMinFX
	float4 StepMinFX = float4(1, 1, 1, 1);
	
	// Type:MultiplyAddNode, Name:MultiplyAddForOver90Degs
	float4 MultiplyAddForOver90Degs = StepMinDelta * MaxBonusForDrivingSnow + StepMinFX;
	
	// Type:FloatNode, Name:StepMax0
	float4 StepMax0 = float4(1.5, 1.5, 1.5, 1.5);
	
	// Type:FloatNode, Name:fluctuationNoise0
	float4 fluctuationNoise0 = float4(0.18, 0.18, 0.18, 0.18);
	
	// Type:MultiplyNode, Name:Multiply10
	float4 Multiply10 = fluctuationNoise0 * LowNoiseTextureRed;
	
	// Type:OneMinusNode, Name:OneMinus30
	float4 OneMinus30 = 1 - Multiply10;
	
	// Type:MultiplyNode, Name:xLowNoiseFrost
	float4 xLowNoiseFrost = OneMinus30 * Add1;
	
	// Type:StepNode, Name:StepFrostMask0
	float4 StepFrostMask0 = smoothstep( MultiplyAddForOver90Degs, StepMax0, xLowNoiseFrost );
	
	// Type:MultiplyNode, Name:mulFrostFade
	float4 mulFrostFade = MulFrostMaskTex * StepFrostMask0;
	
	// Type:FloatNode, Name:NoStationaryFrostOrSnow
	float4 NoStationaryFrostOrSnow = float4(0, 0, 0, 0);
	
	// Type:CarReceivesDirtNode, Name:CarReceivesDirt0
	float4 CarReceivesDirt0;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDirt0 = NoStationaryFrostOrSnow;
	#else
	[branch]
	if (ReceivesDirt())
	{
		CarReceivesDirt0 = mulFrostFade;
	}
	else
	{
		CarReceivesDirt0 = NoStationaryFrostOrSnow;
	}
	#endif
	
	// Type:FloatNode, Name:floatHeightFrostDecay
	float4 floatHeightFrostDecay = float4(0.6, 0.6, 0.6, 0.6);
	
	// Type:FloatNode, Name:MinStepHeightSnowMask
	float4 MinStepHeightSnowMask = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:FloatNode, Name:MaxStepHeightSnowMask
	float4 MaxStepHeightSnowMask = float4(1.25, 1.25, 1.25, 1.25);
	
	// Type:FloatNode, Name:fluctuationNoiseHeightSnow
	float4 fluctuationNoiseHeightSnow = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:MultiplyNode, Name:Multiply12
	float4 Multiply12 = LowNoiseTextureRed * fluctuationNoiseHeightSnow;
	
	// Type:OneMinusNode, Name:OneMinus31
	float4 OneMinus31 = 1 - Multiply12;
	
	// Type:FloatNode, Name:maxSmearMaskMultipler
	float4 maxSmearMaskMultipler = float4(0.07, 0.07, 0.07, 0.07);
	
	// Type:MultiplyNode, Name:Multiply6
	float4 Multiply6 = TextureWetnessEdgeGreen * maxSmearMaskMultipler;
	
	// Type:OneMinusNode, Name:OneMinus6
	float4 OneMinus6 = 1 - Multiply6;
	
	// Type:OneMinusNode, Name:OneMinus5
	float4 OneMinus5 = 1 - MulToMeters;
	
	// Type:MultiplyNode, Name:mulSmearMask
	float4 mulSmearMask = OneMinus6 * OneMinus5;
	
	// Type:FloatNode, Name:FloatPowHeightSnowChangeRate
	float4 FloatPowHeightSnowChangeRate = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:PowNode, Name:PowHeightSnowChangeRate
	float4 PowHeightSnowChangeRate = pow( CarOilAmount0, FloatPowHeightSnowChangeRate );
	
	// Type:MultiplyNode, Name:MulHeightMask
	float4 MulHeightMask = mulSmearMask * PowHeightSnowChangeRate;
	
	// Type:MultiplyNode, Name:xLowNoiseSnow0
	float4 xLowNoiseSnow0 = OneMinus31 * MulHeightMask;
	
	// Type:StepNode, Name:StepSnowMask
	float4 StepSnowMask = smoothstep( MinStepHeightSnowMask, MaxStepHeightSnowMask, xLowNoiseSnow0 );
	
	// Type:OneMinusNode, Name:OneMinus0
	float4 OneMinus0 = 1 - StepSnowMask;
	
	// Type:FloatNode, Name:HighNoiseMaskStepRange0
	float4 HighNoiseMaskStepRange0 = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:AddNode, Name:Add00
	float4 Add00 = HighNoiseMaskStepRange0 + OneMinus0;
	
	// Type:StepNode, Name:StepHighNoiseMask0
	float4 StepHighNoiseMask0 = smoothstep( OneMinus0, Add00, SwizzleR );
	
	// Type:MultiplyNode, Name:xHighNoiseMask0
	float4 xHighNoiseMask0 = StepHighNoiseMask0 * StepSnowMask;
	
	// Type:OneMinusNode, Name:OneMinus20
	float4 OneMinus20 = 1 - xHighNoiseMask0;
	
	// Type:FloatNode, Name:modulationRate0
	float4 modulationRate0 = float4(10, 10, 10, 10);
	
	// Type:PowNode, Name:PowSharpen0
	float4 PowSharpen0 = pow( OneMinus20, modulationRate0 );
	
	// Type:OneMinusNode, Name:OneMinus030
	float4 OneMinus030 = 1 - PowSharpen0;
	
	// Type:OneMinusNode, Name:OneMinus01
	float4 OneMinus01 = 1 - OneMinus030;
	
	// Type:MultiplyNode, Name:Multiply111
	float4 Multiply111 = OneMinus01 * SwizzleG;
	
	// Type:FloatNode, Name:StepMinDeltaFrostMask
	float4 StepMinDeltaFrostMask = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:FloatNode, Name:StepMinFXFrostMask
	float4 StepMinFXFrostMask = float4(0.28, 0.28, 0.28, 0.28);
	
	// Type:MultiplyAddNode, Name:MulAddFrostMask
	float4 MulAddFrostMask = StepMinDeltaFrostMask * CarOilAmount0 + StepMinFXFrostMask;
	
	// Type:FloatNode, Name:MaxStepDeltaFrostMask
	float4 MaxStepDeltaFrostMask = float4(0.79, 0.79, 0.79, 0.79);
	
	// Type:StepNode, Name:StepFrostMask
	float4 StepFrostMask = smoothstep( MulAddFrostMask, MaxStepDeltaFrostMask, xLowNoiseSnow0 );
	
	// Type:MultiplyNode, Name:mulFrostFade1
	float4 mulFrostFade1 = Multiply111 * StepFrostMask;
	
	// Type:MultiplyNode, Name:mulHeightFrostDecay
	float4 mulHeightFrostDecay = floatHeightFrostDecay * mulFrostFade1;
	
	// Type:FloatNode, Name:StepMin110
	float4 StepMin110 = float4(-0.15, -0.15, -0.15, -0.15);
	
	// Type:FloatNode, Name:StepMax210
	float4 StepMax210 = float4(1.5, 1.5, 1.5, 1.5);
	
	// Type:FloatNode, Name:fluctuationNoiseSnow1
	float4 fluctuationNoiseSnow1 = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:MultiplyNode, Name:Multiply120
	float4 Multiply120 = LowNoiseTextureRed * fluctuationNoiseSnow1;
	
	// Type:OneMinusNode, Name:OneMinus310
	float4 OneMinus310 = 1 - Multiply120;
	
	// Type:FloatNode, Name:Float8
	float4 Float8 = float4(0.28, 0.28, 0.28, 0.28);
	
	// Type:FloatNode, Name:Float20
	float4 Float20 = float4(1, 1, 1, 1);
	
	// Type:Vector4Node, Name:FrontDirection
	float4 FrontDirection = float4(0, 0, 1, 1) ;
	
	// Type:DotNode, Name:DotFrontNormal
	float4 DotFrontNormal = dot(CarSpaceNormal, FrontDirection);
	
	// Type:StepNode, Name:SmoothStep_frontFade
	float4 SmoothStep_frontFade = smoothstep( Float8, Float20, DotFrontNormal );
	
	// Type:MultiplyNode, Name:mulFrontMaskAmount
	float4 mulFrontMaskAmount = SmoothStep_frontFade * CarOilAmount0;
	
	// Type:MultiplyNode, Name:xLowNoiseSnow00
	float4 xLowNoiseSnow00 = OneMinus310 * mulFrontMaskAmount;
	
	// Type:StepNode, Name:StepSnowMaskFront
	float4 StepSnowMaskFront = smoothstep( StepMin110, StepMax210, xLowNoiseSnow00 );
	
	// Type:OneMinusNode, Name:OneMinus00
	float4 OneMinus00 = 1 - StepSnowMaskFront;
	
	// Type:FloatNode, Name:HighNoiseMaskStepRange00
	float4 HighNoiseMaskStepRange00 = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:AddNode, Name:Add000
	float4 Add000 = HighNoiseMaskStepRange00 + OneMinus00;
	
	// Type:StepNode, Name:StepHighNoiseMask00
	float4 StepHighNoiseMask00 = smoothstep( OneMinus00, Add000, SwizzleR );
	
	// Type:MultiplyNode, Name:xHighNoiseMask00
	float4 xHighNoiseMask00 = StepHighNoiseMask00 * StepSnowMaskFront;
	
	// Type:OneMinusNode, Name:OneMinus0110
	float4 OneMinus0110 = 1 - xHighNoiseMask00;
	
	// Type:MultiplyNode, Name:Multiply11110
	float4 Multiply11110 = OneMinus0110 * SwizzleG;
	
	// Type:FloatNode, Name:StepMin0110
	float4 StepMin0110 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:StepMax0110
	float4 StepMax0110 = float4(0.35, 0.35, 0.35, 0.35);
	
	// Type:StepNode, Name:StepFrostMask10
	float4 StepFrostMask10 = smoothstep( StepMin0110, StepMax0110, xLowNoiseSnow00 );
	
	// Type:MultiplyNode, Name:mulFrostFadeFront
	float4 mulFrostFadeFront = Multiply11110 * StepFrostMask10;
	
	// Type:MaxNode, Name:MaxFrostMask
	float4 MaxFrostMask = max(mulHeightFrostDecay, mulFrostFadeFront);
	
	// Type:UVNode, Name:CH4UV3
	float4 CH4UV3 = GetTexCoord3(In).xyxy;
	float4 CH4UV3Tangent = GetWorldTangent3(In);
	float4 CH4UV3UCoord = GetTexCoord3(In).xxxx;
	float4 CH4UV3VCoord = GetTexCoord3(In).yyyy;
	
	// Type:FloatNode, Name:NoDrivingFrostOrSnow
	float4 NoDrivingFrostOrSnow = float4(0, 0, 0, 0);
	
	// Type:MultiplyNode, Name:mulDummyUVforCompatibility
	float4 mulDummyUVforCompatibility = CH4UV3UCoord * NoDrivingFrostOrSnow;
	
	// Type:CarReceivesOilNode, Name:CarReceivesOil0
	float4 CarReceivesOil0;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesOil0 = mulDummyUVforCompatibility;
	#else
	[branch]
	if (ReceivesOil())
	{
		CarReceivesOil0 = MaxFrostMask;
	}
	else
	{
		CarReceivesOil0 = mulDummyUVforCompatibility;
	}
	#endif
	
	// Type:CarReceivesDirtNode, Name:CarReceivesDirt00
	float4 CarReceivesDirt00;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDirt00 = NoStationaryFrostOrSnow;
	#else
	[branch]
	if (ReceivesDirt())
	{
		CarReceivesDirt00 = StepSnowMask0;
	}
	else
	{
		CarReceivesDirt00 = NoStationaryFrostOrSnow;
	}
	#endif
	
	// Type:FloatNode, Name:StepMin11_sideKickupHighNoise
	float4 StepMin11_sideKickupHighNoise = float4(-0.3, -0.3, -0.3, -0.3);
	
	// Type:FloatNode, Name:StepMax21_sideKickupHighNoise
	float4 StepMax21_sideKickupHighNoise = float4(1.55, 1.55, 1.55, 1.55);
	
	// Type:MultiplyNode, Name:mulSmearMask0
	float4 mulSmearMask0 = OneMinus6 * PowKickupMaskRateAdjustment;
	
	// Type:MultiplyNode, Name:mulKickupAmount0
	float4 mulKickupAmount0 = mulSmearMask0 * CarOilAmount0;
	
	// Type:StepNode, Name:StepSnowMaskKickup
	float4 StepSnowMaskKickup = smoothstep( StepMin11_sideKickupHighNoise, StepMax21_sideKickupHighNoise, mulKickupAmount0 );
	
	// Type:OneMinusNode, Name:OneMinus
	float4 OneMinus = 1 - StepSnowMaskKickup;
	
	// Type:FloatNode, Name:HighNoiseMaskStepRange_sideKickup
	float4 HighNoiseMaskStepRange_sideKickup = float4(1, 1, 1, 1);
	
	// Type:AddNode, Name:Add0
	float4 Add0 = HighNoiseMaskStepRange_sideKickup + OneMinus;
	
	// Type:StepNode, Name:StepHighNoiseMask
	float4 StepHighNoiseMask = smoothstep( OneMinus, Add0, SwizzleR );
	
	// Type:MultiplyNode, Name:xHighNoiseMask
	float4 xHighNoiseMask = StepHighNoiseMask * StepSnowMaskKickup;
	
	// Type:OneMinusNode, Name:OneMinus2
	float4 OneMinus2 = 1 - xHighNoiseMask;
	
	// Type:FloatNode, Name:modulationRate
	float4 modulationRate = float4(10, 10, 10, 10);
	
	// Type:PowNode, Name:PowSharpen
	float4 PowSharpen = pow( OneMinus2, modulationRate );
	
	// Type:OneMinusNode, Name:OneMinus03
	float4 OneMinus03 = 1 - PowSharpen;
	
	// Type:FloatNode, Name:StepMin11_height
	float4 StepMin11_height = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:FloatNode, Name:StepMax21_height
	float4 StepMax21_height = float4(0.9, 0.9, 0.9, 0.9);
	
	// Type:StepNode, Name:StepFineSnowMaskHeight
	float4 StepFineSnowMaskHeight = smoothstep( StepMin11_height, StepMax21_height, xLowNoiseSnow0 );
	
	// Type:FloatNode, Name:StepMin11_sideKickup0
	float4 StepMin11_sideKickup0 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:StepMax21_sideKickup0
	float4 StepMax21_sideKickup0 = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:StepFineSnowMaskKickup0
	float4 StepFineSnowMaskKickup0 = smoothstep( StepMin11_sideKickup0, StepMax21_sideKickup0, mulKickupAmount0 );
	
	// Type:MaxNode, Name:Max
	float4 Max = max(StepFineSnowMaskHeight, StepFineSnowMaskKickup0);
	
	// Type:OneMinusNode, Name:OneMinus4
	float4 OneMinus4 = 1 - Max;
	
	// Type:FloatNode, Name:FineSnowMaskStepRange_sideKickup0
	float4 FineSnowMaskStepRange_sideKickup0 = float4(1, 1, 1, 1);
	
	// Type:AddNode, Name:Add02
	float4 Add02 = FineSnowMaskStepRange_sideKickup0 + OneMinus4;
	
	// Type:StepNode, Name:StepFineSnowMask
	float4 StepFineSnowMask = smoothstep( OneMinus4, Add02, HighNoiseTextureBlue );
	
	// Type:MultiplyNode, Name:xHighNoiseMask2
	float4 xHighNoiseMask2 = StepFineSnowMask * Max;
	
	// Type:OneMinusNode, Name:OneMinus21
	float4 OneMinus21 = 1 - xHighNoiseMask2;
	
	// Type:FloatNode, Name:modulationRate1
	float4 modulationRate1 = float4(10, 10, 10, 10);
	
	// Type:PowNode, Name:PowSharpen1
	float4 PowSharpen1 = pow( OneMinus21, modulationRate1 );
	
	// Type:OneMinusNode, Name:OneMinus031
	float4 OneMinus031 = 1 - PowSharpen1;
	
	// Type:FloatNode, Name:FloatTunedLevel
	float4 FloatTunedLevel = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:MultiplyNode, Name:mulFineSnowMaxLevel
	float4 mulFineSnowMaxLevel = OneMinus031 * FloatTunedLevel;
	
	// Type:MaxNode, Name:MaxSnowHighAndFine
	float4 MaxSnowHighAndFine = max(OneMinus03, mulFineSnowMaxLevel);
	
	// Type:MaxNode, Name:MaxSnowMaskFront
	float4 MaxSnowMaskFront = max(MaxSnowHighAndFine, xHighNoiseMask00);
	
	// Type:MaxNode, Name:MaxSnowMask0
	float4 MaxSnowMask0 = max(OneMinus030, MaxSnowMaskFront);
	
	// Type:CarReceivesOilNode, Name:CarReceivesOil00
	float4 CarReceivesOil00;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesOil00 = mulDummyUVforCompatibility;
	#else
	[branch]
	if (ReceivesOil())
	{
		CarReceivesOil00 = MaxSnowMask0;
	}
	else
	{
		CarReceivesOil00 = mulDummyUVforCompatibility;
	}
	#endif
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel01
	float4 CarPartIsWheel01;
	float4 CarPartIsWheel01Out1;
	float4 CarPartIsWheel01Out2;
	float4 CarPartIsWheel01Out3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel01 = CarReceivesDirt0;
	CarPartIsWheel01Out1 = CarReceivesOil0;
	CarPartIsWheel01Out2 = CarReceivesDirt00;
	CarPartIsWheel01Out3 = CarReceivesOil00;
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel01 = mulWheelStationaryFrostMaskScaler;
		CarPartIsWheel01Out1 = mulWheelFrostFade10;
		CarPartIsWheel01Out2 = StationaryWheelSnow;
		CarPartIsWheel01Out3 = xHighNoiseMask1;
	}
	else
	{
		CarPartIsWheel01 = CarReceivesDirt0;
		CarPartIsWheel01Out1 = CarReceivesOil0;
		CarPartIsWheel01Out2 = CarReceivesDirt00;
		CarPartIsWheel01Out3 = CarReceivesOil00;
	}
	#endif
	
	// Type:LerpNode, Name:LerpDrivingSnowSpecificTranslucency
	float4 LerpDrivingSnowSpecificTranslucency = lerp(LerpAngleTranslucencyFade, Pow0, CarPartIsWheel01Out3.x);
	
	// Type:AddNode, Name:AddFrostMasksDrivingAndStationary
	float4 AddFrostMasksDrivingAndStationary = CarPartIsWheel01 + CarPartIsWheel01Out1;
	
	// Type:FloatNode, Name:Float2
	float4 Float2 = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:FloatWadingWaterDiffScaler
	float4 FloatWadingWaterDiffScaler = float4(0.12, 0.12, 0.12, 0.12);
	
	// Type:FloatNode, Name:FloatWadingWaterDiffScalerWheel
	float4 FloatWadingWaterDiffScalerWheel = float4(0.06, 0.06, 0.06, 0.06);
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(FloatWadingWaterDiffScaler, FloatWadingWaterDiffScalerWheel, CarPartIsWheel_noiseOut3.x);
	
	// Type:FloatNode, Name:floatNoiseTexStepRange0
	float4 floatNoiseTexStepRange0 = float4(-0.1, -0.1, -0.1, -0.1);
	
	// Type:FloatNode, Name:WadingSplashTransitionRangeInMeters
	float4 WadingSplashTransitionRangeInMeters = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:AddNode, Name:Add2
	float4 Add2 = WadingSplashTransitionRangeInMeters + CarPartIsWheel_noise;
	
	// Type:StepNode, Name:StepWadingLevel
	float4 StepWadingLevel = linearstep( CarPartIsWheel_noise, Add2, CarPartIsWheel_noiseOut2 );
	
	// Type:AddNode, Name:Add200
	float4 Add200 = floatNoiseTexStepRange0 + StepWadingLevel;
	
	// Type:StepNode, Name:StepNoiseTexture
	float4 StepNoiseTexture = linearstep( Add200, StepWadingLevel, CarPartIsWheel_noiseOut1 );
	
	// Type:LerpNode, Name:LerpWadingWaterDiffScaler
	float4 LerpWadingWaterDiffScaler = lerp(Float2, Lerp0, StepNoiseTexture.x);
	
	// Type:MultiplyNode, Name:mulWadingWaterDiffMaskFade00
	float4 mulWadingWaterDiffMaskFade00 = AddFrostMasksDrivingAndStationary * LerpWadingWaterDiffScaler;
	
	// Type:AddNode, Name:AddSnowMasksDrivingAndStationary
	float4 AddSnowMasksDrivingAndStationary = CarPartIsWheel01Out2 + CarPartIsWheel01Out3;
	
	// Type:MultiplyNode, Name:mulWadingWaterDiffMaskFade0
	float4 mulWadingWaterDiffMaskFade0 = LerpWadingWaterDiffScaler * AddSnowMasksDrivingAndStationary;
	
	// Type:AddNode, Name:Add_SnowFrostThickness
	float4 Add_SnowFrostThickness = mulWadingWaterDiffMaskFade00 + mulWadingWaterDiffMaskFade0;
	
	// Type:SaturateNode, Name:Saturate
	float4 Saturate = saturate( Add_SnowFrostThickness ); 
	
	// Type:MultiplyNode, Name:mulTranslucencyMaskSnowPlusFrost
	float4 mulTranslucencyMaskSnowPlusFrost = LerpDrivingSnowSpecificTranslucency * Saturate;
	
	// Type:LerpNode, Name:LerpSnowFrostDiffuse
	float4 LerpSnowFrostDiffuse = lerp(DiffuseColour, SnowDiffuseTexture, mulTranslucencyMaskSnowPlusFrost.x);
	
	// Type:ColorNode, Name:ColorGrime
	float4 ColorGrime = ColorGrimeColorParam;
	float4 ColorGrimeRed = ColorGrimeColorParam.rrrr;
	float4 ColorGrimeGreen = ColorGrimeColorParam.gggg;
	float4 ColorGrimeBlue = ColorGrimeColorParam.bbbb;
	float4 ColorGrimeAlpha = ColorGrimeColorParam.aaaa;
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:MultiplyNode, Name:mulWetDarken
	float4 mulWetDarken = ColorGrime * Float1;
	
	// Type:CarWetAmountNode, Name:GlobalCarWetness
	float4 GlobalCarWetness = GetWetMudAmount().xxxx;
	
	// Type:MaxNode, Name:MaxWetMask
	float4 MaxWetMask = max(GlobalCarWetness, StepNoiseTexture);
	
	// Type:LerpNode, Name:LerpWetGrime
	float4 LerpWetGrime = lerp(ColorGrime, mulWetDarken, MaxWetMask.x);
	
	// Type:Vector4Node, Name:Vector4
	float4 Vector4 = float4(0.2126, 0.7152, 0.0722, 1) ;
	
	// Type:FunctionInputNode, Name:MetalColour
	float4 MetalColour = float4(0,0,0,0);
	float4 MetalColourPreview = float4(0,0,0,0);
	
	// Type:DotNode, Name:DotMetalColourRelLuminance
	float4 DotMetalColourRelLuminance = dot(Vector4, MetalColour);
	
	// Type:FloatNode, Name:metalContributionScaler
	float4 metalContributionScaler = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:MultiplyNode, Name:mulMixedWithMetalLight0
	float4 mulMixedWithMetalLight0 = DotMetalColourRelLuminance * metalContributionScaler;
	
	// Type:MultiplyNode, Name:mulMixedWithMetalLight
	float4 mulMixedWithMetalLight = mulMixedWithMetalLight0 * LerpWetGrime;
	
	// Type:AddNode, Name:Add
	float4 Add = mulMixedWithMetalLight + LerpWetGrime;
	
	// Type:FunctionInputNode, Name:Metalness
	float4 Metalness = float4(0,0,0,0);
	float4 MetalnessPreview = float4(0,0,0,0);
	
	// Type:LerpNode, Name:LerpDiffWithMixedMetal
	float4 LerpDiffWithMixedMetal = lerp(LerpWetGrime, Add, Metalness.x);
	
	// Type:FloatNode, Name:stepmin_thickness
	float4 stepmin_thickness = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:stepmax_thickness
	float4 stepmax_thickness = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:CarGrimeAmountNode, Name:CarGrimeAmount
	float4 CarGrimeAmount = GetCarGrimeAmount().xxxx;
	
	// Type:FloatNode, Name:Float0
	float4 Float0 = float4(0, 0, 0, 0);
	
	// Type:CarReceivesDirtNode, Name:CarReceivesDirt01
	float4 CarReceivesDirt01;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDirt01 = Float0;
	#else
	[branch]
	if (ReceivesDirt())
	{
		CarReceivesDirt01 = CarGrimeAmount;
	}
	else
	{
		CarReceivesDirt01 = Float0;
	}
	#endif
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:PowNode, Name:PowControlRate
	float4 PowControlRate = pow( CarReceivesDirt01, Float );
	
	// Type:FloatNode, Name:fluctuationNoise00
	float4 fluctuationNoise00 = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:MultiplyNode, Name:Multiply100
	float4 Multiply100 = fluctuationNoise00 * LowNoiseTextureRed;
	
	// Type:OneMinusNode, Name:OneMinus300
	float4 OneMinus300 = 1 - Multiply100;
	
	// Type:MultiplyNode, Name:xLowNoise0
	float4 xLowNoise0 = PowControlRate * OneMinus300;
	
	// Type:MultiplyNode, Name:xHighFrequencyDustTexture
	float4 xHighFrequencyDustTexture = xLowNoise0 * SnowDiffuseTextureBlue;
	
	// Type:FloatNode, Name:FloatOne
	float4 FloatOne = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:stepStreakMin
	float4 stepStreakMin = float4(-5, -5, -5, -5);
	
	// Type:FloatNode, Name:stepStreakMax
	float4 stepStreakMax = float4(1, 1, 1, 1);
	
	// Type:StepNode, Name:StepStreakMask
	float4 StepStreakMask = linearstep( stepStreakMin, stepStreakMax, HighNoiseTextureAlpha );
	
	// Type:FloatNode, Name:Float9
	float4 Float9 = float4(0.766, 0.766, 0.766, 0.766);
	
	// Type:FloatNode, Name:Float7
	float4 Float7 = float4(0.6428, 0.6428, 0.6428, 0.6428);
	
	// Type:StepNode, Name:StepStreakSkyDirFade
	float4 StepStreakSkyDirFade = linearstep( Float9, Float7, AmountTowardsSky );
	
	// Type:LerpNode, Name:Lerp1
	float4 Lerp1 = lerp(FloatOne, StepStreakMask, StepStreakSkyDirFade.x);
	
	// Type:MultiplyNode, Name:mulStreakPattern
	float4 mulStreakPattern = xHighFrequencyDustTexture * Lerp1;
	
	// Type:FloatNode, Name:Float6
	float4 Float6 = float4(0.85, 0.85, 0.85, 0.85);
	
	// Type:FloatNode, Name:Float51
	float4 Float51 = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:OneMinusNode, Name:OneMinus10
	float4 OneMinus10 = 1 - NdotV;
	
	// Type:MultiplyNode, Name:Multiply4
	float4 Multiply4 = Float51 * OneMinus10;
	
	// Type:AddNode, Name:AddViewVectorVariation
	float4 AddViewVectorVariation = Float6 + Multiply4;
	
	// Type:MultiplyNode, Name:xViewFade
	float4 xViewFade = mulStreakPattern * AddViewVectorVariation;
	
	// Type:FloatNode, Name:maxDustThicknessPercentageBottom
	float4 maxDustThicknessPercentageBottom = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:FloatNode, Name:maxDustThicknessPercentage1
	float4 maxDustThicknessPercentage1 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:maxDustKickupThickness
	float4 maxDustKickupThickness = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:LerpNode, Name:LerpKickupDust
	float4 LerpKickupDust = lerp(maxDustThicknessPercentage1, maxDustKickupThickness, VertexColorGreen.x);
	
	// Type:FloatNode, Name:FloatLowerVertHeightInMeters
	float4 FloatLowerVertHeightInMeters = float4(-0.2, -0.2, -0.2, -0.2);
	
	// Type:FloatNode, Name:FloatHigherVertHeightInMeters
	float4 FloatHigherVertHeightInMeters = float4(0.95, 0.95, 0.95, 0.95);
	
	// Type:StepNode, Name:step_bottomFade0
	float4 step_bottomFade0 = linearstep( FloatLowerVertHeightInMeters, FloatHigherVertHeightInMeters, MulToMeters );
	
	// Type:LerpNode, Name:LerpBottomFadeMultiplier0
	float4 LerpBottomFadeMultiplier0 = lerp(maxDustThicknessPercentageBottom, LerpKickupDust, step_bottomFade0.x);
	
	// Type:FloatNode, Name:maxSmearMaskMultipler0
	float4 maxSmearMaskMultipler0 = float4(0.08, 0.08, 0.08, 0.08);
	
	// Type:MultiplyNode, Name:Multiply60
	float4 Multiply60 = TextureWetnessEdgeGreen * maxSmearMaskMultipler0;
	
	// Type:OneMinusNode, Name:OneMinus7
	float4 OneMinus7 = 1 - Multiply60;
	
	// Type:MultiplyNode, Name:mulDustSmearMask
	float4 mulDustSmearMask = LerpBottomFadeMultiplier0 * OneMinus7;
	
	// Type:MultiplyNode, Name:xDustCombinedNonWheel
	float4 xDustCombinedNonWheel = xViewFade * mulDustSmearMask;
	
	// Type:StepNode, Name:SmoothStep_test
	float4 SmoothStep_test = smoothstep( stepmin_thickness, stepmax_thickness, xDustCombinedNonWheel );
	
	// Type:LerpNode, Name:LerpGrimeDiffuse
	float4 LerpGrimeDiffuse = lerp(LerpSnowFrostDiffuse, LerpDiffWithMixedMetal, SmoothStep_test.x);
	
	// Type:NormalMapWithIntensityNode, Name:NormalMapWithIntensity
	float4 textureLookup_NormalMapWithIntensity = NormalMapWithIntensityTexture.Sample(g_samplerLinearWrap, CH2UV1.xy * NormalMapWithIntensityTiling);
	#ifdef _MAX_
	textureLookup_NormalMapWithIntensity.xyz = pow(textureLookup_NormalMapWithIntensity.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMapWithIntensity = (2.0f * textureLookup_NormalMapWithIntensity.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapWithIntensityGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMapWithIntensity, NormalMapWithIntensitySpecPower);
	float4 NormalMapWithIntensityAlpha = textureLookup_NormalMapWithIntensity.aaaa;
	float4 NormalMapWithIntensityRed = textureLookup_NormalMapWithIntensity.rrrr;
	float4 NormalMapWithIntensityGreen = textureLookup_NormalMapWithIntensity.gggg;
	float4 NormalMapWithIntensityBlue = textureLookup_NormalMapWithIntensity.bbbb;
	tangentSpaceNormal_NormalMapWithIntensity.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMapWithIntensity.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMapWithIntensity.x*tangentSpaceNormal_NormalMapWithIntensity.x - tangentSpaceNormal_NormalMapWithIntensity.y*tangentSpaceNormal_NormalMapWithIntensity.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMapWithIntensity.xy *= g_GlobalNormalScale * NormalMapWithIntensityHeightScale.x;
	#else
	tangentSpaceNormal_NormalMapWithIntensity.xy *= NormalMapWithIntensityHeightScale.x;
	#endif
	float4 NormalMapWithIntensity = float4(normalize(mul(tangentSpaceNormal_NormalMapWithIntensity, float3x3(CH2UV1Tangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, CH2UV1Tangent.xyz) * CH2UV1Tangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMapWithIntensity = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:F0ValuesNode, Name:F0Values_snowFrost
	float4 F0Values_snowFrost = float4(0.04, 0.04, 0.04, 1) ;
	
	// Type:F0ValuesNode, Name:F0Values_grime
	float4 F0Values_grime = float4(0.01790891, 0.01790891, 0.01790891, 1) ;
	
	// Type:FloatNode, Name:stepmin_target
	float4 stepmin_target = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:stepmax_target
	float4 stepmax_target = float4(0.6, 0.6, 0.6, 0.6);
	
	// Type:StepNode, Name:Step_test0
	float4 Step_test0 = linearstep( stepmin_target, stepmax_target, xDustCombinedNonWheel );
	
	// Type:FloatNode, Name:FloatNoINF0
	float4 FloatNoINF0 = float4(0.001, 0.001, 0.001, 0.001);
	
	// Type:AddNode, Name:Add3
	float4 Add3 = FloatNoINF0 + Saturate;
	
	// Type:DivideNode, Name:DivideBetweenGrimeMaskAndSnowFrostMask
	float4 DivideBetweenGrimeMaskAndSnowFrostMask = Step_test0 / Add3;
	
	// Type:SaturateNode, Name:Saturate1
	float4 Saturate1 = saturate( DivideBetweenGrimeMaskAndSnowFrostMask ); 
	
	// Type:LerpNode, Name:LerpGrimeF0
	float4 LerpGrimeF0 = lerp(F0Values_snowFrost, F0Values_grime, Saturate1.x);
	
	// Type:FloatNode, Name:GlossMatte
	float4 GlossMatte = float4(0.05, 0.05, 0.05, 0.05);
	
	// Type:LerpNode, Name:LerpGrimeGloss
	float4 LerpGrimeGloss = lerp(SnowDiffuseTextureAlpha, GlossMatte, Saturate1.x);
	
	// Type:AOMapValueNode, Name:AOMapValue0
	float4 AOMapValue0 = g_AOMapValue.xxxx;
	// Type:OneMinusNode, Name:OneMinus8
	float4 OneMinus8 = 1 - AOMapValue0;
	
	// Type:FloatNode, Name:floatSnowAOPower
	float4 floatSnowAOPower = float4(2, 2, 2, 2);
	
	// Type:PowNode, Name:Pow00
	float4 Pow00 = pow( OneMinus8, floatSnowAOPower );
	
	// Type:OneMinusNode, Name:OneMinus02
	float4 OneMinus02 = 1 - Pow00;
	
	// Type:LerpNode, Name:SurfaceFX_AOSnow
	float4 SurfaceFX_AOSnow = lerp(AOMapValue0, OneMinus02, mulTranslucencyMaskSnowPlusFrost.x);
	
	output.DiffuseColor = LerpGrimeDiffuse;
	output.Normal = NormalMapWithIntensity;
	output.F0 = LerpGrimeF0;
	output.Glossiness = LerpGrimeGloss;
	output.CarAOOverride = SurfaceFX_AOSnow;
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#include "LightScenarios\CarDebugLightingLightScenario.hlsl"