#include "LightScenarios\Inc\DebugLightingLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
int CarLODLOD < string UIName = "CarLODLOD"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
int CarLODoptimisation1LOD < string UIName = "CarLODoptimisation1LOD"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
int CarLODOptimisationLOD < string UIName = "CarLODOptimisationLOD"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
int CH2UV1UVSet < string UIName = "CH2UV1UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int CH4UV3UVSet < string UIName = "CH4UV3UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
float4 ColorDryDustColorParam < string UIName = "ColorDryDustColorParam"; string UIWidget = "Color"; > = float4( 0.3762622, 0.2663556, 0.1912017, 1 );
float4 ColorDryMudColorParam < string UIName = "ColorDryMudColorParam"; string UIWidget = "Color"; > = float4( 0.2961383, 0.2122308, 0.1441285, 1 );
float4 ColorWetDustColorParam < string UIName = "ColorWetDustColorParam"; string UIWidget = "Color"; > = float4( 0.1470273, 0.1070231, 0.07818743, 1 );
float4 ColorWetMudColorParam < string UIName = "ColorWetMudColorParam"; string UIWidget = "Color"; > = float4( 0.1559265, 0.1022417, 0.06480327, 1 );
float DynamicBranchRefValue < string UIName = "DynamicBranchRefValue"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float DynamicOptimisationForNonMuddyPixelsRefValue < string UIName = "DynamicOptimisationForNonMuddyPixelsRefValue"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.05 ;
float4 MudTileDirectionalLeftTiling < string UIName = "MudTileDirectionalLeftTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 5, 5, 0, 0 );
float4 MudTileNonDirectionalTiling < string UIName = "MudTileNonDirectionalTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float NormalMapWithIntensityHeightScale < string UIName = "NormalMapWithIntensityHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.25 ;
float NormalMapWithIntensitySpecPower < string UIName = "NormalMapWithIntensitySpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalMapWithIntensityTiling < string UIName = "NormalMapWithIntensityTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
bool SmoothStep_bottomFade0Bool < string UIName = "SmoothStep_bottomFade0Bool"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_bottomFade0HardStepBool < string UIName = "SmoothStep_bottomFade0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool SmoothStep_frontFadeBool < string UIName = "SmoothStep_frontFadeBool"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_frontFadeHardStepBool < string UIName = "SmoothStep_frontFadeHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool SmoothStep_heightFadeBool < string UIName = "SmoothStep_heightFadeBool"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_heightFadeHardStepBool < string UIName = "SmoothStep_heightFadeHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool SmoothStep_kickupDustBool < string UIName = "SmoothStep_kickupDustBool"; string UIWidget = "Checkbox"; > = 1;
bool SmoothStep_kickupDustHardStepBool < string UIName = "SmoothStep_kickupDustHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepAccumSplashBool < string UIName = "StepAccumSplashBool"; string UIWidget = "Checkbox"; > = 0;
bool StepAccumSplashHardStepBool < string UIName = "StepAccumSplashHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepAccumStreakBool < string UIName = "StepAccumStreakBool"; string UIWidget = "Checkbox"; > = 0;
bool StepAccumStreakHardStepBool < string UIName = "StepAccumStreakHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepBool < string UIName = "StepBool"; string UIWidget = "Checkbox"; > = 1;
bool StepFlattenBool < string UIName = "StepFlattenBool"; string UIWidget = "Checkbox"; > = 0;
bool StepFlattenHardStepBool < string UIName = "StepFlattenHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepHardStepBool < string UIName = "StepHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepLowLODsBool < string UIName = "StepLowLODsBool"; string UIWidget = "Checkbox"; > = 0;
bool StepLowLODsHardStepBool < string UIName = "StepLowLODsHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepLumRangeBool < string UIName = "StepLumRangeBool"; string UIWidget = "Checkbox"; > = 0;
bool StepLumRangeHardStepBool < string UIName = "StepLumRangeHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepMudDampnessBuildupMaskBool < string UIName = "StepMudDampnessBuildupMaskBool"; string UIWidget = "Checkbox"; > = 0;
bool StepMudDampnessBuildupMaskHardStepBool < string UIName = "StepMudDampnessBuildupMaskHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepNoiseTextureBool < string UIName = "StepNoiseTextureBool"; string UIWidget = "Checkbox"; > = 0;
bool StepNoiseTextureHardStepBool < string UIName = "StepNoiseTextureHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepRemapGlobalNaturalWetRangeBool < string UIName = "StepRemapGlobalNaturalWetRangeBool"; string UIWidget = "Checkbox"; > = 0;
bool StepRemapGlobalNaturalWetRangeHardStepBool < string UIName = "StepRemapGlobalNaturalWetRangeHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepSideTexDirectionBool < string UIName = "StepSideTexDirectionBool"; string UIWidget = "Checkbox"; > = 0;
bool StepSideTexDirectionHardStepBool < string UIName = "StepSideTexDirectionHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepSideTexMaskBool < string UIName = "StepSideTexMaskBool"; string UIWidget = "Checkbox"; > = 0;
bool StepSideTexMaskHardStepBool < string UIName = "StepSideTexMaskHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepSpecSpotsBool < string UIName = "StepSpecSpotsBool"; string UIWidget = "Checkbox"; > = 1;
bool StepSpecSpotsHardStepBool < string UIName = "StepSpecSpotsHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepWadingLevelBool < string UIName = "StepWadingLevelBool"; string UIWidget = "Checkbox"; > = 0;
bool StepWadingLevelHardStepBool < string UIName = "StepWadingLevelHardStepBool"; string UIWidget = "Checkbox"; > = 0;
float4 TexLowFrequencyNoiseTiling < string UIName = "TexLowFrequencyNoiseTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0, 0 );
float4 TextureWetnessEdgeTiling < string UIName = "TextureWetnessEdgeTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.3, 0.32, 0, 0 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const float4 ColorDryDustColorParam = float4(0.3762622, 0.2663556, 0.1912017, 1);
static const float4 ColorWetDustColorParam = float4(0.1470273, 0.1070231, 0.07818743, 1);
static const bool StepWadingLevelBool = false;
static const bool StepWadingLevelHardStepBool = false;
static const int CH2UV1UVSet = 1;
static const float2 TextureWetnessEdgeTiling = float2(0.3, 0.32);
static const float2 TexLowFrequencyNoiseTiling = float2(0.5, 0.5);
static const bool StepNoiseTextureBool = false;
static const bool StepNoiseTextureHardStepBool = false;
static const bool StepSpecSpotsBool = true;
static const bool StepSpecSpotsHardStepBool = false;
static const float2 MudTileNonDirectionalTiling = float2(1, 1);
static const bool StepBool = true;
static const bool StepHardStepBool = false;
static const bool StepAccumSplashBool = false;
static const bool StepAccumSplashHardStepBool = false;
static const int CH4UV3UVSet = 3;
static const float2 MudTileDirectionalLeftTiling = float2(5, 5);
static const bool StepSideTexDirectionBool = false;
static const bool StepSideTexDirectionHardStepBool = false;
static const bool StepAccumStreakBool = false;
static const bool StepAccumStreakHardStepBool = false;
static const bool StepSideTexMaskBool = false;
static const bool StepSideTexMaskHardStepBool = false;
static const float DynamicOptimisationForNonMuddyPixelsRefValue = 0.05;
static const bool StepLowLODsBool = false;
static const bool StepLowLODsHardStepBool = false;
static const int CarLODOptimisationLOD = 3;
static const bool StepRemapGlobalNaturalWetRangeBool = false;
static const bool StepRemapGlobalNaturalWetRangeHardStepBool = false;
static const int CarLODoptimisation1LOD = 3;
static const bool StepFlattenBool = false;
static const bool StepFlattenHardStepBool = false;
static const bool StepMudDampnessBuildupMaskBool = false;
static const bool StepMudDampnessBuildupMaskHardStepBool = false;
static const float DynamicBranchRefValue = 0;
static const float4 ColorDryMudColorParam = float4(0.2961383, 0.2122308, 0.1441285, 1);
static const float4 ColorWetMudColorParam = float4(0.1559265, 0.1022417, 0.06480327, 1);
static const bool SmoothStep_kickupDustBool = true;
static const bool SmoothStep_kickupDustHardStepBool = false;
static const bool SmoothStep_bottomFade0Bool = true;
static const bool SmoothStep_bottomFade0HardStepBool = false;
static const bool SmoothStep_frontFadeBool = true;
static const bool SmoothStep_frontFadeHardStepBool = false;
static const bool SmoothStep_heightFadeBool = true;
static const bool SmoothStep_heightFadeHardStepBool = false;
static const int CarLODLOD = 2;
static const bool StepLumRangeBool = false;
static const bool StepLumRangeHardStepBool = false;
static const float NormalMapWithIntensityHeightScale = 0.25;
static const float NormalMapWithIntensitySpecPower = 100;
static const float2 NormalMapWithIntensityTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MudTileDirectionalLeftTexture, 16);
#else
#define MudTileDirectionalLeftTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MudTileNonDirectionalTexture, 17);
#else
#define MudTileNonDirectionalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapWithIntensityTexture, 18);
#else
#define NormalMapWithIntensityTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TexLowFrequencyNoiseTexture, 19);
#else
#define TexLowFrequencyNoiseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TextureWetnessEdgeTexture, 20);
#else
#define TextureWetnessEdgeTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_Glossiness 1
#define MATERIAL_INPUT_IS_USED_Glossiness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_INPUT_IS_USED_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"
#include "CarConstantBuffer.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:FunctionInputNode, Name:DiffuseColour
	float4 DiffuseColour = float4(0,0,0,0);
	float4 DiffuseColourPreview = float4(0,0,0,0);
	
	// Type:ColorNode, Name:ColorDryDust
	float4 ColorDryDust = ColorDryDustColorParam;
	float4 ColorDryDustRed = ColorDryDustColorParam.rrrr;
	float4 ColorDryDustGreen = ColorDryDustColorParam.gggg;
	float4 ColorDryDustBlue = ColorDryDustColorParam.bbbb;
	float4 ColorDryDustAlpha = ColorDryDustColorParam.aaaa;
	
	// Type:ColorNode, Name:ColorWetDust
	float4 ColorWetDust = ColorWetDustColorParam;
	float4 ColorWetDustRed = ColorWetDustColorParam.rrrr;
	float4 ColorWetDustGreen = ColorWetDustColorParam.gggg;
	float4 ColorWetDustBlue = ColorWetDustColorParam.bbbb;
	float4 ColorWetDustAlpha = ColorWetDustColorParam.aaaa;
	
	// Type:CarWetAmountNode, Name:GlobalCarWetness
	float4 GlobalCarWetness = GetWetMudAmount().xxxx;
	
	// Type:FloatNode, Name:floatNoiseTexStepRange0
	float4 floatNoiseTexStepRange0 = float4(-0.1, -0.1, -0.1, -0.1);
	
	// Type:Vector4Node, Name:WheelVertColor
	float4 WheelVertColor = float4(0, 0, 0, 1) ;
	
	// Type:FloatNode, Name:startOfWheelWading
	float4 startOfWheelWading = float4(-0.38, -0.38, -0.38, -0.38);
	
	// Type:CarTireWadingLevelNode, Name:CarTireWadingLevel
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IN_MATERIAL_EDITOR)
	float4 CarTireWadingLevel = GetTireWadingLevel();
	#else
	float4 CarTireWadingLevel = float4(0,0,0,0);
	#endif
	
	// Type:AddNode, Name:Add5
	float4 Add5 = startOfWheelWading + CarTireWadingLevel;
	
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:CarWadingWetnessLevelNode, Name:CarWadingWetnessLevel
	float4 CarWadingWetnessLevel = GetRubberAmount().xxxx;
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel
	float4 CarPartIsWheel;
	float4 CarPartIsWheelOut1;
	float4 CarPartIsWheelOut2;
	float4 CarPartIsWheelOut3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel = VertexColor;
	CarPartIsWheelOut1 = CarWadingWetnessLevel;
	CarPartIsWheelOut2 = float4(1, 1, 1, 1);
	CarPartIsWheelOut3 = float4(1, 1, 1, 1);
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel = WheelVertColor;
		CarPartIsWheelOut1 = Add5;
		CarPartIsWheelOut2 = float4(1, 1, 1, 1);
		CarPartIsWheelOut3 = float4(1, 1, 1, 1);
	}
	else
	{
		CarPartIsWheel = VertexColor;
		CarPartIsWheelOut1 = CarWadingWetnessLevel;
		CarPartIsWheelOut2 = float4(1, 1, 1, 1);
		CarPartIsWheelOut3 = float4(1, 1, 1, 1);
	}
	#endif
	
	// Type:FloatNode, Name:WadingSplashTransitionRangeInMeters
	float4 WadingSplashTransitionRangeInMeters = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:AddNode, Name:Add2
	float4 Add2 = WadingSplashTransitionRangeInMeters + CarPartIsWheelOut1;
	
	// Type:FloatNode, Name:floatKickupContributionScaler
	float4 floatKickupContributionScaler = float4(-0.25, -0.25, -0.25, -0.25);
	
	// Type:SwizzleNode, Name:SwizzleG0
	float4 SwizzleG0 = CarPartIsWheel.yyyw;
	
	// Type:FloatNode, Name:FloatAdjustmentOnly
	float4 FloatAdjustmentOnly = float4(1.9, 1.9, 1.9, 1.9);
	
	// Type:PowNode, Name:PowDeGammaG_plusAdjustment
	float4 PowDeGammaG_plusAdjustment = pow( SwizzleG0, FloatAdjustmentOnly );
	
	// Type:MultiplyNode, Name:mulModulatedKickupVC
	float4 mulModulatedKickupVC = floatKickupContributionScaler * PowDeGammaG_plusAdjustment;
	
	// Type:SwizzleNode, Name:SwizzleR0
	float4 SwizzleR0 = CarPartIsWheel.xxxw;
	
	// Type:FloatNode, Name:HeightToVertColorRatio
	float4 HeightToVertColorRatio = float4(2, 2, 2, 2);
	
	// Type:MultiplyNode, Name:MulToMeters
	float4 MulToMeters = SwizzleR0 * HeightToVertColorRatio;
	
	// Type:AddNode, Name:Add4
	float4 Add4 = mulModulatedKickupVC + MulToMeters;
	
	// Type:SaturateNode, Name:Saturate0
	float4 Saturate0 = saturate( Add4 ); 
	
	// Type:StepNode, Name:StepWadingLevel
	float4 StepWadingLevel = linearstep( CarPartIsWheelOut1, Add2, Saturate0 );
	
	// Type:AddNode, Name:Add200
	float4 Add200 = floatNoiseTexStepRange0 + StepWadingLevel;
	
	// Type:FloatNode, Name:MaskWheelBlurred
	float4 MaskWheelBlurred = float4(0.8706, 0.8706, 0.8706, 0.8706);
	
	// Type:UVNode, Name:CH2UV1
	float4 CH2UV1 = GetTexCoord1(In).xyxy;
	float4 CH2UV1Tangent = GetWorldTangent1(In);
	float4 CH2UV1UCoord = GetTexCoord1(In).xxxx;
	float4 CH2UV1VCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:TextureWetnessEdge
	float4 TextureWetnessEdge = TextureWetnessEdgeTexture.Sample(g_samplerLinearWrap, CH2UV1.xy * TextureWetnessEdgeTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TextureWetnessEdgeMip = GetDebugMipColour(TextureWetnessEdgeTexture, g_samplerLinearWrap, CH2UV1.xy * TextureWetnessEdgeTiling);
	#else
	float4 TextureWetnessEdgeMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TextureWetnessEdgeAlpha = TextureWetnessEdge.aaaa;
	float4 TextureWetnessEdgeRed = TextureWetnessEdge.rrrr;
	float4 TextureWetnessEdgeGreen = TextureWetnessEdge.gggg;
	float4 TextureWetnessEdgeBlue = TextureWetnessEdge.bbbb;
	Texture2D TextureWetnessEdgeRef = TextureWetnessEdgeTexture;
	
	// Type:FloatNode, Name:MaskWheelBlurred0
	float4 MaskWheelBlurred0 = float4(0.2863, 0.2863, 0.2863, 0.2863);
	
	// Type:CarTireVelocityNode, Name:CarTireVelocity
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IN_MATERIAL_EDITOR)
	float4 CarTireVelocity = GetTireVelocityAmount();
	#else
	float4 CarTireVelocity = float4(0,0,0,0);
	#endif
	
	// Type:LerpNode, Name:Lerp00
	float4 Lerp00 = lerp(TextureWetnessEdgeRed, MaskWheelBlurred0, CarTireVelocity.x);
	
	// Type:TextureNode, Name:TexLowFrequencyNoise
	float4 TexLowFrequencyNoise = TexLowFrequencyNoiseTexture.Sample(g_samplerLinearWrap, CH2UV1.xy * TexLowFrequencyNoiseTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TexLowFrequencyNoiseMip = GetDebugMipColour(TexLowFrequencyNoiseTexture, g_samplerLinearWrap, CH2UV1.xy * TexLowFrequencyNoiseTiling);
	#else
	float4 TexLowFrequencyNoiseMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TexLowFrequencyNoiseAlpha = TexLowFrequencyNoise.aaaa;
	float4 TexLowFrequencyNoiseRed = TexLowFrequencyNoise.rrrr;
	float4 TexLowFrequencyNoiseGreen = TexLowFrequencyNoise.gggg;
	float4 TexLowFrequencyNoiseBlue = TexLowFrequencyNoise.bbbb;
	Texture2D TexLowFrequencyNoiseRef = TexLowFrequencyNoiseTexture;
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel_noise
	float4 CarPartIsWheel_noise;
	float4 CarPartIsWheel_noiseOut1;
	float4 CarPartIsWheel_noiseOut2;
	float4 CarPartIsWheel_noiseOut3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel_noise = TexLowFrequencyNoiseRed;
	CarPartIsWheel_noiseOut1 = TextureWetnessEdgeRed;
	CarPartIsWheel_noiseOut2 = float4(1, 1, 1, 1);
	CarPartIsWheel_noiseOut3 = float4(1, 1, 1, 1);
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel_noise = MaskWheelBlurred;
		CarPartIsWheel_noiseOut1 = Lerp00;
		CarPartIsWheel_noiseOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_noiseOut3 = float4(1, 1, 1, 1);
	}
	else
	{
		CarPartIsWheel_noise = TexLowFrequencyNoiseRed;
		CarPartIsWheel_noiseOut1 = TextureWetnessEdgeRed;
		CarPartIsWheel_noiseOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_noiseOut3 = float4(1, 1, 1, 1);
	}
	#endif
	
	// Type:StepNode, Name:StepNoiseTexture
	float4 StepNoiseTexture = linearstep( Add200, StepWadingLevel, CarPartIsWheel_noiseOut1 );
	
	// Type:MaxNode, Name:MaxWetMask
	float4 MaxWetMask = max(GlobalCarWetness, StepNoiseTexture);
	
	// Type:OneMinusNode, Name:OneMinus5
	float4 OneMinus5 = 1 - MulToMeters;
	
	// Type:FloatNode, Name:TractorTyreOverride
	float4 TractorTyreOverride = float4(1, 1, 1, 1);
	
	// Type:MultiplyNode, Name:MulHeightMask
	float4 MulHeightMask = OneMinus5 * TractorTyreOverride;
	
	// Type:MultiplyNode, Name:mulKickupAmount
	float4 mulKickupAmount = TractorTyreOverride * PowDeGammaG_plusAdjustment;
	
	// Type:AddNode, Name:AddUpAllMudMaskGradientForOptimisation
	float4 AddUpAllMudMaskGradientForOptimisation = MulHeightMask + mulKickupAmount;
	
	// Type:FloatNode, Name:Float9
	float4 Float9 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:MinStep0
	float4 MinStep0 = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:FloatNode, Name:maxStep0
	float4 maxStep0 = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:FloatNode, Name:mudNoiseMultiplier
	float4 mudNoiseMultiplier = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:OneMinusNode, Name:OneMinus0
	float4 OneMinus0 = 1 - mudNoiseMultiplier;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd
	float4 MultiplyAdd = CarPartIsWheel_noise * mudNoiseMultiplier + OneMinus0;
	
	// Type:MultiplyNode, Name:xLowNoise
	float4 xLowNoise = MultiplyAdd * MulHeightMask;
	
	// Type:StepNode, Name:StepSpecSpots
	float4 StepSpecSpots = smoothstep( MinStep0, maxStep0, xLowNoise );
	
	// Type:SamplerStatesFunctionInputNode, Name:SamplerStates
	SamplerState SamplerStates = FunctionInputDummySamplerState;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:MudTileNonDirectional
	float4 MudTileNonDirectional = MudTileNonDirectionalTexture.Sample(g_samplerLinearWrap, CH2UV1.xy * MudTileNonDirectionalTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MudTileNonDirectionalMip = GetDebugMipColour(MudTileNonDirectionalTexture, g_samplerLinearWrap, CH2UV1.xy * MudTileNonDirectionalTiling);
	#else
	float4 MudTileNonDirectionalMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MudTileNonDirectionalAlpha = MudTileNonDirectional.aaaa;
	float4 MudTileNonDirectionalRed = MudTileNonDirectional.rrrr;
	float4 MudTileNonDirectionalGreen = MudTileNonDirectional.gggg;
	float4 MudTileNonDirectionalBlue = MudTileNonDirectional.bbbb;
	Texture2D MudTileNonDirectionalRef = MudTileNonDirectionalTexture;
	
	// Type:MultiplyNode, Name:MulSpotNonDirectional
	float4 MulSpotNonDirectional = StepSpecSpots * MudTileNonDirectionalGreen;
	
	// Type:FloatNode, Name:minStep
	float4 minStep = float4(0.36, 0.36, 0.36, 0.36);
	
	// Type:FloatNode, Name:maxStep
	float4 maxStep = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:Step
	float4 Step = smoothstep( minStep, maxStep, xLowNoise );
	
	// Type:MultiplyNode, Name:MulSolid
	float4 MulSolid = Step * MudTileNonDirectionalRed;
	
	// Type:OneMinusNode, Name:OneMinusStreakAmount0
	float4 OneMinusStreakAmount0 = 1 - mulKickupAmount;
	
	// Type:FloatNode, Name:StepRangeAccumSplash
	float4 StepRangeAccumSplash = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:AddNode, Name:Add10
	float4 Add10 = OneMinusStreakAmount0 + StepRangeAccumSplash;
	
	// Type:StepNode, Name:StepAccumSplash
	float4 StepAccumSplash = linearstep( OneMinusStreakAmount0, Add10, MudTileNonDirectionalBlue );
	
	// Type:OneMinusNode, Name:OneMinusStreakAmount
	float4 OneMinusStreakAmount = 1 - mulKickupAmount;
	
	// Type:FloatNode, Name:StepRangeAccumStreaks
	float4 StepRangeAccumStreaks = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:AddNode, Name:Add1
	float4 Add1 = OneMinusStreakAmount + StepRangeAccumStreaks;
	
	// Type:UVNode, Name:CH4UV3
	float4 CH4UV3 = GetTexCoord3(In).xyxy;
	float4 CH4UV3Tangent = GetWorldTangent3(In);
	float4 CH4UV3UCoord = GetTexCoord3(In).xxxx;
	float4 CH4UV3VCoord = GetTexCoord3(In).yyyy;
	
	// Type:TextureNode, Name:MudTileDirectionalLeft
	float4 MudTileDirectionalLeft = MudTileDirectionalLeftTexture.Sample(g_samplerLinearWrap, CH4UV3.xy * MudTileDirectionalLeftTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MudTileDirectionalLeftMip = GetDebugMipColour(MudTileDirectionalLeftTexture, g_samplerLinearWrap, CH4UV3.xy * MudTileDirectionalLeftTiling);
	#else
	float4 MudTileDirectionalLeftMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MudTileDirectionalLeftAlpha = MudTileDirectionalLeft.aaaa;
	float4 MudTileDirectionalLeftRed = MudTileDirectionalLeft.rrrr;
	float4 MudTileDirectionalLeftGreen = MudTileDirectionalLeft.gggg;
	float4 MudTileDirectionalLeftBlue = MudTileDirectionalLeft.bbbb;
	Texture2D MudTileDirectionalLeftRef = MudTileDirectionalLeftTexture;
	
	// Type:FloatNode, Name:Float0
	float4 Float0 = float4(-0.1, -0.1, -0.1, -0.1);
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:CarSpaceNormal, Name:CarSpaceNormal
	float4 CarSpaceNormal = normalize(mul(float4(GetWorldNormal(In).xyz, 0), g_CarInvWorldTransform));
	
	// Type:Vector4Node, Name:SideVector
	float4 SideVector = float4(1, 0, 0, 1) ;
	
	// Type:DotNode, Name:DotSideNormal
	float4 DotSideNormal = dot(CarSpaceNormal, SideVector);
	
	// Type:StepNode, Name:StepSideTexDirection
	float4 StepSideTexDirection = linearstep( Float0, Float1, DotSideNormal );
	
	// Type:LerpNode, Name:LerpSideStreaks
	float4 LerpSideStreaks = lerp(MudTileDirectionalLeftRed, MudTileDirectionalLeftBlue, StepSideTexDirection.x);
	
	// Type:StepNode, Name:StepAccumStreak
	float4 StepAccumStreak = linearstep( OneMinusStreakAmount, Add1, LerpSideStreaks );
	
	// Type:FloatNode, Name:stepStart
	float4 stepStart = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:FloatNode, Name:stepEnd
	float4 stepEnd = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:AbsNode, Name:Abs0
	float4 Abs0 = abs( DotSideNormal ); 
	
	// Type:StepNode, Name:StepSideTexMask
	float4 StepSideTexMask = linearstep( stepStart, stepEnd, Abs0 );
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(StepAccumSplash, StepAccumStreak, StepSideTexMask.x);
	
	// Type:MultiplyNode, Name:MulSolidTex_highFrequencyFix
	float4 MulSolidTex_highFrequencyFix = MudTileNonDirectionalRed * Lerp;
	
	// Type:MaxNode, Name:MaxStreaksAndSolids
	float4 MaxStreaksAndSolids = max(MulSolid, MulSolidTex_highFrequencyFix);
	
	// Type:MaxNode, Name:MaxSpotsNonDirectional
	float4 MaxSpotsNonDirectional = max(MulSpotNonDirectional, MaxStreaksAndSolids);
	
	// Type:LerpNode, Name:LerpSideSpots
	float4 LerpSideSpots = lerp(MudTileDirectionalLeftGreen, MudTileDirectionalLeftAlpha, StepSideTexDirection.x);
	
	// Type:MultiplyNode, Name:MulSideMask0
	float4 MulSideMask0 = LerpSideSpots * StepSideTexMask;
	
	// Type:MultiplyNode, Name:MulSpotDirectional
	float4 MulSpotDirectional = StepSpecSpots * MulSideMask0;
	
	// Type:MaxNode, Name:MaxSpotsDirectional
	float4 MaxSpotsDirectional = max(MaxSpotsNonDirectional, MulSpotDirectional);
	
	// Type:DynamicBranchNode, Name:DynamicOptimisationForNonMuddyPixels
	float4 DynamicOptimisationForNonMuddyPixels;
	[branch]
	if(AddUpAllMudMaskGradientForOptimisation.x < DynamicOptimisationForNonMuddyPixelsRefValue.x)
	{
		DynamicOptimisationForNonMuddyPixels = Float9;
	}
	else
	{
		DynamicOptimisationForNonMuddyPixels = MaxSpotsDirectional;
	}
	
	// Type:StepNode, Name:StepLowLODs
	float4 StepLowLODs = linearstep( minStep, maxStep, xLowNoise );
	
	// Type:CarLODNode, Name:CarLODOptimisation
	float4 CarLODOptimisation;
	[branch]
	if (GetLODLessThanOrEqual(3) )
	{
		CarLODOptimisation = DynamicOptimisationForNonMuddyPixels;
	}
	else
	{
		CarLODOptimisation = StepLowLODs;
	}
	
	// Type:FloatNode, Name:NoMud
	float4 NoMud = float4(0, 0, 0, 0);
	
	// Type:CarReceivesOilNode, Name:CarReceivesOil
	float4 CarReceivesOil;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesOil = NoMud;
	#else
	[branch]
	if (ReceivesOil())
	{
		CarReceivesOil = CarLODOptimisation;
	}
	else
	{
		CarReceivesOil = NoMud;
	}
	#endif
	
	// Type:FloatNode, Name:Float15
	float4 Float15 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:FloatNaturalWetBuildupMax
	float4 FloatNaturalWetBuildupMax = float4(0.75, 0.75, 0.75, 0.75);
	
	// Type:FloatNode, Name:Float14
	float4 Float14 = float4(-0.2, -0.2, -0.2, -0.2);
	
	// Type:FloatNode, Name:Float16
	float4 Float16 = float4(-1, -1, -1, -1);
	
	// Type:FloatNode, Name:Float17
	float4 Float17 = float4(1, 1, 1, 1);
	
	// Type:CarMudDampAmountNode, Name:CarMudDampAmount
	float4 CarMudDampAmount = GetCarMudDampAmount().xxxx;
	
	// Type:StepNode, Name:StepRemapGlobalNaturalWetRange
	float4 StepRemapGlobalNaturalWetRange = linearstep( Float16, Float17, CarMudDampAmount );
	
	// Type:OneMinusNode, Name:OneMinus3
	float4 OneMinus3 = 1 - StepRemapGlobalNaturalWetRange;
	
	// Type:AddNode, Name:Add30
	float4 Add30 = Float14 + OneMinus3;
	
	// Type:SaturateNode, Name:Saturate
	float4 Saturate = saturate( Add30 ); 
	
	// Type:FloatNode, Name:initialStepMax
	float4 initialStepMax = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:AddNode, Name:Add3
	float4 Add3 = OneMinus3 + initialStepMax;
	
	// Type:MultiplyNode, Name:mulLowFrequencyNoise
	float4 mulLowFrequencyNoise = CarPartIsWheel_noiseOut1 * CarPartIsWheel_noise;
	
	// Type:FloatNode, Name:Float13
	float4 Float13 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:float14
	float4 float14 = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:CarLODNode, Name:CarLODoptimisation1
	float4 CarLODoptimisation1;
	[branch]
	if (GetLODLessThanOrEqual(3) )
	{
		CarLODoptimisation1 = MaxStreaksAndSolids;
	}
	else
	{
		CarLODoptimisation1 = StepLowLODs;
	}
	
	// Type:StepNode, Name:StepFlatten
	float4 StepFlatten = linearstep( Float13, float14, CarLODoptimisation1 );
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = mulLowFrequencyNoise * StepFlatten;
	
	// Type:StepNode, Name:StepMudDampnessBuildupMask
	float4 StepMudDampnessBuildupMask = linearstep( Saturate, Add3, Multiply2 );
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = FloatNaturalWetBuildupMax * StepMudDampnessBuildupMask;
	
	// Type:DynamicBranchNode, Name:DynamicBranch
	float4 DynamicBranch;
	[branch]
	if(CarReceivesOil.x == DynamicBranchRefValue.x)
	{
		DynamicBranch = Float15;
	}
	else
	{
		DynamicBranch = Multiply0;
	}
	
	// Type:MaxNode, Name:MaxDampnessBuildupMask
	float4 MaxDampnessBuildupMask = max(MaxWetMask, DynamicBranch);
	
	// Type:LerpNode, Name:LerpColourDryWet
	float4 LerpColourDryWet = lerp(ColorDryDust, ColorWetDust, MaxDampnessBuildupMask.x);
	
	// Type:ColorNode, Name:ColorDryMud
	float4 ColorDryMud = ColorDryMudColorParam;
	float4 ColorDryMudRed = ColorDryMudColorParam.rrrr;
	float4 ColorDryMudGreen = ColorDryMudColorParam.gggg;
	float4 ColorDryMudBlue = ColorDryMudColorParam.bbbb;
	float4 ColorDryMudAlpha = ColorDryMudColorParam.aaaa;
	
	// Type:ColorNode, Name:ColorWetMud
	float4 ColorWetMud = ColorWetMudColorParam;
	float4 ColorWetMudRed = ColorWetMudColorParam.rrrr;
	float4 ColorWetMudGreen = ColorWetMudColorParam.gggg;
	float4 ColorWetMudBlue = ColorWetMudColorParam.bbbb;
	float4 ColorWetMudAlpha = ColorWetMudColorParam.aaaa;
	
	// Type:LerpNode, Name:LerpColourDryWet0
	float4 LerpColourDryWet0 = lerp(ColorDryMud, ColorWetMud, MaxDampnessBuildupMask.x);
	
	// Type:FloatNode, Name:FloatNoINF
	float4 FloatNoINF = float4(0.001, 0.001, 0.001, 0.001);
	
	// Type:CarDirtAmountNode, Name:CarDirtAmount
	float4 CarDirtAmount = GetDirtAmount().xxxx;
	
	// Type:MultiplyNode, Name:xLowNoise0
	float4 xLowNoise0 = CarDirtAmount * CarPartIsWheel_noise;
	
	// Type:MultiplyNode, Name:xHighFrequencyDustTexture
	float4 xHighFrequencyDustTexture = xLowNoise0 * MudTileNonDirectionalAlpha;
	
	// Type:FloatNode, Name:Float6
	float4 Float6 = float4(0.7, 0.7, 0.7, 0.7);
	
	// Type:FloatNode, Name:Float5
	float4 Float5 = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:ViewVectorNode, Name:ViewVector
	float4 ViewVector = float4(GetViewVector(), 0);
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:DotNode, Name:Dot0
	float4 Dot0 = dot(ViewVector, WorldNormal);
	
	// Type:OneMinusNode, Name:OneMinus1
	float4 OneMinus1 = 1 - Dot0;
	
	// Type:MultiplyNode, Name:Multiply4
	float4 Multiply4 = Float5 * OneMinus1;
	
	// Type:AddNode, Name:AddViewVectorVariation
	float4 AddViewVectorVariation = Float6 + Multiply4;
	
	// Type:MultiplyNode, Name:xViewFade
	float4 xViewFade = xHighFrequencyDustTexture * AddViewVectorVariation;
	
	// Type:FloatNode, Name:maxDustThicknessPercentage1_wheel
	float4 maxDustThicknessPercentage1_wheel = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:MultiplyNode, Name:xDustCombinedWheel
	float4 xDustCombinedWheel = xViewFade * maxDustThicknessPercentage1_wheel;
	
	// Type:FloatNode, Name:maxDustThicknessPercentageBottom
	float4 maxDustThicknessPercentageBottom = float4(0.7, 0.7, 0.7, 0.7);
	
	// Type:FloatNode, Name:maxDustThicknessPercentage1
	float4 maxDustThicknessPercentage1 = float4(0.31, 0.31, 0.31, 0.31);
	
	// Type:FloatNode, Name:maxDustKickupThickness
	float4 maxDustKickupThickness = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FloatNode, Name:Float10
	float4 Float10 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:Float23
	float4 Float23 = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:StepNode, Name:SmoothStep_kickupDust
	float4 SmoothStep_kickupDust = smoothstep( Float10, Float23, VertexColorGreen );
	
	// Type:LerpNode, Name:LerpKickupDust
	float4 LerpKickupDust = lerp(maxDustThicknessPercentage1, maxDustKickupThickness, SmoothStep_kickupDust.x);
	
	// Type:FloatNode, Name:FloatLowerVertColour0
	float4 FloatLowerVertColour0 = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:FloatHigherVertColour0
	float4 FloatHigherVertColour0 = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:StepNode, Name:SmoothStep_bottomFade0
	float4 SmoothStep_bottomFade0 = smoothstep( FloatLowerVertColour0, FloatHigherVertColour0, VertexColorRed );
	
	// Type:LerpNode, Name:LerpBottomFadeMultiplier0
	float4 LerpBottomFadeMultiplier0 = lerp(maxDustThicknessPercentageBottom, LerpKickupDust, SmoothStep_bottomFade0.x);
	
	// Type:FloatNode, Name:maxDustThicknessPercentageFront0
	float4 maxDustThicknessPercentageFront0 = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FloatNode, Name:Float8
	float4 Float8 = float4(0.28, 0.28, 0.28, 0.28);
	
	// Type:FloatNode, Name:Float20
	float4 Float20 = float4(1, 1, 1, 1);
	
	// Type:Vector4Node, Name:FrontVector
	float4 FrontVector = float4(0, 0, 1, 1) ;
	
	// Type:DotNode, Name:DotFrontNormal
	float4 DotFrontNormal = dot(CarSpaceNormal, FrontVector);
	
	// Type:StepNode, Name:SmoothStep_frontFade
	float4 SmoothStep_frontFade = smoothstep( Float8, Float20, DotFrontNormal );
	
	// Type:LerpNode, Name:LerpFrontVectorScaler
	float4 LerpFrontVectorScaler = lerp(LerpBottomFadeMultiplier0, maxDustThicknessPercentageFront0, SmoothStep_frontFade.x);
	
	// Type:FloatNode, Name:maxSmearMaskMultipler
	float4 maxSmearMaskMultipler = float4(0.22, 0.22, 0.22, 0.22);
	
	// Type:MultiplyNode, Name:Multiply6
	float4 Multiply6 = TextureWetnessEdgeGreen * maxSmearMaskMultipler;
	
	// Type:OneMinusNode, Name:OneMinus
	float4 OneMinus = 1 - Multiply6;
	
	// Type:MultiplyNode, Name:mulDustSmearMask
	float4 mulDustSmearMask = LerpFrontVectorScaler * OneMinus;
	
	// Type:FloatNode, Name:dustLowerPart
	float4 dustLowerPart = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:dustHigherPart
	float4 dustHigherPart = float4(0.2, 0.2, 0.2, 0.2);
	
	// Type:FloatNode, Name:FloatLowerVertColour
	float4 FloatLowerVertColour = float4(0.14, 0.14, 0.14, 0.14);
	
	// Type:FloatNode, Name:FloatHigherVertColour
	float4 FloatHigherVertColour = float4(0.35, 0.35, 0.35, 0.35);
	
	// Type:StepNode, Name:SmoothStep_heightFade
	float4 SmoothStep_heightFade = smoothstep( FloatLowerVertColour, FloatHigherVertColour, VertexColorRed );
	
	// Type:LerpNode, Name:LerpHeightFadeMultiplier
	float4 LerpHeightFadeMultiplier = lerp(dustLowerPart, dustHigherPart, SmoothStep_heightFade.x);
	
	// Type:MultiplyNode, Name:mulFadeRules
	float4 mulFadeRules = mulDustSmearMask * LerpHeightFadeMultiplier;
	
	// Type:MultiplyNode, Name:xDustCombinedNonWheel
	float4 xDustCombinedNonWheel = xViewFade * mulFadeRules;
	
	// Type:CarPartIsWheel, Name:CarPartIsWheel_dust
	float4 CarPartIsWheel_dust;
	float4 CarPartIsWheel_dustOut1;
	float4 CarPartIsWheel_dustOut2;
	float4 CarPartIsWheel_dustOut3;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarPartIsWheel_dust = xDustCombinedNonWheel;
	CarPartIsWheel_dustOut1 = float4(1, 1, 1, 1);
	CarPartIsWheel_dustOut2 = float4(1, 1, 1, 1);
	CarPartIsWheel_dustOut3 = float4(1, 1, 1, 1);
	#else
	[branch]
	if (IsWheel())
	{
		CarPartIsWheel_dust = xDustCombinedWheel;
		CarPartIsWheel_dustOut1 = float4(1, 1, 1, 1);
		CarPartIsWheel_dustOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_dustOut3 = float4(1, 1, 1, 1);
	}
	else
	{
		CarPartIsWheel_dust = xDustCombinedNonWheel;
		CarPartIsWheel_dustOut1 = float4(1, 1, 1, 1);
		CarPartIsWheel_dustOut2 = float4(1, 1, 1, 1);
		CarPartIsWheel_dustOut3 = float4(1, 1, 1, 1);
	}
	#endif
	
	// Type:FloatNode, Name:LOD_approximate
	float4 LOD_approximate = float4(0.25, 0.25, 0.25, 0.25);
	
	// Type:MultiplyNode, Name:Multiply7
	float4 Multiply7 = LOD_approximate * LerpHeightFadeMultiplier;
	
	// Type:MultiplyNode, Name:lowerLODAverage
	float4 lowerLODAverage = xLowNoise0 * Multiply7;
	
	// Type:CarLODNode, Name:CarLOD
	float4 CarLOD;
	[branch]
	if (GetLODLessThanOrEqual(2) )
	{
		CarLOD = CarPartIsWheel_dust;
	}
	else
	{
		CarLOD = lowerLODAverage;
	}
	
	// Type:FloatNode, Name:NoDust
	float4 NoDust = float4(0, 0, 0, 0);
	
	// Type:CarReceivesDirtNode, Name:CarReceivesDirt
	float4 CarReceivesDirt;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDirt = NoDust;
	#else
	[branch]
	if (ReceivesDirt())
	{
		CarReceivesDirt = CarLOD;
	}
	else
	{
		CarReceivesDirt = NoDust;
	}
	#endif
	
	// Type:AddNode, Name:AddMask
	float4 AddMask = CarReceivesDirt + CarReceivesOil;
	
	// Type:AddNode, Name:Add
	float4 Add = FloatNoINF + AddMask;
	
	// Type:DivideNode, Name:Divide_percentage
	float4 Divide_percentage = CarReceivesOil / Add;
	
	// Type:LerpNode, Name:LerpDiffColor
	float4 LerpDiffColor = lerp(LerpColourDryWet, LerpColourDryWet0, Divide_percentage.x);
	
	// Type:LerpNode, Name:SurfaceFX_DiffMud
	float4 SurfaceFX_DiffMud = lerp(DiffuseColour, LerpDiffColor, CarReceivesOil.x);
	
	// Type:FloatNode, Name:LumRangeMin
	float4 LumRangeMin = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:LumRangeMax
	float4 LumRangeMax = float4(0.3, 0.3, 0.3, 0.3);
	
	// Type:Vector4Node, Name:VectorDryDustLumCoefficient
	float4 VectorDryDustLumCoefficient = float4(0.3864, 0.3302, 0.2833, 0) ;
	
	// Type:FloatNode, Name:SSSMetalContribution_scaler
	float4 SSSMetalContribution_scaler = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FunctionInputNode, Name:MetalColour
	float4 MetalColour = float4(0,0,0,0);
	float4 MetalColourPreview = float4(0,0,0,0);
	
	// Type:MultiplyNode, Name:Multiply8
	float4 Multiply8 = SSSMetalContribution_scaler * MetalColour;
	
	// Type:FunctionInputNode, Name:Metalness
	float4 Metalness = float4(0,0,0,0);
	float4 MetalnessPreview = float4(0,0,0,0);
	
	// Type:LerpNode, Name:LerpSSScontributors
	float4 LerpSSScontributors = lerp(SurfaceFX_DiffMud, Multiply8, Metalness.x);
	
	// Type:DotNode, Name:Dot
	float4 Dot = dot(VectorDryDustLumCoefficient, LerpSSScontributors);
	
	// Type:StepNode, Name:StepLumRange
	float4 StepLumRange = linearstep( LumRangeMin, LumRangeMax, Dot );
	
	// Type:FloatNode, Name:SSSWeighting
	float4 SSSWeighting = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:MultiplyAddNode, Name:MulAddSSSFactor
	float4 MulAddSSSFactor = StepLumRange * SSSWeighting + SSSWeighting;
	
	// Type:OneMinusNode, Name:OneMinus412
	float4 OneMinus412 = 1 - CarReceivesDirt;
	
	// Type:FloatNode, Name:DustDiffMaskPower
	float4 DustDiffMaskPower = float4(5, 5, 5, 5);
	
	// Type:PowNode, Name:PowDiffRate
	float4 PowDiffRate = pow( OneMinus412, DustDiffMaskPower );
	
	// Type:OneMinusNode, Name:DustDiffMask
	float4 DustDiffMask = 1 - PowDiffRate;
	
	// Type:MultiplyNode, Name:MulSSS
	float4 MulSSS = MulAddSSSFactor * DustDiffMask;
	
	// Type:LerpNode, Name:SurfaceFX_DiffDust
	float4 SurfaceFX_DiffDust = lerp(SurfaceFX_DiffMud, LerpDiffColor, MulSSS.x);
	
	// Type:NormalMapWithIntensityNode, Name:NormalMapWithIntensity
	float4 textureLookup_NormalMapWithIntensity = NormalMapWithIntensityTexture.Sample(g_samplerLinearWrap, CH2UV1.xy * NormalMapWithIntensityTiling);
	#ifdef _MAX_
	textureLookup_NormalMapWithIntensity.xyz = pow(textureLookup_NormalMapWithIntensity.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMapWithIntensity = (2.0f * textureLookup_NormalMapWithIntensity.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapWithIntensityGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMapWithIntensity, NormalMapWithIntensitySpecPower);
	float4 NormalMapWithIntensityAlpha = textureLookup_NormalMapWithIntensity.aaaa;
	float4 NormalMapWithIntensityRed = textureLookup_NormalMapWithIntensity.rrrr;
	float4 NormalMapWithIntensityGreen = textureLookup_NormalMapWithIntensity.gggg;
	float4 NormalMapWithIntensityBlue = textureLookup_NormalMapWithIntensity.bbbb;
	tangentSpaceNormal_NormalMapWithIntensity.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMapWithIntensity.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMapWithIntensity.x*tangentSpaceNormal_NormalMapWithIntensity.x - tangentSpaceNormal_NormalMapWithIntensity.y*tangentSpaceNormal_NormalMapWithIntensity.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMapWithIntensity.xy *= g_GlobalNormalScale * NormalMapWithIntensityHeightScale.x;
	#else
	tangentSpaceNormal_NormalMapWithIntensity.xy *= NormalMapWithIntensityHeightScale.x;
	#endif
	float4 NormalMapWithIntensity = float4(normalize(mul(tangentSpaceNormal_NormalMapWithIntensity, float3x3(CH2UV1Tangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, CH2UV1Tangent.xyz) * CH2UV1Tangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMapWithIntensity = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:F0ValuesNode, Name:F0Values_temp
	float4 F0Values_temp = float4(0.01790891, 0.01790891, 0.01790891, 1) ;
	
	// Type:FloatNode, Name:GlossMatte
	float4 GlossMatte = float4(0.05, 0.05, 0.05, 0.05);
	
	// Type:AOMapValueNode, Name:AOMapValue0
	float4 AOMapValue0 = g_AOMapValue.xxxx;
	output.DiffuseColor = SurfaceFX_DiffDust;
	output.Normal = NormalMapWithIntensity;
	output.F0 = F0Values_temp;
	output.Glossiness = GlossMatte;
	output.CarAOOverride = AOMapValue0;
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#include "LightScenarios\DebugLightingLightScenario.hlsl"