#include "LightScenarios\Inc\CarShadowDepthLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 Alpha_Tiling < string UIName = "Alpha_Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
int CarLOD20LOD < string UIName = "CarLOD20LOD"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
int CarLOD4LOD < string UIName = "CarLOD4LOD"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
int CarLODLOD < string UIName = "CarLODLOD"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = -1 ;
bool CH1F0MaskSwitchBool < string UIName = "CH1F0MaskSwitchBool"; string UIWidget = "Checkbox"; > = 0;
bool CH1GlossMaskSwitchBool < string UIName = "CH1GlossMaskSwitchBool"; string UIWidget = "Checkbox"; > = 0;
bool CH1LocalAOSwitchBool < string UIName = "CH1LocalAOSwitchBool"; string UIWidget = "Checkbox"; > = 0;
bool CH1NormalMapSwitchBool < string UIName = "CH1NormalMapSwitchBool"; string UIWidget = "Checkbox"; > = 0;
bool CH1OpacityMaskSwitchBool < string UIName = "CH1OpacityMaskSwitchBool"; string UIWidget = "Checkbox"; > = 0;
float4 F0aVector4 < string UIName = "F0aVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.913183, 0.921494, 0.924524, 1 );
float4 F0bVector4 < string UIName = "F0bVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.913183, 0.921494, 0.924524, 1 );
float4 Gloss_Tiling < string UIName = "Gloss_Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float GlossA_floatVal < string UIName = "GlossA_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.983 ;
float GlossB_floatVal < string UIName = "GlossB_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.983 ;
bool LiverySwitchBool < string UIName = "LiverySwitchBool"; string UIWidget = "Checkbox"; > = 0;
float4 LocalAO_Tiling < string UIName = "LocalAO_Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float Normal_HeightScale < string UIName = "Normal_HeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 Normal_Tiling < string UIName = "Normal_Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float NormalMapWithIntensity_HeightScale < string UIName = "NormalMapWithIntensity_HeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.35 ;
float4 NormalMapWithIntensity_Tiling < string UIName = "NormalMapWithIntensity_Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.4, 0.4, 0, 0 );
float NormalMapWithIntensitySpecPower < string UIName = "NormalMapWithIntensitySpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float NormalSpecPower < string UIName = "NormalSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 Reflected_RTint_Tiling < string UIName = "Reflected_RTint_Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 2, 2, 0, 0 );
float4 SplatterY_Tiling < string UIName = "SplatterY_Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
bool Step0Bool < string UIName = "Step0Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step0HardStepBool < string UIName = "Step0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool Step10Bool < string UIName = "Step10Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step10HardStepBool < string UIName = "Step10HardStepBool"; string UIWidget = "Checkbox"; > = 0;
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int WorldToTangentSpaceUVSet < string UIName = "WorldToTangentSpaceUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define F0bVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 F0bVector4 : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F0aVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 F0aVector4 : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Normal_Tiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].xy))
	#else
	float2 Normal_Tiling : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Reflected_RTint_Tiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].zw))
	#else
	float2 Reflected_RTint_Tiling : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Gloss_Tiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].xy))
	#else
	float2 Gloss_Tiling : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LocalAO_Tiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].zw))
	#else
	float2 LocalAO_Tiling : packoffset(c3.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Alpha_Tiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].xy))
	#else
	float2 Alpha_Tiling : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Normal_HeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)
	#else
	float Normal_HeightScale : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define NormalSpecPower (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)
	#else
	float NormalSpecPower : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GlossB_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)
	#else
	float GlossB_floatVal : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GlossA_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)
	#else
	float GlossA_floatVal : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LiverySwitchBool ((bool)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x) != 0.0f)
	#else
	bool LiverySwitchBool : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define CH1NormalMapSwitchBool ((bool)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].y) != 0.0f)
	#else
	bool CH1NormalMapSwitchBool : packoffset(c6.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define CH1F0MaskSwitchBool ((bool)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].z) != 0.0f)
	#else
	bool CH1F0MaskSwitchBool : packoffset(c6.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define CH1GlossMaskSwitchBool ((bool)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].w) != 0.0f)
	#else
	bool CH1GlossMaskSwitchBool : packoffset(c6.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define CH1LocalAOSwitchBool ((bool)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].x) != 0.0f)
	#else
	bool CH1LocalAOSwitchBool : packoffset(c7.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define CH1OpacityMaskSwitchBool ((bool)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].y) != 0.0f)
	#else
	bool CH1OpacityMaskSwitchBool : packoffset(c7.y);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UVUVSet = 1;
static const float NormalMapWithIntensity_HeightScale = 0.35;
static const float NormalMapWithIntensitySpecPower = 100;
static const float2 NormalMapWithIntensity_Tiling = float2(0.4, 0.4);
static const float2 SplatterY_Tiling = float2(1, 1);
static const int CarLOD4LOD = 3;
static const bool Step0Bool = false;
static const bool Step0HardStepBool = false;
static const bool Step10Bool = false;
static const bool Step10HardStepBool = false;
static const int CarLOD20LOD = 2;
static const int WorldToTangentSpaceUVSet = 0;
static const int CarLODLOD = -1;

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Alpha_Texture, 16);
#else
#define Alpha_Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Gloss_Texture, 17);
#else
#define Gloss_Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(LocalAO_Texture, 18);
#else
#define LocalAO_Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Normal_Texture, 19);
#else
#define Normal_Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapWithIntensity_Texture, 20);
#else
#define NormalMapWithIntensity_Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Reflected_RTint_Texture, 21);
#else
#define Reflected_RTint_Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(SplatterY_Texture, 22);
#else
#define SplatterY_Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(6)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_Glossiness 1
#define MATERIAL_INPUT_IS_USED_Glossiness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_INPUT_IS_USED_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 1
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"
#include "CarConstantBuffer.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:FloatNode, Name:Float5
	float4 Float5 = float4(0, 0, 0, 0);
	
	// Type:CarLiveryTextureNode, Name:CarLiveryTexture
	#if defined(CAR_LIGHTING_SCENARIO) || defined(IS_WHEEL_BLUR_SCENARIO) || (defined(IN_MATERIAL_EDITOR) && IN_MATERIAL_EDITOR == 1)
	float4 CarLiveryTexture = GetCarLivery(In, g_samplerLinearWrap);
	#else
	float4 CarLiveryTexture = float4(1,1,1,1);
	#endif
	float4 CarLiveryTextureAlpha = CarLiveryTexture.aaaa;
	// Type:FloatNode, Name:Float61
	float4 Float61 = float4(0, 0, 0, 0);
	
	// Type:OnOffNode, Name:LiverySwitch
	float4 LiverySwitch;
	float4 LiverySwitchOutput2;
	[branch]
	if(LiverySwitchBool == true)
	{
		LiverySwitch = CarLiveryTextureAlpha;
		LiverySwitchOutput2 = float4(1, 1, 1, 1);
	}
	else
	{
		LiverySwitch = Float61;
		LiverySwitchOutput2 = float4(1, 1, 1, 1);
	}
	
	// Type:FloatNode, Name:Float31
	float4 Float31 = float4(1, 1, 1, 1);
	
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord1(In).xyxy;
	float4 UVTangent = GetWorldTangent1(In);
	float4 UVUCoord = GetTexCoord1(In).xxxx;
	float4 UVVCoord = GetTexCoord1(In).yyyy;
	
	// Type:NormalMapWithIntensityNode, Name:NormalMapWithIntensity
	float4 textureLookup_NormalMapWithIntensity = NormalMapWithIntensity_Texture.Sample(g_samplerLinearWrap, UV.xy * NormalMapWithIntensity_Tiling);
	#ifdef _MAX_
	textureLookup_NormalMapWithIntensity.xyz = pow(textureLookup_NormalMapWithIntensity.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMapWithIntensity = (2.0f * textureLookup_NormalMapWithIntensity.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapWithIntensityGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMapWithIntensity, NormalMapWithIntensitySpecPower);
	float4 NormalMapWithIntensityAlpha = textureLookup_NormalMapWithIntensity.aaaa;
	float4 NormalMapWithIntensityRed = textureLookup_NormalMapWithIntensity.rrrr;
	float4 NormalMapWithIntensityGreen = textureLookup_NormalMapWithIntensity.gggg;
	float4 NormalMapWithIntensityBlue = textureLookup_NormalMapWithIntensity.bbbb;
	tangentSpaceNormal_NormalMapWithIntensity.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMapWithIntensity.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMapWithIntensity.x*tangentSpaceNormal_NormalMapWithIntensity.x - tangentSpaceNormal_NormalMapWithIntensity.y*tangentSpaceNormal_NormalMapWithIntensity.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMapWithIntensity.xy *= g_GlobalNormalScale * NormalMapWithIntensity_HeightScale.x;
	#else
	tangentSpaceNormal_NormalMapWithIntensity.xy *= NormalMapWithIntensity_HeightScale.x;
	#endif
	float4 NormalMapWithIntensity = float4(normalize(mul(tangentSpaceNormal_NormalMapWithIntensity, float3x3(UVTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UVTangent.xyz) * UVTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMapWithIntensity = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:CarScrapeAmountNode, Name:CarScrapeAmount
	float4 CarScrapeAmount = GetScrapeAmount(In).xxxx;
	
	// Type:FloatNode, Name:Float9
	float4 Float9 = float4(0, 0, 0, 0);
	
	// Type:CarReceivesDamageNode, Name:CarReceivesDamage
	float4 CarReceivesDamage;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDamage = Float9;
	#else
	[branch]
	if (ReceivesDamage())
	{
		CarReceivesDamage = CarScrapeAmount;
	}
	else
	{
		CarReceivesDamage = Float9;
	}
	#endif
	
	// Type:LerpNode, Name:Lerp20
	float4 Lerp20 = lerp(Float31, NormalMapWithIntensityAlpha, CarReceivesDamage.x);
	
	// Type:MultiplyNode, Name:Multiply8
	float4 Multiply8 = LiverySwitch * Lerp20;
	
	// Type:LerpNode, Name:Lerp9
	float4 Lerp9 = lerp(Float5, CarLiveryTexture, Multiply8.x);
	
	// Type:CarDirtAmountNode, Name:CarDirtAmount
	float4 CarDirtAmount = GetDirtAmount().xxxx;
	
	// Type:FloatNode, Name:Float40
	float4 Float40 = float4(0, 0, 0, 0);
	
	// Type:CarReceivesDirtNode, Name:CarReceivesDirt
	float4 CarReceivesDirt;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDirt = Float40;
	#else
	[branch]
	if (ReceivesDirt())
	{
		CarReceivesDirt = CarDirtAmount;
	}
	else
	{
		CarReceivesDirt = Float40;
	}
	#endif
	
	// Type:CarSplatterMaskTextureNode, Name:CarSplatterMaskTexture
	float4 CarSplatterMaskTexture = GetCarSplatterMask(In);
	
	// Type:SwizzleNode, Name:Swizzle3
	float4 Swizzle3 = CarSplatterMaskTexture.xxxx;
	
	// Type:TextureNode, Name:SplatterY
	float4 SplatterY = SplatterY_Texture.Sample(g_samplerLinearWrap, UV.xy * SplatterY_Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 SplatterYMip = GetDebugMipColour(SplatterY_Texture, g_samplerLinearWrap, UV.xy * SplatterY_Tiling);
	#else
	float4 SplatterYMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 SplatterYAlpha = SplatterY.aaaa;
	float4 SplatterYRed = SplatterY.rrrr;
	float4 SplatterYGreen = SplatterY.gggg;
	float4 SplatterYBlue = SplatterY.bbbb;
	Texture2D SplatterYRef = SplatterY_Texture;
	
	// Type:SwizzleNode, Name:Swizzle6
	float4 Swizzle6 = SplatterY.zzzz;
	
	// Type:MultiplyNode, Name:Multiply130
	float4 Multiply130 = Swizzle3 * Swizzle6;
	
	// Type:FloatNode, Name:Float16
	float4 Float16 = float4(0, 0, 0, 0);
	
	// Type:CarLODNode, Name:CarLOD4
	float4 CarLOD4;
	[branch]
	if (GetLODLessThanOrEqual(3) )
	{
		CarLOD4 = Multiply130;
	}
	else
	{
		CarLOD4 = Float16;
	}
	
	// Type:MultiplyNode, Name:Multiply200
	float4 Multiply200 = CarReceivesDirt * CarLOD4;
	
	// Type:OneMinusNode, Name:OneMinus1
	float4 OneMinus1 = 1 - Multiply200;
	
	// Type:FloatNode, Name:Float70
	float4 Float70 = float4(0.175, 0.175, 0.175, 0.175);
	
	// Type:FloatNode, Name:Float80
	float4 Float80 = float4(0.4, 0.4, 0.4, 0.4);
	
	// Type:SwizzleNode, Name:Swizzle4
	float4 Swizzle4 = SplatterY.yyyy;
	
	// Type:SwizzleNode, Name:Swizzle50
	float4 Swizzle50 = SplatterY.xxxx;
	
	// Type:SwizzleNode, Name:Swizzle10
	float4 Swizzle10 = CarSplatterMaskTexture.zzzz;
	
	// Type:LerpNode, Name:Lerp40
	float4 Lerp40 = lerp(Swizzle4, Swizzle50, Swizzle10.x);
	
	// Type:StepNode, Name:Step0
	float4 Step0 = linearstep( Float70, Float80, Lerp40 );
	
	// Type:FloatNode, Name:Float90
	float4 Float90 = float4(1, 1, 1, 1);
	
	// Type:CarOilAmountNode, Name:CarOilAmount
	float4 CarOilAmount = GetOilAmount().xxxx;
	
	// Type:SubstractNode, Name:Substract
	float4 Substract = Float90 - CarOilAmount;
	
	// Type:FloatNode, Name:Float100
	float4 Float100 = float4(1.001, 1.001, 1.001, 1.001);
	
	// Type:SubstractNode, Name:Substract0
	float4 Substract0 = Float100 - CarOilAmount;
	
	// Type:SwizzleNode, Name:Swizzle00
	float4 Swizzle00 = CarSplatterMaskTexture.yyyy;
	
	// Type:MultiplyNode, Name:Multiply201
	float4 Multiply201 = Swizzle00 * Swizzle3;
	
	// Type:MultiplyNode, Name:Multiply9
	float4 Multiply9 = Multiply201 * Swizzle6;
	
	// Type:StepNode, Name:Step10
	float4 Step10 = linearstep( Substract, Substract0, Multiply9 );
	
	// Type:MultiplyNode, Name:Multiply5
	float4 Multiply5 = Step0 * Step10;
	
	// Type:FloatNode, Name:Float10
	float4 Float10 = float4(0, 0, 0, 0);
	
	// Type:CarReceivesOilNode, Name:CarReceivesOil
	float4 CarReceivesOil;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesOil = Float10;
	#else
	[branch]
	if (ReceivesOil())
	{
		CarReceivesOil = Multiply5;
	}
	else
	{
		CarReceivesOil = Float10;
	}
	#endif
	
	// Type:FloatNode, Name:Float18
	float4 Float18 = float4(0, 0, 0, 0);
	
	// Type:CarLODNode, Name:CarLOD20
	float4 CarLOD20;
	[branch]
	if (GetLODLessThanOrEqual(2) )
	{
		CarLOD20 = CarReceivesOil;
	}
	else
	{
		CarLOD20 = Float18;
	}
	
	// Type:OneMinusNode, Name:OneMinus
	float4 OneMinus = 1 - CarLOD20;
	
	// Type:MultiplyNode, Name:Multiply14
	float4 Multiply14 = OneMinus1 * OneMinus;
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = Lerp9 * Multiply14;
	
	// Type:NormalMapWithIntensityNode, Name:Normal
	float4 textureLookup_Normal = Normal_Texture.Sample(g_samplerLinearWrap, GetTexCoord0(In).xy * Normal_Tiling);
	#ifdef _MAX_
	textureLookup_Normal.xyz = pow(textureLookup_Normal.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_Normal = (2.0f * textureLookup_Normal.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_Normal, NormalSpecPower);
	float4 NormalAlpha = textureLookup_Normal.aaaa;
	float4 NormalRed = textureLookup_Normal.rrrr;
	float4 NormalGreen = textureLookup_Normal.gggg;
	float4 NormalBlue = textureLookup_Normal.bbbb;
	tangentSpaceNormal_Normal.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_Normal.z = sqrt(saturate(1 - tangentSpaceNormal_Normal.x*tangentSpaceNormal_Normal.x - tangentSpaceNormal_Normal.y*tangentSpaceNormal_Normal.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_Normal.xy *= g_GlobalNormalScale * Normal_HeightScale.x;
	#else
	tangentSpaceNormal_Normal.xy *= Normal_HeightScale.x;
	#endif
	float4 Normal = float4(normalize(mul(tangentSpaceNormal_Normal, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 Normal = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:FloatNode, Name:Float12
	float4 Float12 = float4(1, 1, 1, 1);
	
	// Type:OnOffNode, Name:CH1NormalMapSwitch
	float4 CH1NormalMapSwitch;
	float4 CH1NormalMapSwitchOutput2;
	[branch]
	if(CH1NormalMapSwitchBool == true)
	{
		CH1NormalMapSwitch = Normal;
		CH1NormalMapSwitchOutput2 = NormalGlossScalar;
	}
	else
	{
		CH1NormalMapSwitch = WorldNormal;
		CH1NormalMapSwitchOutput2 = Float12;
	}
	
	// Type:CarDamageAmountNode, Name:CarDamageAmount
	float4 CarDamageAmount = GetDamageAmount(In).xxxx;
	
	// Type:CarReceivesDamageNode, Name:CarReceivesDamage0
	float4 CarReceivesDamage0;
	#if ENABLE_DAMAGE == 0 && !defined(PREVIEW_DAMAGE_VALUES)
	CarReceivesDamage0 = Float9;
	#else
	[branch]
	if (ReceivesDamage())
	{
		CarReceivesDamage0 = CarDamageAmount;
	}
	else
	{
		CarReceivesDamage0 = Float9;
	}
	#endif
	
	// Type:LerpNode, Name:Lerp70
	float4 Lerp70 = lerp(CH1NormalMapSwitch, NormalMapWithIntensity, CarReceivesDamage0.x);
	
	// Type:FloatNode, Name:Float0
	float4 Float0 = float4(0.45, 0.45, 0.45, 0.45);
	
	// Type:ClampNode, Name:Clamp
	float4 Clamp = Lerp20;
	Clamp = max(Clamp, Float0);
	
	// Type:F0ValuesNode, Name:F0b
	float4 F0b = F0bVector4;
	
	// Type:ViewVectorNode, Name:ViewVector0
	float4 ViewVector0 = float4(GetViewVector(), 0);
	// Type:NegateNode, Name:Negate
	float4 Negate = -1.0f * ViewVector0;
	
	// Type:ReflectNode, Name:Reflect
	float4 Reflect = reflect(Negate,Lerp70);
	
	// Type:WorldToTangentSpaceNode, Name:WorldToTangentSpace
	float4 WorldToTangentSpace = float4(normalize(mul(Reflect, transpose(float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz)))), 0);
	
	// Type:SwizzleNode, Name:Swizzle000
	float4 Swizzle000 = WorldToTangentSpace.yzzw;
	
	// Type:TextureNode, Name:Reflected_RTint
	float4 Reflected_RTint = Reflected_RTint_Texture.Sample(g_samplerLinearWrap, Swizzle000.xy * Reflected_RTint_Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Reflected_RTintMip = GetDebugMipColour(Reflected_RTint_Texture, g_samplerLinearWrap, Swizzle000.xy * Reflected_RTint_Tiling);
	#else
	float4 Reflected_RTintMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Reflected_RTintAlpha = Reflected_RTint.aaaa;
	float4 Reflected_RTintRed = Reflected_RTint.rrrr;
	float4 Reflected_RTintGreen = Reflected_RTint.gggg;
	float4 Reflected_RTintBlue = Reflected_RTint.bbbb;
	Texture2D Reflected_RTintRef = Reflected_RTint_Texture;
	
	// Type:F0ValuesNode, Name:F0a
	float4 F0a = F0aVector4;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = Reflected_RTint * F0a;
	
	// Type:TextureNode, Name:Gloss
	float4 Gloss = Gloss_Texture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * Gloss_Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 GlossMip = GetDebugMipColour(Gloss_Texture, g_samplerLinearWrap, GetTexCoord0(In) * Gloss_Tiling);
	#else
	float4 GlossMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 GlossAlpha = Gloss.aaaa;
	float4 GlossRed = Gloss.rrrr;
	float4 GlossGreen = Gloss.gggg;
	float4 GlossBlue = Gloss.bbbb;
	Texture2D GlossRef = Gloss_Texture;
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(F0b, Multiply0, Gloss.x);
	
	// Type:OnOffNode, Name:CH1F0MaskSwitch
	float4 CH1F0MaskSwitch;
	float4 CH1F0MaskSwitchOutput2;
	[branch]
	if(CH1F0MaskSwitchBool == true)
	{
		CH1F0MaskSwitch = Lerp0;
		CH1F0MaskSwitchOutput2 = float4(1, 1, 1, 1);
	}
	else
	{
		CH1F0MaskSwitch = Multiply0;
		CH1F0MaskSwitchOutput2 = float4(1, 1, 1, 1);
	}
	
	// Type:F0ValuesNode, Name:LiveryDustOilF0
	float4 LiveryDustOilF0 = float4(0.04, 0.04, 0.04, 1) ;
	
	// Type:ClampNode, Name:Clamp0
	float4 Clamp0 = Multiply8;
	Clamp0 = max(Clamp0, Multiply200);
	
	// Type:ClampNode, Name:Clamp1
	float4 Clamp1 = Clamp0;
	Clamp1 = max(Clamp1, CarLOD20);
	
	// Type:LerpNode, Name:Lerp11
	float4 Lerp11 = lerp(CH1F0MaskSwitch, LiveryDustOilF0, Clamp1.x);
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = Clamp * Lerp11;
	
	// Type:GlossGroupNode, Name:GlossB
	float4 GlossB = GlossB_floatVal;
	
	// Type:GlossGroupNode, Name:GlossA
	float4 GlossA = GlossA_floatVal;
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(GlossB, GlossA, Gloss.x);
	
	// Type:OnOffNode, Name:CH1GlossMaskSwitch
	float4 CH1GlossMaskSwitch;
	float4 CH1GlossMaskSwitchOutput2;
	[branch]
	if(CH1GlossMaskSwitchBool == true)
	{
		CH1GlossMaskSwitch = Lerp;
		CH1GlossMaskSwitchOutput2 = float4(1, 1, 1, 1);
	}
	else
	{
		CH1GlossMaskSwitch = GlossA;
		CH1GlossMaskSwitchOutput2 = float4(1, 1, 1, 1);
	}
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = CH1GlossMaskSwitch * CH1NormalMapSwitchOutput2;
	
	// Type:ClampNode, Name:LiveryGlossClamp
	float4 LiveryGlossClamp = Multiply2;
	LiveryGlossClamp = max(LiveryGlossClamp, Multiply8);
	
	// Type:MultiplyNode, Name:ScrapeGloss
	float4 ScrapeGloss = LiveryGlossClamp * Clamp;
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(1, 1, 1, 1);
	
	// Type:CarLODNode, Name:CarLOD
	float4 CarLOD;
	[branch]
	if (GetLODLessThanOrEqual(-1) )
	{
		CarLOD = OneMinus1;
	}
	else
	{
		CarLOD = Float1;
	}
	
	// Type:MultiplyNode, Name:DirtMuliply
	float4 DirtMuliply = ScrapeGloss * CarLOD;
	
	// Type:ClampNode, Name:OilClamp
	float4 OilClamp = DirtMuliply;
	OilClamp = max(OilClamp, CarLOD20);
	
	// Type:TextureNode, Name:LocalAO
	float4 LocalAO = LocalAO_Texture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * LocalAO_Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 LocalAOMip = GetDebugMipColour(LocalAO_Texture, g_samplerLinearWrap, GetTexCoord0(In) * LocalAO_Tiling);
	#else
	float4 LocalAOMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 LocalAOAlpha = LocalAO.aaaa;
	float4 LocalAORed = LocalAO.rrrr;
	float4 LocalAOGreen = LocalAO.gggg;
	float4 LocalAOBlue = LocalAO.bbbb;
	Texture2D LocalAORef = LocalAO_Texture;
	
	// Type:FloatNode, Name:Float4
	float4 Float4 = float4(1, 1, 1, 1);
	
	// Type:OnOffNode, Name:CH1LocalAOSwitch
	float4 CH1LocalAOSwitch;
	float4 CH1LocalAOSwitchOutput2;
	[branch]
	if(CH1LocalAOSwitchBool == true)
	{
		CH1LocalAOSwitch = LocalAO;
		CH1LocalAOSwitchOutput2 = float4(1, 1, 1, 1);
	}
	else
	{
		CH1LocalAOSwitch = Float4;
		CH1LocalAOSwitchOutput2 = float4(1, 1, 1, 1);
	}
	
	// Type:TextureNode, Name:Alpha
	float4 Alpha = Alpha_Texture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * Alpha_Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AlphaMip = GetDebugMipColour(Alpha_Texture, g_samplerLinearWrap, GetTexCoord0(In) * Alpha_Tiling);
	#else
	float4 AlphaMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AlphaAlpha = Alpha.aaaa;
	float4 AlphaRed = Alpha.rrrr;
	float4 AlphaGreen = Alpha.gggg;
	float4 AlphaBlue = Alpha.bbbb;
	Texture2D AlphaRef = Alpha_Texture;
	
	// Type:FloatNode, Name:Float6
	float4 Float6 = float4(1, 1, 1, 1);
	
	// Type:OnOffNode, Name:CH1OpacityMaskSwitch
	float4 CH1OpacityMaskSwitch;
	float4 CH1OpacityMaskSwitchOutput2;
	[branch]
	if(CH1OpacityMaskSwitchBool == true)
	{
		CH1OpacityMaskSwitch = Alpha;
		CH1OpacityMaskSwitchOutput2 = float4(1, 1, 1, 1);
	}
	else
	{
		CH1OpacityMaskSwitch = Float6;
		CH1OpacityMaskSwitchOutput2 = float4(1, 1, 1, 1);
	}
	
	output.DiffuseColor = Multiply1;
	output.Normal = Lerp70;
	output.F0 = Multiply3;
	output.Glossiness = OilClamp;
	output.AmbientOcclusion = CH1LocalAOSwitch;
	#if IN_MATERIAL_EDITOR
	if (!forVertex) clip(CH1OpacityMaskSwitch.x - ALPHATEST_MIN);
	#else
	#if ENABLE_ALPHA_TEST && IS_ALPHA_TESTED
	if (!forVertex && g_EnableAlphaTest) clip(CH1OpacityMaskSwitch.x - ALPHATEST_MIN);
	#endif
	#endif
	output.AlphaTest = CH1OpacityMaskSwitch;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\CarShadowDepthLightScenario.hlsl"