#include "LightScenarios\Inc\ShadowDepthLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 DiffuseATiling < string UIName = "DiffuseATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 EmissiveTiling < string UIName = "EmissiveTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float ExposureEV_floatVal < string UIName = "ExposureEV_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.001375 ;
float F0_floatVal < string UIName = "F0_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.04 ;
float GIScale_floatVal < string UIName = "GIScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LightSwitchOnEnd_floatVal < string UIName = "LightSwitchOnEnd_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LightSwitchOnStart_floatVal < string UIName = "LightSwitchOnStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float NormalMapSpecPower < string UIName = "NormalMapSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalMapTiling < string UIName = "NormalMapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 RoughnessTiling < string UIName = "RoughnessTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define F0_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].x)
	#else
	float F0_floatVal : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ExposureEV_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].y)
	#else
	float ExposureEV_floatVal : packoffset(c0.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].z)
	#else
	float LightSwitchOnStart_floatVal : packoffset(c0.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnEnd_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].w)
	#else
	float LightSwitchOnEnd_floatVal : packoffset(c0.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GIScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].x)
	#else
	float GIScale_floatVal : packoffset(c1.x);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const float2 DiffuseATiling = float2(1, 1);
static const float NormalMapSpecPower = 100;
static const float2 NormalMapTiling = float2(1, 1);
static const float2 RoughnessTiling = float2(1, 1);
static const float2 EmissiveTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStatesSampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(DiffuseATexture, 16);
#else
#define DiffuseATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(EmissiveTexture, 17);
#else
#define EmissiveTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapTexture, 18);
#else
#define NormalMapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(RoughnessTexture, 19);
#else
#define RoughnessTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Transmissiveness 1
#define MATERIAL_HAS_INPUT_TransmissiveFuzziness 1
#define MATERIAL_HAS_INPUT_TransmissiveControl 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_LightmapAdditive 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_INPUT_IS_USED_GIScale 1
#define MATERIAL_HAS_INPUT_MinimumWind 1
#define MATERIAL_HAS_INPUT_AnimationPivot 1
#define MATERIAL_HAS_INPUT_AnimationSpeed 1
#define MATERIAL_HAS_INPUT_TranslateSpeed 1
#define MATERIAL_HAS_INPUT_RotateSpeed 1
#define MATERIAL_HAS_INPUT_Translate 1
#define MATERIAL_HAS_INPUT_Rotate 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
#define MATERIAL_HAS_INPUT_SnowSpecTexture 1
#define MATERIAL_HAS_INPUT_SnowAmount 1
#define MATERIAL_HAS_INPUT_FrostAmount 1
#define MATERIAL_HAS_INPUT_TwinkleAmount 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BlinnPhongAlpha.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStatesSampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:DiffuseA
	float4 DiffuseA = DiffuseATexture.Sample(SamplerStatesSampler, GetTexCoord0(In) * DiffuseATiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 DiffuseAMip = GetDebugMipColour(DiffuseATexture, SamplerStatesSampler, GetTexCoord0(In) * DiffuseATiling);
	#else
	float4 DiffuseAMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 DiffuseAAlpha = DiffuseA.aaaa;
	float4 DiffuseARed = DiffuseA.rrrr;
	float4 DiffuseAGreen = DiffuseA.gggg;
	float4 DiffuseABlue = DiffuseA.bbbb;
	Texture2D DiffuseARef = DiffuseATexture;
	
	// Type:NormalMapNode, Name:NormalMap
	float4 textureLookup_NormalMap = NormalMapTexture.Sample(SamplerStatesSampler, GetTexCoord0(In).xy * NormalMapTiling);
	#ifdef _MAX_
	textureLookup_NormalMap.xyz = pow(textureLookup_NormalMap.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMap = (2.0f * textureLookup_NormalMap.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMap, NormalMapSpecPower);
	float4 NormalMapAlpha = textureLookup_NormalMap.aaaa;
	float4 NormalMapRed = textureLookup_NormalMap.rrrr;
	float4 NormalMapGreen = textureLookup_NormalMap.gggg;
	float4 NormalMapBlue = textureLookup_NormalMap.bbbb;
	tangentSpaceNormal_NormalMap.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMap.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMap.x*tangentSpaceNormal_NormalMap.x - tangentSpaceNormal_NormalMap.y*tangentSpaceNormal_NormalMap.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMap.xy *= g_GlobalNormalScale;
	#endif
	float4 NormalMap = float4(normalize(mul(tangentSpaceNormal_NormalMap, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMap = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:FloatNode, Name:F0
	float4 F0 = F0_floatVal;
	
	// Type:TextureNode, Name:Roughness
	float4 Roughness = RoughnessTexture.Sample(SamplerStatesSampler, GetTexCoord0(In) * RoughnessTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 RoughnessMip = GetDebugMipColour(RoughnessTexture, SamplerStatesSampler, GetTexCoord0(In) * RoughnessTiling);
	#else
	float4 RoughnessMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 RoughnessAlpha = Roughness.aaaa;
	float4 RoughnessRed = Roughness.rrrr;
	float4 RoughnessGreen = Roughness.gggg;
	float4 RoughnessBlue = Roughness.bbbb;
	Texture2D RoughnessRef = RoughnessTexture;
	
	// Type:ExposureValuesGroupNode, Name:ExposureEV
	float4 ExposureEV = ExposureEV_floatVal;
	
	// Type:TextureNode, Name:Emissive
	float4 Emissive = EmissiveTexture.Sample(SamplerStatesSampler, GetTexCoord0(In) * EmissiveTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 EmissiveMip = GetDebugMipColour(EmissiveTexture, SamplerStatesSampler, GetTexCoord0(In) * EmissiveTiling);
	#else
	float4 EmissiveMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 EmissiveAlpha = Emissive.aaaa;
	float4 EmissiveRed = Emissive.rrrr;
	float4 EmissiveGreen = Emissive.gggg;
	float4 EmissiveBlue = Emissive.bbbb;
	Texture2D EmissiveRef = EmissiveTexture;
	
	// Type:MultiplyNode, Name:EmissiveMultiply
	float4 EmissiveMultiply = ExposureEV * Emissive;
	
	// Type:FloatNode, Name:LightSwitchOnStart
	float4 LightSwitchOnStart = LightSwitchOnStart_floatVal;
	
	// Type:FloatNode, Name:LightSwitchOnEnd
	float4 LightSwitchOnEnd = LightSwitchOnEnd_floatVal;
	
	// Type:FloatNode, Name:GIScale
	float4 GIScale = GIScale_floatVal;
	
	output.BaseColor = DiffuseA;
	output.Normal = NormalMap;
	output.F0 = F0;
	output.Roughness = Roughness;
	output.Emissive = EmissiveMultiply;
	output.LightSwitchOnStart = LightSwitchOnStart;
	output.LightSwitchOnEnd = LightSwitchOnEnd;
	output.GIScale = GIScale;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\ShadowDepthLightScenario.hlsl"