#include "LightScenarios\Inc\ShadowDepthLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 DiffuseATiling < string UIName = "DiffuseATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define DiffuseATiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].xy))
	#else
	float2 DiffuseATiling : packoffset(c0.x);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(DiffuseATexture, 16);
#else
#define DiffuseATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_Glossiness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:TextureNode, Name:DiffuseA
	float4 DiffuseA = DiffuseATexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * DiffuseATiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 DiffuseAMip = GetDebugMipColour(DiffuseATexture, g_samplerLinearWrap, GetTexCoord0(In) * DiffuseATiling);
	#else
	float4 DiffuseAMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 DiffuseAAlpha = DiffuseA.aaaa;
	float4 DiffuseARed = DiffuseA.rrrr;
	float4 DiffuseAGreen = DiffuseA.gggg;
	float4 DiffuseABlue = DiffuseA.bbbb;
	Texture2D DiffuseARef = DiffuseATexture;
	
	output.DiffuseColor = DiffuseA;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\ShadowDepthLightScenario.hlsl"