#include "LightScenarios\Inc\CubemapLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float AOToCavityMapStrength < string UIName = "AOToCavityMapStrength"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 LocalModulateVector4 < string UIName = "LocalModulateVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 1, 1 );
float4 Micro2NormalTiling < string UIName = "Micro2NormalTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 5, 5, 0, 0 );
float MicroDiffuse01Strength_floatVal < string UIName = "MicroDiffuse01Strength_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.2 ;
float MicroDiffuse02Strength_floatVal < string UIName = "MicroDiffuse02Strength_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.2 ;
float4 MicroNormalTiling < string UIName = "MicroNormalTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 5, 5, 0, 0 );
float4 ModulateBlendBlendMapOffset < string UIName = "ModulateBlendBlendMapOffset"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0, 0, 0, 0 );
float4 ModulateBlendBlendMapScale < string UIName = "ModulateBlendBlendMapScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float ModulateBlendTM_Max < string UIName = "ModulateBlendTM_Max"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.5 ;
float ModulateBlendTM_Multiplier < string UIName = "ModulateBlendTM_Multiplier"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.3210145 ;
int MultiChoiceNormalBlend0NormalBlendModes < string UIName = "MultiChoiceNormalBlend0NormalBlendModes"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
bool Step1Bool < string UIName = "Step1Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step1HardStepBool < string UIName = "Step1HardStepBool"; string UIWidget = "Checkbox"; > = 0;
int TangentToWorldSpace0UVSet < string UIName = "TangentToWorldSpace0UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int TrackParameterTrackParam < string UIName = "TrackParameterTrackParam"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
float4 TwinkleTiling < string UIName = "TwinkleTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float UberRockBlendBlendHeightScale < string UIName = "UberRockBlendBlendHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 4 ;
float UberRockBlendBlendRamp < string UIName = "UberRockBlendBlendRamp"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 UberRockTextureSetAUVTiling < string UIName = "UberRockTextureSetAUVTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 UberRockTextureSetBUVTiling < string UIName = "UberRockTextureSetBUVTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 UberRockTextureSetCUVTiling < string UIName = "UberRockTextureSetCUVTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float UberRockWaterTideMarkAOEffect < string UIName = "UberRockWaterTideMarkAOEffect"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float UberRockWaterTideMarkBlendAmount < string UIName = "UberRockWaterTideMarkBlendAmount"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.2 ;
float UberRockWaterTideMarkDarkenAmount < string UIName = "UberRockWaterTideMarkDarkenAmount"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.4 ;
float UberRockWaterTideMarkDarkenOffset < string UIName = "UberRockWaterTideMarkDarkenOffset"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.4 ;
float UberRockWaterTideMarkSaturationAmount < string UIName = "UberRockWaterTideMarkSaturationAmount"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.8 ;
float UpBlendMaxUpAngle < string UIName = "UpBlendMaxUpAngle"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 80 ;
float UpBlendMinUpAngle < string UIName = "UpBlendMinUpAngle"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 54 ;
int UV0UVSet < string UIName = "UV0UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int UVMicroUVSet < string UIName = "UVMicroUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Blend2 < string UIName = "VariantConstant_Blend2"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Frost < string UIName = "VariantConstant_Frost"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Micro2Normal < string UIName = "VariantConstant_Micro2Normal"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_MicroNormal < string UIName = "VariantConstant_MicroNormal"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Modulate < string UIName = "VariantConstant_Modulate"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_UpBlend < string UIName = "VariantConstant_UpBlend"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
bool Variation0FullColor < string UIName = "Variation0FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation0VariationIndex < string UIName = "Variation0VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
bool VariationFullColor < string UIName = "VariationFullColor"; string UIWidget = "Checkbox"; > = 0;
int VariationVariationIndex < string UIName = "VariationVariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 WorldSpaceUVsTiling < string UIName = "WorldSpaceUVsTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.2, 0.2, 0, 0 );
int WorldToTangentSpaceUVSet < string UIName = "WorldToTangentSpaceUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define LocalModulateVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 LocalModulateVector4 : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ModulateBlendBlendMapOffset ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 ModulateBlendBlendMapOffset : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ModulateBlendBlendMapScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].xy))
	#else
	float2 ModulateBlendBlendMapScale : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Micro2NormalTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].zw))
	#else
	float2 Micro2NormalTiling : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MicroNormalTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].xy))
	#else
	float2 MicroNormalTiling : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ModulateBlendTM_Max (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float ModulateBlendTM_Max : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UpBlendMinUpAngle (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].y)
	#else
	float UpBlendMinUpAngle : packoffset(c4.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UpBlendMaxUpAngle (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].z)
	#else
	float UpBlendMaxUpAngle : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberRockBlendBlendHeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].w)
	#else
	float UberRockBlendBlendHeightScale : packoffset(c4.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberRockBlendBlendRamp (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)
	#else
	float UberRockBlendBlendRamp : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MicroDiffuse02Strength_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)
	#else
	float MicroDiffuse02Strength_floatVal : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MicroDiffuse01Strength_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)
	#else
	float MicroDiffuse01Strength_floatVal : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberRockWaterTideMarkAOEffect (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)
	#else
	float UberRockWaterTideMarkAOEffect : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberRockWaterTideMarkBlendAmount (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)
	#else
	float UberRockWaterTideMarkBlendAmount : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberRockWaterTideMarkDarkenOffset (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].y)
	#else
	float UberRockWaterTideMarkDarkenOffset : packoffset(c6.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberRockWaterTideMarkDarkenAmount (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].z)
	#else
	float UberRockWaterTideMarkDarkenAmount : packoffset(c6.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberRockWaterTideMarkSaturationAmount (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].w)
	#else
	float UberRockWaterTideMarkSaturationAmount : packoffset(c6.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AOToCavityMapStrength (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].x)
	#else
	float AOToCavityMapStrength : packoffset(c7.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Blend2 ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].x)))
	#else
	int VariantConstant_Blend2 : packoffset(c8.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UpBlend ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].y)))
	#else
	int VariantConstant_UpBlend : packoffset(c8.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_MicroNormal ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].z)))
	#else
	int VariantConstant_MicroNormal : packoffset(c8.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Micro2Normal ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].w)))
	#else
	int VariantConstant_Micro2Normal : packoffset(c8.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Modulate ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].x)))
	#else
	int VariantConstant_Modulate : packoffset(c9.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Frost ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].y)))
	#else
	int VariantConstant_Frost : packoffset(c9.y);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int TrackParameterTrackParam = 3;
static const float ModulateBlendTM_Multiplier = 0.3210145;
static const int VariationVariationIndex = 0;
static const bool VariationFullColor = false;
static const float2 WorldSpaceUVsTiling = float2(0.2, 0.2);
static const float2 UberRockTextureSetCUVTiling = float2(1, 1);
static const int UV0UVSet = 0;
static const float2 UberRockTextureSetAUVTiling = float2(1, 1);
static const float2 UberRockTextureSetBUVTiling = float2(1, 1);
static const int UVMicroUVSet = 1;
static const int Variation0VariationIndex = 1;
static const bool Variation0FullColor = false;
static const int WorldToTangentSpaceUVSet = 0;
static const int MultiChoiceNormalBlend0NormalBlendModes = 2;
static const int TangentToWorldSpace0UVSet = 0;
static const bool Step1Bool = false;
static const bool Step1HardStepBool = false;
static const float2 TwinkleTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(DiffuseSamplerStatesSampler, 12);
DECLARE_SAMPLERSTATE(NormalSamplerStates0Sampler, 13);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Micro2NormalTexture, 16);
#else
#define Micro2NormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MicroNormalTexture, 17);
#else
#define MicroNormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(ModulateBlendTexture, 18);
#else
#define ModulateBlendTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TwinkleTexture, 19);
#else
#define TwinkleTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberRockTextureSetAAOTexture, 20);
#else
#define UberRockTextureSetAAOTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberRockTextureSetADiffuseTexture, 21);
#else
#define UberRockTextureSetADiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberRockTextureSetANormalTexture, 22);
#else
#define UberRockTextureSetANormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(6)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberRockTextureSetBAOTexture, 23);
#else
#define UberRockTextureSetBAOTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(7)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberRockTextureSetBDiffuseTexture, 24);
#else
#define UberRockTextureSetBDiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(8)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberRockTextureSetBNormalTexture, 25);
#else
#define UberRockTextureSetBNormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(9)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberRockTextureSetCAOTexture, 26);
#else
#define UberRockTextureSetCAOTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(10)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberRockTextureSetCDiffuseTexture, 27);
#else
#define UberRockTextureSetCDiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(11)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberRockTextureSetCNormalTexture, 28);
#else
#define UberRockTextureSetCNormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(12)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_TerrainTransmissivness 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_LightmapAdditive 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_INPUT_IS_USED_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_INPUT_IS_USED_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_INPUT_IS_USED_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_SnowSpecTexture 1
#define MATERIAL_INPUT_IS_USED_SnowSpecTexture 1
#define MATERIAL_HAS_INPUT_SnowAmount 1
#define MATERIAL_INPUT_IS_USED_SnowAmount 1
#define MATERIAL_HAS_INPUT_FrostAmount 1
#define MATERIAL_INPUT_IS_USED_FrostAmount 1
#define MATERIAL_HAS_INPUT_TwinkleAmount 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"
#include "TrackConstantBuffer.hlsl"
#include "TerrainModulation.hlsl"
#include "UberRock.hlsl"
#include "NormalMapping.hlsl"
#include "Blend.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:TrackParameterNode, Name:TrackParameter
	// DX12 binding strategies currently don't support track params in these light scenarios
	
	#if defined(IS_WHEEL_BLUR_SCENARIO) || defined(CAR_LIGHTING_SCENARIO)
	float4 TrackParameter = float4(1.0, 1.0, 0.0, 1.0);
	#else
	float4 TrackParameter = g_TrackParams[min(NUM_TRACKPARAMS_SLOTS - 1, TrackParameterTrackParam)];
	#endif
	
	// Type:FloatNode, Name:Float2
	float4 Float2 = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:Vector4Node, Name:LocalModulate
	float4 LocalModulate = LocalModulateVector4;
	
	// Type:SwizzleNode, Name:Swizzle3
	float4 Swizzle3 = LocalModulate.xxxx;
	
	// Type:ModulateBlendNode, Name:ModulateBlend
	float2 ModulateBlendUV = GetModulationUV( GetWorldPos(In).xyz );
	float4 ModulateBlendTex = ModulateBlendTexture.Sample(g_samplerLinearWrap, ModulateBlendUV);
	float4 ModulateBlendVec = float4(0.5, 0.5, 0.5, 0.5);
	float4 ModulateBlendLerp = lerp(ModulateBlendVec, ModulateBlendTex, ModulateBlendTM_Max);
	float4 ModulateBlendModulate = ModulateBlendLerp;
	float4 ModulateBlendModulateTexture = ModulateBlendTex;
	
	// Type:VariationNode, Name:Variation
	float4 Variation = GetInstanceVariation(In)[0];
	
	// Type:LerpNode, Name:Lerp3
	float4 Lerp3 = lerp(Float2, ModulateBlendModulate, Variation.x);
	
	// Type:WorldSpaceUVs, Name:WorldSpaceUVs
	#ifdef _MAX_
	float4 WorldSpaceUVs = float4(GetWorldPos(In).x * WorldSpaceUVsTiling.x, GetWorldPos(In).y * WorldSpaceUVsTiling.y, GetWorldPos(In).x * WorldSpaceUVsTiling.x, GetWorldPos(In).y * WorldSpaceUVsTiling.y) * 0.05f;
	#else
	float4 WorldSpaceUVs = float4(GetWorldPos(In).x * WorldSpaceUVsTiling.x, GetWorldPos(In).z * WorldSpaceUVsTiling.y, GetWorldPos(In).x * WorldSpaceUVsTiling.x, GetWorldPos(In).z * WorldSpaceUVsTiling.y);
	#endif
	float4 WorldSpaceUVsTangent = float4(1, 0, 0, 1);
	// Type:SamplerStatesNode, Name:DiffuseSamplerStates
	SamplerState DiffuseSamplerStates = DiffuseSamplerStatesSampler;
	float4 DiffuseSamplerStatesPreview = float4(0,0,0,0);
	
	// Type:SamplerStatesNode, Name:NormalSamplerStates0
	SamplerState NormalSamplerStates0 = NormalSamplerStates0Sampler;
	float4 NormalSamplerStates0Preview = float4(0,0,0,0);
	
	// Type:UberRockTextureSet, Name:UberRockTextureSetC
	float2 UberRockTextureSetCuv = WorldSpaceUVs.xy;
	float4 UberRockTextureSetCtangent = WorldSpaceUVsTangent;
	float3 UberRockTextureSetCworldNormal = GetWorldNormal(In);
	float4 UberRockTextureSetCDiffuse = 0;
	float4 UberRockTextureSetCNormal = 0;
	float4 UberRockTextureSetCHeight = 0;
	float4 UberRockTextureSetCFrost = 0;
	float4 UberRockTextureSetCAO = 0;
	GetUberRockTextureSet(g_samplerLinearWrap, UberRockTextureSetCDiffuseTexture, g_samplerLinearWrap, UberRockTextureSetCNormalTexture, UberRockTextureSetCAOTexture, UberRockTextureSetCuv, UberRockTextureSetCtangent, UberRockTextureSetCworldNormal, UberRockTextureSetCUVTiling, UberRockTextureSetCDiffuse, UberRockTextureSetCNormal, UberRockTextureSetCHeight, UberRockTextureSetCFrost, UberRockTextureSetCAO);
	float4 UberRockTextureSetCRoughness = UberRockTextureSetCDiffuse.wwww;
	
	// Type:UVNode, Name:UV0
	float4 UV0 = GetTexCoord0(In).xyxy;
	float4 UV0Tangent = GetWorldTangent0(In);
	float4 UV0UCoord = GetTexCoord0(In).xxxx;
	float4 UV0VCoord = GetTexCoord0(In).yyyy;
	
	// Type:UberRockTextureSet, Name:UberRockTextureSetA
	float2 UberRockTextureSetAuv = UV0.xy;
	float4 UberRockTextureSetAtangent = UV0Tangent;
	float3 UberRockTextureSetAworldNormal = GetWorldNormal(In);
	float4 UberRockTextureSetADiffuse = 0;
	float4 UberRockTextureSetANormal = 0;
	float4 UberRockTextureSetAHeight = 0;
	float4 UberRockTextureSetAFrost = 0;
	float4 UberRockTextureSetAAO = 0;
	GetUberRockTextureSet(g_samplerLinearWrap, UberRockTextureSetADiffuseTexture, g_samplerLinearWrap, UberRockTextureSetANormalTexture, UberRockTextureSetAAOTexture, UberRockTextureSetAuv, UberRockTextureSetAtangent, UberRockTextureSetAworldNormal, UberRockTextureSetAUVTiling, UberRockTextureSetADiffuse, UberRockTextureSetANormal, UberRockTextureSetAHeight, UberRockTextureSetAFrost, UberRockTextureSetAAO);
	float4 UberRockTextureSetARoughness = UberRockTextureSetADiffuse.wwww;
	
	// Type:UberRockTextureSet, Name:UberRockTextureSetB
	float2 UberRockTextureSetBuv = UV0.xy;
	float4 UberRockTextureSetBtangent = UV0Tangent;
	float3 UberRockTextureSetBworldNormal = GetWorldNormal(In);
	float4 UberRockTextureSetBDiffuse = 0;
	float4 UberRockTextureSetBNormal = 0;
	float4 UberRockTextureSetBHeight = 0;
	float4 UberRockTextureSetBFrost = 0;
	float4 UberRockTextureSetBAO = 0;
	GetUberRockTextureSet(g_samplerLinearWrap, UberRockTextureSetBDiffuseTexture, g_samplerLinearWrap, UberRockTextureSetBNormalTexture, UberRockTextureSetBAOTexture, UberRockTextureSetBuv, UberRockTextureSetBtangent, UberRockTextureSetBworldNormal, UberRockTextureSetBUVTiling, UberRockTextureSetBDiffuse, UberRockTextureSetBNormal, UberRockTextureSetBHeight, UberRockTextureSetBFrost, UberRockTextureSetBAO);
	float4 UberRockTextureSetBRoughness = UberRockTextureSetBDiffuse.wwww;
	
	// Type:UpBlendNode, Name:UpBlend
	float4 UpBlend = (smoothstep(UpBlendMinUpAngle * 0.011111, UpBlendMaxUpAngle * 0.011111, GetWorldNormal(In).y)).xxxx;
	
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(0, 0, 0, 0);
	
	// Type:VariantOnOffNode, Name:Blend2OnOff3
	#if defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 1
	float4 Blend2OnOff3 = VertexColorRed;
	#elif defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 0
	float4 Blend2OnOff3 = Float;
	#elif !defined(VARIANTPROPERTY_BLEND2) || VARIANTPROPERTY_BLEND2 == 2
	float4 Blend2OnOff3;
	[branch]
	if(VariantConstant_Blend2 != 0)
	{
		Blend2OnOff3 = VertexColorRed;
	}
	else
	{
		Blend2OnOff3 = Float;
	}
	#endif
	
	// Type:VariantOnOffNode, Name:UpBlendOnOff40
	#if defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 1
	float4 UpBlendOnOff40 = VertexColorGreen;
	#elif defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 0
	float4 UpBlendOnOff40 = Float;
	#elif !defined(VARIANTPROPERTY_UPBLEND) || VARIANTPROPERTY_UPBLEND == 2
	float4 UpBlendOnOff40;
	[branch]
	if(VariantConstant_UpBlend != 0)
	{
		UpBlendOnOff40 = VertexColorGreen;
	}
	else
	{
		UpBlendOnOff40 = Float;
	}
	#endif
	
	// Type:MultiplyNode, Name:Multiply5
	float4 Multiply5 = UpBlendOnOff40 * UberRockTextureSetCHeight;
	
	// Type:UberRockBlend, Name:UberRockBlend
	float UberRockBlendheightA = UberRockTextureSetAHeight;
	float UberRockBlendheightB = UberRockTextureSetBHeight;
	float UberRockBlendupBlend = UpBlend;
	float4 UberRockBlendABlend = 0;
	float4 UberRockBlendBBlend = 0;
	float4 UberRockBlendCBlend = 0;
	GetUberRockBlendValues(UberRockTextureSetAHeight, UberRockTextureSetBHeight, UpBlend, Blend2OnOff3, Multiply5, UberRockBlendBlendHeightScale, UberRockBlendBlendRamp, UberRockBlendABlend, UberRockBlendBBlend, UberRockBlendCBlend);
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = UberRockTextureSetADiffuse * UberRockBlendABlend;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd
	float4 MultiplyAdd = UberRockTextureSetBDiffuse * UberRockBlendBBlend + Multiply1;
	
	// Type:VariantOnOffNode, Name:Blend2OnOff2
	#if defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 1
	float4 Blend2OnOff2 = MultiplyAdd;
	#elif defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 0
	float4 Blend2OnOff2 = Multiply1;
	#elif !defined(VARIANTPROPERTY_BLEND2) || VARIANTPROPERTY_BLEND2 == 2
	float4 Blend2OnOff2;
	[branch]
	if(VariantConstant_Blend2 != 0)
	{
		Blend2OnOff2 = MultiplyAdd;
	}
	else
	{
		Blend2OnOff2 = Multiply1;
	}
	#endif
	
	// Type:MultiplyAddNode, Name:MultiplyAdd0
	float4 MultiplyAdd0 = UberRockTextureSetCDiffuse * UberRockBlendCBlend + Blend2OnOff2;
	
	// Type:VariantOnOffNode, Name:UpBlendOnOff2
	#if defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 1
	float4 UpBlendOnOff2 = MultiplyAdd0;
	#elif defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 0
	float4 UpBlendOnOff2 = Blend2OnOff2;
	#elif !defined(VARIANTPROPERTY_UPBLEND) || VARIANTPROPERTY_UPBLEND == 2
	float4 UpBlendOnOff2;
	[branch]
	if(VariantConstant_UpBlend != 0)
	{
		UpBlendOnOff2 = MultiplyAdd0;
	}
	else
	{
		UpBlendOnOff2 = Blend2OnOff2;
	}
	#endif
	
	// Type:UVNode, Name:UVMicro
	float4 UVMicro = GetTexCoord1(In).xyxy;
	float4 UVMicroTangent = GetWorldTangent1(In);
	float4 UVMicroUCoord = GetTexCoord1(In).xxxx;
	float4 UVMicroVCoord = GetTexCoord1(In).yyyy;
	
	// Type:ObjectScaleNode, Name:ObjectScale
	float4 ObjectScale = GetMatrixScale(g_WorldMatrix);
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = UVMicro * ObjectScale;
	
	// Type:NormalMapOnlyNode, Name:Micro2Normal
	float4 Micro2Normal = Micro2NormalTexture.Sample(g_samplerLinearWrap, Multiply0.xy * Micro2NormalTiling);
	#ifdef _MAX_
	Micro2Normal.xyz = pow(Micro2Normal.xyz, 1 / 2.2);
	#endif
	float4 Micro2NormalGlossiness = Micro2Normal.bbbb;
	float4 Micro2NormalRed = Micro2Normal.rrrr;
	float4 Micro2NormalGreen = Micro2Normal.gggg;
	float4 Micro2NormalBlue = Micro2Normal.bbbb;
	float4 Micro2NormalAlpha = Micro2Normal.aaaa;
	Micro2Normal = DecodeNormalMap(Micro2Normal);
	
	// Type:VectorMake, Name:VectorMake0
	float4 VectorMake0 = float4(Micro2NormalAlpha.x, Micro2NormalAlpha.x, Micro2NormalAlpha.x, Micro2NormalGlossiness.x);
	
	// Type:Vector4Node, Name:Vector42
	float4 Vector42 = float4(0.5, 0.5, 0.5, 0.5) ;
	
	// Type:NormalMapOnlyNode, Name:MicroNormal
	float4 MicroNormal = MicroNormalTexture.Sample(g_samplerLinearWrap, Multiply0.xy * MicroNormalTiling);
	#ifdef _MAX_
	MicroNormal.xyz = pow(MicroNormal.xyz, 1 / 2.2);
	#endif
	float4 MicroNormalGlossiness = MicroNormal.bbbb;
	float4 MicroNormalRed = MicroNormal.rrrr;
	float4 MicroNormalGreen = MicroNormal.gggg;
	float4 MicroNormalBlue = MicroNormal.bbbb;
	float4 MicroNormalAlpha = MicroNormal.aaaa;
	MicroNormal = DecodeNormalMap(MicroNormal);
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(MicroNormalAlpha.x, MicroNormalAlpha.x, MicroNormalAlpha.x, MicroNormalGlossiness.x);
	
	// Type:VariantOnOffNode, Name:MicroNormalOnOff2
	#if defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 1
	float4 MicroNormalOnOff2 = VertexColorBlue;
	#elif defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 0
	float4 MicroNormalOnOff2 = Float;
	#elif !defined(VARIANTPROPERTY_MICRONORMAL) || VARIANTPROPERTY_MICRONORMAL == 2
	float4 MicroNormalOnOff2;
	[branch]
	if(VariantConstant_MicroNormal != 0)
	{
		MicroNormalOnOff2 = VertexColorBlue;
	}
	else
	{
		MicroNormalOnOff2 = Float;
	}
	#endif
	
	// Type:LerpNode, Name:Lerp50
	float4 Lerp50 = lerp(Vector42, VectorMake, MicroNormalOnOff2.x);
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(1, 1, 1, 1);
	
	// Type:VariantOnOffNode, Name:Micro2NormalOnOff
	#if defined(VARIANTPROPERTY_MICRO2NORMAL) && VARIANTPROPERTY_MICRO2NORMAL == 1
	float4 Micro2NormalOnOff = VertexColorAlpha;
	#elif defined(VARIANTPROPERTY_MICRO2NORMAL) && VARIANTPROPERTY_MICRO2NORMAL == 0
	float4 Micro2NormalOnOff = Float1;
	#elif !defined(VARIANTPROPERTY_MICRO2NORMAL) || VARIANTPROPERTY_MICRO2NORMAL == 2
	float4 Micro2NormalOnOff;
	[branch]
	if(VariantConstant_Micro2Normal != 0)
	{
		Micro2NormalOnOff = VertexColorAlpha;
	}
	else
	{
		Micro2NormalOnOff = Float1;
	}
	#endif
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(VectorMake0, Lerp50, Micro2NormalOnOff.x);
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(Lerp0, Vector42, UberRockBlendCBlend.x);
	
	// Type:FloatNode, Name:Float3
	float4 Float3 = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:SubstractNode, Name:Substract
	float4 Substract = Lerp - Float3;
	
	// Type:FloatNode, Name:MicroDiffuse02Strength
	float4 MicroDiffuse02Strength = MicroDiffuse02Strength_floatVal;
	
	// Type:FloatNode, Name:MicroDiffuse01Strength
	float4 MicroDiffuse01Strength = MicroDiffuse01Strength_floatVal;
	
	// Type:LerpNode, Name:Lerp2
	float4 Lerp2 = lerp(MicroDiffuse02Strength, MicroDiffuse01Strength, Micro2NormalOnOff.x);
	
	// Type:ObjectScaleNode, Name:ObjectScale0
	float4 ObjectScale0 = GetMatrixScale(g_WorldMatrix);
	
	// Type:SwizzleNode, Name:Swizzle0
	float4 Swizzle0 = ObjectScale0.zzzz;
	
	// Type:FloatNode, Name:Float4
	float4 Float4 = float4(0.125, 0.125, 0.125, 0.125);
	
	// Type:FloatNode, Name:Float5
	float4 Float5 = float4(0.875, 0.875, 0.875, 0.875);
	
	// Type:MultiplyAddNode, Name:MultiplyAdd3
	float4 MultiplyAdd3 = Swizzle0 * Float4 + Float5;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Lerp2 * MultiplyAdd3;
	
	// Type:SaturateNode, Name:Saturate0
	float4 Saturate0 = saturate( Multiply ); 
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = Substract * Saturate0;
	
	// Type:AddNode, Name:Add
	float4 Add = UpBlendOnOff2 + Multiply3;
	
	// Type:VariantOnOffNode, Name:MicroNormalOnOff
	#if defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 1
	float4 MicroNormalOnOff = Add;
	#elif defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 0
	float4 MicroNormalOnOff = UpBlendOnOff2;
	#elif !defined(VARIANTPROPERTY_MICRONORMAL) || VARIANTPROPERTY_MICRONORMAL == 2
	float4 MicroNormalOnOff;
	[branch]
	if(VariantConstant_MicroNormal != 0)
	{
		MicroNormalOnOff = Add;
	}
	else
	{
		MicroNormalOnOff = UpBlendOnOff2;
	}
	#endif
	
	// Type:OverlayBlendNode, Name:OverlayBlend01
	float4 OverlayBlend01 = 2.0 * Lerp3 * MicroNormalOnOff;
	float4 blendOverlayBlend01 = 1.0 - 2.0 * (1.0 - MicroNormalOnOff) * (1.0 - Lerp3);
	if (Lerp3.x > 0.5) OverlayBlend01.x = blendOverlayBlend01.x;
	if (Lerp3.y > 0.5) OverlayBlend01.y = blendOverlayBlend01.y;
	if (Lerp3.z > 0.5) OverlayBlend01.z = blendOverlayBlend01.z;
	saturate(OverlayBlend01);
	
	// Type:ViewDistanceNode, Name:ViewDistance
	float4 ViewDistance = distance(GetWorldPos(In).xyz, g_EyePos.xyz).xxxx;
	// Type:FloatNode, Name:ViewDist_mult
	float4 ViewDist_mult = float4(0.01, 0.01, 0.01, 0.01);
	
	// Type:FloatNode, Name:ViewDist_offset
	float4 ViewDist_offset = float4(-6, -6, -6, -6);
	
	// Type:MultiplyAddNode, Name:MultiplyAdd2
	float4 MultiplyAdd2 = ViewDistance * ViewDist_mult + ViewDist_offset;
	
	// Type:SaturateNode, Name:Saturate
	float4 Saturate = saturate( MultiplyAdd2 ); 
	
	// Type:LerpNode, Name:Modulate_DistanceFade
	float4 Modulate_DistanceFade = lerp(OverlayBlend01, MicroNormalOnOff, Saturate.x);
	
	// Type:VariantOnOffNode, Name:ModulateOnOff
	#if defined(VARIANTPROPERTY_MODULATE) && VARIANTPROPERTY_MODULATE == 1
	float4 ModulateOnOff = Modulate_DistanceFade;
	#elif defined(VARIANTPROPERTY_MODULATE) && VARIANTPROPERTY_MODULATE == 0
	float4 ModulateOnOff = MicroNormalOnOff;
	#elif !defined(VARIANTPROPERTY_MODULATE) || VARIANTPROPERTY_MODULATE == 2
	float4 ModulateOnOff;
	[branch]
	if(VariantConstant_Modulate != 0)
	{
		ModulateOnOff = Modulate_DistanceFade;
	}
	else
	{
		ModulateOnOff = MicroNormalOnOff;
	}
	#endif
	
	// Type:SwizzleNode, Name:Swizzle80
	float4 Swizzle80 = UpBlendOnOff2.wwww;
	
	// Type:SwizzleNode, Name:Swizzle8
	float4 Swizzle8 = Lerp.wwww;
	
	// Type:OverlayBlendNode, Name:OverlayBlend00
	float4 OverlayBlend00 = 2.0 * Swizzle80 * Swizzle8;
	float4 blendOverlayBlend00 = 1.0 - 2.0 * (1.0 - Swizzle8) * (1.0 - Swizzle80);
	if (Swizzle80.x > 0.5) OverlayBlend00.x = blendOverlayBlend00.x;
	if (Swizzle80.y > 0.5) OverlayBlend00.y = blendOverlayBlend00.y;
	if (Swizzle80.z > 0.5) OverlayBlend00.z = blendOverlayBlend00.z;
	saturate(OverlayBlend00);
	
	// Type:VariantOnOffNode, Name:MicroNormalOnOff1
	#if defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 1
	float4 MicroNormalOnOff1 = OverlayBlend00;
	#elif defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 0
	float4 MicroNormalOnOff1 = Swizzle80;
	#elif !defined(VARIANTPROPERTY_MICRONORMAL) || VARIANTPROPERTY_MICRONORMAL == 2
	float4 MicroNormalOnOff1;
	[branch]
	if(VariantConstant_MicroNormal != 0)
	{
		MicroNormalOnOff1 = OverlayBlend00;
	}
	else
	{
		MicroNormalOnOff1 = Swizzle80;
	}
	#endif
	
	// Type:WetifyNode, Name:Wetify
	float4 WetifyDiffuse = ModulateOnOff;
	float WetifyGloss = float(0);
	float WetifyRoughness = MicroNormalOnOff1;
	#ifdef _MAX_
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyGloss, float4(lerp(1.0, g_WetDiffuse, g_WetLevel), lerp(1.0, g_WetGloss, g_WetLevel), lerp(1.0, g_WetDiffuse, g_WetLevel), 0), float3(0,1,0), 1);
	#else
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyRoughness, TrackParameter, GetWorldNormal(In).xyz, float(1));
	#endif
	
	// Type:WorldPosNode, Name:WorldPos
	float4 WorldPos = float4(GetWorldPos(In).xyz, 1);
	// Type:MultiplyNode, Name:Multiply100
	float4 Multiply100 = UberRockTextureSetAAO * UberRockBlendABlend;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd10
	float4 MultiplyAdd10 = UberRockTextureSetBAO * UberRockBlendBBlend + Multiply100;
	
	// Type:VariantOnOffNode, Name:Blend2OnOff1
	#if defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 1
	float4 Blend2OnOff1 = MultiplyAdd10;
	#elif defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 0
	float4 Blend2OnOff1 = Multiply100;
	#elif !defined(VARIANTPROPERTY_BLEND2) || VARIANTPROPERTY_BLEND2 == 2
	float4 Blend2OnOff1;
	[branch]
	if(VariantConstant_Blend2 != 0)
	{
		Blend2OnOff1 = MultiplyAdd10;
	}
	else
	{
		Blend2OnOff1 = Multiply100;
	}
	#endif
	
	// Type:MultiplyAddNode, Name:MultiplyAdd000
	float4 MultiplyAdd000 = UberRockTextureSetCAO * UberRockBlendCBlend + Blend2OnOff1;
	
	// Type:VariantOnOffNode, Name:UpBlendOnOff0
	#if defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 1
	float4 UpBlendOnOff0 = MultiplyAdd000;
	#elif defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 0
	float4 UpBlendOnOff0 = Blend2OnOff1;
	#elif !defined(VARIANTPROPERTY_UPBLEND) || VARIANTPROPERTY_UPBLEND == 2
	float4 UpBlendOnOff0;
	[branch]
	if(VariantConstant_UpBlend != 0)
	{
		UpBlendOnOff0 = MultiplyAdd000;
	}
	else
	{
		UpBlendOnOff0 = Blend2OnOff1;
	}
	#endif
	
	// Type:VariationNode, Name:Variation0
	float4 Variation0 = GetInstanceVariation(In)[1];
	
	// Type:UberRockWaterTideMark, Name:UberRockWaterTideMark
	float4 UberRockWaterTideMarkDiffuse = 0;
	GetUberRockWaterTideMark(WetifyDiffuse, WorldPos, UpBlendOnOff0, Variation0, UberRockWaterTideMarkAOEffect, UberRockWaterTideMarkBlendAmount, UberRockWaterTideMarkDarkenOffset, UberRockWaterTideMarkDarkenAmount, UberRockWaterTideMarkSaturationAmount, UberRockWaterTideMarkDiffuse);
	
	// Type:FloatNode, Name:Float0
	float4 Float0 = float4(0, 0, 0, 0);
	
	// Type:VariantOnOffNode, Name:UpBlendOnOff000
	#if defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 1
	float4 UpBlendOnOff000 = UberRockBlendCBlend;
	#elif defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 0
	float4 UpBlendOnOff000 = Float0;
	#elif !defined(VARIANTPROPERTY_UPBLEND) || VARIANTPROPERTY_UPBLEND == 2
	float4 UpBlendOnOff000;
	[branch]
	if(VariantConstant_UpBlend != 0)
	{
		UpBlendOnOff000 = UberRockBlendCBlend;
	}
	else
	{
		UpBlendOnOff000 = Float0;
	}
	#endif
	
	// Type:LerpNode, Name:Lerp1
	float4 Lerp1 = lerp(UberRockWaterTideMarkDiffuse, MicroNormalOnOff, UpBlendOnOff000.x);
	
	// Type:MaxSwitch, Name:MaxSwitch
	    float4 MaxSwitch = Lerp1;
	#ifdef _MAX_
	    MaxSwitch = WetifyDiffuse;
	#endif
	
	// Type:MultiplyNode, Name:Multiply10
	float4 Multiply10 = UberRockTextureSetANormal * UberRockBlendABlend;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd1
	float4 MultiplyAdd1 = UberRockTextureSetBNormal * UberRockBlendBBlend + Multiply10;
	
	// Type:VariantOnOffNode, Name:Blend2OnOff0
	#if defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 1
	float4 Blend2OnOff0 = MultiplyAdd1;
	#elif defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 0
	float4 Blend2OnOff0 = Multiply10;
	#elif !defined(VARIANTPROPERTY_BLEND2) || VARIANTPROPERTY_BLEND2 == 2
	float4 Blend2OnOff0;
	[branch]
	if(VariantConstant_Blend2 != 0)
	{
		Blend2OnOff0 = MultiplyAdd1;
	}
	else
	{
		Blend2OnOff0 = Multiply10;
	}
	#endif
	
	// Type:MultiplyAddNode, Name:MultiplyAdd00
	float4 MultiplyAdd00 = UberRockTextureSetCNormal * UberRockBlendCBlend + Blend2OnOff0;
	
	// Type:VariantOnOffNode, Name:UpBlendOnOff1
	#if defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 1
	float4 UpBlendOnOff1 = MultiplyAdd00;
	#elif defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 0
	float4 UpBlendOnOff1 = Blend2OnOff0;
	#elif !defined(VARIANTPROPERTY_UPBLEND) || VARIANTPROPERTY_UPBLEND == 2
	float4 UpBlendOnOff1;
	[branch]
	if(VariantConstant_UpBlend != 0)
	{
		UpBlendOnOff1 = MultiplyAdd00;
	}
	else
	{
		UpBlendOnOff1 = Blend2OnOff0;
	}
	#endif
	
	// Type:WorldToTangentSpaceNode, Name:WorldToTangentSpace
	float4 WorldToTangentSpace = float4(normalize(mul(UpBlendOnOff1, transpose(float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz)))), 0);
	
	// Type:Vector4Node, Name:Vector41
	float4 Vector41 = float4(0, 0, 0, 0) ;
	
	// Type:LerpNode, Name:Lerp5
	float4 Lerp5 = lerp(Vector41, MicroNormal, MicroNormalOnOff2.x);
	
	// Type:LerpNode, Name:Lerp00
	float4 Lerp00 = lerp(Micro2Normal, Lerp5, Micro2NormalOnOff.x);
	
	// Type:LerpNode, Name:Lerp6
	float4 Lerp6 = lerp(Lerp00, Vector41, UberRockBlendCBlend.x);
	
	// Type:OneMinusNode, Name:OneMinus000
	float4 OneMinus000 = 1 - UberRockBlendCBlend;
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = OneMinus000 * MicroNormalOnOff2;
	
	// Type:OneMinusNode, Name:OneMinus
	float4 OneMinus = 1 - Micro2NormalOnOff;
	
	// Type:MaxNode, Name:Max
	float4 Max = max(Multiply2, OneMinus);
	
	// Type:MultiChoiceNormalBlendNode, Name:MultiChoiceNormalBlend0
	float4 MultiChoiceNormalBlend0 = NormalBlendFunction(WorldToTangentSpace, Lerp6, Max, NORMAL_WHITEOUTSIMPLE);
	
	// Type:TangentToWorldSpaceNode, Name:TangentToWorldSpace0
	float4 TangentToWorldSpace0 = float4(normalize(mul(MultiChoiceNormalBlend0, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	
	// Type:VariantOnOffNode, Name:MicroNormalOnOff0
	#if defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 1
	float4 MicroNormalOnOff0 = TangentToWorldSpace0;
	#elif defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 0
	float4 MicroNormalOnOff0 = UpBlendOnOff1;
	#elif !defined(VARIANTPROPERTY_MICRONORMAL) || VARIANTPROPERTY_MICRONORMAL == 2
	float4 MicroNormalOnOff0;
	[branch]
	if(VariantConstant_MicroNormal != 0)
	{
		MicroNormalOnOff0 = TangentToWorldSpace0;
	}
	else
	{
		MicroNormalOnOff0 = UpBlendOnOff1;
	}
	#endif
	
	// Type:LerpNode, Name:Lerp4
	float4 Lerp4 = lerp(WetifyRoughness, MicroNormalOnOff1, UpBlendOnOff000.x);
	
	// Type:FloatNode, Name:Float10
	float4 Float10 = float4(0.96, 0.96, 0.96, 0.96);
	
	// Type:FloatNode, Name:Float11
	float4 Float11 = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:Step1
	float4 Step1 = linearstep( Float10, Float11, MicroNormalOnOff1 );
	
	// Type:AOToCavityMap, Name:AOToCavityMap
	float4 AOToCavityMap = (saturate((1 / (1 + pow(2.71828, -(UpBlendOnOff0 - 0.46) * 5)) - 0.09) * 1.21));
	AOToCavityMap = AOToCavityMap * AOToCavityMapStrength + (1 - AOToCavityMapStrength);
	
	// Type:MultiplyNode, Name:Multiply11
	float4 Multiply11 = Step1 * AOToCavityMap;
	
	// Type:Vector4Node, Name:Vector4
	float4 Vector4 = float4(1, 0, 1, 1) ;
	
	// Type:DebugInputNode, Name:DebugInput
	float4 DebugInput = ModulateBlendModulateTexture;
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	if (true)
	{
		g_DebugInputValueA = DebugInput;
		if (!g_EnableDebugInputA)
		{
			DebugInput = float4(0.5f, 0.5f, 0.5f, 0.5f);
		}
	}
	#endif
	
	// Type:ColorNode, Name:Color
	float4 Color =  float4(0, 0, 0, 1) ;
	float4 ColorRed = 0;
	float4 ColorGreen = 0;
	float4 ColorBlue = 0;
	float4 ColorAlpha = 1;
	
	// Type:VariantOnOffNode, Name:ModulateOnOff0
	#if defined(VARIANTPROPERTY_MODULATE) && VARIANTPROPERTY_MODULATE == 1
	float4 ModulateOnOff0 = DebugInput;
	#elif defined(VARIANTPROPERTY_MODULATE) && VARIANTPROPERTY_MODULATE == 0
	float4 ModulateOnOff0 = Color;
	#elif !defined(VARIANTPROPERTY_MODULATE) || VARIANTPROPERTY_MODULATE == 2
	float4 ModulateOnOff0;
	[branch]
	if(VariantConstant_Modulate != 0)
	{
		ModulateOnOff0 = DebugInput;
	}
	else
	{
		ModulateOnOff0 = Color;
	}
	#endif
	
	// Type:TextureNodeLinear, Name:Twinkle
	float4 Twinkle = TwinkleTexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * TwinkleTiling);
	#ifdef _MAX_
	Twinkle.rgb = pow(Twinkle.rgb, 1 / 2.2);
	#endif
	float4 TwinkleAlpha = Twinkle.aaaa;
	Texture2D TwinkleRef = TwinkleTexture;
	
	// Type:MultiplyNode, Name:Multiply1000
	float4 Multiply1000 = UberRockTextureSetAFrost * UberRockBlendABlend;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd100
	float4 MultiplyAdd100 = UberRockTextureSetBFrost * UberRockBlendBBlend + Multiply1000;
	
	// Type:VariantOnOffNode, Name:Blend2OnOff10
	#if defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 1
	float4 Blend2OnOff10 = MultiplyAdd100;
	#elif defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 0
	float4 Blend2OnOff10 = Multiply1000;
	#elif !defined(VARIANTPROPERTY_BLEND2) || VARIANTPROPERTY_BLEND2 == 2
	float4 Blend2OnOff10;
	[branch]
	if(VariantConstant_Blend2 != 0)
	{
		Blend2OnOff10 = MultiplyAdd100;
	}
	else
	{
		Blend2OnOff10 = Multiply1000;
	}
	#endif
	
	// Type:MultiplyAddNode, Name:MultiplyAdd0000
	float4 MultiplyAdd0000 = UberRockTextureSetCFrost * UberRockBlendCBlend + Blend2OnOff10;
	
	// Type:VariantOnOffNode, Name:UpBlendOnOff00
	#if defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 1
	float4 UpBlendOnOff00 = MultiplyAdd0000;
	#elif defined(VARIANTPROPERTY_UPBLEND) && VARIANTPROPERTY_UPBLEND == 0
	float4 UpBlendOnOff00 = Blend2OnOff10;
	#elif !defined(VARIANTPROPERTY_UPBLEND) || VARIANTPROPERTY_UPBLEND == 2
	float4 UpBlendOnOff00;
	[branch]
	if(VariantConstant_UpBlend != 0)
	{
		UpBlendOnOff00 = MultiplyAdd0000;
	}
	else
	{
		UpBlendOnOff00 = Blend2OnOff10;
	}
	#endif
	
	// Type:VariantOnOffNode, Name:FrostOnOff
	#if defined(VARIANTPROPERTY_FROST) && VARIANTPROPERTY_FROST == 1
	float4 FrostOnOff = UpBlendOnOff00;
	#elif defined(VARIANTPROPERTY_FROST) && VARIANTPROPERTY_FROST == 0
	float4 FrostOnOff = Float0;
	#elif !defined(VARIANTPROPERTY_FROST) || VARIANTPROPERTY_FROST == 2
	float4 FrostOnOff;
	[branch]
	if(VariantConstant_Frost != 0)
	{
		FrostOnOff = UpBlendOnOff00;
	}
	else
	{
		FrostOnOff = Float0;
	}
	#endif
	
	output.BaseColor = MaxSwitch;
	output.Normal = MicroNormalOnOff0;
	output.Roughness = Lerp4;
	output.AmbientOcclusion = UpBlendOnOff0;
	output.DirectOcclusion = UpBlendOnOff0;
	output.SpecularScale = Multiply11;
	output.DebugComplexity = Vector4;
	output.DebugModulationMap = ModulateOnOff0;
	output.SnowSpecTexture = TwinkleRef;
	output.SnowAmount = UpBlendOnOff000;
	output.FrostAmount = FrostOnOff;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\CubemapLightScenario.hlsl"