#include "LightScenarios\Inc\DebugLightingLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 AlphaTiling < string UIName = "AlphaTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 AO_Thickness_ModelTiling < string UIName = "AO_Thickness_ModelTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 EmissiveColourColorParam < string UIName = "EmissiveColourColorParam"; string UIWidget = "Color"; > = float4( 0, 0, 0, 1 );
float4 EmissiveTiling < string UIName = "EmissiveTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float ExposureEV_floatVal < string UIName = "ExposureEV_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.001375 ;
int LegoColorSeasonIndex < string UIName = "LegoColorSeasonIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float NormalMapSpecPower < string UIName = "NormalMapSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalMapTiling < string UIName = "NormalMapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 Roughness_AO_SpecScale_ModulateTiling < string UIName = "Roughness_AO_SpecScale_ModulateTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float RoughnessTest_floatVal < string UIName = "RoughnessTest_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.08 ;
int UV1UVSet < string UIName = "UV1UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Emissive < string UIName = "VariantConstant_Emissive"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_EmissiveTextureUsesUV2 < string UIName = "VariantConstant_EmissiveTextureUsesUV2"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_TexturedEmissive < string UIName = "VariantConstant_TexturedEmissive"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define EmissiveColourColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 EmissiveColourColorParam : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define RoughnessTest_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].x)
	#else
	float RoughnessTest_floatVal : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ExposureEV_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].y)
	#else
	float ExposureEV_floatVal : packoffset(c1.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LegoColorSeasonIndex ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].x)))
	#else
	int LegoColorSeasonIndex : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Emissive ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].y)))
	#else
	int VariantConstant_Emissive : packoffset(c2.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_TexturedEmissive ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].z)))
	#else
	int VariantConstant_TexturedEmissive : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_EmissiveTextureUsesUV2 ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].w)))
	#else
	int VariantConstant_EmissiveTextureUsesUV2 : packoffset(c2.w);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UVUVSet = 0;
static const float2 Roughness_AO_SpecScale_ModulateTiling = float2(1, 1);
static const int UV1UVSet = 1;
static const float2 AO_Thickness_ModelTiling = float2(1, 1);
static const float2 AlphaTiling = float2(1, 1);
static const float NormalMapSpecPower = 100;
static const float2 NormalMapTiling = float2(1, 1);
static const float2 EmissiveTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStates0Sampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(AlphaTexture, 16);
#else
#define AlphaTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(AO_Thickness_ModelTexture, 17);
#else
#define AO_Thickness_ModelTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Colour_Metalness_SwatchTexture, 18);
#else
#define Colour_Metalness_SwatchTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(EmissiveTexture, 19);
#else
#define EmissiveTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapTexture, 20);
#else
#define NormalMapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(Roughness_AO_SpecScale_ModulateTexture, 21);
#else
#define Roughness_AO_SpecScale_ModulateTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_CloudyColor 1
#define MATERIAL_INPUT_IS_USED_CloudyColor 1
#define MATERIAL_HAS_INPUT_Cloudyness 1
#define MATERIAL_INPUT_IS_USED_Cloudyness 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_INPUT_IS_USED_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
// Alpha
#define IS_ALPHA_BLENDED 1
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\Glass.hlsl"
#include "Lego.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:LegoColorNode, Name:LegoColor
	float4 LegoColorColourUV = UnpackLegoColor(VertexColor, LegoColorSeasonIndex);
	// Type:GatherTexture4, Name:Colour_Metalness_Swatch
	float4 Colour_Metalness_SwatchColor0 = Colour_Metalness_SwatchTexture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(0,0));
	float4 Colour_Metalness_SwatchColor1 = Colour_Metalness_SwatchTexture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(1,0));
	float4 Colour_Metalness_SwatchColor2 = Colour_Metalness_SwatchTexture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(0,1));
	float4 Colour_Metalness_SwatchColor3 = Colour_Metalness_SwatchTexture.SampleLevel(g_samplerPointClamp,LegoColorColourUV.xy, 0, int2(1,1));
	
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord0(In).xyxy;
	float4 UVTangent = GetWorldTangent0(In);
	float4 UVUCoord = GetTexCoord0(In).xxxx;
	float4 UVVCoord = GetTexCoord0(In).yyyy;
	
	// Type:SamplerStatesNode, Name:SamplerStates0
	SamplerState SamplerStates0 = SamplerStates0Sampler;
	float4 SamplerStates0Preview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:Roughness_AO_SpecScale_Modulate
	float4 Roughness_AO_SpecScale_Modulate = Roughness_AO_SpecScale_ModulateTexture.Sample(SamplerStates0Sampler, UV.xy * Roughness_AO_SpecScale_ModulateTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 Roughness_AO_SpecScale_ModulateMip = GetDebugMipColour(Roughness_AO_SpecScale_ModulateTexture, SamplerStates0Sampler, UV.xy * Roughness_AO_SpecScale_ModulateTiling);
	#else
	float4 Roughness_AO_SpecScale_ModulateMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 Roughness_AO_SpecScale_ModulateAlpha = Roughness_AO_SpecScale_Modulate.aaaa;
	float4 Roughness_AO_SpecScale_ModulateRed = Roughness_AO_SpecScale_Modulate.rrrr;
	float4 Roughness_AO_SpecScale_ModulateGreen = Roughness_AO_SpecScale_Modulate.gggg;
	float4 Roughness_AO_SpecScale_ModulateBlue = Roughness_AO_SpecScale_Modulate.bbbb;
	Texture2D Roughness_AO_SpecScale_ModulateRef = Roughness_AO_SpecScale_ModulateTexture;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Colour_Metalness_SwatchColor0 * Roughness_AO_SpecScale_ModulateAlpha;
	
	// Type:UVNode, Name:UV1
	float4 UV1 = GetTexCoord1(In).xyxy;
	float4 UV1Tangent = GetWorldTangent1(In);
	float4 UV1UCoord = GetTexCoord1(In).xxxx;
	float4 UV1VCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:AO_Thickness_Model
	float4 AO_Thickness_Model = AO_Thickness_ModelTexture.Sample(SamplerStates0Sampler, UV1.xy * AO_Thickness_ModelTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AO_Thickness_ModelMip = GetDebugMipColour(AO_Thickness_ModelTexture, SamplerStates0Sampler, UV1.xy * AO_Thickness_ModelTiling);
	#else
	float4 AO_Thickness_ModelMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AO_Thickness_ModelAlpha = AO_Thickness_Model.aaaa;
	float4 AO_Thickness_ModelRed = AO_Thickness_Model.rrrr;
	float4 AO_Thickness_ModelGreen = AO_Thickness_Model.gggg;
	float4 AO_Thickness_ModelBlue = AO_Thickness_Model.bbbb;
	Texture2D AO_Thickness_ModelRef = AO_Thickness_ModelTexture;
	
	// Type:MultiplyNode, Name:MultiplyAO
	float4 MultiplyAO = Roughness_AO_SpecScale_ModulateGreen * AO_Thickness_ModelRed;
	
	// Type:FloatNode, Name:One0
	float4 One0 = float4(1, 1, 1, 1);
	
	// Type:TextureNode, Name:Alpha
	float4 Alpha = AlphaTexture.Sample(SamplerStates0Sampler, UV.xy * AlphaTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AlphaMip = GetDebugMipColour(AlphaTexture, SamplerStates0Sampler, UV.xy * AlphaTiling);
	#else
	float4 AlphaMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AlphaAlpha = Alpha.aaaa;
	float4 AlphaRed = Alpha.rrrr;
	float4 AlphaGreen = Alpha.gggg;
	float4 AlphaBlue = Alpha.bbbb;
	Texture2D AlphaRef = AlphaTexture;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = One0 * AlphaRed;
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = MultiplyAO * Multiply0;
	
	// Type:FloatNode, Name:One
	float4 One = float4(1, 1, 1, 1);
	
	// Type:MaxSwitch, Name:MaxSwitch
	    float4 MaxSwitch = Multiply1;
	#ifdef _MAX_
	    MaxSwitch = One;
	#endif
	
	// Type:NormalMapNode, Name:NormalMap
	float4 textureLookup_NormalMap = NormalMapTexture.Sample(SamplerStates0Sampler, UV.xy * NormalMapTiling);
	#ifdef _MAX_
	textureLookup_NormalMap.xyz = pow(textureLookup_NormalMap.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMap = (2.0f * textureLookup_NormalMap.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMap, NormalMapSpecPower);
	float4 NormalMapAlpha = textureLookup_NormalMap.aaaa;
	float4 NormalMapRed = textureLookup_NormalMap.rrrr;
	float4 NormalMapGreen = textureLookup_NormalMap.gggg;
	float4 NormalMapBlue = textureLookup_NormalMap.bbbb;
	tangentSpaceNormal_NormalMap.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMap.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMap.x*tangentSpaceNormal_NormalMap.x - tangentSpaceNormal_NormalMap.y*tangentSpaceNormal_NormalMap.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMap.xy *= g_GlobalNormalScale;
	#endif
	float4 NormalMap = float4(normalize(mul(tangentSpaceNormal_NormalMap, float3x3(UVTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UVTangent.xyz) * UVTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMap = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:FloatNode, Name:RoughnessTest
	float4 RoughnessTest = RoughnessTest_floatVal;
	
	// Type:SwizzleNode, Name:AlphaSwizzle
	float4 AlphaSwizzle = Colour_Metalness_SwatchColor0.wwww;
	
	// Type:ExposureValuesGroupNode, Name:ExposureEV
	float4 ExposureEV = ExposureEV_floatVal;
	
	// Type:VariantOnOffNode, Name:EmissiveTextureUsesUV2OnOff
	#if defined(VARIANTPROPERTY_EMISSIVETEXTUREUSESUV2) && VARIANTPROPERTY_EMISSIVETEXTUREUSESUV2 == 1
	float4 EmissiveTextureUsesUV2OnOff = UV1;
	#elif defined(VARIANTPROPERTY_EMISSIVETEXTUREUSESUV2) && VARIANTPROPERTY_EMISSIVETEXTUREUSESUV2 == 0
	float4 EmissiveTextureUsesUV2OnOff = UV;
	#elif !defined(VARIANTPROPERTY_EMISSIVETEXTUREUSESUV2) || VARIANTPROPERTY_EMISSIVETEXTUREUSESUV2 == 2
	float4 EmissiveTextureUsesUV2OnOff;
	[branch]
	if(VariantConstant_EmissiveTextureUsesUV2 != 0)
	{
		EmissiveTextureUsesUV2OnOff = UV1;
	}
	else
	{
		EmissiveTextureUsesUV2OnOff = UV;
	}
	#endif
	
	// Type:TextureNode, Name:Emissive
	float4 Emissive = EmissiveTexture.Sample(SamplerStates0Sampler, EmissiveTextureUsesUV2OnOff.xy * EmissiveTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 EmissiveMip = GetDebugMipColour(EmissiveTexture, SamplerStates0Sampler, EmissiveTextureUsesUV2OnOff.xy * EmissiveTiling);
	#else
	float4 EmissiveMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 EmissiveAlpha = Emissive.aaaa;
	float4 EmissiveRed = Emissive.rrrr;
	float4 EmissiveGreen = Emissive.gggg;
	float4 EmissiveBlue = Emissive.bbbb;
	Texture2D EmissiveRef = EmissiveTexture;
	
	// Type:ColorNode, Name:EmissiveColour
	float4 EmissiveColour = EmissiveColourColorParam;
	float4 EmissiveColourRed = EmissiveColourColorParam.rrrr;
	float4 EmissiveColourGreen = EmissiveColourColorParam.gggg;
	float4 EmissiveColourBlue = EmissiveColourColorParam.bbbb;
	float4 EmissiveColourAlpha = EmissiveColourColorParam.aaaa;
	
	// Type:VariantOnOffNode, Name:TexturedEmissiveOnOff
	#if defined(VARIANTPROPERTY_TEXTUREDEMISSIVE) && VARIANTPROPERTY_TEXTUREDEMISSIVE == 1
	float4 TexturedEmissiveOnOff = Emissive;
	#elif defined(VARIANTPROPERTY_TEXTUREDEMISSIVE) && VARIANTPROPERTY_TEXTUREDEMISSIVE == 0
	float4 TexturedEmissiveOnOff = EmissiveColour;
	#elif !defined(VARIANTPROPERTY_TEXTUREDEMISSIVE) || VARIANTPROPERTY_TEXTUREDEMISSIVE == 2
	float4 TexturedEmissiveOnOff;
	[branch]
	if(VariantConstant_TexturedEmissive != 0)
	{
		TexturedEmissiveOnOff = Emissive;
	}
	else
	{
		TexturedEmissiveOnOff = EmissiveColour;
	}
	#endif
	
	// Type:MultiplyNode, Name:EmissiveMultiply
	float4 EmissiveMultiply = ExposureEV * TexturedEmissiveOnOff;
	
	// Type:MultiplyNode, Name:MultiplyEmmisiveColor
	float4 MultiplyEmmisiveColor = Colour_Metalness_SwatchColor0 * EmissiveMultiply;
	
	// Type:FloatNode, Name:Zero
	float4 Zero = float4(0, 0, 0, 0);
	
	// Type:VariantOnOffNode, Name:EmissiveVariantOnOff
	#if defined(VARIANTPROPERTY_EMISSIVE) && VARIANTPROPERTY_EMISSIVE == 1
	float4 EmissiveVariantOnOff = MultiplyEmmisiveColor;
	#elif defined(VARIANTPROPERTY_EMISSIVE) && VARIANTPROPERTY_EMISSIVE == 0
	float4 EmissiveVariantOnOff = Zero;
	#elif !defined(VARIANTPROPERTY_EMISSIVE) || VARIANTPROPERTY_EMISSIVE == 2
	float4 EmissiveVariantOnOff;
	[branch]
	if(VariantConstant_Emissive != 0)
	{
		EmissiveVariantOnOff = MultiplyEmmisiveColor;
	}
	else
	{
		EmissiveVariantOnOff = Zero;
	}
	#endif
	
	output.BaseColor = Multiply;
	output.CloudyColor = Multiply;
	output.Cloudyness = MaxSwitch;
	output.Normal = NormalMap;
	output.Roughness = RoughnessTest;
	output.Metalness = AlphaSwizzle;
	output.Emissive = EmissiveVariantOnOff;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "ColorGlassTint.hlsl"
#include "LightScenarios\DebugLightingLightScenario.hlsl"