#include "LightScenarios\Inc\TrackLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
int ABBlendUVUVSet < string UIName = "ABBlendUVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
float4 AlphaTiling < string UIName = "AlphaTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 AOTiling < string UIName = "AOTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float AOToCavityMapStrength < string UIName = "AOToCavityMapStrength"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 DiffuseATiling < string UIName = "DiffuseATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 DiffuseBTiling < string UIName = "DiffuseBTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 EmissiveTiling < string UIName = "EmissiveTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float ExposureEV_floatVal < string UIName = "ExposureEV_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.001375 ;
float GIAOScale_floatVal < string UIName = "GIAOScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float GIRadScale_floatVal < string UIName = "GIRadScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 HeightATiling < string UIName = "HeightATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
bool HeightBlendStepBool < string UIName = "HeightBlendStepBool"; string UIWidget = "Checkbox"; > = 1;
bool HeightBlendStepHardStepBool < string UIName = "HeightBlendStepHardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool IsVertexColorOver3Bool < string UIName = "IsVertexColorOver3Bool"; string UIWidget = "Checkbox"; > = 0;
bool IsVertexColorOver3HardStepBool < string UIName = "IsVertexColorOver3HardStepBool"; string UIWidget = "Checkbox"; > = 1;
float LightmapAdditiveScale_floatVal < string UIName = "LightmapAdditiveScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LightmapEV_floatVal < string UIName = "LightmapEV_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.001375 ;
float4 LightmapTiling < string UIName = "LightmapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float LightSwitchOnEnd_floatVal < string UIName = "LightSwitchOnEnd_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LightSwitchOnStart_floatVal < string UIName = "LightSwitchOnStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float NormalASpecPower < string UIName = "NormalASpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalATiling < string UIName = "NormalATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float NormalBSpecPower < string UIName = "NormalBSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalBTiling < string UIName = "NormalBTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 RoughnessMetalnessATiling < string UIName = "RoughnessMetalnessATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 RoughnessMetalnessBTiling < string UIName = "RoughnessMetalnessBTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
bool Step1Bool < string UIName = "Step1Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step1HardStepBool < string UIName = "Step1HardStepBool"; string UIWidget = "Checkbox"; > = 0;
float4 TintTiling < string UIName = "TintTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
int TrackParameterTrackParam < string UIName = "TrackParameterTrackParam"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
float4 TransmissiveFuzzinessVector4 < string UIName = "TransmissiveFuzzinessVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( -0.1, -0.2, -0.2, 0 );
float4 TransmissivenessColorParam < string UIName = "TransmissivenessColorParam"; string UIWidget = "Color"; > = float4( 0, 0, 0, 1 );
float4 TwinkleTiling < string UIName = "TwinkleTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float UsesLocalisedCubes_floatVal < string UIName = "UsesLocalisedCubes_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int UV1UVSet < string UIName = "UV1UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_AlphaBlend < string UIName = "VariantConstant_AlphaBlend"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_AlphaTest < string UIName = "VariantConstant_AlphaTest"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Blend2 < string UIName = "VariantConstant_Blend2"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Emissive < string UIName = "VariantConstant_Emissive"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Lightmap < string UIName = "VariantConstant_Lightmap"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Modulate < string UIName = "VariantConstant_Modulate"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_NormalMap < string UIName = "VariantConstant_NormalMap"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Snow < string UIName = "VariantConstant_Snow"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Tint < string UIName = "VariantConstant_Tint"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Transmissive < string UIName = "VariantConstant_Transmissive"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_UpperFloor < string UIName = "VariantConstant_UpperFloor"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
bool Variation0FullColor < string UIName = "Variation0FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation0VariationIndex < string UIName = "Variation0VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
bool Variation1FullColor < string UIName = "Variation1FullColor"; string UIWidget = "Checkbox"; > = 0;
int Variation1VariationIndex < string UIName = "Variation1VariationIndex"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define TransmissivenessColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 TransmissivenessColorParam : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TransmissiveFuzzinessVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 TransmissiveFuzzinessVector4 : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ExposureEV_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].x)
	#else
	float ExposureEV_floatVal : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightmapEV_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].y)
	#else
	float LightmapEV_floatVal : packoffset(c2.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightmapAdditiveScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].z)
	#else
	float LightmapAdditiveScale_floatVal : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].w)
	#else
	float LightSwitchOnStart_floatVal : packoffset(c2.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LightSwitchOnEnd_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].x)
	#else
	float LightSwitchOnEnd_floatVal : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AOToCavityMapStrength (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].y)
	#else
	float AOToCavityMapStrength : packoffset(c3.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GIAOScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].z)
	#else
	float GIAOScale_floatVal : packoffset(c3.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GIRadScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].w)
	#else
	float GIRadScale_floatVal : packoffset(c3.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UsesLocalisedCubes_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float UsesLocalisedCubes_floatVal : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Blend2 ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)))
	#else
	int VariantConstant_Blend2 : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_NormalMap ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)))
	#else
	int VariantConstant_NormalMap : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Modulate ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)))
	#else
	int VariantConstant_Modulate : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Tint ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)))
	#else
	int VariantConstant_Tint : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_AlphaTest ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)))
	#else
	int VariantConstant_AlphaTest : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_AlphaBlend ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].y)))
	#else
	int VariantConstant_AlphaBlend : packoffset(c6.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Emissive ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].z)))
	#else
	int VariantConstant_Emissive : packoffset(c6.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Transmissive ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].w)))
	#else
	int VariantConstant_Transmissive : packoffset(c6.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Lightmap ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].x)))
	#else
	int VariantConstant_Lightmap : packoffset(c7.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Snow ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].y)))
	#else
	int VariantConstant_Snow : packoffset(c7.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UpperFloor ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].z)))
	#else
	int VariantConstant_UpperFloor : packoffset(c7.z);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int TrackParameterTrackParam = 3;
static const int UV1UVSet = 1;
static const float2 TintTiling = float2(1, 1);
static const int UVUVSet = 0;
static const float2 DiffuseATiling = float2(1, 1);
static const float2 DiffuseBTiling = float2(1, 1);
static const float2 HeightATiling = float2(1, 1);
static const int ABBlendUVUVSet = 2;
static const bool HeightBlendStepBool = true;
static const bool HeightBlendStepHardStepBool = false;
static const bool IsVertexColorOver3Bool = false;
static const bool IsVertexColorOver3HardStepBool = true;
static const float2 RoughnessMetalnessATiling = float2(1, 1);
static const float2 RoughnessMetalnessBTiling = float2(1, 1);
static const float NormalASpecPower = 100;
static const float2 NormalATiling = float2(1, 1);
static const float NormalBSpecPower = 100;
static const float2 NormalBTiling = float2(1, 1);
static const int Variation0VariationIndex = 0;
static const bool Variation0FullColor = false;
static const float2 EmissiveTiling = float2(1, 1);
static const int Variation1VariationIndex = 1;
static const bool Variation1FullColor = false;
static const float2 LightmapTiling = float2(1, 1);
static const float2 AOTiling = float2(1, 1);
static const float2 AlphaTiling = float2(1, 1);
static const bool Step1Bool = false;
static const bool Step1HardStepBool = false;
static const float2 TwinkleTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStatesSampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(AlphaTexture, 16);
#else
#define AlphaTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(AOTexture, 17);
#else
#define AOTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(DiffuseATexture, 18);
#else
#define DiffuseATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(DiffuseBTexture, 19);
#else
#define DiffuseBTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(EmissiveTexture, 20);
#else
#define EmissiveTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(HeightATexture, 21);
#else
#define HeightATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(LightmapTexture, 22);
#else
#define LightmapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(6)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalATexture, 23);
#else
#define NormalATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(7)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalBTexture, 24);
#else
#define NormalBTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(8)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(RoughnessMetalnessATexture, 25);
#else
#define RoughnessMetalnessATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(9)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(RoughnessMetalnessBTexture, 26);
#else
#define RoughnessMetalnessBTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(10)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TintTexture, 27);
#else
#define TintTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(11)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TwinkleTexture, 28);
#else
#define TwinkleTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(12)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_INPUT_IS_USED_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Transmissiveness 1
#define MATERIAL_INPUT_IS_USED_Transmissiveness 1
#define MATERIAL_HAS_INPUT_TransmissiveFuzziness 1
#define MATERIAL_INPUT_IS_USED_TransmissiveFuzziness 1
#define MATERIAL_HAS_INPUT_TransmissiveControl 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_INPUT_IS_USED_Lightmap 1
#define MATERIAL_HAS_INPUT_LightmapAdditive 1
#define MATERIAL_INPUT_IS_USED_LightmapAdditive 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_INPUT_IS_USED_AlphaTest 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_INPUT_IS_USED_AlphaBlend 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_INPUT_IS_USED_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_INPUT_IS_USED_SpecularScale 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_INPUT_IS_USED_GIScale 1
#define MATERIAL_HAS_INPUT_MinimumWind 1
#define MATERIAL_HAS_INPUT_AnimationPivot 1
#define MATERIAL_HAS_INPUT_AnimationSpeed 1
#define MATERIAL_HAS_INPUT_TranslateSpeed 1
#define MATERIAL_HAS_INPUT_RotateSpeed 1
#define MATERIAL_HAS_INPUT_Translate 1
#define MATERIAL_HAS_INPUT_Rotate 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
#define MATERIAL_INPUT_IS_USED_LocalisedCubes 1
#define MATERIAL_HAS_INPUT_SnowSpecTexture 1
#define MATERIAL_INPUT_IS_USED_SnowSpecTexture 1
#define MATERIAL_HAS_INPUT_SnowAmount 1
#define MATERIAL_INPUT_IS_USED_SnowAmount 1
#define MATERIAL_HAS_INPUT_FrostAmount 1
#define MATERIAL_HAS_INPUT_TwinkleAmount 1
// Alpha
#if VARIANTPROPERTY_ALPHABLEND
#define IS_ALPHA_BLENDED 1
#else
#define IS_ALPHA_BLENDED 0
#endif
#if VARIANTPROPERTY_ALPHATEST
#define IS_ALPHA_TESTED 1
#else
#define IS_ALPHA_TESTED 0
#endif
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BlinnPhongAlpha.hlsl"
#include "TrackConstantBuffer.hlsl"
#include "Blend.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:TrackParameterNode, Name:TrackParameter
	// DX12 binding strategies currently don't support track params in these light scenarios
	
	#if defined(IS_WHEEL_BLUR_SCENARIO) || defined(CAR_LIGHTING_SCENARIO)
	float4 TrackParameter = float4(1.0, 1.0, 0.0, 1.0);
	#else
	float4 TrackParameter = g_TrackParams[min(NUM_TRACKPARAMS_SLOTS - 1, TrackParameterTrackParam)];
	#endif
	
	// Type:UVNode, Name:UV1
	float4 UV1 = GetTexCoord1(In).xyxy;
	float4 UV1Tangent = GetWorldTangent1(In);
	float4 UV1UCoord = GetTexCoord1(In).xxxx;
	float4 UV1VCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:Tint
	float4 Tint = TintTexture.Sample(g_samplerLinearWrap, UV1.xy * TintTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TintMip = GetDebugMipColour(TintTexture, g_samplerLinearWrap, UV1.xy * TintTiling);
	#else
	float4 TintMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TintAlpha = Tint.aaaa;
	float4 TintRed = Tint.rrrr;
	float4 TintGreen = Tint.gggg;
	float4 TintBlue = Tint.bbbb;
	Texture2D TintRef = TintTexture;
	
	// Type:FloatNode, Name:Float2
	float4 Float2 = float4(0.454545, 0.454545, 0.454545, 0.454545);
	
	// Type:PowNode, Name:Pow
	float4 Pow = pow( Tint, Float2 );
	
	// Type:FloatNode, Name:Float4
	float4 Float4 = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:DebugInputNode, Name:DebugInputHeight
	float4 DebugInputHeight = Pow;
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	if (true)
	{
		g_DebugInputValueI = DebugInputHeight;
		if (!g_EnableDebugInputI)
		{
			DebugInputHeight = Float4;
		}
	}
	#endif
	
	// Type:FloatNode, Name:UV0Tiling
	float4 UV0Tiling = float4(1, 1, 1, 1);
	
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord0(In).xyxy;
	float4 UVTangent = GetWorldTangent0(In);
	float4 UVUCoord = GetTexCoord0(In).xxxx;
	float4 UVVCoord = GetTexCoord0(In).yyyy;
	
	// Type:MultiplyNode, Name:UV0Multiply
	float4 UV0Multiply = UV0Tiling * UV;
	
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStatesSampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:DiffuseA
	float4 DiffuseA = DiffuseATexture.Sample(SamplerStatesSampler, UV0Multiply.xy * DiffuseATiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 DiffuseAMip = GetDebugMipColour(DiffuseATexture, SamplerStatesSampler, UV0Multiply.xy * DiffuseATiling);
	#else
	float4 DiffuseAMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 DiffuseAAlpha = DiffuseA.aaaa;
	float4 DiffuseARed = DiffuseA.rrrr;
	float4 DiffuseAGreen = DiffuseA.gggg;
	float4 DiffuseABlue = DiffuseA.bbbb;
	Texture2D DiffuseARef = DiffuseATexture;
	
	// Type:TextureNode, Name:DiffuseB
	float4 DiffuseB = DiffuseBTexture.Sample(SamplerStatesSampler, UV0Multiply.xy * DiffuseBTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 DiffuseBMip = GetDebugMipColour(DiffuseBTexture, SamplerStatesSampler, UV0Multiply.xy * DiffuseBTiling);
	#else
	float4 DiffuseBMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 DiffuseBAlpha = DiffuseB.aaaa;
	float4 DiffuseBRed = DiffuseB.rrrr;
	float4 DiffuseBGreen = DiffuseB.gggg;
	float4 DiffuseBBlue = DiffuseB.bbbb;
	Texture2D DiffuseBRef = DiffuseBTexture;
	
	// Type:TextureNodeLinear, Name:HeightA
	float4 HeightA = HeightATexture.Sample(g_samplerLinearWrap, UV0Multiply.xy * HeightATiling);
	#ifdef _MAX_
	HeightA.rgb = pow(HeightA.rgb, 1 / 2.2);
	#endif
	float4 HeightAAlpha = HeightA.aaaa;
	Texture2D HeightARef = HeightATexture;
	
	// Type:SwizzleNode, Name:Swizzle1
	float4 Swizzle1 = HeightA.xxxx;
	
	// Type:FloatNode, Name:ABBlendSmoothness
	float4 ABBlendSmoothness = float4(0.1, 0.1, 0.1, 0.1);
	
	// Type:SubstractNode, Name:MinHeightSubstract
	float4 MinHeightSubstract = Swizzle1 - ABBlendSmoothness;
	
	// Type:AddNode, Name:MaxHeightAdd
	float4 MaxHeightAdd = Swizzle1 + ABBlendSmoothness;
	
	// Type:UVNode, Name:ABBlendUV
	float4 ABBlendUV = GetTexCoord2(In).xyxy;
	float4 ABBlendUVTangent = GetWorldTangent2(In);
	float4 ABBlendUVUCoord = GetTexCoord2(In).xxxx;
	float4 ABBlendUVVCoord = GetTexCoord2(In).yyyy;
	
	// Type:SaturateNode, Name:ABBlendSaturate
	float4 ABBlendSaturate = saturate( ABBlendUVUCoord ); 
	
	// Type:StepNode, Name:HeightBlendStep
	float4 HeightBlendStep = smoothstep( MinHeightSubstract, MaxHeightAdd, ABBlendSaturate );
	
	// Type:SaturateNode, Name:HeightBlendSaturate
	float4 HeightBlendSaturate = saturate( HeightBlendStep ); 
	
	// Type:LerpNode, Name:DiffuseABLerp
	float4 DiffuseABLerp = lerp(DiffuseA, DiffuseB, HeightBlendSaturate.x);
	
	// Type:VariantOnOffNode, Name:Blend2DiffuseOnOff
	#if defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 1
	float4 Blend2DiffuseOnOff = DiffuseABLerp;
	#elif defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 0
	float4 Blend2DiffuseOnOff = DiffuseA;
	#elif !defined(VARIANTPROPERTY_BLEND2) || VARIANTPROPERTY_BLEND2 == 2
	float4 Blend2DiffuseOnOff;
	[branch]
	if(VariantConstant_Blend2 != 0)
	{
		Blend2DiffuseOnOff = DiffuseABLerp;
	}
	else
	{
		Blend2DiffuseOnOff = DiffuseA;
	}
	#endif
	
	// Type:FloatNode, Name:Float3
	float4 Float3 = float4(0.454545, 0.454545, 0.454545, 0.454545);
	
	// Type:PowNode, Name:Pow1
	float4 Pow1 = pow( Blend2DiffuseOnOff, Float3 );
	
	// Type:OverlayBlendNode, Name:OverlayBlend
	float4 OverlayBlend = 2.0 * DebugInputHeight * Pow1;
	float4 blendOverlayBlend = 1.0 - 2.0 * (1.0 - Pow1) * (1.0 - DebugInputHeight);
	if (DebugInputHeight.x > 0.5) OverlayBlend.x = blendOverlayBlend.x;
	if (DebugInputHeight.y > 0.5) OverlayBlend.y = blendOverlayBlend.y;
	if (DebugInputHeight.z > 0.5) OverlayBlend.z = blendOverlayBlend.z;
	saturate(OverlayBlend);
	
	// Type:FloatNode, Name:Float0
	float4 Float0 = float4(2.2, 2.2, 2.2, 2.2);
	
	// Type:PowNode, Name:Pow0
	float4 Pow0 = pow( OverlayBlend, Float0 );
	
	// Type:VariantOnOffNode, Name:TintOnOff
	#if defined(VARIANTPROPERTY_TINT) && VARIANTPROPERTY_TINT == 1
	float4 TintOnOff = Pow0;
	#elif defined(VARIANTPROPERTY_TINT) && VARIANTPROPERTY_TINT == 0
	float4 TintOnOff = Blend2DiffuseOnOff;
	#elif !defined(VARIANTPROPERTY_TINT) || VARIANTPROPERTY_TINT == 2
	float4 TintOnOff;
	[branch]
	if(VariantConstant_Tint != 0)
	{
		TintOnOff = Pow0;
	}
	else
	{
		TintOnOff = Blend2DiffuseOnOff;
	}
	#endif
	
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:FloatNode, Name:DefaultModulate
	float4 DefaultModulate = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:Vector4Node, Name:XYZ_1
	float4 XYZ_1 = float4(1, 1, 1, 0) ;
	
	// Type:DotNode, Name:TotalVertexColor
	float4 TotalVertexColor = dot(XYZ_1, VertexColor);
	
	// Type:FloatNode, Name:MaxVC
	float4 MaxVC = float4(2.99, 2.99, 2.99, 2.99);
	
	// Type:StepNode, Name:IsVertexColorOver3
	float4 IsVertexColorOver3 = step( MaxVC, TotalVertexColor);
	
	// Type:LerpNode, Name:ModulateColorLerp
	float4 ModulateColorLerp = lerp(VertexColor, DefaultModulate, IsVertexColorOver3.x);
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:VectorMake, Name:VectorMake0
	float4 VectorMake0 = float4(ModulateColorLerp.x, Float1.y, Float1.z, 0);
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(1, 1, 1, 1);
	
	// Type:ColorControlNode, Name:ModulateColorControl
	float4 ModulateColorControl = ColorControlFunction(TintOnOff, VectorMake0, Float, true, false);
	
	// Type:VariantOnOffNode, Name:ModulateOnOff
	#if defined(VARIANTPROPERTY_MODULATE) && VARIANTPROPERTY_MODULATE == 1
	float4 ModulateOnOff = ModulateColorControl;
	#elif defined(VARIANTPROPERTY_MODULATE) && VARIANTPROPERTY_MODULATE == 0
	float4 ModulateOnOff = TintOnOff;
	#elif !defined(VARIANTPROPERTY_MODULATE) || VARIANTPROPERTY_MODULATE == 2
	float4 ModulateOnOff;
	[branch]
	if(VariantConstant_Modulate != 0)
	{
		ModulateOnOff = ModulateColorControl;
	}
	else
	{
		ModulateOnOff = TintOnOff;
	}
	#endif
	
	// Type:TextureNode, Name:RoughnessMetalnessA
	float4 RoughnessMetalnessA = RoughnessMetalnessATexture.Sample(g_samplerLinearWrap, UV0Multiply.xy * RoughnessMetalnessATiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 RoughnessMetalnessAMip = GetDebugMipColour(RoughnessMetalnessATexture, g_samplerLinearWrap, UV0Multiply.xy * RoughnessMetalnessATiling);
	#else
	float4 RoughnessMetalnessAMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 RoughnessMetalnessAAlpha = RoughnessMetalnessA.aaaa;
	float4 RoughnessMetalnessARed = RoughnessMetalnessA.rrrr;
	float4 RoughnessMetalnessAGreen = RoughnessMetalnessA.gggg;
	float4 RoughnessMetalnessABlue = RoughnessMetalnessA.bbbb;
	Texture2D RoughnessMetalnessARef = RoughnessMetalnessATexture;
	
	// Type:TextureNode, Name:RoughnessMetalnessB
	float4 RoughnessMetalnessB = RoughnessMetalnessBTexture.Sample(g_samplerLinearWrap, UV0Multiply.xy * RoughnessMetalnessBTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 RoughnessMetalnessBMip = GetDebugMipColour(RoughnessMetalnessBTexture, g_samplerLinearWrap, UV0Multiply.xy * RoughnessMetalnessBTiling);
	#else
	float4 RoughnessMetalnessBMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 RoughnessMetalnessBAlpha = RoughnessMetalnessB.aaaa;
	float4 RoughnessMetalnessBRed = RoughnessMetalnessB.rrrr;
	float4 RoughnessMetalnessBGreen = RoughnessMetalnessB.gggg;
	float4 RoughnessMetalnessBBlue = RoughnessMetalnessB.bbbb;
	Texture2D RoughnessMetalnessBRef = RoughnessMetalnessBTexture;
	
	// Type:LerpNode, Name:RoughnessMetalABLerp
	float4 RoughnessMetalABLerp = lerp(RoughnessMetalnessA, RoughnessMetalnessB, HeightBlendSaturate.x);
	
	// Type:VariantOnOffNode, Name:Blend2RMOnOff
	#if defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 1
	float4 Blend2RMOnOff = RoughnessMetalABLerp;
	#elif defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 0
	float4 Blend2RMOnOff = RoughnessMetalnessA;
	#elif !defined(VARIANTPROPERTY_BLEND2) || VARIANTPROPERTY_BLEND2 == 2
	float4 Blend2RMOnOff;
	[branch]
	if(VariantConstant_Blend2 != 0)
	{
		Blend2RMOnOff = RoughnessMetalABLerp;
	}
	else
	{
		Blend2RMOnOff = RoughnessMetalnessA;
	}
	#endif
	
	// Type:SwizzleNode, Name:Swizzle
	float4 Swizzle = Blend2RMOnOff.xxxx;
	
	// Type:WetifyNode, Name:Wetify
	float4 WetifyDiffuse = ModulateOnOff;
	float WetifyGloss = float(0);
	float WetifyRoughness = Swizzle;
	#ifdef _MAX_
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyGloss, float4(lerp(1.0, g_WetDiffuse, g_WetLevel), lerp(1.0, g_WetGloss, g_WetLevel), lerp(1.0, g_WetDiffuse, g_WetLevel), 0), float3(0,1,0), 1);
	#else
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyRoughness, TrackParameter, GetWorldNormal(In).xyz, float(1));
	#endif
	
	// Type:NormalMapNode, Name:NormalA
	float4 textureLookup_NormalA = NormalATexture.Sample(SamplerStatesSampler, UV0Multiply.xy * NormalATiling);
	#ifdef _MAX_
	textureLookup_NormalA.xyz = pow(textureLookup_NormalA.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalA = (2.0f * textureLookup_NormalA.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalAGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalA, NormalASpecPower);
	float4 NormalAAlpha = textureLookup_NormalA.aaaa;
	float4 NormalARed = textureLookup_NormalA.rrrr;
	float4 NormalAGreen = textureLookup_NormalA.gggg;
	float4 NormalABlue = textureLookup_NormalA.bbbb;
	tangentSpaceNormal_NormalA.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalA.z = sqrt(saturate(1 - tangentSpaceNormal_NormalA.x*tangentSpaceNormal_NormalA.x - tangentSpaceNormal_NormalA.y*tangentSpaceNormal_NormalA.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalA.xy *= g_GlobalNormalScale;
	#endif
	float4 NormalA = float4(normalize(mul(tangentSpaceNormal_NormalA, float3x3(UVTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UVTangent.xyz) * UVTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalA = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:NormalMapNode, Name:NormalB
	float4 textureLookup_NormalB = NormalBTexture.Sample(SamplerStatesSampler, UV0Multiply.xy * NormalBTiling);
	#ifdef _MAX_
	textureLookup_NormalB.xyz = pow(textureLookup_NormalB.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalB = (2.0f * textureLookup_NormalB.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalBGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalB, NormalBSpecPower);
	float4 NormalBAlpha = textureLookup_NormalB.aaaa;
	float4 NormalBRed = textureLookup_NormalB.rrrr;
	float4 NormalBGreen = textureLookup_NormalB.gggg;
	float4 NormalBBlue = textureLookup_NormalB.bbbb;
	tangentSpaceNormal_NormalB.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalB.z = sqrt(saturate(1 - tangentSpaceNormal_NormalB.x*tangentSpaceNormal_NormalB.x - tangentSpaceNormal_NormalB.y*tangentSpaceNormal_NormalB.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalB.xy *= g_GlobalNormalScale;
	#endif
	float4 NormalB = float4(normalize(mul(tangentSpaceNormal_NormalB, float3x3(UVTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UVTangent.xyz) * UVTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalB = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:LerpNode, Name:NormalABLerp
	float4 NormalABLerp = lerp(NormalA, NormalB, HeightBlendSaturate.x);
	
	// Type:VariantOnOffNode, Name:Blend2NormalMapOnOff
	#if defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 1
	float4 Blend2NormalMapOnOff = NormalABLerp;
	#elif defined(VARIANTPROPERTY_BLEND2) && VARIANTPROPERTY_BLEND2 == 0
	float4 Blend2NormalMapOnOff = NormalA;
	#elif !defined(VARIANTPROPERTY_BLEND2) || VARIANTPROPERTY_BLEND2 == 2
	float4 Blend2NormalMapOnOff;
	[branch]
	if(VariantConstant_Blend2 != 0)
	{
		Blend2NormalMapOnOff = NormalABLerp;
	}
	else
	{
		Blend2NormalMapOnOff = NormalA;
	}
	#endif
	
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:VariantOnOffNode, Name:NormalMapOnOff
	#if defined(VARIANTPROPERTY_NORMALMAP) && VARIANTPROPERTY_NORMALMAP == 1
	float4 NormalMapOnOff = Blend2NormalMapOnOff;
	#elif defined(VARIANTPROPERTY_NORMALMAP) && VARIANTPROPERTY_NORMALMAP == 0
	float4 NormalMapOnOff = WorldNormal;
	#elif !defined(VARIANTPROPERTY_NORMALMAP) || VARIANTPROPERTY_NORMALMAP == 2
	float4 NormalMapOnOff;
	[branch]
	if(VariantConstant_NormalMap != 0)
	{
		NormalMapOnOff = Blend2NormalMapOnOff;
	}
	else
	{
		NormalMapOnOff = WorldNormal;
	}
	#endif
	
	// Type:SwizzleNode, Name:Swizzle0
	float4 Swizzle0 = Blend2RMOnOff.yyyy;
	
	// Type:VariationNode, Name:Variation0
	float4 Variation0 = GetInstanceVariation(In)[0];
	
	// Type:IntNode, Name:Int1
	float4 Int1 = float4(1000, 1000, 1000, 1000) ;
	
	// Type:MaxSwitch, Name:MaxSwitch
	    float4 MaxSwitch = Variation0;
	#ifdef _MAX_
	    MaxSwitch = Int1;
	#endif
	
	// Type:ExposureValuesGroupNode, Name:ExposureEV
	float4 ExposureEV = ExposureEV_floatVal;
	
	// Type:TextureNode, Name:Emissive
	float4 Emissive = EmissiveTexture.Sample(g_samplerLinearWrap, UV.xy * EmissiveTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 EmissiveMip = GetDebugMipColour(EmissiveTexture, g_samplerLinearWrap, UV.xy * EmissiveTiling);
	#else
	float4 EmissiveMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 EmissiveAlpha = Emissive.aaaa;
	float4 EmissiveRed = Emissive.rrrr;
	float4 EmissiveGreen = Emissive.gggg;
	float4 EmissiveBlue = Emissive.bbbb;
	Texture2D EmissiveRef = EmissiveTexture;
	
	// Type:MultiplyNode, Name:EmissiveMultiply
	float4 EmissiveMultiply = ExposureEV * Emissive;
	
	// Type:MultiplyNode, Name:Multiply4
	float4 Multiply4 = MaxSwitch * EmissiveMultiply;
	
	// Type:Vector4Node, Name:Zero
	float4 Zero = float4(0, 0, 0, 1) ;
	
	// Type:VariantOnOffNode, Name:EmissiveOnOff
	#if defined(VARIANTPROPERTY_EMISSIVE) && VARIANTPROPERTY_EMISSIVE == 1
	float4 EmissiveOnOff = Multiply4;
	#elif defined(VARIANTPROPERTY_EMISSIVE) && VARIANTPROPERTY_EMISSIVE == 0
	float4 EmissiveOnOff = Zero;
	#elif !defined(VARIANTPROPERTY_EMISSIVE) || VARIANTPROPERTY_EMISSIVE == 2
	float4 EmissiveOnOff;
	[branch]
	if(VariantConstant_Emissive != 0)
	{
		EmissiveOnOff = Multiply4;
	}
	else
	{
		EmissiveOnOff = Zero;
	}
	#endif
	
	// Type:ColorNode, Name:Transmissiveness
	float4 Transmissiveness = TransmissivenessColorParam;
	float4 TransmissivenessRed = TransmissivenessColorParam.rrrr;
	float4 TransmissivenessGreen = TransmissivenessColorParam.gggg;
	float4 TransmissivenessBlue = TransmissivenessColorParam.bbbb;
	float4 TransmissivenessAlpha = TransmissivenessColorParam.aaaa;
	
	// Type:Vector4Node, Name:TransmissivenessOff
	float4 TransmissivenessOff = float4(0, 0, 0, 0) ;
	
	// Type:VariantOnOffNode, Name:TransmissiveOnOff
	#if defined(VARIANTPROPERTY_TRANSMISSIVE) && VARIANTPROPERTY_TRANSMISSIVE == 1
	float4 TransmissiveOnOff = Transmissiveness;
	#elif defined(VARIANTPROPERTY_TRANSMISSIVE) && VARIANTPROPERTY_TRANSMISSIVE == 0
	float4 TransmissiveOnOff = TransmissivenessOff;
	#elif !defined(VARIANTPROPERTY_TRANSMISSIVE) || VARIANTPROPERTY_TRANSMISSIVE == 2
	float4 TransmissiveOnOff;
	[branch]
	if(VariantConstant_Transmissive != 0)
	{
		TransmissiveOnOff = Transmissiveness;
	}
	else
	{
		TransmissiveOnOff = TransmissivenessOff;
	}
	#endif
	
	// Type:Vector4Node, Name:TransmissiveFuzziness
	float4 TransmissiveFuzziness = TransmissiveFuzzinessVector4;
	
	// Type:Vector4Node, Name:TransmissiveFuzzinessOff
	float4 TransmissiveFuzzinessOff = float4(-0.1, -0.2, -0.2, 0) ;
	
	// Type:VariantOnOffNode, Name:TransmissiveFuzzinessOnOff
	#if defined(VARIANTPROPERTY_TRANSMISSIVE) && VARIANTPROPERTY_TRANSMISSIVE == 1
	float4 TransmissiveFuzzinessOnOff = TransmissiveFuzziness;
	#elif defined(VARIANTPROPERTY_TRANSMISSIVE) && VARIANTPROPERTY_TRANSMISSIVE == 0
	float4 TransmissiveFuzzinessOnOff = TransmissiveFuzzinessOff;
	#elif !defined(VARIANTPROPERTY_TRANSMISSIVE) || VARIANTPROPERTY_TRANSMISSIVE == 2
	float4 TransmissiveFuzzinessOnOff;
	[branch]
	if(VariantConstant_Transmissive != 0)
	{
		TransmissiveFuzzinessOnOff = TransmissiveFuzziness;
	}
	else
	{
		TransmissiveFuzzinessOnOff = TransmissiveFuzzinessOff;
	}
	#endif
	
	// Type:VariationNode, Name:Variation1
	float4 Variation1 = GetInstanceVariation(In)[1];
	
	// Type:ExposureValuesGroupNode, Name:LightmapEV
	float4 LightmapEV = LightmapEV_floatVal;
	
	// Type:TextureNode, Name:Lightmap
	float4 Lightmap = LightmapTexture.Sample(g_samplerLinearWrap, UV1.xy * LightmapTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 LightmapMip = GetDebugMipColour(LightmapTexture, g_samplerLinearWrap, UV1.xy * LightmapTiling);
	#else
	float4 LightmapMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 LightmapAlpha = Lightmap.aaaa;
	float4 LightmapRed = Lightmap.rrrr;
	float4 LightmapGreen = Lightmap.gggg;
	float4 LightmapBlue = Lightmap.bbbb;
	Texture2D LightmapRef = LightmapTexture;
	
	// Type:MultiplyNode, Name:LightmapMultiply
	float4 LightmapMultiply = LightmapEV * Lightmap;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Variation1 * LightmapMultiply;
	
	// Type:VariantOnOffNode, Name:LightmapOnOff
	#if defined(VARIANTPROPERTY_LIGHTMAP) && VARIANTPROPERTY_LIGHTMAP == 1
	float4 LightmapOnOff = Multiply;
	#elif defined(VARIANTPROPERTY_LIGHTMAP) && VARIANTPROPERTY_LIGHTMAP == 0
	float4 LightmapOnOff = Zero;
	#elif !defined(VARIANTPROPERTY_LIGHTMAP) || VARIANTPROPERTY_LIGHTMAP == 2
	float4 LightmapOnOff;
	[branch]
	if(VariantConstant_Lightmap != 0)
	{
		LightmapOnOff = Multiply;
	}
	else
	{
		LightmapOnOff = Zero;
	}
	#endif
	
	// Type:FloatNode, Name:LightmapAdditiveScale
	float4 LightmapAdditiveScale = LightmapAdditiveScale_floatVal;
	
	// Type:MultiplyNode, Name:LightmapMultiply1
	float4 LightmapMultiply1 = Multiply * LightmapAdditiveScale;
	
	// Type:VariantOnOffNode, Name:LightmapOnOff1
	#if defined(VARIANTPROPERTY_LIGHTMAP) && VARIANTPROPERTY_LIGHTMAP == 1
	float4 LightmapOnOff1 = LightmapMultiply1;
	#elif defined(VARIANTPROPERTY_LIGHTMAP) && VARIANTPROPERTY_LIGHTMAP == 0
	float4 LightmapOnOff1 = Zero;
	#elif !defined(VARIANTPROPERTY_LIGHTMAP) || VARIANTPROPERTY_LIGHTMAP == 2
	float4 LightmapOnOff1;
	[branch]
	if(VariantConstant_Lightmap != 0)
	{
		LightmapOnOff1 = LightmapMultiply1;
	}
	else
	{
		LightmapOnOff1 = Zero;
	}
	#endif
	
	// Type:TextureNode, Name:AO
	float4 AO = AOTexture.Sample(g_samplerLinearWrap, UV1.xy * AOTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AOMip = GetDebugMipColour(AOTexture, g_samplerLinearWrap, UV1.xy * AOTiling);
	#else
	float4 AOMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AOAlpha = AO.aaaa;
	float4 AORed = AO.rrrr;
	float4 AOGreen = AO.gggg;
	float4 AOBlue = AO.bbbb;
	Texture2D AORef = AOTexture;
	
	// Type:SwizzleNode, Name:AOABSwizzle
	float4 AOABSwizzle = Blend2DiffuseOnOff.wwww;
	
	// Type:AOModifier, Name:AOModifier
	g_IgnoreGlobalScales = true;
	float4 AOModifierAOHigh = ApplyIntensistyAndPower(AOABSwizzle, g_AODOHighModifiers.x, g_AODOHighModifiers.y) ;
	float4 AOModifierAO = CombineAOs(ApplyIntensistyAndPower(AO, g_AODOMediumModifiers.x, g_AODOMediumModifiers.y), AOModifierAOHigh);
	float4 AOModifierDO = ApplyIntensistyAndPower(AO, g_AODOMediumModifiers.z, g_AODOMediumModifiers.w) * ApplyIntensistyAndPower(AOABSwizzle, g_AODOHighModifiers.z, g_AODOHighModifiers.w);
	
	// Type:TextureNode, Name:Alpha
	float4 Alpha = AlphaTexture.Sample(SamplerStatesSampler, UV0Multiply.xy * AlphaTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AlphaMip = GetDebugMipColour(AlphaTexture, SamplerStatesSampler, UV0Multiply.xy * AlphaTiling);
	#else
	float4 AlphaMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AlphaAlpha = Alpha.aaaa;
	float4 AlphaRed = Alpha.rrrr;
	float4 AlphaGreen = Alpha.gggg;
	float4 AlphaBlue = Alpha.bbbb;
	Texture2D AlphaRef = AlphaTexture;
	
	// Type:Vector4Node, Name:One
	float4 One = float4(1, 1, 1, 1) ;
	
	// Type:VariantOnOffNode, Name:AlphaTestOnOff
	#if defined(VARIANTPROPERTY_ALPHATEST) && VARIANTPROPERTY_ALPHATEST == 1
	float4 AlphaTestOnOff = AlphaRed;
	#elif defined(VARIANTPROPERTY_ALPHATEST) && VARIANTPROPERTY_ALPHATEST == 0
	float4 AlphaTestOnOff = One;
	#elif !defined(VARIANTPROPERTY_ALPHATEST) || VARIANTPROPERTY_ALPHATEST == 2
	float4 AlphaTestOnOff;
	[branch]
	if(VariantConstant_AlphaTest != 0)
	{
		AlphaTestOnOff = AlphaRed;
	}
	else
	{
		AlphaTestOnOff = One;
	}
	#endif
	
	// Type:VariantOnOffNode, Name:AlphaBlendOnOff
	#if defined(VARIANTPROPERTY_ALPHABLEND) && VARIANTPROPERTY_ALPHABLEND == 1
	float4 AlphaBlendOnOff = AlphaRed;
	#elif defined(VARIANTPROPERTY_ALPHABLEND) && VARIANTPROPERTY_ALPHABLEND == 0
	float4 AlphaBlendOnOff = One;
	#elif !defined(VARIANTPROPERTY_ALPHABLEND) || VARIANTPROPERTY_ALPHABLEND == 2
	float4 AlphaBlendOnOff;
	[branch]
	if(VariantConstant_AlphaBlend != 0)
	{
		AlphaBlendOnOff = AlphaRed;
	}
	else
	{
		AlphaBlendOnOff = One;
	}
	#endif
	
	// Type:FloatNode, Name:LightSwitchOnStart
	float4 LightSwitchOnStart = LightSwitchOnStart_floatVal;
	
	// Type:FloatNode, Name:LightSwitchOnEnd
	float4 LightSwitchOnEnd = LightSwitchOnEnd_floatVal;
	
	// Type:FloatNode, Name:Float10
	float4 Float10 = float4(0.96, 0.96, 0.96, 0.96);
	
	// Type:FloatNode, Name:Float11
	float4 Float11 = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:Step1
	float4 Step1 = linearstep( Float10, Float11, Swizzle );
	
	// Type:AOToCavityMap, Name:AOToCavityMap
	float4 AOToCavityMap = (saturate((1 / (1 + pow(2.71828, -(AOModifierAOHigh - 0.46) * 5)) - 0.09) * 1.21));
	AOToCavityMap = AOToCavityMap * AOToCavityMapStrength + (1 - AOToCavityMapStrength);
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = Step1 * AOToCavityMap;
	
	// Type:FloatNode, Name:GIAOScale
	float4 GIAOScale = GIAOScale_floatVal;
	
	// Type:FloatNode, Name:GIRadScale
	float4 GIRadScale = GIRadScale_floatVal;
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(GIAOScale.x, GIAOScale.y, GIRadScale.z, 0);
	
	// Type:FloatNode, Name:UsesLocalisedCubes
	float4 UsesLocalisedCubes = UsesLocalisedCubes_floatVal;
	
	// Type:TextureNodeLinear, Name:Twinkle
	float4 Twinkle = TwinkleTexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * TwinkleTiling);
	#ifdef _MAX_
	Twinkle.rgb = pow(Twinkle.rgb, 1 / 2.2);
	#endif
	float4 TwinkleAlpha = Twinkle.aaaa;
	Texture2D TwinkleRef = TwinkleTexture;
	
	// Type:FloatNode, Name:Float5
	float4 Float5 = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:Float50
	float4 Float50 = float4(0, 0, 0, 0);
	
	// Type:VariantOnOffNode, Name:SnowOnOff
	#if defined(VARIANTPROPERTY_SNOW) && VARIANTPROPERTY_SNOW == 1
	float4 SnowOnOff = Float5;
	#elif defined(VARIANTPROPERTY_SNOW) && VARIANTPROPERTY_SNOW == 0
	float4 SnowOnOff = Float50;
	#elif !defined(VARIANTPROPERTY_SNOW) || VARIANTPROPERTY_SNOW == 2
	float4 SnowOnOff;
	[branch]
	if(VariantConstant_Snow != 0)
	{
		SnowOnOff = Float5;
	}
	else
	{
		SnowOnOff = Float50;
	}
	#endif
	
	output.BaseColor = WetifyDiffuse;
	output.Normal = NormalMapOnOff;
	output.Roughness = WetifyRoughness;
	output.Metalness = Swizzle0;
	output.Emissive = EmissiveOnOff;
	output.Transmissiveness = TransmissiveOnOff;
	output.TransmissiveFuzziness = TransmissiveFuzzinessOnOff;
	output.Lightmap = LightmapOnOff;
	output.LightmapAdditive = LightmapOnOff1;
	output.AmbientOcclusion = AOModifierAO;
	output.DirectOcclusion = AOModifierDO;
	#if IN_MATERIAL_EDITOR
	if (!forVertex) clip(AlphaTestOnOff.x - ALPHATEST_MIN);
	#else
	#if ENABLE_ALPHA_TEST && IS_ALPHA_TESTED
	if (!forVertex && g_EnableAlphaTest) clip(AlphaTestOnOff.x - ALPHATEST_MIN);
	#endif
	#endif
	output.AlphaTest = AlphaTestOnOff;
	output.AlphaBlend = AlphaBlendOnOff;
	output.LightSwitchOnStart = LightSwitchOnStart;
	output.LightSwitchOnEnd = LightSwitchOnEnd;
	output.SpecularScale = Multiply1;
	output.GIScale = VectorMake;
	output.LocalisedCubes = UsesLocalisedCubes;
	output.SnowSpecTexture = TwinkleRef;
	output.SnowAmount = SnowOnOff;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\TrackLightScenario.hlsl"