#include "LightScenarios\Inc\TrackNightLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float EmissiveEV_floatVal < string UIName = "EmissiveEV_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 EmissiveTiling < string UIName = "EmissiveTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 L1_BaseColourTiling < string UIName = "L1_BaseColourTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 6, 6, 0, 0 );
float L1_Mask_opacity_floatVal < string UIName = "L1_Mask_opacity_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float L1_NormRoughnessMetalnessHeightScale < string UIName = "L1_NormRoughnessMetalnessHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float L1_NormRoughnessMetalnessSpecPower < string UIName = "L1_NormRoughnessMetalnessSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 L1_NormRoughnessMetalnessTiling < string UIName = "L1_NormRoughnessMetalnessTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 6, 6, 0, 0 );
float4 L2_BaseColourTiling < string UIName = "L2_BaseColourTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 6, 6, 0, 0 );
float L2_Mask_opacity_floatVal < string UIName = "L2_Mask_opacity_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float L2_NormRoughnessMetalnessHeightScale < string UIName = "L2_NormRoughnessMetalnessHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float L2_NormRoughnessMetalnessSpecPower < string UIName = "L2_NormRoughnessMetalnessSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 L2_NormRoughnessMetalnessTiling < string UIName = "L2_NormRoughnessMetalnessTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 6, 6, 0, 0 );
float L3_GreaseDiffScaler_floatVal < string UIName = "L3_GreaseDiffScaler_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.6 ;
float L3_GreaseMetalness_floatVal < string UIName = "L3_GreaseMetalness_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float L3_GreaseRoughness_floatVal < string UIName = "L3_GreaseRoughness_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.05 ;
float L3_Mask_opacity_floatVal < string UIName = "L3_Mask_opacity_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 L4Pri_BaseColourTiling < string UIName = "L4Pri_BaseColourTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float L4Pri_NormRoughnessMetalnessHeightScale < string UIName = "L4Pri_NormRoughnessMetalnessHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float L4Pri_NormRoughnessMetalnessSpecPower < string UIName = "L4Pri_NormRoughnessMetalnessSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 L4Pri_NormRoughnessMetalnessTiling < string UIName = "L4Pri_NormRoughnessMetalnessTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 MaskAOTextureTiling < string UIName = "MaskAOTextureTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 MaskTiledNormalTiling < string UIName = "MaskTiledNormalTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float TiledNormalHeightScale < string UIName = "TiledNormalHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float TiledNormalSpecPower < string UIName = "TiledNormalSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 TiledNormalTiling < string UIName = "TiledNormalTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 50, 50, 0, 0 );
int TrackParameterTrackParam < string UIName = "TrackParameterTrackParam"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
int UV_emissiveUVSet < string UIName = "UV_emissiveUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
int UV_layerMasksUVSet < string UIName = "UV_layerMasksUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int UV_primaryUVSet < string UIName = "UV_primaryUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int UV_tilingUVSet < string UIName = "UV_tilingUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define L4Pri_BaseColourTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].xy))
	#else
	float2 L4Pri_BaseColourTiling : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L2_BaseColourTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].zw))
	#else
	float2 L2_BaseColourTiling : packoffset(c0.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L1_BaseColourTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].xy))
	#else
	float2 L1_BaseColourTiling : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L4Pri_NormRoughnessMetalnessTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].zw))
	#else
	float2 L4Pri_NormRoughnessMetalnessTiling : packoffset(c1.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L2_NormRoughnessMetalnessTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].xy))
	#else
	float2 L2_NormRoughnessMetalnessTiling : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L1_NormRoughnessMetalnessTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].zw))
	#else
	float2 L1_NormRoughnessMetalnessTiling : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TiledNormalTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].xy))
	#else
	float2 TiledNormalTiling : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MaskTiledNormalTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].zw))
	#else
	float2 MaskTiledNormalTiling : packoffset(c3.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L3_GreaseDiffScaler_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float L3_GreaseDiffScaler_floatVal : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L3_Mask_opacity_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].y)
	#else
	float L3_Mask_opacity_floatVal : packoffset(c4.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L2_Mask_opacity_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].z)
	#else
	float L2_Mask_opacity_floatVal : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L1_Mask_opacity_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].w)
	#else
	float L1_Mask_opacity_floatVal : packoffset(c4.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L4Pri_NormRoughnessMetalnessHeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)
	#else
	float L4Pri_NormRoughnessMetalnessHeightScale : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L3_GreaseRoughness_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)
	#else
	float L3_GreaseRoughness_floatVal : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L3_GreaseMetalness_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)
	#else
	float L3_GreaseMetalness_floatVal : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L2_NormRoughnessMetalnessHeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)
	#else
	float L2_NormRoughnessMetalnessHeightScale : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define L1_NormRoughnessMetalnessHeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)
	#else
	float L1_NormRoughnessMetalnessHeightScale : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TiledNormalHeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].y)
	#else
	float TiledNormalHeightScale : packoffset(c6.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define EmissiveEV_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].z)
	#else
	float EmissiveEV_floatVal : packoffset(c6.z);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int TrackParameterTrackParam = 3;
static const int UV_primaryUVSet = 0;
static const int UV_layerMasksUVSet = 1;
static const float2 MaskAOTextureTiling = float2(1, 1);
static const int UV_tilingUVSet = 1;
static const float L4Pri_NormRoughnessMetalnessSpecPower = 100;
static const float L2_NormRoughnessMetalnessSpecPower = 100;
static const float L1_NormRoughnessMetalnessSpecPower = 100;
static const float TiledNormalSpecPower = 100;
static const int UV_emissiveUVSet = 2;
static const float2 EmissiveTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStatesSampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(EmissiveTexture, 16);
#else
#define EmissiveTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(L1_BaseColourTexture, 17);
#else
#define L1_BaseColourTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(L1_NormRoughnessMetalnessTexture, 18);
#else
#define L1_NormRoughnessMetalnessTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(L2_BaseColourTexture, 19);
#else
#define L2_BaseColourTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(L2_NormRoughnessMetalnessTexture, 20);
#else
#define L2_NormRoughnessMetalnessTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(L4Pri_BaseColourTexture, 21);
#else
#define L4Pri_BaseColourTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(L4Pri_NormRoughnessMetalnessTexture, 22);
#else
#define L4Pri_NormRoughnessMetalnessTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(6)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MaskAOTextureTexture, 23);
#else
#define MaskAOTextureTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(7)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MaskTiledNormalTexture, 24);
#else
#define MaskTiledNormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(8)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TiledNormalTexture, 25);
#else
#define TiledNormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(9)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_TerrainTransmissivness 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_INPUT_IS_USED_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_LightmapAdditive 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_SnowSpecTexture 1
#define MATERIAL_HAS_INPUT_SnowAmount 1
#define MATERIAL_HAS_INPUT_FrostAmount 1
#define MATERIAL_HAS_INPUT_TwinkleAmount 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"
#include "TrackConstantBuffer.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:TrackParameterNode, Name:TrackParameter
	// DX12 binding strategies currently don't support track params in these light scenarios
	
	#if defined(IS_WHEEL_BLUR_SCENARIO) || defined(CAR_LIGHTING_SCENARIO)
	float4 TrackParameter = float4(1.0, 1.0, 0.0, 1.0);
	#else
	float4 TrackParameter = g_TrackParams[min(NUM_TRACKPARAMS_SLOTS - 1, TrackParameterTrackParam)];
	#endif
	
	// Type:UVNode, Name:UV_primary
	float4 UV_primary = GetTexCoord0(In).xyxy;
	float4 UV_primaryTangent = GetWorldTangent0(In);
	float4 UV_primaryUCoord = GetTexCoord0(In).xxxx;
	float4 UV_primaryVCoord = GetTexCoord0(In).yyyy;
	
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStatesSampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:L4Pri_BaseColour
	float4 L4Pri_BaseColour = L4Pri_BaseColourTexture.Sample(SamplerStatesSampler, UV_primary.xy * L4Pri_BaseColourTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 L4Pri_BaseColourMip = GetDebugMipColour(L4Pri_BaseColourTexture, SamplerStatesSampler, UV_primary.xy * L4Pri_BaseColourTiling);
	#else
	float4 L4Pri_BaseColourMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 L4Pri_BaseColourAlpha = L4Pri_BaseColour.aaaa;
	float4 L4Pri_BaseColourRed = L4Pri_BaseColour.rrrr;
	float4 L4Pri_BaseColourGreen = L4Pri_BaseColour.gggg;
	float4 L4Pri_BaseColourBlue = L4Pri_BaseColour.bbbb;
	Texture2D L4Pri_BaseColourRef = L4Pri_BaseColourTexture;
	
	// Type:FloatNode, Name:L3_GreaseDiffScaler
	float4 L3_GreaseDiffScaler = L3_GreaseDiffScaler_floatVal;
	
	// Type:MultiplyNode, Name:mulGreaseDiffuse
	float4 mulGreaseDiffuse = L3_GreaseDiffScaler * L4Pri_BaseColour;
	
	// Type:UVNode, Name:UV_layerMasks
	float4 UV_layerMasks = GetTexCoord1(In).xyxy;
	float4 UV_layerMasksTangent = GetWorldTangent1(In);
	float4 UV_layerMasksUCoord = GetTexCoord1(In).xxxx;
	float4 UV_layerMasksVCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:MaskAOTexture
	float4 MaskAOTexture = MaskAOTextureTexture.Sample(SamplerStatesSampler, UV_layerMasks.xy * MaskAOTextureTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MaskAOTextureMip = GetDebugMipColour(MaskAOTextureTexture, SamplerStatesSampler, UV_layerMasks.xy * MaskAOTextureTiling);
	#else
	float4 MaskAOTextureMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MaskAOTextureAlpha = MaskAOTexture.aaaa;
	float4 MaskAOTextureRed = MaskAOTexture.rrrr;
	float4 MaskAOTextureGreen = MaskAOTexture.gggg;
	float4 MaskAOTextureBlue = MaskAOTexture.bbbb;
	Texture2D MaskAOTextureRef = MaskAOTextureTexture;
	
	// Type:FloatNode, Name:L3_Mask_opacity
	float4 L3_Mask_opacity = L3_Mask_opacity_floatVal;
	
	// Type:MultiplyNode, Name:mul_L3_Mask
	float4 mul_L3_Mask = MaskAOTextureBlue * L3_Mask_opacity;
	
	// Type:LerpNode, Name:LerpBaseColour3
	float4 LerpBaseColour3 = lerp(L4Pri_BaseColour, mulGreaseDiffuse, mul_L3_Mask.x);
	
	// Type:UVNode, Name:UV_tiling
	float4 UV_tiling = GetTexCoord1(In).xyxy;
	float4 UV_tilingTangent = GetWorldTangent1(In);
	float4 UV_tilingUCoord = GetTexCoord1(In).xxxx;
	float4 UV_tilingVCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:L2_BaseColour
	float4 L2_BaseColour = L2_BaseColourTexture.Sample(SamplerStatesSampler, UV_tiling.xy * L2_BaseColourTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 L2_BaseColourMip = GetDebugMipColour(L2_BaseColourTexture, SamplerStatesSampler, UV_tiling.xy * L2_BaseColourTiling);
	#else
	float4 L2_BaseColourMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 L2_BaseColourAlpha = L2_BaseColour.aaaa;
	float4 L2_BaseColourRed = L2_BaseColour.rrrr;
	float4 L2_BaseColourGreen = L2_BaseColour.gggg;
	float4 L2_BaseColourBlue = L2_BaseColour.bbbb;
	Texture2D L2_BaseColourRef = L2_BaseColourTexture;
	
	// Type:FloatNode, Name:L2_Mask_opacity
	float4 L2_Mask_opacity = L2_Mask_opacity_floatVal;
	
	// Type:MultiplyNode, Name:mul_L2_Mask
	float4 mul_L2_Mask = MaskAOTextureGreen * L2_Mask_opacity;
	
	// Type:LerpNode, Name:LerpBaseColour2
	float4 LerpBaseColour2 = lerp(LerpBaseColour3, L2_BaseColour, mul_L2_Mask.x);
	
	// Type:TextureNode, Name:L1_BaseColour
	float4 L1_BaseColour = L1_BaseColourTexture.Sample(SamplerStatesSampler, UV_tiling.xy * L1_BaseColourTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 L1_BaseColourMip = GetDebugMipColour(L1_BaseColourTexture, SamplerStatesSampler, UV_tiling.xy * L1_BaseColourTiling);
	#else
	float4 L1_BaseColourMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 L1_BaseColourAlpha = L1_BaseColour.aaaa;
	float4 L1_BaseColourRed = L1_BaseColour.rrrr;
	float4 L1_BaseColourGreen = L1_BaseColour.gggg;
	float4 L1_BaseColourBlue = L1_BaseColour.bbbb;
	Texture2D L1_BaseColourRef = L1_BaseColourTexture;
	
	// Type:FloatNode, Name:L1_Mask_opacity
	float4 L1_Mask_opacity = L1_Mask_opacity_floatVal;
	
	// Type:MultiplyNode, Name:mul_L1_Mask
	float4 mul_L1_Mask = MaskAOTextureRed * L1_Mask_opacity;
	
	// Type:LerpNode, Name:LerpBaseColour1
	float4 LerpBaseColour1 = lerp(LerpBaseColour2, L1_BaseColour, mul_L1_Mask.x);
	
	// Type:NormalMapWithIntensityNode, Name:L4Pri_NormRoughnessMetalness
	float4 textureLookup_L4Pri_NormRoughnessMetalness = L4Pri_NormRoughnessMetalnessTexture.Sample(SamplerStatesSampler, UV_primary.xy * L4Pri_NormRoughnessMetalnessTiling);
	#ifdef _MAX_
	textureLookup_L4Pri_NormRoughnessMetalness.xyz = pow(textureLookup_L4Pri_NormRoughnessMetalness.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_L4Pri_NormRoughnessMetalness = (2.0f * textureLookup_L4Pri_NormRoughnessMetalness.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 L4Pri_NormRoughnessMetalnessGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_L4Pri_NormRoughnessMetalness, L4Pri_NormRoughnessMetalnessSpecPower);
	float4 L4Pri_NormRoughnessMetalnessAlpha = textureLookup_L4Pri_NormRoughnessMetalness.aaaa;
	float4 L4Pri_NormRoughnessMetalnessRed = textureLookup_L4Pri_NormRoughnessMetalness.rrrr;
	float4 L4Pri_NormRoughnessMetalnessGreen = textureLookup_L4Pri_NormRoughnessMetalness.gggg;
	float4 L4Pri_NormRoughnessMetalnessBlue = textureLookup_L4Pri_NormRoughnessMetalness.bbbb;
	tangentSpaceNormal_L4Pri_NormRoughnessMetalness.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_L4Pri_NormRoughnessMetalness.z = sqrt(saturate(1 - tangentSpaceNormal_L4Pri_NormRoughnessMetalness.x*tangentSpaceNormal_L4Pri_NormRoughnessMetalness.x - tangentSpaceNormal_L4Pri_NormRoughnessMetalness.y*tangentSpaceNormal_L4Pri_NormRoughnessMetalness.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_L4Pri_NormRoughnessMetalness.xy *= g_GlobalNormalScale * L4Pri_NormRoughnessMetalnessHeightScale.x;
	#else
	tangentSpaceNormal_L4Pri_NormRoughnessMetalness.xy *= L4Pri_NormRoughnessMetalnessHeightScale.x;
	#endif
	float4 L4Pri_NormRoughnessMetalness = float4(normalize(mul(tangentSpaceNormal_L4Pri_NormRoughnessMetalness, float3x3(UV_primaryTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UV_primaryTangent.xyz) * UV_primaryTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 L4Pri_NormRoughnessMetalness = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:VectorMake, Name:VectorMake00
	float4 VectorMake00 = float4(L4Pri_NormRoughnessMetalnessBlue.x, L4Pri_NormRoughnessMetalnessAlpha.y, 0, 0);
	
	// Type:FloatNode, Name:L3_GreaseRoughness
	float4 L3_GreaseRoughness = L3_GreaseRoughness_floatVal;
	
	// Type:FloatNode, Name:L3_GreaseMetalness
	float4 L3_GreaseMetalness = L3_GreaseMetalness_floatVal;
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(L3_GreaseRoughness.x, L3_GreaseMetalness.y, 0, 0);
	
	// Type:LerpNode, Name:LerpRoughMetal
	float4 LerpRoughMetal = lerp(VectorMake00, VectorMake, mul_L3_Mask.x);
	
	// Type:NormalMapWithIntensityNode, Name:L2_NormRoughnessMetalness
	float4 textureLookup_L2_NormRoughnessMetalness = L2_NormRoughnessMetalnessTexture.Sample(SamplerStatesSampler, UV_tiling.xy * L2_NormRoughnessMetalnessTiling);
	#ifdef _MAX_
	textureLookup_L2_NormRoughnessMetalness.xyz = pow(textureLookup_L2_NormRoughnessMetalness.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_L2_NormRoughnessMetalness = (2.0f * textureLookup_L2_NormRoughnessMetalness.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 L2_NormRoughnessMetalnessGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_L2_NormRoughnessMetalness, L2_NormRoughnessMetalnessSpecPower);
	float4 L2_NormRoughnessMetalnessAlpha = textureLookup_L2_NormRoughnessMetalness.aaaa;
	float4 L2_NormRoughnessMetalnessRed = textureLookup_L2_NormRoughnessMetalness.rrrr;
	float4 L2_NormRoughnessMetalnessGreen = textureLookup_L2_NormRoughnessMetalness.gggg;
	float4 L2_NormRoughnessMetalnessBlue = textureLookup_L2_NormRoughnessMetalness.bbbb;
	tangentSpaceNormal_L2_NormRoughnessMetalness.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_L2_NormRoughnessMetalness.z = sqrt(saturate(1 - tangentSpaceNormal_L2_NormRoughnessMetalness.x*tangentSpaceNormal_L2_NormRoughnessMetalness.x - tangentSpaceNormal_L2_NormRoughnessMetalness.y*tangentSpaceNormal_L2_NormRoughnessMetalness.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_L2_NormRoughnessMetalness.xy *= g_GlobalNormalScale * L2_NormRoughnessMetalnessHeightScale.x;
	#else
	tangentSpaceNormal_L2_NormRoughnessMetalness.xy *= L2_NormRoughnessMetalnessHeightScale.x;
	#endif
	float4 L2_NormRoughnessMetalness = float4(normalize(mul(tangentSpaceNormal_L2_NormRoughnessMetalness, float3x3(UV_tilingTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UV_tilingTangent.xyz) * UV_tilingTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 L2_NormRoughnessMetalness = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:VectorMake, Name:VectorMake000
	float4 VectorMake000 = float4(L2_NormRoughnessMetalnessBlue.x, L2_NormRoughnessMetalnessAlpha.y, 0, 0);
	
	// Type:LerpNode, Name:LerpRoughMetal20
	float4 LerpRoughMetal20 = lerp(LerpRoughMetal, VectorMake000, mul_L2_Mask.x);
	
	// Type:NormalMapWithIntensityNode, Name:L1_NormRoughnessMetalness
	float4 textureLookup_L1_NormRoughnessMetalness = L1_NormRoughnessMetalnessTexture.Sample(SamplerStatesSampler, UV_tiling.xy * L1_NormRoughnessMetalnessTiling);
	#ifdef _MAX_
	textureLookup_L1_NormRoughnessMetalness.xyz = pow(textureLookup_L1_NormRoughnessMetalness.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_L1_NormRoughnessMetalness = (2.0f * textureLookup_L1_NormRoughnessMetalness.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 L1_NormRoughnessMetalnessGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_L1_NormRoughnessMetalness, L1_NormRoughnessMetalnessSpecPower);
	float4 L1_NormRoughnessMetalnessAlpha = textureLookup_L1_NormRoughnessMetalness.aaaa;
	float4 L1_NormRoughnessMetalnessRed = textureLookup_L1_NormRoughnessMetalness.rrrr;
	float4 L1_NormRoughnessMetalnessGreen = textureLookup_L1_NormRoughnessMetalness.gggg;
	float4 L1_NormRoughnessMetalnessBlue = textureLookup_L1_NormRoughnessMetalness.bbbb;
	tangentSpaceNormal_L1_NormRoughnessMetalness.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_L1_NormRoughnessMetalness.z = sqrt(saturate(1 - tangentSpaceNormal_L1_NormRoughnessMetalness.x*tangentSpaceNormal_L1_NormRoughnessMetalness.x - tangentSpaceNormal_L1_NormRoughnessMetalness.y*tangentSpaceNormal_L1_NormRoughnessMetalness.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_L1_NormRoughnessMetalness.xy *= g_GlobalNormalScale * L1_NormRoughnessMetalnessHeightScale.x;
	#else
	tangentSpaceNormal_L1_NormRoughnessMetalness.xy *= L1_NormRoughnessMetalnessHeightScale.x;
	#endif
	float4 L1_NormRoughnessMetalness = float4(normalize(mul(tangentSpaceNormal_L1_NormRoughnessMetalness, float3x3(UV_tilingTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UV_tilingTangent.xyz) * UV_tilingTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 L1_NormRoughnessMetalness = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:VectorMake, Name:VectorMake0001
	float4 VectorMake0001 = float4(L1_NormRoughnessMetalnessBlue.x, L1_NormRoughnessMetalnessAlpha.y, 0, 0);
	
	// Type:LerpNode, Name:LerpRoughMetal10
	float4 LerpRoughMetal10 = lerp(LerpRoughMetal20, VectorMake0001, mul_L1_Mask.x);
	
	// Type:SwizzleNode, Name:SwizzleX
	float4 SwizzleX = LerpRoughMetal10.xxxw;
	
	// Type:WetifyNode, Name:Wetify
	float4 WetifyDiffuse = LerpBaseColour1;
	float WetifyGloss = float(0);
	float WetifyRoughness = SwizzleX;
	#ifdef _MAX_
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyGloss, float4(lerp(1.0, g_WetDiffuse, g_WetLevel), lerp(1.0, g_WetGloss, g_WetLevel), lerp(1.0, g_WetDiffuse, g_WetLevel), 0), float3(0,1,0), 1);
	#else
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyRoughness, TrackParameter, GetWorldNormal(In).xyz, float(1));
	#endif
	
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:LerpNode, Name:LerpNorm
	float4 LerpNorm = lerp(L4Pri_NormRoughnessMetalness, WorldNormal, mul_L3_Mask.x);
	
	// Type:LerpNode, Name:LerpNorm0
	float4 LerpNorm0 = lerp(LerpNorm, L2_NormRoughnessMetalness, mul_L2_Mask.x);
	
	// Type:LerpNode, Name:LerpNorm1
	float4 LerpNorm1 = lerp(LerpNorm0, L1_NormRoughnessMetalness, mul_L1_Mask.x);
	
	// Type:NormalMapWithIntensityNode, Name:TiledNormal
	float4 textureLookup_TiledNormal = TiledNormalTexture.Sample(SamplerStatesSampler, UV_tiling.xy * TiledNormalTiling);
	#ifdef _MAX_
	textureLookup_TiledNormal.xyz = pow(textureLookup_TiledNormal.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_TiledNormal = (2.0f * textureLookup_TiledNormal.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 TiledNormalGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_TiledNormal, TiledNormalSpecPower);
	float4 TiledNormalAlpha = textureLookup_TiledNormal.aaaa;
	float4 TiledNormalRed = textureLookup_TiledNormal.rrrr;
	float4 TiledNormalGreen = textureLookup_TiledNormal.gggg;
	float4 TiledNormalBlue = textureLookup_TiledNormal.bbbb;
	tangentSpaceNormal_TiledNormal.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_TiledNormal.z = sqrt(saturate(1 - tangentSpaceNormal_TiledNormal.x*tangentSpaceNormal_TiledNormal.x - tangentSpaceNormal_TiledNormal.y*tangentSpaceNormal_TiledNormal.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_TiledNormal.xy *= g_GlobalNormalScale * TiledNormalHeightScale.x;
	#else
	tangentSpaceNormal_TiledNormal.xy *= TiledNormalHeightScale.x;
	#endif
	float4 TiledNormal = float4(normalize(mul(tangentSpaceNormal_TiledNormal, float3x3(UV_tilingTangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UV_tilingTangent.xyz) * UV_tilingTangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 TiledNormal = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:TextureNode, Name:MaskTiledNormal
	float4 MaskTiledNormal = MaskTiledNormalTexture.Sample(SamplerStatesSampler, UV_layerMasks.xy * MaskTiledNormalTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MaskTiledNormalMip = GetDebugMipColour(MaskTiledNormalTexture, SamplerStatesSampler, UV_layerMasks.xy * MaskTiledNormalTiling);
	#else
	float4 MaskTiledNormalMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MaskTiledNormalAlpha = MaskTiledNormal.aaaa;
	float4 MaskTiledNormalRed = MaskTiledNormal.rrrr;
	float4 MaskTiledNormalGreen = MaskTiledNormal.gggg;
	float4 MaskTiledNormalBlue = MaskTiledNormal.bbbb;
	Texture2D MaskTiledNormalRef = MaskTiledNormalTexture;
	
	// Type:LerpNode, Name:LerpTiledNormal
	float4 LerpTiledNormal = lerp(LerpNorm1, TiledNormal, MaskTiledNormalRed.x);
	
	// Type:SwizzleNode, Name:SwizzleY0
	float4 SwizzleY0 = LerpRoughMetal10.yyyw;
	
	// Type:UVNode, Name:UV_emissive
	float4 UV_emissive = GetTexCoord2(In).xyxy;
	float4 UV_emissiveTangent = GetWorldTangent2(In);
	float4 UV_emissiveUCoord = GetTexCoord2(In).xxxx;
	float4 UV_emissiveVCoord = GetTexCoord2(In).yyyy;
	
	// Type:TextureNode, Name:Emissive
	float4 Emissive = EmissiveTexture.Sample(g_samplerLinearWrap, UV_emissive.xy * EmissiveTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 EmissiveMip = GetDebugMipColour(EmissiveTexture, g_samplerLinearWrap, UV_emissive.xy * EmissiveTiling);
	#else
	float4 EmissiveMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 EmissiveAlpha = Emissive.aaaa;
	float4 EmissiveRed = Emissive.rrrr;
	float4 EmissiveGreen = Emissive.gggg;
	float4 EmissiveBlue = Emissive.bbbb;
	Texture2D EmissiveRef = EmissiveTexture;
	
	// Type:ExposureValuesGroupNode, Name:EmissiveEV
	float4 EmissiveEV = EmissiveEV_floatVal;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Emissive * EmissiveEV;
	
	output.BaseColor = WetifyDiffuse;
	output.Normal = LerpTiledNormal;
	output.Roughness = WetifyRoughness;
	output.Metalness = SwizzleY0;
	output.Emissive = Multiply;
	output.AmbientOcclusion = MaskAOTextureAlpha;
	output.DirectOcclusion = MaskAOTextureAlpha;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\TrackNightLightScenario.hlsl"