#include "LightScenarios\Inc\ShadowDepthLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 DiffuseTiling < string UIName = "DiffuseTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float DynamicBranch00RefValue_CarAO < string UIName = "DynamicBranch00RefValue_CarAO"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float DynamicBranch0RefValue_CarAO < string UIName = "DynamicBranch0RefValue_CarAO"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float DynamicBranch1RefValue_CarAO < string UIName = "DynamicBranch1RefValue_CarAO"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float DynamicBranchRefValue_CarAO < string UIName = "DynamicBranchRefValue_CarAO"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 EmissColourColorParam < string UIName = "EmissColourColorParam"; string UIWidget = "Color"; > = float4( 1, 1, 1, 1 );
float ExposureValuesGroup_floatVal < string UIName = "ExposureValuesGroup_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.001375 ;
float4 F0ColorParam < string UIName = "F0ColorParam"; string UIWidget = "Color"; > = float4( 0.03189603, 0.03189603, 0.03189603, 1 );
float NormalASpecPower < string UIName = "NormalASpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalATiling < string UIName = "NormalATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
bool Step0Bool_CarAO < string UIName = "Step0Bool_CarAO"; string UIWidget = "Checkbox"; > = 0;
bool Step0HardStepBool_CarAO < string UIName = "Step0HardStepBool_CarAO"; string UIWidget = "Checkbox"; > = 0;
bool Step1Bool_CarAO < string UIName = "Step1Bool_CarAO"; string UIWidget = "Checkbox"; > = 0;
bool Step1HardStepBool_CarAO < string UIName = "Step1HardStepBool_CarAO"; string UIWidget = "Checkbox"; > = 0;
bool StepBool_CarAO < string UIName = "StepBool_CarAO"; string UIWidget = "Checkbox"; > = 0;
bool StepHardStepBool_CarAO < string UIName = "StepHardStepBool_CarAO"; string UIWidget = "Checkbox"; > = 0;
int UVUVSet < string UIName = "UVUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define F0ColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 F0ColorParam : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define EmissColourColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 EmissColourColorParam : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ExposureValuesGroup_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].x)
	#else
	float ExposureValuesGroup_floatVal : packoffset(c2.x);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UVUVSet = 1;
static const float2 DiffuseTiling = float2(1, 1);
static const float DynamicBranch1RefValue_CarAO = 1;
static const float DynamicBranch00RefValue_CarAO = 1;
static const bool StepBool_CarAO = false;
static const bool StepHardStepBool_CarAO = false;
static const bool Step0Bool_CarAO = false;
static const bool Step0HardStepBool_CarAO = false;
static const float DynamicBranchRefValue_CarAO = 1;
static const float DynamicBranch0RefValue_CarAO = 1;
static const bool Step1Bool_CarAO = false;
static const bool Step1HardStepBool_CarAO = false;
static const float NormalASpecPower = 100;
static const float2 NormalATiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(DiffuseTexture, 16);
#else
#define DiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalATexture, 17);
#else
#define NormalATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_WaterNormal 1
#define MATERIAL_HAS_INPUT_WaterAmount 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_Glossiness 1
#define MATERIAL_INPUT_IS_USED_Glossiness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_PlanarReflectionOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_DebugComplexity 1
#define MATERIAL_INPUT_IS_USED_DebugComplexity 1
#define MATERIAL_HAS_INPUT_TDDOStrength 1
#define MATERIAL_HAS_INPUT_DebugModulationMap 1
#define MATERIAL_HAS_INPUT_SunBlend 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_CarAOOverride 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BaseBlinnPhong.hlsl"
#include "CarConstantBuffer.hlsl"

struct CarAOShaderFunctionOutput
{
	float4 DiffuseColor;
	float4 AmbientOcclusion;
};

CarAOShaderFunctionOutput CarAOShaderFunction(PS_IN In)
{
	// Type:UsingCarLightScenario, Name:UsingCarLightScenario0_CarAO
	float4 UsingCarLightScenario0_CarAO = IsCarLightScenario();
	
	// Type:CarIsOpenTop, Name:CarIsOpenTop0_CarAO
	float4 CarIsOpenTop0_CarAO = IsOpenTopCar();
	
	// Type:FloatNode, Name:OpenTopExposureCorrection_CarAO
	float4 OpenTopExposureCorrection_CarAO = float4(1.4, 1.4, 1.4, 1.4);
	
	// Type:FloatNode, Name:CloseTopExposureCorrection_CarAO
	float4 CloseTopExposureCorrection_CarAO = float4(1, 1, 1, 1);
	
	// Type:DynamicBranchNode, Name:DynamicBranch1_CarAO
	float4 DynamicBranch1_CarAO;
	[branch]
	if(CarIsOpenTop0_CarAO.x == DynamicBranch1RefValue_CarAO.x)
	{
		DynamicBranch1_CarAO = OpenTopExposureCorrection_CarAO;
	}
	else
	{
		DynamicBranch1_CarAO = CloseTopExposureCorrection_CarAO;
	}
	
	// Type:FloatNode, Name:TrackAO0_CarAO
	float4 TrackAO0_CarAO = float4(1, 1, 1, 1);
	
	// Type:DynamicBranchNode, Name:DynamicBranch00_CarAO
	float4 DynamicBranch00_CarAO;
	[branch]
	if(UsingCarLightScenario0_CarAO.x == DynamicBranch00RefValue_CarAO.x)
	{
		DynamicBranch00_CarAO = DynamicBranch1_CarAO;
	}
	else
	{
		DynamicBranch00_CarAO = TrackAO0_CarAO;
	}
	
	// Type:UsingCarLightScenario, Name:UsingCarLightScenario_CarAO
	float4 UsingCarLightScenario_CarAO = IsCarLightScenario();
	
	// Type:CarIsOpenTop, Name:CarIsOpenTop_CarAO
	float4 CarIsOpenTop_CarAO = IsOpenTopCar();
	
	// Type:FloatNode, Name:OpenTopMaxAO_CarAO
	float4 OpenTopMaxAO_CarAO = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:FloatNode, Name:OpenTopMinAO_CarAO
	float4 OpenTopMinAO_CarAO = float4(0.75, 0.75, 0.75, 0.75);
	
	// Type:FloatNode, Name:OpenTopMinHeight_CarAO
	float4 OpenTopMinHeight_CarAO = float4(0.25, 0.25, 0.25, 0.25);
	
	// Type:FloatNode, Name:OpenTopMaxHeight_CarAO
	float4 OpenTopMaxHeight_CarAO = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:ObjectPosNode, Name:ObjectPos_CarAO
	#ifdef _MAX_
	float4 ObjectPos_CarAO = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix).xzyw;
	#else
	float4 ObjectPos_CarAO = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix);
	#endif
	
	// Type:SwizzleNode, Name:Swizzle_CarAO
	float4 Swizzle_CarAO = ObjectPos_CarAO.yyyw;
	
	// Type:StepNode, Name:Step_CarAO
	float4 Step_CarAO = linearstep( OpenTopMinHeight_CarAO, OpenTopMaxHeight_CarAO, Swizzle_CarAO );
	
	// Type:LerpNode, Name:OpenTop_CarAO
	float4 OpenTop_CarAO = lerp(OpenTopMaxAO_CarAO, OpenTopMinAO_CarAO, Step_CarAO.x);
	
	// Type:FloatNode, Name:CloseTopMaxAO_CarAO
	float4 CloseTopMaxAO_CarAO = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:FloatNode, Name:CloseTopMinAO_CarAO
	float4 CloseTopMinAO_CarAO = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FloatNode, Name:CloseTopMinHeight_CarAO
	float4 CloseTopMinHeight_CarAO = float4(0.25, 0.25, 0.25, 0.25);
	
	// Type:FloatNode, Name:CloseTopMaxHeight_CarAO
	float4 CloseTopMaxHeight_CarAO = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:ObjectPosNode, Name:ObjectPos0_CarAO
	#ifdef _MAX_
	float4 ObjectPos0_CarAO = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix).xzyw;
	#else
	float4 ObjectPos0_CarAO = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix);
	#endif
	
	// Type:SwizzleNode, Name:Swizzle0_CarAO
	float4 Swizzle0_CarAO = ObjectPos0_CarAO.yyyw;
	
	// Type:StepNode, Name:Step0_CarAO
	float4 Step0_CarAO = linearstep( CloseTopMinHeight_CarAO, CloseTopMaxHeight_CarAO, Swizzle0_CarAO );
	
	// Type:LerpNode, Name:CloseTop_CarAO
	float4 CloseTop_CarAO = lerp(CloseTopMaxAO_CarAO, CloseTopMinAO_CarAO, Step0_CarAO.x);
	
	// Type:DynamicBranchNode, Name:DynamicBranch_CarAO
	float4 DynamicBranch_CarAO;
	[branch]
	if(CarIsOpenTop_CarAO.x == DynamicBranchRefValue_CarAO.x)
	{
		DynamicBranch_CarAO = OpenTop_CarAO;
	}
	else
	{
		DynamicBranch_CarAO = CloseTop_CarAO;
	}
	
	// Type:FloatNode, Name:TrackAO_CarAO
	float4 TrackAO_CarAO = float4(1, 1, 1, 1);
	
	// Type:DynamicBranchNode, Name:DynamicBranch0_CarAO
	float4 DynamicBranch0_CarAO;
	[branch]
	if(UsingCarLightScenario_CarAO.x == DynamicBranch0RefValue_CarAO.x)
	{
		DynamicBranch0_CarAO = DynamicBranch_CarAO;
	}
	else
	{
		DynamicBranch0_CarAO = TrackAO_CarAO;
	}
	
	// Type:BlinnPhongPixelShadernode, Name:Root_CarAO
	
	// Type:ObjectPosNode, Name:ObjectPos1_CarAO
	#ifdef _MAX_
	float4 ObjectPos1_CarAO = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix).xzyw;
	#else
	float4 ObjectPos1_CarAO = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix);
	#endif
	
	// Type:SwizzleNode, Name:Swizzle1_CarAO
	float4 Swizzle1_CarAO = ObjectPos1_CarAO.yyyw;
	
	// Type:FloatNode, Name:OpenTopMinHeight0_CarAO
	float4 OpenTopMinHeight0_CarAO = float4(0, 0, 0, 0);
	
	// Type:FloatNode, Name:OpenTopMaxHeight0_CarAO
	float4 OpenTopMaxHeight0_CarAO = float4(0.01, 0.01, 0.01, 0.01);
	
	// Type:StepNode, Name:Step1_CarAO
	float4 Step1_CarAO = linearstep( OpenTopMinHeight0_CarAO, OpenTopMaxHeight0_CarAO, Swizzle1_CarAO );
	
	// Type:FloatNode, Name:OpenTopMaxAO0_CarAO
	float4 OpenTopMaxAO0_CarAO = float4(0.2065217, 0.2065217, 0.2065217, 0.2065217);
	
	// Type:FloatNode, Name:OpenTopMinAO0_CarAO
	float4 OpenTopMinAO0_CarAO = float4(1, 1, 1, 1);
	
	// Type:LerpNode, Name:Enviro_CarAO
	float4 Enviro_CarAO = lerp(OpenTopMaxAO0_CarAO, OpenTopMinAO0_CarAO, Step1_CarAO.x);
	
	CarAOShaderFunctionOutput dataOut;
	dataOut.DiffuseColor = DynamicBranch00_CarAO;
	dataOut.AmbientOcclusion = DynamicBranch0_CarAO;
	return dataOut;
}

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:UVNode, Name:UV
	float4 UV = GetTexCoord1(In).xyxy;
	float4 UVTangent = GetWorldTangent1(In);
	float4 UVUCoord = GetTexCoord1(In).xxxx;
	float4 UVVCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:Diffuse
	float4 Diffuse = DiffuseTexture.Sample(g_samplerLinearWrap, UV.xy * DiffuseTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 DiffuseMip = GetDebugMipColour(DiffuseTexture, g_samplerLinearWrap, UV.xy * DiffuseTiling);
	#else
	float4 DiffuseMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 DiffuseAlpha = Diffuse.aaaa;
	float4 DiffuseRed = Diffuse.rrrr;
	float4 DiffuseGreen = Diffuse.gggg;
	float4 DiffuseBlue = Diffuse.bbbb;
	Texture2D DiffuseRef = DiffuseTexture;
	
	// Type:FunctionNode, Name:CarAO
	float4 CarAO;
	float4 CarAODiffuseColor;
	float4 CarAOAmbientOcclusion;
	{
		CarAOShaderFunctionOutput funcData = CarAOShaderFunction(In);
		CarAO = funcData.DiffuseColor;
		CarAODiffuseColor = funcData.DiffuseColor;
		CarAOAmbientOcclusion = funcData.AmbientOcclusion;
	}
	
	// Type:MultiplyNode, Name:Mul_InCarDiff
	float4 Mul_InCarDiff = Diffuse * CarAODiffuseColor;
	
	// Type:NormalMapNode, Name:NormalA
	float4 textureLookup_NormalA = NormalATexture.Sample(g_samplerLinearWrap, GetTexCoord0(In).xy * NormalATiling);
	#ifdef _MAX_
	textureLookup_NormalA.xyz = pow(textureLookup_NormalA.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalA = (2.0f * textureLookup_NormalA.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalAGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalA, NormalASpecPower);
	float4 NormalAAlpha = textureLookup_NormalA.aaaa;
	float4 NormalARed = textureLookup_NormalA.rrrr;
	float4 NormalAGreen = textureLookup_NormalA.gggg;
	float4 NormalABlue = textureLookup_NormalA.bbbb;
	tangentSpaceNormal_NormalA.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalA.z = sqrt(saturate(1 - tangentSpaceNormal_NormalA.x*tangentSpaceNormal_NormalA.x - tangentSpaceNormal_NormalA.y*tangentSpaceNormal_NormalA.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalA.xy *= g_GlobalNormalScale;
	#endif
	float4 NormalA = float4(normalize(mul(tangentSpaceNormal_NormalA, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalA = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:ColorNode, Name:F0
	float4 F0 = F0ColorParam;
	float4 F0Red = F0ColorParam.rrrr;
	float4 F0Green = F0ColorParam.gggg;
	float4 F0Blue = F0ColorParam.bbbb;
	float4 F0Alpha = F0ColorParam.aaaa;
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = F0 * CarAODiffuseColor;
	
	// Type:ColorNode, Name:EmissColour
	float4 EmissColour = EmissColourColorParam;
	float4 EmissColourRed = EmissColourColorParam.rrrr;
	float4 EmissColourGreen = EmissColourColorParam.gggg;
	float4 EmissColourBlue = EmissColourColorParam.bbbb;
	float4 EmissColourAlpha = EmissColourColorParam.aaaa;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = DiffuseAlpha * EmissColour;
	
	// Type:ExposureValuesGroupNode, Name:ExposureValuesGroup
	float4 ExposureValuesGroup = ExposureValuesGroup_floatVal;
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = Multiply * ExposureValuesGroup;
	
	// Type:MultiplyNode, Name:Mul_InCarAO
	float4 Mul_InCarAO = NormalABlue * CarAOAmbientOcclusion;
	
	// Type:Vector4Node, Name:Vector4
	float4 Vector4 = float4(1, 0.5, 0, 1) ;
	
	output.DiffuseColor = Mul_InCarDiff;
	output.Normal = NormalA;
	output.F0 = Multiply1;
	output.Glossiness = NormalAAlpha;
	output.Emissive = Multiply2;
	output.AmbientOcclusion = Mul_InCarAO;
	output.DirectOcclusion = NormalABlue;
	output.DebugComplexity = Vector4;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\ShadowDepthLightScenario.hlsl"