#include "LightScenarios\Inc\TrackDebugLightingLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 BaseColorColorParam < string UIName = "BaseColorColorParam"; string UIWidget = "Color"; > = float4( 0.6172066, 0.04817183, 0.6307572, 1 );
float ChromaticMul_floatVal < string UIName = "ChromaticMul_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 5 ;
float ChromaticSaturation_floatVal < string UIName = "ChromaticSaturation_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.4 ;
float ChromaticSpeedUTimeScale < string UIName = "ChromaticSpeedUTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.25 ;
float ChromaticSpeedVTimeScale < string UIName = "ChromaticSpeedVTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.43 ;
float ChromaticStep0_floatVal < string UIName = "ChromaticStep0_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = -5 ;
float ChromaticStep1_floatVal < string UIName = "ChromaticStep1_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = -3 ;
float ColorSwitchStep_floatVal < string UIName = "ColorSwitchStep_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.1 ;
float ColorSwitchStepFade_floatVal < string UIName = "ColorSwitchStepFade_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.9 ;
float4 CrossColorColorParam < string UIName = "CrossColorColorParam"; string UIWidget = "Color"; > = float4( 0.9646863, 0.5149177, 0.9822506, 0.9882353 );
float4 DepthEffectColor0ColorParam < string UIName = "DepthEffectColor0ColorParam"; string UIWidget = "Color"; > = float4( 0.03688945, 0.9130986, 0.8879231, 1 );
float DepthEffectScale_floatVal < string UIName = "DepthEffectScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1.8 ;
float DistanceFaderEndFade < string UIName = "DistanceFaderEndFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 400 ;
float DistanceFaderStartFade < string UIName = "DistanceFaderStartFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 50 ;
float DistanceStarStart_floatVal < string UIName = "DistanceStarStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 75 ;
float DistanceStarSwap_floatVal < string UIName = "DistanceStarSwap_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 FeatureTexture0Tiling < string UIName = "FeatureTexture0Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 FeatureTexture1Tiling < string UIName = "FeatureTexture1Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 FeatureTexture2Tiling < string UIName = "FeatureTexture2Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float Float0_floatVal < string UIName = "Float0_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1.597826 ;
float Float1_floatVal < string UIName = "Float1_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1.5 ;
float Float13_floatVal < string UIName = "Float13_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1450 ;
float Float3_floatVal < string UIName = "Float3_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.5 ;
float Float4_floatVal < string UIName = "Float4_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.9804348 ;
float Float5_floatVal < string UIName = "Float5_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.0075 ;
float Float60_floatVal < string UIName = "Float60_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float Float7_floatVal < string UIName = "Float7_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float Float8_floatVal < string UIName = "Float8_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.6413044 ;
float NightAlphaScale_floatVal < string UIName = "NightAlphaScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.2 ;
float4 NoiseTextureTiling < string UIName = "NoiseTextureTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 OnOffTextureTiling < string UIName = "OnOffTextureTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 10, 450, 0, 0 );
float RimIntensity_floatVal < string UIName = "RimIntensity_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.4543478 ;
float StarFadeLerpMax_floatVal < string UIName = "StarFadeLerpMax_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float StarFadeLerpMin_floatVal < string UIName = "StarFadeLerpMin_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float StarTiling_floatVal < string UIName = "StarTiling_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 45 ;
bool Step0Bool < string UIName = "Step0Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step0HardStepBool < string UIName = "Step0HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool Step1Bool < string UIName = "Step1Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step1HardStepBool < string UIName = "Step1HardStepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepBool < string UIName = "StepBool"; string UIWidget = "Checkbox"; > = 0;
bool StepHardStepBool < string UIName = "StepHardStepBool"; string UIWidget = "Checkbox"; > = 0;
float StripeEffectOnAbberation_floatVal < string UIName = "StripeEffectOnAbberation_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.1 ;
float StripeStrength_floatVal < string UIName = "StripeStrength_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.4347826 ;
int UV0UVSet < string UIName = "UV0UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 UVPannerXYTimeScale < string UIName = "UVPannerXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0, 2.173913E-05, 0, 0 );
float WallFadeEndFade < string UIName = "WallFadeEndFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1000 ;
float WallFadeStartFade < string UIName = "WallFadeStartFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 600 ;
float WallMaxSolid_floatVal < string UIName = "WallMaxSolid_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.2 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define BaseColorColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 BaseColorColorParam : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define CrossColorColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 CrossColorColorParam : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DepthEffectColor0ColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2]))
	#else
	float4 DepthEffectColor0ColorParam : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define OnOffTextureTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].xy))
	#else
	float2 OnOffTextureTiling : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define StarTiling_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float StarTiling_floatVal : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float3_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].y)
	#else
	float Float3_floatVal : packoffset(c4.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DistanceStarStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].z)
	#else
	float DistanceStarStart_floatVal : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DistanceStarSwap_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].w)
	#else
	float DistanceStarSwap_floatVal : packoffset(c4.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define StripeStrength_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)
	#else
	float StripeStrength_floatVal : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define StripeEffectOnAbberation_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)
	#else
	float StripeEffectOnAbberation_floatVal : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ChromaticSpeedUTimeScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)
	#else
	float ChromaticSpeedUTimeScale : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ChromaticSpeedVTimeScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)
	#else
	float ChromaticSpeedVTimeScale : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ChromaticMul_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)
	#else
	float ChromaticMul_floatVal : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ChromaticStep0_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].y)
	#else
	float ChromaticStep0_floatVal : packoffset(c6.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ChromaticStep1_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].z)
	#else
	float ChromaticStep1_floatVal : packoffset(c6.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DistanceFaderStartFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].w)
	#else
	float DistanceFaderStartFade : packoffset(c6.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DistanceFaderEndFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].x)
	#else
	float DistanceFaderEndFade : packoffset(c7.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define StarFadeLerpMin_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].y)
	#else
	float StarFadeLerpMin_floatVal : packoffset(c7.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define StarFadeLerpMax_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].z)
	#else
	float StarFadeLerpMax_floatVal : packoffset(c7.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ColorSwitchStep_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].w)
	#else
	float ColorSwitchStep_floatVal : packoffset(c7.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ColorSwitchStepFade_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].x)
	#else
	float ColorSwitchStepFade_floatVal : packoffset(c8.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define ChromaticSaturation_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].y)
	#else
	float ChromaticSaturation_floatVal : packoffset(c8.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float0_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].z)
	#else
	float Float0_floatVal : packoffset(c8.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DepthEffectScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].w)
	#else
	float DepthEffectScale_floatVal : packoffset(c8.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float5_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].x)
	#else
	float Float5_floatVal : packoffset(c9.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float7_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].y)
	#else
	float Float7_floatVal : packoffset(c9.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float4_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].z)
	#else
	float Float4_floatVal : packoffset(c9.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define WallFadeStartFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].w)
	#else
	float WallFadeStartFade : packoffset(c9.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define WallFadeEndFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].x)
	#else
	float WallFadeEndFade : packoffset(c10.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define WallMaxSolid_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].y)
	#else
	float WallMaxSolid_floatVal : packoffset(c10.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float60_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].z)
	#else
	float Float60_floatVal : packoffset(c10.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float13_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].w)
	#else
	float Float13_floatVal : packoffset(c10.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define RimIntensity_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].x)
	#else
	float RimIntensity_floatVal : packoffset(c11.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float8_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].y)
	#else
	float Float8_floatVal : packoffset(c11.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float1_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].z)
	#else
	float Float1_floatVal : packoffset(c11.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define NightAlphaScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].w)
	#else
	float NightAlphaScale_floatVal : packoffset(c11.w);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UV0UVSet = 0;
static const float2 UVPannerXYTimeScale = float2(0, 2.173913E-05);
static const float2 NoiseTextureTiling = float2(1, 1);
static const float2 FeatureTexture0Tiling = float2(1, 1);
static const bool Step0Bool = false;
static const bool Step0HardStepBool = false;
static const float2 FeatureTexture1Tiling = float2(1, 1);
static const float2 FeatureTexture2Tiling = float2(1, 1);
static const bool StepBool = false;
static const bool StepHardStepBool = false;
static const bool Step1Bool = false;
static const bool Step1HardStepBool = false;

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(FeatureTexture0Texture, 16);
#else
#define FeatureTexture0Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(FeatureTexture1Texture, 17);
#else
#define FeatureTexture1Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(FeatureTexture2Texture, 18);
#else
#define FeatureTexture2Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NoiseTextureTexture, 19);
#else
#define NoiseTextureTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(OnOffTextureTexture, 20);
#else
#define OnOffTextureTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_INPUT_IS_USED_AlphaBlend 1
// Alpha
#define IS_ALPHA_BLENDED 1
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\ARBarrier.hlsl"
#include "Panner.hlsl"
#include "Blend.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:ColorNode, Name:BaseColor
	float4 BaseColor = BaseColorColorParam;
	float4 BaseColorRed = BaseColorColorParam.rrrr;
	float4 BaseColorGreen = BaseColorColorParam.gggg;
	float4 BaseColorBlue = BaseColorColorParam.bbbb;
	float4 BaseColorAlpha = BaseColorColorParam.aaaa;
	
	// Type:ColorNode, Name:CrossColor
	float4 CrossColor = CrossColorColorParam;
	float4 CrossColorRed = CrossColorColorParam.rrrr;
	float4 CrossColorGreen = CrossColorColorParam.gggg;
	float4 CrossColorBlue = CrossColorColorParam.bbbb;
	float4 CrossColorAlpha = CrossColorColorParam.aaaa;
	
	// Type:UVNode, Name:UV0
	float4 UV0 = GetTexCoord0(In).xyxy;
	float4 UV0Tangent = GetWorldTangent0(In);
	float4 UV0UCoord = GetTexCoord0(In).xxxx;
	float4 UV0VCoord = GetTexCoord0(In).yyyy;
	
	// Type:UVPannerNode, Name:UVPanner
	float4 UVPanner = PanTextureCoordinates(UV0.xy, g_Time * UVPannerXYTimeScale.xy).xyxy;
	
	// Type:FloatNode, Name:StarTiling
	float4 StarTiling = StarTiling_floatVal;
	
	// Type:FloatNode, Name:Float3
	float4 Float3 = Float3_floatVal;
	
	// Type:ViewDistanceNode, Name:ViewDistance
	float4 ViewDistance = distance(GetWorldPos(In).xyz, g_EyePos.xyz).xxxx;
	// Type:FloatNode, Name:DistanceStarStart
	float4 DistanceStarStart = DistanceStarStart_floatVal;
	
	// Type:AddNode, Name:Add4
	float4 Add4 = ViewDistance + DistanceStarStart;
	
	// Type:FloatNode, Name:DistanceStarSwap
	float4 DistanceStarSwap = DistanceStarSwap_floatVal;
	
	// Type:MultiplyNode, Name:Multiply4
	float4 Multiply4 = Add4 * DistanceStarSwap;
	
	// Type:FloatNode, Name:Float2
	float4 Float2 = float4(0, 0, 0, 0);
	
	// Type:ClampNode, Name:Clamp
	float4 Clamp = Multiply4;
	Clamp = max(Clamp, Float2);
	
	// Type:ObjectScaleNode, Name:ObjectScale
	float4 ObjectScale = GetMatrixScale(g_WorldMatrix);
	
	// Type:DivideNode, Name:Divide
	float4 Divide = Clamp / ObjectScale;
	
	// Type:Log2Node, Name:Log2
	float4 Log2 = log2( Divide );
	
	// Type:FracNode, Name:Frac1
	float4 Frac1 = frac(Log2);
	
	// Type:SubstractNode, Name:Substract0
	float4 Substract0 = Log2 - Frac1;
	
	// Type:PowNode, Name:Pow1
	float4 Pow1 = pow( Float3, Substract0 );
	
	// Type:MultiplyNode, Name:Multiply5
	float4 Multiply5 = StarTiling * Pow1;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = UVPanner * Multiply5;
	
	// Type:SwizzleNode, Name:Swizzle
	float4 Swizzle = Multiply.xxxx;
	
	// Type:TextureNode, Name:OnOffTexture
	float4 OnOffTexture = OnOffTextureTexture.Sample(g_samplerLinearWrap, UV0.xy * OnOffTextureTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 OnOffTextureMip = GetDebugMipColour(OnOffTextureTexture, g_samplerLinearWrap, UV0.xy * OnOffTextureTiling);
	#else
	float4 OnOffTextureMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 OnOffTextureAlpha = OnOffTexture.aaaa;
	float4 OnOffTextureRed = OnOffTexture.rrrr;
	float4 OnOffTextureGreen = OnOffTexture.gggg;
	float4 OnOffTextureBlue = OnOffTexture.bbbb;
	Texture2D OnOffTextureRef = OnOffTextureTexture;
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(1, 1, 1, 1);
	
	// Type:FloatNode, Name:StripeStrength
	float4 StripeStrength = StripeStrength_floatVal;
	
	// Type:LerpNode, Name:Lerp6
	float4 Lerp6 = lerp(OnOffTexture, Float, StripeStrength.x);
	
	// Type:FloatNode, Name:StripeEffectOnAbberation
	float4 StripeEffectOnAbberation = StripeEffectOnAbberation_floatVal;
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = Lerp6 * StripeEffectOnAbberation;
	
	// Type:TimeNode, Name:ChromaticSpeedU
	float4 ChromaticSpeedU = ChromaticSpeedUTimeScale * g_Time;
	
	// Type:TimeNode, Name:ChromaticSpeedV
	float4 ChromaticSpeedV = ChromaticSpeedVTimeScale * g_Time;
	
	// Type:VectorMake, Name:VectorMake5
	float4 VectorMake5 = float4(ChromaticSpeedU.x, ChromaticSpeedV.y, 0, 0);
	
	// Type:FracNode, Name:Frac0
	float4 Frac0 = frac(VectorMake5);
	
	// Type:TextureNode, Name:NoiseTexture
	float4 NoiseTexture = NoiseTextureTexture.Sample(g_samplerLinearWrap, Frac0.xy * NoiseTextureTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 NoiseTextureMip = GetDebugMipColour(NoiseTextureTexture, g_samplerLinearWrap, Frac0.xy * NoiseTextureTiling);
	#else
	float4 NoiseTextureMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 NoiseTextureAlpha = NoiseTexture.aaaa;
	float4 NoiseTextureRed = NoiseTexture.rrrr;
	float4 NoiseTextureGreen = NoiseTexture.gggg;
	float4 NoiseTextureBlue = NoiseTexture.bbbb;
	Texture2D NoiseTextureRef = NoiseTextureTexture;
	
	// Type:FloatNode, Name:ChromaticMul
	float4 ChromaticMul = ChromaticMul_floatVal;
	
	// Type:FloatNode, Name:ChromaticStep0
	float4 ChromaticStep0 = ChromaticStep0_floatVal;
	
	// Type:FloatNode, Name:ChromaticStep1
	float4 ChromaticStep1 = ChromaticStep1_floatVal;
	
	// Type:DistanceFaderNode, Name:DistanceFader
	float4 DistanceFader = 1 - saturate( ( distance(GetWorldPos(In), g_EyePos.xyz) - DistanceFaderStartFade) / (DistanceFaderEndFade - DistanceFaderStartFade) );
	
	// Type:LerpNode, Name:Lerp2
	float4 Lerp2 = lerp(ChromaticStep0, ChromaticStep1, DistanceFader.x);
	
	// Type:MultiplyAddNode, Name:MultiplyAdd1
	float4 MultiplyAdd1 = NoiseTexture * ChromaticMul + Lerp2;
	
	// Type:SaturateNode, Name:Saturate1
	float4 Saturate1 = saturate( MultiplyAdd1 ); 
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = Multiply1 * Saturate1;
	
	// Type:AddNode, Name:Add
	float4 Add = Swizzle + Multiply0;
	
	// Type:SwizzleNode, Name:Swizzle0
	float4 Swizzle0 = Multiply.yyyy;
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(Add.x, Swizzle0.y, 0, 0);
	
	// Type:TextureNode, Name:FeatureTexture0
	float4 FeatureTexture0 = FeatureTexture0Texture.Sample(g_samplerLinearWrap, VectorMake.xy * FeatureTexture0Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 FeatureTexture0Mip = GetDebugMipColour(FeatureTexture0Texture, g_samplerLinearWrap, VectorMake.xy * FeatureTexture0Tiling);
	#else
	float4 FeatureTexture0Mip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 FeatureTexture0Alpha = FeatureTexture0.aaaa;
	float4 FeatureTexture0Red = FeatureTexture0.rrrr;
	float4 FeatureTexture0Green = FeatureTexture0.gggg;
	float4 FeatureTexture0Blue = FeatureTexture0.bbbb;
	Texture2D FeatureTexture0Ref = FeatureTexture0Texture;
	
	// Type:FloatNode, Name:StarFadeLerpMin
	float4 StarFadeLerpMin = StarFadeLerpMin_floatVal;
	
	// Type:FloatNode, Name:StarFadeLerpMax
	float4 StarFadeLerpMax = StarFadeLerpMax_floatVal;
	
	// Type:FracNode, Name:Frac
	float4 Frac = frac(Log2);
	
	// Type:StepNode, Name:Step0
	float4 Step0 = linearstep( StarFadeLerpMin, StarFadeLerpMax, Frac );
	
	// Type:OneMinusNode, Name:OneMinus1
	float4 OneMinus1 = 1 - Step0;
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(FeatureTexture0Red, FeatureTexture0Green, OneMinus1.x);
	
	// Type:TextureNode, Name:FeatureTexture1
	float4 FeatureTexture1 = FeatureTexture1Texture.Sample(g_samplerLinearWrap, Multiply.xy * FeatureTexture1Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 FeatureTexture1Mip = GetDebugMipColour(FeatureTexture1Texture, g_samplerLinearWrap, Multiply.xy * FeatureTexture1Tiling);
	#else
	float4 FeatureTexture1Mip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 FeatureTexture1Alpha = FeatureTexture1.aaaa;
	float4 FeatureTexture1Red = FeatureTexture1.rrrr;
	float4 FeatureTexture1Green = FeatureTexture1.gggg;
	float4 FeatureTexture1Blue = FeatureTexture1.bbbb;
	Texture2D FeatureTexture1Ref = FeatureTexture1Texture;
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(FeatureTexture1Red, FeatureTexture1Green, OneMinus1.x);
	
	// Type:SubstractNode, Name:Substract
	float4 Substract = Swizzle - Multiply0;
	
	// Type:VectorMake, Name:VectorMake0
	float4 VectorMake0 = float4(Substract.x, Swizzle0.y, 0, 0);
	
	// Type:TextureNode, Name:FeatureTexture2
	float4 FeatureTexture2 = FeatureTexture2Texture.Sample(g_samplerLinearWrap, VectorMake0.xy * FeatureTexture2Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 FeatureTexture2Mip = GetDebugMipColour(FeatureTexture2Texture, g_samplerLinearWrap, VectorMake0.xy * FeatureTexture2Tiling);
	#else
	float4 FeatureTexture2Mip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 FeatureTexture2Alpha = FeatureTexture2.aaaa;
	float4 FeatureTexture2Red = FeatureTexture2.rrrr;
	float4 FeatureTexture2Green = FeatureTexture2.gggg;
	float4 FeatureTexture2Blue = FeatureTexture2.bbbb;
	Texture2D FeatureTexture2Ref = FeatureTexture2Texture;
	
	// Type:LerpNode, Name:Lerp1
	float4 Lerp1 = lerp(FeatureTexture2Red, FeatureTexture2Green, OneMinus1.x);
	
	// Type:VectorMake, Name:VectorMake1
	float4 VectorMake1 = float4(Lerp.x, Lerp0.y, Lerp1.z, 0);
	
	// Type:FloatNode, Name:ColorSwitchStep
	float4 ColorSwitchStep = ColorSwitchStep_floatVal;
	
	// Type:FloatNode, Name:ColorSwitchStepFade
	float4 ColorSwitchStepFade = ColorSwitchStepFade_floatVal;
	
	// Type:StepNode, Name:Step
	float4 Step = linearstep( ColorSwitchStep, ColorSwitchStepFade, Saturate1 );
	
	// Type:LerpNode, Name:Lerp5
	float4 Lerp5 = lerp(CrossColor, VectorMake1, Step.x);
	
	// Type:AddNode, Name:Add0
	float4 Add0 = Lerp + Lerp0;
	
	// Type:AddNode, Name:Add1
	float4 Add1 = Add0 + Lerp1;
	
	// Type:FloatNode, Name:ChromaticSaturation
	float4 ChromaticSaturation = ChromaticSaturation_floatVal;
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = Add1 * ChromaticSaturation;
	
	// Type:SaturateNode, Name:Saturate
	float4 Saturate = saturate( Multiply2 ); 
	
	// Type:LerpNode, Name:Lerp4
	float4 Lerp4 = lerp(BaseColor, Lerp5, Saturate.x);
	
	// Type:ColorNode, Name:DepthEffectColor0
	float4 DepthEffectColor0 = DepthEffectColor0ColorParam;
	float4 DepthEffectColor0Red = DepthEffectColor0ColorParam.rrrr;
	float4 DepthEffectColor0Green = DepthEffectColor0ColorParam.gggg;
	float4 DepthEffectColor0Blue = DepthEffectColor0ColorParam.bbbb;
	float4 DepthEffectColor0Alpha = DepthEffectColor0ColorParam.aaaa;
	
	// Type:FloatNode, Name:Float6
	float4 Float6 = float4(1E-05, 1E-05, 1E-05, 1E-05);
	
	// Type:EliminatorDistanceToWallNode, Name:EliminatorDistanceToWall
	g_DisableBarrierTransparency = true; 
	float4 EliminatorDistanceToWall = g_ElimDistanceToWall;
	
	// Type:MultiplyNode, Name:Multiply9
	float4 Multiply9 = Float6 * EliminatorDistanceToWall;
	
	// Type:MultiplyNode, Name:Multiply12
	float4 Multiply12 = Multiply9 * Float6;
	
	// Type:FloatNode, Name:Float0
	float4 Float0 = Float0_floatVal;
	
	// Type:AddNode, Name:Add2
	float4 Add2 = Multiply12 + Float0;
	
	// Type:DepthFadeBlendNode, Name:DepthFadeBlend
	float linearFarDistanceDepthFadeBlend = NonLinearToLinearDepth(DepthBufferTexture[In.pos.xy]);
	float linearOurDistanceDepthFadeBlend = NonLinearToLinearDepth(1 - In.pos.z);
	float linearDifferenceDepthFadeBlend = (linearFarDistanceDepthFadeBlend - linearOurDistanceDepthFadeBlend);float4 DepthFadeBlend = (linearDifferenceDepthFadeBlend < -0.1) ? 1 : saturate(linearDifferenceDepthFadeBlend / Add2.x);
	
	// Type:SaturateNode, Name:Saturate3
	float4 Saturate3 = saturate( DepthFadeBlend ); 
	
	// Type:OneMinusNode, Name:OneMinus0
	float4 OneMinus0 = 1 - Saturate3;
	
	// Type:FloatNode, Name:DepthEffectScale
	float4 DepthEffectScale = DepthEffectScale_floatVal;
	
	// Type:MultiplyNode, Name:Multiply000
	float4 Multiply000 = OneMinus0 * DepthEffectScale;
	
	// Type:LerpNode, Name:Lerp8
	float4 Lerp8 = lerp(Lerp4, DepthEffectColor0, Multiply000.x);
	
	// Type:FloatNode, Name:Float5
	float4 Float5 = Float5_floatVal;
	
	// Type:FloatNode, Name:Float7
	float4 Float7 = Float7_floatVal;
	
	// Type:ViewVectorNode, Name:ViewVector
	float4 ViewVector = float4(GetViewVector(), 0);
	// Type:NegateNode, Name:Negate
	float4 Negate = -1.0f * ViewVector;
	
	// Type:GlobalDiffuseCubeNode, Name:GlobalDiffuseCube
	float4 GlobalDiffuseCube = GetGlobalDiffuseCubeLookup(g_samplerLinearWrap, Negate.xyz);
	float4 GlobalDiffuseCubeAlpha = GlobalDiffuseCube.aaaa;
	// Type:Vector4Node, Name:Vector40
	float4 Vector40 = float4(0.212, 0.71, 0.07, 0) ;
	
	// Type:DotNode, Name:Dot
	float4 Dot = dot(GlobalDiffuseCube, Vector40);
	
	// Type:LerpNode, Name:Lerp3
	float4 Lerp3 = lerp(Float5, Float7, Dot.x);
	
	// Type:MultiplyNode, Name:Multiply11
	float4 Multiply11 = Lerp8 * Lerp3;
	
	// Type:FloatNode, Name:Float4
	float4 Float4 = Float4_floatVal;
	
	// Type:DistanceFaderNode, Name:WallFade
	float4 WallFade = 1 - saturate( ( distance(GetWorldPos(In), g_EyePos.xyz) - WallFadeStartFade) / (WallFadeEndFade - WallFadeStartFade) );
	
	// Type:OneMinusNode, Name:OneMinus
	float4 OneMinus = 1 - Saturate1;
	
	// Type:LerpNode, Name:Lerp7
	float4 Lerp7 = lerp(Lerp6, Float, OneMinus.x);
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = WallFade * Lerp7;
	
	// Type:MultiplyNode, Name:Multiply7
	float4 Multiply7 = Float4 * Multiply3;
	
	// Type:FloatNode, Name:WallMaxSolid
	float4 WallMaxSolid = WallMaxSolid_floatVal;
	
	// Type:MaxNode, Name:Max0
	float4 Max0 = max(Multiply000, Saturate);
	
	// Type:MultiplyAddNode, Name:MultiplyAdd
	float4 MultiplyAdd = Multiply7 * WallMaxSolid + Max0;
	
	// Type:EyePosNode, Name:EyePos0
	float4 EyePos0 = float4(g_EyePos.xyz, 1);
	// Type:SwizzleNode, Name:Swizzle10
	float4 Swizzle10 = EyePos0.yyyy;
	
	// Type:FloatNode, Name:Float60
	float4 Float60 = Float60_floatVal;
	
	// Type:AddNode, Name:Add50
	float4 Add50 = Swizzle10 + Float60;
	
	// Type:FloatNode, Name:Float13
	float4 Float13 = Float13_floatVal;
	
	// Type:AddNode, Name:Add3
	float4 Add3 = Add50 + Float13;
	
	// Type:WorldPosNode, Name:WorldPos
	float4 WorldPos = float4(GetWorldPos(In).xyz, 1);
	// Type:SwizzleNode, Name:Swizzle2
	float4 Swizzle2 = WorldPos.yyyy;
	
	// Type:StepNode, Name:Step1
	float4 Step1 = linearstep( Add50, Add3, Swizzle2 );
	
	// Type:OneMinusNode, Name:OneMinus2
	float4 OneMinus2 = 1 - Step1;
	
	// Type:MultiplyNode, Name:Multiply10
	float4 Multiply10 = MultiplyAdd * OneMinus2;
	
	// Type:FloatNode, Name:RimIntensity
	float4 RimIntensity = RimIntensity_floatVal;
	
	// Type:FloatNode, Name:Float8
	float4 Float8 = Float8_floatVal;
	
	// Type:MultiplyNode, Name:Multiply6
	float4 Multiply6 = OneMinus2 * Float8;
	
	// Type:SaturateNode, Name:Saturate4
	float4 Saturate4 = saturate( Multiply6 ); 
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = Float1_floatVal;
	
	// Type:PowNode, Name:Pow0
	float4 Pow0 = pow( Saturate4, Float1 );
	
	// Type:SaturateNode, Name:Saturate0
	float4 Saturate0 = saturate( Pow0 ); 
	
	// Type:MultiplyNode, Name:RimIntensity0
	float4 RimIntensity0 = RimIntensity * Saturate0;
	
	// Type:MaxNode, Name:Max1
	float4 Max1 = max(Multiply10, RimIntensity0);
	
	// Type:FloatNode, Name:NightAlphaScale
	float4 NightAlphaScale = NightAlphaScale_floatVal;
	
	// Type:MultiplyNode, Name:Multiply8
	float4 Multiply8 = Max1 * NightAlphaScale;
	
	// Type:SaturateNode, Name:Saturate2
	float4 Saturate2 = saturate( Multiply8 ); 
	
	output.DiffuseColor = Multiply11;
	output.AlphaBlend = Saturate2;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\TrackDebugLightingLightScenario.hlsl"