#include "LightScenarios\Inc\TrackFullNightLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float Angle_floatVal < string UIName = "Angle_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float AOMin0_floatVal < string UIName = "AOMin0_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.1 ;
float4 AOTiling < string UIName = "AOTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 DetailTileVector4 < string UIName = "DetailTileVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 1, 1 );
float DynamicBranch00RefValue_CarAO0 < string UIName = "DynamicBranch00RefValue_CarAO0"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float DynamicBranch0RefValue_CarAO0 < string UIName = "DynamicBranch0RefValue_CarAO0"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float DynamicBranch1RefValue_CarAO0 < string UIName = "DynamicBranch1RefValue_CarAO0"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float DynamicBranchRefValue_CarAO0 < string UIName = "DynamicBranchRefValue_CarAO0"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float F0_floatVal < string UIName = "F0_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 FadeTiling < string UIName = "FadeTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float FuzzAmount_floatVal < string UIName = "FuzzAmount_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 GlobalAOTiling < string UIName = "GlobalAOTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float Gloss_floatVal < string UIName = "Gloss_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LogoF0_floatVal < string UIName = "LogoF0_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LogoGloss_floatVal < string UIName = "LogoGloss_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 LogoTiling < string UIName = "LogoTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 LogoTintColorParam < string UIName = "LogoTintColorParam"; string UIWidget = "Color"; > = float4( 1, 1, 1, 1 );
float4 MainColourColorParam < string UIName = "MainColourColorParam"; string UIWidget = "Color"; > = float4( 1, 1, 1, 1 );
int MultiChoiceNormalBlend0NormalBlendModes < string UIName = "MultiChoiceNormalBlend0NormalBlendModes"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int MultiChoiceNormalBlendNormalBlendModes < string UIName = "MultiChoiceNormalBlendNormalBlendModes"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float NormHeightScale < string UIName = "NormHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float NormSpecPower < string UIName = "NormSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormTiling < string UIName = "NormTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 PanVector4 < string UIName = "PanVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0, 0, 0, 0 );
float4 PatternTiling < string UIName = "PatternTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float PeachfuzzEnd_floatVal < string UIName = "PeachfuzzEnd_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float PeachFuzzPower_floatVal < string UIName = "PeachFuzzPower_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 7.065217 ;
float PeachfuzzStart_floatVal < string UIName = "PeachfuzzStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float PeachFuzzWrap_floatVal < string UIName = "PeachFuzzWrap_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.8043478 ;
float Scale_floatVal < string UIName = "Scale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
bool Step0Bool_CarAO0 < string UIName = "Step0Bool_CarAO0"; string UIWidget = "Checkbox"; > = 0;
bool Step0HardStepBool_CarAO0 < string UIName = "Step0HardStepBool_CarAO0"; string UIWidget = "Checkbox"; > = 0;
bool StepBool_CarAO0 < string UIName = "StepBool_CarAO0"; string UIWidget = "Checkbox"; > = 0;
bool StepHardStepBool_CarAO0 < string UIName = "StepHardStepBool_CarAO0"; string UIWidget = "Checkbox"; > = 0;
float4 TileAOTiling < string UIName = "TileAOTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float TileNormHeightScale < string UIName = "TileNormHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float TileNormSpecPower < string UIName = "TileNormSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 TileNormTiling < string UIName = "TileNormTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float TimeTimeScale < string UIName = "TimeTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int UV0UVSet < string UIName = "UV0UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 4 ;
int UV11UVSet < string UIName = "UV11UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int UV1UVSet < string UIName = "UV1UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int UV2UVSet < string UIName = "UV2UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
float4 WindMaskTiling < string UIName = "WindMaskTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float WindNorm_Amnt_floatVal < string UIName = "WindNorm_Amnt_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float WindNorm_Offset_floatVal < string UIName = "WindNorm_Offset_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float WindNorm_Speed_floatVal < string UIName = "WindNorm_Speed_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.04 ;
float WindNormHeightScale < string UIName = "WindNormHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 8 ;
float WindNormSpecPower < string UIName = "WindNormSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 WindNormTiling < string UIName = "WindNormTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define MainColourColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 MainColourColorParam : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define PanVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 PanVector4 : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LogoTintColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2]))
	#else
	float4 LogoTintColorParam : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DetailTileVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3]))
	#else
	float4 DetailTileVector4 : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define PatternTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].xy))
	#else
	float2 PatternTiling : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define WindNormTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].zw))
	#else
	float2 WindNormTiling : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Scale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)
	#else
	float Scale_floatVal : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Angle_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)
	#else
	float Angle_floatVal : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define NormHeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)
	#else
	float NormHeightScale : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TileNormHeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)
	#else
	float TileNormHeightScale : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define WindNorm_Speed_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)
	#else
	float WindNorm_Speed_floatVal : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define WindNorm_Offset_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].y)
	#else
	float WindNorm_Offset_floatVal : packoffset(c6.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define WindNormHeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].z)
	#else
	float WindNormHeightScale : packoffset(c6.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define WindNorm_Amnt_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].w)
	#else
	float WindNorm_Amnt_floatVal : packoffset(c6.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F0_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].x)
	#else
	float F0_floatVal : packoffset(c7.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LogoF0_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].y)
	#else
	float LogoF0_floatVal : packoffset(c7.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Gloss_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].z)
	#else
	float Gloss_floatVal : packoffset(c7.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LogoGloss_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].w)
	#else
	float LogoGloss_floatVal : packoffset(c7.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AOMin0_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].x)
	#else
	float AOMin0_floatVal : packoffset(c8.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define PeachFuzzPower_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].y)
	#else
	float PeachFuzzPower_floatVal : packoffset(c8.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define PeachFuzzWrap_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].z)
	#else
	float PeachFuzzWrap_floatVal : packoffset(c8.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define FuzzAmount_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].w)
	#else
	float FuzzAmount_floatVal : packoffset(c8.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define PeachfuzzStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].x)
	#else
	float PeachfuzzStart_floatVal : packoffset(c9.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define PeachfuzzEnd_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].y)
	#else
	float PeachfuzzEnd_floatVal : packoffset(c9.y);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UV11UVSet = 0;
static const float2 FadeTiling = float2(1, 1);
static const int UV1UVSet = 1;
static const int UV2UVSet = 2;
static const float2 LogoTiling = float2(1, 1);
static const float DynamicBranch1RefValue_CarAO0 = 1;
static const float DynamicBranch00RefValue_CarAO0 = 1;
static const bool StepBool_CarAO0 = false;
static const bool StepHardStepBool_CarAO0 = false;
static const bool Step0Bool_CarAO0 = false;
static const bool Step0HardStepBool_CarAO0 = false;
static const float DynamicBranchRefValue_CarAO0 = 1;
static const float DynamicBranch0RefValue_CarAO0 = 1;
static const float NormSpecPower = 100;
static const float2 NormTiling = float2(1, 1);
static const float TileNormSpecPower = 100;
static const float2 TileNormTiling = float2(1, 1);
static const int MultiChoiceNormalBlendNormalBlendModes = 0;
static const float TimeTimeScale = 1;
static const float WindNormSpecPower = 100;
static const int MultiChoiceNormalBlend0NormalBlendModes = 0;
static const float2 WindMaskTiling = float2(1, 1);
static const float2 AOTiling = float2(1, 1);
static const float2 TileAOTiling = float2(1, 1);
static const int UV0UVSet = 4;
static const float2 GlobalAOTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStates0Sampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(AOTexture, 16);
#else
#define AOTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(FadeTexture, 17);
#else
#define FadeTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(GlobalAOTexture, 18);
#else
#define GlobalAOTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(LogoTexture, 19);
#else
#define LogoTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormTexture, 20);
#else
#define NormTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(PatternTexture, 21);
#else
#define PatternTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TileAOTexture, 22);
#else
#define TileAOTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(6)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TileNormTexture, 23);
#else
#define TileNormTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(7)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(WindMaskTexture, 24);
#else
#define WindMaskTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(8)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(WindNormTexture, 25);
#else
#define WindNormTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(9)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_DiffuseColor 1
#define MATERIAL_INPUT_IS_USED_DiffuseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_INPUT_IS_USED_F0 1
#define MATERIAL_HAS_INPUT_Glossiness 1
#define MATERIAL_INPUT_IS_USED_Glossiness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_PeachFuzzPower 1
#define MATERIAL_INPUT_IS_USED_PeachFuzzPower 1
#define MATERIAL_HAS_INPUT_PeachFuzzWrap 1
#define MATERIAL_INPUT_IS_USED_PeachFuzzWrap 1
#define MATERIAL_HAS_INPUT_PeachFuzzIntensity 1
#define MATERIAL_INPUT_IS_USED_PeachFuzzIntensity 1
#define MATERIAL_HAS_INPUT_PeachFuzzStart 1
#define MATERIAL_INPUT_IS_USED_PeachFuzzStart 1
#define MATERIAL_HAS_INPUT_PeachFuzzEnd 1
#define MATERIAL_INPUT_IS_USED_PeachFuzzEnd 1
#define MATERIAL_HAS_INPUT_ClothBRDF 1
#define MATERIAL_HAS_INPUT_IndirectSpecScale 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\Clothes.hlsl"
#include "CarConstantBuffer.hlsl"
#include "Blend.hlsl"

struct CarAO0ShaderFunctionOutput
{
	float4 DiffuseColor;
	float4 AmbientOcclusion;
};

CarAO0ShaderFunctionOutput CarAO0ShaderFunction(PS_IN In)
{
	// Type:UsingCarLightScenario, Name:UsingCarLightScenario0_CarAO0
	float4 UsingCarLightScenario0_CarAO0 = IsCarLightScenario();
	
	// Type:CarIsOpenTop, Name:CarIsOpenTop0_CarAO0
	float4 CarIsOpenTop0_CarAO0 = IsOpenTopCar();
	
	// Type:FloatNode, Name:OpenTopExposureCorrection_CarAO0
	float4 OpenTopExposureCorrection_CarAO0 = float4(1.4, 1.4, 1.4, 1.4);
	
	// Type:FloatNode, Name:CloseTopExposureCorrection_CarAO0
	float4 CloseTopExposureCorrection_CarAO0 = float4(1, 1, 1, 1);
	
	// Type:DynamicBranchNode, Name:DynamicBranch1_CarAO0
	float4 DynamicBranch1_CarAO0;
	[branch]
	if(CarIsOpenTop0_CarAO0.x == DynamicBranch1RefValue_CarAO0.x)
	{
		DynamicBranch1_CarAO0 = OpenTopExposureCorrection_CarAO0;
	}
	else
	{
		DynamicBranch1_CarAO0 = CloseTopExposureCorrection_CarAO0;
	}
	
	// Type:FloatNode, Name:TrackAO0_CarAO0
	float4 TrackAO0_CarAO0 = float4(1, 1, 1, 1);
	
	// Type:DynamicBranchNode, Name:DynamicBranch00_CarAO0
	float4 DynamicBranch00_CarAO0;
	[branch]
	if(UsingCarLightScenario0_CarAO0.x == DynamicBranch00RefValue_CarAO0.x)
	{
		DynamicBranch00_CarAO0 = DynamicBranch1_CarAO0;
	}
	else
	{
		DynamicBranch00_CarAO0 = TrackAO0_CarAO0;
	}
	
	// Type:UsingCarLightScenario, Name:UsingCarLightScenario_CarAO0
	float4 UsingCarLightScenario_CarAO0 = IsCarLightScenario();
	
	// Type:CarIsOpenTop, Name:CarIsOpenTop_CarAO0
	float4 CarIsOpenTop_CarAO0 = IsOpenTopCar();
	
	// Type:FloatNode, Name:OpenTopMaxAO_CarAO0
	float4 OpenTopMaxAO_CarAO0 = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:FloatNode, Name:OpenTopMinAO_CarAO0
	float4 OpenTopMinAO_CarAO0 = float4(0.75, 0.75, 0.75, 0.75);
	
	// Type:FloatNode, Name:OpenTopMinHeight_CarAO0
	float4 OpenTopMinHeight_CarAO0 = float4(0.25, 0.25, 0.25, 0.25);
	
	// Type:FloatNode, Name:OpenTopMaxHeight_CarAO0
	float4 OpenTopMaxHeight_CarAO0 = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:ObjectPosNode, Name:ObjectPos_CarAO0
	#ifdef _MAX_
	float4 ObjectPos_CarAO0 = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix).xzyw;
	#else
	float4 ObjectPos_CarAO0 = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix);
	#endif
	
	// Type:SwizzleNode, Name:Swizzle_CarAO0
	float4 Swizzle_CarAO0 = ObjectPos_CarAO0.yyyw;
	
	// Type:StepNode, Name:Step_CarAO0
	float4 Step_CarAO0 = linearstep( OpenTopMinHeight_CarAO0, OpenTopMaxHeight_CarAO0, Swizzle_CarAO0 );
	
	// Type:LerpNode, Name:OpenTop_CarAO0
	float4 OpenTop_CarAO0 = lerp(OpenTopMaxAO_CarAO0, OpenTopMinAO_CarAO0, Step_CarAO0.x);
	
	// Type:FloatNode, Name:CloseTopMaxAO_CarAO0
	float4 CloseTopMaxAO_CarAO0 = float4(0.15, 0.15, 0.15, 0.15);
	
	// Type:FloatNode, Name:CloseTopMinAO_CarAO0
	float4 CloseTopMinAO_CarAO0 = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:FloatNode, Name:CloseTopMinHeight_CarAO0
	float4 CloseTopMinHeight_CarAO0 = float4(0.25, 0.25, 0.25, 0.25);
	
	// Type:FloatNode, Name:CloseTopMaxHeight_CarAO0
	float4 CloseTopMaxHeight_CarAO0 = float4(0.65, 0.65, 0.65, 0.65);
	
	// Type:ObjectPosNode, Name:ObjectPos0_CarAO0
	#ifdef _MAX_
	float4 ObjectPos0_CarAO0 = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix).xzyw;
	#else
	float4 ObjectPos0_CarAO0 = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix);
	#endif
	
	// Type:SwizzleNode, Name:Swizzle0_CarAO0
	float4 Swizzle0_CarAO0 = ObjectPos0_CarAO0.yyyw;
	
	// Type:StepNode, Name:Step0_CarAO0
	float4 Step0_CarAO0 = linearstep( CloseTopMinHeight_CarAO0, CloseTopMaxHeight_CarAO0, Swizzle0_CarAO0 );
	
	// Type:LerpNode, Name:CloseTop_CarAO0
	float4 CloseTop_CarAO0 = lerp(CloseTopMaxAO_CarAO0, CloseTopMinAO_CarAO0, Step0_CarAO0.x);
	
	// Type:DynamicBranchNode, Name:DynamicBranch_CarAO0
	float4 DynamicBranch_CarAO0;
	[branch]
	if(CarIsOpenTop_CarAO0.x == DynamicBranchRefValue_CarAO0.x)
	{
		DynamicBranch_CarAO0 = OpenTop_CarAO0;
	}
	else
	{
		DynamicBranch_CarAO0 = CloseTop_CarAO0;
	}
	
	// Type:FloatNode, Name:TrackAO_CarAO0
	float4 TrackAO_CarAO0 = float4(1, 1, 1, 1);
	
	// Type:DynamicBranchNode, Name:DynamicBranch0_CarAO0
	float4 DynamicBranch0_CarAO0;
	[branch]
	if(UsingCarLightScenario_CarAO0.x == DynamicBranch0RefValue_CarAO0.x)
	{
		DynamicBranch0_CarAO0 = DynamicBranch_CarAO0;
	}
	else
	{
		DynamicBranch0_CarAO0 = TrackAO_CarAO0;
	}
	
	// Type:BlinnPhongPixelShadernode, Name:Root_CarAO0
	
	CarAO0ShaderFunctionOutput dataOut;
	dataOut.DiffuseColor = DynamicBranch00_CarAO0;
	dataOut.AmbientOcclusion = DynamicBranch0_CarAO0;
	return dataOut;
}

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:UVNode, Name:UV11
	float4 UV11 = GetTexCoord0(In).xyxy;
	float4 UV11Tangent = GetWorldTangent0(In);
	float4 UV11UCoord = GetTexCoord0(In).xxxx;
	float4 UV11VCoord = GetTexCoord0(In).yyyy;
	
	// Type:TextureNode, Name:Fade
	float4 Fade = FadeTexture.Sample(g_samplerLinearWrap, UV11.xy * FadeTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 FadeMip = GetDebugMipColour(FadeTexture, g_samplerLinearWrap, UV11.xy * FadeTiling);
	#else
	float4 FadeMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 FadeAlpha = Fade.aaaa;
	float4 FadeRed = Fade.rrrr;
	float4 FadeGreen = Fade.gggg;
	float4 FadeBlue = Fade.bbbb;
	Texture2D FadeRef = FadeTexture;
	
	// Type:UVNode, Name:UV1
	float4 UV1 = GetTexCoord1(In).xyxy;
	float4 UV1Tangent = GetWorldTangent1(In);
	float4 UV1UCoord = GetTexCoord1(In).xxxx;
	float4 UV1VCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:Pattern
	float4 Pattern = PatternTexture.Sample(g_samplerLinearWrap, UV1.xy * PatternTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 PatternMip = GetDebugMipColour(PatternTexture, g_samplerLinearWrap, UV1.xy * PatternTiling);
	#else
	float4 PatternMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 PatternAlpha = Pattern.aaaa;
	float4 PatternRed = Pattern.rrrr;
	float4 PatternGreen = Pattern.gggg;
	float4 PatternBlue = Pattern.bbbb;
	Texture2D PatternRef = PatternTexture;
	
	// Type:ColorNode, Name:MainColour
	float4 MainColour = MainColourColorParam;
	float4 MainColourRed = MainColourColorParam.rrrr;
	float4 MainColourGreen = MainColourColorParam.gggg;
	float4 MainColourBlue = MainColourColorParam.bbbb;
	float4 MainColourAlpha = MainColourColorParam.aaaa;
	
	// Type:MultiplyNode, Name:Multiply00
	float4 Multiply00 = Pattern * MainColour;
	
	// Type:UVNode, Name:UV2
	float4 UV2 = GetTexCoord2(In).xyxy;
	float4 UV2Tangent = GetWorldTangent2(In);
	float4 UV2UCoord = GetTexCoord2(In).xxxx;
	float4 UV2VCoord = GetTexCoord2(In).yyyy;
	
	// Type:FloatNode, Name:Scale
	float4 Scale = Scale_floatVal;
	
	// Type:Vector4Node, Name:Pan
	float4 Pan = PanVector4;
	
	// Type:MultiplyAddNode, Name:UVScalePan
	float4 UVScalePan = UV2 * Scale + Pan;
	
	// Type:SwizzleNode, Name:V
	float4 V = UVScalePan.yyyy;
	
	// Type:FloatNode, Name:Angle
	float4 Angle = Angle_floatVal;
	
	// Type:FloatNode, Name:TwoPi
	float4 TwoPi = float4(6.283185, 6.283185, 6.283185, 6.283185);
	
	// Type:MultiplyNode, Name:AngleRadians
	float4 AngleRadians = Angle * TwoPi;
	
	// Type:SinCos, Name:SinCos
	float4 SinCosSinOut = float4( 1, 1, 1, 1); 
	float4 SinCosCosOut = float4( 1, 1, 1, 1); 
	sincos(AngleRadians, SinCosSinOut, SinCosCosOut); 
	
	// Type:VectorMake, Name:VAxis
	float4 VAxis = float4(SinCosSinOut.x, SinCosCosOut.y, 0, 0);
	
	// Type:MultiplyNode, Name:RotatedV
	float4 RotatedV = V * VAxis;
	
	// Type:SwizzleNode, Name:U
	float4 U = UVScalePan.xxxx;
	
	// Type:NegateNode, Name:Negate
	float4 Negate = -1.0f * SinCosSinOut;
	
	// Type:VectorMake, Name:UAxis
	float4 UAxis = float4(SinCosCosOut.x, Negate.y, 0, 0);
	
	// Type:MultiplyNode, Name:RotatedU
	float4 RotatedU = U * UAxis;
	
	// Type:AddNode, Name:FinalUV
	float4 FinalUV = RotatedV + RotatedU;
	
	// Type:SamplerStatesNode, Name:SamplerStates0
	SamplerState SamplerStates0 = SamplerStates0Sampler;
	float4 SamplerStates0Preview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:Logo
	float4 Logo = LogoTexture.Sample(SamplerStates0Sampler, FinalUV.xy * LogoTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 LogoMip = GetDebugMipColour(LogoTexture, SamplerStates0Sampler, FinalUV.xy * LogoTiling);
	#else
	float4 LogoMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 LogoAlpha = Logo.aaaa;
	float4 LogoRed = Logo.rrrr;
	float4 LogoGreen = Logo.gggg;
	float4 LogoBlue = Logo.bbbb;
	Texture2D LogoRef = LogoTexture;
	
	// Type:ColorNode, Name:LogoTint
	float4 LogoTint = LogoTintColorParam;
	float4 LogoTintRed = LogoTintColorParam.rrrr;
	float4 LogoTintGreen = LogoTintColorParam.gggg;
	float4 LogoTintBlue = LogoTintColorParam.bbbb;
	float4 LogoTintAlpha = LogoTintColorParam.aaaa;
	
	// Type:MultiplyNode, Name:Multiply000
	float4 Multiply000 = Logo * LogoTint;
	
	// Type:LerpNode, Name:LerpLogoDiff
	float4 LerpLogoDiff = lerp(Multiply00, Multiply000, LogoAlpha.x);
	
	// Type:OverlayBlendNode, Name:OverlayBlend
	float4 OverlayBlend = 2.0 * Fade * LerpLogoDiff;
	float4 blendOverlayBlend = 1.0 - 2.0 * (1.0 - LerpLogoDiff) * (1.0 - Fade);
	if (Fade.x > 0.5) OverlayBlend.x = blendOverlayBlend.x;
	if (Fade.y > 0.5) OverlayBlend.y = blendOverlayBlend.y;
	if (Fade.z > 0.5) OverlayBlend.z = blendOverlayBlend.z;
	saturate(OverlayBlend);
	
	// Type:AddNode, Name:Add0
	float4 Add0 = OverlayBlend + OverlayBlend;
	
	// Type:FunctionNode, Name:CarAO0
	float4 CarAO0;
	float4 CarAO0DiffuseColor;
	float4 CarAO0AmbientOcclusion;
	{
		CarAO0ShaderFunctionOutput funcData = CarAO0ShaderFunction(In);
		CarAO0 = funcData.DiffuseColor;
		CarAO0DiffuseColor = funcData.DiffuseColor;
		CarAO0AmbientOcclusion = funcData.AmbientOcclusion;
	}
	
	// Type:MultiplyNode, Name:Mul_InCarDiff
	float4 Mul_InCarDiff = Add0 * CarAO0DiffuseColor;
	
	// Type:NormalMapWithIntensityNode, Name:Norm
	float4 textureLookup_Norm = NormTexture.Sample(g_samplerLinearWrap, UV11.xy * NormTiling);
	#ifdef _MAX_
	textureLookup_Norm.xyz = pow(textureLookup_Norm.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_Norm = (2.0f * textureLookup_Norm.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_Norm, NormSpecPower);
	float4 NormAlpha = textureLookup_Norm.aaaa;
	float4 NormRed = textureLookup_Norm.rrrr;
	float4 NormGreen = textureLookup_Norm.gggg;
	float4 NormBlue = textureLookup_Norm.bbbb;
	tangentSpaceNormal_Norm.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_Norm.z = sqrt(saturate(1 - tangentSpaceNormal_Norm.x*tangentSpaceNormal_Norm.x - tangentSpaceNormal_Norm.y*tangentSpaceNormal_Norm.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_Norm.xy *= g_GlobalNormalScale * NormHeightScale.x;
	#else
	tangentSpaceNormal_Norm.xy *= NormHeightScale.x;
	#endif
	float4 Norm = float4(normalize(mul(tangentSpaceNormal_Norm, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 Norm = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:Vector4Node, Name:DetailTile
	float4 DetailTile = DetailTileVector4;
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = UV1 * DetailTile;
	
	// Type:NormalMapWithIntensityNode, Name:TileNorm
	float4 textureLookup_TileNorm = TileNormTexture.Sample(g_samplerLinearWrap, Multiply1.xy * TileNormTiling);
	#ifdef _MAX_
	textureLookup_TileNorm.xyz = pow(textureLookup_TileNorm.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_TileNorm = (2.0f * textureLookup_TileNorm.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 TileNormGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_TileNorm, TileNormSpecPower);
	float4 TileNormAlpha = textureLookup_TileNorm.aaaa;
	float4 TileNormRed = textureLookup_TileNorm.rrrr;
	float4 TileNormGreen = textureLookup_TileNorm.gggg;
	float4 TileNormBlue = textureLookup_TileNorm.bbbb;
	tangentSpaceNormal_TileNorm.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_TileNorm.z = sqrt(saturate(1 - tangentSpaceNormal_TileNorm.x*tangentSpaceNormal_TileNorm.x - tangentSpaceNormal_TileNorm.y*tangentSpaceNormal_TileNorm.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_TileNorm.xy *= g_GlobalNormalScale * TileNormHeightScale.x;
	#else
	tangentSpaceNormal_TileNorm.xy *= TileNormHeightScale.x;
	#endif
	float4 TileNorm = float4(normalize(mul(tangentSpaceNormal_TileNorm, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 TileNorm = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:MultiChoiceNormalBlendNode, Name:MultiChoiceNormalBlend
	float4 MultiChoiceNormalBlend = NormalBlendFunction(Norm, TileNorm, float4(.5, .5, .5, .5), NORMAL_ADD);
	
	// Type:ObjectPosNode, Name:ObjectPos
	#ifdef _MAX_
	float4 ObjectPos = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix).xzyw;
	#else
	float4 ObjectPos = mul(float4(GetWorldPos(In).xyz, 1), g_InvWorldMatrix);
	#endif
	
	// Type:SwizzleNode, Name:Swizzle
	float4 Swizzle = ObjectPos.xxxx;
	
	// Type:SwizzleNode, Name:Swizzle0
	float4 Swizzle0 = ObjectPos.yyyy;
	
	// Type:IntNode, Name:Int
	float4 Int = float4(2, 2, 2, 2) ;
	
	// Type:IntNode, Name:Int0
	float4 Int0 = float4(1, 1, 1, 1) ;
	
	// Type:DivideNode, Name:Divide
	float4 Divide = Int0 / Int;
	
	// Type:TimeNode, Name:Time
	float4 Time = TimeTimeScale * g_Time;
	
	// Type:MultiplyNode, Name:Multiply8
	float4 Multiply8 = Divide * Time;
	
	// Type:SinCos, Name:SinCos1
	float4 SinCos1SinOut = float4( 1, 1, 1, 1); 
	float4 SinCos1CosOut = float4( 1, 1, 1, 1); 
	sincos(Multiply8, SinCos1SinOut, SinCos1CosOut); 
	
	// Type:MultiplyNode, Name:Multiply7
	float4 Multiply7 = Int * SinCos1SinOut;
	
	// Type:SinCos, Name:SinCos0
	float4 SinCos0SinOut = float4( 1, 1, 1, 1); 
	float4 SinCos0CosOut = float4( 1, 1, 1, 1); 
	sincos(Time, SinCos0SinOut, SinCos0CosOut); 
	
	// Type:AddNode, Name:Add3
	float4 Add3 = Multiply7 + SinCos0SinOut;
	
	// Type:FloatNode, Name:Float0
	float4 Float0 = float4(2, 2, 2, 2);
	
	// Type:MultiplyNode, Name:Multiply5
	float4 Multiply5 = Time * Float0;
	
	// Type:AddNode, Name:Add
	float4 Add = Add3 + Multiply5;
	
	// Type:FloatNode, Name:WindNorm_Speed
	float4 WindNorm_Speed = WindNorm_Speed_floatVal;
	
	// Type:MultiplyNode, Name:Multiply4
	float4 Multiply4 = Add * WindNorm_Speed;
	
	// Type:FloatNode, Name:WindNorm_Offset
	float4 WindNorm_Offset = WindNorm_Offset_floatVal;
	
	// Type:AddNode, Name:Add1
	float4 Add1 = Multiply4 + WindNorm_Offset;
	
	// Type:AddNode, Name:Add2
	float4 Add2 = Swizzle0 + Add1;
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(Swizzle.x, Add2.y, 0, 0);
	
	// Type:NormalMapWithIntensityNode, Name:WindNorm
	float4 textureLookup_WindNorm = WindNormTexture.Sample(g_samplerLinearWrap, VectorMake.xy * WindNormTiling);
	#ifdef _MAX_
	textureLookup_WindNorm.xyz = pow(textureLookup_WindNorm.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_WindNorm = (2.0f * textureLookup_WindNorm.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 WindNormGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_WindNorm, WindNormSpecPower);
	float4 WindNormAlpha = textureLookup_WindNorm.aaaa;
	float4 WindNormRed = textureLookup_WindNorm.rrrr;
	float4 WindNormGreen = textureLookup_WindNorm.gggg;
	float4 WindNormBlue = textureLookup_WindNorm.bbbb;
	tangentSpaceNormal_WindNorm.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_WindNorm.z = sqrt(saturate(1 - tangentSpaceNormal_WindNorm.x*tangentSpaceNormal_WindNorm.x - tangentSpaceNormal_WindNorm.y*tangentSpaceNormal_WindNorm.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_WindNorm.xy *= g_GlobalNormalScale * WindNormHeightScale.x;
	#else
	tangentSpaceNormal_WindNorm.xy *= WindNormHeightScale.x;
	#endif
	float4 WindNorm = float4(normalize(mul(tangentSpaceNormal_WindNorm, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 WindNorm = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:FloatNode, Name:WindNorm_Amnt
	float4 WindNorm_Amnt = WindNorm_Amnt_floatVal;
	
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:MultiplyNode, Name:Multiply10
	float4 Multiply10 = WindNorm_Amnt * VertexColorAlpha;
	
	// Type:MultiChoiceNormalBlendNode, Name:MultiChoiceNormalBlend0
	float4 MultiChoiceNormalBlend0 = NormalBlendFunction(MultiChoiceNormalBlend, WindNorm, Multiply10, NORMAL_ADD);
	
	// Type:FloatNode, Name:F0
	float4 F0 = F0_floatVal;
	
	// Type:FloatNode, Name:LogoF0
	float4 LogoF0 = LogoF0_floatVal;
	
	// Type:LerpNode, Name:ToF0
	float4 ToF0 = lerp(F0, LogoF0, LogoAlpha.x);
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = ToF0 * CarAO0DiffuseColor;
	
	// Type:FloatNode, Name:Gloss
	float4 Gloss = Gloss_floatVal;
	
	// Type:FloatNode, Name:LogoGloss
	float4 LogoGloss = LogoGloss_floatVal;
	
	// Type:LerpNode, Name:ToGloss
	float4 ToGloss = lerp(Gloss, LogoGloss, LogoAlpha.x);
	
	// Type:TextureNode, Name:WindMask
	float4 WindMask = WindMaskTexture.Sample(g_samplerLinearWrap, VectorMake.xy * WindMaskTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 WindMaskMip = GetDebugMipColour(WindMaskTexture, g_samplerLinearWrap, VectorMake.xy * WindMaskTiling);
	#else
	float4 WindMaskMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 WindMaskAlpha = WindMask.aaaa;
	float4 WindMaskRed = WindMask.rrrr;
	float4 WindMaskGreen = WindMask.gggg;
	float4 WindMaskBlue = WindMask.bbbb;
	Texture2D WindMaskRef = WindMaskTexture;
	
	// Type:FloatNode, Name:Float
	float4 Float = float4(1, 1, 1, 1);
	
	// Type:MultiplyNode, Name:Multiply6
	float4 Multiply6 = WindMaskRed * Float;
	
	// Type:VertexColor, Name:VertexColor0
	float4 VertexColor0 = GetColor(In);float4 VertexColor0Alpha = VertexColor0.aaaa;
	float4 VertexColor0Red = VertexColor0.rrrr;
	float4 VertexColor0Green = VertexColor0.gggg;
	float4 VertexColor0Blue = VertexColor0.bbbb;
	
	// Type:MultiplyNode, Name:Multiply11
	float4 Multiply11 = Multiply6 * VertexColor0;
	
	// Type:MultiplyNode, Name:Multiply9
	float4 Multiply9 = Multiply11 * VertexColor0Alpha;
	
	// Type:TextureNode, Name:AO
	float4 AO = AOTexture.Sample(g_samplerLinearWrap, UV11.xy * AOTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AOMip = GetDebugMipColour(AOTexture, g_samplerLinearWrap, UV11.xy * AOTiling);
	#else
	float4 AOMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AOAlpha = AO.aaaa;
	float4 AORed = AO.rrrr;
	float4 AOGreen = AO.gggg;
	float4 AOBlue = AO.bbbb;
	Texture2D AORef = AOTexture;
	
	// Type:TextureNode, Name:TileAO
	float4 TileAO = TileAOTexture.Sample(g_samplerLinearWrap, Multiply1.xy * TileAOTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TileAOMip = GetDebugMipColour(TileAOTexture, g_samplerLinearWrap, Multiply1.xy * TileAOTiling);
	#else
	float4 TileAOMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TileAOAlpha = TileAO.aaaa;
	float4 TileAORed = TileAO.rrrr;
	float4 TileAOGreen = TileAO.gggg;
	float4 TileAOBlue = TileAO.bbbb;
	Texture2D TileAORef = TileAOTexture;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = AO * TileAO;
	
	// Type:UVNode, Name:UV0
	float4 UV0 = GetTexCoord4(In).xyxy;
	float4 UV0Tangent = GetWorldTangent4(In);
	float4 UV0UCoord = GetTexCoord4(In).xxxx;
	float4 UV0VCoord = GetTexCoord4(In).yyyy;
	
	// Type:TextureNode, Name:GlobalAO
	float4 GlobalAO = GlobalAOTexture.Sample(g_samplerLinearWrap, UV0.xy * GlobalAOTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 GlobalAOMip = GetDebugMipColour(GlobalAOTexture, g_samplerLinearWrap, UV0.xy * GlobalAOTiling);
	#else
	float4 GlobalAOMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 GlobalAOAlpha = GlobalAO.aaaa;
	float4 GlobalAORed = GlobalAO.rrrr;
	float4 GlobalAOGreen = GlobalAO.gggg;
	float4 GlobalAOBlue = GlobalAO.bbbb;
	Texture2D GlobalAORef = GlobalAOTexture;
	
	// Type:MultiplyNode, Name:Multiply2
	float4 Multiply2 = Multiply0 * GlobalAO;
	
	// Type:MultiplyNode, Name:Mul_InCarAO
	float4 Mul_InCarAO = Multiply2 * CarAO0AmbientOcclusion;
	
	// Type:FloatNode, Name:AOMin0
	float4 AOMin0 = AOMin0_floatVal;
	
	// Type:FloatNode, Name:AOMax0
	float4 AOMax0 = float4(1, 1, 1, 1);
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(AOMin0, AOMax0, Multiply2.x);
	
	// Type:FloatNode, Name:PeachFuzzPower
	float4 PeachFuzzPower = PeachFuzzPower_floatVal;
	
	// Type:FloatNode, Name:PeachFuzzWrap
	float4 PeachFuzzWrap = PeachFuzzWrap_floatVal;
	
	// Type:AddNode, Name:Add00
	float4 Add00 = Add0 + OverlayBlend;
	
	// Type:FloatNode, Name:FuzzAmount
	float4 FuzzAmount = FuzzAmount_floatVal;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = Add00 * FuzzAmount;
	
	// Type:FloatNode, Name:PeachfuzzStart
	float4 PeachfuzzStart = PeachfuzzStart_floatVal;
	
	// Type:FloatNode, Name:PeachfuzzEnd
	float4 PeachfuzzEnd = PeachfuzzEnd_floatVal;
	
	output.DiffuseColor = Mul_InCarDiff;
	output.Normal = MultiChoiceNormalBlend0;
	output.F0 = Multiply3;
	output.Glossiness = ToGloss;
	output.Emissive = Multiply9;
	output.AmbientOcclusion = Mul_InCarAO;
	output.DirectOcclusion = Lerp0;
	output.PeachFuzzPower = PeachFuzzPower;
	output.PeachFuzzWrap = PeachFuzzWrap;
	output.PeachFuzzIntensity = Multiply;
	output.PeachFuzzStart = PeachfuzzStart;
	output.PeachFuzzEnd = PeachfuzzEnd;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\ClothWind.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\TrackFullNightLightScenario.hlsl"