#include "LightScenarios\Inc\TrackDebugLightingLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 AOTiling < string UIName = "AOTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 BaseColorTiling < string UIName = "BaseColorTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 LightmapTiling < string UIName = "LightmapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float NormalMapSpecPower < string UIName = "NormalMapSpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalMapTiling < string UIName = "NormalMapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 RoughnessMetalnessTiling < string UIName = "RoughnessMetalnessTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
int UV1UVSet < string UIName = "UV1UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int UV2UVSet < string UIName = "UV2UVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UV1UVSet = 0;
static const float2 BaseColorTiling = float2(1, 1);
static const float NormalMapSpecPower = 100;
static const float2 NormalMapTiling = float2(1, 1);
static const float2 RoughnessMetalnessTiling = float2(1, 1);
static const int UV2UVSet = 1;
static const float2 LightmapTiling = float2(1, 1);
static const float2 AOTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStatesSampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(AOTexture, 16);
#else
#define AOTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(BaseColorTexture, 17);
#else
#define BaseColorTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(LightmapTexture, 18);
#else
#define LightmapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalMapTexture, 19);
#else
#define NormalMapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(RoughnessMetalnessTexture, 20);
#else
#define RoughnessMetalnessTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_INPUT_IS_USED_Metalness 1
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Transmissiveness 1
#define MATERIAL_HAS_INPUT_TransmissiveFuzziness 1
#define MATERIAL_HAS_INPUT_TransmissiveControl 1
#define MATERIAL_HAS_INPUT_Lightmap 1
#define MATERIAL_INPUT_IS_USED_Lightmap 1
#define MATERIAL_HAS_INPUT_LightmapAdditive 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_INPUT_IS_USED_AlphaBlend 1
#define MATERIAL_HAS_INPUT_LightSwitchOnStart 1
#define MATERIAL_HAS_INPUT_LightSwitchOnEnd 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_HAS_INPUT_MinimumWind 1
#define MATERIAL_HAS_INPUT_AnimationPivot 1
#define MATERIAL_HAS_INPUT_AnimationSpeed 1
#define MATERIAL_HAS_INPUT_TranslateSpeed 1
#define MATERIAL_HAS_INPUT_RotateSpeed 1
#define MATERIAL_HAS_INPUT_Translate 1
#define MATERIAL_HAS_INPUT_Rotate 1
#define MATERIAL_HAS_INPUT_LocalisedCubes 1
#define MATERIAL_HAS_INPUT_SnowSpecTexture 1
#define MATERIAL_HAS_INPUT_SnowAmount 1
#define MATERIAL_HAS_INPUT_FrostAmount 1
#define MATERIAL_HAS_INPUT_TwinkleAmount 1
// Alpha
#define IS_ALPHA_BLENDED 1
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\BlinnPhongAlpha.hlsl"

#define MODIFY_PIXEL_COLOUR_DEFINED 1
void ModifyPixelColour(PS_IN In, inout float3 pixelColour, inout float pixelAlpha)
{
	g_PixelColour = float4(pixelColour, pixelAlpha);
	float4 PixelColourOutput = g_PixelColour;
	pixelColour = PixelColourOutput.rgb;
	pixelAlpha = PixelColourOutput.a;
}
////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:UVNode, Name:UV1
	float4 UV1 = GetTexCoord0(In).xyxy;
	float4 UV1Tangent = GetWorldTangent0(In);
	float4 UV1UCoord = GetTexCoord0(In).xxxx;
	float4 UV1VCoord = GetTexCoord0(In).yyyy;
	
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStatesSampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:TextureNode, Name:BaseColor
	float4 BaseColor = BaseColorTexture.Sample(SamplerStatesSampler, UV1.xy * BaseColorTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 BaseColorMip = GetDebugMipColour(BaseColorTexture, SamplerStatesSampler, UV1.xy * BaseColorTiling);
	#else
	float4 BaseColorMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 BaseColorAlpha = BaseColor.aaaa;
	float4 BaseColorRed = BaseColor.rrrr;
	float4 BaseColorGreen = BaseColor.gggg;
	float4 BaseColorBlue = BaseColor.bbbb;
	Texture2D BaseColorRef = BaseColorTexture;
	
	// Type:NormalMapNode, Name:NormalMap
	float4 textureLookup_NormalMap = NormalMapTexture.Sample(SamplerStatesSampler, UV1.xy * NormalMapTiling);
	#ifdef _MAX_
	textureLookup_NormalMap.xyz = pow(textureLookup_NormalMap.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalMap = (2.0f * textureLookup_NormalMap.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalMapGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalMap, NormalMapSpecPower);
	float4 NormalMapAlpha = textureLookup_NormalMap.aaaa;
	float4 NormalMapRed = textureLookup_NormalMap.rrrr;
	float4 NormalMapGreen = textureLookup_NormalMap.gggg;
	float4 NormalMapBlue = textureLookup_NormalMap.bbbb;
	tangentSpaceNormal_NormalMap.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalMap.z = sqrt(saturate(1 - tangentSpaceNormal_NormalMap.x*tangentSpaceNormal_NormalMap.x - tangentSpaceNormal_NormalMap.y*tangentSpaceNormal_NormalMap.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalMap.xy *= g_GlobalNormalScale;
	#endif
	float4 NormalMap = float4(normalize(mul(tangentSpaceNormal_NormalMap, float3x3(UV1Tangent.xyz, (normalize(cross(GetWorldNormal(In).xyz, UV1Tangent.xyz) * UV1Tangent.w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalMap = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:TextureNode, Name:RoughnessMetalness
	float4 RoughnessMetalness = RoughnessMetalnessTexture.Sample(SamplerStatesSampler, UV1.xy * RoughnessMetalnessTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 RoughnessMetalnessMip = GetDebugMipColour(RoughnessMetalnessTexture, SamplerStatesSampler, UV1.xy * RoughnessMetalnessTiling);
	#else
	float4 RoughnessMetalnessMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 RoughnessMetalnessAlpha = RoughnessMetalness.aaaa;
	float4 RoughnessMetalnessRed = RoughnessMetalness.rrrr;
	float4 RoughnessMetalnessGreen = RoughnessMetalness.gggg;
	float4 RoughnessMetalnessBlue = RoughnessMetalness.bbbb;
	Texture2D RoughnessMetalnessRef = RoughnessMetalnessTexture;
	
	// Type:UVNode, Name:UV2
	float4 UV2 = GetTexCoord1(In).xyxy;
	float4 UV2Tangent = GetWorldTangent1(In);
	float4 UV2UCoord = GetTexCoord1(In).xxxx;
	float4 UV2VCoord = GetTexCoord1(In).yyyy;
	
	// Type:TextureNode, Name:Lightmap
	float4 Lightmap = LightmapTexture.Sample(SamplerStatesSampler, UV2.xy * LightmapTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 LightmapMip = GetDebugMipColour(LightmapTexture, SamplerStatesSampler, UV2.xy * LightmapTiling);
	#else
	float4 LightmapMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 LightmapAlpha = Lightmap.aaaa;
	float4 LightmapRed = Lightmap.rrrr;
	float4 LightmapGreen = Lightmap.gggg;
	float4 LightmapBlue = Lightmap.bbbb;
	Texture2D LightmapRef = LightmapTexture;
	
	// Type:TextureNode, Name:AO
	float4 AO = AOTexture.Sample(SamplerStatesSampler, UV2.xy * AOTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 AOMip = GetDebugMipColour(AOTexture, SamplerStatesSampler, UV2.xy * AOTiling);
	#else
	float4 AOMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 AOAlpha = AO.aaaa;
	float4 AORed = AO.rrrr;
	float4 AOGreen = AO.gggg;
	float4 AOBlue = AO.bbbb;
	Texture2D AORef = AOTexture;
	
	output.BaseColor = BaseColor;
	output.Normal = NormalMap;
	output.Roughness = RoughnessMetalnessRed;
	output.Metalness = RoughnessMetalnessGreen;
	output.Lightmap = Lightmap;
	output.AmbientOcclusion = AORed;
	output.DirectOcclusion = AORed;
	output.AlphaBlend = BaseColorAlpha;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\TrackDebugLightingLightScenario.hlsl"