#include "LightScenarios\Inc\TrackDayOptimisedLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float4 ColorColorParam < string UIName = "ColorColorParam"; string UIWidget = "Color"; > = float4( 0.2383976, 0.2383976, 0.2383976, 1 );
float F_ColVarDiv_floatVal < string UIName = "F_ColVarDiv_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 10 ;
float F_DiffuseAmp_floatVal < string UIName = "F_DiffuseAmp_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1.5 ;
float F_EmissiveAmp_floatVal < string UIName = "F_EmissiveAmp_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 5 ;
float F_Fresnel_Offset_floatVal < string UIName = "F_Fresnel_Offset_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = -0.25 ;
float F_Fresnel_Scale_floatVal < string UIName = "F_Fresnel_Scale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 TextureClouds0Tiling < string UIName = "TextureClouds0Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 TextureClouds1Tiling < string UIName = "TextureClouds1Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.5, 0.5, 0, 0 );
float4 TextureCloudsTiling < string UIName = "TextureCloudsTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 TextureGradTiling < string UIName = "TextureGradTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 UVPanner_BeamXYTimeScale < string UIName = "UVPanner_BeamXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( -0.4347821, 0, 0, 0 );
float4 UVPanner_CloudXYTimeScale < string UIName = "UVPanner_CloudXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.22, 3.33, 0, 0 );
float4 UVPanner_ColXYTimeScale < string UIName = "UVPanner_ColXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1.2, 0, 0, 0 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define ColorColorParam ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 ColorColorParam : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UVPanner_ColXYTimeScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].xy))
	#else
	float2 UVPanner_ColXYTimeScale : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UVPanner_CloudXYTimeScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].zw))
	#else
	float2 UVPanner_CloudXYTimeScale : packoffset(c1.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_EmissiveAmp_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].x)
	#else
	float F_EmissiveAmp_floatVal : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_DiffuseAmp_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].y)
	#else
	float F_DiffuseAmp_floatVal : packoffset(c2.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_ColVarDiv_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].z)
	#else
	float F_ColVarDiv_floatVal : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_Fresnel_Scale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].w)
	#else
	float F_Fresnel_Scale_floatVal : packoffset(c2.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define F_Fresnel_Offset_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].x)
	#else
	float F_Fresnel_Offset_floatVal : packoffset(c3.x);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const float2 TextureCloudsTiling = float2(1, 1);
static const float2 UVPanner_BeamXYTimeScale = float2(-0.4347821, 0);
static const float2 TextureClouds0Tiling = float2(1, 1);
static const float2 TextureClouds1Tiling = float2(0.5, 0.5);
static const float2 TextureGradTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TextureClouds0Texture, 16);
#else
#define TextureClouds0Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TextureClouds1Texture, 17);
#else
#define TextureClouds1Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TextureCloudsTexture, 18);
#else
#define TextureCloudsTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(TextureGradTexture, 19);
#else
#define TextureGradTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_INPUT_IS_USED_Emissive 1
#define MATERIAL_HAS_INPUT_Additive 1
#define MATERIAL_INPUT_IS_USED_Additive 1
#define MATERIAL_HAS_INPUT_ApplyFog 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_INPUT_IS_USED_AlphaBlend 1
// Alpha
#define IS_ALPHA_BLENDED 1
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\EmissiveOnly.hlsl"
#include "Panner.hlsl"

#define MODIFY_PIXEL_COLOUR_DEFINED 1
void ModifyPixelColour(PS_IN In, inout float3 pixelColour, inout float pixelAlpha)
{
	g_PixelColour = float4(pixelColour, pixelAlpha);
	float4 PixelColourOutput = g_PixelColour;
	pixelColour = PixelColourOutput.rgb;
	pixelAlpha = PixelColourOutput.a;
}
////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:FloatNode, Name:F_EmissiveAmp
	float4 F_EmissiveAmp = F_EmissiveAmp_floatVal;
	
	// Type:FloatNode, Name:F_DiffuseAmp
	float4 F_DiffuseAmp = F_DiffuseAmp_floatVal;
	
	// Type:ColorNode, Name:Color
	float4 Color = ColorColorParam;
	float4 ColorRed = ColorColorParam.rrrr;
	float4 ColorGreen = ColorColorParam.gggg;
	float4 ColorBlue = ColorColorParam.bbbb;
	float4 ColorAlpha = ColorColorParam.aaaa;
	
	// Type:UVPannerNode, Name:UVPanner_Col
	float4 UVPanner_Col = PanTextureCoordinates(GetTexCoord0(In), g_Time * UVPanner_ColXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:TextureClouds
	float4 TextureClouds = TextureCloudsTexture.Sample(g_samplerLinearWrap, UVPanner_Col.xy * TextureCloudsTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TextureCloudsMip = GetDebugMipColour(TextureCloudsTexture, g_samplerLinearWrap, UVPanner_Col.xy * TextureCloudsTiling);
	#else
	float4 TextureCloudsMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TextureCloudsAlpha = TextureClouds.aaaa;
	float4 TextureCloudsRed = TextureClouds.rrrr;
	float4 TextureCloudsGreen = TextureClouds.gggg;
	float4 TextureCloudsBlue = TextureClouds.bbbb;
	Texture2D TextureCloudsRef = TextureCloudsTexture;
	
	// Type:FloatNode, Name:F_ColVarDiv
	float4 F_ColVarDiv = F_ColVarDiv_floatVal;
	
	// Type:DivideNode, Name:Divide
	float4 Divide = TextureCloudsGreen / F_ColVarDiv;
	
	// Type:AddNode, Name:Add0
	float4 Add0 = Color + Divide;
	
	// Type:UVPannerNode, Name:UVPanner_Beam
	float4 UVPanner_Beam = PanTextureCoordinates(GetTexCoord0(In), g_Time * UVPanner_BeamXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:TextureClouds0
	float4 TextureClouds0 = TextureClouds0Texture.Sample(g_samplerLinearWrap, UVPanner_Beam.xy * TextureClouds0Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TextureClouds0Mip = GetDebugMipColour(TextureClouds0Texture, g_samplerLinearWrap, UVPanner_Beam.xy * TextureClouds0Tiling);
	#else
	float4 TextureClouds0Mip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TextureClouds0Alpha = TextureClouds0.aaaa;
	float4 TextureClouds0Red = TextureClouds0.rrrr;
	float4 TextureClouds0Green = TextureClouds0.gggg;
	float4 TextureClouds0Blue = TextureClouds0.bbbb;
	Texture2D TextureClouds0Ref = TextureClouds0Texture;
	
	// Type:UVPannerNode, Name:UVPanner_Cloud
	float4 UVPanner_Cloud = PanTextureCoordinates(GetTexCoord0(In), g_Time * UVPanner_CloudXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:TextureClouds1
	float4 TextureClouds1 = TextureClouds1Texture.Sample(g_samplerLinearWrap, UVPanner_Cloud.xy * TextureClouds1Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TextureClouds1Mip = GetDebugMipColour(TextureClouds1Texture, g_samplerLinearWrap, UVPanner_Cloud.xy * TextureClouds1Tiling);
	#else
	float4 TextureClouds1Mip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TextureClouds1Alpha = TextureClouds1.aaaa;
	float4 TextureClouds1Red = TextureClouds1.rrrr;
	float4 TextureClouds1Green = TextureClouds1.gggg;
	float4 TextureClouds1Blue = TextureClouds1.bbbb;
	Texture2D TextureClouds1Ref = TextureClouds1Texture;
	
	// Type:AddNode, Name:Add
	float4 Add = TextureClouds0Blue + TextureClouds1Green;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = Add0 * Add;
	
	// Type:MultiplyNode, Name:Mult_Diff
	float4 Mult_Diff = F_DiffuseAmp * Multiply0;
	
	// Type:FloatNode, Name:FadeFresnelEdge
	float4 FadeFresnelEdge = float4(0, 0, 0, 0);
	
	// Type:TextureNode, Name:TextureGrad
	float4 TextureGrad = TextureGradTexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * TextureGradTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 TextureGradMip = GetDebugMipColour(TextureGradTexture, g_samplerLinearWrap, GetTexCoord0(In) * TextureGradTiling);
	#else
	float4 TextureGradMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 TextureGradAlpha = TextureGrad.aaaa;
	float4 TextureGradRed = TextureGrad.rrrr;
	float4 TextureGradGreen = TextureGrad.gggg;
	float4 TextureGradBlue = TextureGrad.bbbb;
	Texture2D TextureGradRef = TextureGradTexture;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = TextureClouds1Green * TextureGradRed;
	
	// Type:ViewVectorNode, Name:ViewVector
	float4 ViewVector = float4(GetViewVector(), 0);
	// Type:WorldNormalNode, Name:WorldNormal
	float4 WorldNormal = float4(GetWorldNormal(In).xyz, 0);
	// Type:DotNode, Name:Dot
	float4 Dot = dot(ViewVector, WorldNormal);
	
	// Type:FloatNode, Name:F_Fresnel_Scale
	float4 F_Fresnel_Scale = F_Fresnel_Scale_floatVal;
	
	// Type:FloatNode, Name:F_Fresnel_Offset
	float4 F_Fresnel_Offset = F_Fresnel_Offset_floatVal;
	
	// Type:MultiplyAddNode, Name:FresnelMultiplyAdd
	float4 FresnelMultiplyAdd = Dot * F_Fresnel_Scale + F_Fresnel_Offset;
	
	// Type:SaturateNode, Name:Saturate
	float4 Saturate = saturate( FresnelMultiplyAdd ); 
	
	// Type:LerpNode, Name:AddFresnel
	float4 AddFresnel = lerp(FadeFresnelEdge, Multiply, Saturate.x);
	
	// Type:MultiplyNode, Name:Multiply00
	float4 Multiply00 = Mult_Diff * AddFresnel;
	
	// Type:MultiplyNode, Name:Mult_Emiss
	float4 Mult_Emiss = F_EmissiveAmp * Multiply00;
	
	output.Emissive = Mult_Emiss;
	output.Additive = Mult_Emiss;
	output.AlphaBlend = Mult_Emiss;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\DefaultVertexAnim.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\TrackDayOptimisedLightScenario.hlsl"