#include "LightScenarios\Inc\TrackDayOptimisedLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float AnimEndFadeDistance_floatVal < string UIName = "AnimEndFadeDistance_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 200 ;
float AnimStartFadeDistance_floatVal < string UIName = "AnimStartFadeDistance_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float AOToCavityMapStrength < string UIName = "AOToCavityMapStrength"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float BakedLightExposure_floatVal < string UIName = "BakedLightExposure_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float BakedLightIntensity_floatVal < string UIName = "BakedLightIntensity_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float DistanceFaderEndFade < string UIName = "DistanceFaderEndFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 20 ;
float DistanceFaderStartFade < string UIName = "DistanceFaderStartFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 5 ;
float DistantColourBlendEndDistance_floatVal < string UIName = "DistantColourBlendEndDistance_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float DistantColourBlendStartDistance_floatVal < string UIName = "DistantColourBlendStartDistance_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float GIAOScale_floatVal < string UIName = "GIAOScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float GIRadScale_floatVal < string UIName = "GIRadScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float IndirectSpecularScale0_floatVal < string UIName = "IndirectSpecularScale0_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float LeafLateralAmplitude_floatVal < string UIName = "LeafLateralAmplitude_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LeafLateralFrequency_floatVal < string UIName = "LeafLateralFrequency_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LeafNormalDistortion_floatVal < string UIName = "LeafNormalDistortion_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.7934783 ;
float LeafVerticalAmplitude_floatVal < string UIName = "LeafVerticalAmplitude_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float LeafVerticalFrequency_floatVal < string UIName = "LeafVerticalFrequency_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float MediumDOPower_floatVal < string UIName = "MediumDOPower_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 SkyTransmControl0Vector4 < string UIName = "SkyTransmControl0Vector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.1, 3, 1, 0 );
float4 SkyTransmFuzzinessVector4 < string UIName = "SkyTransmFuzzinessVector4"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.1304348, 0.6304348, -0.6956522, 0.2608696 );
float SpecTransmCurve_floatVal < string UIName = "SpecTransmCurve_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float SpecTransmIntensity_floatVal < string UIName = "SpecTransmIntensity_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float SpecularNormalElevation_floatVal < string UIName = "SpecularNormalElevation_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float SpecularScale_floatVal < string UIName = "SpecularScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
bool Step1Bool < string UIName = "Step1Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step1HardStepBool < string UIName = "Step1HardStepBool"; string UIWidget = "Checkbox"; > = 0;
float TransmDistanceFaderEndFade < string UIName = "TransmDistanceFaderEndFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 20 ;
float TransmDistanceFaderStartFade < string UIName = "TransmDistanceFaderStartFade"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 5 ;
float TrunkHeightScale_floatVal < string UIName = "TrunkHeightScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float TrunkHeightStart_floatVal < string UIName = "TrunkHeightStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int TrunkWindResponse_intVal < string UIName = "TrunkWindResponse_intVal"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
float UberFoliageTexturesParamAlphaStepMax < string UIName = "UberFoliageTexturesParamAlphaStepMax"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.6 ;
float UberFoliageTexturesParamAlphaStepMin < string UIName = "UberFoliageTexturesParamAlphaStepMin"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.05 ;
float4 UberFoliageTexturesParamAOFader < string UIName = "UberFoliageTexturesParamAOFader"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 40, 80, 0.8, 0 );
float UberFoliageTexturesParamRoughnessScale < string UIName = "UberFoliageTexturesParamRoughnessScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 UberFoliageTexturesParamTransmissiveColor < string UIName = "UberFoliageTexturesParamTransmissiveColor"; string UIWidget = "Color"; > = float4( 1, 1, 1, 1 );
float4 UberFoliageTexturesParamTransmissiveFuzziness < string UIName = "UberFoliageTexturesParamTransmissiveFuzziness"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( -0.6565217, 0.6347826, -0.1, 0 );
float UberFoliageTexturesParamTransmissiveScale < string UIName = "UberFoliageTexturesParamTransmissiveScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 4 ;
int VariantConstant_Animated < string UIName = "VariantConstant_Animated"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Baked_Lighting < string UIName = "VariantConstant_Baked_Lighting"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Billboard < string UIName = "VariantConstant_Billboard"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Billboard_Blend < string UIName = "VariantConstant_Billboard_Blend"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Bush < string UIName = "VariantConstant_Bush"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_BushSkeletalDeform < string UIName = "VariantConstant_BushSkeletalDeform"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_BushVertDeform < string UIName = "VariantConstant_BushVertDeform"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_DistantColourBlend < string UIName = "VariantConstant_DistantColourBlend"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Enable_Specular < string UIName = "VariantConstant_Enable_Specular"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Enable_Transmissivness < string UIName = "VariantConstant_Enable_Transmissivness"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_EnableMegaRoughness < string UIName = "VariantConstant_EnableMegaRoughness"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_FullShadow < string UIName = "VariantConstant_FullShadow"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Grass < string UIName = "VariantConstant_Grass"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Morph < string UIName = "VariantConstant_Morph"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_No_Clip < string UIName = "VariantConstant_No_Clip"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_NoCameraFacing < string UIName = "VariantConstant_NoCameraFacing"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_NoFlatten < string UIName = "VariantConstant_NoFlatten"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_PerPixelTint < string UIName = "VariantConstant_PerPixelTint"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Separate_DO < string UIName = "VariantConstant_Separate_DO"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Tree < string UIName = "VariantConstant_Tree"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_UsePSSM < string UIName = "VariantConstant_UsePSSM"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_UseSSAO < string UIName = "VariantConstant_UseSSAO"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_UseTerrainNormal < string UIName = "VariantConstant_UseTerrainNormal"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_UseUPNormal < string UIName = "VariantConstant_UseUPNormal"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_UseWorldTint < string UIName = "VariantConstant_UseWorldTint"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_VC_Overlay < string UIName = "VariantConstant_VC_Overlay"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Vertex_AO < string UIName = "VariantConstant_Vertex_AO"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Vertex_Lighting < string UIName = "VariantConstant_Vertex_Lighting"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_WettenDiffuse < string UIName = "VariantConstant_WettenDiffuse"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Winter < string UIName = "VariantConstant_Winter"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float VertexRoughness_floatVal < string UIName = "VertexRoughness_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.5 ;
float4 WorldTintMapTexturesDisplacement < string UIName = "WorldTintMapTexturesDisplacement"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0, 20, -10, 69.89131 );
float4 WorldTintMapTexturesWorldOffsetAndScale < string UIName = "WorldTintMapTexturesWorldOffsetAndScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 6750, 7530, 14366, 14366 );
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define WorldTintMapTexturesDisplacement ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0]))
	#else
	float4 WorldTintMapTexturesDisplacement : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberFoliageTexturesParamTransmissiveColor ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1]))
	#else
	float4 UberFoliageTexturesParamTransmissiveColor : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberFoliageTexturesParamTransmissiveFuzziness ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2]))
	#else
	float4 UberFoliageTexturesParamTransmissiveFuzziness : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberFoliageTexturesParamAOFader ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3]))
	#else
	float4 UberFoliageTexturesParamAOFader : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define SkyTransmFuzzinessVector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4]))
	#else
	float4 SkyTransmFuzzinessVector4 : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define SkyTransmControl0Vector4 ((float4)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5]))
	#else
	float4 SkyTransmControl0Vector4 : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TransmDistanceFaderStartFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)
	#else
	float TransmDistanceFaderStartFade : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TransmDistanceFaderEndFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].y)
	#else
	float TransmDistanceFaderEndFade : packoffset(c6.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberFoliageTexturesParamAlphaStepMin (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].z)
	#else
	float UberFoliageTexturesParamAlphaStepMin : packoffset(c6.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberFoliageTexturesParamAlphaStepMax (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].w)
	#else
	float UberFoliageTexturesParamAlphaStepMax : packoffset(c6.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberFoliageTexturesParamRoughnessScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].x)
	#else
	float UberFoliageTexturesParamRoughnessScale : packoffset(c7.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UberFoliageTexturesParamTransmissiveScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].y)
	#else
	float UberFoliageTexturesParamTransmissiveScale : packoffset(c7.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define BakedLightIntensity_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].z)
	#else
	float BakedLightIntensity_floatVal : packoffset(c7.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define BakedLightExposure_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 7].w)
	#else
	float BakedLightExposure_floatVal : packoffset(c7.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MediumDOPower_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].x)
	#else
	float MediumDOPower_floatVal : packoffset(c8.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AOToCavityMapStrength (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].y)
	#else
	float AOToCavityMapStrength : packoffset(c8.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VertexRoughness_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].z)
	#else
	float VertexRoughness_floatVal : packoffset(c8.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define SpecTransmIntensity_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 8].w)
	#else
	float SpecTransmIntensity_floatVal : packoffset(c8.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define SpecTransmCurve_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].x)
	#else
	float SpecTransmCurve_floatVal : packoffset(c9.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define SpecularScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].y)
	#else
	float SpecularScale_floatVal : packoffset(c9.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DistanceFaderStartFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].z)
	#else
	float DistanceFaderStartFade : packoffset(c9.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DistanceFaderEndFade (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 9].w)
	#else
	float DistanceFaderEndFade : packoffset(c9.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define SpecularNormalElevation_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].x)
	#else
	float SpecularNormalElevation_floatVal : packoffset(c10.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define IndirectSpecularScale0_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].y)
	#else
	float IndirectSpecularScale0_floatVal : packoffset(c10.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GIAOScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].z)
	#else
	float GIAOScale_floatVal : packoffset(c10.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GIRadScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 10].w)
	#else
	float GIRadScale_floatVal : packoffset(c10.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TrunkHeightScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].x)
	#else
	float TrunkHeightScale_floatVal : packoffset(c11.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TrunkHeightStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].y)
	#else
	float TrunkHeightStart_floatVal : packoffset(c11.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LeafVerticalAmplitude_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].z)
	#else
	float LeafVerticalAmplitude_floatVal : packoffset(c11.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LeafLateralAmplitude_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 11].w)
	#else
	float LeafLateralAmplitude_floatVal : packoffset(c11.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LeafVerticalFrequency_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 12].x)
	#else
	float LeafVerticalFrequency_floatVal : packoffset(c12.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LeafLateralFrequency_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 12].y)
	#else
	float LeafLateralFrequency_floatVal : packoffset(c12.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define LeafNormalDistortion_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 12].z)
	#else
	float LeafNormalDistortion_floatVal : packoffset(c12.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AnimStartFadeDistance_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 12].w)
	#else
	float AnimStartFadeDistance_floatVal : packoffset(c12.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AnimEndFadeDistance_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 13].x)
	#else
	float AnimEndFadeDistance_floatVal : packoffset(c13.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DistantColourBlendStartDistance_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 13].y)
	#else
	float DistantColourBlendStartDistance_floatVal : packoffset(c13.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define DistantColourBlendEndDistance_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 13].z)
	#else
	float DistantColourBlendEndDistance_floatVal : packoffset(c13.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TrunkWindResponse_intVal ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 14].x)))
	#else
	int TrunkWindResponse_intVal : packoffset(c14.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Tree ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 14].y)))
	#else
	int VariantConstant_Tree : packoffset(c14.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Grass ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 14].z)))
	#else
	int VariantConstant_Grass : packoffset(c14.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Bush ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 14].w)))
	#else
	int VariantConstant_Bush : packoffset(c14.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Billboard ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 15].x)))
	#else
	int VariantConstant_Billboard : packoffset(c15.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_NoCameraFacing ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 15].y)))
	#else
	int VariantConstant_NoCameraFacing : packoffset(c15.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Vertex_Lighting ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 15].z)))
	#else
	int VariantConstant_Vertex_Lighting : packoffset(c15.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Enable_Specular ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 15].w)))
	#else
	int VariantConstant_Enable_Specular : packoffset(c15.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Enable_Transmissivness ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 16].x)))
	#else
	int VariantConstant_Enable_Transmissivness : packoffset(c16.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Winter ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 16].y)))
	#else
	int VariantConstant_Winter : packoffset(c16.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Vertex_AO ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 16].z)))
	#else
	int VariantConstant_Vertex_AO : packoffset(c16.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UseUPNormal ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 16].w)))
	#else
	int VariantConstant_UseUPNormal : packoffset(c16.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UseTerrainNormal ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 17].x)))
	#else
	int VariantConstant_UseTerrainNormal : packoffset(c17.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Morph ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 17].y)))
	#else
	int VariantConstant_Morph : packoffset(c17.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Animated ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 17].z)))
	#else
	int VariantConstant_Animated : packoffset(c17.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_No_Clip ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 17].w)))
	#else
	int VariantConstant_No_Clip : packoffset(c17.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_VC_Overlay ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 18].x)))
	#else
	int VariantConstant_VC_Overlay : packoffset(c18.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UsePSSM ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 18].y)))
	#else
	int VariantConstant_UsePSSM : packoffset(c18.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UseWorldTint ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 18].z)))
	#else
	int VariantConstant_UseWorldTint : packoffset(c18.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_PerPixelTint ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 18].w)))
	#else
	int VariantConstant_PerPixelTint : packoffset(c18.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Baked_Lighting ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 19].x)))
	#else
	int VariantConstant_Baked_Lighting : packoffset(c19.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_UseSSAO ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 19].y)))
	#else
	int VariantConstant_UseSSAO : packoffset(c19.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_NoFlatten ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 19].z)))
	#else
	int VariantConstant_NoFlatten : packoffset(c19.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_BushVertDeform ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 19].w)))
	#else
	int VariantConstant_BushVertDeform : packoffset(c19.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_BushSkeletalDeform ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 20].x)))
	#else
	int VariantConstant_BushSkeletalDeform : packoffset(c20.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_DistantColourBlend ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 20].y)))
	#else
	int VariantConstant_DistantColourBlend : packoffset(c20.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Billboard_Blend ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 20].z)))
	#else
	int VariantConstant_Billboard_Blend : packoffset(c20.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Separate_DO ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 20].w)))
	#else
	int VariantConstant_Separate_DO : packoffset(c20.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_EnableMegaRoughness ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 21].x)))
	#else
	int VariantConstant_EnableMegaRoughness : packoffset(c21.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_WettenDiffuse ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 21].y)))
	#else
	int VariantConstant_WettenDiffuse : packoffset(c21.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_FullShadow ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 21].z)))
	#else
	int VariantConstant_FullShadow : packoffset(c21.z);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const float4 WorldTintMapTexturesWorldOffsetAndScale = float4(6750, 7530, 14366, 14366);
static const bool Step1Bool = false;
static const bool Step1HardStepBool = false;

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
DECLARE_SAMPLERSTATE(SamplerStatesSampler, 12);
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberFoliageTexturesParamBakedLightTexture, 16);
#else
#define UberFoliageTexturesParamBakedLightTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberFoliageTexturesParamDiffuseTexture, 17);
#else
#define UberFoliageTexturesParamDiffuseTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberFoliageTexturesParamMaskTexture, 18);
#else
#define UberFoliageTexturesParamMaskTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberFoliageTexturesParamNormalTexture, 19);
#else
#define UberFoliageTexturesParamNormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(UberFoliageTexturesParamRTAOTexture, 20);
#else
#define UberFoliageTexturesParamRTAOTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(WorldTintMapTexturesWorldTintMap, 21);
#else
#define WorldTintMapTexturesWorldTintMap InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_TintColor 1
#define MATERIAL_INPUT_IS_USED_TintColor 1
#define MATERIAL_HAS_INPUT_BakedLight 1
#define MATERIAL_INPUT_IS_USED_BakedLight 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_VertexRoughness 1
#define MATERIAL_INPUT_IS_USED_VertexRoughness 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_HAS_INPUT_Transmissiveness 1
#define MATERIAL_INPUT_IS_USED_Transmissiveness 1
#define MATERIAL_HAS_INPUT_TransmissiveFuzziness 1
#define MATERIAL_INPUT_IS_USED_TransmissiveFuzziness 1
#define MATERIAL_HAS_INPUT_SkyTransmissiveness 1
#define MATERIAL_INPUT_IS_USED_SkyTransmissiveness 1
#define MATERIAL_HAS_INPUT_SkyTransmFuzziness 1
#define MATERIAL_INPUT_IS_USED_SkyTransmFuzziness 1
#define MATERIAL_HAS_INPUT_SkyTransmControl 1
#define MATERIAL_INPUT_IS_USED_SkyTransmControl 1
#define MATERIAL_HAS_INPUT_SpecTransmControl 1
#define MATERIAL_INPUT_IS_USED_SpecTransmControl 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_INPUT_IS_USED_SpecularScale 1
#define MATERIAL_HAS_INPUT_SpecularNormalElevation 1
#define MATERIAL_INPUT_IS_USED_SpecularNormalElevation 1
#define MATERIAL_HAS_INPUT_IndirectSpecularScale 1
#define MATERIAL_INPUT_IS_USED_IndirectSpecularScale 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_INPUT_IS_USED_GIScale 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_INPUT_IS_USED_AlphaTest 1
#define MATERIAL_HAS_INPUT_TrunkHeightScale 1
#define MATERIAL_INPUT_IS_USED_TrunkHeightScale 1
#define MATERIAL_HAS_INPUT_TrunkHeightStart 1
#define MATERIAL_INPUT_IS_USED_TrunkHeightStart 1
#define MATERIAL_HAS_INPUT_TrunkWindResponse 1
#define MATERIAL_INPUT_IS_USED_TrunkWindResponse 1
#define MATERIAL_HAS_INPUT_LeafVerticalAmplitude 1
#define MATERIAL_INPUT_IS_USED_LeafVerticalAmplitude 1
#define MATERIAL_HAS_INPUT_LeafLateralAmplitude 1
#define MATERIAL_INPUT_IS_USED_LeafLateralAmplitude 1
#define MATERIAL_HAS_INPUT_LeafVerticalFrequency 1
#define MATERIAL_INPUT_IS_USED_LeafVerticalFrequency 1
#define MATERIAL_HAS_INPUT_LeafLateralFrequency 1
#define MATERIAL_INPUT_IS_USED_LeafLateralFrequency 1
#define MATERIAL_HAS_INPUT_LeafNormalDistortion 1
#define MATERIAL_INPUT_IS_USED_LeafNormalDistortion 1
#define MATERIAL_HAS_INPUT_AnimStartFadeDistance 1
#define MATERIAL_INPUT_IS_USED_AnimStartFadeDistance 1
#define MATERIAL_HAS_INPUT_AnimEndFadeDistance 1
#define MATERIAL_INPUT_IS_USED_AnimEndFadeDistance 1
#define MATERIAL_HAS_INPUT_DistantColourFadeDistances 1
#define MATERIAL_INPUT_IS_USED_DistantColourFadeDistances 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 1
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\UberFoliage.hlsl"
#include "UberFoliage.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:SamplerStatesNode, Name:SamplerStates
	SamplerState SamplerStates = SamplerStatesSampler;
	float4 SamplerStatesPreview = float4(0,0,0,0);
	
	// Type:WorldTintMapTextures, Name:WorldTintMapTextures
	float4 WorldTintMapTextures = GetWorldTint(In, WorldTintMapTexturesWorldTintMap, WorldTintMapTexturesWorldOffsetAndScale, WorldTintMapTexturesDisplacement, GetWorldNormal(In));
	 
	// Type:VariantOnOffNode, Name:UseWorldTintOnOff
	#if defined(VARIANTPROPERTY_USEWORLDTINT) && VARIANTPROPERTY_USEWORLDTINT == 1
	float4 UseWorldTintOnOff = WorldTintMapTextures;
	#elif defined(VARIANTPROPERTY_USEWORLDTINT) && VARIANTPROPERTY_USEWORLDTINT == 0
	float4 UseWorldTintOnOff = float4(1, 1, 1, 1);
	#elif !defined(VARIANTPROPERTY_USEWORLDTINT) || VARIANTPROPERTY_USEWORLDTINT == 2
	float4 UseWorldTintOnOff;
	[branch]
	if(VariantConstant_UseWorldTint != 0)
	{
		UseWorldTintOnOff = WorldTintMapTextures;
	}
	else
	{
		UseWorldTintOnOff = float4(1, 1, 1, 1);
	}
	#endif
	
	// Type:VariantOnOffNode, Name:PerPixelTintOnOff
	#if defined(VARIANTPROPERTY_PERPIXELTINT) && VARIANTPROPERTY_PERPIXELTINT == 1
	float4 PerPixelTintOnOff = UseWorldTintOnOff;
	#elif defined(VARIANTPROPERTY_PERPIXELTINT) && VARIANTPROPERTY_PERPIXELTINT == 0
	float4 PerPixelTintOnOff = float4(1, 1, 1, 1);
	#elif !defined(VARIANTPROPERTY_PERPIXELTINT) || VARIANTPROPERTY_PERPIXELTINT == 2
	float4 PerPixelTintOnOff;
	[branch]
	if(VariantConstant_PerPixelTint != 0)
	{
		PerPixelTintOnOff = UseWorldTintOnOff;
	}
	else
	{
		PerPixelTintOnOff = float4(1, 1, 1, 1);
	}
	#endif
	
	// Type:DistanceFaderNode, Name:TransmDistanceFader
	float4 TransmDistanceFader = 1 - saturate( ( distance(GetWorldPos(In), g_EyePos.xyz) - TransmDistanceFaderStartFade) / (TransmDistanceFaderEndFade - TransmDistanceFaderStartFade) );
	
	// Type:UberFoliageTextures, Name:UberFoliageTextures
	float4 UberFoliageTexturesworldTint = PerPixelTintOnOff;
	float4 UberFoliageTexturesDiffuse = 0;
	float4 UberFoliageTexturesNormal = 0;
	float4 UberFoliageTexturesRTAO = 0;
	float4 UberFoliageTexturesMediumAO = 1;
	float4 UberFoliageTexturesHighAO = 1;
	float4 UberFoliageTexturesTransmissiveness = 0;
	float4 UberFoliageTexturesTransmissiveFuzzinessOut = 0;
	float4 UberFoliageTexturesBakedLight = 1;float4 UberFoliageTexturesTransmissivenessColor = 1;
	GetUberFoliageTextures(In, SamplerStatesSampler, UberFoliageTexturesParamDiffuseTexture, SamplerStatesSampler, UberFoliageTexturesParamNormalTexture, UberFoliageTexturesParamRTAOTexture, UberFoliageTexturesParamBakedLightTexture, UberFoliageTexturesParamMaskTexture, UberFoliageTexturesworldTint, UberFoliageTexturesParamAlphaStepMin, UberFoliageTexturesParamAlphaStepMax, UberFoliageTexturesParamRoughnessScale, UberFoliageTexturesParamTransmissiveColor, UberFoliageTexturesParamTransmissiveScale, UberFoliageTexturesParamTransmissiveFuzziness, UberFoliageTexturesParamAOFader, UberFoliageTexturesDiffuse, UberFoliageTexturesNormal, UberFoliageTexturesRTAO, UberFoliageTexturesMediumAO, UberFoliageTexturesHighAO, UberFoliageTexturesTransmissiveness, UberFoliageTexturesTransmissiveFuzzinessOut, UberFoliageTexturesBakedLight, UberFoliageTexturesTransmissivenessColor);
	#if defined(VARIANTPROPERTY_VERTEX_LIGHTING) && VARIANTPROPERTY_VERTEX_LIGHTING == 1
	    if (g_VertexShader)
	        UberFoliageTexturesTransmissiveness *= TransmDistanceFader;
	#else
	    UberFoliageTexturesTransmissiveness *= TransmDistanceFader;
	#endif
	float4 UberFoliageTexturesRoughness = UberFoliageTexturesRTAO.xxxx;
	float4 UberFoliageTexturesAlpha = UberFoliageTexturesDiffuse.wwww;
	
	// Type:VariantOnOffNode, Name:PerVertexTintOnOff
	#if defined(VARIANTPROPERTY_PERPIXELTINT) && VARIANTPROPERTY_PERPIXELTINT == 1
	float4 PerVertexTintOnOff = float4(1, 1, 1, 1);
	#elif defined(VARIANTPROPERTY_PERPIXELTINT) && VARIANTPROPERTY_PERPIXELTINT == 0
	float4 PerVertexTintOnOff = UseWorldTintOnOff;
	#elif !defined(VARIANTPROPERTY_PERPIXELTINT) || VARIANTPROPERTY_PERPIXELTINT == 2
	float4 PerVertexTintOnOff;
	[branch]
	if(VariantConstant_PerPixelTint != 0)
	{
		PerVertexTintOnOff = float4(1, 1, 1, 1);
	}
	else
	{
		PerVertexTintOnOff = UseWorldTintOnOff;
	}
	#endif
	
	// Type:FloatNode, Name:BakedLightIntensity
	float4 BakedLightIntensity = BakedLightIntensity_floatVal;
	
	// Type:FloatNode, Name:BakedLightExposure
	float4 BakedLightExposure = BakedLightExposure_floatVal;
	
	// Type:PowNode, Name:Pow3
	float4 Pow3 = pow( UberFoliageTexturesBakedLight, BakedLightExposure );
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = BakedLightIntensity * Pow3;
	
	// Type:FloatNode, Name:MediumDOPower
	float4 MediumDOPower = MediumDOPower_floatVal;
	
	// Type:PowNode, Name:Pow
	float4 Pow = pow( UberFoliageTexturesMediumAO, MediumDOPower );
	
	// Type:AOModifier, Name:AOModifier
	g_IgnoreGlobalScales = true;
	float4 AOModifierAOHigh = ApplyIntensistyAndPower(UberFoliageTexturesHighAO, g_AODOHighModifiers.x, g_AODOHighModifiers.y) ;
	float4 AOModifierAO = CombineAOs(ApplyIntensistyAndPower(UberFoliageTexturesMediumAO, g_AODOMediumModifiers.x, g_AODOMediumModifiers.y), AOModifierAOHigh);
	float4 AOModifierDO = ApplyIntensistyAndPower(Pow, g_AODOMediumModifiers.z, g_AODOMediumModifiers.w) * ApplyIntensistyAndPower(UberFoliageTexturesHighAO, g_AODOHighModifiers.z, g_AODOHighModifiers.w);
	
	// Type:AOToCavityMap, Name:AOToCavityMap
	float4 AOToCavityMap = (saturate((1 / (1 + pow(2.71828, -(AOModifierAOHigh - 0.46) * 5)) - 0.09) * 1.21));
	AOToCavityMap = AOToCavityMap * AOToCavityMapStrength + (1 - AOToCavityMapStrength);
	
	// Type:VariantOnOffNode, Name:Baked_Lighting
	#if defined(VARIANTPROPERTY_BAKED_LIGHTING) && VARIANTPROPERTY_BAKED_LIGHTING == 1
	float4 Baked_Lighting = float4(1, 1, 1, 1);
	#elif defined(VARIANTPROPERTY_BAKED_LIGHTING) && VARIANTPROPERTY_BAKED_LIGHTING == 0
	float4 Baked_Lighting = AOToCavityMap;
	#elif !defined(VARIANTPROPERTY_BAKED_LIGHTING) || VARIANTPROPERTY_BAKED_LIGHTING == 2
	float4 Baked_Lighting;
	[branch]
	if(VariantConstant_Baked_Lighting != 0)
	{
		Baked_Lighting = float4(1, 1, 1, 1);
	}
	else
	{
		Baked_Lighting = AOToCavityMap;
	}
	#endif
	
	// Type:VariantOnOffNode, Name:GrassOnOff
	#if defined(VARIANTPROPERTY_GRASS) && VARIANTPROPERTY_GRASS == 1
	float4 GrassOnOff = float4(1, 1, 1, 1);
	#elif defined(VARIANTPROPERTY_GRASS) && VARIANTPROPERTY_GRASS == 0
	float4 GrassOnOff = Baked_Lighting;
	#elif !defined(VARIANTPROPERTY_GRASS) || VARIANTPROPERTY_GRASS == 2
	float4 GrassOnOff;
	[branch]
	if(VariantConstant_Grass != 0)
	{
		GrassOnOff = float4(1, 1, 1, 1);
	}
	else
	{
		GrassOnOff = Baked_Lighting;
	}
	#endif
	
	// Type:MultiplyNode, Name:Multiply300
	float4 Multiply300 = UberFoliageTexturesRoughness * GrassOnOff;
	
	// Type:VariantOnOffNode, Name:Vertex_LightingOnOff
	#if defined(VARIANTPROPERTY_VERTEX_LIGHTING) && VARIANTPROPERTY_VERTEX_LIGHTING == 1
	float4 Vertex_LightingOnOff = Multiply300;
	#elif defined(VARIANTPROPERTY_VERTEX_LIGHTING) && VARIANTPROPERTY_VERTEX_LIGHTING == 0
	float4 Vertex_LightingOnOff = UberFoliageTexturesRoughness;
	#elif !defined(VARIANTPROPERTY_VERTEX_LIGHTING) || VARIANTPROPERTY_VERTEX_LIGHTING == 2
	float4 Vertex_LightingOnOff;
	[branch]
	if(VariantConstant_Vertex_Lighting != 0)
	{
		Vertex_LightingOnOff = Multiply300;
	}
	else
	{
		Vertex_LightingOnOff = UberFoliageTexturesRoughness;
	}
	#endif
	
	// Type:FloatNode, Name:VertexRoughness
	float4 VertexRoughness = VertexRoughness_floatVal;
	
	// Type:Vector4Node, Name:SkyTransmFuzziness
	float4 SkyTransmFuzziness = SkyTransmFuzzinessVector4;
	
	// Type:Vector4Node, Name:SkyTransmControl0
	float4 SkyTransmControl0 = SkyTransmControl0Vector4;
	
	// Type:FloatNode, Name:SpecTransmIntensity
	float4 SpecTransmIntensity = SpecTransmIntensity_floatVal;
	
	// Type:FloatNode, Name:SpecTransmCurve
	float4 SpecTransmCurve = SpecTransmCurve_floatVal;
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(SpecTransmIntensity.x, SpecTransmCurve.y, 0, 0);
	
	// Type:VariantOnOffNode, Name:GrassOnOff0
	#if defined(VARIANTPROPERTY_GRASS) && VARIANTPROPERTY_GRASS == 1
	float4 GrassOnOff0 = Pow;
	#elif defined(VARIANTPROPERTY_GRASS) && VARIANTPROPERTY_GRASS == 0
	float4 GrassOnOff0 = AOModifierDO;
	#elif !defined(VARIANTPROPERTY_GRASS) || VARIANTPROPERTY_GRASS == 2
	float4 GrassOnOff0;
	[branch]
	if(VariantConstant_Grass != 0)
	{
		GrassOnOff0 = Pow;
	}
	else
	{
		GrassOnOff0 = AOModifierDO;
	}
	#endif
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(0.96, 0.96, 0.96, 0.96);
	
	// Type:FloatNode, Name:Float11
	float4 Float11 = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:Step1
	float4 Step1 = linearstep( Float1, Float11, UberFoliageTexturesRoughness );
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = Step1 * GrassOnOff;
	
	// Type:VariantOnOffNode, Name:Vertex_LightingOnOff0
	#if defined(VARIANTPROPERTY_VERTEX_LIGHTING) && VARIANTPROPERTY_VERTEX_LIGHTING == 1
	float4 Vertex_LightingOnOff0 = float4(1, 1, 1, 1);
	#elif defined(VARIANTPROPERTY_VERTEX_LIGHTING) && VARIANTPROPERTY_VERTEX_LIGHTING == 0
	float4 Vertex_LightingOnOff0 = Multiply1;
	#elif !defined(VARIANTPROPERTY_VERTEX_LIGHTING) || VARIANTPROPERTY_VERTEX_LIGHTING == 2
	float4 Vertex_LightingOnOff0;
	[branch]
	if(VariantConstant_Vertex_Lighting != 0)
	{
		Vertex_LightingOnOff0 = float4(1, 1, 1, 1);
	}
	else
	{
		Vertex_LightingOnOff0 = Multiply1;
	}
	#endif
	
	// Type:FloatNode, Name:SpecularScale
	float4 SpecularScale = SpecularScale_floatVal;
	
	// Type:DistanceFaderNode, Name:DistanceFader
	float4 DistanceFader = 1 - saturate( ( distance(GetWorldPos(In), g_EyePos.xyz) - DistanceFaderStartFade) / (DistanceFaderEndFade - DistanceFaderStartFade) );
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = SpecularScale * DistanceFader;
	
	// Type:MultiplyNode, Name:Multiply30
	float4 Multiply30 = Vertex_LightingOnOff0 * Multiply3;
	
	// Type:FloatNode, Name:SpecularNormalElevation
	float4 SpecularNormalElevation = SpecularNormalElevation_floatVal;
	
	// Type:FloatNode, Name:IndirectSpecularScale0
	float4 IndirectSpecularScale0 = IndirectSpecularScale0_floatVal;
	
	// Type:FloatNode, Name:GIAOScale
	float4 GIAOScale = GIAOScale_floatVal;
	
	// Type:FloatNode, Name:GIRadScale
	float4 GIRadScale = GIRadScale_floatVal;
	
	// Type:VectorMake, Name:VectorMake1
	float4 VectorMake1 = float4(GIAOScale.x, GIAOScale.y, GIRadScale.z, 0);
	
	// Type:FloatNode, Name:TrunkHeightScale
	float4 TrunkHeightScale = TrunkHeightScale_floatVal;
	
	// Type:FloatNode, Name:TrunkHeightStart
	float4 TrunkHeightStart = TrunkHeightStart_floatVal;
	
	// Type:IntNode, Name:TrunkWindResponse
	float4 TrunkWindResponse = TrunkWindResponse_intVal;
	
	// Type:FloatNode, Name:LeafVerticalAmplitude
	float4 LeafVerticalAmplitude = LeafVerticalAmplitude_floatVal;
	
	// Type:FloatNode, Name:LeafLateralAmplitude
	float4 LeafLateralAmplitude = LeafLateralAmplitude_floatVal;
	
	// Type:FloatNode, Name:LeafVerticalFrequency
	float4 LeafVerticalFrequency = LeafVerticalFrequency_floatVal;
	
	// Type:FloatNode, Name:LeafLateralFrequency
	float4 LeafLateralFrequency = LeafLateralFrequency_floatVal;
	
	// Type:FloatNode, Name:LeafNormalDistortion
	float4 LeafNormalDistortion = LeafNormalDistortion_floatVal;
	
	// Type:FloatNode, Name:AnimStartFadeDistance
	float4 AnimStartFadeDistance = AnimStartFadeDistance_floatVal;
	
	// Type:FloatNode, Name:AnimEndFadeDistance
	float4 AnimEndFadeDistance = AnimEndFadeDistance_floatVal;
	
	// Type:FloatNode, Name:DistantColourBlendStartDistance
	float4 DistantColourBlendStartDistance = DistantColourBlendStartDistance_floatVal;
	
	// Type:FloatNode, Name:DistantColourBlendEndDistance
	float4 DistantColourBlendEndDistance = DistantColourBlendEndDistance_floatVal;
	
	// Type:VectorMake, Name:VectorMake0
	float4 VectorMake0 = float4(DistantColourBlendStartDistance.x, DistantColourBlendEndDistance.y, 0, 0);
	
	output.BaseColor = UberFoliageTexturesDiffuse;
	output.TintColor = PerVertexTintOnOff;
	output.BakedLight = Multiply;
	output.Normal = UberFoliageTexturesNormal;
	output.Roughness = Vertex_LightingOnOff;
	output.VertexRoughness = VertexRoughness;
	output.Transmissiveness = UberFoliageTexturesTransmissiveness;
	output.TransmissiveFuzziness = UberFoliageTexturesTransmissiveFuzzinessOut;
	output.SkyTransmissiveness = UberFoliageTexturesTransmissivenessColor;
	output.SkyTransmFuzziness = SkyTransmFuzziness;
	output.SkyTransmControl = SkyTransmControl0;
	output.SpecTransmControl = VectorMake;
	output.AmbientOcclusion = AOModifierAO;
	output.DirectOcclusion = GrassOnOff0;
	output.SpecularScale = Multiply30;
	output.SpecularNormalElevation = SpecularNormalElevation;
	output.IndirectSpecularScale = IndirectSpecularScale0;
	output.GIScale = VectorMake1;
	#if IN_MATERIAL_EDITOR
	if (!forVertex) clip(UberFoliageTexturesAlpha.x - ALPHATEST_MIN);
	#else
	#if ENABLE_ALPHA_TEST && IS_ALPHA_TESTED
	if (!forVertex && g_EnableAlphaTest) clip(UberFoliageTexturesAlpha.x - ALPHATEST_MIN);
	#endif
	#endif
	output.AlphaTest = UberFoliageTexturesAlpha;
	output.TrunkHeightScale = TrunkHeightScale;
	output.TrunkHeightStart = TrunkHeightStart;
	output.TrunkWindResponse = TrunkWindResponse;
	output.LeafVerticalAmplitude = LeafVerticalAmplitude;
	output.LeafLateralAmplitude = LeafLateralAmplitude;
	output.LeafVerticalFrequency = LeafVerticalFrequency;
	output.LeafLateralFrequency = LeafLateralFrequency;
	output.LeafNormalDistortion = LeafNormalDistortion;
	output.AnimStartFadeDistance = AnimStartFadeDistance;
	output.AnimEndFadeDistance = AnimEndFadeDistance;
	output.DistantColourFadeDistances = VectorMake0;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\UberFoliageVertex.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\TrackDayOptimisedLightScenario.hlsl"