#include "LightScenarios\Inc\TrackDayOptimisedLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float AnimEndFadeDistance_floatVal < string UIName = "AnimEndFadeDistance_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 200 ;
float AnimStartFadeDistance_floatVal < string UIName = "AnimStartFadeDistance_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float AOToCavityMapStrength < string UIName = "AOToCavityMapStrength"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 DiffuseATiling < string UIName = "DiffuseATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float Float_floatVal < string UIName = "Float_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float GIAOScale_floatVal < string UIName = "GIAOScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float GIRadScale_floatVal < string UIName = "GIRadScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float4 MicroNormalTiling < string UIName = "MicroNormalTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 5, 5, 0, 0 );
int MultiChoiceNormalBlendNormalBlendModes < string UIName = "MultiChoiceNormalBlendNormalBlendModes"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
float NormalAHeightScale < string UIName = "NormalAHeightScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
float NormalASpecPower < string UIName = "NormalASpecPower"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 100 ;
float4 NormalATiling < string UIName = "NormalATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
bool Step1Bool < string UIName = "Step1Bool"; string UIWidget = "Checkbox"; > = 0;
bool Step1HardStepBool < string UIName = "Step1HardStepBool"; string UIWidget = "Checkbox"; > = 0;
int TangentToWorldSpaceUVSet < string UIName = "TangentToWorldSpaceUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int TrackParameterTrackParam < string UIName = "TrackParameterTrackParam"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 3 ;
float TrunkHeightScale_floatVal < string UIName = "TrunkHeightScale_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float TrunkHeightStart_floatVal < string UIName = "TrunkHeightStart_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int TrunkWindResponse_intVal < string UIName = "TrunkWindResponse_intVal"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 2 ;
int VariantConstant_Animated < string UIName = "VariantConstant_Animated"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Disable_Rustling < string UIName = "VariantConstant_Disable_Rustling"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_MicroNormal < string UIName = "VariantConstant_MicroNormal"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_NormalAlpha_AO < string UIName = "VariantConstant_NormalAlpha_AO"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Tree < string UIName = "VariantConstant_Tree"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int VariantConstant_Vertex_Lighting < string UIName = "VariantConstant_Vertex_Lighting"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
int WorldToTangentSpaceUVSet < string UIName = "WorldToTangentSpaceUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define DiffuseATiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].xy))
	#else
	float2 DiffuseATiling : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MicroNormalTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].zw))
	#else
	float2 MicroNormalTiling : packoffset(c0.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define NormalATiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].xy))
	#else
	float2 NormalATiling : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define NormalAHeightScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].x)
	#else
	float NormalAHeightScale : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AOToCavityMapStrength (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].y)
	#else
	float AOToCavityMapStrength : packoffset(c2.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GIAOScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].z)
	#else
	float GIAOScale_floatVal : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define GIRadScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].w)
	#else
	float GIRadScale_floatVal : packoffset(c2.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define Float_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].x)
	#else
	float Float_floatVal : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TrunkHeightScale_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].y)
	#else
	float TrunkHeightScale_floatVal : packoffset(c3.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TrunkHeightStart_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].z)
	#else
	float TrunkHeightStart_floatVal : packoffset(c3.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AnimStartFadeDistance_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].w)
	#else
	float AnimStartFadeDistance_floatVal : packoffset(c3.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AnimEndFadeDistance_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float AnimEndFadeDistance_floatVal : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define TrunkWindResponse_intVal ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)))
	#else
	int TrunkWindResponse_intVal : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Tree ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)))
	#else
	int VariantConstant_Tree : packoffset(c5.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Vertex_Lighting ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].z)))
	#else
	int VariantConstant_Vertex_Lighting : packoffset(c5.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Animated ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].w)))
	#else
	int VariantConstant_Animated : packoffset(c5.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Disable_Rustling ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].x)))
	#else
	int VariantConstant_Disable_Rustling : packoffset(c6.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_NormalAlpha_AO ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].y)))
	#else
	int VariantConstant_NormalAlpha_AO : packoffset(c6.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_MicroNormal ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 6].z)))
	#else
	int VariantConstant_MicroNormal : packoffset(c6.z);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int TrackParameterTrackParam = 3;
static const float NormalASpecPower = 100;
static const int WorldToTangentSpaceUVSet = 0;
static const int MultiChoiceNormalBlendNormalBlendModes = 2;
static const int TangentToWorldSpaceUVSet = 0;
static const bool Step1Bool = false;
static const bool Step1HardStepBool = false;

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(DiffuseATexture, 16);
#else
#define DiffuseATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MicroNormalTexture, 17);
#else
#define MicroNormalTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NormalATexture, 18);
#else
#define NormalATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
#define NEW_PBR 1
// Inputs
#define MATERIAL_HAS_INPUT_BaseColor 1
#define MATERIAL_INPUT_IS_USED_BaseColor 1
#define MATERIAL_HAS_INPUT_TintColor 1
#define MATERIAL_HAS_INPUT_BakedLight 1
#define MATERIAL_HAS_INPUT_Normal 1
#define MATERIAL_INPUT_IS_USED_Normal 1
#define MATERIAL_HAS_INPUT_Roughness 1
#define MATERIAL_INPUT_IS_USED_Roughness 1
#define MATERIAL_HAS_INPUT_VertexRoughness 1
#define MATERIAL_HAS_INPUT_F0 1
#define MATERIAL_HAS_INPUT_Metalness 1
#define MATERIAL_HAS_INPUT_Transmissiveness 1
#define MATERIAL_HAS_INPUT_TransmissiveFuzziness 1
#define MATERIAL_HAS_INPUT_SkyTransmissiveness 1
#define MATERIAL_HAS_INPUT_SkyTransmFuzziness 1
#define MATERIAL_HAS_INPUT_SkyTransmControl 1
#define MATERIAL_HAS_INPUT_SpecTransmControl 1
#define MATERIAL_HAS_INPUT_AmbientOcclusion 1
#define MATERIAL_INPUT_IS_USED_AmbientOcclusion 1
#define MATERIAL_HAS_INPUT_DirectOcclusion 1
#define MATERIAL_INPUT_IS_USED_DirectOcclusion 1
#define MATERIAL_HAS_INPUT_SpecularScale 1
#define MATERIAL_INPUT_IS_USED_SpecularScale 1
#define MATERIAL_HAS_INPUT_SpecularNormalElevation 1
#define MATERIAL_HAS_INPUT_IndirectSpecularScale 1
#define MATERIAL_HAS_INPUT_GIScale 1
#define MATERIAL_INPUT_IS_USED_GIScale 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_INPUT_IS_USED_AlphaTest 1
#define MATERIAL_HAS_INPUT_TrunkHeightScale 1
#define MATERIAL_INPUT_IS_USED_TrunkHeightScale 1
#define MATERIAL_HAS_INPUT_TrunkHeightStart 1
#define MATERIAL_INPUT_IS_USED_TrunkHeightStart 1
#define MATERIAL_HAS_INPUT_TrunkWindResponse 1
#define MATERIAL_INPUT_IS_USED_TrunkWindResponse 1
#define MATERIAL_HAS_INPUT_LeafVerticalAmplitude 1
#define MATERIAL_HAS_INPUT_LeafLateralAmplitude 1
#define MATERIAL_HAS_INPUT_LeafVerticalFrequency 1
#define MATERIAL_HAS_INPUT_LeafLateralFrequency 1
#define MATERIAL_HAS_INPUT_LeafNormalDistortion 1
#define MATERIAL_HAS_INPUT_AnimStartFadeDistance 1
#define MATERIAL_INPUT_IS_USED_AnimStartFadeDistance 1
#define MATERIAL_HAS_INPUT_AnimEndFadeDistance 1
#define MATERIAL_INPUT_IS_USED_AnimEndFadeDistance 1
#define MATERIAL_HAS_INPUT_DistantColourFadeDistances 1
// Alpha
#define IS_ALPHA_BLENDED 0
#define IS_ALPHA_TESTED 1
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\UberFoliage.hlsl"
#include "TrackConstantBuffer.hlsl"
#include "NormalMapping.hlsl"
#include "Blend.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:TrackParameterNode, Name:TrackParameter
	// DX12 binding strategies currently don't support track params in these light scenarios
	
	#if defined(IS_WHEEL_BLUR_SCENARIO) || defined(CAR_LIGHTING_SCENARIO)
	float4 TrackParameter = float4(1.0, 1.0, 0.0, 1.0);
	#else
	float4 TrackParameter = g_TrackParams[min(NUM_TRACKPARAMS_SLOTS - 1, TrackParameterTrackParam)];
	#endif
	
	// Type:TextureNode, Name:DiffuseA
	float4 DiffuseA = DiffuseATexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * DiffuseATiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 DiffuseAMip = GetDebugMipColour(DiffuseATexture, g_samplerLinearWrap, GetTexCoord0(In) * DiffuseATiling);
	#else
	float4 DiffuseAMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 DiffuseAAlpha = DiffuseA.aaaa;
	float4 DiffuseARed = DiffuseA.rrrr;
	float4 DiffuseAGreen = DiffuseA.gggg;
	float4 DiffuseABlue = DiffuseA.bbbb;
	Texture2D DiffuseARef = DiffuseATexture;
	
	// Type:NormalMapOnlyNode, Name:MicroNormal
	float4 MicroNormal = MicroNormalTexture.Sample(g_samplerLinearWrap, GetTexCoord0(In) * MicroNormalTiling);
	#ifdef _MAX_
	MicroNormal.xyz = pow(MicroNormal.xyz, 1 / 2.2);
	#endif
	float4 MicroNormalGlossiness = MicroNormal.bbbb;
	float4 MicroNormalRed = MicroNormal.rrrr;
	float4 MicroNormalGreen = MicroNormal.gggg;
	float4 MicroNormalBlue = MicroNormal.bbbb;
	float4 MicroNormalAlpha = MicroNormal.aaaa;
	MicroNormal = DecodeNormalMap(MicroNormal);
	
	// Type:VectorMake, Name:VectorMake
	float4 VectorMake = float4(MicroNormalAlpha.x, MicroNormalAlpha.x, MicroNormalAlpha.x, MicroNormalGlossiness.x);
	
	// Type:OverlayBlendNode, Name:OverlayBlend0
	float4 OverlayBlend0 = 2.0 * DiffuseA * VectorMake;
	float4 blendOverlayBlend0 = 1.0 - 2.0 * (1.0 - VectorMake) * (1.0 - DiffuseA);
	if (DiffuseA.x > 0.5) OverlayBlend0.x = blendOverlayBlend0.x;
	if (DiffuseA.y > 0.5) OverlayBlend0.y = blendOverlayBlend0.y;
	if (DiffuseA.z > 0.5) OverlayBlend0.z = blendOverlayBlend0.z;
	saturate(OverlayBlend0);
	
	// Type:VariantOnOffNode, Name:MicroNormal_OnOff0
	#if defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 1
	float4 MicroNormal_OnOff0 = OverlayBlend0;
	#elif defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 0
	float4 MicroNormal_OnOff0 = DiffuseA;
	#elif !defined(VARIANTPROPERTY_MICRONORMAL) || VARIANTPROPERTY_MICRONORMAL == 2
	float4 MicroNormal_OnOff0;
	[branch]
	if(VariantConstant_MicroNormal != 0)
	{
		MicroNormal_OnOff0 = OverlayBlend0;
	}
	else
	{
		MicroNormal_OnOff0 = DiffuseA;
	}
	#endif
	
	// Type:WetifyNode, Name:Wetify
	float4 WetifyDiffuse = MicroNormal_OnOff0;
	float WetifyGloss = float(0);
	float WetifyRoughness = DiffuseAAlpha;
	#ifdef _MAX_
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyGloss, float4(lerp(1.0, g_WetDiffuse, g_WetLevel), lerp(1.0, g_WetGloss, g_WetLevel), lerp(1.0, g_WetDiffuse, g_WetLevel), 0), float3(0,1,0), 1);
	#else
	Wetify(WetifyDiffuse.rgb, WetifyGloss, WetifyRoughness, TrackParameter, GetWorldNormal(In).xyz, float(1));
	#endif
	
	// Type:NormalMapWithIntensityNode, Name:NormalA
	float4 textureLookup_NormalA = NormalATexture.Sample(g_samplerLinearWrap, GetTexCoord0(In).xy * NormalATiling);
	#ifdef _MAX_
	textureLookup_NormalA.xyz = pow(textureLookup_NormalA.xyz, 1 / 2.2);
	#endif
	float3 tangentSpaceNormal_NormalA = (2.0f * textureLookup_NormalA.xyz) - float3(1.0f, 1.0f, 1.0f);
	float4 NormalAGlossScalar = ComputeToksvigFactor(tangentSpaceNormal_NormalA, NormalASpecPower);
	float4 NormalAAlpha = textureLookup_NormalA.aaaa;
	float4 NormalARed = textureLookup_NormalA.rrrr;
	float4 NormalAGreen = textureLookup_NormalA.gggg;
	float4 NormalABlue = textureLookup_NormalA.bbbb;
	tangentSpaceNormal_NormalA.y *= -1;
	#if ENABLE_NORMALMAPS 
	tangentSpaceNormal_NormalA.z = sqrt(saturate(1 - tangentSpaceNormal_NormalA.x*tangentSpaceNormal_NormalA.x - tangentSpaceNormal_NormalA.y*tangentSpaceNormal_NormalA.y));
	#ifdef _DEBUG_GLOBAL_SCALARS
	tangentSpaceNormal_NormalA.xy *= g_GlobalNormalScale * NormalAHeightScale.x;
	#else
	tangentSpaceNormal_NormalA.xy *= NormalAHeightScale.x;
	#endif
	float4 NormalA = float4(normalize(mul(tangentSpaceNormal_NormalA, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	#else 
	float4 NormalA = float4(GetWorldNormal(In).xyz, 0);
	#endif
	
	// Type:WorldToTangentSpaceNode, Name:WorldToTangentSpace
	float4 WorldToTangentSpace = float4(normalize(mul(NormalA, transpose(float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz)))), 0);
	
	// Type:FloatNode, Name:Float_1
	float4 Float_1 = float4(1, 1, 1, 1);
	
	// Type:MultiChoiceNormalBlendNode, Name:MultiChoiceNormalBlend
	float4 MultiChoiceNormalBlend = NormalBlendFunction(WorldToTangentSpace, MicroNormal, Float_1, NORMAL_WHITEOUTSIMPLE);
	
	// Type:TangentToWorldSpaceNode, Name:TangentToWorldSpace
	float4 TangentToWorldSpace = float4(normalize(mul(MultiChoiceNormalBlend, float3x3(GetWorldTangent0(In).xyz, (normalize(cross(GetWorldNormal(In).xyz, GetWorldTangent0(In).xyz) * GetWorldTangent0(In).w)).xyz, GetWorldNormal(In).xyz))), 0);
	
	// Type:VariantOnOffNode, Name:MicroNormal_OnOff
	#if defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 1
	float4 MicroNormal_OnOff = TangentToWorldSpace;
	#elif defined(VARIANTPROPERTY_MICRONORMAL) && VARIANTPROPERTY_MICRONORMAL == 0
	float4 MicroNormal_OnOff = NormalA;
	#elif !defined(VARIANTPROPERTY_MICRONORMAL) || VARIANTPROPERTY_MICRONORMAL == 2
	float4 MicroNormal_OnOff;
	[branch]
	if(VariantConstant_MicroNormal != 0)
	{
		MicroNormal_OnOff = TangentToWorldSpace;
	}
	else
	{
		MicroNormal_OnOff = NormalA;
	}
	#endif
	
	// Type:VertexColor, Name:VertexColor
	float4 VertexColor = GetColor(In);float4 VertexColorAlpha = VertexColor.aaaa;
	float4 VertexColorRed = VertexColor.rrrr;
	float4 VertexColorGreen = VertexColor.gggg;
	float4 VertexColorBlue = VertexColor.bbbb;
	
	// Type:VariantOnOffNode, Name:NormalAlphaAO_OnOff
	#if defined(VARIANTPROPERTY_NORMALALPHA_AO) && VARIANTPROPERTY_NORMALALPHA_AO == 1
	float4 NormalAlphaAO_OnOff = NormalAAlpha;
	#elif defined(VARIANTPROPERTY_NORMALALPHA_AO) && VARIANTPROPERTY_NORMALALPHA_AO == 0
	float4 NormalAlphaAO_OnOff = VertexColorAlpha;
	#elif !defined(VARIANTPROPERTY_NORMALALPHA_AO) || VARIANTPROPERTY_NORMALALPHA_AO == 2
	float4 NormalAlphaAO_OnOff;
	[branch]
	if(VariantConstant_NormalAlpha_AO != 0)
	{
		NormalAlphaAO_OnOff = NormalAAlpha;
	}
	else
	{
		NormalAlphaAO_OnOff = VertexColorAlpha;
	}
	#endif
	
	// Type:FloatNode, Name:Float1
	float4 Float1 = float4(0.96, 0.96, 0.96, 0.96);
	
	// Type:FloatNode, Name:Float11
	float4 Float11 = float4(0.8, 0.8, 0.8, 0.8);
	
	// Type:StepNode, Name:Step1
	float4 Step1 = linearstep( Float1, Float11, DiffuseAAlpha );
	
	// Type:AOToCavityMap, Name:AOToCavityMap
	float4 AOToCavityMap = (saturate((1 / (1 + pow(2.71828, -(NormalAlphaAO_OnOff - 0.46) * 5)) - 0.09) * 1.21));
	AOToCavityMap = AOToCavityMap * AOToCavityMapStrength + (1 - AOToCavityMapStrength);
	
	// Type:MultiplyNode, Name:Multiply1
	float4 Multiply1 = Step1 * AOToCavityMap;
	
	// Type:FloatNode, Name:GIAOScale
	float4 GIAOScale = GIAOScale_floatVal;
	
	// Type:FloatNode, Name:GIRadScale
	float4 GIRadScale = GIRadScale_floatVal;
	
	// Type:VectorMake, Name:VectorMake1
	float4 VectorMake1 = float4(GIAOScale.x, GIAOScale.y, GIRadScale.z, 0);
	
	// Type:FloatNode, Name:Float
	float4 Float = Float_floatVal;
	
	// Type:FloatNode, Name:TrunkHeightScale
	float4 TrunkHeightScale = TrunkHeightScale_floatVal;
	
	// Type:FloatNode, Name:TrunkHeightStart
	float4 TrunkHeightStart = TrunkHeightStart_floatVal;
	
	// Type:IntNode, Name:TrunkWindResponse
	float4 TrunkWindResponse = TrunkWindResponse_intVal;
	
	// Type:FloatNode, Name:AnimStartFadeDistance
	float4 AnimStartFadeDistance = AnimStartFadeDistance_floatVal;
	
	// Type:FloatNode, Name:AnimEndFadeDistance
	float4 AnimEndFadeDistance = AnimEndFadeDistance_floatVal;
	
	output.BaseColor = WetifyDiffuse;
	output.Normal = MicroNormal_OnOff;
	output.Roughness = WetifyRoughness;
	output.AmbientOcclusion = NormalAlphaAO_OnOff;
	output.DirectOcclusion = NormalAlphaAO_OnOff;
	output.SpecularScale = Multiply1;
	output.GIScale = VectorMake1;
	#if IN_MATERIAL_EDITOR
	if (!forVertex) clip(Float.x - ALPHATEST_MIN);
	#else
	#if ENABLE_ALPHA_TEST && IS_ALPHA_TESTED
	if (!forVertex && g_EnableAlphaTest) clip(Float.x - ALPHATEST_MIN);
	#endif
	#endif
	output.AlphaTest = Float;
	output.TrunkHeightScale = TrunkHeightScale;
	output.TrunkHeightStart = TrunkHeightStart;
	output.TrunkWindResponse = TrunkWindResponse;
	output.AnimStartFadeDistance = AnimStartFadeDistance;
	output.AnimEndFadeDistance = AnimEndFadeDistance;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\UberFoliageVertex.hlsl"
#include "VertexShaderBase.hlsl"
#endif
#include "LightScenarios\TrackDayOptimisedLightScenario.hlsl"