#include "LightScenarios\Inc\TrackFullNightLightScenario.h"
#include "ShaderRegisterMappings.h"
#include "ShaderFramework.h"
////////////////////////////////////////////////////////////////////////////////
// Parameters
////////////////////////////////////////////////////////////////////////////////
#ifdef _MAX_
float AuroraHardness_floatVal < string UIName = "AuroraHardness_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.9 ;
float FlowDistance_floatVal < string UIName = "FlowDistance_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.01 ;
float4 FlowMapTiling < string UIName = "FlowMapTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float FlowSpeedTimeScale < string UIName = "FlowSpeedTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.05 ;
float FrameBrightness_floatVal < string UIName = "FrameBrightness_floatVal"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0.2 ;
float4 MaskATiling < string UIName = "MaskATiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 2, 0, 0 );
float4 MaskBTiling < string UIName = "MaskBTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 2, 0, 0 );
float4 MaskClouds_LTiling < string UIName = "MaskClouds_LTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 8, 0.5, 0, 0 );
float4 MaskClouds_RTiling < string UIName = "MaskClouds_RTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 8, 0.5, 0, 0 );
float4 NoiseAmountTiling < string UIName = "NoiseAmountTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 NoiseDirectionTiling < string UIName = "NoiseDirectionTiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
float4 SkyTexture1Tiling < string UIName = "SkyTexture1Tiling"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 1, 1, 0, 0 );
int UV_FlowUVSet < string UIName = "UV_FlowUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int UV_TileUVSet < string UIName = "UV_TileUVSet"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
float4 UVPanner_LXYTimeScale < string UIName = "UVPanner_LXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( -0.001, 0.05, 0, 0 );
float4 UVPanner_RXYTimeScale < string UIName = "UVPanner_RXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.001, 0.05, 0, 0 );
float4 UVPannerAXYTimeScale < string UIName = "UVPannerAXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( 0.002, 0, 0, 0 );
float4 UVPannerBXYTimeScale < string UIName = "UVPannerBXYTimeScale"; string UIWidget = "Spinner"; float UIMin = -1000.0; float UIMax = 1000.0; > = float4( -0.001, 0, 0, 0 );
int VariantConstant_Simple < string UIName = "VariantConstant_Simple"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 0 ;
int VariantConstant_Skydome < string UIName = "VariantConstant_Skydome"; string UIWidget = "Slider"; float UIMin = -1000.0; float UIMax = 1000.0; > = 1 ;
#else
#if !INSTANCED_DRAW_BUNDLE
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT(CBuffer_MatEditShader))
{
	#endif //!INSTANCED_DRAW_BUNDLE
	
	#if INSTANCED_DRAW_BUNDLE
	#define UVPannerAXYTimeScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].xy))
	#else
	float2 UVPannerAXYTimeScale : packoffset(c0.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MaskATiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 0].zw))
	#else
	float2 MaskATiling : packoffset(c0.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UVPannerBXYTimeScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].xy))
	#else
	float2 UVPannerBXYTimeScale : packoffset(c1.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MaskBTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 1].zw))
	#else
	float2 MaskBTiling : packoffset(c1.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UVPanner_LXYTimeScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].xy))
	#else
	float2 UVPanner_LXYTimeScale : packoffset(c2.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MaskClouds_LTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 2].zw))
	#else
	float2 MaskClouds_LTiling : packoffset(c2.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define UVPanner_RXYTimeScale ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].xy))
	#else
	float2 UVPanner_RXYTimeScale : packoffset(c3.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define MaskClouds_RTiling ((float2)(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 3].zw))
	#else
	float2 MaskClouds_RTiling : packoffset(c3.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define FlowDistance_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].x)
	#else
	float FlowDistance_floatVal : packoffset(c4.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define FlowSpeedTimeScale (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].y)
	#else
	float FlowSpeedTimeScale : packoffset(c4.y);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define AuroraHardness_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].z)
	#else
	float AuroraHardness_floatVal : packoffset(c4.z);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define FrameBrightness_floatVal (g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 4].w)
	#else
	float FrameBrightness_floatVal : packoffset(c4.w);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Skydome ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].x)))
	#else
	int VariantConstant_Skydome : packoffset(c5.x);
	#endif
	#if INSTANCED_DRAW_BUNDLE
	#define VariantConstant_Simple ((int)(asint(g_ParameterConstantBufferData[GetIDBMaterialCBIndex() + 5].y)))
	#else
	int VariantConstant_Simple : packoffset(c5.y);
	#endif
	#if !INSTANCED_DRAW_BUNDLE
};
#else
cbuffer ParameterConstantBuffer : register(CBUFFER_SLOT_SPACE(CBuffer_IDBBaseMaterialCB, CBufferSpace_IDBBaseMaterialCB))
{
	float4 g_ParameterConstantBufferData[MAX_CONSTANT_BUFFER_ELEMENTS];
};
#endif //INSTANCED_DRAW_BUNDLE

#endif //_MAX_

////////////////////////////////////////////////////////////////////////////////
// Static Parameters
////////////////////////////////////////////////////////////////////////////////
static const int UV_FlowUVSet = 0;
static const float2 FlowMapTiling = float2(1, 1);
static const float2 SkyTexture1Tiling = float2(1, 1);
static const int UV_TileUVSet = 0;
static const float2 NoiseDirectionTiling = float2(1, 1);
static const float2 NoiseAmountTiling = float2(1, 1);

////////////////////////////////////////////////////////////////////////////////
//Textures and Samplers
////////////////////////////////////////////////////////////////////////////////
#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(FlowMapTexture, 16);
#else
#define FlowMapTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(0)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MaskATexture, 17);
#else
#define MaskATexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(1)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MaskBTexture, 18);
#else
#define MaskBTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(2)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MaskClouds_LTexture, 19);
#else
#define MaskClouds_LTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(3)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(MaskClouds_RTexture, 20);
#else
#define MaskClouds_RTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(4)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NoiseAmountTexture, 21);
#else
#define NoiseAmountTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(5)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(NoiseDirectionTexture, 22);
#else
#define NoiseDirectionTexture InstancedDrawBundleTextures2D[GetIDBTextureIndex(6)]
#endif

#if !INSTANCED_DRAW_BUNDLE
DECLARE_TEXTURE2D(SkyTexture1Texture, 23);
#else
#define SkyTexture1Texture InstancedDrawBundleTextures2D[GetIDBTextureIndex(7)]
#endif

Texture2D FunctionInputDummyTexture;
SamplerState FunctionInputDummySamplerState;

////////////////////////////////////////////////////////////////////////////////
//Defines
////////////////////////////////////////////////////////////////////////////////
// Lighting Model
// Inputs
#define MATERIAL_HAS_INPUT_Emissive 1
#define MATERIAL_HAS_INPUT_Additive 1
#define MATERIAL_INPUT_IS_USED_Additive 1
#define MATERIAL_HAS_INPUT_ApplyFog 1
#define MATERIAL_HAS_INPUT_AlphaTest 1
#define MATERIAL_HAS_INPUT_AlphaBlend 1
#define MATERIAL_INPUT_IS_USED_AlphaBlend 1
// Alpha
#define IS_ALPHA_BLENDED 1
#define IS_ALPHA_TESTED 0
////////////////////////////////////////////////////////////////////////////////
//Includes
////////////////////////////////////////////////////////////////////////////////
#include "ShaderUtil.hlsl"
#include "LightingModels\EmissiveOnly.hlsl"
#include "Panner.hlsl"

////////////////////////////////////////////////////////////////////////////////
// Pixel Shader Stage
////////////////////////////////////////////////////////////////////////////////
void OverrideMaterialInputsForVertexLighting(inout MaterialInput input);
#ifdef IS_DEBUG_LIGHT_SCENARIO
void DebugModifyMaterialInputs(inout MaterialInput input);
#endif
MaterialInput GetMaterialInputs(PS_IN In, bool forVertex = false)
{
	MaterialInput output = GetDefaultInputs(In);
	// Type:UVNode, Name:UV_Flow
	float4 UV_Flow = GetTexCoord0(In).xyxy;
	float4 UV_FlowTangent = GetWorldTangent0(In);
	float4 UV_FlowUCoord = GetTexCoord0(In).xxxx;
	float4 UV_FlowVCoord = GetTexCoord0(In).yyyy;
	
	// Type:TextureNodeLinear, Name:FlowMap
	float4 FlowMap = FlowMapTexture.Sample(g_samplerLinearWrap, UV_Flow.xy * FlowMapTiling);
	#ifdef _MAX_
	FlowMap.rgb = pow(FlowMap.rgb, 1 / 2.2);
	#endif
	float4 FlowMapAlpha = FlowMap.aaaa;
	Texture2D FlowMapRef = FlowMapTexture;
	
	// Type:RangeExpandNode, Name:RangeExpand0
	float4 RangeExpand0 = 2 * FlowMap - 1;
	
	// Type:FloatNode, Name:FlowDistance
	float4 FlowDistance = FlowDistance_floatVal;
	
	// Type:MultiplyNode, Name:Multiply0
	float4 Multiply0 = RangeExpand0 * FlowDistance;
	
	// Type:TimeNode, Name:FlowSpeed
	float4 FlowSpeed = FlowSpeedTimeScale * g_Time;
	
	// Type:SinCos, Name:SinCos
	float4 SinCosSinOut = float4( 1, 1, 1, 1); 
	float4 SinCosCosOut = float4( 1, 1, 1, 1); 
	sincos(FlowSpeed, SinCosSinOut, SinCosCosOut); 
	
	// Type:IntNode, Name:Int
	float4 Int = float4(3, 3, 3, 3) ;
	
	// Type:MultiplyNode, Name:Multiply
	float4 Multiply = FlowSpeed * Int;
	
	// Type:SinCos, Name:SinCos0
	float4 SinCos0SinOut = float4( 1, 1, 1, 1); 
	float4 SinCos0CosOut = float4( 1, 1, 1, 1); 
	sincos(Multiply, SinCos0SinOut, SinCos0CosOut); 
	
	// Type:AddNode, Name:Add
	float4 Add = SinCosSinOut + SinCos0CosOut;
	
	// Type:IntNode, Name:Int0
	float4 Int0 = float4(2, 2, 2, 2) ;
	
	// Type:DivideNode, Name:Divide
	float4 Divide = Add / Int0;
	
	// Type:MultiplyNode, Name:Multiply00
	float4 Multiply00 = Multiply0 * Divide;
	
	// Type:AddNode, Name:Add0
	float4 Add0 = UV_Flow + Multiply00;
	
	// Type:VariantOnOffNode, Name:Simple_OnOff0
	#if defined(VARIANTPROPERTY_SIMPLE) && VARIANTPROPERTY_SIMPLE == 1
	float4 Simple_OnOff0 = UV_Flow;
	#elif defined(VARIANTPROPERTY_SIMPLE) && VARIANTPROPERTY_SIMPLE == 0
	float4 Simple_OnOff0 = Add0;
	#elif !defined(VARIANTPROPERTY_SIMPLE) || VARIANTPROPERTY_SIMPLE == 2
	float4 Simple_OnOff0;
	[branch]
	if(VariantConstant_Simple != 0)
	{
		Simple_OnOff0 = UV_Flow;
	}
	else
	{
		Simple_OnOff0 = Add0;
	}
	#endif
	
	// Type:TextureNode, Name:SkyTexture1
	float4 SkyTexture1 = SkyTexture1Texture.Sample(g_samplerLinearWrap, Simple_OnOff0.xy * SkyTexture1Tiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 SkyTexture1Mip = GetDebugMipColour(SkyTexture1Texture, g_samplerLinearWrap, Simple_OnOff0.xy * SkyTexture1Tiling);
	#else
	float4 SkyTexture1Mip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 SkyTexture1Alpha = SkyTexture1.aaaa;
	float4 SkyTexture1Red = SkyTexture1.rrrr;
	float4 SkyTexture1Green = SkyTexture1.gggg;
	float4 SkyTexture1Blue = SkyTexture1.bbbb;
	Texture2D SkyTexture1Ref = SkyTexture1Texture;
	
	// Type:IntNode, Name:Zero
	float4 Zero = float4(0, 0, 0, 0) ;
	
	// Type:FloatNode, Name:AuroraHardness
	float4 AuroraHardness = AuroraHardness_floatVal;
	
	// Type:PowNode, Name:Pow
	float4 Pow = pow( SkyTexture1, AuroraHardness );
	
	// Type:FloatNode, Name:FrameBrightness
	float4 FrameBrightness = FrameBrightness_floatVal;
	
	// Type:UVNode, Name:UV_Tile
	float4 UV_Tile = GetTexCoord0(In).xyxy;
	float4 UV_TileTangent = GetWorldTangent0(In);
	float4 UV_TileUCoord = GetTexCoord0(In).xxxx;
	float4 UV_TileVCoord = GetTexCoord0(In).yyyy;
	
	// Type:UVPannerNode, Name:UVPannerA
	float4 UVPannerA = PanTextureCoordinates(UV_Tile.xy, g_Time * UVPannerAXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:MaskA
	float4 MaskA = MaskATexture.Sample(g_samplerLinearWrap, UVPannerA.xy * MaskATiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MaskAMip = GetDebugMipColour(MaskATexture, g_samplerLinearWrap, UVPannerA.xy * MaskATiling);
	#else
	float4 MaskAMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MaskAAlpha = MaskA.aaaa;
	float4 MaskARed = MaskA.rrrr;
	float4 MaskAGreen = MaskA.gggg;
	float4 MaskABlue = MaskA.bbbb;
	Texture2D MaskARef = MaskATexture;
	
	// Type:UVPannerNode, Name:UVPannerB
	float4 UVPannerB = PanTextureCoordinates(UV_Tile.xy, g_Time * UVPannerBXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:MaskB
	float4 MaskB = MaskBTexture.Sample(g_samplerLinearWrap, UVPannerB.xy * MaskBTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MaskBMip = GetDebugMipColour(MaskBTexture, g_samplerLinearWrap, UVPannerB.xy * MaskBTiling);
	#else
	float4 MaskBMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MaskBAlpha = MaskB.aaaa;
	float4 MaskBRed = MaskB.rrrr;
	float4 MaskBGreen = MaskB.gggg;
	float4 MaskBBlue = MaskB.bbbb;
	Texture2D MaskBRef = MaskBTexture;
	
	// Type:OverlayBlendNode, Name:OverlayBlend0
	float4 OverlayBlend0 = 2.0 * MaskARed * MaskBRed;
	float4 blendOverlayBlend0 = 1.0 - 2.0 * (1.0 - MaskBRed) * (1.0 - MaskARed);
	if (MaskARed.x > 0.5) OverlayBlend0.x = blendOverlayBlend0.x;
	if (MaskARed.y > 0.5) OverlayBlend0.y = blendOverlayBlend0.y;
	if (MaskARed.z > 0.5) OverlayBlend0.z = blendOverlayBlend0.z;
	saturate(OverlayBlend0);
	
	// Type:UVPannerNode, Name:UVPanner_L
	float4 UVPanner_L = PanTextureCoordinates(UV_Tile.xy, g_Time * UVPanner_LXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:MaskClouds_L
	float4 MaskClouds_L = MaskClouds_LTexture.Sample(g_samplerLinearWrap, UVPanner_L.xy * MaskClouds_LTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MaskClouds_LMip = GetDebugMipColour(MaskClouds_LTexture, g_samplerLinearWrap, UVPanner_L.xy * MaskClouds_LTiling);
	#else
	float4 MaskClouds_LMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MaskClouds_LAlpha = MaskClouds_L.aaaa;
	float4 MaskClouds_LRed = MaskClouds_L.rrrr;
	float4 MaskClouds_LGreen = MaskClouds_L.gggg;
	float4 MaskClouds_LBlue = MaskClouds_L.bbbb;
	Texture2D MaskClouds_LRef = MaskClouds_LTexture;
	
	// Type:UVPannerNode, Name:UVPanner_R
	float4 UVPanner_R = PanTextureCoordinates(UV_Tile.xy, g_Time * UVPanner_RXYTimeScale.xy).xyxy;
	
	// Type:TextureNode, Name:MaskClouds_R
	float4 MaskClouds_R = MaskClouds_RTexture.Sample(g_samplerLinearWrap, UVPanner_R.xy * MaskClouds_RTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 MaskClouds_RMip = GetDebugMipColour(MaskClouds_RTexture, g_samplerLinearWrap, UVPanner_R.xy * MaskClouds_RTiling);
	#else
	float4 MaskClouds_RMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 MaskClouds_RAlpha = MaskClouds_R.aaaa;
	float4 MaskClouds_RRed = MaskClouds_R.rrrr;
	float4 MaskClouds_RGreen = MaskClouds_R.gggg;
	float4 MaskClouds_RBlue = MaskClouds_R.bbbb;
	Texture2D MaskClouds_RRef = MaskClouds_RTexture;
	
	// Type:TextureNode, Name:NoiseDirection
	float4 NoiseDirection = NoiseDirectionTexture.Sample(g_samplerLinearWrap, Simple_OnOff0.xy * NoiseDirectionTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 NoiseDirectionMip = GetDebugMipColour(NoiseDirectionTexture, g_samplerLinearWrap, Simple_OnOff0.xy * NoiseDirectionTiling);
	#else
	float4 NoiseDirectionMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 NoiseDirectionAlpha = NoiseDirection.aaaa;
	float4 NoiseDirectionRed = NoiseDirection.rrrr;
	float4 NoiseDirectionGreen = NoiseDirection.gggg;
	float4 NoiseDirectionBlue = NoiseDirection.bbbb;
	Texture2D NoiseDirectionRef = NoiseDirectionTexture;
	
	// Type:LerpNode, Name:Lerp
	float4 Lerp = lerp(MaskClouds_LRed, MaskClouds_RRed, NoiseDirectionRed.x);
	
	// Type:OverlayBlendNode, Name:OverlayBlend1
	float4 OverlayBlend1 = 2.0 * OverlayBlend0 * Lerp;
	float4 blendOverlayBlend1 = 1.0 - 2.0 * (1.0 - Lerp) * (1.0 - OverlayBlend0);
	if (OverlayBlend0.x > 0.5) OverlayBlend1.x = blendOverlayBlend1.x;
	if (OverlayBlend0.y > 0.5) OverlayBlend1.y = blendOverlayBlend1.y;
	if (OverlayBlend0.z > 0.5) OverlayBlend1.z = blendOverlayBlend1.z;
	saturate(OverlayBlend1);
	
	// Type:SaturateNode, Name:Saturate0
	float4 Saturate0 = saturate( OverlayBlend1 ); 
	
	// Type:FloatNode, Name:Half
	float4 Half = float4(0.5, 0.5, 0.5, 0.5);
	
	// Type:TextureNode, Name:NoiseAmount
	float4 NoiseAmount = NoiseAmountTexture.Sample(g_samplerLinearWrap, Simple_OnOff0.xy * NoiseAmountTiling);
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	float4 NoiseAmountMip = GetDebugMipColour(NoiseAmountTexture, g_samplerLinearWrap, Simple_OnOff0.xy * NoiseAmountTiling);
	#else
	float4 NoiseAmountMip = float4(0.0f, 0.0f, 0.0f, 0.0f);
	#endif
	float4 NoiseAmountAlpha = NoiseAmount.aaaa;
	float4 NoiseAmountRed = NoiseAmount.rrrr;
	float4 NoiseAmountGreen = NoiseAmount.gggg;
	float4 NoiseAmountBlue = NoiseAmount.bbbb;
	Texture2D NoiseAmountRef = NoiseAmountTexture;
	
	// Type:LerpNode, Name:Lerp0
	float4 Lerp0 = lerp(Saturate0, Half, NoiseAmountRed.x);
	
	// Type:VariantOnOffNode, Name:Simple_OnOff1
	#if defined(VARIANTPROPERTY_SIMPLE) && VARIANTPROPERTY_SIMPLE == 1
	float4 Simple_OnOff1 = FrameBrightness;
	#elif defined(VARIANTPROPERTY_SIMPLE) && VARIANTPROPERTY_SIMPLE == 0
	float4 Simple_OnOff1 = Lerp0;
	#elif !defined(VARIANTPROPERTY_SIMPLE) || VARIANTPROPERTY_SIMPLE == 2
	float4 Simple_OnOff1;
	[branch]
	if(VariantConstant_Simple != 0)
	{
		Simple_OnOff1 = FrameBrightness;
	}
	else
	{
		Simple_OnOff1 = Lerp0;
	}
	#endif
	
	// Type:LerpNode, Name:Lerp1
	float4 Lerp1 = lerp(Zero, Pow, Simple_OnOff1.x);
	
	// Type:HardLightBlendNode, Name:HardLightBlend
	float4 HardLightBlend = 2.0 * SkyTexture1 * Lerp1;
	float4 blendHardLightBlend = 1.0 - 2.0 * (1.0 - SkyTexture1) * (1.0 - Lerp1);
	if (Lerp1.x > 0.5) HardLightBlend.x = blendHardLightBlend.x;
	if (Lerp1.y > 0.5) HardLightBlend.y = blendHardLightBlend.y;
	if (Lerp1.z > 0.5) HardLightBlend.z = blendHardLightBlend.z;
	saturate(HardLightBlend);
	
	// Type:MultiplyNode, Name:Multiply3
	float4 Multiply3 = Lerp1 * Simple_OnOff1;
	
	// Type:MultiplyAddNode, Name:MultiplyAdd
	float4 MultiplyAdd = HardLightBlend * Lerp1 + Multiply3;
	
	output.Additive = MultiplyAdd;
	output.AlphaBlend = Zero;
	#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
	if(forVertex)
	{
		  OverrideMaterialInputsForVertexLighting(output);
	}
	#endif
	#ifdef IS_DEBUG_LIGHT_SCENARIO
	DebugModifyMaterialInputs(output);
	#endif
	FinalizeInputs(output);
	return output;
}

#if defined(VERTEX_SHADER) || defined(IN_MATERIAL_EDITOR)
////////////////////////////////////////////////////////////////////////////////
//vertex shader includes
////////////////////////////////////////////////////////////////////////////////
#include "VertexShaders\AdditiveSkydome.hlsl"
#include "VertexShaderBase.hlsl"
#endif

#include "CommonAlphaEntryPoint.hlsl"
#include "LightScenarios\TrackFullNightLightScenario.hlsl"