@echo off
mode 80,30
%~d0
cd %~dp0

REM *********************************************************
REM *** define your variables here...
REM *********************************************************
rem *** md5 backup will be recalculated with each attempt...
rem *** if [games2.arc] gets updated, you must update its md5 value here...
rem ***
set sExpFolder=EXP_game2.arc
set sFileOrig=wb_ava_logo.bk2c
set sIntroOrig=%sExpFolder%\%sFileOrig%_ORIG
set sIntroSkip=%sExpFolder%\%sFileOrig%_SKIP
set sGameFile=game2.arc
set sGameBackup=game2.arc_BACKUP
set md5_ORIG=edc0a72a42c70b23525f7f10786874b7
set md5_SKIP=0e35cd8501714201afb8b8a127e9ac00
set md5_BACK=edc0a72a42c70b23525f7f10786874b7
set SysFiles=MadMax_Filelist.txt
set ChMD5=MadMax_fciv.exe


Title Change Intro Movie Mad Max...

rem *** check if system files are present...
(echo MadMax_ARC.bms
 echo %ChMD5%
 echo MadMax_Hashes.list
 echo MadMax_NoIntro.bat
 echo quickbms.exe)> %SysFiles%

for /F %%i in (%SysFiles%) do (
    if NOT exist %%i (
    echo.
    echo [%%i] is not located in this folder...
    echo.
    del %SysFiles% >nul 2>nul
    goto :End)
)
del %SysFiles% >nul 2>nul

:choice
cls
echo.
echo *******************************************************************************
echo *                                                                             *
echo *                 Changing Intro Movie ~ Mad Max  [v1.001]                    *
echo *                                                                             *
echo *                                                                             *
echo *   This procedure first makes a copy of [game2.arc] ~ ^[game2.arc_BACKUP^]     *
echo *   If a backup already exists, it will verify its original hash-value        *
echo *   ^(and will not overwrite it again if it proves to be the original file^)    *
echo *                                                                             *
echo *                                                                             *
echo *       Choose:  1 = Replace with NoIntro movie                               *
echo *                3 = Restore original intro movie                             *
echo *                                                                             *
echo *                5 = Extract original intro movie                             *
echo *                0 = Quit                                                     *
echo *                                                                             *
echo *                                                                             *
echo *   Current Folder: [%~dp0]
echo *                   (you must be located in [.\archives_win64])               *
echo *                                                                             *
echo *                                                                             *
echo *  Important note: if you want to be sure, make a manual backup yourself...   *
echo *                                                                             *
echo *******************************************************************************
echo.
set /p userinp=Type a number (0-5): 
set userinp=%userinp:~0,1%
if "%userinp%"=="0" (
goto :End
)
if "%userinp%"=="1" goto NoIntro
if "%userinp%"=="3" goto Original
if "%userinp%"=="5" goto ExtractOrig
echo invalid choice
goto choice


REM ***************************
REM *** Replace Intro movie ***
REM ***************************

:NoIntro
if "%userinp"=="" goto choice

if NOT exist %sGameFile% (
    echo.
    echo [%sGameFile%] is not located in current folder...
    goto :End
)

if NOT exist %sIntroOrig% (
    echo.
    echo You must first extract the original Intro movie...
    pause
    goto :choice
)

if NOT exist %sIntroSkip% (
    echo.
    echo [%sIntroSkip%] does not exist in this folder...
    pause
    goto :choice
)

Setlocal EnableDelayedExpansion
if NOT exist %sGameBackup% (
    rem check if this is the original file...
    for /f "skip=3 delims= " %%f in ('%ChMD5% -wp -md5 %sGameFile%') do (
        set md5_Temp=%%f
        if %md5_ORIG% NEQ !md5_Temp! (
        echo.
        echo Current [%sGameFile%] is not the original file...
        goto :End
        )
    )
    copy %sGameFile% %sGameBackup% >nul 2>nul
    if %errorlevel% NEQ 0 (
         echo.
         echo Could not make a backup copy...
         goto :End
    )
) ELSE (
    rem *** verify backup
    for /f "skip=3 delims= " %%f in ('%ChMD5% -wp -md5 %sGameBackup%') do (
        set md5_BACK=%%f
        if %md5_ORIG% NEQ %md5_BACK% (
        echo Backup file is incorrect...
        goto :End
        )
    )
)
endlocal

rem *** importing nointro movie
echo Replacing Intro movie...
rem *** check if current file has already NoIntro movie...
for /F "skip=3 delims= " %%f in ('%ChMD5% -wp -md5 %sGameFile%') do (set md5_Temp=%%f)

if %md5_SKIP% EQU %md5_Temp% (
     echo.
     echo The Intro movie has already been replaced...
     goto :End
)

FOR /F %%F IN ("%sIntroSkip%") do (set sFilename=%%~nxF)
set sFilename=%sFilename:~0,-5%
copy %sIntroSkip% %sExpFolder%\%sFilename% >nul 2>nul

if %errorlevel% NEQ 0 (
     echo.
     echo Could not make an Intro movie copy...
     goto :End
)

quickbms -w -r MadMax_ARC.bms %sGameFile% %sExpFolder%

if %errorlevel% EQU 0 (
     echo.
     echo.
     echo *[Replacing NoIntro movie was successful...]*
     echo.
     goto :End
) ELSE (
     echo.
     echo Something went wrong. Try running the command manually...
     goto :End
)


REM **********************************
REM *** Restore original game file ***
REM **********************************

:Original
if "%userinp"=="" goto choice
if NOT exist %sGameFile% (
    echo [%sGameFile%] is not located in current folder...
    goto :End
)

for /F "skip=3 delims= " %%f in ('%ChMD5% -wp -md5 %sGameFile%') do (set md5_Temp=%%f)
if %md5_ORIG% EQU %md5_Temp% (
     echo.
     echo The current [%sGameFile%] is the original file...
     goto :End
)

Setlocal EnableDelayedExpansion
if exist %sGameBackup% (
    rem check if this is the original file...
    for /f "skip=3 delims= " %%f in ('%ChMD5% -wp -md5 %sGameBackup%') do (
        set md5_Temp=%%f
        if %md5_ORIG% NEQ !md5_Temp! (
        echo.
        echo Current [%sGameBackup%] is not a backup of the original file...
        goto :End
        )
        rem *** restore original file...
        echo.
        echo Restoring original [%sGameFile%] file from backup...

        copy %sGameBackup% %sGameFile% >nul 2>nul
        if %errorlevel% NEQ 0 (
            echo.
            echo Could not restore the original [%sGameFile%] file...
            goto :End
        )
    )
) ELSE (

     echo Restoring original Intro movie...

     rem *** check if current file has already original Intro movie...
     for /F "skip=3 delims= " %%f in ('%ChMD5% -wp -md5 %sGameFile%') do (set md5_Temp=%%f)

     if %md5_ORIG% EQU !md5_Temp! (
          echo.
          echo The original Intro movie has already been restored...
          goto :End
     )

     FOR /F %%F IN ("%sIntroOrig%") do (set sFilename=%%~nxF)
     set sFilename=!sFilename:~0,-5!

     copy %sIntroOrig% %sExpFolder%\!sFilename! >nul 2>nul
     if %errorlevel% NEQ 0 (
          echo.
          echo Could not make an original Intro movie copy...
          goto :End
     )

     quickbms -w -r MadMax_ARC.bms %sGameFile% %sExpFolder%

     if %errorlevel% EQU 0 (
          echo.
          echo.
          echo *[Restoring original Intro movie was successful...]*
          goto :End
     ) ELSE (
          echo.
          echo Something went wrong. Try running the command manually...
          goto :End
     )
)
endlocal



REM ************************************
REM *** Extract original Intro movie ***
REM ************************************

:ExtractOrig

if NOT exist %sGameFile% (
    echo.
    echo [%sGameFile%] is not located in current folder...
    goto :choice
)

echo Extracting original Intro movie...
md %sExpFolder% >nul 2>nul

quickbms -Y -f "wb_ava_logo.bk2c" MadMax_ARC.bms %sGameFile% %sExpFolder%

if %errorlevel% EQU 0 (
     echo.
     echo *[Extracting original Intro movie was successful...]*
) ELSE (
     echo.
     echo Something went wrong. Try running the command manually...
)

if exist %sIntroOrig% (
    del %sIntroOrig% >nul 2>nul
)

ren %sExpFolder%\%sFileOrig% %sFileOrig%_ORIG

if %errorlevel% NEQ 0 (
     echo.
     echo *[Could not rename original Intro movie...]*
)
echo.
pause
goto choice



:End
echo.
echo Quiting...
pause
