/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_638;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.minimap.radar.color.RadarColorHelper;
import xaero.hud.minimap.radar.state.RadarState;
import xaero.hud.minimap.radar.state.RadarStateUpdater;

public class RadarSession {
    private final EntityRadarCategoryManager categoryManager;
    private final RadarState state;
    private final RadarStateUpdater stateUpdater;
    private final RadarColorHelper colorHelper;

    public RadarSession(EntityRadarCategoryManager categoryManager) {
        this.categoryManager = categoryManager;
        this.state = new RadarState();
        this.stateUpdater = new RadarStateUpdater(categoryManager, this.state);
        this.colorHelper = new RadarColorHelper();
    }

    public void update(class_638 world, class_1297 renderEntity, class_1657 player) {
        this.stateUpdater.update(world, renderEntity, player);
    }

    public EntityRadarCategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public RadarState getState() {
        return this.state;
    }

    public RadarStateUpdater getStateUpdater() {
        return this.stateUpdater;
    }

    public RadarColorHelper getColorHelper() {
        return this.colorHelper;
    }

    public static class Builder {
        private EntityRadarCategoryManager categoryManager;

        private Builder() {
        }

        public Builder setDefault() {
            this.setCategoryManager(null);
            return this;
        }

        public Builder setCategoryManager(EntityRadarCategoryManager categoryManager) {
            this.categoryManager = categoryManager;
            return this;
        }

        public RadarSession build() {
            if (this.categoryManager == null) {
                throw new IllegalStateException();
            }
            return new MinimapRadar(this.categoryManager);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

