/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.tracking.entity;

import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import net.caffeinemc.mods.lithium.api.inventory.LithiumInventory;
import net.caffeinemc.mods.lithium.common.entity.EntityClassGroup;
import net.minecraft.class_1263;
import net.minecraft.class_1542;
import net.minecraft.class_2614;
import net.minecraft.class_5568;

public abstract class MovementTrackerHelper {
    public static final List<Class<?>> MOVEMENT_NOTIFYING_ENTITY_CLASSES = LithiumInventory.class.isAssignableFrom(class_2614.class) ? List.of(class_1542.class, class_1263.class) : List.of();
    public static final List<EntityClassGroup> MOVEMENT_NOTIFYING_ENTITY_CLASS_GROUPS = List.of();
    public static volatile Reference2IntOpenHashMap<Class<? extends class_5568>> CLASS_2_NOTIFY_MASK = new Reference2IntOpenHashMap();
    public static final int NUM_MOVEMENT_NOTIFYING_CLASSES;

    public static int getNotificationMask(Class<? extends class_5568> entityClass) {
        int notificationMask = CLASS_2_NOTIFY_MASK.getInt(entityClass);
        if (notificationMask == -1) {
            notificationMask = MovementTrackerHelper.calculateNotificationMask(entityClass);
        }
        return notificationMask;
    }

    private static int calculateNotificationMask(Class<? extends class_5568> entityClass) {
        int i;
        int mask = 0;
        for (i = 0; i < MOVEMENT_NOTIFYING_ENTITY_CLASSES.size(); ++i) {
            Class<? extends class_5568> superclass = MOVEMENT_NOTIFYING_ENTITY_CLASSES.get(i);
            if (!superclass.isAssignableFrom(entityClass)) continue;
            mask |= 1 << i;
        }
        for (i = 0; i < MOVEMENT_NOTIFYING_ENTITY_CLASS_GROUPS.size(); ++i) {
            EntityClassGroup group = MOVEMENT_NOTIFYING_ENTITY_CLASS_GROUPS.get(i);
            if (!group.contains(entityClass)) continue;
            mask |= 1 << i + MOVEMENT_NOTIFYING_ENTITY_CLASSES.size();
        }
        Reference2IntOpenHashMap copy = CLASS_2_NOTIFY_MASK.clone();
        copy.put(entityClass, mask);
        CLASS_2_NOTIFY_MASK = copy;
        return mask;
    }

    static int getTrackerIndex(Object classOrClassGroup) {
        if (classOrClassGroup instanceof Class) {
            return MOVEMENT_NOTIFYING_ENTITY_CLASSES.indexOf(classOrClassGroup);
        }
        if (classOrClassGroup instanceof EntityClassGroup) {
            return MOVEMENT_NOTIFYING_ENTITY_CLASSES.size() + MOVEMENT_NOTIFYING_ENTITY_CLASS_GROUPS.indexOf(classOrClassGroup);
        }
        return -1;
    }

    static {
        CLASS_2_NOTIFY_MASK.defaultReturnValue(-1);
        NUM_MOVEMENT_NOTIFYING_CLASSES = MOVEMENT_NOTIFYING_ENTITY_CLASSES.size() + MOVEMENT_NOTIFYING_ENTITY_CLASS_GROUPS.size();
    }
}

