/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorPosesScreen;
import com.mrbysco.armorposer.client.gui.widgets.PoseEntry;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2522;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3730;
import net.minecraft.class_4280;
import net.minecraft.class_490;
import net.minecraft.class_638;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PoseListWidget
extends class_4280<ListEntry> {
    private static final Vector3f ARMOR_STAND_TRANSLATION = new Vector3f();
    private static final Quaternionf ARMOR_STAND_ANGLE = new Quaternionf().rotationXYZ(0.43633232f, 0.0f, (float)Math.PI);
    private final ArmorPosesScreen parent;
    private final int listWidth;
    private final class_2561 title;

    public PoseListWidget(ArmorPosesScreen parent, class_2561 title, boolean user, int listWidth, int top, int bottom) {
        class_310 class_3102 = parent.getScreenMinecraft();
        Objects.requireNonNull(parent.getScreenFont());
        super(class_3102, listWidth, bottom - top, top, 9 * 2 + 16);
        this.parent = parent;
        this.title = title;
        this.listWidth = listWidth;
        this.refreshList(user);
    }

    protected int method_65507() {
        return this.method_46426() + this.listWidth - 6;
    }

    public int method_25322() {
        return this.listWidth;
    }

    public void refreshList(boolean user) {
        this.method_25339();
        if (user) {
            this.parent.buildUserPoseList(x$0 -> this.method_25321((class_350.class_351)x$0), location -> new ListEntry((PoseEntry)location, this.parent));
        } else {
            this.parent.buildPoseList(x$0 -> this.method_25321((class_350.class_351)x$0), location -> new ListEntry((PoseEntry)location, this.parent));
        }
    }

    protected void method_44398(class_332 guiGraphics, int top, int width, int height, int outerColor, int innerColor) {
        int xPos = this.method_46426() + (this.field_22758 - width) / 2;
        int xPos2 = this.method_46426() + (this.field_22758 + width) / 2;
        guiGraphics.method_25296(xPos, top - 2, xPos2, top + height + 2, -1945083888, -1676648432);
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.method_25296(this.method_46426(), 0, this.method_46426() + this.listWidth, this.parent.field_22790, -1945104368, -1676668912);
        super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.method_27534(this.parent.getScreenFont(), this.title, this.method_46426() + this.listWidth / 2, 2, 0xFFFFFF);
    }

    public class ListEntry
    extends class_4280.class_4281<ListEntry> {
        private final PoseEntry poseEntry;
        private final ArmorPosesScreen parent;
        private class_1309 cachedEntity;

        ListEntry(PoseEntry entry, ArmorPosesScreen parent) {
            class_638 level;
            this.poseEntry = entry;
            this.parent = parent;
            class_310 mc = parent.getScreenMinecraft();
            if (mc == null) {
                Reference.LOGGER.error("Minecraft is null, cannot create pose entry {}", (Object)entry.pose().name());
                return;
            }
            Object object = level = mc.method_1496() && mc.method_1576() != null ? (class_1937)mc.method_1576().method_3738().iterator().next() : mc.field_1687;
            if (level != null) {
                try {
                    class_2487 tag = class_2522.method_10718((String)entry.pose().data());
                    class_2487 nbt = new class_2487();
                    nbt.method_10582("id", "minecraft:armor_stand");
                    if (!tag.method_33133()) {
                        nbt.method_10543(tag);
                    }
                    this.cachedEntity = (class_1531)class_1299.method_17842((class_2487)nbt, (class_1937)level, (class_3730)class_3730.field_52444, entity -> {
                        if (entity instanceof class_1531) {
                            class_1531 stand = (class_1531)entity;
                            stand.method_6907(true);
                            stand.method_6913(true);
                            stand.field_6283 = 210.0f;
                            stand.method_36457(25.0f);
                            stand.field_6241 = stand.method_36454();
                            stand.field_6259 = stand.method_36454();
                        }
                        return entity;
                    });
                }
                catch (Exception e) {
                    Reference.LOGGER.error("Unable to parse nbt pose {}", (Object)e.getMessage());
                }
            }
        }

        public void method_25343(class_332 guiGraphics, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            class_327 font = this.parent.getScreenFont();
            PoseListWidget.method_52718((class_332)guiGraphics, (class_327)font, (class_2561)((class_2561)class_2561.method_43470((String)this.getName())), (int)(left + 36), (int)(top + 10), (int)(left + PoseListWidget.this.field_22758 - 18), (int)(top + 20), (int)0xFFFFFF);
            this.renderPose(guiGraphics, left + 16, top + 28, 15);
        }

        public void renderPose(class_332 guiGraphics, int xPos, int yPos, int size) {
            if (this.cachedEntity != null) {
                class_490.method_48472((class_332)guiGraphics, (float)xPos, (float)yPos, (float)size, (Vector3f)ARMOR_STAND_TRANSLATION, (Quaternionf)ARMOR_STAND_ANGLE, (Quaternionf)null, (class_1309)this.cachedEntity);
            }
        }

        public void method_49568(class_332 guiGraphics, int mouseX, int mouseY, int $$3, int $$4, int $$5, int $$6, int $$7, boolean $$8, float $$9) {
            super.method_49568(guiGraphics, mouseX, mouseY, $$3, $$4, $$5, $$6, $$7, $$8, $$9);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            this.parent.setSelected(this);
            if (PoseListWidget.this.method_25334() == this) {
                PoseListWidget.this.method_25313(null);
            } else {
                PoseListWidget.this.method_25313((class_350.class_351)this);
            }
            return false;
        }

        public class_2487 getTag() {
            return this.poseEntry.getTag();
        }

        public String getName() {
            return this.poseEntry.getName();
        }

        public boolean userAdded() {
            return this.poseEntry.userAdded();
        }

        public String rawName() {
            return this.poseEntry.pose().name();
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.getName());
        }
    }
}

