/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.StringReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class Util {
    public static final Gson GSON = new GsonBuilder().create();

    private Util() {
    }

    public static StringReader prepareStringReader(String buffer) {
        StringReader stringReader = new StringReader(buffer);
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        return stringReader;
    }

    public static void deleteDirectoryIfExists(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);){
                List<Path> list = stream.sorted(Comparator.reverseOrder()).toList();
                for (Path path : list) {
                    Files.deleteIfExists(path);
                }
            }
        }
    }

    public static <X extends Throwable> RuntimeException rethrow(Throwable t) throws X {
        throw t;
    }

    public static BufferedReader gzipBufferedReader(Path path) throws IOException {
        return new BufferedReader(new InputStreamReader(new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]))));
    }

    public static BufferedWriter gzipBufferedWriter(Path path) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(Files.newOutputStream(path, new OpenOption[0]))));
    }
}

