/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.remap;

import com.mojang.logging.LogUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.zip.GZIPOutputStream;
import net.minecraft.class_3797;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.slf4j.Logger;
import xyz.jpenilla.betterfabricconsole.remap.MappingsDownloader;
import xyz.jpenilla.betterfabricconsole.remap.MojangMappingsDownloader;
import xyz.jpenilla.betterfabricconsole.remap.YarnMappingsDownloader;
import xyz.jpenilla.betterfabricconsole.util.Util;

@DefaultQualifier(value=NonNull.class)
public final class MappingsCache {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String VERSION = String.valueOf(2);
    private static final String VERSION_PATH = "version.txt";
    static final String MINECRAFT_VERSION = class_3797.method_16672().method_48018();
    static final String DATA_PATH = "data";
    static final String MAPPINGS_PATH = "mappings";
    static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0000");
    final Path cache;
    private final Path failed;

    public MappingsCache(Path cache) throws IOException {
        this.cache = cache;
        this.failed = cache.resolveSibling(String.valueOf(cache.getFileName()) + "_failed");
        Util.deleteDirectoryIfExists(this.failed);
        try {
            this.checkCacheVersion();
        }
        catch (IOException e) {
            this.moveFailed();
            throw e;
        }
    }

    private void checkCacheVersion() throws IOException {
        boolean clean = false;
        if (!Files.exists(this.cache.resolve(VERSION_PATH), new LinkOption[0])) {
            clean = true;
        } else {
            String versionString = Files.readString(this.cache.resolve(VERSION_PATH));
            if (!versionString.equals(VERSION)) {
                clean = true;
            }
        }
        if (clean) {
            Util.deleteDirectoryIfExists(this.cache);
            Files.createDirectories(this.cache, new FileAttribute[0]);
            Files.writeString(this.cache.resolve(VERSION_PATH), (CharSequence)VERSION, new OpenOption[0]);
        }
    }

    void moveFailed() {
        if (!Files.exists(this.cache, new LinkOption[0])) {
            return;
        }
        try {
            Files.move(this.cache, this.failed, new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to move failed mappings cache", (Throwable)e);
            try {
                Util.deleteDirectoryIfExists(this.cache);
            }
            catch (IOException e1) {
                LOGGER.warn("Failed to delete failed mappings cache", (Throwable)e);
            }
        }
    }

    public MappingsDownloader<MojangMappingsDownloader.MojangMappingsData> createMojangMappingsDownloader() {
        return new MojangMappingsDownloader(this);
    }

    public MappingsDownloader<YarnMappingsDownloader.YarnData> createYarnMappingsDownloader() {
        return new YarnMappingsDownloader(this);
    }

    static void downloadFile(String url, Path dest) throws IOException {
        MappingsCache.downloadFile(url, dest, false);
    }

    static void downloadFileAndGzip(String url, Path dest) throws IOException {
        MappingsCache.downloadFile(url, dest, true);
    }

    private static void downloadFile(String url, Path dest, boolean gzip) throws IOException {
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        Path tempDest = dest.resolveSibling(dest.getFileName().toString() + ".download.tmp");
        Files.deleteIfExists(tempDest);
        LOGGER.info("Downloading {}...", (Object)url);
        long start = System.currentTimeMillis();
        try (ReadableByteChannel downloadChannel = Channels.newChannel(URI.create(url).toURL().openStream());
             FileOutputStream outputStream = new FileOutputStream(tempDest.toFile());){
            outputStream.getChannel().transferFrom(downloadChannel, 0L, Long.MAX_VALUE);
        }
        if (gzip) {
            try (GZIPOutputStream output = new GZIPOutputStream(Files.newOutputStream(dest, new OpenOption[0]));){
                Files.copy(tempDest, output);
                Files.deleteIfExists(tempDest);
            }
        } else {
            Files.move(tempDest, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        LOGGER.info("Done in {} seconds.", (Object)DECIMAL_FORMAT.format((double)(System.currentTimeMillis() - start) / 1000.0));
    }
}

