/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.console;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.platform.modcommon.MinecraftServerAudiences;
import net.kyori.adventure.text.serializer.ansi.ANSIComponentSerializer;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import xyz.jpenilla.betterfabricconsole.util.Util;

@DefaultQualifier(value=NonNull.class)
public record MinecraftCommandCompleter(MinecraftServer server, MinecraftServerAudiences audiences) implements Completer
{
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        StringReader stringReader = Util.prepareStringReader(line.line());
        ParseResults results = this.server.method_3734().method_9235().parse(stringReader, (Object)this.server.method_3739());
        CompletableFuture suggestionsFuture = this.server.method_3734().method_9235().getCompletionSuggestions(results, line.cursor());
        Suggestions suggestions = (Suggestions)suggestionsFuture.join();
        ParseContext parseContext = new ParseContext(line.line(), results.getContext().findSuggestionContext((int)line.cursor()).startPos);
        for (Suggestion suggestion : suggestions.getList()) {
            String suggestionText = suggestion.getText();
            if (suggestionText.isEmpty()) continue;
            candidates.add(this.toCandidate(suggestion, parseContext));
        }
    }

    private Candidate toCandidate(Suggestion suggestion, ParseContext context) {
        return this.toCandidate(context.line.substring(context.suggestionStart, suggestion.getRange().getStart()) + suggestion.getText(), suggestion.getTooltip());
    }

    private Candidate toCandidate(String suggestionText, Message descriptionMessage) {
        @Nullable String description = Optional.ofNullable(descriptionMessage).map(tooltip -> {
            class_2561 tooltipComponent = class_2564.method_10883((Message)tooltip);
            return tooltipComponent.equals((Object)class_2561.method_43473()) ? null : this.audiences.asAdventure(tooltipComponent);
        }).map(adventure -> (String)ANSIComponentSerializer.ansi().serialize(adventure)).orElse(null);
        return new MinecraftCandidate(suggestionText, suggestionText, null, description, null, null, false);
    }

    private record ParseContext(String line, int suggestionStart) {
    }

    public static final class MinecraftCandidate
    extends Candidate {
        public MinecraftCandidate(String value, String display, @Nullable String group, @Nullable String description, @Nullable String suffix, @Nullable String key, boolean complete) {
            super(value, display, group, description, suffix, key, complete);
        }
    }
}

