/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicManager;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.services.Permission;
import me.wesley1808.servercore.common.services.platform.PlatformHelper;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class ServerCoreCommand {
    private static final String VALUE = "value";

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder node = class_2170.method_9247((String)"servercore");
        node.then(ServerCoreCommand.reloadConfig());
        node.then(ServerCoreCommand.settings());
        if (Config.get().commands().statusCommandEnabled()) {
            node.then(class_2170.method_9247((String)"status").executes(ctx -> ServerCoreCommand.getStatus((class_2168)ctx.getSource())));
        }
        dispatcher.register(node);
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"sc").redirect((CommandNode)node.build()));
    }

    private static LiteralArgumentBuilder<class_2168> reloadConfig() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(Permission.require("command.config", 2))).executes(ctx -> ServerCoreCommand.reload((class_2168)ctx.getSource()));
    }

    private static LiteralArgumentBuilder<class_2168> settings() {
        LiteralArgumentBuilder settings = (LiteralArgumentBuilder)class_2170.method_9247((String)"settings").requires(Permission.require("command.settings", 2));
        for (DynamicSetting setting : DynamicSetting.values()) {
            settings.then(class_2170.method_9247((String)setting.name().toLowerCase()).then(class_2170.method_9244((String)VALUE, (ArgumentType)IntegerArgumentType.integer((int)setting.getLowerBound(), (int)setting.getUpperBound())).executes(ctx -> ServerCoreCommand.modifyDynamic((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)VALUE), setting))));
        }
        return settings;
    }

    private static int modifyDynamic(class_2168 source, int value, DynamicSetting setting) {
        DynamicManager manager = DynamicManager.getInstance(source.method_9211());
        setting.set(value, manager);
        source.method_9226(() -> Formatter.parse("<c:#secondary>%s <c:#primary>has been set to <c:#secondary>%s".formatted(setting.getFormattedName(), setting.getFormattedValue()), source.method_9211()), false);
        return 1;
    }

    private static int reload(class_2168 source) {
        boolean success = Config.reloadConfigs();
        if (success) {
            source.method_9226(() -> class_2561.method_43470((String)"Config reloaded!").method_27692(class_124.field_1060), false);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"Failed to reload config! Check the logs for more info.").method_27692(class_124.field_1061));
        }
        return 1;
    }

    private static int getStatus(class_2168 source) {
        CommandConfig config = Config.get().commands();
        source.method_9226(() -> {
            class_5250 component = class_2561.method_43473();
            class_5250 title = class_2561.method_43470((String)"ServerCore").method_54663(config.tertiaryValue());
            if (source.method_43737()) {
                Formatter.addLines(component, 14, config.primaryValue(), (class_2561)title);
            } else {
                component.method_10852((class_2561)title);
            }
            component.method_10852(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>Version: <c:#secondary>%s".formatted(PlatformHelper.getVersion()), source.method_9211()));
            for (DynamicSetting setting : DynamicSetting.values()) {
                component.method_10852(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>%s: <c:#secondary>%s".formatted(setting.getFormattedName(), setting.getFormattedValue()), source.method_9211()));
            }
            return component;
        }, false);
        return 1;
    }
}

