/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.config.builder;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonBuilder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JvmStreamsKt;
import org.anti_ad.mc.common.Savable;
import org.anti_ad.mc.common.config.IConfigElement;
import org.anti_ad.mc.common.extensions.Java_ioKt;
import org.anti_ad.mc.common.extensions.JsonKt;
import org.anti_ad.mc.common.vanilla.VanillaUtil;
import org.anti_ad.mc.libipn.Log;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u0012\u0004\b\u0016\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lorg/anti_ad/mc/common/config/builder/ConfigSaveLoadManager;", "Lorg/anti_ad/mc/common/Savable;", "Lorg/anti_ad/mc/common/config/IConfigElement;", "config", "", "modId", "fileName", "<init>", "(Lorg/anti_ad/mc/common/config/IConfigElement;Ljava/lang/String;Ljava/lang/String;)V", "", "save", "()V", "load", "Lorg/anti_ad/mc/common/config/IConfigElement;", "Ljava/nio/file/Path;", "configFile", "Ljava/nio/file/Path;", "path", "Ljava/lang/String;", "Lkotlinx/serialization/json/Json;", "encoder", "Lkotlinx/serialization/json/Json;", "getEncoder$annotations", "fabric-1.21.3"})
public final class ConfigSaveLoadManager
implements Savable {
    @NotNull
    private final IConfigElement config;
    @NotNull
    private final Path configFile;
    @NotNull
    private final String path;
    @NotNull
    private final Json encoder;

    public ConfigSaveLoadManager(@NotNull IConfigElement config, @NotNull String modId, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)modId, (String)"modId");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.config = config;
        this.configFile = Java_ioKt.div(VanillaUtil.INSTANCE.configDirectory(modId), fileName);
        this.path = Java_ioKt.getLoggingPath(this.configFile);
        this.encoder = kotlinx.serialization.json.JsonKt.Json$default(null, ConfigSaveLoadManager::encoder$lambda$0, (int)1, null);
    }

    private static /* synthetic */ void getEncoder$annotations() {
    }

    @Override
    public void save() {
        try {
            JsonElement el = this.config.toJsonElement();
            SerializationStrategy serializationStrategy = (SerializationStrategy)JsonElement.Companion.serializer();
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(this.configFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            JvmStreamsKt.encodeToStream((Json)this.encoder, (SerializationStrategy)serializationStrategy, (Object)el, (OutputStream)outputStream);
        }
        catch (IOException e) {
            Log.INSTANCE.error("Failed to write config file " + this.path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void load() {
        try {
            if (!Java_ioKt.exists(this.configFile)) {
                return;
            }
            JsonElement j = JsonKt.toJsonElement(PathsKt.readText$default((Path)this.configFile, null, (int)1, null));
            this.config.fromJsonElement(j);
        }
        catch (IOException e) {
            Log.INSTANCE.error("Failed to read config file " + this.path);
        }
        catch (SerializationException e) {
            Log.INSTANCE.error("Failed to parse config file " + this.path + " as JSON");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static final Unit encoder$lambda$0(JsonBuilder $this$Json) {
        Intrinsics.checkNotNullParameter((Object)$this$Json, (String)"$this$Json");
        $this$Json.setPrettyPrintIndent("    ");
        $this$Json.setPrettyPrint(true);
        return Unit.INSTANCE;
    }
}

