/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.common.moreinfo;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\f\b\u0086\b\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001(B=\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\r*\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0019\u0010\fJ\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\fJF\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00022\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001a\u0010\u001e\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0010\u0010 \u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b \u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u0016R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010!\u001a\u0004\b#\u0010\u0016R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010!\u001a\u0004\b$\u0010\u0016R\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010\fR\u0019\u0010\b\u001a\u0004\u0018\u00010\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010%\u001a\u0004\b'\u0010\f\u00a8\u0006)"}, d2={"Lorg/anti_ad/mc/common/moreinfo/SemVer;", "", "", "major", "minor", "patch", "", "preRelease", "buildMetadata", "<init>", "(IIILjava/lang/String;Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "", "isInitialDevelopmentPhase", "()Z", "other", "compareTo", "(Lorg/anti_ad/mc/common/moreinfo/SemVer;)I", "isNumeric", "(Ljava/lang/String;)Z", "component1", "()I", "component2", "component3", "component4", "component5", "copy", "(IIILjava/lang/String;Ljava/lang/String;)Lorg/anti_ad/mc/common/moreinfo/SemVer;", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "I", "getMajor", "getMinor", "getPatch", "Ljava/lang/String;", "getPreRelease", "getBuildMetadata", "Companion", "fabric-1.21.3"})
@SourceDebugExtension(value={"SMAP\nSemVer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SemVer.kt\norg/anti_ad/mc/common/moreinfo/SemVer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class SemVer
implements Comparable<SemVer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final String preRelease;
    @Nullable
    private final String buildMetadata;

    public SemVer(int major, int minor, int patch, @Nullable String preRelease, @Nullable String buildMetadata) {
        CharSequence charSequence;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.buildMetadata = buildMetadata;
        if (!(this.major >= 0)) {
            boolean $i$a$-require-SemVer$62 = false;
            String $i$a$-require-SemVer$62 = "Major version must be a positive number or zero";
            throw new IllegalArgumentException($i$a$-require-SemVer$62.toString());
        }
        if (!(this.minor >= 0)) {
            boolean $i$a$-require-SemVer$72 = false;
            String $i$a$-require-SemVer$72 = "Minor version must be a positive number or zero";
            throw new IllegalArgumentException($i$a$-require-SemVer$72.toString());
        }
        if (!(this.patch >= 0)) {
            boolean $i$a$-require-SemVer$82 = false;
            String $i$a$-require-SemVer$82 = "Patch version must be a positive number or zero";
            throw new IllegalArgumentException($i$a$-require-SemVer$82.toString());
        }
        if (this.preRelease != null && !new Regex("[\\dA-z\\-]+(?:\\.[\\dA-z\\-]+)*").matches(charSequence = (CharSequence)this.preRelease)) {
            boolean $i$a$-require-SemVer$92 = false;
            String $i$a$-require-SemVer$92 = "Pre-release version is not valid";
            throw new IllegalArgumentException($i$a$-require-SemVer$92.toString());
        }
        if (this.buildMetadata != null && !new Regex("[\\dA-z\\-]+(?:\\.[\\dA-z\\-]+)*").matches(charSequence = (CharSequence)this.buildMetadata)) {
            boolean bl = false;
            String string = "Build metadata is not valid";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ SemVer(int n, int n2, int n3, String string, String string2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 0;
        }
        if ((n4 & 2) != 0) {
            n2 = 0;
        }
        if ((n4 & 4) != 0) {
            n3 = 0;
        }
        if ((n4 & 8) != 0) {
            string = null;
        }
        if ((n4 & 0x10) != 0) {
            string2 = null;
        }
        this(n, n2, n3, string, string2);
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getPatch() {
        return this.patch;
    }

    @Nullable
    public final String getPreRelease() {
        return this.preRelease;
    }

    @Nullable
    public final String getBuildMetadata() {
        return this.buildMetadata;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u245.append(this.major + "." + this.minor + "." + this.patch);
        if (this.preRelease != null) {
            $this$toString_u24lambda_u245.append('-');
            $this$toString_u24lambda_u245.append(this.preRelease);
        }
        if (this.buildMetadata != null) {
            $this$toString_u24lambda_u245.append('+');
            $this$toString_u24lambda_u245.append(this.buildMetadata);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final boolean isInitialDevelopmentPhase() {
        return this.major == 0;
    }

    @Override
    public int compareTo(@NotNull SemVer other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.preRelease == null && other.preRelease == null) {
            return 0;
        }
        if (this.preRelease != null && other.preRelease == null) {
            return -1;
        }
        if (this.preRelease == null && other.preRelease != null) {
            return 1;
        }
        String string = this.preRelease;
        if (string == null) {
            string = "";
        }
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string2 = other.preRelease;
        if (string2 == null) {
            string2 = "";
        }
        String[] stringArray2 = new String[]{"."};
        List otherParts = StringsKt.split$default((CharSequence)string2, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        int i = 0;
        int endIndex = Math.min(parts.size(), otherParts.size()) - 1;
        if (i <= endIndex) {
            while (true) {
                String otherPart;
                String part;
                if (!Intrinsics.areEqual((Object)(part = (String)parts.get(i)), (Object)(otherPart = (String)otherParts.get(i)))) {
                    boolean partIsNumeric = this.isNumeric(part);
                    boolean otherPartIsNumeric = this.isNumeric(otherPart);
                    if (partIsNumeric && !otherPartIsNumeric) {
                        return -1;
                    }
                    if (!partIsNumeric && otherPartIsNumeric) {
                        return 1;
                    }
                    if (!partIsNumeric && !otherPartIsNumeric) {
                        if (part.compareTo(otherPart) > 0) {
                            return 1;
                        }
                        if (part.compareTo(otherPart) < 0) {
                            return -1;
                        }
                    } else {
                        try {
                            int partInt = Integer.parseInt(part);
                            int otherPartInt = Integer.parseInt(otherPart);
                            if (partInt > otherPartInt) {
                                return 1;
                            }
                            if (partInt < otherPartInt) {
                                return -1;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            return part.compareTo(otherPart);
                        }
                    }
                }
                if (i == endIndex) break;
                ++i;
            }
        }
        return parts.size() == endIndex + 1 && otherParts.size() > endIndex + 1 ? -1 : (parts.size() > endIndex + 1 && otherParts.size() == endIndex + 1 ? 1 : 0);
    }

    private final boolean isNumeric(String $this$isNumeric) {
        CharSequence charSequence = $this$isNumeric;
        return new Regex("\\d+").matches(charSequence);
    }

    public final int component1() {
        return this.major;
    }

    public final int component2() {
        return this.minor;
    }

    public final int component3() {
        return this.patch;
    }

    @Nullable
    public final String component4() {
        return this.preRelease;
    }

    @Nullable
    public final String component5() {
        return this.buildMetadata;
    }

    @NotNull
    public final SemVer copy(int major, int minor, int patch, @Nullable String preRelease, @Nullable String buildMetadata) {
        return new SemVer(major, minor, patch, preRelease, buildMetadata);
    }

    public static /* synthetic */ SemVer copy$default(SemVer semVer, int n, int n2, int n3, String string, String string2, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = semVer.major;
        }
        if ((n4 & 2) != 0) {
            n2 = semVer.minor;
        }
        if ((n4 & 4) != 0) {
            n3 = semVer.patch;
        }
        if ((n4 & 8) != 0) {
            string = semVer.preRelease;
        }
        if ((n4 & 0x10) != 0) {
            string2 = semVer.buildMetadata;
        }
        return semVer.copy(n, n2, n3, string, string2);
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = result * 31 + Integer.hashCode(this.minor);
        result = result * 31 + Integer.hashCode(this.patch);
        result = result * 31 + (this.preRelease == null ? 0 : this.preRelease.hashCode());
        result = result * 31 + (this.buildMetadata == null ? 0 : this.buildMetadata.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SemVer)) {
            return false;
        }
        SemVer semVer = (SemVer)other;
        if (this.major != semVer.major) {
            return false;
        }
        if (this.minor != semVer.minor) {
            return false;
        }
        if (this.patch != semVer.patch) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.preRelease, (Object)semVer.preRelease)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.buildMetadata, (Object)semVer.buildMetadata);
    }

    public SemVer() {
        this(0, 0, 0, null, null, 31, null);
    }

    @JvmStatic
    @NotNull
    public static final SemVer parse(@NotNull String version) {
        return Companion.parse(version);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/anti_ad/mc/common/moreinfo/SemVer$Companion;", "", "<init>", "()V", "", "version", "Lorg/anti_ad/mc/common/moreinfo/SemVer;", "parse", "(Ljava/lang/String;)Lorg/anti_ad/mc/common/moreinfo/SemVer;", "fabric-1.21.3"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SemVer parse(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Regex pattern = new Regex("(0|[1-9]\\d*)?(?:\\.)?(0|[1-9]\\d*)?(?:\\.)?(0|[1-9]\\d*)?(?:-([\\dA-z\\-]+(?:\\.[\\dA-z\\-]+)*))?(?:\\+([\\dA-z\\-]+(?:\\.[\\dA-z\\-]+)*))?");
            MatchResult matchResult = pattern.matchEntire((CharSequence)version);
            if (matchResult == null) {
                throw new IllegalArgumentException("Invalid version string [" + version + "]");
            }
            MatchResult result = matchResult;
            return new SemVer(((CharSequence)result.getGroupValues().get(1)).length() == 0 ? 0 : Integer.parseInt((String)result.getGroupValues().get(1)), ((CharSequence)result.getGroupValues().get(2)).length() == 0 ? 0 : Integer.parseInt((String)result.getGroupValues().get(2)), ((CharSequence)result.getGroupValues().get(3)).length() == 0 ? 0 : Integer.parseInt((String)result.getGroupValues().get(3)), ((CharSequence)result.getGroupValues().get(4)).length() == 0 ? null : (String)result.getGroupValues().get(4), ((CharSequence)result.getGroupValues().get(5)).length() == 0 ? null : (String)result.getGroupValues().get(5));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

