/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.config.data;

import space.arim.dazzleconf.annote.ConfComments;
import space.arim.dazzleconf.annote.ConfDefault;
import space.arim.dazzleconf.annote.ConfKey;
import space.arim.dazzleconf.annote.IntegerRange;
import space.arim.dazzleconf.annote.NumericRange;
import space.arim.dazzleconf.sorter.AnnotationBasedSorter;

public interface FeatureConfig {
    @AnnotationBasedSorter.Order(value=1)
    @ConfKey(value="prevent-enderpearl-chunkloading")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Reverts enderpearl behavior to pre-1.21.2. The following will change when this setting is enabled:", "\u25ba Enderpearls will no longer load chunks around them.", "\u25ba Enderpearls will load / unload with chunks again instead of with their owner joining / leaving the game.", "Note: Toggling this setting may cause some old enderpearls from before the toggle to be lost."})
    public boolean preventEnderpearlChunkLoading();

    @AnnotationBasedSorter.Order(value=2)
    @ConfKey(value="prevent-moving-into-unloaded-chunks")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Prevents lagspikes caused by players moving into unloaded chunks."})
    public boolean preventMovingIntoUnloadedChunks();

    @AnnotationBasedSorter.Order(value=3)
    @ConfKey(value="autosave-interval-seconds")
    @ConfDefault.DefaultInteger(value=300)
    @IntegerRange(min=5L)
    @ConfComments(value={"The amount of seconds between auto-saves when /save-on is active."})
    public int autosaveIntervalSeconds();

    @AnnotationBasedSorter.Order(value=4)
    @ConfKey(value="xp-merge-fraction")
    @ConfDefault.DefaultInteger(value=40)
    @IntegerRange(min=1L)
    @ConfComments(value={"The fraction that decides the chance of experience orbs being able to merge with each other. (1 = 100%, 40 = 2.5%)", "Note that just like in vanilla, experience orbs will still need to be of the same size to actually merge."})
    public int xpMergeFraction();

    @AnnotationBasedSorter.Order(value=5)
    @ConfKey(value="xp-merge-radius")
    @ConfDefault.DefaultDouble(value=0.5)
    @NumericRange(min=0.5)
    @ConfComments(value={"The radius in blocks that experience orbs will merge at."})
    public double xpMergeRadius();

    @AnnotationBasedSorter.Order(value=6)
    @ConfKey(value="item-merge-radius")
    @ConfDefault.DefaultDouble(value=0.5)
    @NumericRange(min=0.5)
    @ConfComments(value={"The radius in blocks that items will merge at."})
    public double itemMergeRadius();

    @AnnotationBasedSorter.Order(value=7)
    @ConfKey(value="lobotomize-villagers.enabled")
    @ConfDefault.DefaultBoolean(value=false)
    @ConfComments(value={"Makes villagers tick less often if they are stuck in a 1x1 space."})
    public boolean lobotomizeVillagers();

    @AnnotationBasedSorter.Order(value=8)
    @ConfKey(value="lobotomize-villagers.tick-interval")
    @ConfDefault.DefaultInteger(value=20)
    @IntegerRange(min=2L)
    @ConfComments(value={"Decides the interval in between villager ticks when lobotomized."})
    public int lobotomizedTickInterval();
}

