/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.util.mappings;

import net.fabricmc.loader.impl.lib.mappingio.tree.MappingTree;
import net.fabricmc.loader.impl.lib.tinyremapper.IMappingProvider;

public class TinyRemapperMappingsHelper {
    private TinyRemapperMappingsHelper() {
    }

    private static IMappingProvider.Member memberOf(String className, String memberName, String descriptor) {
        return new IMappingProvider.Member(className, memberName, descriptor);
    }

    public static IMappingProvider create(MappingTree mappings, String from, String to) {
        return acceptor -> {
            int fromId = mappings.getNamespaceId(from);
            int toId = mappings.getNamespaceId(to);
            for (MappingTree.ClassMapping classMapping : mappings.getClasses()) {
                String className = classMapping.getName(fromId);
                String dstName = classMapping.getName(toId);
                if (dstName == null) {
                    dstName = className;
                }
                acceptor.acceptClass(className, dstName);
                for (MappingTree.FieldMapping fieldMapping : classMapping.getFields()) {
                    acceptor.acceptField(TinyRemapperMappingsHelper.memberOf(className, fieldMapping.getName(fromId), fieldMapping.getDesc(fromId)), fieldMapping.getName(toId));
                }
                for (MappingTree.MethodMapping methodMapping : classMapping.getMethods()) {
                    IMappingProvider.Member methodIdentifier = TinyRemapperMappingsHelper.memberOf(className, methodMapping.getName(fromId), methodMapping.getDesc(fromId));
                    acceptor.acceptMethod(methodIdentifier, methodMapping.getName(toId));
                }
            }
        };
    }
}

