/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.remap;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.slf4j.Logger;
import xyz.jpenilla.betterfabricconsole.remap.MappingsCache;
import xyz.jpenilla.betterfabricconsole.remap.MappingsDownloader;
import xyz.jpenilla.betterfabricconsole.remap.Remapper;
import xyz.jpenilla.betterfabricconsole.util.ThrowingFunction;

@DefaultQualifier(value=NonNull.class)
public enum RemapMode {
    MOJANG(MappingsCache::createMojangMappingsDownloader, Remapper::mojangMappings),
    YARN(MappingsCache::createYarnMappingsDownloader, Remapper::yarn),
    NONE;

    private static final Logger LOGGER;
    private final @Nullable Function<MappingsCache, MappingsDownloader<?>> downloaderFactory;
    private final @Nullable ThrowingFunction<Object, Remapper, IOException> remapperFactory;

    private <O, D extends MappingsDownloader<O>> RemapMode(Function<MappingsCache, D> downloaderFactory, ThrowingFunction<O, Remapper, IOException> remapperFactory) {
        this.downloaderFactory = downloaderFactory;
        this.remapperFactory = remapperFactory;
    }

    private RemapMode() {
        this.downloaderFactory = null;
        this.remapperFactory = null;
    }

    public @Nullable Remapper createRemapper(MappingsCache mappingsCache) {
        Object mappingsData;
        if (this.downloaderFactory == null || this.remapperFactory == null) {
            return null;
        }
        MappingsDownloader<?> downloader = this.downloaderFactory.apply(mappingsCache);
        try {
            mappingsData = downloader.downloadMappings();
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to download mappings. Will retry on next startup.", (Throwable)ex);
            mappingsCache.moveFailed();
            return null;
        }
        try {
            return this.remapperFactory.apply(mappingsData);
        }
        catch (IOException ex) {
            LOGGER.warn("Failed to read mappings. Will retry on next startup.", (Throwable)ex);
            mappingsCache.moveFailed();
            return null;
        }
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

