/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.console;

import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;

@DefaultQualifier(value=NonNull.class)
public final class DelegatingHighlighter
implements Highlighter {
    private @Nullable Highlighter delegate;

    public AttributedString highlight(LineReader reader, String buffer) {
        if (this.delegate != null) {
            return this.delegate.highlight(reader, buffer);
        }
        AttributedStringBuilder builder = new AttributedStringBuilder();
        builder.append((CharSequence)buffer, AttributedStyle.DEFAULT.foreground(1));
        return builder.toAttributedString();
    }

    public void setErrorPattern(Pattern errorPattern) {
        if (this.delegate != null) {
            this.delegate.setErrorPattern(errorPattern);
        }
    }

    public void setErrorIndex(int errorIndex) {
        if (this.delegate != null) {
            this.delegate.setErrorIndex(errorIndex);
        }
    }

    public void delegateTo(Highlighter highlighter) {
        this.delegate = highlighter;
    }
}

