/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import net.fabricmc.loader.api.MappingResolver;
import net.fabricmc.loader.impl.lib.mappingio.tree.MappingTree;

class MappingResolverImpl
implements MappingResolver {
    private final MappingTree mappings;
    private final String targetNamespace;
    private final int targetNamespaceId;

    MappingResolverImpl(MappingTree mappings, String targetNamespace) {
        this.mappings = mappings;
        this.targetNamespace = targetNamespace;
        this.targetNamespaceId = mappings.getNamespaceId(targetNamespace);
    }

    @Override
    public Collection<String> getNamespaces() {
        HashSet<String> namespaces = new HashSet<String>(this.mappings.getDstNamespaces());
        namespaces.add(this.mappings.getSrcNamespace());
        return Collections.unmodifiableSet(namespaces);
    }

    @Override
    public String getCurrentRuntimeNamespace() {
        return this.targetNamespace;
    }

    @Override
    public String mapClassName(String namespace, String className) {
        if (className.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + className);
        }
        return MappingResolverImpl.replaceSlashesWithDots(this.mappings.mapClassName(MappingResolverImpl.replaceDotsWithSlashes(className), this.mappings.getNamespaceId(namespace), this.targetNamespaceId));
    }

    @Override
    public String unmapClassName(String namespace, String className) {
        if (className.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + className);
        }
        return MappingResolverImpl.replaceSlashesWithDots(this.mappings.mapClassName(MappingResolverImpl.replaceDotsWithSlashes(className), this.targetNamespaceId, this.mappings.getNamespaceId(namespace)));
    }

    @Override
    public String mapFieldName(String namespace, String owner, String name, String descriptor) {
        if (owner.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + owner);
        }
        MappingTree.FieldMapping field = this.mappings.getField(MappingResolverImpl.replaceDotsWithSlashes(owner), name, descriptor, this.mappings.getNamespaceId(namespace));
        return field == null ? name : field.getName(this.targetNamespaceId);
    }

    @Override
    public String mapMethodName(String namespace, String owner, String name, String descriptor) {
        if (owner.indexOf(47) >= 0) {
            throw new IllegalArgumentException("Class names must be provided in dot format: " + owner);
        }
        MappingTree.MethodMapping method = this.mappings.getMethod(MappingResolverImpl.replaceDotsWithSlashes(owner), name, descriptor, this.mappings.getNamespaceId(namespace));
        return method == null ? name : method.getName(this.targetNamespaceId);
    }

    private static String replaceSlashesWithDots(String cname) {
        return cname.replace('/', '.');
    }

    private static String replaceDotsWithSlashes(String cname) {
        return cname.replace('.', '/');
    }
}

