"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var moves_exports = {};
__export(moves_exports, {
  Moves: () => Moves
});
module.exports = __toCommonJS(moves_exports);
const Moves = {
  aeroblast: {
    inherit: true,
    isNonstandard: null
  },
  allyswitch: {
    inherit: true,
    stallingMove: false,
    onPrepareHit() {
    },
    onHit(pokemon) {
      const newPosition = pokemon.position === 0 ? pokemon.side.active.length - 1 : 0;
      if (!pokemon.side.active[newPosition])
        return false;
      if (pokemon.side.active[newPosition].fainted)
        return false;
      this.swapPosition(pokemon, newPosition, "[from] move: Ally Switch");
    }
  },
  anchorshot: {
    inherit: true,
    isNonstandard: null
  },
  aromatherapy: {
    inherit: true,
    isNonstandard: null
  },
  assist: {
    inherit: true,
    flags: { failencore: 1, nosleeptalk: 1, noassist: 1, failcopycat: 1, failinstruct: 1 }
  },
  aurawheel: {
    inherit: true,
    isNonstandard: null
  },
  auroraveil: {
    inherit: true,
    onTry() {
      return this.field.isWeather("hail");
    }
  },
  autotomize: {
    inherit: true,
    isNonstandard: null
  },
  belch: {
    inherit: true,
    flags: { protect: 1, failmefirst: 1, nosleeptalk: 1, noassist: 1, failcopycat: 1, failinstruct: 1 }
  },
  blizzard: {
    inherit: true,
    onModifyMove(move) {
      if (this.field.isWeather("hail"))
        move.accuracy = true;
    }
  },
  blueflare: {
    inherit: true,
    isNonstandard: null
  },
  boltbeak: {
    inherit: true,
    isNonstandard: null
  },
  boltstrike: {
    inherit: true,
    isNonstandard: null
  },
  bonemerang: {
    inherit: true,
    isNonstandard: null
  },
  celebrate: {
    inherit: true,
    flags: { nosleeptalk: 1, noassist: 1, failcopycat: 1, failinstruct: 1 }
  },
  charge: {
    inherit: true,
    condition: {
      onStart(pokemon, source, effect) {
        this.add("-start", pokemon, "Charge");
      },
      onRestart(pokemon, source, effect) {
        this.add("-start", pokemon, "Charge");
      },
      onBasePowerPriority: 9,
      onBasePower(basePower, attacker, defender, move) {
        if (move.type === "Electric") {
          this.debug("charge boost");
          return this.chainModify(2);
        }
      },
      onMoveAborted(pokemon, target, move) {
        if (move.id !== "charge") {
          pokemon.removeVolatile("charge");
        }
      },
      onAfterMove(pokemon, target, move) {
        if (move.id !== "charge") {
          pokemon.removeVolatile("charge");
        }
      },
      onEnd(pokemon) {
        this.add("-end", pokemon, "Charge", "[silent]");
      }
    }
  },
  chatter: {
    inherit: true,
    flags: {
      protect: 1,
      mirror: 1,
      sound: 1,
      distance: 1,
      bypasssub: 1,
      noassist: 1,
      failcopycat: 1,
      failinstruct: 1,
      failmefirst: 1,
      nosleeptalk: 1,
      failmimic: 1
    }
  },
  clangingscales: {
    inherit: true,
    isNonstandard: null
  },
  clangoroussoul: {
    inherit: true,
    isNonstandard: null
  },
  conversion: {
    inherit: true,
    isNonstandard: null
  },
  conversion2: {
    inherit: true,
    isNonstandard: null
  },
  copycat: {
    inherit: true,
    flags: { failencore: 1, nosleeptalk: 1, noassist: 1, failcopycat: 1, failinstruct: 1 }
  },
  coreenforcer: {
    inherit: true,
    isNonstandard: null
  },
  cosmicpower: {
    inherit: true,
    isNonstandard: null
  },
  craftyshield: {
    inherit: true,
    isNonstandard: null
  },
  crushgrip: {
    inherit: true,
    isNonstandard: null
  },
  curse: {
    inherit: true,
    onModifyMove(move, source, target) {
      if (!source.hasType("Ghost")) {
        move.target = move.nonGhostTarget;
      }
    },
    target: "randomNormal"
  },
  decorate: {
    inherit: true,
    isNonstandard: null
  },
  doomdesire: {
    inherit: true,
    isNonstandard: null
  },
  doubleironbash: {
    inherit: true,
    isNonstandard: null
  },
  dragonhammer: {
    inherit: true,
    isNonstandard: null
  },
  dualchop: {
    inherit: true,
    isNonstandard: null
  },
  electrify: {
    inherit: true,
    isNonstandard: null
  },
  eternabeam: {
    inherit: true,
    flags: { recharge: 1, protect: 1, mirror: 1, failinstruct: 1 },
    isNonstandard: null
  },
  fishiousrend: {
    inherit: true,
    isNonstandard: null
  },
  floralhealing: {
    inherit: true,
    isNonstandard: null
  },
  flowershield: {
    inherit: true,
    isNonstandard: null
  },
  fly: {
    inherit: true,
    onTryMove(attacker, defender, move) {
      if (attacker.removeVolatile(move.id)) {
        return;
      }
      this.add("-prepare", attacker, move.name);
      if (!this.runEvent("ChargeMove", attacker, defender, move)) {
        return;
      }
      if (this.gameType === "doubles" || this.gameType === "multi") {
        const animatedTarget = attacker.getMoveTargets(this.dex.getActiveMove("aerialace"), defender).targets[0];
        if (animatedTarget) {
          this.hint(`${move.name}'s animation targeted ${animatedTarget.name}`);
        }
      }
      attacker.addVolatile("twoturnmove", defender);
      return null;
    }
  },
  forestscurse: {
    inherit: true,
    isNonstandard: null
  },
  freezeshock: {
    inherit: true,
    isNonstandard: null
  },
  fusionbolt: {
    inherit: true,
    isNonstandard: null
  },
  fusionflare: {
    inherit: true,
    isNonstandard: null
  },
  futuresight: {
    inherit: true,
    flags: { futuremove: 1 }
  },
  geargrind: {
    inherit: true,
    isNonstandard: null
  },
  gearup: {
    inherit: true,
    isNonstandard: null
  },
  geomancy: {
    inherit: true,
    isNonstandard: null
  },
  glaciallance: {
    inherit: true,
    basePower: 130
  },
  glaciate: {
    inherit: true,
    isNonstandard: null
  },
  grassyglide: {
    inherit: true,
    basePower: 70
  },
  grudge: {
    inherit: true,
    isNonstandard: null
  },
  hail: {
    inherit: true,
    isNonstandard: null
  },
  headcharge: {
    inherit: true,
    isNonstandard: null
  },
  healbell: {
    inherit: true,
    isNonstandard: null
  },
  heartswap: {
    inherit: true,
    isNonstandard: "Past"
  },
  holdhands: {
    inherit: true,
    flags: { bypasssub: 1, nosleeptalk: 1, noassist: 1, failcopycat: 1, failinstruct: 1 }
  },
  hyperspacefury: {
    inherit: true,
    isNonstandard: "Past"
  },
  hyperspacehole: {
    inherit: true,
    isNonstandard: "Past"
  },
  iceburn: {
    inherit: true,
    isNonstandard: null
  },
  icehammer: {
    inherit: true,
    isNonstandard: "Past"
  },
  judgment: {
    inherit: true,
    isNonstandard: "Past"
  },
  kinesis: {
    inherit: true,
    isNonstandard: null
  },
  kingsshield: {
    inherit: true,
    isNonstandard: null
  },
  landswrath: {
    inherit: true,
    isNonstandard: null
  },
  laserfocus: {
    inherit: true,
    isNonstandard: null
  },
  leaftornado: {
    inherit: true,
    isNonstandard: null
  },
  lovelykiss: {
    inherit: true,
    isNonstandard: null
  },
  lusterpurge: {
    inherit: true,
    isNonstandard: null
  },
  magiccoat: {
    inherit: true,
    isNonstandard: null
  },
  matblock: {
    inherit: true,
    isNonstandard: null
  },
  maxairstream: {
    inherit: true,
    isNonstandard: null
  },
  maxdarkness: {
    inherit: true,
    isNonstandard: null
  },
  maxflare: {
    inherit: true,
    isNonstandard: null
  },
  maxflutterby: {
    inherit: true,
    isNonstandard: null
  },
  maxgeyser: {
    inherit: true,
    isNonstandard: null
  },
  maxguard: {
    inherit: true,
    isNonstandard: null
  },
  maxhailstorm: {
    inherit: true,
    isNonstandard: null
  },
  maxknuckle: {
    inherit: true,
    isNonstandard: null
  },
  maxlightning: {
    inherit: true,
    isNonstandard: null
  },
  maxmindstorm: {
    inherit: true,
    isNonstandard: null
  },
  maxooze: {
    inherit: true,
    isNonstandard: null
  },
  maxovergrowth: {
    inherit: true,
    isNonstandard: null
  },
  maxphantasm: {
    inherit: true,
    isNonstandard: null
  },
  maxquake: {
    inherit: true,
    isNonstandard: null
  },
  maxrockfall: {
    inherit: true,
    isNonstandard: null
  },
  maxstarfall: {
    inherit: true,
    isNonstandard: null
  },
  maxsteelspike: {
    inherit: true,
    isNonstandard: null
  },
  maxstrike: {
    inherit: true,
    isNonstandard: null
  },
  maxwyrmwind: {
    inherit: true,
    isNonstandard: null
  },
  mefirst: {
    inherit: true,
    flags: {
      protect: 1,
      bypasssub: 1,
      failencore: 1,
      failmefirst: 1,
      nosleeptalk: 1,
      noassist: 1,
      failcopycat: 1,
      failinstruct: 1
    }
  },
  meteorassault: {
    inherit: true,
    isNonstandard: null
  },
  metronome: {
    inherit: true,
    flags: { failencore: 1, nosleeptalk: 1, noassist: 1, failcopycat: 1, failinstruct: 1 }
  },
  milkdrink: {
    inherit: true,
    pp: 10
  },
  mindblown: {
    inherit: true,
    isNonstandard: null
  },
  mindreader: {
    inherit: true,
    isNonstandard: null
  },
  mirrorcoat: {
    inherit: true,
    flags: { protect: 1, failmefirst: 1, noassist: 1, failcopycat: 1 }
  },
  mirrormove: {
    inherit: true,
    flags: { failencore: 1, nosleeptalk: 1, noassist: 1, failcopycat: 1, failinstruct: 1 }
  },
  mistball: {
    inherit: true,
    isNonstandard: null
  },
  moongeistbeam: {
    inherit: true,
    isNonstandard: null
  },
  multiattack: {
    inherit: true,
    isNonstandard: null
  },
  naturepower: {
    inherit: true,
    isNonstandard: null,
    flags: { failencore: 1, nosleeptalk: 1, noassist: 1, failcopycat: 1, failinstruct: 1 }
  },
  naturesmadness: {
    inherit: true,
    isNonstandard: null
  },
  oblivionwing: {
    inherit: true,
    isNonstandard: null
  },
  obstruct: {
    inherit: true,
    isNonstandard: null
  },
  octazooka: {
    inherit: true,
    isNonstandard: null
  },
  octolock: {
    inherit: true,
    isNonstandard: null
  },
  photongeyser: {
    inherit: true,
    isNonstandard: null
  },
  plasmafists: {
    inherit: true,
    isNonstandard: null
  },
  poweruppunch: {
    inherit: true,
    isNonstandard: null
  },
  prismaticlaser: {
    inherit: true,
    isNonstandard: null
  },
  psychoshift: {
    inherit: true,
    isNonstandard: null
  },
  purify: {
    inherit: true,
    isNonstandard: null
  },
  recover: {
    inherit: true,
    pp: 10
  },
  relicsong: {
    inherit: true,
    isNonstandard: "Past"
  },
  rest: {
    inherit: true,
    pp: 10
  },
  revelationdance: {
    inherit: true,
    isNonstandard: "Past"
  },
  revenge: {
    inherit: true,
    isNonstandard: null
  },
  rockwrecker: {
    inherit: true,
    isNonstandard: null
  },
  roost: {
    inherit: true,
    pp: 10
  },
  sacredfire: {
    inherit: true,
    isNonstandard: null
  },
  searingshot: {
    inherit: true,
    isNonstandard: null
  },
  secretsword: {
    inherit: true,
    isNonstandard: null
  },
  shadowbone: {
    inherit: true,
    isNonstandard: null
  },
  shelltrap: {
    inherit: true,
    isNonstandard: null
  },
  shoreup: {
    inherit: true,
    pp: 10
  },
  simplebeam: {
    inherit: true,
    isNonstandard: null
  },
  skullbash: {
    inherit: true,
    isNonstandard: null
  },
  slackoff: {
    inherit: true,
    pp: 10
  },
  sleeptalk: {
    inherit: true,
    flags: { failencore: 1, nosleeptalk: 1, noassist: 1, failcopycat: 1, failinstruct: 1 }
  },
  snaptrap: {
    inherit: true,
    isNonstandard: null
  },
  softboiled: {
    inherit: true,
    pp: 10
  },
  sparklingaria: {
    inherit: true,
    isNonstandard: null
  },
  spectralthief: {
    inherit: true,
    isNonstandard: null
  },
  stormthrow: {
    inherit: true,
    isNonstandard: null
  },
  strangesteam: {
    inherit: true,
    isNonstandard: null
  },
  submission: {
    inherit: true,
    isNonstandard: null
  },
  sunsteelstrike: {
    inherit: true,
    isNonstandard: null
  },
  technoblast: {
    inherit: true,
    isNonstandard: null
  },
  thousandarrows: {
    inherit: true,
    isNonstandard: null
  },
  thousandwaves: {
    inherit: true,
    isNonstandard: null
  },
  topsyturvy: {
    inherit: true,
    isNonstandard: null
  },
  trickortreat: {
    inherit: true,
    isNonstandard: null
  },
  triplekick: {
    inherit: true,
    isNonstandard: null
  },
  venomdrench: {
    inherit: true,
    isNonstandard: null
  },
  vitalthrow: {
    inherit: true,
    isNonstandard: null
  },
  wickedblow: {
    inherit: true,
    basePower: 80
  }
};
//# sourceMappingURL=moves.js.map
