"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var formats_exports = {};
__export(formats_exports, {
  Formats: () => Formats
});
module.exports = __toCommonJS(formats_exports);
const Formats = [
  // S/V Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "S/V Singles"
  },
  {
    name: "[Gen 9] Random Battle",
    desc: `Randomized teams of Pok&eacute;mon with sets that are generated to be competitively viable.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712619/">Random Battle Suggestions</a>`
    ],
    mod: "gen9",
    team: "random",
    ruleset: ["PotD", "Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 9] Unrated Random Battle",
    mod: "gen9",
    team: "random",
    challengeShow: false,
    rated: false,
    ruleset: ["Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 9] Random Battle (Blitz)",
    mod: "gen9",
    team: "random",
    ruleset: ["[Gen 9] Random Battle", "Blitz"]
  },
  {
    name: "[Gen 9] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710915/">SV OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712513/">SV OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712493/">SV OU Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard"],
    banlist: ["Uber", "AG", "Arena Trap", "Moody", "Sand Veil", "Shadow Tag", "Snow Cloak", "King's Rock", "Baton Pass"]
  },
  {
    name: "[Gen 9] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710870/">Ubers Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712978/">Ubers Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard"],
    banlist: ["AG", "Moody", "King's Rock", "Baton Pass"]
  },
  {
    name: "[Gen 9] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3713709/">UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3716435/">UU Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] OU"],
    banlist: ["OU", "UUBL"]
  },
  {
    name: "[Gen 9] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3713711/">RU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3717138/">RU Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] UU"],
    banlist: ["UU", "RUBL", "Light Clay"]
  },
  {
    name: "[Gen 9] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715408/">NU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715712/">NU Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] RU"],
    banlist: ["RU", "NUBL"]
  },
  {
    name: "[Gen 9] PU",
    mod: "gen9",
    ruleset: ["[Gen 9] NU"],
    banlist: ["NU", "PUBL"]
  },
  {
    name: "[Gen 9] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710868/">Little Cup Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712989/">Little Cup Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712664/">Little Cup Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Little Cup", "Standard"],
    banlist: ["Dunsparce", "Flittle", "Gastly", "Girafarig", "Meditite", "Misdreavus", "Murkrow", "Rufflet", "Scyther", "Sneasel", "Moody", "Baton Pass"]
  },
  {
    name: "[Gen 9] Monotype",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710724/">Monotype Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715794/">Monotype Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714063/">Monotype Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard", "Evasion Abilities Clause", "Same Type Clause", "Terastal Clause"],
    banlist: ["Annihilape", "Chi-Yu", "Houndstone", "Iron Bundle", "Koraidon", "Miraidon", "Palafin", "Moody", "Shadow Tag", "Booster Energy", "Damp Rock", "Focus Band", "King's Rock", "Quick Claw", "Acupressure", "Baton Pass"]
  },
  {
    name: "[Gen 9] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710864/">1v1 Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712375/">1v1 Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Standard",
      "Terastal Clause",
      "Sleep Moves Clause",
      "Accuracy Moves Clause",
      "!Sleep Clause Mod"
    ],
    banlist: [
      "Chi-Yu",
      "Cinderace",
      "Dragonite",
      "Flutter Mane",
      "Gholdengo",
      "Greninja",
      "Koraidon",
      "Mimikyu",
      "Miraidon",
      "Scream Tail",
      "Moody",
      "Focus Band",
      "Focus Sash",
      "King's Rock",
      "Quick Claw",
      "Acupressure",
      "Perish Song"
    ]
  },
  {
    name: "[Gen 9] Anything Goes",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710911/">AG Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714177/">AG Viability Rankings</a>`
    ],
    mod: "gen9",
    ruleset: ["Min Source Gen = 9", "Obtainable", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause"]
  },
  {
    name: "[Gen 9] CAP",
    mod: "gen9",
    ruleset: ["[Gen 9] OU", "+CAP"],
    banlist: ["Walking Wake", "Crucibellite"]
  },
  {
    name: "[Gen 9] Free-For-All",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711724/">Free-For-All</a>`
    ],
    mod: "gen9",
    gameType: "freeforall",
    rated: false,
    tournamentShow: false,
    ruleset: ["Standard", "!Evasion Items Clause"],
    banlist: [
      "Annihilape",
      "Chi-Yu",
      "Flutter Mane",
      "Houndstone",
      "Koraidon",
      "Iron Bundle",
      "Miraidon",
      "Palafin",
      "Moody",
      "Shadow Tag",
      "Toxic Debris",
      "Acupressure",
      "Aromatic Mist",
      "Baton Pass",
      "Court Change",
      "Final Gambit",
      "Flatter",
      "Follow Me",
      "Heal Pulse",
      "Poison Fang",
      "Rage Powder",
      "Spicy Extract",
      "Swagger",
      "Toxic",
      "Toxic Spikes"
    ]
  },
  {
    name: "[Gen 9] Battle Stadium Singles Series 2",
    mod: "gen9",
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Paldea Pokedex", "Min Source Gen = 9", "VGC Timer"],
    banlist: ["Sub-Legendary"]
  },
  {
    name: "[Gen 9] Battle Stadium Singles Regulation C",
    mod: "gen9",
    searchShow: false,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Paldea Pokedex", "Min Source Gen = 9", "VGC Timer"]
  },
  {
    name: "[Gen 9] Custom Game",
    mod: "gen9",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // S/V Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "S/V Doubles"
  },
  {
    name: "[Gen 9] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710876/">Doubles OU Sample Teams</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Standard Doubles"],
    banlist: ["DUber", "Shadow Tag"]
  },
  {
    name: "[Gen 9] Doubles Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712864/">Doubles Ubers</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Standard Doubles", "!Gravity Sleep Clause"]
  },
  {
    name: "[Gen 9] Doubles UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712825/">Doubles UU</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["[Gen 9] Doubles OU"],
    banlist: ["DOU", "DBL"]
  },
  {
    name: "[Gen 9] Doubles LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710957/">Doubles LC</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Standard Doubles", "Little Cup", "Sleep Clause Mod"],
    banlist: ["Dunsparce", "Murkrow", "Scyther", "Sneasel"]
  },
  {
    name: "[Gen 9] 2v2 Doubles",
    desc: `Double battle where you bring four Pok&eacute;mon to Team Preview and choose only two.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710849/">2v2 Doubles</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: [
      "Picked Team Size = 2",
      "Max Team Size = 4",
      "Standard Doubles",
      "Accuracy Moves Clause",
      "Terastal Clause",
      "Sleep Clause Mod",
      "Evasion Items Clause"
    ],
    banlist: ["Koraidon", "Miraidon", "Commander", "Focus Sash", "King's Rock", "Ally Switch", "Final Gambit", "Moody", "Perish Song", "Swagger"]
  },
  {
    name: "[Gen 9] VGC 2023 Series 2",
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Paldea Pokedex", "Min Source Gen = 9", "VGC Timer", "Open Team Sheets"],
    banlist: ["Sub-Legendary"]
  },
  {
    name: "[Gen 9] VGC 2023 Regulation C",
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Paldea Pokedex", "Min Source Gen = 9", "VGC Timer", "Open Team Sheets"]
  },
  {
    name: "[Gen 9] Doubles Custom Game",
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // National Dex
  ///////////////////////////////////////////////////////////////////
  {
    section: "National Dex"
  },
  {
    name: "[Gen 9] National Dex",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710848/">National Dex Metagame Discussion</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard NatDex", "OHKO Clause", "Evasion Clause", "Species Clause", "Sleep Clause Mod"],
    banlist: ["ND Uber", "ND AG", "Arena Trap", "Moody", "Power Construct", "Shadow Tag", "King's Rock", "Quick Claw", "Razor Fang", "Assist", "Baton Pass"]
  },
  {
    name: "[Gen 9] National Dex Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712168/">National Dex Ubers Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712170/">National Dex Ubers Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712169/">National Dex Ubers Viability List</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard NatDex", "OHKO Clause", "Evasion Moves Clause", "Evasion Items Clause", "Species Clause", "Sleep Clause Mod", "Mega Rayquaza Clause"],
    banlist: ["ND AG", "Assist", "Baton Pass"]
  },
  {
    name: "[Gen 9] National Dex UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711752/">National Dex UU Metagame Discussion</a>`
    ],
    mod: "gen9",
    ruleset: ["[Gen 9] National Dex"],
    banlist: ["ND OU", "ND UUBL"]
  },
  {
    name: "[Gen 9] National Dex RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3713801/">National Dex RU Metagame Discussion</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["[Gen 9] National Dex UU"],
    banlist: ["ND UU", "ND RUBL", "Drizzle", "Light Clay"]
  },
  {
    name: "[Gen 9] National Dex Monotype",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710738/">National Dex Monotype Metagame Discussion</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard NatDex", "Same Type Clause", "Terastal Clause", "Species Clause", "OHKO Clause", "Evasion Clause", "Sleep Clause Mod"],
    banlist: [
      "Annihilape",
      "Arceus",
      "Blastoise-Mega",
      "Blaziken-Mega",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Chi-Yu",
      "Chien-Pao",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Dracovish",
      "Dragapult",
      "Eternatus",
      "Flutter Mane",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Houndstone",
      "Iron Bundle",
      "Kangaskhan-Mega",
      "Kartana",
      "Koraidon",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lucario-Mega",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Mawile-Mega",
      "Medicham-Mega",
      "Metagross-Mega",
      "Mewtwo",
      "Miraidon",
      "Naganadel",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palafin",
      "Palkia",
      "Pheromosa",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Solgaleo",
      "Urshifu-Base",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Zygarde-Base",
      "Zygarde-Complete",
      "Moody",
      "Shadow Tag",
      "Power Construct",
      "Booster Energy",
      "Damp Rock",
      "Focus Band",
      "Icy Rock",
      "King's Rock",
      "Leppa Berry",
      "Quick Claw",
      "Smooth Rock",
      "Terrain Extender",
      "Acupressure",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 9] National Dex AG",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672423/">National Dex AG</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard NatDex"]
  },
  {
    name: "[Gen 9] National Dex BH",
    desc: `Balanced Hackmons with National Dex elements mixed in.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711099/">National Dex BH</a>`
    ],
    mod: "gen9",
    ruleset: ["-Nonexistent", "Standard NatDex", "Forme Clause", "Sleep Moves Clause", "Ability Clause = 2", "OHKO Clause", "Evasion Moves Clause", "Dynamax Clause", "CFZ Clause", "!Obtainable"],
    banlist: [
      "Cramorant-Gorging",
      "Calyrex-Shadow",
      "Darmanitan-Galar-Zen",
      "Eternatus-Eternamax",
      "Groudon-Primal",
      "Rayquaza-Mega",
      "Shedinja",
      "Zygarde-Complete",
      "Arena Trap",
      "Contrary",
      "Gorilla Tactics",
      "Huge Power",
      "Illusion",
      "Innards Out",
      "Magnet Pull",
      "Moody",
      "Neutralizing Gas",
      "Parental Bond",
      "Pure Power",
      "Shadow Tag",
      "Stakeout",
      "Water Bubble",
      "Wonder Guard",
      "Gengarite",
      "Belly Drum",
      "Bolt Beak",
      "Chatter",
      "Double Iron Bash",
      "Electrify",
      "Last Respects",
      "Octolock",
      "Rage Fist",
      "Revival Blessing",
      "Shed Tail",
      "Shell Smash",
      "Comatose + Sleep Talk",
      "Imprison + Transform"
    ],
    restricted: ["Arceus"],
    onValidateTeam(team, format) {
      const restrictedPokemonCount = /* @__PURE__ */ new Map();
      for (const set of team) {
        const species = this.dex.species.get(set.species);
        if (!this.ruleTable.isRestrictedSpecies(species))
          continue;
        restrictedPokemonCount.set(species.baseSpecies, (restrictedPokemonCount.get(species.baseSpecies) || 0) + 1);
      }
      for (const [baseSpecies, count] of restrictedPokemonCount) {
        if (count > 1) {
          return [
            `You are limited to one ${baseSpecies} forme.`,
            `(You have ${count} ${baseSpecies} forme${count === 1 ? "" : "s"}.)`
          ];
        }
      }
    }
  },
  // Pet Mods
  ///////////////////////////////////////////////////////////////////
  {
    section: "Pet Mods"
  },
  {
    name: "[Gen 8] JolteMons Random Battle",
    desc: `Pok&eacute;mon, items, abilities, and moves are redesigned for OU, and new items, abilities, and moves are added, all without changing base stats.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3694234/">JolteMons</a>`,
      `&bullet; <a href="https://docs.google.com/spreadsheets/d/149ZlQY0bJIAqfWB_233Dvbpqs3pVSHYpIoAQQkwquls/edit?usp=sharing">Spreadsheet</a>`
    ],
    mod: "gen8joltemons",
    team: "random",
    ruleset: ["Dynamax Clause", "Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod", "Mega Data Mod", "Z-Move Clause"]
  },
  {
    name: "[Gen 6] NEXT OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3476151/">Gen-NEXT Development Thread</a>`
    ],
    mod: "gennext",
    searchShow: false,
    challengeShow: false,
    ruleset: ["Obtainable", "Standard NEXT", "Team Preview"],
    banlist: ["Uber"]
  },
  // Draft League
  ///////////////////////////////////////////////////////////////////
  {
    section: "Draft",
    column: 1
  },
  {
    name: "[Gen 9] Paldea Dex Draft",
    mod: "gen9",
    searchShow: false,
    ruleset: ["Draft", "Min Source Gen = 9"]
  },
  {
    name: "[Gen 9] 6v6 Doubles Draft",
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Draft", "!Sleep Clause Mod", "!Evasion Moves Clause", "Min Source Gen = 9"]
  },
  {
    name: "[Gen 9] 4v4 Doubles Draft",
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Draft", "Item Clause", "!Sleep Clause Mod", "!OHKO Clause", "!Evasion Moves Clause", "Adjust Level = 50", "Picked Team Size = 4", "Min Source Gen = 9"]
  },
  {
    name: "[Gen 9] NatDex Draft",
    mod: "gen9",
    searchShow: false,
    ruleset: ["Draft", "+Unobtainable", "+Past"]
  },
  {
    name: "[Gen 9] NatDex 6v6 Doubles Draft",
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["[Gen 9] 6v6 Doubles Draft", "+Unobtainable", "+Past", "!! Min Source Gen = 3"]
  },
  {
    name: "[Gen 9] NatDex 4v4 Doubles Draft",
    mod: "gen9",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["[Gen 9] 4v4 Doubles Draft", "+Unobtainable", "+Past", "!! Min Source Gen = 3"]
  },
  {
    name: "[Gen 9] NatDex LC Draft",
    mod: "gen9",
    searchShow: false,
    ruleset: ["[Gen 9] NatDex Draft", "Double Item Clause", "Little Cup"],
    banlist: ["Dragon Rage", "Sonic Boom"]
  },
  {
    name: "[Gen 8] Galar Dex Draft",
    mod: "gen8",
    searchShow: false,
    ruleset: ["Draft"]
  },
  {
    name: "[Gen 8] NatDex Draft",
    mod: "gen8",
    searchShow: false,
    ruleset: ["Draft", "+Past"]
  },
  {
    name: "[Gen 8] NatDex 4v4 Doubles Draft",
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Draft", "Item Clause", "!Sleep Clause Mod", "!OHKO Clause", "!Evasion Moves Clause", "Adjust Level = 50", "Picked Team Size = 4", "+Past"]
  },
  {
    name: "[Gen 7] Draft",
    mod: "gen7",
    searchShow: false,
    ruleset: ["Draft", "+LGPE"]
  },
  {
    name: "[Gen 6] Draft",
    mod: "gen6",
    searchShow: false,
    ruleset: ["Draft", "Moody Clause", "Swagger Clause"],
    banlist: ["Soul Dew"]
  },
  // OM of the Month
  ///////////////////////////////////////////////////////////////////
  {
    section: "OM of the Month",
    column: 2
  },
  {
    name: "[Gen 9] Fortemons",
    desc: `Put an attacking move in the item slot to have all of a Pok&eacute;mon's attacks inherit its properties.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3713983/">Fortemons</a>`
    ],
    mod: "gen9",
    // searchShow: false,
    ruleset: ["Standard OMs", "Sleep Clause Mod", "Min Source Gen = 9"],
    banlist: [
      "Annihilape",
      "Azumarill",
      "Chi-Yu",
      "Chien-Pao",
      "Cloyster",
      "Dragonite",
      "Espathra",
      "Flutter Mane",
      "Great Tusk",
      "Houndstone",
      "Iron Bundle",
      "Koraidon",
      "Miraidon",
      "Palafin",
      "Arena Trap",
      "Moody",
      "Serene Grace",
      "Shadow Tag",
      "Covert Cloak",
      "Beat Up",
      "Baton Pass"
    ],
    restricted: ["Dynamic Punch", "Flail", "Fury Cutter", "Grass Knot", "Heavy Slam", "Inferno", "Low Kick", "Nuzzle", "Power Trip", "Reversal", "Spit Up", "Stored Power", "Zap Cannon"],
    validateSet(set, teamHas) {
      const item = set.item;
      const species = this.dex.species.get(set.species);
      const move = this.dex.moves.get(item);
      if (!move.exists || move.id === "metronome" || move.category === "Status") {
        return this.validateSet(set, teamHas);
      }
      set.item = "";
      const problems = this.validateSet(set, teamHas) || [];
      set.item = item;
      if (this.checkCanLearn(move, species, this.allSources(species), set)) {
        problems.push(`${species.name} can't learn ${move.name}.`);
      }
      if (set.moves.map(this.toID).includes(move.id)) {
        problems.push(`Moves in the item slot can't be in the moveslots as well.`);
      }
      const accuracyLoweringMove = move.secondaries?.some((secondary) => secondary.boosts?.accuracy && secondary.boosts?.accuracy < 0);
      const flinchMove = move.secondaries?.some((secondary) => secondary.volatileStatus === "flinch");
      const freezeMove = move.secondaries?.some((secondary) => secondary.status === "frz") || move.id === "triattack";
      if (this.ruleTable.isRestricted(`move:${move.id}`) || (accuracyLoweringMove || move.ohko || move.multihit || move.id === "beatup" || move.flags["charge"] || move.priority > 0 || move.damageCallback || flinchMove || freezeMove || move.selfSwitch) && !this.ruleTable.has(`+move:${move.id}`)) {
        problems.push(`The move ${move.name} can't be used as an item.`);
      }
      return problems.length ? problems : null;
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        const move = this.dex.getActiveMove(pokemon.set.item);
        if (move.exists && move.category !== "Status") {
          pokemon.m.forte = move;
          pokemon.item = "mail";
        }
      }
    },
    onModifyMovePriority: 1,
    onModifyMove(move, pokemon, target) {
      const forte = pokemon.m.forte;
      if (move.category !== "Status" && forte) {
        move.flags = { ...move.flags, ...forte.flags };
        if (forte.self) {
          if (forte.self.onHit && move.self?.onHit) {
            for (const i in forte.self) {
              if (i.startsWith("onHit"))
                continue;
              move.self[i] = forte.self[i];
            }
          } else {
            move.self = { ...move.self || {}, ...forte.self };
          }
        }
        if (forte.selfBoost?.boosts) {
          if (!move.selfBoost?.boosts)
            move.selfBoost = { boosts: {} };
          let boostid;
          for (boostid in forte.selfBoost.boosts) {
            if (!move.selfBoost.boosts[boostid])
              move.selfBoost.boosts[boostid] = 0;
            move.selfBoost.boosts[boostid] += forte.selfBoost.boosts[boostid];
          }
        }
        if (forte.secondaries) {
          move.secondaries = [...move.secondaries || [], ...forte.secondaries];
        }
        move.critRatio = (move.critRatio || 1) + (forte.critRatio || 1) - 1;
        const VALID_PROPERTIES = [
          "alwaysHit",
          "basePowerCallback",
          "breaksProtect",
          "drain",
          "forceSTAB",
          "forceSwitch",
          "hasCrashDamage",
          "hasSheerForce",
          "ignoreAbility",
          "ignoreAccuracy",
          "ignoreDefensive",
          "ignoreEvasion",
          "ignoreImmunity",
          "mindBlownRecoil",
          "noDamageVariance",
          "ohko",
          "overrideDefensivePokemon",
          "overrideDefensiveStat",
          "overrideOffensivePokemon",
          "overrideOffensiveStat",
          "pseudoWeather",
          "recoil",
          "selfdestruct",
          "selfSwitch",
          "sleepUsable",
          "smartTarget",
          "stealsBoosts",
          "thawsTarget",
          "volatileStatus",
          "willCrit"
        ];
        for (const property of VALID_PROPERTIES) {
          if (forte[property]) {
            move[property] = forte[property];
          }
        }
        if (forte.onEffectiveness) {
          move.onEffectiveness = function(typeMod, t, type, m) {
            return forte.onEffectiveness.call(this, typeMod, t, type, m);
          };
        }
        forte.onModifyMove?.call(this, move, pokemon, target);
      }
    },
    onModifyPriority(priority, source, target, move) {
      const forte = source?.m.forte;
      if (move.category !== "Status" && forte) {
        if (source.hasAbility("Triage") && forte.flags["heal"]) {
          return priority + (move.flags["heal"] ? 0 : 3);
        }
        return priority + forte.priority;
      }
    },
    onModifyTypePriority: 1,
    onModifyType(move, pokemon, target) {
      const forte = pokemon.m.forte;
      if (move.category !== "Status" && forte) {
        this.singleEvent("ModifyType", forte, null, pokemon, target, move, move);
      }
    },
    onHitPriority: 1,
    onHit(target, source, move) {
      const forte = source.m.forte;
      if (move?.category !== "Status" && forte) {
        this.singleEvent("Hit", forte, {}, target, source, move);
        if (forte.self)
          this.singleEvent("Hit", forte.self, {}, source, source, move);
        this.singleEvent("AfterHit", forte, {}, target, source, move);
      }
    },
    onAfterSubDamage(damage, target, source, move) {
      const forte = source.m.forte;
      if (move?.category !== "Status" && forte) {
        this.singleEvent("AfterSubDamage", forte, null, target, source, move);
      }
    },
    onModifySecondaries(secondaries, target, source, move) {
      if (secondaries.some((s) => !!s.self))
        move.selfDropped = false;
    },
    onAfterMoveSecondaryPriority: 1,
    onAfterMoveSecondarySelf(source, target, move) {
      const forte = source.m.forte;
      if (move?.category !== "Status" && forte) {
        this.singleEvent("AfterMoveSecondarySelf", forte, null, source, target, move);
      }
    },
    onBasePowerPriority: 1,
    onBasePower(basePower, source, target, move) {
      const forte = source.m.forte;
      if (move.category !== "Status" && forte?.onBasePower) {
        forte.onBasePower.call(this, basePower, source, target, move);
      }
    },
    pokemon: {
      getItem() {
        const move = this.battle.dex.moves.get(this.m.forte);
        if (!move.exists)
          return Object.getPrototypeOf(this).getItem.call(this);
        return {
          ...this.battle.dex.items.get("mail"),
          name: move.name,
          id: move.id,
          ignoreKlutz: true,
          onTakeItem: false
        };
      }
    }
  },
  {
    name: "[Gen 9] Tera Donation",
    desc: `The first Pok&eacute;mon sent out immediately terastallizes. The other Pok&eacute;mon in the party inherit that Tera Type as an additional type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3715801/">Tera Donation</a>`
    ],
    mod: "gen9",
    // searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves CLause", "Tera Type Preview", "Min Source Gen = 9"],
    banlist: [
      "Annihilape",
      "Chi-Yu",
      "Chien-Pao",
      "Cyclizar",
      "Espathra",
      "Flutter Mane",
      "Houndstone",
      "Iron Bundle",
      "Koraidon",
      "Miraidon",
      "Palafin",
      "Arena Trap",
      "Moody",
      "Shadow Tag",
      "Booster Energy",
      "Heat Rock",
      "King's Rock",
      "Baton Pass"
    ],
    onSwitchIn(pokemon) {
      if (this.turn === 0) {
        this.actions.terastallize(pokemon);
        const teraType = pokemon.teraType;
        for (const poke of pokemon.side.pokemon) {
          poke.m.thirdType = teraType;
        }
      }
      if (!pokemon.terastallized) {
        this.add("-start", pokemon, "typechange", (pokemon.illusion || pokemon).getTypes(true).join("/"), "[silent]");
      }
    },
    onModifyMove(move, pokemon, target) {
      if (move.id === "terablast") {
        const teraType = pokemon.m.thirdType;
        if (teraType && pokemon.getStat("atk", false, true) > pokemon.getStat("spa", false, true)) {
          move.category = "Physical";
        }
      }
    },
    onModifyType(move, pokemon, target) {
      if (move.id === "terablast") {
        const teraType = pokemon.m.thirdType;
        if (teraType) {
          move.type = teraType;
        }
      }
    },
    pokemon: {
      getTypes(excludeAdded, preterastallized) {
        if (!preterastallized && this.terastallized)
          return [this.terastallized];
        const types = this.battle.runEvent("Type", this, null, null, this.types);
        if (!excludeAdded && this.addedType)
          return types.concat(this.addedType);
        const addTeraType = this.m.thirdType;
        if (types.length) {
          if (addTeraType)
            return Array.from(/* @__PURE__ */ new Set([...types, addTeraType]));
          return types;
        }
        return [this.battle.gen >= 5 ? "Normal" : "???"];
      }
    }
  },
  // Other Metagames
  ///////////////////////////////////////////////////////////////////
  {
    section: "Other Metagames",
    column: 2
  },
  {
    name: "[Gen 9] Almost Any Ability",
    desc: `Pok&eacute;mon have access to almost any ability.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710568/">Almost Any Ability</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710571/">AAA Resources</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "!Obtainable Abilities", "Ability Clause = 1", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Annihilape",
      "Baxcalibur",
      "Dragapult",
      "Flutter Mane",
      "Great Tusk",
      "Gholdengo",
      "Houndstone",
      "Iron Bundle",
      "Iron Hands",
      "Iron Valiant",
      "Koraidon",
      "Miraidon",
      "Noivern",
      "Slaking",
      "Walking Wake",
      "Arena Trap",
      "Comatose",
      "Contrary",
      "Fur Coat",
      "Good as Gold",
      "Gorilla Tactics",
      "Huge Power",
      "Ice Scales",
      "Illusion",
      "Imposter",
      "Innards Out",
      "Magic Bounce",
      "Magnet Pull",
      "Moody",
      "Neutralizing Gas",
      "Orichalcum Pulse",
      "Parental Bond",
      "Poison Heal",
      "Pure Power",
      "Shadow Tag",
      "Simple",
      "Speed Boost",
      "Stakeout",
      "Unburden",
      "Water Bubble",
      "Wonder Guard",
      "King's Rock",
      "Baton Pass",
      "Revival Blessing",
      "Shed Tail"
    ]
  },
  {
    name: "[Gen 9] Balanced Hackmons",
    desc: `Anything directly hackable onto a set (EVs, IVs, forme, ability, item, and move) and is usable in local battles is allowed.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710859/">Balanced Hackmons</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712766/">BH Resources</a>`
    ],
    mod: "gen9",
    ruleset: ["-Nonexistent", "OHKO Clause", "Evasion Clause", "Species Clause", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Sleep Moves Clause", "Endless Battle Clause"],
    banlist: [
      "Calyrex-Shadow",
      "Zacian-Crowned",
      "Arena Trap",
      "Contrary",
      "Huge Power",
      "Illusion",
      "Innards Out",
      "Magnet Pull",
      "Moody",
      "Neutralizing Gas",
      "Parental Bond",
      "Poison Heal",
      "Pure Power",
      "Shadow Tag",
      "Stakeout",
      "Water Bubble",
      "Wonder Guard",
      "Comatose + Sleep Talk",
      "Belly Drum",
      "Last Respects",
      "Quiver Dance",
      "Rage Fist",
      "Revival Blessing",
      "Shed Tail",
      "Shell Smash"
    ]
  },
  {
    name: "[Gen 9] Mix and Mega",
    desc: `Mega evolve any Pok&eacute;mon with any mega stone, or transform them with Primal orbs, Origin orbs, and Rusted items with no limit. Mega and Primal boosts based on form changes from gen 7.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710921/">Mix and Mega</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3716385/">Mix and Mega Resources</a>`
    ],
    mod: "mixandmega",
    ruleset: ["Standard OMs", "Evasion Items Clause", "Evasion Abilities Clause", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: ["Koraidon", "Miraidon", "Beedrillite", "Blazikenite", "Gengarite", "Kangaskhanite", "Mawilite", "Medichamite", "Moody", "Rusted Sword", "Shadow Tag", "Baton Pass", "Shed Tail"],
    restricted: ["Dragapult", "Flutter Mane", "Gengar", "Iron Bundle", "Kilowattrel", "Sandy Shocks", "Slaking"],
    onValidateTeam(team) {
      const itemTable = /* @__PURE__ */ new Set();
      for (const set of team) {
        const item = this.dex.items.get(set.item);
        if (!item.megaStone && !item.onPrimal && !item.forcedForme?.endsWith("Origin") && !item.name.startsWith("Rusted"))
          continue;
        const natdex = this.ruleTable.has("standardnatdex");
        if (natdex && item.id !== "ultranecroziumz")
          continue;
        const species = this.dex.species.get(set.species);
        if (species.isNonstandard && !this.ruleTable.has(`+pokemontag:${this.toID(species.isNonstandard)}`)) {
          return [`${species.baseSpecies} does not exist in gen 9.`];
        }
        if (item.itemUser?.includes(species.name) && !item.megaStone && !item.onPrimal || natdex && species.name.startsWith("Necrozma-") && item.id === "ultranecroziumz") {
          continue;
        }
        if (this.ruleTable.isRestrictedSpecies(species) || this.toID(set.ability) === "powerconstruct") {
          return [`${species.name} is not allowed to hold ${item.name}.`];
        }
        if (itemTable.has(item.id)) {
          return [
            `You are limited to one of each mega stone/orb/rusted item/sinnoh item.`,
            `(You have more than one ${item.name})`
          ];
        }
        itemTable.add(item.id);
      }
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        pokemon.m.originalSpecies = pokemon.baseSpecies.name;
      }
    },
    onSwitchIn(pokemon) {
      const originalFormeSecies = this.dex.species.get(pokemon.species.originalSpecies);
      if (originalFormeSecies.exists && pokemon.m.originalSpecies !== originalFormeSecies.baseSpecies) {
        this.add("-start", pokemon, originalFormeSecies.requiredItem || originalFormeSecies.requiredMove, "[silent]");
        const oSpecies = this.dex.species.get(pokemon.m.originalSpecies);
        if (oSpecies.types.length !== pokemon.species.types.length || oSpecies.types[1] !== pokemon.species.types[1]) {
          this.add("-start", pokemon, "typechange", pokemon.species.types.join("/"), "[silent]");
        }
      }
    },
    onSwitchOut(pokemon) {
      const oMegaSpecies = this.dex.species.get(pokemon.species.originalSpecies);
      if (oMegaSpecies.exists && pokemon.m.originalSpecies !== oMegaSpecies.baseSpecies) {
        this.add("-end", pokemon, oMegaSpecies.requiredItem || oMegaSpecies.requiredMove, "[silent]");
      }
    }
  },
  {
    name: "[Gen 9] Godly Gift",
    desc: `Each Pok&eacute;mon receives one base stat from a God (AG/Uber Pok&eacute;mon) depending on its position in the team. If there is no Uber Pok&eacute;mon, it uses the Pok&eacute;mon in the first slot.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710734/">Godly Gift</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3718065/">Godly Gift Resources</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Godly Gift Mod", "Min Source Gen = 9"],
    banlist: [
      "Blissey",
      "Chansey",
      "Great Tusk",
      "Iron Hands",
      "Iron Valiant",
      "Walking Wake",
      "Arena Trap",
      "Huge Power",
      "Moody",
      "Pure Power",
      "Shadow Tag",
      "Swift Swim",
      "Booster Energy",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 9] STABmons",
    desc: `Pok&eacute;mon can use any move of their typing, in addition to the moves they can normally learn.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710577/">STABmons</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714664/">STABmons Resources</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "STABmons Move Legality", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: [
      "Chi-Yu",
      "Chien-Pao",
      "Cloyster",
      "Dragapult",
      "Dragonite",
      "Flutter Mane",
      "Garchomp",
      "Iron Bundle",
      "Komala",
      "Koraidon",
      "Miraidon",
      "Walking Wake",
      "Zoroark-Hisui",
      "Arena Trap",
      "Moody",
      "Shadow Tag",
      "Booster Energy",
      "King's Rock",
      "Baton Pass"
    ],
    restricted: [
      "Acupressure",
      "Astral Barrage",
      "Belly Drum",
      "Dire Claw",
      "Extreme Speed",
      "Fillet Away",
      "Last Respects",
      "No Retreat",
      "Revival Blessing",
      "Shed Tail",
      "Shell Smash",
      "Shift Gear",
      "V-create",
      "Victory Dance",
      "Wicked Blow"
    ]
  },
  {
    name: "[Gen 9] NFE",
    desc: `Only Pok&eacute;mon that can evolve are allowed.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710638/">NFE</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712567/">NFE Resources</a>`
    ],
    mod: "gen9",
    ruleset: ["Standard OMs", "Not Fully Evolved", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Bisharp",
      "Chansey",
      "Haunter",
      "Magneton",
      "Primeape",
      "Scyther",
      "Arena Trap",
      "Shadow Tag",
      "Baton Pass",
      // Shouldn't be legal
      "Stantler",
      "Ursaring"
    ]
  },
  // Challengeable OMs
  ///////////////////////////////////////////////////////////////////
  {
    section: "Challengeable OMs",
    column: 2
  },
  {
    name: "[Gen 9] Cross Evolution",
    desc: `Give a Pok&eacute;mon a Pok&eacute;mon name of the next evolution stage as a nickname to inherit stat changes, typing, abilities, and moves from the next stage Pok&eacute;mon.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710953/">Cross Evolution</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Ability Clause = 2", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: ["Scyther", "Sneasel", "Ursaring", "Arena Trap", "Huge Power", "Pure Power", "Shadow Tag", "Speed Boost", "Moody", "King's Rock", "Baton Pass", "Revival Blessing"],
    restricted: ["Gallade", "Gholdengo"],
    onValidateTeam(team) {
      const names = /* @__PURE__ */ new Set();
      for (const set of team) {
        const name = set.name;
        if (names.has(this.dex.toID(name))) {
          return [
            `Your Pok\xE9mon must have different nicknames.`,
            `(You have more than one Pok\xE9mon named '${name}')`
          ];
        }
        names.add(this.dex.toID(name));
      }
      if (!names.size) {
        return [
          `${this.format.name} works using nicknames; your team has 0 nicknamed Pok\xE9mon.`,
          `(If this was intentional, add a nickname to one Pok\xE9mon that isn't the name of a Pok\xE9mon species.)`
        ];
      }
    },
    checkCanLearn(move, species, lsetData, set) {
      if (!set.sp?.exists || !set.crossSpecies?.exists) {
        return this.checkCanLearn(move, species, lsetData, set);
      }
      const problem = this.checkCanLearn(move, set.sp);
      if (!problem)
        return null;
      if (this.checkCanLearn(move, set.crossSpecies))
        return problem;
      return null;
    },
    validateSet(set, teamHas) {
      const crossSpecies = this.dex.species.get(set.name);
      let problems = this.dex.formats.get("Obtainable Misc").onChangeSet?.call(this, set, this.format) || null;
      if (Array.isArray(problems) && problems.length)
        return problems;
      const crossNonstandard = !this.ruleTable.has("standardnatdex") && crossSpecies.isNonstandard === "Past" || crossSpecies.isNonstandard === "Future";
      const crossIsCap = !this.ruleTable.has("+pokemontag:cap") && crossSpecies.isNonstandard === "CAP";
      if (!crossSpecies.exists || crossNonstandard || crossIsCap)
        return this.validateSet(set, teamHas);
      const species = this.dex.species.get(set.species);
      const check = this.checkSpecies(set, species, species, {});
      if (check)
        return [check];
      const nonstandard = !this.ruleTable.has("standardnatdex") && species.isNonstandard === "Past";
      const isCap = !this.ruleTable.has("+pokemontag:cap") && species.isNonstandard === "CAP";
      if (!species.exists || nonstandard || isCap || species === crossSpecies)
        return this.validateSet(set, teamHas);
      if (!species.nfe)
        return [`${species.name} cannot cross evolve because it doesn't evolve.`];
      const crossIsUnreleased = crossSpecies.tier === "Unreleased" && crossSpecies.isNonstandard === "Unobtainable" && !this.ruleTable.has("+unobtainable");
      if (crossSpecies.battleOnly || crossIsUnreleased || !crossSpecies.prevo) {
        return [`${species.name} cannot cross evolve into ${crossSpecies.name} because it isn't an evolution.`];
      }
      if (this.ruleTable.isRestrictedSpecies(crossSpecies)) {
        return [`${species.name} cannot cross evolve into ${crossSpecies.name} because it is banned.`];
      }
      const crossPrevoSpecies = this.dex.species.get(crossSpecies.prevo);
      if (!crossPrevoSpecies.prevo !== !species.prevo) {
        return [
          `${species.name} cannot cross evolve into ${crossSpecies.name} because they are not consecutive evolution stages.`
        ];
      }
      const item = this.dex.items.get(set.item);
      if (item.itemUser?.length) {
        if (!item.itemUser.includes(crossSpecies.name) || crossSpecies.name !== species.name) {
          return [`${species.name} cannot use ${item.name} because it is cross evolved into ${crossSpecies.name}.`];
        }
      }
      const ability = this.dex.abilities.get(set.ability);
      if (!this.ruleTable.isRestricted(`ability:${ability.id}`) || Object.values(species.abilities).includes(ability.name)) {
        set.species = crossSpecies.name;
      }
      set.sp = species;
      set.crossSpecies = crossSpecies;
      problems = this.validateSet(set, teamHas);
      set.name = crossSpecies.name;
      set.species = species.name;
      return problems;
    },
    onModifySpecies(species, target, source, effect) {
      if (!target)
        return;
      if (effect && ["imposter", "transform"].includes(effect.id))
        return;
      if (target.set.name === target.set.species)
        return;
      const crossSpecies = this.dex.species.get(target.set.name);
      if (!crossSpecies.exists)
        return;
      if (species.battleOnly || !species.nfe)
        return;
      const crossIsUnreleased = crossSpecies.tier === "Unreleased" && crossSpecies.isNonstandard === "Unobtainable" && !this.ruleTable.has("+unobtainable");
      if (crossSpecies.battleOnly || crossIsUnreleased || !crossSpecies.prevo)
        return;
      const crossPrevoSpecies = this.dex.species.get(crossSpecies.prevo);
      if (!crossPrevoSpecies.prevo !== !species.prevo)
        return;
      const mixedSpecies = this.dex.deepClone(species);
      mixedSpecies.weightkg = Math.max(0.1, +(species.weightkg + crossSpecies.weightkg - crossPrevoSpecies.weightkg)).toFixed(1);
      mixedSpecies.nfe = false;
      mixedSpecies.evos = [];
      mixedSpecies.eggGroups = crossSpecies.eggGroups;
      mixedSpecies.abilities = crossSpecies.abilities;
      mixedSpecies.bst = 0;
      let i;
      for (i in species.baseStats) {
        const statChange = crossSpecies.baseStats[i] - crossPrevoSpecies.baseStats[i];
        mixedSpecies.baseStats[i] = this.clampIntRange(species.baseStats[i] + statChange, 1, 255);
        mixedSpecies.bst += mixedSpecies.baseStats[i];
      }
      if (crossSpecies.types[0] !== crossPrevoSpecies.types[0])
        mixedSpecies.types[0] = crossSpecies.types[0];
      if (crossSpecies.types[1] !== crossPrevoSpecies.types[1]) {
        mixedSpecies.types[1] = crossSpecies.types[1] || crossSpecies.types[0];
      }
      if (mixedSpecies.types[0] === mixedSpecies.types[1])
        mixedSpecies.types = [mixedSpecies.types[0]];
      return mixedSpecies;
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        pokemon.baseSpecies = pokemon.species;
      }
    }
  },
  {
    name: "[Gen 9] Full Potential",
    desc: `Pok&eacute;mon's moves hit off of their highest stat.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711127/">Full Potential</a>`
    ],
    mod: "fullpotential",
    searchShow: false,
    ruleset: ["Standard OMs", "Evasion Abilities Clause", "Evasion Items Clause", "Sleep Moves Clause", "Terastal Clause", "Min Source Gen = 9"],
    banlist: [
      "Chien-Pao",
      "Cyclizar",
      "Dragapult",
      "Espathra",
      "Flutter Mane",
      "Iron Bundle",
      "Koraidon",
      "Miraidon",
      "Scream Tail",
      "Arena Trap",
      "Chlorophyll",
      "Drought",
      "Moody",
      "Sand Rush",
      "Shadow Tag",
      "Slush Rush",
      "Swift Swim",
      "Unburden",
      "Booster Energy",
      "Choice Scarf",
      "Heat Rock",
      "King's Rock",
      "Baton Pass",
      "Tailwind"
    ]
  },
  {
    name: "[Gen 9] Inheritance",
    desc: `Pok&eacute;mon may use the ability and moves of another, as long as they forfeit their own learnset.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712296/">Inheritance</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Ability Clause = 2", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: ["Koraidon", "Miraidon", "Slaking", "Arena Trap", "Huge Power", "Imposter", "Pure Power", "Shadow Tag", "King's Rock", "Baton Pass", "Last Respects", "Shed Tail", "Shell Smash"],
    getEvoFamily(speciesid) {
      let species = Dex.species.get(speciesid);
      while (species.prevo) {
        species = Dex.species.get(species.prevo);
      }
      return species.id;
    },
    validateSet(set, teamHas) {
      const unreleased = (pokemon) => pokemon.tier === "Unreleased" && pokemon.isNonstandard === "Unobtainable";
      if (!teamHas.abilityMap) {
        teamHas.abilityMap = /* @__PURE__ */ Object.create(null);
        for (const pokemon of Dex.species.all()) {
          if (pokemon.isNonstandard || unreleased(pokemon) && !this.ruleTable.has("+unobtainable"))
            continue;
          if (pokemon.requiredAbility || pokemon.requiredItem || pokemon.requiredMove)
            continue;
          if (this.ruleTable.isBannedSpecies(pokemon))
            continue;
          for (const key of Object.values(pokemon.abilities)) {
            const abilityId = this.dex.toID(key);
            if (abilityId in teamHas.abilityMap) {
              teamHas.abilityMap[abilityId][pokemon.evos ? "push" : "unshift"](pokemon.id);
            } else {
              teamHas.abilityMap[abilityId] = [pokemon.id];
            }
          }
        }
      }
      const problem = this.validateForme(set);
      if (problem.length)
        return problem;
      const species = this.dex.species.get(set.species);
      if (!species.exists || species.num < 1)
        return [`The Pok\xE9mon "${set.species}" does not exist.`];
      if (species.isNonstandard || unreleased(species) && !this.ruleTable.has("+unobtainable")) {
        return [`${species.name} is not obtainable in Generation ${this.dex.gen}.`];
      }
      const name = set.name;
      if (this.ruleTable.isBannedSpecies(species)) {
        return this.validateSet(set, teamHas);
      }
      const ability = this.dex.abilities.get(set.ability);
      if (!ability.exists || ability.isNonstandard)
        return [`${name} needs to have a valid ability.`];
      const pokemonWithAbility = teamHas.abilityMap[ability.id];
      if (!pokemonWithAbility)
        return [`${ability.name} is not available on a legal Pok\xE9mon.`];
      this.format.debug = true;
      if (!teamHas.abilitySources)
        teamHas.abilitySources = /* @__PURE__ */ Object.create(null);
      const validSources = teamHas.abilitySources[this.dex.toID(set.species)] = [];
      let canonicalSource = "";
      for (const donor of pokemonWithAbility) {
        const donorSpecies = this.dex.species.get(donor);
        let format = this.format;
        if (!format.getEvoFamily)
          format = this.dex.formats.get("gen9inheritance");
        const evoFamily = format.getEvoFamily(donorSpecies.id);
        if (validSources.includes(evoFamily))
          continue;
        set.species = donorSpecies.name;
        set.name = donorSpecies.baseSpecies;
        const problems = this.validateSet(set, teamHas) || [];
        if (!problems.length) {
          validSources.push(evoFamily);
          canonicalSource = donorSpecies.name;
        }
        if (validSources.length > 1)
          break;
      }
      this.format.debug = false;
      set.name = name;
      set.species = species.name;
      if (!validSources.length) {
        if (pokemonWithAbility.length > 1)
          return [`${name}'s set is illegal.`];
        return [`${name} has an illegal set with an ability from ${this.dex.species.get(pokemonWithAbility[0]).name}.`];
      }
      set.ability = `${set.ability}0${canonicalSource}`;
      return null;
    },
    onValidateTeam(team, f, teamHas) {
      if (this.ruleTable.has("abilityclause")) {
        const abilityTable = /* @__PURE__ */ new Map();
        const base = {
          airlock: "cloudnine",
          armortail: "queenlymajesty",
          battlearmor: "shellarmor",
          clearbody: "whitesmoke",
          dazzling: "queenlymajesty",
          emergencyexit: "wimpout",
          filter: "solidrock",
          gooey: "tanglinghair",
          insomnia: "vitalspirit",
          ironbarbs: "roughskin",
          libero: "protean",
          minus: "plus",
          moxie: "chillingneigh",
          powerofalchemy: "receiver",
          propellertail: "stalwart",
          teravolt: "moldbreaker",
          turboblaze: "moldbreaker"
        };
        const num = parseInt(this.ruleTable.valueRules.get("abilityclause"));
        for (const set of team) {
          let ability = this.toID(set.ability.split("0")[0]);
          if (!ability)
            continue;
          if (ability in base)
            ability = base[ability];
          if ((abilityTable.get(ability) || 0) >= num) {
            return [
              `You are limited to ${num} of each ability by ${num} Ability Clause.`,
              `(You have more than ${num} ${this.dex.abilities.get(ability).name} variants)`
            ];
          }
          abilityTable.set(ability, (abilityTable.get(ability) || 0) + 1);
        }
      }
      const evoFamilyLists = [];
      for (const set of team) {
        const abilitySources = teamHas.abilitySources?.[this.dex.toID(set.species)];
        if (!abilitySources)
          continue;
        let format = this.format;
        if (!format.getEvoFamily)
          format = this.dex.formats.get("gen9inheritance");
        evoFamilyLists.push(abilitySources.map(format.getEvoFamily));
      }
      const requiredFamilies = /* @__PURE__ */ Object.create(null);
      for (const evoFamilies of evoFamilyLists) {
        if (evoFamilies.length !== 1)
          continue;
        const [familyId] = evoFamilies;
        if (!(familyId in requiredFamilies)) {
          requiredFamilies[familyId] = 1;
        } else {
          requiredFamilies[familyId]++;
        }
        if (requiredFamilies[familyId] > 1) {
          return [
            `You are limited to up to one inheritance from each evolution family by the Donor Clause.`,
            `(You inherit more than once from ${this.dex.species.get(familyId).name}).`
          ];
        }
      }
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        if (pokemon.baseAbility.includes("0")) {
          const donor = pokemon.baseAbility.split("0")[1];
          pokemon.m.donor = this.toID(donor);
          pokemon.baseAbility = this.toID(pokemon.baseAbility.split("0")[0]);
          pokemon.ability = pokemon.baseAbility;
        }
      }
    },
    onSwitchIn(pokemon) {
      if (!pokemon.m.donor)
        return;
      const donorTemplate = this.dex.species.get(pokemon.m.donor);
      if (!donorTemplate.exists)
        return;
      this.add("-start", pokemon, donorTemplate.name, "[silent]");
    }
  },
  {
    name: "[Gen 9] Partners in Crime",
    desc: `Doubles-based metagame where both active ally Pok&eacute;mon share abilities and moves.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3710997/">Partners in Crime</a>`
    ],
    mod: "partnersincrime",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Doubles"],
    banlist: ["Annihilape", "Chi-Yu", "Flutter Mane", "Koraidon", "Miraidon", "Dancer", "Huge Power", "Moody", "Pure Power", "Shadow Tag", "Ally Switch", "Revival Blessing", "Swagger"],
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        pokemon.m.trackPP = /* @__PURE__ */ new Map();
      }
    },
    onBeforeSwitchIn(pokemon) {
      pokemon.m.curMoves = this.dex.deepClone(pokemon.moves);
      let ngas = false;
      for (const poke of this.getAllActive()) {
        if (this.toID(poke.ability) === "neutralizinggas") {
          ngas = true;
          break;
        }
      }
      const BAD_ABILITIES = ["trace", "imposter", "neutralizinggas", "illusion", "wanderingspirit"];
      const ally = pokemon.side.active.find((mon) => mon && mon !== pokemon && !mon.fainted);
      if (ally && ally.ability !== pokemon.ability) {
        if (!pokemon.m.innate && !BAD_ABILITIES.includes(this.toID(ally.ability))) {
          pokemon.m.innate = "ability:" + ally.ability;
          if (!ngas || ally.getAbility().isPermanent || pokemon.hasItem("Ability Shield")) {
            pokemon.volatiles[pokemon.m.innate] = { id: pokemon.m.innate, target: pokemon };
            pokemon.m.startVolatile = true;
          }
        }
        if (!ally.m.innate && !BAD_ABILITIES.includes(this.toID(pokemon.ability))) {
          ally.m.innate = "ability:" + pokemon.ability;
          if (!ngas || pokemon.getAbility().isPermanent || ally.hasItem("Ability Shield")) {
            ally.volatiles[ally.m.innate] = { id: ally.m.innate, target: ally };
            ally.m.startVolatile = true;
          }
        }
      }
    },
    // Starting innate abilities in scripts#actions
    onSwitchOut(pokemon) {
      if (pokemon.m.innate) {
        pokemon.removeVolatile(pokemon.m.innate);
        delete pokemon.m.innate;
      }
      const ally = pokemon.side.active.find((mon) => mon && mon !== pokemon && !mon.fainted);
      if (ally && ally.m.innate) {
        ally.removeVolatile(ally.m.innate);
        delete ally.m.innate;
      }
    },
    onFaint(pokemon) {
      if (pokemon.m.innate) {
        pokemon.removeVolatile(pokemon.m.innate);
        delete pokemon.m.innate;
      }
      const ally = pokemon.side.active.find((mon) => mon && mon !== pokemon && !mon.fainted);
      if (ally && ally.m.innate) {
        ally.removeVolatile(ally.m.innate);
        delete ally.m.innate;
      }
    }
  },
  {
    name: "[Gen 9] Pokebilities",
    desc: `Pok&eacute;mon have all of their released abilities simultaneously.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3679692/">Pok&eacute;bilities</a>`
    ],
    mod: "pokebilities",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Clause Mod"],
    banlist: ["Chi-Yu", "Flutter Mane", "Houndstone", "Iron Bundle", "Koraidon", "Miraidon", "Palafin", "Arena Trap", "Moody", "Shadow Tag", "King's Rock", "Baton Pass"],
    onValidateSet(set) {
      const species = this.dex.species.get(set.species);
      const unSeenAbilities = Object.keys(species.abilities).filter((key) => key !== "S" && (key !== "H" || !species.unreleasedHidden)).map((key) => species.abilities[key]).filter((ability) => ability !== set.ability);
      if (unSeenAbilities.length && this.toID(set.ability) !== this.toID(species.abilities["S"])) {
        for (const abilityName of unSeenAbilities) {
          const banReason = this.ruleTable.check("ability:" + this.toID(abilityName));
          if (banReason) {
            return [`${set.name}'s ability ${abilityName} is ${banReason}.`];
          }
        }
      }
    },
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        if (pokemon.ability === this.toID(pokemon.species.abilities["S"])) {
          continue;
        }
        pokemon.m.innates = Object.keys(pokemon.species.abilities).filter((key) => key !== "S" && (key !== "H" || !pokemon.species.unreleasedHidden)).map((key) => this.toID(pokemon.species.abilities[key])).filter((ability) => ability !== pokemon.ability);
      }
    },
    onBeforeSwitchIn(pokemon) {
      const neededBeforeSwitchInIDs = [
        "clearbody",
        "competitive",
        "contrary",
        "defiant",
        "fullmetalbody",
        "hypercutter",
        "innerfocus",
        "mirrorarmor",
        "oblivious",
        "owntempo",
        "rattled",
        "scrappy",
        "simple",
        "whitesmoke"
      ];
      if (pokemon.m.innates) {
        for (const innate of pokemon.m.innates) {
          if (!neededBeforeSwitchInIDs.includes(innate))
            continue;
          if (pokemon.hasAbility(innate))
            continue;
          pokemon.addVolatile("ability:" + innate, pokemon);
        }
      }
    },
    onSwitchInPriority: 2,
    onSwitchIn(pokemon) {
      if (pokemon.m.innates) {
        for (const innate of pokemon.m.innates) {
          if (pokemon.hasAbility(innate))
            continue;
          pokemon.addVolatile("ability:" + innate, pokemon);
        }
      }
    },
    onSwitchOut(pokemon) {
      for (const innate of Object.keys(pokemon.volatiles).filter((i) => i.startsWith("ability:"))) {
        pokemon.removeVolatile(innate);
      }
    },
    onFaint(pokemon) {
      for (const innate of Object.keys(pokemon.volatiles).filter((i) => i.startsWith("ability:"))) {
        const innateEffect = this.dex.conditions.get(innate);
        this.singleEvent("End", innateEffect, null, pokemon);
      }
    },
    onAfterMega(pokemon) {
      for (const innate of Object.keys(pokemon.volatiles).filter((i) => i.startsWith("ability:"))) {
        pokemon.removeVolatile(innate);
      }
      pokemon.m.innates = void 0;
    }
  },
  {
    name: "[Gen 9] Pure Hackmons",
    desc: `Anything directly hackable onto a set (EVs, IVs, forme, ability, item, and move) and is usable in local battles is allowed.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3712086/">Pure Hackmons</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["-Nonexistent", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause"]
  },
  {
    name: "[Gen 9] Shared Power",
    desc: `Once a Pok&eacute;mon switches in, its ability is shared with the rest of the team.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3711011/">Shared Power</a>`
    ],
    mod: "sharedpower",
    searchShow: false,
    ruleset: ["Standard OMs", "Evasion Abilities Clause", "Evasion Items Clause", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: [
      "Chien-Pao",
      "Gholdengo",
      "Koraidon",
      "Komala",
      "Miraidon",
      "Ting-Lu",
      "Arena Trap",
      "Armor Tail",
      "Contrary",
      "Dazzling",
      "Drought",
      "Electric Surge",
      "Guts",
      "Huge Power",
      "Imposter",
      "Magic Bounce",
      "Magnet Pull",
      "Mold Breaker",
      "Moody",
      "Poison Heal",
      "Prankster",
      "Pure Power",
      "Purifying Salt",
      "Queenly Majesty",
      "Quick Draw",
      "Quick Feet",
      "Regenerator",
      "Sand Rush",
      "Shadow Tag",
      "Simple",
      "Slush Rush",
      "Speed Boost",
      "Stakeout",
      "Stench",
      "Sturdy",
      "Swift Swim",
      "Tinted Lens",
      "Unaware",
      "Unburden",
      "Starf Berry",
      "King's Rock",
      "Baton Pass"
    ],
    getSharedPower(pokemon) {
      const sharedPower = /* @__PURE__ */ new Set();
      for (const ally of pokemon.side.pokemon) {
        if (ally.previouslySwitchedIn > 0) {
          if (pokemon.battle.dex.currentMod !== "sharedpower" && ["trace", "mirrorarmor"].includes(ally.baseAbility)) {
            sharedPower.add("noability");
            continue;
          }
          sharedPower.add(ally.baseAbility);
        }
      }
      sharedPower.delete(pokemon.baseAbility);
      return sharedPower;
    },
    onBeforeSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedPower)
        format = this.dex.formats.get("gen9sharedpower");
      for (const ability of format.getSharedPower(pokemon)) {
        const effect = "ability:" + ability;
        pokemon.volatiles[effect] = { id: this.toID(effect), target: pokemon };
        if (!pokemon.m.abils)
          pokemon.m.abils = [];
        if (!pokemon.m.abils.includes(effect))
          pokemon.m.abils.push(effect);
      }
    },
    onSwitchInPriority: 2,
    onSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedPower)
        format = this.dex.formats.get("gen9sharedpower");
      for (const ability of format.getSharedPower(pokemon)) {
        if (ability === "noability") {
          this.hint(`Mirror Armor and Trace break in Shared Power formats that don't use Shared Power as a base, so they get removed from non-base users.`);
        }
        const effect = "ability:" + ability;
        delete pokemon.volatiles[effect];
        pokemon.addVolatile(effect);
      }
    }
  },
  {
    name: "[Gen 9] The Card Game",
    desc: `The type chart is simplified based off of the Pok&eacute;mon Trading Card Game.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3716838/">The Card Game</a>`
    ],
    mod: "thecardgame",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Evasion Abilities Clause", "Evasion Items Clause", "Min Source Gen = 9"],
    banlist: ["Annihilape", "Baxcalibur", "Chi-Yu", "Cyclizar", "Dragonite", "Espathra", "Houndstone", "Hydreigon", "Koraidon", "Miraidon", "Noivern", "Palafin", "Walking Wake", "Arena Trap", "Moody", "Shadow Tag", "Baton Pass"],
    onBegin() {
      for (const pokemon of this.getAllPokemon()) {
        pokemon.hpType = pokemon.hpType.replace(/(Ghost|Fairy)/g, "Psychic").replace(/Bug/g, "Grass").replace(/Ice/g, "Water").replace(/(Rock|Ground)/g, "Fighting").replace(/Flying/g, "Normal").replace(/Poison/g, "Dark");
        pokemon.teraType = pokemon.teraType.replace(/(Ghost|Fairy)/g, "Psychic").replace(/Bug/g, "Grass").replace(/Ice/g, "Water").replace(/(Rock|Ground)/g, "Fighting").replace(/Flying/g, "Normal").replace(/Poison/g, "Dark");
      }
    },
    onSwitchIn(pokemon) {
      this.add("-start", pokemon, "typechange", (pokemon.illusion || pokemon).getTypes(true).join("/"), "[silent]");
      pokemon.apparentType = pokemon.getTypes(true).join("/");
    },
    onAfterMega(pokemon) {
      this.add("-start", pokemon, "typechange", (pokemon.illusion || pokemon).getTypes(true).join("/"), "[silent]");
      pokemon.apparentType = pokemon.getTypes(true).join("/");
    }
  },
  {
    name: "[Gen 9] The Loser's Game",
    desc: `The first player to lose all of their Pok&eacute;mon wins.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714223/">The Loser's Game</a>`
    ],
    mod: "gen9",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Clause Mod", "!OHKO Clause", "Picked Team Size = 6", "Adjust Level = 100", "Min Source Gen = 9"],
    banlist: ["Infiltrator", "Choice Scarf", "Explosion", "Final Gambit", "Healing Wish", "Lunar Dance", "Magic Room", "Memento", "Misty Explosion", "Self-Destruct"],
    onValidateTeam(team) {
      const familyTable = /* @__PURE__ */ new Set();
      for (const set of team) {
        let species = this.dex.species.get(set.species);
        while (species.prevo) {
          species = this.dex.species.get(species.prevo);
        }
        if (familyTable.has(species.id)) {
          return [
            `You are limited to one Pok&eacute;mon from each family by the Family Clause.`,
            `(You have more than one evolution of ${species.name}.)`
          ];
        }
        familyTable.add(species.id);
      }
    },
    battle: {
      tiebreak() {
        if (this.ended)
          return false;
        this.inputLog.push(`>tiebreak`);
        this.add("message", "Time's up! Going to tiebreaker...");
        const notFainted = this.sides.map((side) => side.pokemon.filter((pokemon) => !pokemon.fainted).length);
        this.add("-message", this.sides.map((side, i) => `${side.name}: ${notFainted[i]} Pokemon left`).join("; "));
        const maxNotFainted = Math.max(...notFainted);
        let tiedSides = this.sides.filter((side, i) => notFainted[i] === maxNotFainted);
        if (tiedSides.length <= 1) {
          return this.win(tiedSides[1]);
        }
        const hpPercentage = tiedSides.map((side) => side.pokemon.map((pokemon) => pokemon.hp / pokemon.maxhp).reduce((a, b) => a + b) * 100 / 6);
        this.add("-message", tiedSides.map((side, i) => `${side.name}: ${Math.round(hpPercentage[i])}% total HP left`).join("; "));
        const maxPercentage = Math.max(...hpPercentage);
        tiedSides = tiedSides.filter((side, i) => hpPercentage[i] === maxPercentage);
        if (tiedSides.length <= 1) {
          return this.win(tiedSides[1]);
        }
        const hpTotal = tiedSides.map((side) => side.pokemon.map((pokemon) => pokemon.hp).reduce((a, b) => a + b));
        this.add("-message", tiedSides.map((side, i) => `${side.name}: ${Math.round(hpTotal[i])} total HP left`).join("; "));
        const maxTotal = Math.max(...hpTotal);
        tiedSides = tiedSides.filter((side, i) => hpTotal[i] === maxTotal);
        if (tiedSides.length <= 1) {
          return this.win(tiedSides[1]);
        }
        return this.tie();
      },
      checkWin(faintData) {
        const team1PokemonLeft = this.sides[0].pokemonLeft;
        const team2PokemonLeft = this.sides[1].pokemonLeft;
        if (!team1PokemonLeft && !team2PokemonLeft) {
          this.win(faintData?.target.side || null);
          return true;
        }
        for (const side of this.sides) {
          if (!side.pokemonLeft) {
            this.win(side);
            return true;
          }
        }
      }
    }
  },
  {
    name: "[Gen 9] Trademarked",
    desc: `Sacrifice your Pok&eacute;mon's ability for a status move that activates on switch-in.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3714688/">Trademarked</a>`
    ],
    mod: "trademarked",
    searchShow: false,
    ruleset: ["Standard OMs", "Sleep Moves Clause", "Min Source Gen = 9"],
    banlist: ["Flutter Mane", "Koraidon", "Miraidon", "Slaking", "Arena Trap", "Magnet Pull", "Moody", "Shadow Tag", "Baton Pass", "Revival Blessing"],
    restricted: [
      "Baneful Bunker",
      "Block",
      "Chilly Reception",
      "Copycat",
      "Detect",
      "Destiny Bond",
      "Encore",
      "Fairy Lock",
      "Ingrain",
      "Instruct",
      "Mean Look",
      "move:Metronome",
      "Parting Shot",
      "Protect",
      "Roar",
      "Silk Trap",
      "Spiky Shield",
      "Sleep Talk",
      "Shed Tail",
      "Shell Smash",
      "Substitute",
      "Teleport",
      "Trick Room",
      "Whirlwind"
    ],
    onValidateTeam(team, format, teamHas) {
      const problems = [];
      for (const trademark in teamHas.trademarks) {
        if (teamHas.trademarks[trademark] > 1) {
          problems.push(`You are limited to 1 of each Trademark.`, `(You have ${teamHas.trademarks[trademark]} Pok\xE9mon with ${trademark} as a Trademark.)`);
        }
      }
      return problems;
    },
    validateSet(set, teamHas) {
      const dex = this.dex;
      const ability = dex.moves.get(set.ability);
      if (!ability.exists) {
        return this.validateSet(set, teamHas);
      }
      if (ability.category !== "Status") {
        return [`${ability.name} is not a status move and cannot be used as a trademark.`];
      }
      if (this.ruleTable.isRestricted(`move:${ability.id}`)) {
        return [`${ability.name} is restricted from being used as a trademark.`];
      }
      if (set.moves.map(this.toID).includes(ability.id)) {
        return [`${set.name} may not use ${ability.name} as both a trademark and one of its moves simultaneously.`];
      }
      const customRules = this.format.customRules || [];
      if (!customRules.includes("!obtainableabilities"))
        customRules.push("!obtainableabilities");
      if (!customRules.includes("+noability"))
        customRules.push("+noability");
      const TeamValidator = require("../sim/team-validator").TeamValidator;
      const validator = new TeamValidator(dex.formats.get(`${this.format.id}@@@${customRules.join(",")}`));
      const moves = set.moves;
      set.moves = [ability.id];
      set.ability = "No Ability";
      let problems = validator.validateSet(set, {}) || [];
      if (problems.length)
        return problems;
      set.moves = moves;
      set.ability = "No Ability";
      problems = problems.concat(validator.validateSet(set, teamHas) || []);
      set.ability = ability.id;
      if (!teamHas.trademarks)
        teamHas.trademarks = {};
      teamHas.trademarks[ability.name] = (teamHas.trademarks[ability.name] || 0) + 1;
      return problems.length ? problems : null;
    }
  },
  // Retro Other Metagames
  ///////////////////////////////////////////////////////////////////
  {
    section: "Retro Other Metagames",
    column: 2
  },
  {
    name: "[Gen 7] STABmons",
    desc: `Pok&eacute;mon can use any move of their typing, in addition to the moves they can normally learn.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8697545/">USM STABmons</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] OU", "STABmons Move Legality"],
    banlist: ["Aerodactyl", "Aerodactyl-Mega", "Araquanid", "Blacephalon", "Kartana", "Komala", "Kyurem-Black", "Porygon-Z", "Silvally", "Tapu Koko", "Tapu Lele", "Thundurus", "Thundurus-Therian", "King's Rock", "Razor Fang"],
    restricted: ["Acupressure", "Belly Drum", "Chatter", "Extreme Speed", "Geomancy", "Lovely Kiss", "Shell Smash", "Shift Gear", "Spore", "Thousand Arrows"]
  },
  {
    name: "[Gen 6] Almost Any Ability",
    desc: `Pok&eacute;mon have access to almost any ability.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8772336/">ORAS Almost Any Ability</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] OU", "Ability Clause = 2", "AAA Restricted Abilities", "!Obtainable Abilities"],
    banlist: ["Archeops", "Bisharp", "Chatot", "Dragonite", "Keldeo", "Kyurem-Black", "Mamoswine", "Regigigas", "Shedinja", "Slaking", "Smeargle", "Snorlax", "Suicune", "Terrakion", "Weavile", "Dynamic Punch", "Zap Cannon"],
    unbanlist: ["Aegislash", "Blaziken", "Deoxys-Defense", "Deoxys-Speed", "Genesect", "Greninja", "Landorus"],
    restricted: ["Arena Trap", "Contrary", "Fur Coat", "Huge Power", "Illusion", "Imposter", "Parental Bond", "Protean", "Pure Power", "Simple", "Speed Boost", "Wonder Guard"]
  },
  {
    name: "[Gen 6] Pure Hackmons",
    desc: `Anything that can be hacked in-game and is usable in local battles is allowed.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9029427/">ORAS Pure Hackmons</a>`
    ],
    mod: "gen6",
    ruleset: ["-Nonexistent", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause", "EV limit = 510"]
  },
  // Randomized Format Spotlight
  ///////////////////////////////////////////////////////////////////
  {
    section: "Randomized Format Spotlight",
    column: 3
  },
  {
    name: "[Gen 9] Broken Cup",
    desc: `[Gen 9] Hackmons Cup but with only the most powerful Pokemon, moves, Abilities, and items.`,
    team: "randomHC",
    ruleset: ["[Gen 9] Hackmons Cup"],
    banlist: ["All Pokemon", "All Abilities", "All Items", "All Moves"],
    unbanlist: [
      "10,000,000 Volt Thunderbolt",
      "Abomasnow-Mega",
      "Absol-Mega",
      "Accelerock",
      "Acid Spray",
      "Adaptability",
      "Aeroblast",
      "Aerodactyl-Mega",
      "Aggron",
      "Aggron-Mega",
      "Aguav Berry",
      "Air Balloon",
      "Air Slash",
      "Alakazam-Mega",
      "Altaria-Mega",
      "Ampharos-Mega",
      "Analytic",
      "Anchor Shot",
      "Anger Shell",
      "Annihilape",
      "Anticipation",
      "Apple Acid",
      "Aqua Step",
      "Arcanine",
      "Arcanine-Hisui",
      "Archeops",
      "Arena Trap",
      "Armarouge",
      "Armor Cannon",
      "Aromatherapy",
      "Articuno",
      "Articuno-Galar",
      "Assault Vest",
      "Astral Barrage",
      "Attack Order",
      "Audino-Mega",
      "Aura Sphere",
      "Axe Kick",
      "Azelf",
      "Baddy Bad",
      "Baneful Bunker",
      "Banette-Mega",
      "Barb Barrage",
      "Basculegion",
      "Basculegion-F",
      "Baton Pass",
      "Baxcalibur",
      "Beads of Ruin",
      "Beak Blast",
      "Beast Boost",
      "Behemoth Bash",
      "Behemoth Blade",
      "Belly Drum",
      "Berserk",
      "Bitter Blade",
      "Bitter Malice",
      "Blacephalon",
      "Blastoise",
      "Blastoise-Mega",
      "Blaziken",
      "Blaziken-Mega",
      "Blazing Torque",
      "Bleakwind Storm",
      "Blissey",
      "Blizzard",
      "Blue Flare",
      "Blunder Policy",
      "Body Press",
      "Body Slam",
      "Bolt Beak",
      "Bolt Strike",
      "Boomburst",
      "Bouncy Bubble",
      "Brave Bird",
      "Bright Powder",
      "Brute Bonnet",
      "Bug Buzz",
      "Buginium Z",
      "Bullet Punch",
      "Buzzwole",
      "Buzzy Buzz",
      "Calm Mind",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Camerupt-Mega",
      "Catastropika",
      "Ceaseless Edge",
      "Celebi",
      "Celesteela",
      "Centiskorch",
      "Ceruledge",
      "Charizard",
      "Charizard-Mega-X",
      "Charizard-Mega-Y",
      "Chatter",
      "Chesnaught",
      "Chesto Berry",
      "Chi-Yu",
      "Chien-Pao",
      "Chilan Berry",
      "Chilly Reception",
      "Choice Band",
      "Choice Scarf",
      "Choice Specs",
      "Cinderace",
      "Circle Throw",
      "Clanging Scales",
      "Clangorous Soul",
      "Clangorous Soulblaze",
      "Clear Amulet",
      "Close Combat",
      "Cloyster",
      "Cobalion",
      "Coil",
      "Collision Course",
      "Comatose",
      "Combat Torque",
      "Competitive",
      "Compound Eyes",
      "Contrary",
      "Core Enforcer",
      "Cosmic Power",
      "Cotton Guard",
      "Court Change",
      "Covert Cloak",
      "Crabhammer",
      "Cresselia",
      "Crobat",
      "Custap Berry",
      "Dark Pulse",
      "Darkest Lariat",
      "Darkinium Z",
      "Darkrai",
      "Darmanitan-Galar-Zen",
      "Darmanitan-Zen",
      "Decidueye",
      "Decidueye-Hisui",
      "Defend Order",
      "Defiant",
      "Defog",
      "Delphox",
      "Deoxys",
      "Deoxys-Attack",
      "Deoxys-Defense",
      "Deoxys-Speed",
      "Desolate Land",
      "Dialga",
      "Dialga-Origin",
      "Diamond Storm",
      "Diancie",
      "Diancie-Mega",
      "Dire Claw",
      "Disable",
      "Discharge",
      "Dondozo",
      "Doom Desire",
      "Double Iron Bash",
      "Download",
      "Draco Meteor",
      "Draco Plate",
      "Dragapult",
      "Dragon Ascent",
      "Dragon Dance",
      "Dragon Darts",
      "Dragon Energy",
      "Dragon Hammer",
      "Dragon Pulse",
      "Dragon Tail",
      "Dragonite",
      "Dragonium Z",
      "Drain Punch",
      "Dread Plate",
      "Drill Peck",
      "Drizzle",
      "Drought",
      "Drum Beating",
      "Dry Skin",
      "Duraludon",
      "Dusknoir",
      "Dynamax Cannon",
      "Earth Eater",
      "Earth Plate",
      "Earth Power",
      "Earthquake",
      "Eerie Spell",
      "Effect Spore",
      "Eject Pack",
      "Electivire",
      "Electric Surge",
      "Electrium Z",
      "Electro Drift",
      "Emboar",
      "Empoleon",
      "Enamorus",
      "Enamorus-Therian",
      "Encore",
      "Energy Ball",
      "Entei",
      "Eruption",
      "Espeon",
      "Esper Wing",
      "Eternatus",
      "Eternatus-Eternamax",
      "Exeggutor",
      "Exeggutor-Alola",
      "Expanding Force",
      "Expert Belt",
      "Explosion",
      "Extreme Evoboost",
      "Extreme Speed",
      "Fairium Z",
      "Fake Out",
      "Feraligatr",
      "Fiery Wrath",
      "Fightinium Z",
      "Figy Berry",
      "Filter",
      "Fire Blast",
      "Fire Lash",
      "Firium Z",
      "First Impression",
      "Fishious Rend",
      "Fist Plate",
      "Flame Body",
      "Flame Charge",
      "Flame Plate",
      "Flamethrower",
      "Flare Blitz",
      "Flareon",
      "Flash Cannon",
      "Fleur Cannon",
      "Flip Turn",
      "Floaty Fall",
      "Florges",
      "Flower Trick",
      "Fluffy",
      "Flutter Mane",
      "Flyinium Z",
      "Focus Blast",
      "Focus Sash",
      "Forewarn",
      "Foul Play",
      "Freeze-Dry",
      "Freezing Glare",
      "Freezy Frost",
      "Frost Breath",
      "Fur Coat",
      "Fusion Bolt",
      "Fusion Flare",
      "Future Sight",
      "G-Max Cannonade",
      "G-Max Centiferno",
      "G-Max Resonance",
      "G-Max Steelsurge",
      "G-Max Stonesurge",
      "G-Max Sweetness",
      "G-Max Vine Lash",
      "G-Max Volcalith",
      "G-Max Wildfire",
      "G-Max Wind Rage",
      "Gallade-Mega",
      "Garchomp",
      "Garchomp-Mega",
      "Gardevoir-Mega",
      "Gear Grind",
      "Genesect",
      "Genesis Supernova",
      "Gengar-Mega",
      "Gholdengo",
      "Ghostium Z",
      "Giga Drain",
      "Gigaton Hammer",
      "Giratina",
      "Giratina-Origin",
      "Glaceon",
      "Glacial Lance",
      "Glaive Rush",
      "Glalie-Mega",
      "Glare",
      "Glastrier",
      "Glimmora",
      "Glitzy Glow",
      "Gogoat",
      "Golisopod",
      "Good as Gold",
      "Goodra",
      "Goodra-Hisui",
      "Gooey",
      "Gorilla Tactics",
      "Grassium Z",
      "Grassy Surge",
      "Grav Apple",
      "Great Tusk",
      "Greninja",
      "Greninja-Ash",
      "Groudon",
      "Groudon-Primal",
      "Groundium Z",
      "Guardian of Alola",
      "Gunk Shot",
      "Guzzlord",
      "Gyarados",
      "Gyarados-Mega",
      "Hadron Engine",
      "Hammer Arm",
      "Haxorus",
      "Haze",
      "Head Charge",
      "Head Smash",
      "Headlong Rush",
      "Heal Bell",
      "Heal Order",
      "Healing Wish",
      "Heart Swap",
      "Heat Crash",
      "Heat Wave",
      "Heatran",
      "Heavy-Duty Boots",
      "Heracross-Mega",
      "High Horsepower",
      "High Jump Kick",
      "Hippowdon",
      "Ho-Oh",
      "Hoopa",
      "Hoopa-Unbound",
      "Horn Leech",
      "Houndoom-Mega",
      "Huge Power",
      "Hurricane",
      "Hydreigon",
      "Hydro Steam",
      "Hyper Drill",
      "Iapapa Berry",
      "Ice Beam",
      "Ice Hammer",
      "Ice Scales",
      "Ice Shard",
      "Ice Spinner",
      "Icicle Plate",
      "Icium Z",
      "Illusion",
      "Imposter",
      "Incineroar",
      "Infernape",
      "Innards Out",
      "Insect Plate",
      "Inteleon",
      "Intimidate",
      "Intrepid Sword",
      "Iron Barbs",
      "Iron Bundle",
      "Iron Hands",
      "Iron Head",
      "Iron Jugulis",
      "Iron Leaves",
      "Iron Moth",
      "Iron Plate",
      "Iron Thorns",
      "Iron Treads",
      "Iron Valiant",
      "Jet Punch",
      "Jirachi",
      "Jolteon",
      "Judgment",
      "Kangaskhan-Mega",
      "Kartana",
      "Keldeo",
      "Keldeo-Resolute",
      "King's Rock",
      "King's Shield",
      "Kingambit",
      "Kingdra",
      "Knock Off",
      "Kommo-o",
      "Koraidon",
      "Kyogre",
      "Kyogre-Primal",
      "Kyurem",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus",
      "Landorus-Therian",
      "Lapras",
      "Last Respects",
      "Latias",
      "Latias-Mega",
      "Latios",
      "Latios-Mega",
      "Lava Plume",
      "Leaf Blade",
      "Leaf Storm",
      "Leafeon",
      "Leech Life",
      "Leech Seed",
      "Leftovers",
      "Leppa Berry",
      "Let's Snuggle Forever",
      "Levitate",
      "Libero",
      "Liechi Berry",
      "Life Orb",
      "Light Screen",
      "Light That Burns the Sky",
      "Light of Ruin",
      "Lightning Rod",
      "Liquidation",
      "Lopunny-Mega",
      "Lovely Kiss",
      "Low Kick",
      "Lucario",
      "Lucario-Mega",
      "Lugia",
      "Lum Berry",
      "Lumina Crash",
      "Lunala",
      "Lunar Blessing",
      "Lunar Dance",
      "Lunge",
      "Mach Punch",
      "Magearna",
      "Magic Bounce",
      "Magic Guard",
      "Magical Torque",
      "Magma Storm",
      "Magmortar",
      "Magnezone",
      "Mago Berry",
      "Make It Rain",
      "Malicious Moonsault",
      "Mamoswine",
      "Manaphy",
      "Manectric-Mega",
      "Marshadow",
      "Max Guard",
      "Meadow Plate",
      "Megahorn",
      "Meganium",
      "Melmetal",
      "Meloetta",
      "Meloetta-Pirouette",
      "Memento",
      "Menacing Moonraze Maelstrom",
      "Mental Herb",
      "Meowscarada",
      "Mesprit",
      "Metagross",
      "Metagross-Mega",
      "Meteor Beam",
      "Meteor Mash",
      "item: Metronome",
      "Mew",
      "Mewtwo",
      "Mewtwo-Mega-X",
      "Mewtwo-Mega-Y",
      "Milk Drink",
      "Milotic",
      "Mind Plate",
      "Minimize",
      "Miraidon",
      "Mirror Herb",
      "Misty Explosion",
      "Misty Surge",
      "Mold Breaker",
      "Moltres",
      "Moltres-Galar",
      "Moody",
      "Moonblast",
      "Moongeist Beam",
      "Moonlight",
      "Morning Sun",
      "Mortal Spin",
      "Mountain Gale",
      "Moxie",
      "Multiscale",
      "Muscle Band",
      "Mystical Fire",
      "Mystical Power",
      "Naganadel",
      "Nasty Plot",
      "Nature's Madness",
      "Necrozma",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Necrozma-Ultra",
      "Neutralizing Gas",
      "Night Daze",
      "Night Shade",
      "Nihilego",
      "No Retreat",
      "Noivern",
      "Normalium Z",
      "Noxious Torque",
      "Nuzzle",
      "Oblivion Wing",
      "Obstruct",
      "Oceanic Operetta",
      "Octolock",
      "Opportunist",
      "Orichalcum Pulse",
      "Origin Pulse",
      "Outrage",
      "Overdrive",
      "Overheat",
      "Palafin-Hero",
      "Palkia",
      "Palkia-Origin",
      "Parental Bond",
      "Parting Shot",
      "Perish Body",
      "Petaya Berry",
      "Pheromosa",
      "Photon Geyser",
      "Pidgeot-Mega",
      "Pinsir-Mega",
      "Pixie Plate",
      "Plasma Fists",
      "Play Rough",
      "Poison Heal",
      "Poisonium Z",
      "Pollen Puff",
      "Poltergeist",
      "Population Bomb",
      "Porygon-Z",
      "Power Gem",
      "Power Trip",
      "Power Whip",
      "Prankster",
      "Precipice Blades",
      "Primarina",
      "Primordial Sea",
      "Probopass",
      "Protean",
      "Protect",
      "Psyblade",
      "Psychic Fangs",
      "Psychic Surge",
      "Psychic",
      "Psychium Z",
      "Psycho Boost",
      "Psyshield Bash",
      "Psystrike",
      "Pulverizing Pancake",
      "Pure Power",
      "Purifying Salt",
      "Pursuit",
      "Pyro Ball",
      "Quaquaval",
      "Quick Claw",
      "Quiver Dance",
      "Rage Fist",
      "Raging Bull",
      "Raging Fury",
      "Raikou",
      "Rapid Spin",
      "Rayquaza",
      "Rayquaza-Mega",
      "Razor Claw",
      "Recover",
      "Red Card",
      "Reflect",
      "Regenerator",
      "Regice",
      "Regidrago",
      "Regieleki",
      "Regigigas",
      "Regirock",
      "Registeel",
      "Reshiram",
      "Rest",
      "Revelation Dance",
      "Revival Blessing",
      "Rhyperior",
      "Rillaboom",
      "Roaring Moon",
      "Rockium Z",
      "Rocky Helmet",
      "Roost",
      "Rough Skin",
      "Ruination",
      "Sacred Fire",
      "Sacred Sword",
      "Salac Berry",
      "Salamence",
      "Salamence-Mega",
      "Salt Cure",
      "Samurott",
      "Samurott-Hisui",
      "Sandsear Storm",
      "Sandy Shocks",
      "Sap Sipper",
      "Sappy Seed",
      "Scald",
      "Sceptile",
      "Sceptile-Mega",
      "Scizor-Mega",
      "Scope Lens",
      "Scream Tail",
      "Searing Shot",
      "Searing Sunraze Smash",
      "Secret Sword",
      "Seed Flare",
      "Seismic Toss",
      "Serene Grace",
      "Serperior",
      "Shadow Ball",
      "Shadow Bone",
      "Shadow Shield",
      "Shadow Sneak",
      "Shadow Tag",
      "Sharpedo-Mega",
      "Shaymin",
      "Shaymin-Sky",
      "Shed Tail",
      "Sheer Force",
      "Shell Side Arm",
      "Shell Smash",
      "Shield Dust",
      "Shift Gear",
      "Silk Scarf",
      "Silk Trap",
      "Silvally",
      "Simple",
      "Sinister Arrow Raid",
      "Sitrus Berry",
      "Sizzly Slide",
      "Skeledirge",
      "Sky Plate",
      "Slack Off",
      "Slaking",
      "Sleep Powder",
      "Slither Wing",
      "Slowbro-Mega",
      "Sludge Bomb",
      "Sludge Wave",
      "Snarl",
      "Snipe Shot",
      "Snorlax",
      "Soft-Boiled",
      "Solgaleo",
      "Solid Rock",
      "Soul-Heart",
      "Soul-Stealing 7-Star Strike",
      "Spacial Rend",
      "Sparkly Swirl",
      "Spectral Thief",
      "Spectrier",
      "Speed Boost",
      "Spikes",
      "Spiky Shield",
      "Spin Out",
      "Spirit Break",
      "Spirit Shackle",
      "Splash Plate",
      "Splintered Stormshards",
      "Splishy Splash",
      "Spooky Plate",
      "Spore",
      "Springtide Storm",
      "Stakataka",
      "Stakeout",
      "Stamina",
      "Stealth Rock",
      "Steam Eruption",
      "Steelium Z",
      "Steelix-Mega",
      "Sticky Web",
      "Stoked Sparksurfer",
      "Stone Axe",
      "Stone Edge",
      "Stone Plate",
      "Stored Power",
      "Storm Drain",
      "Storm Throw",
      "Strange Steam",
      "Strength Sap",
      "Sucker Punch",
      "Suicune",
      "Sunsteel Strike",
      "Super Fang",
      "Superpower",
      "Supreme Overlord",
      "Surf",
      "Surging Strikes",
      "Swampert",
      "Swampert-Mega",
      "Sword of Ruin",
      "Swords Dance",
      "Sylveon",
      "Synthesis",
      "Tablets of Ruin",
      "Tail Glow",
      "Tangrowth",
      "Tapu Bulu",
      "Tapu Fini",
      "Tapu Koko",
      "Tapu Lele",
      "Taunt",
      "Techno Blast",
      "Teleport",
      "Tera Blast",
      "Teravolt",
      "Terrakion",
      "Thick Fat",
      "Thousand Arrows",
      "Thousand Waves",
      "Throat Spray",
      "Thunder Cage",
      "Thunder Wave",
      "Thunder",
      "Thunderbolt",
      "Thunderous Kick",
      "Thundurus",
      "Thundurus-Therian",
      "Tidy Up",
      "Ting-Lu",
      "Tinted Lens",
      "Togekiss",
      "Topsy-Turvy",
      "Torch Song",
      "Tornadus",
      "Tornadus-Therian",
      "Torterra",
      "Tough Claws",
      "Toxic Debris",
      "Toxic Plate",
      "Toxic Spikes",
      "Toxic",
      "Tri Attack",
      "Triage",
      "Triple Arrows",
      "Triple Axel",
      "Turboblaze",
      "Type: Null",
      "Typhlosion",
      "Typhlosion-Hisui",
      "Tyranitar",
      "Tyranitar-Mega",
      "U-turn",
      "Umbreon",
      "Unaware",
      "Unburden",
      "Ursaluna",
      "Urshifu",
      "Urshifu-Rapid-Strike",
      "Uxie",
      "V-create",
      "Vanilluxe",
      "Vaporeon",
      "Venusaur",
      "Venusaur-Mega",
      "Vessel of Ruin",
      "Victini",
      "Victory Dance",
      "Virizion",
      "Volcanion",
      "Volcarona",
      "Volt Absorb",
      "Volt Switch",
      "Volt Tackle",
      "Walking Wake",
      "Walrein",
      "Water Absorb",
      "Water Bubble",
      "Water Shuriken",
      "Water Spout",
      "Waterfall",
      "Waterium Z",
      "Wave Crash",
      "Weakness Policy",
      "Well-Baked Body",
      "White Herb",
      "Wicked Blow",
      "Wicked Torque",
      "Wide Lens",
      "Wiki Berry",
      "Wild Charge",
      "Wildbolt Storm",
      "Will-O-Wisp",
      "Wise Glasses",
      "Wish",
      "Wishiwashi-School",
      "Wo-Chien",
      "Wonder Guard",
      "Wood Hammer",
      "Wyrdeer",
      "Xerneas",
      "Xurkitree",
      "Yawn",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zap Plate",
      "Zapdos",
      "Zapdos-Galar",
      "Zarude",
      "Zekrom",
      "Zeraora",
      "Zing Zap",
      "Zippy Zap",
      "Zygarde",
      "Zygarde-Complete"
    ]
  },
  // Randomized Metas
  ///////////////////////////////////////////////////////////////////
  {
    section: "Randomized Metas",
    column: 3
  },
  {
    name: "[Gen 9] Monotype Random Battle",
    mod: "gen9",
    team: "random",
    ruleset: ["Obtainable", "Same Type Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 9] Random Battle Mayhem",
    desc: `[Gen 9] Random Battle with Team Preview and elements of Camomons, Inverse, Scalemons, and Shared Power.`,
    mod: "sharedpower",
    team: "random",
    ruleset: ["[Gen 9] Random Battle", "Team Preview", "Camomons Mod", "Inverse Mod", "Scalemons Mod"],
    onBeforeSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedPower)
        format = this.dex.formats.get("gen9sharedpower");
      for (const ability of format.getSharedPower(pokemon)) {
        const effect = "ability:" + ability;
        pokemon.volatiles[effect] = { id: this.toID(effect), target: pokemon };
        if (!pokemon.m.abils)
          pokemon.m.abils = [];
        if (!pokemon.m.abils.includes(effect))
          pokemon.m.abils.push(effect);
      }
    },
    onSwitchInPriority: 2,
    onSwitchIn(pokemon) {
      let format = this.format;
      if (!format.getSharedPower)
        format = this.dex.formats.get("gen9sharedpower");
      for (const ability of format.getSharedPower(pokemon)) {
        if (ability === "noability") {
          this.hint(`Mirror Armor and Trace break in Shared Power formats that don't use Shared Power as a base, so they get removed from non-base users.`);
        }
        const effect = "ability:" + ability;
        delete pokemon.volatiles[effect];
        pokemon.addVolatile(effect);
      }
    }
  },
  {
    name: "[Gen 9] Computer-Generated Teams",
    desc: `Teams generated automatically based on heuristics (rules), with levels based on previous success/failure in battle. Not affiliated with Random Battles formats. Some sets will by nature be worse than others, but you can report egregiously bad sets with <a href="https://forms.gle/DYwQN5qGVegz3YU38">this form</a>.`,
    mod: "gen9",
    team: "computerGenerated",
    ruleset: ["Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 9] Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any ability, moves, and item.`,
    mod: "gen9",
    team: "randomHC",
    ruleset: ["HP Percentage Mod", "Cancel Mod"],
    banlist: ["Nonexistent"]
  },
  {
    name: "[Gen 9] Doubles Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any ability, moves, and item. Now with TWICE the Pok&eacute;mon per side!`,
    mod: "gen9",
    team: "randomHC",
    searchShow: false,
    gameType: "doubles",
    ruleset: ["[Gen 9] Hackmons Cup"]
  },
  {
    name: "[Gen 9] Challenge Cup 1v1",
    mod: "gen9",
    team: "randomCC",
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod", "Team Preview", "Terastal Clause", "Picked Team Size = 1"]
  },
  {
    name: "[Gen 9] Challenge Cup 2v2",
    mod: "gen9",
    team: "randomCC",
    gameType: "doubles",
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod", "Team Preview", "Picked Team Size = 2"]
  },
  {
    name: "[Gen 9] Challenge Cup 6v6",
    mod: "gen9",
    team: "randomCC",
    searchShow: false,
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 8] Random Battle",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with sets that are generated to be competitively viable.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3656537/">Random Battle Suggestions</a>`
    ],
    mod: "gen8",
    team: "random",
    ruleset: ["PotD", "Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 8] Random Doubles Battle",
    mod: "gen8",
    gameType: "doubles",
    team: "random",
    ruleset: ["PotD", "Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 8] Free-For-All Random Battle",
    mod: "gen8",
    team: "random",
    gameType: "freeforall",
    // searchShow: false,
    tournamentShow: false,
    rated: false,
    ruleset: ["Obtainable", "Species Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 8] Multi Random Battle",
    mod: "gen8",
    team: "random",
    gameType: "multi",
    searchShow: false,
    tournamentShow: false,
    rated: false,
    ruleset: [
      "Max Team Size = 3",
      "Obtainable",
      "Species Clause",
      "HP Percentage Mod",
      "Cancel Mod",
      "Sleep Clause Mod"
    ]
  },
  {
    name: "[Gen 8] Battle Factory",
    desc: `Randomized teams of Pok&eacute;mon for a generated Smogon tier with sets that are competitively viable.`,
    mod: "gen8",
    team: "randomFactory",
    ruleset: ["Standard", "Dynamax Clause"]
  },
  {
    name: "[Gen 8] BSS Factory",
    desc: `Randomized 3v3 Singles featuring Pok&eacute;mon and movesets popular in Battle Stadium Singles.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3675374/">Information and Suggestions Thread</a>`
    ],
    mod: "gen8",
    team: "randomBSSFactory",
    ruleset: ["Flat Rules"]
  },
  {
    name: "[Gen 8] Super Staff Bros 4",
    desc: "The fourth iteration of Super Staff Bros is here! Battle with a random team of pokemon created by the sim staff.",
    threads: [
      `&bullet; <a href="https://www.smogon.com/articles/super-staff-bros-4">Introduction &amp; Roster</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/super-staff-bros-4-discussion-thread.3675237/">Discussion Thread</a>`
    ],
    mod: "ssb",
    team: "randomStaffBros",
    ruleset: ["Dynamax Clause", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"],
    onBegin() {
      if (!this.ruleTable.has("dynamaxclause")) {
        for (const side of this.sides) {
          side.dynamaxUsed = true;
        }
        this.add("message", "Delphox only");
        this.add("message", "No items");
        this.add("message", "Final Destination");
        return;
      }
      this.add(`raw|<div class='broadcast-green'><b>Wondering what all these custom moves, abilities, and items do?<br />Check out the <a href="https://www.smogon.com/articles/super-staff-bros-4" target="_blank">Super Staff Bros 4 Guide</a> or use /ssb to find out!</b></div>`);
      this.add("message", [
        "THE BATTLE FOR SURVIVAL BEGINS!",
        "WHO WILL SURVIVE?",
        "GET READY TO KEEP UP!",
        "GET READY!",
        "DARE TO BELIEVE YOU CAN SURVIVE!",
        "THERE CAN BE ONLY ONE WINNER!",
        "GET READY FOR THE FIGHT OF YOUR LIFE!",
        "WHO WILL PREVAIL?",
        "ONLY ONE TEAM WILL BE LEFT STANDING!",
        "BATTLE WITHOUT LIMITS!"
      ][this.random(10)]);
      this.add("message", "FIGHT!");
    },
    onSwitchInPriority: 100,
    onSwitchIn(pokemon) {
      let name = this.toID(pokemon.illusion ? pokemon.illusion.name : pokemon.name);
      if (this.dex.species.get(name).exists || this.dex.moves.get(name).exists || this.dex.abilities.get(name).exists) {
        name = name + "user";
      }
      const status = this.dex.conditions.get(name);
      if (status?.exists) {
        pokemon.addVolatile(name, pokemon);
      }
      if (pokemon.m.hasBounty)
        this.add("-start", pokemon, "bounty", "[silent]");
      const details = pokemon.species.name + (pokemon.level === 100 ? "" : ", L" + pokemon.level) + (pokemon.gender === "" ? "" : ", " + pokemon.gender) + (pokemon.set.shiny ? ", shiny" : "");
      if (pokemon.m.nowShiny)
        this.add("replace", pokemon, details);
    },
    onFaint(target, source, effect) {
      if (effect?.effectType !== "Move")
        return;
      if (!target.m.hasBounty)
        return;
      if (source) {
        this.add("-message", `${source.name} received the bounty!`);
        this.boost({ atk: 1, def: 1, spa: 1, spd: 1, spe: 1 }, source, target, effect);
      }
    }
  },
  {
    name: "[Gen 8] Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any ability, moves, and item.`,
    mod: "gen8",
    team: "randomHC",
    ruleset: ["HP Percentage Mod", "Cancel Mod"],
    banlist: ["Nonexistent"]
  },
  {
    name: "[Gen 8] CAP 1v1",
    desc: `Randomly generated 1v1-style teams only including Pok&eacute;mon made by the Create-A-Pok&eacute;mon Project.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3663533/">CAP 1v1</a>`
    ],
    mod: "gen8",
    searchShow: false,
    team: "randomCAP1v1",
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Species Clause",
      "Team Preview",
      "HP Percentage Mod",
      "Cancel Mod",
      "Sleep Clause Mod",
      "Dynamax Clause"
    ]
  },
  {
    name: "[Gen 8 BDSP] Random Battle",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with sets that are generated to be competitively viable.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3693955/">BDSP Random Battle Set Discussion</a>`
    ],
    mod: "gen8bdsp",
    team: "random",
    searchShow: false,
    ruleset: ["[Gen 8] Random Battle", "!PotD"]
  },
  {
    name: "[Gen 7] Random Battle",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with sets that are generated to be competitively viable.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3591157/">Sets and Suggestions</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3616946/">Role Compendium</a>`
    ],
    mod: "gen7",
    team: "random",
    ruleset: ["Obtainable", "Sleep Clause Mod", "HP Percentage Mod", "Cancel Mod", "Mega Rayquaza Clause"]
  },
  {
    name: "[Gen 7] Random Doubles Battle",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3601525/">Sets and Suggestions</a>`],
    mod: "gen7",
    gameType: "doubles",
    team: "random",
    searchShow: false,
    challengeShow: false,
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 7] Battle Factory",
    desc: `Randomized teams of Pok&eacute;mon for a generated Smogon tier with sets that are competitively viable.`,
    mod: "gen7",
    team: "randomFactory",
    ruleset: ["Obtainable", "Sleep Clause Mod", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Mega Rayquaza Clause"]
  },
  {
    name: "[Gen 7] BSS Factory",
    desc: `Randomized 3v3 Singles featuring Pok&eacute;mon and movesets popular in Battle Spot Singles.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3604845/">Information and Suggestions Thread</a>`
    ],
    mod: "gen7",
    team: "randomBSSFactory",
    searchShow: false,
    ruleset: ["Flat Rules"]
  },
  {
    name: "[Gen 7] Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any ability, moves, and item.`,
    mod: "gen7",
    team: "randomHC",
    searchShow: false,
    ruleset: ["HP Percentage Mod", "Cancel Mod"],
    banlist: ["Nonexistent"]
  },
  {
    name: "[Gen 7 Let's Go] Random Battle",
    mod: "gen7letsgo",
    team: "random",
    searchShow: false,
    ruleset: ["Obtainable", "Allow AVs", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 6] Random Battle",
    mod: "gen6",
    team: "random",
    ruleset: ["Obtainable", "Sleep Clause Mod", "HP Percentage Mod", "Cancel Mod", "Mega Rayquaza Clause"]
  },
  {
    name: "[Gen 6] Battle Factory",
    desc: `Randomized teams of Pok&eacute;mon for a generated Smogon tier with sets that are competitively viable.`,
    mod: "gen6",
    team: "randomFactory",
    searchShow: false,
    challengeShow: false,
    ruleset: ["Obtainable", "Sleep Clause Mod", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Mega Rayquaza Clause"]
  },
  {
    name: "[Gen 5] Random Battle",
    mod: "gen5",
    team: "random",
    ruleset: ["Obtainable", "Sleep Clause Mod", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 4] Random Battle",
    mod: "gen4",
    team: "random",
    ruleset: ["Obtainable", "Sleep Clause Mod", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 3] Random Battle",
    mod: "gen3",
    team: "random",
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 2] Random Battle",
    mod: "gen2",
    team: "random",
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 1] Random Battle",
    mod: "gen1",
    team: "random",
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 1] Challenge Cup",
    mod: "gen1",
    team: "randomCC",
    searchShow: false,
    challengeShow: false,
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod", "Desync Clause Mod", "Sleep Clause Mod", "Freeze Clause Mod"]
  },
  {
    name: "[Gen 1] Hackmons Cup",
    desc: `Randomized teams of level-balanced Pok&eacute;mon with absolutely any moves, types, and stats.`,
    mod: "gen1",
    team: "randomHC",
    searchShow: false,
    challengeShow: false,
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Desync Clause Mod", "Sleep Clause Mod", "Freeze Clause Mod", "Team Type Preview"],
    banlist: ["Nonexistent"],
    onModifySpecies(species, target, source, effect) {
      if (!target)
        return;
      return { ...species, ...target.set.hc };
    },
    onSwitchIn(pokemon) {
      this.add("-start", pokemon, "typechange", pokemon.getTypes(true).join("/"), "[silent]");
      for (const i in pokemon.species.baseStats) {
        if (i === "spd")
          continue;
        this.add("-start", pokemon, `${pokemon.species.baseStats[i]}${i === "spa" ? "spc" : i}`, "[silent]");
      }
    }
  },
  // Metronome Battle
  ///////////////////////////////////////////////////////////////////
  {
    section: "Metronome Battle",
    column: 3
  },
  {
    name: "[Gen 9] Metronome Battle",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3632075/">Metronome Battle</a>`
    ],
    mod: "gen9",
    gameType: "doubles",
    ruleset: ["Max Team Size = 2", "HP Percentage Mod", "Cancel Mod"],
    banlist: [
      "Pokestar Spirit",
      "Shedinja + Sturdy",
      "Cheek Pouch",
      "Commander",
      "Cursed Body",
      "Dry Skin",
      "Earth Eater",
      "Fur Coat",
      "Gorilla Tactics",
      "Grassy Surge",
      "Huge Power",
      "Ice Body",
      "Iron Barbs",
      "Moody",
      "Neutralizing Gas",
      "Opportunist",
      "Parental Bond",
      "Perish Body",
      "Poison Heal",
      "Power Construct",
      "Pressure",
      "Pure Power",
      "Rain Dish",
      "Rough Skin",
      "Sand Spit",
      "Sand Stream",
      "Seed Sower",
      "Stamina",
      "Volt Absorb",
      "Water Absorb",
      "Wonder Guard",
      "Aguav Berry",
      "Assault Vest",
      "Berry",
      "Berry Juice",
      "Berserk Gene",
      "Black Sludge",
      "Enigma Berry",
      "Figy Berry",
      "Gold Berry",
      "Iapapa Berry",
      "Kangaskhanite",
      "Leftovers",
      "Mago Berry",
      "Medichamite",
      "Steel Memory",
      "Oran Berry",
      "Rocky Helmet",
      "Shell Bell",
      "Sitrus Berry",
      "Wiki Berry",
      "Harvest + Jaboca Berry",
      "Harvest + Rowap Berry"
    ],
    onValidateSet(set) {
      const species = this.dex.species.get(set.species);
      if (species.types.includes("Steel")) {
        return [`${species.name} is a Steel-type, which is banned from Metronome Battle.`];
      }
      if (set.teraType === "Steel") {
        return [`${species.name} has Steel as its Tera type, which is banned from Metronome Battle.`];
      }
      if (species.bst > 625) {
        return [`${species.name} is banned.`, `(Pok\xE9mon with a BST higher than 625 are banned)`];
      }
      const item = this.dex.items.get(set.item);
      if (set.item && item.megaStone) {
        const megaSpecies = this.dex.species.get(item.megaStone);
        if (species.baseSpecies === item.megaEvolves && megaSpecies.bst > 625) {
          return [
            `${set.name || set.species}'s item ${item.name} is banned.`,
            `(Pok\xE9mon with a BST higher than 625 are banned)`
          ];
        }
      }
      if (set.moves.length !== 1 || this.dex.moves.get(set.moves[0]).id !== "metronome") {
        return [`${set.name || set.species} has illegal moves.`, `(Pok\xE9mon can only have one Metronome in their moveset)`];
      }
    }
  },
  {
    name: "[Gen 8] Metronome Battle",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3632075/">Metronome Battle</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Max Team Size = 2", "HP Percentage Mod", "Cancel Mod"],
    banlist: [
      "Pokestar Spirit",
      "Shedinja + Sturdy",
      "Battle Bond",
      "Cheek Pouch",
      "Cursed Body",
      "Dry Skin",
      "Fur Coat",
      "Gorilla Tactics",
      "Grassy Surge",
      "Huge Power",
      "Ice Body",
      "Iron Barbs",
      "Libero",
      "Moody",
      "Neutralizing Gas",
      "Parental Bond",
      "Perish Body",
      "Poison Heal",
      "Power Construct",
      "Pressure",
      "Protean",
      "Pure Power",
      "Rain Dish",
      "Rough Skin",
      "Sand Spit",
      "Sand Stream",
      "Snow Warning",
      "Stamina",
      "Volt Absorb",
      "Water Absorb",
      "Wonder Guard",
      "Abomasite",
      "Aguav Berry",
      "Assault Vest",
      "Berry",
      "Berry Juice",
      "Berserk Gene",
      "Black Sludge",
      "Enigma Berry",
      "Figy Berry",
      "Gold Berry",
      "Iapapa Berry",
      "Kangaskhanite",
      "Leftovers",
      "Mago Berry",
      "Medichamite",
      "Steel Memory",
      "Oran Berry",
      "Rocky Helmet",
      "Shell Bell",
      "Sitrus Berry",
      "Wiki Berry",
      "Harvest + Jaboca Berry",
      "Harvest + Rowap Berry"
    ],
    onValidateSet(set) {
      const species = this.dex.species.get(set.species);
      if (species.gen > 8) {
        return [`${species.name} is from gen 9, which is banned from [Gen 8] Metronome Battle.`];
      }
      if (species.types.includes("Steel")) {
        return [`${species.name} is a Steel-type, which is banned from Metronome Battle.`];
      }
      if (species.bst > 625) {
        return [`${species.name} is banned.`, `(Pok\xE9mon with a BST higher than 625 are banned)`];
      }
      const item = this.dex.items.get(set.item);
      if (item.gen > 8) {
        return [`${species.name} is from gen 9, which is banned from [Gen 8] Metronome Battle.`];
      }
      if (set.item && item.megaStone) {
        const megaSpecies = this.dex.species.get(item.megaStone);
        if (species.baseSpecies === item.megaEvolves && megaSpecies.bst > 625) {
          return [
            `${set.name || set.species}'s item ${item.name} is banned.`,
            `(Pok\xE9mon with a BST higher than 625 are banned)`
          ];
        }
      }
      const ability = this.dex.abilities.get(set.ability);
      if (ability.gen > 8) {
        return [`${species.name} is from gen 9, which is banned from [Gen 8] Metronome Battle.`];
      }
      if (set.moves.length !== 1 || this.dex.moves.get(set.moves[0]).id !== "metronome") {
        return [`${set.name || set.species} has illegal moves.`, `(Pok\xE9mon can only have one Metronome in their moveset)`];
      }
    }
  },
  // RoA Spotlight
  ///////////////////////////////////////////////////////////////////
  {
    section: "RoA Spotlight",
    column: 4
  },
  {
    name: "[Gen 4] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3532624/">DPP UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3503638/">DPP UU Viability Rankings</a>`
    ],
    mod: "gen4",
    // searchShow: false,
    ruleset: ["[Gen 4] OU", "!Freeze Clause Mod"],
    banlist: ["OU", "UUBL"],
    unbanlist: ["Arena Trap", "Swagger"]
  },
  {
    name: "[Gen 3] Challenge Cup",
    mod: "gen3",
    team: "randomCC",
    // searchShow: false,
    ruleset: ["Obtainable", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 5] ZU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8034680/">BW2 ZU</a>`
    ],
    mod: "gen5",
    // searchShow: false,
    ruleset: ["[Gen 5] PU"],
    banlist: ["PU", "Articuno", "Dragonair", "Glalie", "Machoke", "Marowak", "Omanyte", "Regigigas", "Trubbish", "Whirlipede", "Baton Pass"],
    unbanlist: ["Damp Rock"]
  },
  // Past Gens OU
  ///////////////////////////////////////////////////////////////////
  {
    section: "Past Gens OU",
    column: 4
  },
  {
    name: "[Gen 8] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672210/">SS OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672556/">SS OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3674058/">SS OU Viability Rankings</a>`
    ],
    mod: "gen8",
    ruleset: ["Standard", "Dynamax Clause"],
    banlist: ["Uber", "AG", "Arena Trap", "Moody", "Power Construct", "Sand Veil", "Shadow Tag", "Snow Cloak", "King's Rock", "Baton Pass"]
  },
  {
    name: "[Gen 7] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/sm/tags/ou/">USM OU Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8162240/">USM OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3667522/">USM OU Viability Rankings</a>`
    ],
    mod: "gen7",
    ruleset: ["Standard"],
    banlist: ["Uber", "Arena Trap", "Power Construct", "Shadow Tag", "Baton Pass"]
  },
  {
    name: "[Gen 6] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/tags/ou/">ORAS OU Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8133793/">ORAS OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3623399/">ORAS OU Viability Rankings</a>`
    ],
    mod: "gen6",
    ruleset: ["Standard", "Swagger Clause"],
    banlist: ["Uber", "Arena Trap", "Shadow Tag", "Soul Dew", "Baton Pass"]
  },
  {
    name: "[Gen 5] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3686880/">BW2 Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3668699/">BW2 OU Viability Rankings</a>`
    ],
    mod: "gen5",
    ruleset: ["Standard", "Evasion Abilities Clause", "Sleep Moves Clause", "Swagger Clause", "Gems Clause", "Baton Pass Stat Clause"],
    banlist: ["Uber", "Arena Trap", "Drizzle ++ Swift Swim", "Drought ++ Chlorophyll", "Sand Rush", "Shadow Tag", "King's Rock", "Razor Fang", "Soul Dew", "Assist"]
  },
  {
    name: "[Gen 4] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3685887/">DPP OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3687351/">DPP Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3683332/">DPP OU Viability Rankings</a>`
    ],
    mod: "gen4",
    ruleset: ["Standard", "Freeze Clause Mod"],
    banlist: ["AG", "Uber", "Arena Trap", "Sand Veil", "Swinub + Snow Cloak", "Piloswine + Snow Cloak", "Mamoswine + Snow Cloak", "Soul Dew", "Baton Pass", "Swagger"]
  },
  {
    name: "[Gen 3] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3687813/">ADV Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3503019/">ADV OU Viability Rankings</a>`
    ],
    mod: "gen3",
    ruleset: ["Standard", "One Boost Passer Clause", "Freeze Clause Mod"],
    banlist: ["Uber", "Sand Veil", "Soundproof", "Assist", "Baton Pass + Block", "Baton Pass + Mean Look", "Baton Pass + Spider Web", "Smeargle + Ingrain"]
  },
  {
    name: "[Gen 2] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3688523/">GSC Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3633233/">GSC OU Viability Rankings</a>`
    ],
    mod: "gen2",
    ruleset: ["Standard"],
    banlist: ["Uber", "Mean Look + Baton Pass", "Spider Web + Baton Pass"]
  },
  {
    name: "[Gen 1] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3689726/">RBY Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3685861/">RBY OU Viability Rankings</a>`
    ],
    mod: "gen1",
    ruleset: ["Standard"],
    banlist: ["Uber"]
  },
  // Past Gens Doubles OU
  ///////////////////////////////////////////////////////////////////
  {
    section: "Past Gens Doubles OU",
    column: 4
  },
  {
    name: "[Gen 8] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3689189/">SS Doubles OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3658826/">SS Doubles OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3673519/">SS Doubles OU Viability Rankings</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    ruleset: ["Standard Doubles", "Dynamax Clause", "Swagger Clause"],
    banlist: ["DUber", "Power Construct", "Shadow Tag"]
  },
  {
    name: "[Gen 7] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3661293/">USUM Doubles OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8394179/">USUM Doubles OU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8394190/">USUM Doubles OU Sample Teams</a>`
    ],
    mod: "gen7",
    gameType: "doubles",
    ruleset: ["Standard Doubles", "Swagger Clause"],
    banlist: ["DUber", "Power Construct", "Eevium Z", "Dark Void"]
  },
  {
    name: "[Gen 6] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3606255/">ORAS Doubles OU Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7387213/">ORAS Doubles OU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7387215/">ORAS Doubles OU Sample Teams</a>`
    ],
    mod: "gen6",
    gameType: "doubles",
    ruleset: ["Standard Doubles", "Swagger Clause"],
    banlist: ["DUber", "Soul Dew", "Dark Void"]
  },
  {
    name: "[Gen 5] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3606719/">BW2 Doubles Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7393048/">BW2 Doubles Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7393081/">BW2 Doubles Sample Teams</a>`
    ],
    mod: "gen5",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard", "Evasion Abilities Clause", "Swagger Clause", "Sleep Clause Mod"],
    banlist: ["DUber", "Soul Dew", "Dark Void", "Gravity"]
  },
  {
    name: "[Gen 4] Doubles OU",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3717286/">DPP Doubles</a>`],
    mod: "gen4",
    gameType: "doubles",
    ruleset: ["Standard"],
    banlist: ["AG", "Uber", "Soul Dew", "Dark Void", "Sand Veil"],
    unbanlist: ["Latios", "Manaphy", "Mew", "Salamence", "Wobbuffet", "Wynaut"]
  },
  {
    name: "[Gen 3] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3666831/">ADV Doubles OU</a>`
    ],
    mod: "gen3",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard", "!Switch Priority Clause Mod"],
    banlist: ["Uber", "Soul Dew", "Swagger"],
    unbanlist: ["Latias", "Wobbuffet", "Wynaut"]
  },
  // Sw/Sh Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "Sw/Sh Singles",
    column: 4
  },
  {
    name: "[Gen 8] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3676539/">SS Ubers Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3675564/">SS Ubers Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3675194/">SS Ubers Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Standard", "Dynamax Clause"],
    banlist: ["AG", "Shadow Tag", "Baton Pass"]
  },
  {
    name: "[Gen 8] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3681331/">UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3679621/">UU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3674793/">UU Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] OU"],
    banlist: ["OU", "UUBL", "Light Clay"]
  },
  {
    name: "[Gen 8] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3687060/">RU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3661013/">RU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3676023/">RU Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] UU"],
    banlist: ["UU", "RUBL"]
  },
  {
    name: "[Gen 8] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3687023/">NU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3673598/">NU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3676265/">NU Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] RU"],
    banlist: ["RU", "NUBL", "Drizzle", "Drought", "Slush Rush"]
  },
  {
    name: "[Gen 8] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3707179/">PU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3676106/">PU Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] NU"],
    banlist: ["NU", "PUBL"]
  },
  {
    name: "[Gen 8] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3656348/">SS LC Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3661419/">SS LC Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3657374/">SS LC Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Little Cup", "Standard", "Dynamax Clause"],
    banlist: [
      "Corsola-Galar",
      "Cutiefly",
      "Drifloon",
      "Gastly",
      "Gothita",
      "Magby",
      "Rufflet",
      "Scraggy",
      "Scyther",
      "Sneasel",
      "Swirlix",
      "Tangela",
      "Vullaby",
      "Vulpix-Alola",
      "Woobat",
      "Zigzagoon-Base",
      "Chlorophyll",
      "Moody",
      "Baton Pass",
      "Sticky Web"
    ]
  },
  {
    name: "[Gen 8] Monotype",
    desc: `All the Pok&eacute;mon on a team must share a type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672167/">SS Monotype Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3702647/">SS Monotype Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3673165/">SS Monotype Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Same Type Clause", "Standard", "Dynamax Clause"],
    banlist: [
      "Blaziken",
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Dialga",
      "Dracovish",
      "Eternatus",
      "Genesect",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Kartana",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Landorus-Base",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Mewtwo",
      "Naganadel",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Pheromosa",
      "Rayquaza",
      "Reshiram",
      "Solgaleo",
      "Urshifu-Base",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Zygarde-Base",
      "Moody",
      "Power Construct",
      "Shadow Tag",
      "Damp Rock",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Smooth Rock",
      "Terrain Extender",
      "Acupressure",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 8] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3656364/">SS 1v1 Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3664157/">SS 1v1 Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3657779/">SS 1v1 Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Obtainable",
      "Species Clause",
      "Nickname Clause",
      "OHKO Clause",
      "Evasion Moves Clause",
      "Accuracy Moves Clause",
      "Team Preview",
      "HP Percentage Mod",
      "Cancel Mod",
      "Dynamax Clause",
      "Endless Battle Clause"
    ],
    banlist: [
      "Calyrex-Ice",
      "Calyrex-Shadow",
      "Cinderace",
      "Dialga",
      "Dragonite",
      "Eternatus",
      "Genesect",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Jirachi",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Melmetal",
      "Mew",
      "Mewtwo",
      "Mimikyu",
      "Necrozma",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Rayquaza",
      "Reshiram",
      "Sableye",
      "Snorlax",
      "Solgaleo",
      "Victini",
      "Xerneas",
      "Yveltal",
      "Zacian",
      "Zacian-Crowned",
      "Zamazenta",
      "Zamazenta-Crowned",
      "Zekrom",
      "Moody",
      "Power Construct",
      "Bright Powder",
      "Focus Band",
      "Focus Sash",
      "Lax Incense",
      "Quick Claw",
      "Acupressure",
      "Hypnosis",
      "Perish Song",
      "Sing"
    ]
  },
  {
    name: "[Gen 8] Anything Goes",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672172/">AG Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3675040/">AG Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672899/">AG Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Obtainable", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause"]
  },
  {
    name: "[Gen 8] ZU",
    desc: `The unofficial usage-based tier below PU.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3687415/">ZU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3680071/">ZU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3678037/">ZU Viability Rankings</a>`
    ],
    mod: "gen8",
    // searchShow: false,
    ruleset: ["[Gen 8] PU"],
    banlist: [
      "PU",
      "Arctovish",
      "Aurorus",
      "Basculin",
      "Centiskorch",
      "Drampa",
      "Exeggutor-Alola",
      "Gallade",
      "Glastrier",
      "Haunter",
      "Magmortar",
      "Magneton",
      "Malamar",
      "Ninjask",
      "Omastar",
      "Perrserker",
      "Rotom-Frost",
      "Turtonator",
      "Vanilluxe",
      "Vikavolt",
      "Silvally-Dragon",
      "Silvally-Ground",
      "Sneasel",
      "Damp Rock",
      "Grassy Seed"
    ]
  },
  {
    name: "[Gen 8] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3656824/">CAP Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3671157/">CAP Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3674024/">CAP Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] OU", "+CAP"],
    banlist: ["Crucibellite"]
  },
  {
    name: "[Gen 8] National Dex",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3666135/">SS National Dex Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3667921/">SS National Dex Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3666572/">SS National Dex Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["Standard NatDex", "OHKO Clause", "Evasion Clause", "Species Clause", "Dynamax Clause", "Sleep Clause Mod"],
    banlist: ["ND Uber", "Arena Trap", "Moody", "Power Construct", "Shadow Tag", "King's Rock", "Razor Fang", "Quick Claw", "Baton Pass"]
  },
  {
    name: "[Gen 8] National Dex UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3660920/">National Dex UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672486/">National Dex UU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3672482/">National Dex UU Viability Rankings</a>`
    ],
    mod: "gen8",
    searchShow: false,
    ruleset: ["[Gen 8] National Dex"],
    banlist: ["ND OU", "ND UUBL", "Drizzle", "Drought", "Light Clay", "Slowbronite"]
  },
  {
    name: "[Gen 8 BDSP] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3693629/">BDSP OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3693721/">BDSP OU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3696088/">BDSP OU Viability Rankings</a>`
    ],
    mod: "gen8bdsp",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber", "Arena Trap", "Drizzle", "Moody", "Sand Veil", "Shadow Tag", "Snow Cloak", "King's Rock", "Razor Fang", "Baton Pass"]
  },
  {
    name: "[Gen 8] Battle Stadium Singles",
    mod: "gen8",
    searchShow: false,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 8", "VGC Timer", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"]
  },
  {
    name: "[Gen 8] Custom Game",
    mod: "gen8",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // Sw/Sh Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "Sw/Sh Doubles",
    column: 5
  },
  {
    name: "[Gen 8] Doubles Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3661142/">Doubles Ubers</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Doubles", "!Gravity Sleep Clause"],
    banlist: []
  },
  {
    name: "[Gen 8] Doubles UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3658504/">Doubles UU</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["[Gen 8] Doubles OU"],
    banlist: ["DOU", "DBL"]
  },
  {
    name: "[Gen 8] VGC 2022",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3677186/">VGC 2022 Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3695848/">VGC 2022 Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3696395/">VGC 2022 Viability Rankings</a>`
    ],
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 8", "VGC Timer", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"]
  },
  {
    name: "[Gen 8] VGC 2021",
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 8", "VGC Timer"]
  },
  {
    name: "[Gen 8] VGC 2020",
    mod: "gen8dlc1",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 8", "VGC Timer"]
  },
  {
    name: "[Gen 8 BDSP] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3693891/">BDSP Doubles OU</a>`
    ],
    mod: "gen8bdsp",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Doubles"],
    banlist: ["DUber", "Dark Void"]
  },
  {
    name: "[Gen 8 BDSP] Battle Festival Doubles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3694269/">Battle Festival Doubles</a>`
    ],
    mod: "gen8bdsp",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 8"]
  },
  {
    name: "[Gen 8] Doubles Custom Game",
    mod: "gen8",
    gameType: "doubles",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // US/UM Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "US/UM Singles",
    column: 5
  },
  {
    name: "[Gen 7] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8286276/">USM Ubers</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["Standard", "Mega Rayquaza Clause"],
    banlist: ["Baton Pass"]
  },
  {
    name: "[Gen 7] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3621217/">USM UU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3641346/">USM UU Viability Rankings</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] OU"],
    banlist: ["OU", "UUBL", "Drizzle", "Drought", "Kommonium Z", "Mewnium Z"]
  },
  {
    name: "[Gen 7] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3645338/">USM RU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3645873/">USM RU Viability Rankings</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] UU"],
    banlist: ["UU", "RUBL", "Mimikyu", "Aurora Veil"],
    unbanlist: ["Drought"]
  },
  {
    name: "[Gen 7] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3632667/">USM NU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3645166/">USM NU Viability Rankings</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] RU"],
    banlist: ["RU", "NUBL", "Drought"]
  },
  {
    name: "[Gen 7] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3611496/">USM PU Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3614892/">USM PU Viability Rankings</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] NU"],
    banlist: ["NU", "PUBL"]
  },
  {
    name: "[Gen 7] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/sm/formats/lc/">USM LC Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3639319/">USM LC Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3621440/">USM LC Viability Rankings</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["Little Cup", "Standard", "Swagger Clause"],
    banlist: [
      "Aipom",
      "Cutiefly",
      "Drifloon",
      "Gligar",
      "Gothita",
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Porygon",
      "Scyther",
      "Sneasel",
      "Swirlix",
      "Tangela",
      "Trapinch",
      "Vulpix-Base",
      "Wingull",
      "Yanma",
      "Eevium Z",
      "Baton Pass",
      "Dragon Rage",
      "Sonic Boom",
      "Sticky Web"
    ]
  },
  {
    name: "[Gen 7] Monotype",
    desc: `All the Pok&eacute;mon on a team must share a type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8411581/">USM Monotype</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["Same Type Clause", "Standard", "Swagger Clause"],
    banlist: [
      "Aegislash",
      "Arceus",
      "Blaziken",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Dialga",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Kangaskhan-Mega",
      "Kartana",
      "Kyogre",
      "Kyurem-White",
      "Lucario-Mega",
      "Lugia",
      "Lunala",
      "Magearna",
      "Marshadow",
      "Mawile-Mega",
      "Medicham-Mega",
      "Metagross-Mega",
      "Mewtwo",
      "Naganadel",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Pheromosa",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Solgaleo",
      "Tapu Lele",
      "Xerneas",
      "Yveltal",
      "Zekrom",
      "Zygarde",
      "Battle Bond",
      "Shadow Tag",
      "Damp Rock",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Smooth Rock",
      "Terrain Extender",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 7] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031460/">USUM 1v1</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Obtainable",
      "Species Clause",
      "Nickname Clause",
      "OHKO Clause",
      "Swagger Clause",
      "Evasion Moves Clause",
      "Accuracy Moves Clause",
      "Team Preview",
      "HP Percentage Mod",
      "Cancel Mod",
      "Endless Battle Clause"
    ],
    banlist: [
      "Arceus",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Defense",
      "Dialga",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Kangaskhan-Mega",
      "Kyogre",
      "Kyurem-Black",
      "Kyurem-White",
      "Lugia",
      "Lunala",
      "Marshadow",
      "Mew",
      "Mewtwo",
      "Mimikyu",
      "Necrozma-Dawn-Wings",
      "Necrozma-Dusk-Mane",
      "Palkia",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Snorlax",
      "Solgaleo",
      "Tapu Koko",
      "Xerneas",
      "Yveltal",
      "Zekrom",
      "Moody",
      "Focus Sash",
      "Grass Whistle",
      "Hypnosis",
      "Perish Song",
      "Sing",
      "Detect + Fightinium Z"
    ]
  },
  {
    name: "[Gen 7] Anything Goes",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3587441/">Anything Goes Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3591711/">Anything Goes Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3646736/">Anything Goes Sample Teams</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["Obtainable", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Endless Battle Clause"]
  },
  {
    name: "[Gen 7] ZU",
    desc: `The unofficial usage-based tier below PU.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3646743/">ZU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3643412/">ZU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3646739/">ZU Sample Teams</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] PU"],
    banlist: [
      "PU",
      "Carracosta",
      "Crabominable",
      "Exeggutor-Base",
      "Gorebyss",
      "Jynx",
      "Raticate-Alola",
      "Shiftry",
      "Throh",
      "Turtonator",
      "Type: Null",
      "Ursaring",
      "Victreebel"
    ]
  },
  {
    name: "[Gen 7] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3621207/">USUM CAP Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8691482/">USUM CAP Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8691484/">USUM CAP Sample Teams</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["[Gen 7] OU", "+CAP"]
  },
  {
    name: "[Gen 7] Battle Spot Singles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3601012/">Introduction to Battle Spot Singles</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3605970/">Battle Spot Singles Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3601658/">Battle Spot Singles Role Compendium</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3619162/">Battle Spot Singles Sample Teams</a>`
    ],
    mod: "gen7",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Battle Bond"]
  },
  {
    name: "[Gen 7 Let's Go] OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3667865/">LGPE OU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3656868/">LGPE OU Viability Rankings</a>`
    ],
    mod: "gen7letsgo",
    searchShow: false,
    ruleset: ["Adjust Level = 50", "Obtainable", "Species Clause", "Nickname Clause", "OHKO Clause", "Evasion Moves Clause", "Team Preview", "HP Percentage Mod", "Cancel Mod", "Sleep Clause Mod"],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 7] Custom Game",
    mod: "gen7",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // US/UM Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "US/UM Doubles",
    column: 5
  },
  {
    name: "[Gen 7] Doubles UU",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3598014/">Doubles UU Metagame Discussion</a>`],
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["[Gen 7] Doubles OU"],
    banlist: ["DOU", "DBL"]
  },
  {
    name: "[Gen 7] VGC 2019",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3641100/">VGC 2019 Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3641123/">VGC 2019 Viability Rankings</a>`
    ],
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 7", "VGC Timer", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"],
    banlist: ["Unown", "Battle Bond"]
  },
  {
    name: "[Gen 7] VGC 2018",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3631800/">VGC 2018 Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3622041/">VGC 2018 Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3628885/">VGC 2018 Sample Teams</a>`
    ],
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    timer: {
      starting: 5 * 60,
      addPerTurn: 0,
      maxPerTurn: 55,
      maxFirstTurn: 90,
      grace: 90,
      timeoutAutoChoose: true,
      dcTimerBank: false
    },
    ruleset: ["Flat Rules", "!! Adjust Level = 50", "Min Source Gen = 7"],
    banlist: ["Oranguru + Symbiosis", "Passimian + Defiant", "Unown", "Custap Berry", "Enigma Berry", "Jaboca Berry", "Micle Berry", "Rowap Berry", "Battle Bond"]
  },
  {
    name: "[Gen 7] VGC 2017",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3583926/">VGC 2017 Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3591794/">VGC 2017 Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3590391/">VGC 2017 Sample Teams</a>`
    ],
    mod: "gen7sm",
    gameType: "doubles",
    searchShow: false,
    timer: {
      starting: 15 * 60,
      addPerTurn: 0,
      maxPerTurn: 55,
      maxFirstTurn: 90,
      grace: 90,
      timeoutAutoChoose: true,
      dcTimerBank: false
    },
    ruleset: ["Flat Rules", "Old Alola Pokedex", "!! Adjust Level = 50", "Min Source Gen = 7"],
    banlist: ["Mega", "Custap Berry", "Enigma Berry", "Jaboca Berry", "Micle Berry", "Rowap Berry"]
  },
  {
    name: "[Gen 7] Battle Spot Doubles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3595001/">Battle Spot Doubles Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3593890/">Battle Spot Doubles Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3595859/">Battle Spot Doubles Sample Teams</a>`
    ],
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Battle Bond"]
  },
  {
    name: "[Gen 7 Let's Go] Doubles OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3671748/#post-8685222">LGPE Doubles OU</a>`
    ],
    mod: "gen7letsgo",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Standard Doubles", "Sleep Clause Mod"],
    banlist: ["Mewtwo"]
  },
  {
    name: "[Gen 7] Doubles Custom Game",
    mod: "gen7",
    gameType: "doubles",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // OR/AS Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "OR/AS Singles",
    column: 6
  },
  {
    name: "[Gen 6] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8286277/">ORAS Ubers</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["Standard", "Swagger Clause", "Mega Rayquaza Clause"]
  },
  {
    name: "[Gen 6] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/formats/uu/">ORAS UU Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3598164/">ORAS UU Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] OU"],
    banlist: ["OU", "UUBL", "Drizzle", "Drought"]
  },
  {
    name: "[Gen 6] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/tags/ru/">ORAS RU Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3574583/">ORAS RU Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] UU"],
    banlist: ["UU", "RUBL"]
  },
  {
    name: "[Gen 6] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/tags/nu/">ORAS NU Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3555650/">ORAS NU Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] RU"],
    banlist: ["RU", "NUBL"]
  },
  {
    name: "[Gen 6] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/tags/pu/">ORAS PU Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3528743/">ORAS PU Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] NU"],
    banlist: ["NU", "PUBL", "Chatter"]
  },
  {
    name: "[Gen 6] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/formats/lc/">ORAS LC Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3547566/">ORAS LC Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["Standard", "Little Cup"],
    banlist: [
      "Drifloon",
      "Gligar",
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Scyther",
      "Sneasel",
      "Swirlix",
      "Tangela",
      "Yanma",
      "Baton Pass",
      "Dragon Rage",
      "Sonic Boom",
      "Swagger"
    ]
  },
  {
    name: "[Gen 6] Monotype",
    desc: `All the Pok&eacute;mon on a team must share a type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8411583/">ORAS Monotype</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["Standard", "Swagger Clause", "Same Type Clause"],
    banlist: [
      "Aegislash",
      "Altaria-Mega",
      "Arceus",
      "Blaziken",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Speed",
      "Dialga",
      "Genesect",
      "Gengar-Mega",
      "Giratina",
      "Giratina-Origin",
      "Greninja",
      "Groudon",
      "Ho-Oh",
      "Hoopa-Unbound",
      "Kangaskhan-Mega",
      "Kyogre",
      "Kyurem-White",
      "Lucario-Mega",
      "Lugia",
      "Mawile-Mega",
      "Medicham-Mega",
      "Metagross-Mega",
      "Mewtwo",
      "Palkia",
      "Rayquaza",
      "Reshiram",
      "Sableye-Mega",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Slowbro-Mega",
      "Talonflame",
      "Xerneas",
      "Yveltal",
      "Zekrom",
      "Shadow Tag",
      "Damp Rock",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Razor Fang",
      "Smooth Rock",
      "Soul Dew",
      "Baton Pass"
    ]
  },
  {
    name: "[Gen 6] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031459/">ORAS 1v1</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: [
      "Max Team Size = 3",
      "Picked Team Size = 1",
      "Obtainable",
      "Nickname Clause",
      "Moody Clause",
      "OHKO Clause",
      "Evasion Moves Clause",
      "Accuracy Moves Clause",
      "Swagger Clause",
      "Endless Battle Clause",
      "HP Percentage Mod",
      "Cancel Mod",
      "Team Preview"
    ],
    banlist: [
      "Arceus",
      "Blaziken",
      "Charizard-Mega-Y",
      "Darkrai",
      "Deoxys-Base",
      "Deoxys-Attack",
      "Deoxys-Defense",
      "Dialga",
      "Giratina",
      "Giratina-Origin",
      "Groudon",
      "Ho-Oh",
      "Kangaskhan-Mega",
      "Kyogre",
      "Kyurem-White",
      "Lugia",
      "Mewtwo",
      "Palkia",
      "Rayquaza",
      "Reshiram",
      "Salamence-Mega",
      "Shaymin-Sky",
      "Snorlax",
      "Xerneas",
      "Yveltal",
      "Zekrom",
      "Focus Sash",
      "Soul Dew",
      "Grass Whistle",
      "Hypnosis",
      "Perish Song",
      "Sing",
      "Yawn"
    ]
  },
  {
    name: "[Gen 6] Anything Goes",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3523229/">ORAS Anything Goes</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3548945/">ORAS AG Resources</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["Obtainable", "Team Preview", "Endless Battle Clause", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 6] ZU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dex/xy/formats/zu/">ORAS ZU Banlist</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8034679/">ORAS ZU Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] PU"],
    banlist: ["PU", "Fraxure", "Regigigas", "Simisear"]
  },
  {
    name: "[Gen 6] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3537407/">ORAS CAP Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8752281/">ORAS CAP Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8752280/">ORAS CAP Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["[Gen 6] OU", "+CAP"],
    banlist: ["Cawmodore"]
  },
  {
    name: "[Gen 6] Battle Spot Singles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3527960/">ORAS Battle Spot Singles</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3554616/">ORAS BSS Viability Rankings</a>`
    ],
    mod: "gen6",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Soul Dew"]
  },
  {
    name: "[Gen 6] Custom Game",
    mod: "gen6",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // OR/AS Doubles/Triples
  ///////////////////////////////////////////////////////////////////
  {
    section: "OR/AS Doubles/Triples",
    column: 6
  },
  {
    name: "[Gen 6] VGC 2016",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3558332/">VGC 2016 Rules</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3580592/">VGC 2016 Viability Rankings</a>`
    ],
    mod: "gen6",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 6", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"],
    banlist: ["Soul Dew"]
  },
  {
    name: "[Gen 6] VGC 2015",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3524352/">VGC 2015 Rules</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3560820/">ORAS Battle Spot Doubles Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3530547/">VGC 2015 Viability Rankings</a>`
    ],
    mod: "gen6",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Soul Dew", "Articuno + Snow Cloak", "Zapdos + Static", "Moltres + Flame Body", "Dragonite + Barrier"]
  },
  {
    name: "[Gen 6] VGC 2014",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3493272/">VGC 2014 Rules</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3507789/">VGC 2014 Viability Rankings</a>`
    ],
    mod: "gen6xy",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Kalos Pokedex", "Min Source Gen = 6"]
  },
  {
    name: "[Gen 6] Battle Spot Doubles",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3560820/">ORAS Battle Spot Doubles Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3560824/">ORAS BSD Viability Rankings</a>`
    ],
    mod: "gen6",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 6"],
    banlist: ["Soul Dew"]
  },
  {
    name: "[Gen 6] Doubles Custom Game",
    mod: "gen6",
    gameType: "doubles",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 6] Battle Spot Triples",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3533914/">ORAS Battle Spot Triples Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3549201/">ORAS BST Viability Rankings</a>`
    ],
    mod: "gen6",
    gameType: "triples",
    searchShow: false,
    ruleset: ["Flat Rules", "Min Source Gen = 6"]
  },
  {
    name: "[Gen 6] Triples Custom Game",
    mod: "gen6",
    gameType: "triples",
    searchShow: false,
    battle: { trunc: Math.trunc },
    debug: true,
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // B2/W2 Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "B2/W2 Singles",
    column: 6
  },
  {
    name: "[Gen 5] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8286278/">BW2 Ubers</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["Standard", "Sleep Clause Mod"]
  },
  {
    name: "[Gen 5] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3474024/">BW2 UU Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/6431094/">BW2 Sample Teams</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["Standard", "Evasion Abilities Clause", "Swagger Clause", "Sleep Clause Mod"],
    banlist: ["Uber", "OU", "UUBL", "Arena Trap", "Drought", "Sand Stream", "Snow Warning", "Prankster + Assist", "Prankster + Copycat", "Baton Pass"]
  },
  {
    name: "[Gen 5] RU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/6431094/">BW2 Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3473124/">BW2 RU Viability Rankings</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] UU", "Baton Pass Clause", "!Sleep Clause Mod", "Sleep Moves Clause"],
    banlist: ["UU", "RUBL", "Shadow Tag", "Shell Smash + Baton Pass"],
    unbanlist: ["Prankster + Assist", "Prankster + Copycat", "Baton Pass"]
  },
  {
    name: "[Gen 5] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/6431094/">BW2 Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3484121/">BW2 NU Viability Rankings</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] RU", "!Sleep Moves Clause", "Sleep Clause Mod"],
    banlist: ["RU", "NUBL", "Assist", "Copycat"]
  },
  {
    name: "[Gen 5] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/7326932/">BW2 PU</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] NU", "Sleep Moves Clause"],
    banlist: ["NU", "PUBL", "Damp Rock"]
  },
  {
    name: "[Gen 5] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/6431094/">BW2 Sample Teams</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3485860/">BW2 LC Viability Rankings</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["Standard", "Little Cup", "Sleep Moves Clause"],
    banlist: [
      "Gligar",
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Scraggy",
      "Scyther",
      "Sneasel",
      "Tangela",
      "Vulpix",
      "Yanma",
      "Sand Rush",
      "Sand Veil",
      "Berry Juice",
      "Soul Dew",
      "Baton Pass",
      "Dragon Rage",
      "Sonic Boom",
      "Swagger"
    ]
  },
  {
    name: "[Gen 5] Monotype",
    desc: `All the Pok&eacute;mon on a team must share a type.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8411584/">BW2 Monotype</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] OU", "Same Type Clause", "!Gems Clause"],
    banlist: ["Latios"]
  },
  {
    name: "[Gen 5] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031458/">BW2 1v1</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "Standard",
      "Baton Pass Clause",
      "Swagger Clause",
      "Accuracy Moves Clause",
      "Sleep Moves Clause"
    ],
    banlist: ["Uber", "Cottonee", "Dragonite", "Jirachi", "Kyurem-Black", "Mew", "Togekiss", "Whimsicott", "Victini", "Focus Band", "Focus Sash", "Quick Claw", "Soul Dew", "Perish Song"],
    unbanlist: ["Genesect", "Landorus", "Manaphy", "Thundurus", "Tornadus-Therian"]
  },
  {
    name: "[Gen 5] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8967093/">BW2 CAP Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8969768/">BW2 CAP Sample Teams</a>`
    ],
    mod: "gen5",
    searchShow: false,
    ruleset: ["[Gen 5] OU", "+CAP"],
    banlist: ["Aurumoth", "Cawmodore"]
  },
  {
    name: "[Gen 5] GBU Singles",
    mod: "gen5",
    searchShow: false,
    ruleset: ["Flat Rules"],
    banlist: ["Dark Void", "Sky Drop", "Soul Dew"]
  },
  {
    name: "[Gen 5] Custom Game",
    mod: "gen5",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // B2/W2 Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "B2/W2 Doubles",
    column: 6
  },
  {
    name: "[Gen 5] VGC 2013",
    mod: "gen5",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules"],
    banlist: ["Chatot", "Dark Void", "Sky Drop", "Soul Dew"]
  },
  {
    name: "[Gen 5] VGC 2012",
    mod: "gen5bw1",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules"],
    banlist: ["Dark Void", "Sky Drop"]
  },
  {
    name: "[Gen 5] VGC 2011",
    mod: "gen5bw1",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Old Unova Pokedex"],
    banlist: ["Sky Drop", "Belue Berry", "Durin Berry", "Nomel Berry", "Rabuta Berry", "Spelon Berry", "Watmel Berry"]
  },
  {
    name: "[Gen 5] Doubles Custom Game",
    mod: "gen5",
    gameType: "doubles",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 5] Triples Custom Game",
    mod: "gen5",
    gameType: "triples",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions, for serious (other than team preview)
    ruleset: ["Team Preview", "Cancel Mod"]
  },
  // DPP Singles
  ///////////////////////////////////////////////////////////////////
  {
    section: "DPP Singles",
    column: 7
  },
  {
    name: "[Gen 4] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8286279/">DPP Ubers</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["AG"]
  },
  {
    name: "[Gen 4] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3583742/">DPP NU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3512254/">DPP NU Viability Rankings</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["[Gen 4] UU", "Baton Pass Clause"],
    banlist: ["UU", "NUBL"],
    unbanlist: ["Sand Veil", "Baton Pass"]
  },
  {
    name: "[Gen 4] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/7260264/">DPP PU</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["[Gen 4] NU"],
    banlist: [
      "Articuno",
      "Cacturne",
      "Charizard",
      "Cradily",
      "Dodrio",
      "Drifblim",
      "Dusclops",
      "Electrode",
      "Floatzel",
      "Gardevoir",
      "Gligar",
      "Golem",
      "Grumpig",
      "Haunter",
      "Hitmonchan",
      "Hypno",
      "Jumpluff",
      "Jynx",
      "Lickilicky",
      "Linoone",
      "Magmortar",
      "Magneton",
      "Manectric",
      "Medicham",
      "Meganium",
      "Nidoqueen",
      "Ninetales",
      "Piloswine",
      "Poliwrath",
      "Porygon2",
      "Regice",
      "Regirock",
      "Roselia",
      "Sandslash",
      "Sharpedo",
      "Shiftry",
      "Skuntank",
      "Slowking",
      "Tauros",
      "Typhlosion",
      "Venomoth",
      "Vileplume"
    ]
  },
  {
    name: "[Gen 4] LC",
    threads: [
      `&bullet; <a href="https://www.smogon.com/dp/articles/little_cup_guide">DPP LC Guide</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/7336500/">DPP LC Viability Rankings</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["Standard", "Little Cup", "Sleep Moves Clause"],
    banlist: [
      "Meditite",
      "Misdreavus",
      "Murkrow",
      "Scyther",
      "Sneasel",
      "Tangela",
      "Yanma",
      "Berry Juice",
      "Deep Sea Tooth",
      "Dragon Rage",
      "Sonic Boom",
      "Swagger"
    ]
  },
  {
    name: "[Gen 4] Anything Goes",
    mod: "gen4",
    searchShow: false,
    ruleset: ["Obtainable", "Arceus EV Limit", "Endless Battle Clause", "HP Percentage Mod", "Cancel Mod"]
  },
  {
    name: "[Gen 4] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031457/">DPP 1v1</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "[Gen 4] OU",
      "Accuracy Moves Clause",
      "Sleep Moves Clause",
      "Team Preview",
      "!Freeze Clause Mod"
    ],
    banlist: ["Latias", "Machamp", "Porygon-Z", "Shaymin", "Snorlax", "Togekiss", "Focus Sash", "Destiny Bond", "Explosion", "Perish Song", "Self-Destruct"],
    unbanlist: ["Wobbuffet", "Wynaut", "Sand Veil", "Swagger"]
  },
  {
    name: "[Gen 4] ZU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8034681/">DPP ZU</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["[Gen 4] PU"],
    banlist: [
      "Ampharos",
      "Armaldo",
      "Bellossom",
      "Dragonair",
      "Electabuzz",
      "Gabite",
      "Gastrodon",
      "Glaceon",
      "Glalie",
      "Golduck",
      "Gorebyss",
      "Hippopotas",
      "Kadabra",
      "Kingler",
      "Lapras",
      "Machoke",
      "Magmar",
      "Mantine",
      "Marowak",
      "Metang",
      "Misdreavus",
      "Monferno",
      "Mr. Mime",
      "Muk",
      "Murkrow",
      "Pinsir",
      "Politoed",
      "Purugly",
      "Quagsire",
      "Raichu",
      "Rampardos",
      "Rapidash",
      "Regigigas",
      "Relicanth",
      "Rhydon",
      "Scyther",
      "Sneasel",
      "Snover",
      "Solrock",
      "Tangela",
      "Torkoal",
      "Victreebel",
      "Xatu",
      "Walrein",
      "Zangoose",
      "Damp Rock"
    ]
  },
  {
    name: "[Gen 4] CAP",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8851251/">DPP CAP Viability Rankings</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/posts/8869378/">DPP CAP Sample Teams</a>`
    ],
    mod: "gen4",
    searchShow: false,
    ruleset: ["[Gen 4] OU", "+CAP"]
  },
  {
    name: "[Gen 4] Custom Game",
    mod: "gen4",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions
    ruleset: ["Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // DPP Doubles
  ///////////////////////////////////////////////////////////////////
  {
    section: "DPP Doubles",
    column: 7
  },
  {
    name: "[Gen 4] VGC 2010",
    mod: "gen4",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "Max Team Size = 4", "Limit Two Restricted"],
    restricted: ["Restricted Legendary"],
    banlist: ["Soul Dew"]
  },
  {
    name: "[Gen 4] VGC 2009",
    mod: "gen4pt",
    gameType: "doubles",
    searchShow: false,
    ruleset: ["Flat Rules", "! Adjust Level Down", "Max Level = 50", "Max Team Size = 4"],
    banlist: ["Tyranitar", "Rotom", "Judgment", "Soul Dew"]
  },
  {
    name: "[Gen 4] Doubles Custom Game",
    mod: "gen4",
    gameType: "doubles",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    // no restrictions
    ruleset: ["Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  // Past Generations
  ///////////////////////////////////////////////////////////////////
  {
    section: "Past Generations",
    column: 7
  },
  {
    name: "[Gen 3] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8286280/">ADV Ubers</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: ["Standard", "Deoxys Camouflage Clause", "One Baton Pass Clause"],
    banlist: ["Wobbuffet + Leftovers"]
  },
  {
    name: "[Gen 3] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3585923/">ADV UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3548578/">ADV UU Viability Rankings</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber", "OU", "UUBL", "Smeargle + Ingrain", "Arena Trap", "Baton Pass", "Swagger"]
  },
  {
    name: "[Gen 3] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3503540/">ADV NU Viability Rankings</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber", "OU", "UUBL", "UU", "Smeargle + Ingrain"]
  },
  {
    name: "[Gen 3] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/9395926">ADV PU</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber", "OU", "UUBL", "UU", "NUBL", "NU"]
  },
  {
    name: "[Gen 3] 1v1",
    desc: `Bring three Pok&eacute;mon to Team Preview and choose one to battle.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031456/">ADV 1v1</a>`
    ],
    mod: "gen3",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "[Gen 3] OU",
      "Accuracy Moves Clause",
      "Sleep Moves Clause",
      "Team Preview",
      "!Freeze Clause Mod"
    ],
    banlist: [
      "Clefable",
      "Slaking",
      "Snorlax",
      "Suicune",
      "Zapdos",
      "Destiny Bond",
      "Explosion",
      "Ingrain",
      "Perish Song",
      "Self-Destruct",
      "Focus Band",
      "King's Rock",
      "Quick Claw"
    ],
    unbanlist: ["Mr. Mime", "Wobbuffet", "Wynaut", "Sand Veil", "Soundproof"]
  },
  {
    name: "[Gen 3] Custom Game",
    mod: "gen3",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 3] Doubles Custom Game",
    mod: "gen3",
    gameType: "doubles",
    searchShow: false,
    debug: true,
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 2] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8286282/">GSC Ubers</a>`
    ],
    mod: "gen2",
    searchShow: false,
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 2] UU",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3576710/">GSC UU</a>`],
    mod: "gen2",
    searchShow: false,
    ruleset: ["[Gen 2] OU"],
    banlist: ["OU", "UUBL", "Agility + Baton Pass"],
    unbanlist: ["Mean Look + Baton Pass", "Spider Web + Baton Pass"]
  },
  {
    name: "[Gen 2] NU",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/threads/3642565/">GSC NU</a>`],
    mod: "gen2",
    searchShow: false,
    ruleset: ["[Gen 2] UU"],
    banlist: ["UU", "NUBL"],
    unbanlist: ["Agility + Baton Pass"]
  },
  {
    name: "[Gen 2] 1v1",
    threads: [`&bullet; <a href="https://www.smogon.com/forums/posts/8031463/">GSC 1v1</a>`],
    mod: "gen2",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "[Gen 2] OU",
      "Accuracy Moves Clause",
      "Sleep Moves Clause",
      "Team Preview"
    ],
    banlist: [
      "Alakazam",
      "Clefable",
      "Snorlax",
      "Zapdos",
      "Berserk Gene",
      "Focus Band",
      "King's Rock",
      "Quick Claw",
      "Attract",
      "Destiny Bond",
      "Explosion",
      "Perish Song",
      "Present",
      "Self-Destruct",
      "Swagger"
    ]
  },
  {
    name: "[Gen 2] Nintendo Cup 2000",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3682691/">Nintendo Cup 2000 Resource Hub</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3677370/">Differences between Nintendo Cup 2000 and GSC OU</a>`
    ],
    mod: "gen2stadium2",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 3",
      "Min Level = 50",
      "Max Level = 55",
      "Max Total Level = 155",
      "Obtainable",
      "Stadium Sleep Clause",
      "Freeze Clause Mod",
      "Species Clause",
      "Item Clause",
      "Endless Battle Clause",
      "Cancel Mod",
      "Event Moves Clause",
      "Nickname Clause",
      "Team Preview",
      "Nintendo Cup 2000 Move Legality"
    ],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 2] Stadium OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3677370/">Placeholder</a>`
    ],
    mod: "gen2stadium2",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 2] Custom Game",
    mod: "gen2",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  },
  {
    name: "[Gen 1] Ubers",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8286283/">RBY Ubers</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: ["Standard"]
  },
  {
    name: "[Gen 1] UU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3573896/">RBY UU Metagame Discussion</a>`,
      `&bullet; <a href="https://www.smogon.com/forums/threads/3647713/">RBY UU Viability Rankings</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: ["[Gen 1] OU", "APT Clause", "Sleep Moves Clause"],
    banlist: ["OU", "UUBL"]
  },
  {
    name: "[Gen 1] NU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3679758/">RBY NU Metagame Discussion &amp; Resources</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: ["[Gen 1] UU", "!APT Clause", "!Sleep Moves Clause"],
    banlist: ["UU", "NUBL"]
  },
  {
    name: "[Gen 1] PU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3700527/">RBY PU Metagame Discussion &amp; Resources</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: ["[Gen 1] NU"],
    banlist: ["NU", "PUBL"]
  },
  {
    name: "[Gen 1] 1v1",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/posts/8031468">RBY 1v1</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 1",
      "Max Team Size = 3",
      "[Gen 1] OU",
      "Accuracy Moves Clause",
      "Sleep Moves Clause",
      "Team Preview"
    ],
    banlist: ["Bind", "Clamp", "Explosion", "Fire Spin", "Self-Destruct", "Wrap"]
  },
  {
    name: "[Gen 1] Japanese OU",
    desc: `Generation 1 with Japanese battle mechanics.`,
    mod: "gen1jpn",
    searchShow: false,
    ruleset: ["Standard"],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 1] Nintendo Cup 1997",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3682412/">Nintendo Cup 1997 Discussion &amp; Resources</a>`
    ],
    mod: "gen1jpn",
    searchShow: false,
    ruleset: [
      "Picked Team Size = 3",
      "Min Level = 50",
      "Max Level = 55",
      "Max Total Level = 155",
      "Obtainable",
      "Team Preview",
      "Stadium Sleep Clause",
      "Species Clause",
      "Nickname Clause",
      "HP Percentage Mod",
      "Cancel Mod",
      "Nintendo Cup 1997 Move Legality"
    ],
    banlist: ["Uber"]
  },
  {
    name: "[Gen 1] Stadium OU",
    threads: [
      `&bullet; <a href="https://www.smogon.com/forums/threads/3685877/">Stadium OU Viability Rankings</a>`
    ],
    mod: "gen1stadium",
    searchShow: false,
    ruleset: ["Standard", "Team Preview"],
    banlist: [
      "Uber",
      "Nidoking + Fury Attack + Thrash",
      "Exeggutor + Poison Powder + Stomp",
      "Exeggutor + Sleep Powder + Stomp",
      "Exeggutor + Stun Spore + Stomp",
      "Jolteon + Focus Energy + Thunder Shock",
      "Flareon + Focus Energy + Ember"
    ]
  },
  {
    name: "[Gen 1] Tradebacks OU",
    desc: `RBY OU with movepool additions from the Time Capsule.`,
    threads: [
      `&bullet; <a href="https://www.smogon.com/articles/rby-tradebacks-ou">RBY Tradebacks OU</a>`
    ],
    mod: "gen1",
    searchShow: false,
    ruleset: ["[Gen 1] OU", "Allow Tradeback"]
  },
  {
    name: "[Gen 1] Custom Game",
    mod: "gen1",
    searchShow: false,
    debug: true,
    battle: { trunc: Math.trunc },
    ruleset: ["HP Percentage Mod", "Cancel Mod", "Desync Clause Mod", "Max Team Size = 24", "Max Move Count = 24", "Max Level = 9999", "Default Level = 100"]
  }
];
//# sourceMappingURL=formats.js.map
