/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client.model;

import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2350;
import net.minecraft.class_777;

public class QuadUtils {
    private static final float ROTATION_ANGLE = -45.0f;
    private static final float SCALE_ROTATION_45 = 1.0f / (float)Math.cos(0.7853981633974483) - 1.0f;
    private static final class_1160 ROTATION_ORIGIN = new class_1160(0.5f, 0.5f, 0.5f);
    private static final class_1159 ROTATION_MATRIX = new class_1159(new class_1158(new class_1160(0.0f, 1.0f, 0.0f), -45.0f, true));

    public static class_777 duplicateQuad(class_777 quad) {
        int[] vertexData = new int[quad.method_3357().length];
        System.arraycopy(quad.method_3357(), 0, vertexData, 0, vertexData.length);
        return new class_777(vertexData, quad.method_3359(), quad.method_3358(), quad.method_35788(), quad.method_24874());
    }

    public static void rotateQuad(class_777 quad, class_2350 dir) {
        class_1160 scaleMult = new class_1160((float)dir.method_10148(), 1.0f, (float)dir.method_10165());
        scaleMult.method_23848(Math::abs);
        class_1160 scaleVec = new class_1160(1.0f, 0.0f, 1.0f);
        scaleVec.method_4942(SCALE_ROTATION_45);
        scaleVec.method_23849(scaleMult.method_4943(), scaleMult.method_4945(), scaleMult.method_4947());
        scaleVec.method_4948(1.0f, 1.0f, 1.0f);
        int[] vertexData = quad.method_3357();
        float[][] pos = QuadUtils.unpackQuadPosition(vertexData);
        for (int i = 0; i < 4; ++i) {
            class_1162 vector4f = new class_1162(pos[i][0] - ROTATION_ORIGIN.method_4943(), pos[i][1] - ROTATION_ORIGIN.method_4945(), pos[i][2] - ROTATION_ORIGIN.method_4947(), 1.0f);
            vector4f.method_4954(scaleVec);
            vector4f.method_22674(ROTATION_MATRIX);
            pos[i][0] = vector4f.method_4953() + ROTATION_ORIGIN.method_4943();
            pos[i][1] = vector4f.method_4956() + ROTATION_ORIGIN.method_4945();
            pos[i][2] = vector4f.method_4957() + ROTATION_ORIGIN.method_4947();
        }
        QuadUtils.packQuadPositions(vertexData, pos);
        QuadUtils.fillNormal(vertexData, pos);
    }

    public static float[][] unpackQuadPosition(int[] vertexData) {
        float[][] pos = new float[4][3];
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int offset = i * step;
            pos[i][0] = Float.intBitsToFloat(vertexData[offset]);
            pos[i][1] = Float.intBitsToFloat(vertexData[offset + 1]);
            pos[i][2] = Float.intBitsToFloat(vertexData[offset + 2]);
        }
        return pos;
    }

    public static void packQuadPositions(int[] vertexData, float[][] pos) {
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int offset = i * step;
            vertexData[offset] = Float.floatToIntBits(pos[i][0]);
            vertexData[offset + 1] = Float.floatToIntBits(pos[i][1]);
            vertexData[offset + 2] = Float.floatToIntBits(pos[i][2]);
        }
    }

    public static void fillNormal(int[] vertexData, float[][] pos) {
        class_1160 v1 = new class_1160(pos[3][0], pos[3][1], pos[3][2]);
        class_1160 t1 = new class_1160(pos[1][0], pos[1][1], pos[1][2]);
        class_1160 v2 = new class_1160(pos[2][0], pos[2][1], pos[2][2]);
        class_1160 t2 = new class_1160(pos[0][0], pos[0][1], pos[0][2]);
        v1.method_4944(t1);
        v2.method_4944(t2);
        v2.method_4951(v1);
        v2.method_4952();
        int x = (byte)Math.round(v2.method_4943() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.method_4945() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.method_4947() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        int step = vertexData.length / 4;
        for (int vert = 0; vert < 4; ++vert) {
            vertexData[vert * step + 7] = normal;
        }
    }
}

