/*
 * Decompiled with CFR 0.152.
 */
package fuzs.diagonalfences.client.model;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import fuzs.diagonalfences.DiagonalFences;
import fuzs.diagonalfences.api.world.level.block.DiagonalBlock;
import fuzs.diagonalfences.client.core.ClientAbstractions;
import fuzs.diagonalfences.client.model.QuadUtils;
import fuzs.diagonalfences.client.model.RotatedVariant;
import fuzs.diagonalfences.core.EightWayDirection;
import fuzs.diagonalfences.mixin.client.accessor.KeyValueConditionAccessor;
import fuzs.diagonalfences.mixin.client.accessor.ModelBakeryAccessor;
import fuzs.diagonalfences.mixin.client.accessor.SelectorAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_773;
import net.minecraft.class_777;
import net.minecraft.class_807;
import net.minecraft.class_813;
import net.minecraft.class_815;
import net.minecraft.class_816;
import net.minecraft.class_818;
import net.minecraft.class_819;
import org.jetbrains.annotations.Nullable;

public class MultipartAppender {
    public static void onPrepareModelBaking(class_1088 modelBakery) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        class_2378.field_11146.method_10220().filter(block -> {
            DiagonalBlock diagonalBlock;
            return block instanceof class_2354 && block instanceof DiagonalBlock && (diagonalBlock = (DiagonalBlock)block).hasProperties();
        }).map(block -> (class_2680)block.method_9595().method_11664()).forEach(state -> {
            class_1100 patt2085$temp = modelBakery.method_4726((class_2960)class_773.method_3340((class_2680)state));
            if (patt2085$temp instanceof class_816) {
                class_816 multiPart = (class_816)patt2085$temp;
                MultipartAppender.appendDiagonalSelectors(modelBakery, multiPart);
            } else {
                DiagonalFences.LOGGER.warn("Fence block '{}' is not using multipart models, diagonal fence connections will not be visible!", (Object)state.method_26204());
            }
        });
        DiagonalFences.LOGGER.info("Constructing diagonal fence block models took {}ms", (Object)stopwatch.stop().elapsed().toMillis());
    }

    public static void appendDiagonalSelectors(class_1088 modelBakery, class_816 multiPart) {
        List selectors = multiPart.method_3519();
        ArrayList newSelectors = Lists.newArrayList();
        for (class_819 selector : selectors) {
            EightWayDirection direction;
            class_818 condition;
            class_815 class_8152 = ((SelectorAccessor)selector).diagonalfences$getCondition();
            if (!(class_8152 instanceof class_818) || !Objects.equals(((KeyValueConditionAccessor)(condition = (class_818)class_8152)).diagonalfences$getValue(), "true") || (direction = EightWayDirection.byName(((KeyValueConditionAccessor)condition).diagonalfences$getKey())) == null) continue;
            EightWayDirection interDirection = direction.rotateClockwise();
            class_818 newCondition = new class_818(interDirection.method_15434(), "true");
            List variants = selector.method_3529().method_3497();
            ArrayList newVariants = Lists.newArrayList();
            for (class_813 variant : variants) {
                class_1091 location = new class_1091(variant.method_3510(), interDirection.method_15434());
                ((ModelBakeryAccessor)modelBakery).diagonalfences$callCacheAndQueueDependencies((class_2960)location, new RotatedVariant(variant, direction.toDirection()));
                newVariants.add(new class_813((class_2960)location, variant.method_3509(), variant.method_3512(), variant.method_3511()));
            }
            newSelectors.add(new class_819((class_815)newCondition, new class_807((List)newVariants)));
        }
        selectors.addAll(newSelectors);
    }

    public static class_1087 rotateMultipartSegment(@Nullable class_2680 state, class_1087 segmentModel, class_2350 armDir) {
        HashMap<class_2350, List<class_777>> quadMap = new HashMap<class_2350, List<class_777>>();
        MultipartAppender.rotateQuads(quadMap, state, segmentModel, null, armDir);
        for (class_2350 cullFace : class_2350.values()) {
            MultipartAppender.rotateQuads(quadMap, state, segmentModel, cullFace, armDir);
        }
        return ClientAbstractions.INSTANCE.createWrappedBakedModel(segmentModel, quadMap);
    }

    private static void rotateQuads(Map<class_2350, List<class_777>> quadMap, @Nullable class_2680 state, class_1087 segmentModel, class_2350 cullFace, class_2350 segmentDir) {
        List quads = segmentModel.method_4707(state, cullFace, class_5819.method_43047());
        ArrayList newQuads = Lists.newArrayList();
        for (class_777 quad : quads) {
            class_777 copy = QuadUtils.duplicateQuad(quad);
            QuadUtils.rotateQuad(copy, segmentDir);
            newQuads.add(copy);
        }
        quadMap.put(cullFace, newQuads);
    }
}

