/*
 * Decompiled with CFR 0.152.
 */
package vg.skye.e4mc_minecraft;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vg.skye.e4mc_minecraft.ChannelClosedMessage;
import vg.skye.e4mc_minecraft.ChannelOpenMessage;
import vg.skye.e4mc_minecraft.DomainAssignedMessage;
import vg.skye.e4mc_minecraft.E4mcClient;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\"\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\rH\u0016J\u0012\u0010!\u001a\u00020\u000f2\b\u0010#\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010$\u001a\u00020\u000f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lvg/skye/e4mc_minecraft/E4mcRelayHandler;", "Lorg/java_websocket/client/WebSocketClient;", "()V", "childChannels", "", "", "Lio/netty/channel/local/LocalChannel;", "eventLoopGroup", "Lio/netty/channel/nio/NioEventLoopGroup;", "gson", "Lcom/google/gson/Gson;", "messageQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljava/nio/ByteBuffer;", "alertUser", "", "domain", "", "createMessage", "Lnet/minecraft/text/Text;", "handleChannelClosed", "json", "Lcom/google/gson/JsonObject;", "handleChannelOpen", "handleDomainAssigned", "onClose", "code", "reason", "remote", "", "onError", "ex", "Ljava/lang/Exception;", "onMessage", "bytes", "message", "onOpen", "handshakedata", "Lorg/java_websocket/handshake/ServerHandshake;", "ChildHandler", "e4mc"})
public final class E4mcRelayHandler
extends WebSocketClient {
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private final Map<Integer, LocalChannel> childChannels = new LinkedHashMap();
    @NotNull
    private final Map<Integer, ArrayBlockingQueue<ByteBuffer>> messageQueue = new LinkedHashMap();
    @NotNull
    private final NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();

    public E4mcRelayHandler() {
        super(new URI(System.getProperty("vg.skye.e4mc_minecraft.ingress_uri", "wss://ingress.e4mc.link")));
    }

    public void onOpen(@Nullable ServerHandshake handshakedata) {
    }

    public void onMessage(@Nullable String message) {
        E4mcClient.LOGGER.info("WebSocket Text message: {}", (Object)message);
        JsonObject json = (JsonObject)this.gson.fromJson(message, JsonObject.class);
        if (json.has("DomainAssigned")) {
            Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
            this.handleDomainAssigned(json);
        } else if (json.has("ChannelOpen")) {
            Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
            this.handleChannelOpen(json);
        } else if (json.has("ChannelClosed")) {
            Intrinsics.checkNotNullExpressionValue((Object)json, (String)"json");
            this.handleChannelClosed(json);
        } else {
            E4mcClient.LOGGER.warn("Unhandled WebSocket Text message: " + message);
        }
    }

    public void onMessage(@NotNull ByteBuffer bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        byte channelId = bytes.get();
        ByteBuffer rest = bytes.slice();
        LocalChannel channel = this.childChannels.get(channelId);
        if (channel == null) {
            if (this.messageQueue.get(channelId) == null) {
                E4mcClient.LOGGER.info("Creating queue for channel: {}", (Object)channelId);
                this.messageQueue.put(Integer.valueOf(channelId), new ArrayBlockingQueue(8));
            }
            ArrayBlockingQueue<ByteBuffer> arrayBlockingQueue = this.messageQueue.get(channelId);
            Intrinsics.checkNotNull(arrayBlockingQueue);
            arrayBlockingQueue.add(rest);
        } else {
            ByteBuf byteBuf = channel.alloc().buffer(rest.remaining());
            byteBuf.writeBytes(rest);
            channel.writeAndFlush((Object)byteBuf).sync();
        }
    }

    public void onClose(int code, @Nullable String reason, boolean remote) {
        Map<Integer, LocalChannel> $this$forEach$iv = this.childChannels;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Integer, LocalChannel>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, LocalChannel> element$iv;
            Map.Entry<Integer, LocalChannel> entry = element$iv = iterator.next();
            boolean bl = false;
            LocalChannel channel = entry.getValue();
            channel.close();
        }
    }

    public void onError(@NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        ex.printStackTrace();
        boolean isClient = FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT);
        if (isClient) {
            try {
                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"text.e4mc_minecraft.error"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final void handleDomainAssigned(JsonObject json) {
        DomainAssignedMessage msg = (DomainAssignedMessage)this.gson.fromJson((JsonElement)json, DomainAssignedMessage.class);
        boolean isClient = FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.CLIENT);
        boolean isServer = FabricLoader.getInstance().getEnvironmentType().equals((Object)EnvType.SERVER);
        if (isServer) {
            E4mcClient.LOGGER.warn("e4mc running on Dedicated Server; This works, but isn't recommended as e4mc is designed for short-lived LAN servers");
        }
        E4mcClient.LOGGER.info("Domain assigned: " + msg.getDomainAssigned());
        if (isClient) {
            this.alertUser(msg.getDomainAssigned());
        }
    }

    private final void alertUser(String domain) {
        try {
            class_310.method_1551().field_1705.method_1743().method_1812(this.createMessage(domain));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final class_2561 createMessage(String domain) {
        Object[] objectArray = new Object[]{class_2561.method_43470((String)domain).method_27694(arg_0 -> E4mcRelayHandler.createMessage$lambda-1(domain, arg_0))};
        class_5250 class_52502 = class_2561.method_43469((String)"text.e4mc_minecraft.domainAssigned", (Object[])objectArray).method_10852((class_2561)class_2561.method_43471((String)"text.e4mc_minecraft.clickToStop").method_27694(E4mcRelayHandler::createMessage$lambda-2));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"translatable(\n          \u2026)\n            }\n        )");
        return (class_2561)class_52502;
    }

    private final void handleChannelOpen(JsonObject json) {
        ChannelOpenMessage msg = (ChannelOpenMessage)this.gson.fromJson((JsonElement)json, ChannelOpenMessage.class);
        Number channelId = (Number)msg.getChannelOpen().get(0);
        String clientInfo = (String)msg.getChannelOpen().get(1);
        E4mcClient.LOGGER.info("Channel opened: channelId=" + channelId + ", clientInfo=" + clientInfo);
        String host = StringsKt.substringBeforeLast$default((String)clientInfo, (char)':', null, (int)2, null);
        int port = Integer.parseInt(StringsKt.substringAfterLast$default((String)clientInfo, (char)':', null, (int)2, null));
        InetSocketAddress addr = new InetSocketAddress(host, port);
        E4mcRelayHandler self = this;
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<LocalChannel>(self, addr, channelId){
            final /* synthetic */ E4mcRelayHandler $self;
            final /* synthetic */ InetSocketAddress $addr;
            final /* synthetic */ Number $channelId;
            {
                this.$self = $self;
                this.$addr = $addr;
                this.$channelId = $channelId;
            }

            protected void initChannel(@NotNull LocalChannel ch) throws Exception {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{(ChannelHandler)new ChildHandler(this.$self, this.$addr, this.$channelId.intValue())};
                ch.pipeline().addLast(channelHandlerArray);
            }
        })).group((EventLoopGroup)this.eventLoopGroup)).connect((SocketAddress)new LocalAddress("e4mc-relay"));
    }

    private final void handleChannelClosed(JsonObject json) {
        block0: {
            ChannelClosedMessage msg = (ChannelClosedMessage)this.gson.fromJson((JsonElement)json, ChannelClosedMessage.class);
            int channelId = msg.getChannelClosed().intValue();
            E4mcClient.LOGGER.info("Closing channel as requested: {}", (Object)channelId);
            LocalChannel localChannel = this.childChannels.remove(channelId);
            if (localChannel == null) break block0;
            LocalChannel it = localChannel;
            boolean bl = false;
            ((ChildHandler)it.pipeline().get(ChildHandler.class)).setClosedFromServer(true);
            it.close();
            E4mcClient.LOGGER.info("Channel closed: channelId=" + channelId);
        }
    }

    private static final class_2583 createMessage$lambda-1(String $domain, class_2583 it) {
        Intrinsics.checkNotNullParameter((Object)$domain, (String)"$domain");
        return it.method_10958(new class_2558(class_2558.class_2559.field_21462, $domain)).method_10977(class_124.field_1060).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.copy.click")));
    }

    private static final class_2583 createMessage$lambda-2(class_2583 it) {
        return it.method_10958(new class_2558(class_2558.class_2559.field_11750, "/e4mc stop")).method_10977(class_124.field_1080);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lvg/skye/e4mc_minecraft/E4mcRelayHandler$ChildHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/buffer/ByteBuf;", "parent", "Lvg/skye/e4mc_minecraft/E4mcRelayHandler;", "address", "Ljava/net/InetSocketAddress;", "channelId", "", "(Lvg/skye/e4mc_minecraft/E4mcRelayHandler;Ljava/net/InetSocketAddress;I)V", "isClosedFromServer", "", "()Z", "setClosedFromServer", "(Z)V", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelInactive", "channelRead0", "msg", "e4mc"})
    public static final class ChildHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        @NotNull
        private final E4mcRelayHandler parent;
        @NotNull
        private final InetSocketAddress address;
        private final int channelId;
        private boolean isClosedFromServer;

        public ChildHandler(@NotNull E4mcRelayHandler parent, @NotNull InetSocketAddress address, int channelId) {
            Intrinsics.checkNotNullParameter((Object)((Object)parent), (String)"parent");
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            this.parent = parent;
            this.address = address;
            this.channelId = channelId;
        }

        public final boolean isClosedFromServer() {
            return this.isClosedFromServer;
        }

        public final void setClosedFromServer(boolean bl) {
            this.isClosedFromServer = bl;
        }

        public void channelActive(@NotNull ChannelHandlerContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            if (this.parent.messageQueue.get(this.channelId) != null) {
                Object v = this.parent.messageQueue.get(this.channelId);
                Intrinsics.checkNotNull(v);
                Iterable $this$forEach$iv = (Iterable)v;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ByteBuffer buf = (ByteBuffer)element$iv;
                    boolean bl = false;
                    ChildHandler $this$channelActive_u24lambda_u2d1_u24lambda_u2d0 = this;
                    boolean bl2 = false;
                    E4mcClient.LOGGER.info("Handling queued buffer: {}", (Object)buf);
                    ByteBuf byteBuf = ctx.alloc().buffer(buf.remaining());
                    byteBuf.writeBytes(buf);
                    ctx.writeAndFlush((Object)byteBuf);
                }
                this.parent.messageQueue.remove(this.channelId);
            }
            Map map = this.parent.childChannels;
            Integer n = this.channelId;
            Channel channel = ctx.channel();
            if (channel == null) {
                throw new NullPointerException("null cannot be cast to non-null type io.netty.channel.local.LocalChannel");
            }
            LocalChannel localChannel = (LocalChannel)channel;
            map.put(n, localChannel);
        }

        protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf msg) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            byte[] buf = new byte[msg.readableBytes() + 1];
            buf[0] = (byte)this.channelId;
            msg.readBytes(buf, 1, msg.readableBytes());
            this.parent.send(buf);
        }

        public void channelInactive(@NotNull ChannelHandlerContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            E4mcClient.LOGGER.info("Channel closed: {}", (Object)this.channelId);
            if (!this.isClosedFromServer) {
                this.parent.send(this.parent.gson.toJson((Object)new ChannelClosedMessage(this.channelId)));
            }
            this.parent.childChannels.remove(this.channelId);
        }
    }
}

