/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.Queue;
import net.minecraft.class_1041;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4398;
import net.minecraft.class_442;
import net.minecraft.class_4439;
import net.minecraft.class_4587;
import net.minecraft.class_4877;
import net.minecraft.class_638;
import net.minecraft.class_640;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.patreon.GuiUpdateAll;
import xaero.map.patreon.Patreon;

public class Events {
    private class_4877 latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    public static boolean stopRecursion = false;

    public class_437 handleGuiOpen(class_437 gui) {
        if (gui instanceof class_4398) {
            try {
                class_4439 realmsTask;
                class_4877 realm;
                class_4398 realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = Misc.getFieldReflection(class_4398.class, "field_19919", "Lnet/minecraft/class_4358;");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = Misc.getFieldReflection(class_4439.class, "field_20224", "Lnet/minecraft/class_4877;");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (class_4398)gui)) instanceof class_4439 && (realm = (class_4877)this.realmsTaskServerField.get(realmsTask = (class_4439)task)) != null && (this.latestRealm == null || realm.field_22599 != this.latestRealm.field_22599)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
        return gui;
    }

    public void handleRenderTick(boolean start) {
        WorldMapSession worldmapSession;
        if (start) {
            WorldMap.INSTANCE.tryLoadLater();
        }
        class_310 mc = class_310.method_1551();
        if (!start) {
            WorldMap.glObjectDeleter.work();
        }
        if (mc.field_1724 != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (!start) {
                mapProcessor.onRenderProcess(mc);
                mc.field_1743 = false;
                mapProcessor.resetRenderStartTime();
                Queue<Runnable> minecraftScheduledTasks = mapProcessor.getMinecraftScheduledTasks();
                Runnable task = mapProcessor.getRenderStartTimeUpdater();
                Runnable[] currentTasks = minecraftScheduledTasks.toArray(new Runnable[0]);
                minecraftScheduledTasks.clear();
                minecraftScheduledTasks.add(task);
                for (Runnable t : currentTasks) {
                    minecraftScheduledTasks.add(t);
                }
            } else {
                if (!SupportMods.vivecraft && Misc.screenShouldSkipWorldRender(mc.field_1755, true)) {
                    RenderSystem.enableDepthTest();
                    stopRecursion = true;
                    mc.field_1687.method_38534();
                    mc.field_1687.method_2935().method_12130().method_15516(Integer.MAX_VALUE, mc.field_1687.method_38743(), true);
                    mc.field_1773.method_3192(1.0f, class_156.method_648(), false);
                    stopRecursion = false;
                    mc.field_1743 = true;
                }
                if (mapProcessor != null) {
                    mapProcessor.setMainValues();
                }
            }
        }
    }

    public void handleDrawScreen(class_437 gui) {
        if (Patreon.needsNotification() && gui instanceof class_442 && (!SupportMods.minimap() || SupportMods.xaeroMinimap.compatibilityVersion < 1)) {
            class_310.method_1551().method_1507((class_437)new GuiUpdateAll());
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    public void handlePlayerSetSpawnEvent(class_2338 spawn, class_1937 world) {
        WorldMapSession worldmapSession;
        if (world instanceof class_638 && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.updateWorldSpawn(spawn, (class_638)world);
        }
    }

    public void handleWorldUnload(class_1937 world) {
        WorldMapSession worldmapSession;
        if (class_310.method_1551().field_1724 != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (world == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (world instanceof class_3218) {
            class_3218 sw = (class_3218)world;
            WorldDataHandler.onServerWorldUnload(sw);
        }
    }

    public class_4877 getLatestRealm() {
        return this.latestRealm;
    }

    public void handleRenderCrosshairs(class_4587 matrixStack) {
        String crosshairMessage;
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        MapProcessor mapProcessor = worldmapSession == null ? null : worldmapSession.getMapProcessor();
        String string = crosshairMessage = mapProcessor == null ? null : mapProcessor.getCrosshairMessage();
        if (crosshairMessage != null) {
            int messageWidth = class_310.method_1551().field_1772.method_1727(crosshairMessage);
            RenderSystem.disableBlend();
            class_1041 window = class_310.method_1551().method_22683();
            class_310.method_1551().field_1772.method_1720(matrixStack, crosshairMessage, (float)(window.method_4486() / 2 - messageWidth / 2), (float)(window.method_4502() / 2 + 60), -1);
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
        }
    }

    public boolean handleClientPlayerChatReceivedEvent(class_2556 chatType, class_2561 component, class_640 playerInfo) {
        if (component == null) {
            return false;
        }
        return this.handleChatMessage(playerInfo == null ? null : playerInfo.method_2966().getName(), component);
    }

    public boolean handleClientSystemChatReceivedEvent(class_2561 component) {
        WorldMapSession worldmapSession;
        if (component == null) {
            return false;
        }
        String textString = component.getString();
        if (textString.contains("\u00a7r\u00a7e\u00a7s\u00a7e\u00a7t\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlay(false);
        }
        if (textString.contains("\u00a7x\u00a7a\u00a7e\u00a7r\u00a7o\u00a7w\u00a7m\u00a7n\u00a7e\u00a7t\u00a7h\u00a7e\u00a7r\u00a7i\u00a7s\u00a7f\u00a7a\u00a7i\u00a7r")) {
            worldmapSession = WorldMapSession.getCurrentSession();
            worldmapSession.getMapProcessor().setConsideringNetherFairPlay(true);
        }
        return this.handleChatMessage(class_1074.method_4662((String)"gui.xaero_waypoint_server_shared", (Object[])new Object[0]), component);
    }

    private boolean handleChatMessage(String playerName, class_2561 text) {
        return false;
    }
}

