/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.structures.features;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1160;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_7151;
import org.betterx.bclib.api.v2.levelgen.structures.StructureWorld;
import org.betterx.bclib.sdf.PosInfo;
import org.betterx.bclib.sdf.SDF;
import org.betterx.bclib.sdf.operator.SDFRotation;
import org.betterx.bclib.sdf.operator.SDFTranslate;
import org.betterx.bclib.sdf.operator.SDFUnion;
import org.betterx.bclib.sdf.primitive.SDFCappedCone;
import org.betterx.bclib.sdf.primitive.SDFPrimitive;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.betterend.registry.EndStructures;
import org.betterx.betterend.world.structures.features.SDFStructureFeature;
import org.betterx.betterend.world.structures.piece.VoxelPiece;

public class GiantIceStarStructure
extends SDFStructureFeature {
    private static final float minSize = 20.0f;
    private static final float maxSize = 35.0f;
    private static final int minCount = 25;
    private static final int maxCount = 40;

    public GiantIceStarStructure(class_3195.class_7302 s) {
        super(s);
    }

    public class_7151<GiantIceStarStructure> method_41618() {
        return EndStructures.GIANT_ICE_STAR.structureType;
    }

    protected static SDF getSDF(class_2338 pos, class_5819 random) {
        float size = MHelper.randRange((float)20.0f, (float)35.0f, (class_5819)random);
        int count = MHelper.randRange((int)25, (int)40, (class_5819)random);
        List<class_1160> points = GiantIceStarStructure.getFibonacciPoints(count);
        SDFPrimitive sdf = null;
        SDFPrimitive spike = new SDFCappedCone().setRadius1(3.0f + (size - 5.0f) * 0.2f).setRadius2(0.0f).setHeight(size).setBlock(EndBlocks.DENSE_SNOW);
        spike = new SDFTranslate().setTranslate(0.0f, size - 0.5f, 0.0f).setSource((SDF)spike);
        for (class_1160 point : points) {
            SDFPrimitive rotated = spike;
            float angle = MHelper.angle((class_1160)class_1160.field_20705, (class_1160)(point = MHelper.normalize((class_1160)point)));
            if (angle > 0.01f && angle < 3.14f) {
                class_1160 axis = MHelper.normalize((class_1160)MHelper.cross((class_1160)class_1160.field_20705, (class_1160)point));
                rotated = new SDFRotation().setRotation(axis, angle).setSource((SDF)spike);
            } else if (angle > 1.0f) {
                rotated = new SDFRotation().setRotation(class_1160.field_20705, (float)Math.PI).setSource((SDF)spike);
            }
            sdf = sdf == null ? rotated : new SDFUnion().setSourceA((SDF)sdf).setSourceB((SDF)rotated);
        }
        float ancientRadius = size * 0.7f;
        float denseRadius = size * 0.9f;
        float iceRadius = size < 7.0f ? size * 5.0f : size * 1.3f;
        float randScale = size * 0.3f;
        class_2338 center = pos;
        class_2680 ice = EndBlocks.EMERALD_ICE.method_9564();
        class_2680 dense = EndBlocks.DENSE_EMERALD_ICE.method_9564();
        class_2680 ancient = EndBlocks.ANCIENT_EMERALD_ICE.method_9564();
        SDFPrimitive sdfCopy = sdf;
        return sdf.addPostProcess(arg_0 -> GiantIceStarStructure.lambda$getSDF$0(center, (SDF)sdfCopy, random, randScale, ancientRadius, ancient, denseRadius, dense, iceRadius, ice, arg_0));
    }

    private static List<class_1160> getFibonacciPoints(int count) {
        float max = count - 1;
        ArrayList<class_1160> result = new ArrayList<class_1160>(count);
        for (int i = 0; i < count; ++i) {
            float y = 1.0f - (float)i / max * 2.0f;
            float radius = (float)Math.sqrt(1.0f - y * y);
            float theta = MHelper.PHI * (float)i;
            float x = (float)Math.cos(theta) * radius;
            float z = (float)Math.sin(theta) * radius;
            result.add(new class_1160(x, y, z));
        }
        return result;
    }

    @Override
    public void generatePieces(class_6626 structurePiecesBuilder, class_3195.class_7149 context) {
        class_2919 random = context.comp_566();
        class_1923 chunkPos = context.comp_568();
        class_2794 chunkGenerator = context.comp_562();
        class_5539 levelHeightAccessor = context.comp_569();
        int x = chunkPos.method_33939(MHelper.randRange((int)4, (int)12, (class_5819)random));
        int z = chunkPos.method_33941(MHelper.randRange((int)4, (int)12, (class_5819)random));
        class_2338 start = new class_2338(x, MHelper.randRange((int)32, (int)128, (class_5819)random), z);
        VoxelPiece piece = new VoxelPiece(arg_0 -> GiantIceStarStructure.lambda$generatePieces$1(start, (class_5819)random, arg_0), random.method_43054());
        structurePiecesBuilder.method_35462((class_3443)piece);
    }

    private static /* synthetic */ void lambda$generatePieces$1(class_2338 start, class_5819 random, StructureWorld world) {
        GiantIceStarStructure.getSDF(start, random).fillRecursive(world, start);
    }

    private static /* synthetic */ class_2680 lambda$getSDF$0(class_2338 center, SDF sdfCopy, class_5819 random, float randScale, float ancientRadius, class_2680 ancient, float denseRadius, class_2680 dense, float iceRadius, class_2680 ice, PosInfo info) {
        float pz;
        float py;
        class_2338 bpos = info.getPos();
        float px = bpos.method_10263() - center.method_10263();
        float distance = MHelper.length((float)px, (float)(py = (float)(bpos.method_10264() - center.method_10264())), (float)(pz = (float)(bpos.method_10260() - center.method_10260()))) + sdfCopy.getDistance(px, py, pz) * 0.4f + random.method_43057() * randScale;
        if (distance < ancientRadius) {
            return ancient;
        }
        if (distance < denseRadius) {
            return dense;
        }
        if (distance < iceRadius) {
            return ice;
        }
        return info.getState();
    }
}

