/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.biome.cave;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function15;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_5819;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7243;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeature;
import org.betterx.bclib.api.v3.levelgen.features.BCLFeatureBuilder;
import org.betterx.bclib.api.v3.levelgen.features.BCLPlacedFeatureBuilder;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.betterx.bclib.util.WeightedList;
import org.betterx.betterend.BetterEnd;
import org.betterx.betterend.registry.EndBiomes;
import org.betterx.betterend.registry.EndFeatures;
import org.betterx.betterend.registry.EndSounds;
import org.betterx.betterend.world.biome.EndBiome;
import org.betterx.betterend.world.features.terrain.caves.CaveChunkPopulatorFeatureConfig;

public class EndCaveBiome
extends EndBiome {
    public static final Codec<EndCaveBiome> CODEC = EndCaveBiome.simpleCaveBiomeCodec(EndCaveBiome::new);
    public static final class_7243<EndCaveBiome> KEY_CODEC = class_7243.method_42115(CODEC);
    private final WeightedList<class_6880<? extends class_2975<?, ?>>> floorFeatures = new WeightedList();
    private final WeightedList<class_6880<? extends class_2975<?, ?>>> ceilFeatures = new WeightedList();

    public static <T extends EndCaveBiome> Codec<T> simpleCaveBiomeCodec(Function15<Float, Float, Float, Integer, Boolean, Optional<class_2960>, class_2960, Optional<List<class_6544.class_4762>>, Optional<class_2960>, Optional<WeightedList<class_2960>>, Optional<String>, Boolean, SurfaceMaterialProvider, WeightedList<class_6880<class_2975<?, ?>>>, WeightedList<class_6880<class_2975<?, ?>>>, T> builder) {
        return RecordCodecBuilder.create((T instance) -> EndCaveBiome.codecWithSettings((RecordCodecBuilder.Instance)instance, (RecordCodecBuilder)Codec.BOOL.fieldOf("has_caves").orElse((Object)true).forGetter(EndBiome::hasCaves), (RecordCodecBuilder)SurfaceMaterialProvider.CODEC.fieldOf("surface").orElse((Object)new EndBiome.DefaultSurfaceMaterialProvider()).forGetter(o -> o.surfMatProv), (RecordCodecBuilder)WeightedList.listCodec((Codec)class_2975.field_24833, (String)"configured_features", (String)"configured_feature").fieldOf("floor_features").forGetter(o -> o.floorFeatures), (RecordCodecBuilder)WeightedList.listCodec((Codec)class_2975.field_24833, (String)"configured_features", (String)"configured_feature").fieldOf("ceil_features").forGetter(o -> o.ceilFeatures)).apply((Applicative)instance, builder));
    }

    @Override
    public class_7243<? extends BCLBiome> codec() {
        return KEY_CODEC;
    }

    protected EndCaveBiome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<class_2960> edge, class_2960 biomeID, Optional<List<class_6544.class_4762>> parameterPoints, Optional<class_2960> biomeParent, Optional<WeightedList<class_2960>> subbiomes, Optional<String> intendedType, boolean hasCaves, SurfaceMaterialProvider surface, WeightedList<class_6880<class_2975<?, ?>>> floorFeatures, WeightedList<class_6880<class_2975<?, ?>>> ceilFeatures) {
        super(terrainHeight, fogDensity, genChance, edgeSize, vertical, edge, biomeID, parameterPoints, biomeParent, subbiomes, intendedType, hasCaves, surface);
        this.floorFeatures.addAll(floorFeatures);
        this.ceilFeatures.addAll(ceilFeatures);
    }

    public EndCaveBiome(class_2960 biomeID, class_1959 biome, BCLBiomeSettings settings) {
        super(biomeID, biome, settings);
    }

    public void addFloorFeature(class_6880<? extends class_2975<?, ?>> feature, float weight) {
        this.floorFeatures.add(feature, weight);
    }

    public void addCeilFeature(class_6880<? extends class_2975<?, ?>> feature, float weight) {
        this.ceilFeatures.add(feature, weight);
    }

    public class_6880<? extends class_2975<?, ?>> getFloorFeature(class_5819 random) {
        return this.floorFeatures.isEmpty() ? null : (class_6880)this.floorFeatures.get(random);
    }

    public class_6880<? extends class_2975<?, ?>> getCeilFeature(class_5819 random) {
        return this.ceilFeatures.isEmpty() ? null : (class_6880)this.ceilFeatures.get(random);
    }

    public float getFloorDensity() {
        return 0.0f;
    }

    public float getCeilDensity() {
        return 0.0f;
    }

    public class_2680 getCeil(class_2338 pos) {
        return null;
    }

    public class_2680 getWall(class_2338 pos) {
        return null;
    }

    public static EndCaveBiome create(EndBiome.Config biomeConfig) {
        return (EndCaveBiome)EndBiome.create(biomeConfig);
    }

    public static abstract class Config
    extends EndBiome.Config {
        protected Config(String name) {
            super(name);
        }

        @Override
        protected void addCustomBuildData(BCLBiomeBuilder builder) {
            BCLFeature feature = ((BCLPlacedFeatureBuilder)((BCLPlacedFeatureBuilder)BCLFeatureBuilder.start((class_2960)BetterEnd.makeID(this.ID.method_12832() + "_cave_populator"), (class_3031)EndFeatures.CAVE_CHUNK_POPULATOR).configuration((class_3037)new CaveChunkPopulatorFeatureConfig(this.ID)).buildAndRegister().place().decoration(class_2893.class_2895.field_13177).count(1)).onlyInBiome()).buildAndRegister();
            builder.feature(feature).intendedType(EndBiomes.END_CAVE).music(EndSounds.MUSIC_CAVES).loop(EndSounds.AMBIENT_CAVES);
        }

        @Override
        protected boolean hasCaves() {
            return false;
        }

        @Override
        protected boolean hasReturnGateway() {
            return false;
        }

        @Override
        public BCLBiomeBuilder.BiomeSupplier<EndBiome> getSupplier() {
            return EndCaveBiome::new;
        }
    }
}

