/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.integration.rei;

import com.google.common.collect.Lists;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.betterx.betterend.integration.rei.REIAlloyingFuelDisplay;
import org.betterx.betterend.integration.rei.REIPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class REIAlloyingFuelCategory
implements DisplayCategory<REIAlloyingFuelDisplay> {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");

    @NotNull
    public CategoryIdentifier getCategoryIdentifier() {
        return REIPlugin.ALLOYING_FUEL;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)"category.rei.fuel");
    }

    public int getDisplayHeight() {
        return 49;
    }

    @NotNull
    public EntryStack getIcon() {
        return EntryStacks.of((class_1935)class_1802.field_8187);
    }

    public List<Widget> setupDisplay(REIAlloyingFuelDisplay recipeDisplay, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 17);
        String burnTime = DECIMAL_FORMAT.format(recipeDisplay.getFuelTime());
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createLabel((Point)new Point(bounds.x + 26, bounds.getMaxY() - 15), (class_2561)class_2561.method_43469((String)"category.rei.fuel.time", (Object[])new Object[]{burnTime})).color(-12566464, -4473925).noShadow().leftAligned());
        widgets.add(Widgets.createBurningFire((Point)new Point(bounds.x + 6, startPoint.y + 1)).animationDurationTicks((double)recipeDisplay.getFuelTime()));
        widgets.add(Widgets.createSlot((Point)new Point(bounds.x + 6, startPoint.y + 18)).entries((Collection)recipeDisplay.getInputEntries().get(0)).markInput());
        return widgets;
    }

    public DisplayRenderer getDisplayRenderer(REIAlloyingFuelDisplay recipe) {
        final Slot slot = Widgets.createSlot((Point)new Point(0, 0)).entries((Collection)recipe.getInputEntries().get(0)).disableBackground().disableHighlight();
        final String burnItems = DECIMAL_FORMAT.format((double)recipe.getFuelTime() / 200.0);
        return new DisplayRenderer(){
            private final class_2561 text;
            {
                this.text = class_2561.method_43469((String)"category.rei.fuel.time_short.items", (Object[])new Object[]{burnItems});
            }

            public int getHeight() {
                return 22;
            }

            @Nullable
            public Tooltip getTooltip(TooltipContext ctx) {
                if (slot.containsMouse(ctx.getPoint())) {
                    return slot.getCurrentTooltip(ctx);
                }
                return null;
            }

            public void render(class_4587 matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                slot.setZ(this.getZ() + 50);
                slot.getBounds().setLocation(bounds.x + 4, bounds.y + 2);
                slot.method_25394(matrices, mouseX, mouseY, delta);
                class_310.method_1551().field_1772.method_27517(matrices, this.text.method_30937(), (float)(bounds.x + 25), (float)(bounds.y + 8), -1);
            }
        };
    }
}

